# HL7-AcquisitionModality值集 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HL7-AcquisitionModality值集**

## ValueSet: HL7-AcquisitionModality值集 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/ValueSet/dicom-cid-29-AcquisitionModality | *Version*:1.1.0 |
| Active as of 2024-03-31 | *Computable Name*:AcquisitionModality |
| **Copyright/Legal**: © 2024 NEMA | |

 
原值集因總會工具問題無法正常顯示，故先自建值集。 

 **References** 

* [DICOM影像-ImagingStudy TWPAS](StructureDefinition-ImagingStudy-twpas.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "dicom-cid-29-AcquisitionModality",
  "url" : "https://nhicore.nhi.gov.tw/pas/ValueSet/dicom-cid-29-AcquisitionModality",
  "version" : "1.1.0",
  "name" : "AcquisitionModality",
  "title" : "HL7-AcquisitionModality值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-03-31",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "原值集因總會工具問題無法正常顯示，故先自建值集。",
  "copyright" : "© 2024 NEMA",
  "compose" : {
    "include" : [
      {
        "system" : "http://dicom.nema.org/resources/ontology/DCM",
        "concept" : [
          {
            "code" : "BMD",
            "display" : "Bone Mineral Densitometry"
          },
          {
            "code" : "EOG",
            "display" : "Electrooculography"
          },
          {
            "code" : "SM",
            "display" : "Slide Microscopy"
          },
          {
            "code" : "OP",
            "display" : "Ophthalmic Photography"
          },
          {
            "code" : "ECG",
            "display" : "Electrocardiography"
          },
          {
            "code" : "GM",
            "display" : "General Microscopy"
          },
          {
            "code" : "XA",
            "display" : "X-Ray Angiography"
          },
          {
            "code" : "XC",
            "display" : "External-camera Photography"
          },
          {
            "code" : "DMS",
            "display" : "Dermoscopy"
          },
          {
            "code" : "IVUS",
            "display" : "Intravascular Ultrasound"
          },
          {
            "code" : "CR",
            "display" : "Computed Radiography"
          },
          {
            "code" : "CT",
            "display" : "Computed Tomography"
          },
          {
            "code" : "OSS",
            "display" : "Optical Surface Scanner"
          },
          {
            "code" : "TG",
            "display" : "Thermography"
          },
          {
            "code" : "LEN",
            "display" : "Lensometry"
          },
          {
            "code" : "OPTENF",
            "display" : "Ophthalmic Tomography En Face"
          },
          {
            "code" : "HD",
            "display" : "Hemodynamic Waveform"
          },
          {
            "code" : "OCT",
            "display" : "Optical Coherence Tomography"
          },
          {
            "code" : "BDUS",
            "display" : "Ultrasound Bone Densitometry"
          },
          {
            "code" : "DG",
            "display" : "Diaphanography"
          },
          {
            "code" : "PT",
            "display" : "Positron emission tomography"
          },
          {
            "code" : "EPS",
            "display" : "Cardiac Electrophysiology"
          },
          {
            "code" : "LS",
            "display" : "Laser surface scan"
          },
          {
            "code" : "PX",
            "display" : "Panoramic X-Ray"
          },
          {
            "code" : "OPM",
            "display" : "Ophthalmic Mapping"
          },
          {
            "code" : "OPTBSV",
            "display" : "Ophthalmic Tomography B-scan Volume Analysis"
          },
          {
            "code" : "OPV",
            "display" : "Ophthalmic Visual Field"
          },
          {
            "code" : "DX",
            "display" : "Digital Radiography"
          },
          {
            "code" : "OPT",
            "display" : "Ophthalmic Tomography"
          },
          {
            "code" : "MG",
            "display" : "Mammography"
          },
          {
            "code" : "US",
            "display" : "Ultrasound"
          },
          {
            "code" : "EMG",
            "display" : "Electromyography"
          },
          {
            "code" : "IVOCT",
            "display" : "Intravascular Optical Coherence Tomography"
          },
          {
            "code" : "MR",
            "display" : "Magnetic Resonance"
          },
          {
            "code" : "IO",
            "display" : "Intra-oral Radiography"
          },
          {
            "code" : "EEG",
            "display" : "Electroencephalography"
          },
          {
            "code" : "RTIMAGE",
            "display" : "Radiotherapy Image"
          },
          {
            "code" : "VA",
            "display" : "Visual Acuity"
          },
          {
            "code" : "RESP",
            "display" : "Respiratory Waveform"
          },
          {
            "code" : "ES",
            "display" : "Endoscopy"
          },
          {
            "code" : "AR",
            "display" : "Autorefraction"
          },
          {
            "code" : "POS",
            "display" : "Position Sensor"
          },
          {
            "code" : "RG",
            "display" : "Radiographic imaging"
          },
          {
            "code" : "RF",
            "display" : "Radiofluoroscopy"
          },
          {
            "code" : "KER",
            "display" : "Keratometry"
          },
          {
            "code" : "OAM",
            "display" : "Ophthalmic Axial Measurements"
          },
          {
            "code" : "NM",
            "display" : "Nuclear Medicine"
          },
          {
            "code" : "BI",
            "display" : "Biomagnetic Imaging"
          },
          {
            "code" : "SRF",
            "display" : "Subjective Refraction"
          }
        ]
      }
    ]
  }
}

```
