# 醫事機構-Organization TWPAS - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **醫事機構-Organization TWPAS**

## Resource Profile: 醫事機構-Organization TWPAS 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/Organization-twpas | *Version*:1.1.0 |
| Active as of 2025-12-17 | *Computable Name*:OrganizationTWPAS |

 
此醫事機構-Organization TWPAS Profile說明本IG如何進一步定義臺灣核心-機構(TW Core Organization) Profile以呈現事前審查之醫事機構基本資料 

**Usages:**

* Use this Profile: [免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md) and [癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md)
* Refer to this Profile: [免疫製劑事前審查-Claim Immunologic Aagent TWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md), [癌藥事前審查-Claim TWPAS](StructureDefinition-Claim-twpas.md) and [門診病歷-Encounter OPD TWPAS](StructureDefinition-Encounter-opd-twpas.md)
* Examples for this Profile: [臺北市立聯合醫院](Organization-org-hosp-example.md)
* CapabilityStatements using this Profile: [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) and [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/Organization-twpas)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Organization-twpas.csv), [Excel](StructureDefinition-Organization-twpas.xlsx), [Schematron](StructureDefinition-Organization-twpas.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Organization-twpas",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Organization-twpas",
  "version" : "1.1.0",
  "name" : "OrganizationTWPAS",
  "title" : "醫事機構-Organization TWPAS",
  "status" : "active",
  "date" : "2025-12-17T10:01:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此醫事機構-Organization TWPAS Profile說明本IG如何進一步定義臺灣核心-機構(TW Core Organization) Profile以呈現事前審查之醫事機構基本資料",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/emr/StructureDefinition/TWCoreOrganization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization.meta",
        "path" : "Organization.meta",
        "min" : 1
      },
      {
        "id" : "Organization.meta.profile",
        "path" : "Organization.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Organization-twpas"
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "short" : "醫事機構代碼",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier.system",
        "path" : "Organization.identifier.system",
        "min" : 1,
        "patternUri" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/organization-identifier-tw",
        "example" : [
          {
            "label" : "General",
            "valueUri" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/organization-identifier-tw"
          }
        ]
      },
      {
        "id" : "Organization.identifier.value",
        "path" : "Organization.identifier.value",
        "min" : 1,
        "example" : [
          {
            "label" : "General",
            "valueString" : "0101090517"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/pas/ValueSet/nhi-organization"
        }
      }
    ]
  }
}

```
