# 事前審查品項-MedicationRequest Apply TWPAS - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **事前審查品項-MedicationRequest Apply TWPAS**

## Resource Profile: 事前審查品項-MedicationRequest Apply TWPAS 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/MedicationRequest-apply-twpas | *Version*:1.1.0 |
| Active as of 2025-12-17 | *Computable Name*:MedicationRequestApplyTWPAS |

 
此事前審查品項-MedicationRequest Apply TWPAS Profile說明本IG如何進一步定義臺灣核心-藥品請求(TW Core MedicationRequest) Profile以呈現事前審查中申請項目之事前審查品項 

**Usages:**

* Use this Profile: [免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md) and [癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md)
* Refer to this Profile: [RequestedService](StructureDefinition-extension-requestedService.md)
* Examples for this Profile: [MedicationRequest/medReq-apply-2](MedicationRequest-medReq-apply-2.md) and [MedicationRequest/medReq-apply](MedicationRequest-medReq-apply.md)
* CapabilityStatements using this Profile: [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) and [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/MedicationRequest-apply-twpas)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MedicationRequest-apply-twpas.csv), [Excel](StructureDefinition-MedicationRequest-apply-twpas.xlsx), [Schematron](StructureDefinition-MedicationRequest-apply-twpas.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicationRequest-apply-twpas",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/MedicationRequest-apply-twpas",
  "version" : "1.1.0",
  "name" : "MedicationRequestApplyTWPAS",
  "title" : "事前審查品項-MedicationRequest Apply TWPAS",
  "status" : "active",
  "date" : "2025-12-17T10:01:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此事前審查品項-MedicationRequest Apply TWPAS Profile說明本IG如何進一步定義臺灣核心-藥品請求(TW Core MedicationRequest) Profile以呈現事前審查中申請項目之事前審查品項",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationRequest",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationRequest.meta",
        "path" : "MedicationRequest.meta",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.meta.profile",
        "path" : "MedicationRequest.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/MedicationRequest-apply-twpas"
      },
      {
        "id" : "MedicationRequest.status",
        "path" : "MedicationRequest.status",
        "patternCode" : "on-hold"
      },
      {
        "id" : "MedicationRequest.intent",
        "path" : "MedicationRequest.intent",
        "patternCode" : "plan"
      },
      {
        "id" : "MedicationRequest.medication[x]",
        "path" : "MedicationRequest.medication[x]",
        "short" : "事前審查品項代碼，事前審查醫令代碼。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "condition" : [
          "applyReason-1",
          "applyReason-2",
          "applyReason-3",
          "applyReason-4",
          "applyReason-5",
          "applyReason-6",
          "applyReason-7",
          "applyReason-8",
          "applyReason-9",
          "applyReason-10",
          "applyReason-11",
          "applyReason-12",
          "applyReason-13"
        ],
        "binding" : {
          "strength" : "example",
          "valueSet" : "https://nhicore.nhi.gov.tw/pas/ValueSet/nhi-medication"
        }
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationReference",
        "path" : "MedicationRequest.medication[x]",
        "sliceName" : "medicationReference",
        "max" : "0",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Medication-twcore"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept",
        "path" : "MedicationRequest.medication[x]",
        "sliceName" : "medicationCodeableConcept",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "example",
          "valueSet" : "https://nhicore.nhi.gov.tw/pas/ValueSet/nhi-medication"
        }
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.coding",
        "path" : "MedicationRequest.medication[x].coding",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.coding:fda-medication-tw",
        "path" : "MedicationRequest.medication[x].coding",
        "sliceName" : "fda-medication-tw",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.coding:nhi-medication-tw",
        "path" : "MedicationRequest.medication[x].coding",
        "sliceName" : "nhi-medication-tw",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.coding:nhi-medication-ch-herb-tw",
        "path" : "MedicationRequest.medication[x].coding",
        "sliceName" : "nhi-medication-ch-herb-tw",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.coding:rxnorm-medication-us-core",
        "path" : "MedicationRequest.medication[x].coding",
        "sliceName" : "rxnorm-medication-us-core",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.coding:atc-medication-code",
        "path" : "MedicationRequest.medication[x].coding",
        "sliceName" : "atc-medication-code",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.coding:snomedct-medication-codes",
        "path" : "MedicationRequest.medication[x].coding",
        "sliceName" : "snomedct-medication-codes",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.coding:nhi-medication",
        "path" : "MedicationRequest.medication[x].coding",
        "sliceName" : "nhi-medication",
        "short" : "事前審查品項代碼。",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/pas/ValueSet/nhi-medication"
        }
      },
      {
        "id" : "MedicationRequest.subject",
        "path" : "MedicationRequest.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.dosageInstruction",
        "path" : "MedicationRequest.dosageInstruction",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing",
        "path" : "MedicationRequest.dosageInstruction.timing",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.bounds[x]",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.bounds[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Period"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.bounds[x].start",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.bounds[x].start",
        "short" : "事前審查藥物預定處方起始日期，YYYY-MM-DD，西元年月日。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.bounds[x].end",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.bounds[x].end",
        "short" : "事前審查藥物預定處方終止日期，YYYY-MM-DD，西元年月日。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.count",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.count",
        "short" : "事前審查藥品療程／週期數。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.code",
        "path" : "MedicationRequest.dosageInstruction.timing.code",
        "short" : "事前審查藥品使用頻率及服用時間。",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/pas/ValueSet/medication-frequency-hl7-nhi"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.code.coding",
        "path" : "MedicationRequest.dosageInstruction.timing.code.coding",
        "short" : "事前審查藥品使用頻率及服用時間。",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/pas/ValueSet/medication-frequency-hl7-nhi"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.route",
        "path" : "MedicationRequest.dosageInstruction.route",
        "short" : "給藥途徑／作用部位。",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/pas/ValueSet/medication-path-sct-tw"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.route.coding",
        "path" : "MedicationRequest.dosageInstruction.route.coding",
        "short" : "給藥途徑／作用部位。",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/pas/ValueSet/medication-path-sct-tw"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x].value",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x].value",
        "short" : "事前審查藥品每次處方劑量，數字。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x].system",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x].system",
        "short" : "事前審查藥品每次處方劑量單位之代碼系統，固定為「http://unitsofmeasure.org」。",
        "min" : 1,
        "patternUri" : "http://unitsofmeasure.org"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x].code",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x].code",
        "short" : "事前審查藥品每次處方劑量單位，每次使用之顆數、mL數、支數等。",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "用藥單位的代碼範圍請參考[Common UCUM units](https://hl7.org/fhir/R4/valueset-ucum-common.html)。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/ucum-units"
        }
      }
    ]
  }
}

```
