# 就醫科別-Encounter TWPAS - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **就醫科別-Encounter TWPAS**

## Resource Profile: 就醫科別-Encounter TWPAS 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-twpas | *Version*:1.1.0 |
| Active as of 2025-12-17 | *Computable Name*:EncounterTWPAS |

 
此就醫科別-Encounter TWPAS Profile說明本IG如何進一步定義臺灣核心-就醫事件(TW Core Encounter) Profile以呈現事前審查中院所資訊之就醫科別 

**Usages:**

* Use this Profile: [免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md) and [癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md)
* Refer to this Profile: [ClaimEncounter](StructureDefinition-extension-claim-encounter.md)
* Examples for this Profile: [Encounter/enc-min](Encounter-enc-min.md)
* CapabilityStatements using this Profile: [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) and [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/Encounter-twpas)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Encounter-twpas.csv), [Excel](StructureDefinition-Encounter-twpas.xlsx), [Schematron](StructureDefinition-Encounter-twpas.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TWPAS支援的RESTful互動功能的完整清單，請參閱[TWPAS Server能力聲明](CapabilityStatement-CapabilityStatementTWPASServer.md)。

#### 建議應該支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`service-type`](SearchParameter-Encounter-service-type.md)**查詢所有Encounter：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Encounter?service-type={system|}[code]`例子：
(1) GET [base]/Encounter?service-type=AJ
(2) GET [base]/Encounter?service-type=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw|AJ



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Encounter-twpas",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-twpas",
  "version" : "1.1.0",
  "name" : "EncounterTWPAS",
  "title" : "就醫科別-Encounter TWPAS",
  "status" : "active",
  "date" : "2025-12-17T10:01:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此就醫科別-Encounter TWPAS Profile說明本IG如何進一步定義臺灣核心-就醫事件(TW Core Encounter) Profile以呈現事前審查中院所資訊之就醫科別",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Encounter",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter.meta",
        "path" : "Encounter.meta",
        "min" : 1
      },
      {
        "id" : "Encounter.meta.profile",
        "path" : "Encounter.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-twpas"
      },
      {
        "id" : "Encounter.status",
        "path" : "Encounter.status",
        "short" : "就醫現況。【因FHIR設計而需必填】",
        "patternCode" : "planned"
      },
      {
        "id" : "Encounter.class",
        "path" : "Encounter.class",
        "short" : "就醫分類。【因FHIR設計而需必填】",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActEncounterCode"
        }
      },
      {
        "id" : "Encounter.serviceType",
        "path" : "Encounter.serviceType",
        "short" : "就醫科別，完整代碼對應表請參照就醫科別對應表。",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "description" : "完整代碼對應表請參照[就醫科別對應表](https://build.fhir.org/ig/MOHW-TWCoreIG/cctwFHIRterm/ValueSet-medical-department-sct-tw.html#%E5%B0%B1%E9%86%AB%E7%A7%91%E5%88%A5%E5%B0%8D%E6%87%89%E8%A1%A8)。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medical-department-sct-tw"
        }
      },
      {
        "id" : "Encounter.serviceType.coding",
        "path" : "Encounter.serviceType.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "system"
            }
          ],
          "rules" : "closed"
        },
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Encounter.serviceType.coding.code",
        "path" : "Encounter.serviceType.coding.code",
        "min" : 1
      },
      {
        "id" : "Encounter.serviceType.coding:TWMedicalDepartmentSCT",
        "path" : "Encounter.serviceType.coding",
        "sliceName" : "TWMedicalDepartmentSCT",
        "short" : "對應至SNOMED CT之就醫科別"
      },
      {
        "id" : "Encounter.serviceType.coding:TWMedicalDepartmentSCT.code",
        "path" : "Encounter.serviceType.coding.code",
        "min" : 1
      },
      {
        "id" : "Encounter.serviceType.coding:TWMedicalConsultationDepartment",
        "path" : "Encounter.serviceType.coding",
        "sliceName" : "TWMedicalConsultationDepartment",
        "short" : "無法對應至SNOMED CT之臺灣健保署就醫科別"
      },
      {
        "id" : "Encounter.serviceType.coding:TWMedicalConsultationDepartment.code",
        "path" : "Encounter.serviceType.coding.code",
        "min" : 1
      },
      {
        "id" : "Encounter.serviceType.coding:TWMedicalTreatmentDepartment",
        "path" : "Encounter.serviceType.coding",
        "sliceName" : "TWMedicalTreatmentDepartment",
        "short" : "無法對應至SNOMED CT之臺灣健保署診療科別"
      },
      {
        "id" : "Encounter.serviceType.coding:TWMedicalTreatmentDepartment.code",
        "path" : "Encounter.serviceType.coding.code",
        "min" : 1
      },
      {
        "id" : "Encounter.subject",
        "path" : "Encounter.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
            ]
          }
        ]
      }
    ]
  }
}

```
