# 文件參照-DocumentReference TWPAS - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **文件參照-DocumentReference TWPAS**

## Resource Profile: 文件參照-DocumentReference TWPAS 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/DocumentReference-twpas | *Version*:1.1.0 |
| Active as of 2025-12-17 | *Computable Name*:DocumentReferenceTWPAS |

 
此文件參照-DocumentReference TWPAS Profile說明本IG如何進一步定義臺灣核心-文件參照(TW Core DocumentReference) Profile以呈現事前審查之治療計畫文件及基因報告 

**Usages:**

* Use this Profile: [免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md) and [癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md)
* Refer to this Profile: [免疫製劑事前審查-Claim Immunologic Aagent TWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md), [癌藥事前審查-Claim TWPAS](StructureDefinition-Claim-twpas.md), [基因資訊-Observation Diagnostic TWPAS](StructureDefinition-Observation-diagnostic-twpas.md), [檢驗檢查-Observation Laboratory Result TWPAS](StructureDefinition-Observation-laboratory-result-twpas.md) and [病人狀態評估-Observation Patient Assessment TWPAS](StructureDefinition-Observation-pat-assessment-twpas.md)
* Examples for this Profile: [DocumentReference/doc-careplan-min](DocumentReference-doc-careplan-min.md), [DocumentReference/doc-gene-min](DocumentReference-doc-gene-min.md), [DocumentReference/doc-medicalRecord-min](DocumentReference-doc-medicalRecord-min.md), [DocumentReference/doc-patientAssessment-min](DocumentReference-doc-patientAssessment-min.md) and [DocumentReference/doc-test-min](DocumentReference-doc-test-min.md)
* CapabilityStatements using this Profile: [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) and [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/DocumentReference-twpas)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-DocumentReference-twpas.csv), [Excel](StructureDefinition-DocumentReference-twpas.xlsx), [Schematron](StructureDefinition-DocumentReference-twpas.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "DocumentReference-twpas",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DocumentReference-twpas",
  "version" : "1.1.0",
  "name" : "DocumentReferenceTWPAS",
  "title" : "文件參照-DocumentReference TWPAS",
  "status" : "active",
  "date" : "2025-12-17T10:01:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此文件參照-DocumentReference TWPAS Profile說明本IG如何進一步定義臺灣核心-文件參照(TW Core DocumentReference) Profile以呈現事前審查之治療計畫文件及基因報告",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "fhircomposition",
      "uri" : "http://hl7.org/fhir/composition",
      "name" : "FHIR Composition"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "xds",
      "uri" : "http://ihe.net/xds",
      "name" : "XDS metadata equivalent"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DocumentReference",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DocumentReference",
        "path" : "DocumentReference",
        "constraint" : [
          {
            "key" : "report-title",
            "severity" : "error",
            "human" : "若category為「治療計畫文件(#careplan)」，請擇一填寫：「免疫檢查點抑制劑治療計畫／CAR-T多團隊會議紀錄／造血幹細胞移植計畫書」",
            "expression" : "((category.coding.exists(code='careplan')) implies (content.attachment.title = '免疫檢查點抑制劑治療計畫' or content.attachment.title = 'CAR-T多團隊會議紀錄' or content.attachment.title = '造血幹細胞移植計畫書'))",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DocumentReference-twpas"
          }
        ]
      },
      {
        "id" : "DocumentReference.meta",
        "path" : "DocumentReference.meta",
        "min" : 1
      },
      {
        "id" : "DocumentReference.meta.profile",
        "path" : "DocumentReference.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DocumentReference-twpas"
      },
      {
        "id" : "DocumentReference.status",
        "path" : "DocumentReference.status",
        "patternCode" : "current"
      },
      {
        "id" : "DocumentReference.category",
        "path" : "DocumentReference.category",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/pas/ValueSet/nhi-pdf-type"
        }
      },
      {
        "id" : "DocumentReference.category.coding",
        "path" : "DocumentReference.category.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "DocumentReference.category.coding.code",
        "path" : "DocumentReference.category.coding.code",
        "min" : 1
      },
      {
        "id" : "DocumentReference.subject",
        "path" : "DocumentReference.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.content.attachment",
        "path" : "DocumentReference.content.attachment",
        "constraint" : [
          {
            "key" : "UploadContent",
            "severity" : "error",
            "human" : "填寫格式：file://檔名.副檔名，例如：file://US01.jpg、file://PathologyReport01.pdf、file://GenReport01.pdf、file://王大明病歷.pdf",
            "expression" : "url.matches('^file://[a-zA-Z0-9_一-龥()-]+.[a-zA-Z]{2,5}$')",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DocumentReference-twpas"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.attachment.contentType",
        "path" : "DocumentReference.content.attachment.contentType",
        "short" : "報告結果-MIMEType",
        "min" : 1,
        "patternCode" : "application/pdf",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.attachment.url",
        "path" : "DocumentReference.content.attachment.url",
        "short" : "基因報告／治療計畫文件／檢驗(查)附件／病歷資料／病人狀態評估報告。（請填寫完整檔案路徑）",
        "min" : 1,
        "example" : [
          {
            "label" : "General",
            "valueUrl" : "file://PathologyReport01.pdf"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.attachment.title",
        "path" : "DocumentReference.content.attachment.title",
        "short" : "基因報告名稱／治療計畫文件名稱／檢驗(查)附件名稱／病歷資料名稱／病人狀態評估報告名稱。若category為「治療計畫文件(#careplan)」，請擇一填寫：「免疫檢查點抑制劑治療計畫／CAR-T多團隊會議紀錄／造血幹細胞移植計畫書」。",
        "mustSupport" : true
      }
    ]
  }
}

```
