# 計畫-CarePlan TWPAS - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **計畫-CarePlan TWPAS**

## Resource Profile: 計畫-CarePlan TWPAS 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/CarePlan-twpas | *Version*:1.1.0 |
| Active as of 2025-12-17 | *Computable Name*:CarePlanTWPAS |

 
此計畫-CarePlan TWPAS Profile說明本IG如何進一步定義臺灣核心-照護計畫（TW Core CarePlan） Profile以呈現免疫製劑事前審查之計畫（P） 

**Usages:**

* Use this Profile: [免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md) and [癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md)
* Refer to this Profile: [EncounterCarePlan](StructureDefinition-extension-encounter-carePlan.md)
* Examples for this Profile: [CarePlan/careplan-min](CarePlan-careplan-min.md)
* CapabilityStatements using this Profile: [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) and [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/CarePlan-twpas)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-CarePlan-twpas.csv), [Excel](StructureDefinition-CarePlan-twpas.xlsx), [Schematron](StructureDefinition-CarePlan-twpas.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CarePlan-twpas",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/CarePlan-twpas",
  "version" : "1.1.0",
  "name" : "CarePlanTWPAS",
  "title" : "計畫-CarePlan TWPAS",
  "status" : "active",
  "date" : "2025-12-17T10:01:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此計畫-CarePlan TWPAS Profile說明本IG如何進一步定義臺灣核心-照護計畫（TW Core CarePlan） Profile以呈現免疫製劑事前審查之計畫（P）",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "CarePlan",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CarePlan-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CarePlan.meta",
        "path" : "CarePlan.meta",
        "min" : 1
      },
      {
        "id" : "CarePlan.meta.profile",
        "path" : "CarePlan.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/CarePlan-twpas"
      },
      {
        "id" : "CarePlan.intent",
        "path" : "CarePlan.intent",
        "patternCode" : "plan"
      },
      {
        "id" : "CarePlan.description",
        "path" : "CarePlan.description",
        "short" : "計畫，由醫院自行填寫。",
        "min" : 1
      },
      {
        "id" : "CarePlan.subject",
        "path" : "CarePlan.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.encounter",
        "path" : "CarePlan.encounter",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-opd-twpas"
            ]
          }
        ]
      }
    ]
  }
}

```
