# 事前審查回覆-Bundle Response TWPAS - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **事前審查回覆-Bundle Response TWPAS**

## Resource Profile: 事前審查回覆-Bundle Response TWPAS 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-response-twpas | *Version*:1.1.0 |
| Active as of 2025-12-17 | *Computable Name*:BundleResponseTWPAS |

 
此事前審查回覆-Bundle Response TWPAS Profile說明本IG如何進一步定義資料交換基本單位(TW Core Bundle) Profile以呈現回覆事前審查之內容 

**Usages:**

* Examples for this Profile: [Bundle/bun-response](Bundle-bun-response.md)
* CapabilityStatements using this Profile: [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) and [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/Bundle-response-twpas)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Bundle-response-twpas.csv), [Excel](StructureDefinition-Bundle-response-twpas.xlsx), [Schematron](StructureDefinition-Bundle-response-twpas.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TWPAS支援的RESTful互動功能的完整清單，請參閱[TWPAS Server能力聲明](CapabilityStatement-CapabilityStatementTWPASServer.md)。

#### 建議應該支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`_id`](SearchParameter-Bundle-id.md)**查詢所有Bundle：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Bundle?_id=[id]`
`GET [base]/Bundle/[id]`例子：
(1) GET [base]/Bundle?_id=bun-1
(2) GET [base]/Bundle/bun-1



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Bundle-response-twpas",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-response-twpas",
  "version" : "1.1.0",
  "name" : "BundleResponseTWPAS",
  "title" : "事前審查回覆-Bundle Response TWPAS",
  "status" : "active",
  "date" : "2025-12-17T10:01:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此事前審查回覆-Bundle Response TWPAS Profile說明本IG如何進一步定義資料交換基本單位(TW Core Bundle) Profile以呈現回覆事前審查之內容",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle"
      },
      {
        "id" : "Bundle.meta",
        "path" : "Bundle.meta",
        "min" : 1
      },
      {
        "id" : "Bundle.meta.profile",
        "path" : "Bundle.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-response-twpas"
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "patternCode" : "searchset"
      },
      {
        "id" : "Bundle.total",
        "path" : "Bundle.total",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.link.relation",
        "path" : "Bundle.link.relation",
        "patternString" : "self",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.link.url",
        "path" : "Bundle.link.url",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resource"
            }
          ],
          "rules" : "closed"
        },
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:claimResponse",
        "path" : "Bundle.entry",
        "sliceName" : "claimResponse",
        "short" : "事前審查回覆",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:claimResponse.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "ClaimResponse",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClaimResponse-twpas"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
