# 基因資訊 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **基因資訊**

## Example Observation: 基因資訊

Profile: [基因資訊-Observation Diagnostic TWPAS](StructureDefinition-Observation-diagnostic-twpas.md)

**狀態**：final

**類型**：基因資訊([NHI-補充資訊類別值集](CodeSystem-nhi-supporting-info-type.md/)#geneInfo)

**code**：Genetic variant assessment([LOINC](http://loinc.org/)#69548-6)

**病人**：[Patient/pat-min](Patient-pat-min.md)

**基因檢測日期**：2024-05-07

> **基因檢測代碼**：KRAS gene mutations found [Identifier] in Blood or Tissue by Molecular genetics method Nominal（[LOINC-基因檢測代碼值集](http://loinc.org/)#21702-6）
**基因檢測實際結果**：KRAS 12 mutation: Not Detected, KRAS 13 mutation: Not Detected, KRAS 61 mutation: Not Detected
**基因突變類型**：Not detected（[LOINC-基因突變類型值集](http://loinc.org/)#LA11883-8）

**基因檢測機構**：[Organization 2023LDTB0002](Organization-org-gene-example.md)

**基因檢測分析結果**：基因檢測報告結果

**基因臨床判讀結果**：Positive ([ObservationInterpretationCodes](http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation/)#POS)

**基因檢測方法**：PCR ([LOINC Answer List LL4048-6](http://loinc.org/)#LA26418-6)

**基因檢測檢體類型**：[Specimen/spe-min](Specimen-spe-min.md)

**基因報告**：[DocumentReference/doc-gene-min](DocumentReference-doc-gene-min.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "obs-diagnostic-min",
  "meta" : {
    "profile" : [
      "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-diagnostic-twpas"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
          "code" : "geneInfo"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "69548-6"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-min"
  },
  "effectiveDateTime" : "2024-05-07",
  "performer" : [
    {
      "reference" : "Organization/org-gene-example"
    }
  ],
  "valueString" : "基因檢測報告結果",
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
          "code" : "POS"
        }
      ]
    }
  ],
  "method" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA26418-6"
      }
    ]
  },
  "specimen" : {
    "reference" : "Specimen/spe-min"
  },
  "derivedFrom" : [
    {
      "reference" : "DocumentReference/doc-gene-min"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "21702-6"
          }
        ]
      },
      "valueString" : "KRAS 12 mutation: Not Detected, KRAS 13 mutation: Not Detected, KRAS 61 mutation: Not Detected",
      "interpretation" : [
        {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA11883-8",
              "display" : "Not detected"
            }
          ],
          "text" : "Not detected"
        }
      ]
    }
  ]
}

```
