# 門診病歷 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **門診病歷**

## Example Encounter: 門診病歷

Profile: [門診病歷-Encounter OPD TWPAS](StructureDefinition-Encounter-opd-twpas.md)

**EncounterSubjective**: [Observation Subjective Narrative](Observation-obs-subjective.md)

**EncounterObjective**: [Observation Objective Narrative](Observation-obs-objective.md)

**EncounterClinicalImpression**: [ClinicalImpression: status = completed; summary = Right knee . arthritis . active](ClinicalImpression-cliImp-min.md)

**EncounterCarePlan**: [CarePlan: status = completed; intent = plan; category = Assessment and Plan of Treatment; description = 1.Arrenge Arthrocentesis of Right knee and synovial fluid analysis (routine, culture and crystal analysis) after patient consent. 2.Analgesics. 3.Bed rest with ice packing if necessary.](CarePlan-careplan-min.md)

**status**: Finished

**class**: [ActCode: AMB](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html#v3-ActCode-AMB) (ambulatory)

**serviceType**: Family practice (qualifier value)

### Participants

| | |
| :--- | :--- |
| - | **Individual** |
| * | [Practitioner: identifier = National Person Identifier where the xxx is the ISO table 3166 3-character (alphabetic) country code,Medical License number](Practitioner-pra-min.md) |

**period**: 2025-11-11 --> (ongoing)

### Diagnoses

| | |
| :--- | :--- |
| - | **Condition** |
| * | [Condition M17.11](Condition-con-diagnosis.md) |

**serviceProvider**: [Organization 臺北市立聯合醫院](Organization-org-hosp-example.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "enc-opd",
  "meta" : {
    "profile" : [
      "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-opd-twpas"
    ]
  },
  "extension" : [
    {
      "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-encounter-subjective",
      "valueReference" : {
        "reference" : "Observation/obs-subjective"
      }
    },
    {
      "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-encounter-objective",
      "valueReference" : {
        "reference" : "Observation/obs-objective"
      }
    },
    {
      "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-encounter-clinicalImpression",
      "valueReference" : {
        "reference" : "ClinicalImpression/cliImp-min"
      }
    },
    {
      "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-encounter-carePlan",
      "valueReference" : {
        "reference" : "CarePlan/careplan-min"
      }
    }
  ],
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "AMB"
  },
  "serviceType" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "419772000"
      }
    ]
  },
  "participant" : [
    {
      "individual" : {
        "reference" : "Practitioner/pra-min"
      }
    }
  ],
  "period" : {
    "start" : "2025-11-11"
  },
  "diagnosis" : [
    {
      "condition" : {
        "reference" : "Condition/con-diagnosis"
      }
    }
  ],
  "serviceProvider" : {
    "reference" : "Organization/org-hosp-example"
  }
}

```
