# NHI-健保事前審查-特約醫事機構 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NHI-健保事前審查-特約醫事機構**

## CodeSystem: NHI-健保事前審查-特約醫事機構 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/CodeSystem/organization-identifier-tw | *Version*:1.1.0 |
| Active as of 2025-10-31 | *Computable Name*:NHIOrganization |

 
臺灣衛生福利部中央健康保險署「特約醫事機構」代碼，參照至[衛福部健保署特約醫事機構代碼網路查詢服務](https://www.nhi.gov.tw/ch/cp-5548-135e8-2931-1.html)中的[健保特約醫療院所名冊](https://info.nhi.gov.tw/IODE0000/IODE0000S09?id=1120) 
代碼出版日期：2024-04-22；資料所屬單位：衛生福利部中央健康保險署。 
**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** 

 This Code system is referenced in the content logical definition of the following value sets: 

* [NHIOrganization](ValueSet-nhi-organization.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "organization-identifier-tw",
  "url" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/organization-identifier-tw",
  "version" : "1.1.0",
  "name" : "NHIOrganization",
  "title" : "NHI-健保事前審查-特約醫事機構",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-31",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣衛生福利部中央健康保險署「特約醫事機構」代碼，參照至[衛福部健保署特約醫事機構代碼網路查詢服務](https://www.nhi.gov.tw/ch/cp-5548-135e8-2931-1.html)中的[健保特約醫療院所名冊](https://info.nhi.gov.tw/IODE0000/IODE0000S09?id=1120)\n\n代碼出版日期：2024-04-22；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 36897,
  "concept" : [
    {
      "code" : "0101090517",
      "display" : "臺北市立聯合醫院"
    },
    {
      "code" : "0111070010",
      "display" : "衛生福利部基隆醫院"
    },
    {
      "code" : "0131020016",
      "display" : "新北市立聯合醫院"
    },
    {
      "code" : "0131060010",
      "display" : "衛生福利部樂生療養院"
    },
    {
      "code" : "0131060029",
      "display" : "衛生福利部臺北醫院"
    },
    {
      "code" : "0131230012",
      "display" : "衛生福利部八里療養院"
    },
    {
      "code" : "0190030516",
      "display" : "衛生福利部金門醫院"
    },
    {
      "code" : "0211070012",
      "display" : "基隆市立醫院"
    },
    {
      "code" : "0291010010",
      "display" : "連江縣立醫院"
    },
    {
      "code" : "0401020013",
      "display" : "國立臺灣大學醫學院附設醫院癌醫中心分院"
    },
    {
      "code" : "0401180014",
      "display" : "國立臺灣大學醫學院附設醫院"
    },
    {
      "code" : "0401180023",
      "display" : "國立臺灣大學醫學院附設醫院兒童醫院"
    },
    {
      "code" : "0401190010",
      "display" : "國立臺灣大學醫學院附設醫院北護分院"
    },
    {
      "code" : "0431270012",
      "display" : "國立臺灣大學醫學院附設醫院金山分院"
    },
    {
      "code" : "0434010518",
      "display" : "國立陽明交通大學附設醫院"
    },
    {
      "code" : "0501010019",
      "display" : "三軍總醫院松山分院附設民眾診療服務處"
    },
    {
      "code" : "0501110514",
      "display" : "三軍總醫院附設民眾診療服務處"
    },
    {
      "code" : "0501160014",
      "display" : "三軍總醫院北投分院附設民眾診療服務處"
    },
    {
      "code" : "0511040010",
      "display" : "三軍總醫院基隆分院附設民眾診療服務處"
    },
    {
      "code" : "0601160016",
      "display" : "臺北榮民總醫院"
    },
    {
      "code" : "0634030014",
      "display" : "臺北榮民總醫院蘇澳分院"
    },
    {
      "code" : "0634070018",
      "display" : "臺北榮民總醫院員山分院"
    },
    {
      "code" : "0701160518",
      "display" : "臺北市立關渡醫院-委託臺北榮民總醫院經營"
    },
    {
      "code" : "0901020013",
      "display" : "中山醫療社團法人中山醫院"
    },
    {
      "code" : "0901180023",
      "display" : "郵政醫院（委託中英醫療社團法人經營）"
    },
    {
      "code" : "0901190010",
      "display" : "西園醫療社團法人西園醫院"
    },
    {
      "code" : "0911010010",
      "display" : "維德醫療社團法人基隆維德醫院"
    },
    {
      "code" : "0931010016",
      "display" : "中英醫療社團法人中英醫院"
    },
    {
      "code" : "0931010025",
      "display" : "中英醫療社團法人板英醫院"
    },
    {
      "code" : "0931050010",
      "display" : "怡濟慈園醫療社團法人宏濟神經精神科醫院"
    },
    {
      "code" : "0931060016",
      "display" : "新仁醫療社團法人新仁醫院"
    },
    {
      "code" : "0931090014",
      "display" : "永聖醫療社團法人文化醫院"
    },
    {
      "code" : "0931100015",
      "display" : "北新醫療社團法人北新醫院"
    },
    {
      "code" : "0934060027",
      "display" : "海天醫療社團法人海天醫院"
    },
    {
      "code" : "1101010021",
      "display" : "基督復臨安息日會醫療財團法人臺安醫院"
    },
    {
      "code" : "1101020018",
      "display" : "國泰醫療財團法人國泰綜合醫院"
    },
    {
      "code" : "1101020027",
      "display" : "中心診所醫療財團法人中心綜合醫院"
    },
    {
      "code" : "1101020036",
      "display" : "宏恩醫療財團法人宏恩綜合醫院"
    },
    {
      "code" : "1101100011",
      "display" : "台灣基督長老教會馬偕醫療財團法人馬偕紀念醫院"
    },
    {
      "code" : "1101100020",
      "display" : "台灣基督長老教會馬偕醫療財團法人馬偕兒童醫院"
    },
    {
      "code" : "1101110026",
      "display" : "康寧醫療財團法人康寧醫院"
    },
    {
      "code" : "1101150011",
      "display" : "新光醫療財團法人新光吳火獅紀念醫院"
    },
    {
      "code" : "1101160017",
      "display" : "振興醫療財團法人振興醫院"
    },
    {
      "code" : "1101160026",
      "display" : "醫療財團法人辜公亮基金會和信治癌中心醫院"
    },
    {
      "code" : "1111060015",
      "display" : "長庚醫療財團法人基隆長庚紀念醫院"
    },
    {
      "code" : "1131010011",
      "display" : "醫療財團法人徐元智先生醫藥基金會亞東紀念醫院"
    },
    {
      "code" : "1131050515",
      "display" : "佛教慈濟醫療財團法人台北慈濟醫院"
    },
    {
      "code" : "1131090019",
      "display" : "行天宮醫療志業醫療財團法人恩主公醫院"
    },
    {
      "code" : "1131100010",
      "display" : "台灣基督長老教會馬偕醫療財團法人淡水馬偕紀念醫院"
    },
    {
      "code" : "1131110516",
      "display" : "國泰醫療財團法人汐止國泰綜合醫院"
    },
    {
      "code" : "1131130018",
      "display" : "新北市立土城醫院（委託長庚醫療財團法人興建經營）"
    },
    {
      "code" : "1134010022",
      "display" : "宜蘭仁愛醫療財團法人宜蘭仁愛醫院"
    },
    {
      "code" : "1134020019",
      "display" : "醫療財團法人羅許基金會羅東博愛醫院"
    },
    {
      "code" : "1134020028",
      "display" : "天主教靈醫會醫療財團法人羅東聖母醫院"
    },
    {
      "code" : "1134050026",
      "display" : "天主教靈醫會醫療財團法人礁溪杏和醫院"
    },
    {
      "code" : "1134070019",
      "display" : "宜蘭員山醫療財團法人宜蘭員山醫院"
    },
    {
      "code" : "1231030015",
      "display" : "天主教耕莘醫療財團法人永和耕莘醫院"
    },
    {
      "code" : "1231050017",
      "display" : "天主教耕莘醫療財團法人耕莘醫院"
    },
    {
      "code" : "1301110511",
      "display" : "中國醫藥大學附設醫院臺北分院"
    },
    {
      "code" : "1301170017",
      "display" : "臺北醫學大學附設醫院"
    },
    {
      "code" : "1301200010",
      "display" : "臺北市立萬芳醫院－委託臺北醫學大學辦理"
    },
    {
      "code" : "1331040513",
      "display" : "衛生福利部雙和醫院〈委託臺北醫學大學興建經營〉"
    },
    {
      "code" : "1331160010",
      "display" : "輔仁大學學校財團法人輔仁大學附設醫院"
    },
    {
      "code" : "1401190011",
      "display" : "財團法人台灣省私立台北仁濟院附設仁濟醫院"
    },
    {
      "code" : "1401190039",
      "display" : "同仁院醫療財團法人萬華醫院"
    },
    {
      "code" : "1411030013",
      "display" : "醫療財團法人臺灣區煤礦業基金會臺灣礦工醫院"
    },
    {
      "code" : "1431060017",
      "display" : "財團法人台灣省私立台北仁濟院附設新莊仁濟醫院"
    },
    {
      "code" : "1501010010",
      "display" : "博仁綜合醫院"
    },
    {
      "code" : "1501010029",
      "display" : "培靈醫院"
    },
    {
      "code" : "1501021219",
      "display" : "秀傳醫院"
    },
    {
      "code" : "1501100037",
      "display" : "協和婦女醫院"
    },
    {
      "code" : "1501101141",
      "display" : "泰安醫院"
    },
    {
      "code" : "1501201020",
      "display" : "景美醫院"
    },
    {
      "code" : "1511010068",
      "display" : "新昆明醫院"
    },
    {
      "code" : "1511060022",
      "display" : "南光神經精神科醫院"
    },
    {
      "code" : "1511060040",
      "display" : "暘基醫院"
    },
    {
      "code" : "1531010082",
      "display" : "板新醫院"
    },
    {
      "code" : "1531010108",
      "display" : "蕭中正醫院"
    },
    {
      "code" : "1531010279",
      "display" : "板橋中興醫院"
    },
    {
      "code" : "1531011310",
      "display" : "板橋國泰醫院"
    },
    {
      "code" : "1531020122",
      "display" : "宏仁醫院"
    },
    {
      "code" : "1531021165",
      "display" : "三重中興醫院"
    },
    {
      "code" : "1531021174",
      "display" : "祐民醫院"
    },
    {
      "code" : "1531021183",
      "display" : "全民醫院"
    },
    {
      "code" : "1531021192",
      "display" : "宏仁醫院"
    },
    {
      "code" : "1531031278",
      "display" : "永和復康醫院"
    },
    {
      "code" : "1531040259",
      "display" : "中祥醫院"
    },
    {
      "code" : "1531041363",
      "display" : "蕙生醫院"
    },
    {
      "code" : "1531041390",
      "display" : "怡和醫院"
    },
    {
      "code" : "1531041407",
      "display" : "祥顥醫院"
    },
    {
      "code" : "1531050077",
      "display" : "同仁醫院"
    },
    {
      "code" : "1531050086",
      "display" : "宏慈療養院"
    },
    {
      "code" : "1531051163",
      "display" : "豐榮醫院"
    },
    {
      "code" : "1531051172",
      "display" : "新北仁康醫院"
    },
    {
      "code" : "1531060046",
      "display" : "大順醫院"
    },
    {
      "code" : "1531060073",
      "display" : "新莊英仁醫院"
    },
    {
      "code" : "1531060180",
      "display" : "新泰綜合醫院"
    },
    {
      "code" : "1531061230",
      "display" : "益民醫院"
    },
    {
      "code" : "1531061249",
      "display" : "新泰綜合醫院"
    },
    {
      "code" : "1531061258",
      "display" : "祥顥醫院"
    },
    {
      "code" : "1531071030",
      "display" : "仁愛醫院"
    },
    {
      "code" : "1531080226",
      "display" : "名恩療養院"
    },
    {
      "code" : "1531091149",
      "display" : "清福醫院"
    },
    {
      "code" : "1531100027",
      "display" : "公祥醫院"
    },
    {
      "code" : "1531101113",
      "display" : "泓安醫院"
    },
    {
      "code" : "1531120038",
      "display" : "瑞芳礦工醫院"
    },
    {
      "code" : "1531130052",
      "display" : "廣川醫院"
    },
    {
      "code" : "1531130105",
      "display" : "仁安醫院"
    },
    {
      "code" : "1531131139",
      "display" : "元復醫院"
    },
    {
      "code" : "1531131157",
      "display" : "恩樺醫院"
    },
    {
      "code" : "1531140058",
      "display" : "全民醫院"
    },
    {
      "code" : "1531210019",
      "display" : "台安醫院"
    },
    {
      "code" : "1531210037",
      "display" : "台安醫院"
    },
    {
      "code" : "1701110019",
      "display" : "德威國際牙醫口腔醫院"
    },
    {
      "code" : "2101010013",
      "display" : "臺北市立聯合醫院附設松山門診部"
    },
    {
      "code" : "2101020019",
      "display" : "臺北市立聯合醫院附設大安門診部"
    },
    {
      "code" : "2101090011",
      "display" : "臺北市立聯合醫院附設大同門診部"
    },
    {
      "code" : "2101100227",
      "display" : "臺北市立聯合醫院附設中山門診部"
    },
    {
      "code" : "2101110027",
      "display" : "臺北市立聯合醫院附設內湖門診部"
    },
    {
      "code" : "2101120014",
      "display" : "臺北市立聯合醫院附設南港門診部"
    },
    {
      "code" : "2101150012",
      "display" : "臺北市立聯合醫院附設士林門診部"
    },
    {
      "code" : "2101151037",
      "display" : "臺北市立聯合醫院附設士林中醫門診部"
    },
    {
      "code" : "2101161033",
      "display" : "臺北市立聯合醫院附設北投門診部"
    },
    {
      "code" : "2101170050",
      "display" : "臺北市立聯合醫院附設信義門診部"
    },
    {
      "code" : "2101180038",
      "display" : "臺北市立聯合醫院附設中正門診部"
    },
    {
      "code" : "2101191068",
      "display" : "臺北市立聯合醫院附設萬華門診部"
    },
    {
      "code" : "2101200017",
      "display" : "臺北市立聯合醫院附設政大門診部"
    },
    {
      "code" : "2211070014",
      "display" : "基隆市立慢性病防治所"
    },
    {
      "code" : "2311010010",
      "display" : "基隆市中正區衛生所"
    },
    {
      "code" : "2311020016",
      "display" : "基隆市七堵區衛生所"
    },
    {
      "code" : "2311030012",
      "display" : "基隆市暖暖區衛生所"
    },
    {
      "code" : "2311040018",
      "display" : "基隆市仁愛區衛生所"
    },
    {
      "code" : "2311050014",
      "display" : "基隆市中山區衛生所"
    },
    {
      "code" : "2311060010",
      "display" : "基隆市安樂區衛生所"
    },
    {
      "code" : "2311070016",
      "display" : "基隆市信義區衛生所"
    },
    {
      "code" : "2331010016",
      "display" : "新北市板橋區衛生所"
    },
    {
      "code" : "2331020012",
      "display" : "新北市三重區衛生所"
    },
    {
      "code" : "2331030018",
      "display" : "新北市永和區衛生所"
    },
    {
      "code" : "2331040014",
      "display" : "新北市中和區衛生所"
    },
    {
      "code" : "2331050010",
      "display" : "新北市新店區衛生所"
    },
    {
      "code" : "2331060016",
      "display" : "新北市新莊區衛生所"
    },
    {
      "code" : "2331070012",
      "display" : "新北市樹林區衛生所"
    },
    {
      "code" : "2331080018",
      "display" : "新北市鶯歌區衛生所"
    },
    {
      "code" : "2331090014",
      "display" : "新北市三峽區衛生所"
    },
    {
      "code" : "2331100015",
      "display" : "新北市淡水區衛生所"
    },
    {
      "code" : "2331110011",
      "display" : "新北市汐止區衛生所"
    },
    {
      "code" : "2331120017",
      "display" : "新北市瑞芳區衛生所"
    },
    {
      "code" : "2331130013",
      "display" : "新北市土城區衛生所"
    },
    {
      "code" : "2331140019",
      "display" : "新北市蘆洲區衛生所"
    },
    {
      "code" : "2331150015",
      "display" : "新北市五股區衛生所"
    },
    {
      "code" : "2331160011",
      "display" : "新北市泰山區衛生所"
    },
    {
      "code" : "2331170017",
      "display" : "新北市林口區衛生所"
    },
    {
      "code" : "2331180013",
      "display" : "新北市深坑區衛生所"
    },
    {
      "code" : "2331190019",
      "display" : "新北市石碇區衛生所"
    },
    {
      "code" : "2331200010",
      "display" : "新北市坪林區衛生所"
    },
    {
      "code" : "2331210016",
      "display" : "新北市三芝區衛生所"
    },
    {
      "code" : "2331220012",
      "display" : "新北市石門區衛生所"
    },
    {
      "code" : "2331230018",
      "display" : "新北市八里區衛生所"
    },
    {
      "code" : "2331240014",
      "display" : "新北市平溪區衛生所"
    },
    {
      "code" : "2331250010",
      "display" : "新北市雙溪區衛生所"
    },
    {
      "code" : "2331260016",
      "display" : "新北市貢寮區衛生所"
    },
    {
      "code" : "2331270012",
      "display" : "新北市金山區衛生所"
    },
    {
      "code" : "2331280018",
      "display" : "新北市萬里區衛生所"
    },
    {
      "code" : "2331290014",
      "display" : "新北市烏來區衛生所"
    },
    {
      "code" : "2334010018",
      "display" : "宜蘭縣宜蘭市衛生所"
    },
    {
      "code" : "2334020014",
      "display" : "宜蘭縣羅東鎮衛生所"
    },
    {
      "code" : "2334030010",
      "display" : "宜蘭縣蘇澳鎮衛生所"
    },
    {
      "code" : "2334040016",
      "display" : "宜蘭縣頭城鎮衛生所"
    },
    {
      "code" : "2334050012",
      "display" : "宜蘭縣礁溪鄉衛生所"
    },
    {
      "code" : "2334060018",
      "display" : "宜蘭縣壯圍鄉衛生所"
    },
    {
      "code" : "2334070014",
      "display" : "宜蘭縣員山鄉衛生所"
    },
    {
      "code" : "2334081026",
      "display" : "宜蘭縣冬山鄉衛生所"
    },
    {
      "code" : "2334090016",
      "display" : "宜蘭縣五結鄉衛生所"
    },
    {
      "code" : "2334100017",
      "display" : "宜蘭縣三星鄉衛生所"
    },
    {
      "code" : "2334110013",
      "display" : "宜蘭縣大同鄉衛生所"
    },
    {
      "code" : "2334120019",
      "display" : "宜蘭縣南澳鄉衛生所"
    },
    {
      "code" : "2390010010",
      "display" : "金門縣金城鎮衛生所"
    },
    {
      "code" : "2390020016",
      "display" : "金門縣金沙鎮衛生所"
    },
    {
      "code" : "2390030030",
      "display" : "金門縣金湖鎮衛生所"
    },
    {
      "code" : "2390040518",
      "display" : "金門縣金寧鄉衛生所"
    },
    {
      "code" : "2390050032",
      "display" : "金門縣烈嶼鄉衛生所"
    },
    {
      "code" : "2391020010",
      "display" : "連江縣北竿鄉衛生所"
    },
    {
      "code" : "2391030016",
      "display" : "連江縣莒光鄉西莒衛生所"
    },
    {
      "code" : "2391030026",
      "display" : "連江縣莒光鄉東莒衛生所"
    },
    {
      "code" : "2391040012",
      "display" : "連江縣東引鄉衛生所"
    },
    {
      "code" : "2401020024",
      "display" : "國立台灣大學保健中心"
    },
    {
      "code" : "2501100010",
      "display" : "國防部醫務組診所"
    },
    {
      "code" : "2501100029",
      "display" : "國防部醫務組牙醫診所"
    },
    {
      "code" : "2501180018",
      "display" : "國軍台北門診中心附設民眾診療服務處"
    },
    {
      "code" : "2531090518",
      "display" : "國家中山科學研究院醫務所附設光武分診所"
    },
    {
      "code" : "2631010021",
      "display" : "板橋榮譽國民之家醫務室"
    },
    {
      "code" : "2701010024",
      "display" : "交通部民用航空局航空醫務中心"
    },
    {
      "code" : "2701170052",
      "display" : "臺北市政府醫務室"
    },
    {
      "code" : "2701171068",
      "display" : "臺北市議會醫務室"
    },
    {
      "code" : "2731090012",
      "display" : "退除役官兵輔導委員會臺北榮譽國民之家醫務室"
    },
    {
      "code" : "2731220010",
      "display" : "台灣電力公司第一核能發電廠員工診所"
    },
    {
      "code" : "2731280016",
      "display" : "台灣電力股份有限公司第二核能發電廠員工診所"
    },
    {
      "code" : "327200000I",
      "display" : "國民健康署"
    },
    {
      "code" : "3401160014",
      "display" : "和碩聯合科技股份有限公司附設醫務室"
    },
    {
      "code" : "3401171107",
      "display" : "聯合報系員工診療所"
    },
    {
      "code" : "3401171170",
      "display" : "台灣中油股份有限公司員工診所"
    },
    {
      "code" : "3401171189",
      "display" : "財團法人生命連線基金會附設醫務室"
    },
    {
      "code" : "3411010013",
      "display" : "台灣國際造船股份有限公司基隆廠診療所"
    },
    {
      "code" : "3431041096",
      "display" : "微星科技股份有限公司附設醫務室"
    },
    {
      "code" : "3431051056",
      "display" : "台灣通用器材股份有限公司醫務室"
    },
    {
      "code" : "3501010012",
      "display" : "榮恩耳鼻喉科小兒科聯合診所"
    },
    {
      "code" : "3501010049",
      "display" : "蔡恭禮內兒科診所"
    },
    {
      "code" : "3501010058",
      "display" : "林聰賢婦產科診所"
    },
    {
      "code" : "3501010094",
      "display" : "劉內兒科診所"
    },
    {
      "code" : "3501010209",
      "display" : "趙耳鼻喉科診所"
    },
    {
      "code" : "3501010227",
      "display" : "謝耳鼻喉科診所"
    },
    {
      "code" : "3501010263",
      "display" : "康明哲小兒科內科診所"
    },
    {
      "code" : "3501010307",
      "display" : "佳祐內兒科診所"
    },
    {
      "code" : "3501010414",
      "display" : "松山內兒科診所"
    },
    {
      "code" : "3501010478",
      "display" : "王俊彰耳鼻喉科診所"
    },
    {
      "code" : "3501010530",
      "display" : "林志聖眼科診所"
    },
    {
      "code" : "3501010683",
      "display" : "高國隆婦產科診所"
    },
    {
      "code" : "3501010692",
      "display" : "陳大昕耳鼻喉科診所"
    },
    {
      "code" : "3501010736",
      "display" : "林忠志診所"
    },
    {
      "code" : "3501010754",
      "display" : "吳耳鼻喉科診所"
    },
    {
      "code" : "3501010763",
      "display" : "陳炳堅內科診所"
    },
    {
      "code" : "3501010790",
      "display" : "王世興醫師診所"
    },
    {
      "code" : "3501010816",
      "display" : "詹前俊小兒科診所"
    },
    {
      "code" : "3501010834",
      "display" : "康瑞耳鼻喉科診所"
    },
    {
      "code" : "3501010852",
      "display" : "周玄文診所"
    },
    {
      "code" : "3501010870",
      "display" : "余內科診所"
    },
    {
      "code" : "3501010932",
      "display" : "吳慶南內科診所"
    },
    {
      "code" : "3501010987",
      "display" : "華南小兒科診所"
    },
    {
      "code" : "3501011037",
      "display" : "江建中診所"
    },
    {
      "code" : "3501011144",
      "display" : "尚群眼科診所"
    },
    {
      "code" : "3501011199",
      "display" : "民生翁耳鼻喉科診所"
    },
    {
      "code" : "3501011260",
      "display" : "江崇萍小兒科診所"
    },
    {
      "code" : "3501011313",
      "display" : "安德聯合診所"
    },
    {
      "code" : "3501011322",
      "display" : "安成診所"
    },
    {
      "code" : "3501011331",
      "display" : "美佳皮膚科診所"
    },
    {
      "code" : "3501011340",
      "display" : "傅眼科診所"
    },
    {
      "code" : "3501011439",
      "display" : "王貞乃皮膚科診所"
    },
    {
      "code" : "3501011466",
      "display" : "王躬仁診所"
    },
    {
      "code" : "3501011493",
      "display" : "車參薇小兒科診所"
    },
    {
      "code" : "3501011500",
      "display" : "洪小兒科診所"
    },
    {
      "code" : "3501012589",
      "display" : "方一強眼科診所"
    },
    {
      "code" : "3501012712",
      "display" : "趙彥宇邱慧嫻皮膚科聯合診所"
    },
    {
      "code" : "3501012794",
      "display" : "京華皮膚科診所"
    },
    {
      "code" : "3501012838",
      "display" : "閎新耳鼻喉科皮膚科聯合診所"
    },
    {
      "code" : "3501012990",
      "display" : "日聖眼科診所"
    },
    {
      "code" : "3501013031",
      "display" : "安美診所"
    },
    {
      "code" : "3501013040",
      "display" : "安禾聯合診所"
    },
    {
      "code" : "3501013059",
      "display" : "親親家庭診所"
    },
    {
      "code" : "3501013068",
      "display" : "黎博彥診所"
    },
    {
      "code" : "3501013120",
      "display" : "正風復健科診所"
    },
    {
      "code" : "3501013157",
      "display" : "大家好診所"
    },
    {
      "code" : "3501013237",
      "display" : "宇恩復健科診所"
    },
    {
      "code" : "3501013273",
      "display" : "奧斯卡眼科診所"
    },
    {
      "code" : "3501013282",
      "display" : "邱楠超診所"
    },
    {
      "code" : "3501013326",
      "display" : "祐腎內科診所"
    },
    {
      "code" : "3501013335",
      "display" : "介壽診所"
    },
    {
      "code" : "3501013433",
      "display" : "聯安診所"
    },
    {
      "code" : "3501013497",
      "display" : "裕昇診所"
    },
    {
      "code" : "3501013540",
      "display" : "永承診所"
    },
    {
      "code" : "3501013559",
      "display" : "松山信合美眼科診所"
    },
    {
      "code" : "3501013602",
      "display" : "李士虹皮膚科診所"
    },
    {
      "code" : "3501013835",
      "display" : "泛亞皮膚科整形外科診所"
    },
    {
      "code" : "3501014047",
      "display" : "双眼明眼科診所"
    },
    {
      "code" : "3501014092",
      "display" : "松原復健診所"
    },
    {
      "code" : "3501014145",
      "display" : "佳德診所"
    },
    {
      "code" : "3501014154",
      "display" : "安德復復健專科診所"
    },
    {
      "code" : "3501014172",
      "display" : "周適偉診所"
    },
    {
      "code" : "3501014225",
      "display" : "弘光耳鼻喉科診所"
    },
    {
      "code" : "3501014243",
      "display" : "何兆芬健康診所"
    },
    {
      "code" : "3501014270",
      "display" : "生昇復健專科診所"
    },
    {
      "code" : "3501014323",
      "display" : "美人魚時尚婦產科診所"
    },
    {
      "code" : "3501014350",
      "display" : "聯青診所"
    },
    {
      "code" : "3501014449",
      "display" : "立悅皮膚科診所"
    },
    {
      "code" : "3501014476",
      "display" : "鈞賀診所"
    },
    {
      "code" : "3501014574",
      "display" : "李政洋身心診所"
    },
    {
      "code" : "3501014636",
      "display" : "松山大愛眼科診所"
    },
    {
      "code" : "3501014734",
      "display" : "双悅診所"
    },
    {
      "code" : "3501014743",
      "display" : "延壽耳鼻喉科診所"
    },
    {
      "code" : "3501014823",
      "display" : "澄東耳鼻喉科診所"
    },
    {
      "code" : "3501014878",
      "display" : "悠適復健科診所"
    },
    {
      "code" : "3501014930",
      "display" : "聖光眼科診所"
    },
    {
      "code" : "3501014976",
      "display" : "駿昂耳鼻喉科診所"
    },
    {
      "code" : "3501015017",
      "display" : "樂康診所"
    },
    {
      "code" : "3501015026",
      "display" : "佑家診所"
    },
    {
      "code" : "3501015035",
      "display" : "安兒康小兒專科診所"
    },
    {
      "code" : "3501015053",
      "display" : "原邑診所"
    },
    {
      "code" : "3501015106",
      "display" : "泰安親親家庭診所"
    },
    {
      "code" : "3501015133",
      "display" : "弘宇診所"
    },
    {
      "code" : "3501015142",
      "display" : "佑達骨科診所"
    },
    {
      "code" : "3501015188",
      "display" : "朱家庭醫學科診所"
    },
    {
      "code" : "3501015197",
      "display" : "康健診所"
    },
    {
      "code" : "3501015213",
      "display" : "悅昇小兒科診所"
    },
    {
      "code" : "3501015240",
      "display" : "宥全診所"
    },
    {
      "code" : "3501015286",
      "display" : "全煜耳鼻喉科診所"
    },
    {
      "code" : "3501015311",
      "display" : "禾玥醫學診所"
    },
    {
      "code" : "3501015400",
      "display" : "芯橙診所"
    },
    {
      "code" : "3501015446",
      "display" : "立健美診所"
    },
    {
      "code" : "3501015464",
      "display" : "芯橙診所"
    },
    {
      "code" : "3501015526",
      "display" : "南京安澐診所"
    },
    {
      "code" : "3501015562",
      "display" : "畇力診所"
    },
    {
      "code" : "3501015580",
      "display" : "尚安診所"
    },
    {
      "code" : "3501015599",
      "display" : "書妍診所"
    },
    {
      "code" : "3501015606",
      "display" : "弘宇診所"
    },
    {
      "code" : "3501015615",
      "display" : "泰安親親家庭診所"
    },
    {
      "code" : "3501015660",
      "display" : "心田民生診所"
    },
    {
      "code" : "3501015697",
      "display" : "南京安澐診所"
    },
    {
      "code" : "3501015713",
      "display" : "劉宗憲身心診所"
    },
    {
      "code" : "3501015722",
      "display" : "一森渼診所"
    },
    {
      "code" : "3501015731",
      "display" : "知癒診所"
    },
    {
      "code" : "3501015740",
      "display" : "民安診所"
    },
    {
      "code" : "3501015768",
      "display" : "昱捷診所"
    },
    {
      "code" : "3501015777",
      "display" : "沛康診所"
    },
    {
      "code" : "3501015811",
      "display" : "尚安診所"
    },
    {
      "code" : "3501015820",
      "display" : "南京安澐診所"
    },
    {
      "code" : "3501015839",
      "display" : "榮恩蔡醫師診所"
    },
    {
      "code" : "3501015857",
      "display" : "靜萱身心診所"
    },
    {
      "code" : "3501020054",
      "display" : "林慧雯婦產科診所"
    },
    {
      "code" : "3501020143",
      "display" : "張少萌婦產科診所"
    },
    {
      "code" : "3501020161",
      "display" : "劉耳鼻喉科診所"
    },
    {
      "code" : "3501020232",
      "display" : "曹眼科診所"
    },
    {
      "code" : "3501020581",
      "display" : "大安黃耳鼻喉科診所"
    },
    {
      "code" : "3501020625",
      "display" : "黃禎祥診所"
    },
    {
      "code" : "3501020714",
      "display" : "陳秀鳳婦產科診所"
    },
    {
      "code" : "3501020830",
      "display" : "祥欽診所"
    },
    {
      "code" : "3501020858",
      "display" : "哈利路亞曾英欽診所"
    },
    {
      "code" : "3501020910",
      "display" : "大安林內科診所"
    },
    {
      "code" : "3501020974",
      "display" : "新鑫耳鼻喉科診所"
    },
    {
      "code" : "3501021006",
      "display" : "陳志明診所"
    },
    {
      "code" : "3501021060",
      "display" : "詹骨科診所"
    },
    {
      "code" : "3501021104",
      "display" : "詹內科診所"
    },
    {
      "code" : "3501021239",
      "display" : "吳坤光婦產科診所"
    },
    {
      "code" : "3501021319",
      "display" : "楊懷卿耳鼻喉科診所"
    },
    {
      "code" : "3501021382",
      "display" : "劉達昌眼科診所"
    },
    {
      "code" : "3501021391",
      "display" : "全家聯合診所"
    },
    {
      "code" : "3501021480",
      "display" : "林青穀家庭醫學科診所"
    },
    {
      "code" : "3501021579",
      "display" : "沈德昌診所"
    },
    {
      "code" : "3501021640",
      "display" : "博全婦產科診所"
    },
    {
      "code" : "3501021659",
      "display" : "鄭耳鼻喉科診所"
    },
    {
      "code" : "3501021711",
      "display" : "施崇仁耳鼻喉科診所"
    },
    {
      "code" : "3501021720",
      "display" : "林繼國診所"
    },
    {
      "code" : "3501021855",
      "display" : "馬大勳婦產科診所"
    },
    {
      "code" : "3501022138",
      "display" : "頂好林耳鼻喉科診所"
    },
    {
      "code" : "3501022218",
      "display" : "謝林診所"
    },
    {
      "code" : "3501022316",
      "display" : "黃禎憲皮膚科診所"
    },
    {
      "code" : "3501022361",
      "display" : "簡萬居耳鼻喉科診所"
    },
    {
      "code" : "3501022370",
      "display" : "陳柏豪耳鼻喉科診所"
    },
    {
      "code" : "3501022469",
      "display" : "王暉政眼科診所"
    },
    {
      "code" : "3501022478",
      "display" : "大學眼科診所"
    },
    {
      "code" : "3501022496",
      "display" : "仁安診所"
    },
    {
      "code" : "3501022610",
      "display" : "陳建銓耳鼻喉科診所"
    },
    {
      "code" : "3501022638",
      "display" : "張尚哲婦產科診所"
    },
    {
      "code" : "3501022647",
      "display" : "李翔耳鼻喉科診所"
    },
    {
      "code" : "3501022727",
      "display" : "葉明憲小兒科診所"
    },
    {
      "code" : "3501022745",
      "display" : "張渝醫師診所"
    },
    {
      "code" : "3501022754",
      "display" : "羅斯福診所"
    },
    {
      "code" : "3501022825",
      "display" : "萬通耳鼻喉科診所"
    },
    {
      "code" : "3501022834",
      "display" : "誠品診所"
    },
    {
      "code" : "3501022843",
      "display" : "啟誠聯合診所"
    },
    {
      "code" : "3501022914",
      "display" : "佳音診所"
    },
    {
      "code" : "3501023199",
      "display" : "通化延吉診所"
    },
    {
      "code" : "3501023260",
      "display" : "林正宗婦產科診所"
    },
    {
      "code" : "3501023322",
      "display" : "同心婦產科診所"
    },
    {
      "code" : "3501023340",
      "display" : "新長安診所"
    },
    {
      "code" : "3501023359",
      "display" : "李婦產科診所"
    },
    {
      "code" : "3501023457",
      "display" : "皇家診所"
    },
    {
      "code" : "3501023500",
      "display" : "陳瑞鵬婦產科診所"
    },
    {
      "code" : "3501023519",
      "display" : "劉賢平婦產科診所"
    },
    {
      "code" : "3501023537",
      "display" : "景德耳鼻喉科診所"
    },
    {
      "code" : "3501023555",
      "display" : "黃清浩耳鼻喉科診所"
    },
    {
      "code" : "3501024641",
      "display" : "忠孝大學眼科診所"
    },
    {
      "code" : "3501024829",
      "display" : "李唯通診所"
    },
    {
      "code" : "3501024918",
      "display" : "呂小兒科診所"
    },
    {
      "code" : "3501024954",
      "display" : "安居診所"
    },
    {
      "code" : "3501025077",
      "display" : "陳惠章婦產科家庭醫學科診所"
    },
    {
      "code" : "3501025086",
      "display" : "陳俊松診所"
    },
    {
      "code" : "3501025111",
      "display" : "黃崇禮皮膚科診所"
    },
    {
      "code" : "3501025139",
      "display" : "秋江外科診所"
    },
    {
      "code" : "3501025246",
      "display" : "窈窕診所"
    },
    {
      "code" : "3501025255",
      "display" : "適健復健科診所"
    },
    {
      "code" : "3501025380",
      "display" : "家安復健科診所"
    },
    {
      "code" : "3501025433",
      "display" : "于賓診所"
    },
    {
      "code" : "3501025479",
      "display" : "蘇仁和耳鼻喉科診所"
    },
    {
      "code" : "3501025504",
      "display" : "游鴻儒皮膚科診所"
    },
    {
      "code" : "3501025648",
      "display" : "延吉診所"
    },
    {
      "code" : "3501025719",
      "display" : "尖端診所"
    },
    {
      "code" : "3501025764",
      "display" : "滿意婦產科診所"
    },
    {
      "code" : "3501025791",
      "display" : "和平大愛眼科診所"
    },
    {
      "code" : "3501025906",
      "display" : "宜德復健科診所"
    },
    {
      "code" : "3501025915",
      "display" : "杏語心靈診所"
    },
    {
      "code" : "3501025960",
      "display" : "華漾皮膚專科診所"
    },
    {
      "code" : "3501025988",
      "display" : "鍾啟榮皮膚科診所"
    },
    {
      "code" : "3501026029",
      "display" : "曾皮膚科診所"
    },
    {
      "code" : "3501026109",
      "display" : "祥光診所"
    },
    {
      "code" : "3501026136",
      "display" : "琳安診所"
    },
    {
      "code" : "3501026225",
      "display" : "張國麟耳鼻喉科診所"
    },
    {
      "code" : "3501026314",
      "display" : "許世賓婦產科診所"
    },
    {
      "code" : "3501026396",
      "display" : "周大中婦產科診所"
    },
    {
      "code" : "3501026501",
      "display" : "貝拉整形外科診所"
    },
    {
      "code" : "3501026556",
      "display" : "慈民骨科診所"
    },
    {
      "code" : "3501026592",
      "display" : "尚行美皮膚專科診所"
    },
    {
      "code" : "3501026609",
      "display" : "杏心診所"
    },
    {
      "code" : "3501026716",
      "display" : "大安耳鼻喉科診所"
    },
    {
      "code" : "3501026869",
      "display" : "光能身心診所"
    },
    {
      "code" : "3501027133",
      "display" : "佳醫美人診所"
    },
    {
      "code" : "3501027188",
      "display" : "康婕婦產科診所"
    },
    {
      "code" : "3501027482",
      "display" : "陳偉寶泌尿科診所"
    },
    {
      "code" : "3501027491",
      "display" : "劉建宏診所"
    },
    {
      "code" : "3501027562",
      "display" : "金郁婦產科診所"
    },
    {
      "code" : "3501027580",
      "display" : "星星親子眼科診所"
    },
    {
      "code" : "3501027624",
      "display" : "榮主診所"
    },
    {
      "code" : "3501027660",
      "display" : "忠孝世賓婦產科診所"
    },
    {
      "code" : "3501027679",
      "display" : "聯合整形外科診所"
    },
    {
      "code" : "3501027704",
      "display" : "楷鈞診所"
    },
    {
      "code" : "3501027884",
      "display" : "安吉耳鼻喉科診所"
    },
    {
      "code" : "3501028029",
      "display" : "安仁診所"
    },
    {
      "code" : "3501028050",
      "display" : "許靜瑛小兒科診所"
    },
    {
      "code" : "3501028078",
      "display" : "莊國豐婦產科診所"
    },
    {
      "code" : "3501028201",
      "display" : "杏誠復健科診所"
    },
    {
      "code" : "3501028210",
      "display" : "博安家庭醫學科診所"
    },
    {
      "code" : "3501028416",
      "display" : "鼎心診所"
    },
    {
      "code" : "3501028596",
      "display" : "群維診所"
    },
    {
      "code" : "3501028649",
      "display" : "田嘉程診所"
    },
    {
      "code" : "3501028701",
      "display" : "陳峙仰診所"
    },
    {
      "code" : "3501028747",
      "display" : "瀚群骨科診所"
    },
    {
      "code" : "3501028774",
      "display" : "王群光自然診所"
    },
    {
      "code" : "3501028809",
      "display" : "諾美整形外科診所"
    },
    {
      "code" : "3501028845",
      "display" : "那明珠診所"
    },
    {
      "code" : "3501028970",
      "display" : "捷靚皮膚專科診所"
    },
    {
      "code" : "3501029128",
      "display" : "昱捷診所"
    },
    {
      "code" : "3501029351",
      "display" : "邱醫師診所"
    },
    {
      "code" : "3501029593",
      "display" : "聖侯診所"
    },
    {
      "code" : "3501029619",
      "display" : "宇寧身心診所"
    },
    {
      "code" : "3501029628",
      "display" : "黃文香兒科診所"
    },
    {
      "code" : "3501029771",
      "display" : "富霖診所"
    },
    {
      "code" : "3501029780",
      "display" : "敦平診所"
    },
    {
      "code" : "3501029888",
      "display" : "春暘診所"
    },
    {
      "code" : "3501029922",
      "display" : "健華診所"
    },
    {
      "code" : "3501029931",
      "display" : "松德診所"
    },
    {
      "code" : "3501029986",
      "display" : "雅丰美膚診所"
    },
    {
      "code" : "350102A009",
      "display" : "主愛心靈診所"
    },
    {
      "code" : "350102A107",
      "display" : "夏爾診所"
    },
    {
      "code" : "350102A170",
      "display" : "王修含皮膚科診所"
    },
    {
      "code" : "350102A189",
      "display" : "立喆診所"
    },
    {
      "code" : "350102A385",
      "display" : "雅丰時尚診所"
    },
    {
      "code" : "350102A698",
      "display" : "大仁診所"
    },
    {
      "code" : "350102A965",
      "display" : "延吉美皮膚專科診所"
    },
    {
      "code" : "350102B300",
      "display" : "光慧診所"
    },
    {
      "code" : "350102B319",
      "display" : "愛群婦產科診所"
    },
    {
      "code" : "350102B364",
      "display" : "禾馨新生婦幼診所"
    },
    {
      "code" : "350102B579",
      "display" : "和麗診所"
    },
    {
      "code" : "350102B766",
      "display" : "晴天身心診所"
    },
    {
      "code" : "350102B793",
      "display" : "蔡凱宙自然骨科診所"
    },
    {
      "code" : "350102C147",
      "display" : "達仁診所"
    },
    {
      "code" : "350102C183",
      "display" : "願麗醫美診所"
    },
    {
      "code" : "350102C389",
      "display" : "智博診所"
    },
    {
      "code" : "350102C487",
      "display" : "珍世明眼科診所"
    },
    {
      "code" : "350102C530",
      "display" : "馨思診所"
    },
    {
      "code" : "350102C576",
      "display" : "小禾馨小兒專科診所"
    },
    {
      "code" : "350102C772",
      "display" : "鴻馨診所"
    },
    {
      "code" : "350102C889",
      "display" : "佳立得耳鼻喉科診所"
    },
    {
      "code" : "350102C905",
      "display" : "晶漾診所"
    },
    {
      "code" : "350102C978",
      "display" : "安瑟美膚整形外科診所"
    },
    {
      "code" : "350102D117",
      "display" : "優爾視眼科診所"
    },
    {
      "code" : "350102D135",
      "display" : "李細祥內科診所"
    },
    {
      "code" : "350102D377",
      "display" : "福康診所"
    },
    {
      "code" : "350102D519",
      "display" : "超越復健診所"
    },
    {
      "code" : "350102D555",
      "display" : "謝婦產科診所"
    },
    {
      "code" : "350102D564",
      "display" : "張涵郁診所"
    },
    {
      "code" : "350102D733",
      "display" : "富盈診所"
    },
    {
      "code" : "350102D797",
      "display" : "和欣視光眼科診所"
    },
    {
      "code" : "350102D948",
      "display" : "大安聚英視光眼科診所"
    },
    {
      "code" : "350102E007",
      "display" : "愛家自然診所"
    },
    {
      "code" : "350102E025",
      "display" : "適安復健科診所"
    },
    {
      "code" : "350102E034",
      "display" : "大心診所"
    },
    {
      "code" : "350102E070",
      "display" : "欣昇復健科診所"
    },
    {
      "code" : "350102E105",
      "display" : "樂奕診所"
    },
    {
      "code" : "350102E212",
      "display" : "尚行美耳鼻喉專科診所"
    },
    {
      "code" : "350102E445",
      "display" : "安民家庭醫學科診所"
    },
    {
      "code" : "350102E481",
      "display" : "樂芙美形診所"
    },
    {
      "code" : "350102E534",
      "display" : "天美診所"
    },
    {
      "code" : "350102E678",
      "display" : "樂力適診所"
    },
    {
      "code" : "350102E703",
      "display" : "健全醫美診所"
    },
    {
      "code" : "350102E838",
      "display" : "敦力診所"
    },
    {
      "code" : "350102E892",
      "display" : "大安眼科診所"
    },
    {
      "code" : "350102E909",
      "display" : "大安身心診所"
    },
    {
      "code" : "350102E972",
      "display" : "行一診所"
    },
    {
      "code" : "350102F022",
      "display" : "信禾診所"
    },
    {
      "code" : "350102F157",
      "display" : "樂活診所"
    },
    {
      "code" : "350102F166",
      "display" : "愛群兒童成長診所"
    },
    {
      "code" : "350102F175",
      "display" : "大安双眼明眼科診所"
    },
    {
      "code" : "350102F184",
      "display" : "安東診所"
    },
    {
      "code" : "350102F317",
      "display" : "忠孝安媞婦產科診所"
    },
    {
      "code" : "350102F424",
      "display" : "宏康復健專科診所"
    },
    {
      "code" : "350102F513",
      "display" : "櫟安診所"
    },
    {
      "code" : "350102F531",
      "display" : "立澄診所"
    },
    {
      "code" : "350102F595",
      "display" : "幸福婦產科診所"
    },
    {
      "code" : "350102F620",
      "display" : "金貞醫學美容診所"
    },
    {
      "code" : "350102F657",
      "display" : "藏琢診所"
    },
    {
      "code" : "350102F684",
      "display" : "楊鵬生婦產科診所"
    },
    {
      "code" : "350102F693",
      "display" : "聯新國際診所"
    },
    {
      "code" : "350102F700",
      "display" : "藝群忠孝診所"
    },
    {
      "code" : "350102F719",
      "display" : "杏保醫網信誠診所"
    },
    {
      "code" : "350102F728",
      "display" : "禾馨宜蘊婦產科診所"
    },
    {
      "code" : "350102F737",
      "display" : "向陽身心診所"
    },
    {
      "code" : "350102F835",
      "display" : "信德診所"
    },
    {
      "code" : "350102F844",
      "display" : "適群診所"
    },
    {
      "code" : "350102F871",
      "display" : "敦南諾貝爾眼科診所"
    },
    {
      "code" : "350102F899",
      "display" : "東方美學診所"
    },
    {
      "code" : "350102F906",
      "display" : "微笑寶貝診所"
    },
    {
      "code" : "350102G083",
      "display" : "日安健康診所"
    },
    {
      "code" : "350102G127",
      "display" : "木木日安皮膚專科診所"
    },
    {
      "code" : "350102G216",
      "display" : "大中診所"
    },
    {
      "code" : "350102G234",
      "display" : "伊生診所"
    },
    {
      "code" : "350102G378",
      "display" : "交感身心診所"
    },
    {
      "code" : "350102G387",
      "display" : "生生優動忠孝新生診所"
    },
    {
      "code" : "350102G412",
      "display" : "永誠復健科診所"
    },
    {
      "code" : "350102G547",
      "display" : "顧芳瑜泌尿科診所"
    },
    {
      "code" : "350102G592",
      "display" : "上尚診所"
    },
    {
      "code" : "350102G636",
      "display" : "安澐診所"
    },
    {
      "code" : "350102G654",
      "display" : "法瑞診所"
    },
    {
      "code" : "350102G681",
      "display" : "大安皮膚專科診所"
    },
    {
      "code" : "350102G690",
      "display" : "醫者新診所"
    },
    {
      "code" : "350102G743",
      "display" : "樂益耳鼻喉科診所"
    },
    {
      "code" : "350102G798",
      "display" : "逸林診所"
    },
    {
      "code" : "350102G814",
      "display" : "憶安診所"
    },
    {
      "code" : "350102G823",
      "display" : "仁生復健科診所"
    },
    {
      "code" : "350102G832",
      "display" : "台北享新代診所"
    },
    {
      "code" : "350102G841",
      "display" : "忠孝世賓婦產科診所"
    },
    {
      "code" : "350102G878",
      "display" : "喜月泌尿診所"
    },
    {
      "code" : "350102G903",
      "display" : "看見佳醫診所"
    },
    {
      "code" : "350102G985",
      "display" : "杏保醫網信康診所"
    },
    {
      "code" : "350102H035",
      "display" : "群光自然診所"
    },
    {
      "code" : "350102H053",
      "display" : "伯特利敦南身心診所"
    },
    {
      "code" : "350102H062",
      "display" : "嘉齡診所"
    },
    {
      "code" : "350102H071",
      "display" : "家齡診所"
    },
    {
      "code" : "350102H080",
      "display" : "佳齡診所"
    },
    {
      "code" : "350102H099",
      "display" : "東風診所"
    },
    {
      "code" : "350102H133",
      "display" : "宸光眼科診所"
    },
    {
      "code" : "350102H160",
      "display" : "杏澤健康診所"
    },
    {
      "code" : "350102H286",
      "display" : "琢月診所"
    },
    {
      "code" : "350102H473",
      "display" : "晶漾診所"
    },
    {
      "code" : "350102H526",
      "display" : "禾馨大安婦幼診所"
    },
    {
      "code" : "350102H544",
      "display" : "忠孝喜月泌尿科診所"
    },
    {
      "code" : "350102H553",
      "display" : "維格診所"
    },
    {
      "code" : "350102H571",
      "display" : "仁愛耳鼻喉科診所"
    },
    {
      "code" : "350102H740",
      "display" : "馨思身心精神科診所"
    },
    {
      "code" : "350102H777",
      "display" : "澤之肌皮膚專科診所"
    },
    {
      "code" : "350102H820",
      "display" : "和平診所"
    },
    {
      "code" : "350102H866",
      "display" : "公館得心身醫學診所"
    },
    {
      "code" : "350102H884",
      "display" : "向陽身心診所"
    },
    {
      "code" : "350102H937",
      "display" : "康迎健康診所"
    },
    {
      "code" : "350102H964",
      "display" : "于賓診所"
    },
    {
      "code" : "350102I023",
      "display" : "朝沐和安診所"
    },
    {
      "code" : "350102I087",
      "display" : "博診所"
    },
    {
      "code" : "350102I096",
      "display" : "約書亞診所"
    },
    {
      "code" : "350102I103",
      "display" : "非凡復健科診所"
    },
    {
      "code" : "350102I210",
      "display" : "大安頤和健康診所"
    },
    {
      "code" : "350102I247",
      "display" : "心澤健康美學診所"
    },
    {
      "code" : "350102I309",
      "display" : "怡心診所"
    },
    {
      "code" : "350102I345",
      "display" : "聯準診所"
    },
    {
      "code" : "350102I372",
      "display" : "禾馨新生婦幼診所"
    },
    {
      "code" : "350102I416",
      "display" : "李醫師診所"
    },
    {
      "code" : "350102I434",
      "display" : "信禾診所"
    },
    {
      "code" : "350102I498",
      "display" : "澤星親子診所"
    },
    {
      "code" : "350102I541",
      "display" : "華特診所"
    },
    {
      "code" : "350102I550",
      "display" : "己研皮膚專科診所"
    },
    {
      "code" : "350102I578",
      "display" : "信德診所"
    },
    {
      "code" : "350102I587",
      "display" : "瑞森診所"
    },
    {
      "code" : "350102I649",
      "display" : "捷思身心醫學診所"
    },
    {
      "code" : "350102I658",
      "display" : "華林診所"
    },
    {
      "code" : "350102I676",
      "display" : "瑞安承芯耳鼻喉科診所"
    },
    {
      "code" : "350102I729",
      "display" : "啟程泌尿科診所"
    },
    {
      "code" : "350102I783",
      "display" : "忠孝世賓婦產科診所"
    },
    {
      "code" : "350102I818",
      "display" : "和麗診所"
    },
    {
      "code" : "350102I845",
      "display" : "小禾馨小兒專科診所"
    },
    {
      "code" : "350102I854",
      "display" : "杏澤健康診所"
    },
    {
      "code" : "350102I863",
      "display" : "敦御診所"
    },
    {
      "code" : "350102I952",
      "display" : "敦南諾貝爾眼科診所"
    },
    {
      "code" : "350102I970",
      "display" : "玥漾葛鎂診所"
    },
    {
      "code" : "350102J011",
      "display" : "晞醫診所"
    },
    {
      "code" : "350102J057",
      "display" : "振芝映煦心身醫學診所"
    },
    {
      "code" : "350102J100",
      "display" : "黎安瑟診所"
    },
    {
      "code" : "350102J164",
      "display" : "品元診所"
    },
    {
      "code" : "350102J182",
      "display" : "森歆林家醫診所"
    },
    {
      "code" : "350102J271",
      "display" : "群英健康美學診所"
    },
    {
      "code" : "350102J299",
      "display" : "仁愛柚子診所"
    },
    {
      "code" : "3501090172",
      "display" : "鈞生診所"
    },
    {
      "code" : "3501090458",
      "display" : "施小兒科診所"
    },
    {
      "code" : "3501090663",
      "display" : "廣安診所"
    },
    {
      "code" : "3501090798",
      "display" : "蔡皮膚科診所"
    },
    {
      "code" : "3501090814",
      "display" : "黃博裕小兒科診所"
    },
    {
      "code" : "3501090869",
      "display" : "林昭安診所"
    },
    {
      "code" : "3501091017",
      "display" : "保全診所"
    },
    {
      "code" : "3501091133",
      "display" : "羅志弘診所"
    },
    {
      "code" : "3501091142",
      "display" : "余自興眼科診所"
    },
    {
      "code" : "3501091302",
      "display" : "黃眼科診所"
    },
    {
      "code" : "3501091491",
      "display" : "大龍峒耳鼻喉科診所"
    },
    {
      "code" : "3501091508",
      "display" : "包眼科診所"
    },
    {
      "code" : "3501091642",
      "display" : "夏立雲診所"
    },
    {
      "code" : "3501091660",
      "display" : "朱世輝耳鼻喉科診所"
    },
    {
      "code" : "3501091688",
      "display" : "趙黎海診所"
    },
    {
      "code" : "3501091759",
      "display" : "周承良耳鼻喉科診所"
    },
    {
      "code" : "3501091786",
      "display" : "張漢權內科診所"
    },
    {
      "code" : "3501092890",
      "display" : "建成診所"
    },
    {
      "code" : "3501092989",
      "display" : "聖心婦家醫診所"
    },
    {
      "code" : "3501093011",
      "display" : "廣博診所"
    },
    {
      "code" : "3501093048",
      "display" : "澤民診所"
    },
    {
      "code" : "3501093057",
      "display" : "中華民國防癆協會第一胸腔病防治所"
    },
    {
      "code" : "3501093093",
      "display" : "延平耳鼻喉科診所"
    },
    {
      "code" : "3501093226",
      "display" : "台北聖仁皮膚科診所"
    },
    {
      "code" : "3501093253",
      "display" : "林仲皮膚科診所"
    },
    {
      "code" : "3501093271",
      "display" : "和泰內科診所"
    },
    {
      "code" : "3501093299",
      "display" : "羅源彰診所"
    },
    {
      "code" : "3501093468",
      "display" : "梅約內科診所"
    },
    {
      "code" : "3501093539",
      "display" : "慶吉診所"
    },
    {
      "code" : "3501093557",
      "display" : "澤康診所"
    },
    {
      "code" : "3501093584",
      "display" : "建順診所"
    },
    {
      "code" : "3501093600",
      "display" : "梅約診所"
    },
    {
      "code" : "3501093619",
      "display" : "夏凱納生活診所"
    },
    {
      "code" : "3501093708",
      "display" : "正和復健科診所"
    },
    {
      "code" : "3501093717",
      "display" : "宜康復健科診所"
    },
    {
      "code" : "3501093799",
      "display" : "南西維格皮膚科診所"
    },
    {
      "code" : "3501093806",
      "display" : "祥恩耳鼻喉科診所"
    },
    {
      "code" : "3501093851",
      "display" : "華康診所"
    },
    {
      "code" : "3501093897",
      "display" : "祐雙診所"
    },
    {
      "code" : "3501093913",
      "display" : "寧夏診所"
    },
    {
      "code" : "3501093940",
      "display" : "大同耳鼻喉科診所"
    },
    {
      "code" : "3501093968",
      "display" : "紘成診所"
    },
    {
      "code" : "3501093977",
      "display" : "志勛皮膚科診所"
    },
    {
      "code" : "3501094054",
      "display" : "新旅程復健科診所"
    },
    {
      "code" : "3501094072",
      "display" : "佑佳內科診所"
    },
    {
      "code" : "3501094081",
      "display" : "喜聖診所"
    },
    {
      "code" : "3501094090",
      "display" : "賢福診所"
    },
    {
      "code" : "3501094107",
      "display" : "泉源診所"
    },
    {
      "code" : "3501094125",
      "display" : "牧人所身心醫學診所"
    },
    {
      "code" : "3501094134",
      "display" : "圓山診所"
    },
    {
      "code" : "3501094152",
      "display" : "千暘診所"
    },
    {
      "code" : "3501094161",
      "display" : "聖方診所"
    },
    {
      "code" : "3501094189",
      "display" : "悅昇診所"
    },
    {
      "code" : "3501094223",
      "display" : "台全診所"
    },
    {
      "code" : "3501094232",
      "display" : "中山抱抱心身醫學診所"
    },
    {
      "code" : "3501094241",
      "display" : "恆昕泌尿科診所"
    },
    {
      "code" : "3501094250",
      "display" : "動能復健科診所"
    },
    {
      "code" : "3501094269",
      "display" : "悅昇診所"
    },
    {
      "code" : "3501094278",
      "display" : "聖方診所"
    },
    {
      "code" : "3501094287",
      "display" : "泉心診所"
    },
    {
      "code" : "3501100057",
      "display" : "生泉婦產科診所"
    },
    {
      "code" : "3501100182",
      "display" : "中崙聯合診所"
    },
    {
      "code" : "3501100217",
      "display" : "陳炯輝診所"
    },
    {
      "code" : "3501100413",
      "display" : "陳家庭醫學科診所"
    },
    {
      "code" : "3501100815",
      "display" : "木生婦幼診所"
    },
    {
      "code" : "3501100888",
      "display" : "富生婦產科診所"
    },
    {
      "code" : "3501100986",
      "display" : "葉小兒科診所"
    },
    {
      "code" : "3501100995",
      "display" : "柏泉內科小兒科診所"
    },
    {
      "code" : "3501101198",
      "display" : "歐婦產科診所"
    },
    {
      "code" : "3501101385",
      "display" : "王三郎婦產科診所"
    },
    {
      "code" : "3501101492",
      "display" : "李義男婦產科診所"
    },
    {
      "code" : "3501101625",
      "display" : "晏安診所"
    },
    {
      "code" : "3501101634",
      "display" : "劉宣彥診所"
    },
    {
      "code" : "3501101769",
      "display" : "林錦祥耳鼻喉科診所"
    },
    {
      "code" : "3501101787",
      "display" : "周賢章耳鼻喉科診所"
    },
    {
      "code" : "3501101803",
      "display" : "楊錦標神經科診所"
    },
    {
      "code" : "3501101849",
      "display" : "北安聯合診所"
    },
    {
      "code" : "3501102328",
      "display" : "邱內科診所"
    },
    {
      "code" : "3501102364",
      "display" : "陳世澤內科診所"
    },
    {
      "code" : "3501102560",
      "display" : "芯慈耳鼻喉科診所"
    },
    {
      "code" : "3501102622",
      "display" : "宗北內科診所"
    },
    {
      "code" : "3501102720",
      "display" : "陳正熹耳鼻喉科診所"
    },
    {
      "code" : "3501102766",
      "display" : "如田診所"
    },
    {
      "code" : "3501102944",
      "display" : "賴達三診所"
    },
    {
      "code" : "3501102953",
      "display" : "鼎廬診所"
    },
    {
      "code" : "3501102971",
      "display" : "蔡瓊瑤眼科診所"
    },
    {
      "code" : "3501103003",
      "display" : "世珍婦產診所"
    },
    {
      "code" : "3501103058",
      "display" : "長春眼科聯合診所"
    },
    {
      "code" : "3501103076",
      "display" : "德容聯合診所"
    },
    {
      "code" : "3501103272",
      "display" : "大直診所"
    },
    {
      "code" : "3501103281",
      "display" : "仁佑診所"
    },
    {
      "code" : "3501103334",
      "display" : "德美診所"
    },
    {
      "code" : "3501103361",
      "display" : "英政耳鼻喉科診所"
    },
    {
      "code" : "3501103370",
      "display" : "蔡仁雨皮膚科診所"
    },
    {
      "code" : "3501103414",
      "display" : "正恩耳鼻喉科診所"
    },
    {
      "code" : "3501103478",
      "display" : "蘇宋儒婦產科診所"
    },
    {
      "code" : "3501103503",
      "display" : "龍江小兒科診所"
    },
    {
      "code" : "3501103521",
      "display" : "晉宏診所"
    },
    {
      "code" : "3501103549",
      "display" : "瑞光眼科診所"
    },
    {
      "code" : "3501103567",
      "display" : "大直復健科診所"
    },
    {
      "code" : "3501103585",
      "display" : "鄭志誠小兒科診所"
    },
    {
      "code" : "3501103665",
      "display" : "寧康聯合診所"
    },
    {
      "code" : "3501103781",
      "display" : "黃大倫婦產科診所"
    },
    {
      "code" : "3501103790",
      "display" : "潘外科內科診所"
    },
    {
      "code" : "3501103905",
      "display" : "宏林診所"
    },
    {
      "code" : "3501103978",
      "display" : "吳振力診所"
    },
    {
      "code" : "3501104091",
      "display" : "慶恩小兒科診所"
    },
    {
      "code" : "3501104117",
      "display" : "王俊民皮膚科診所"
    },
    {
      "code" : "3501104126",
      "display" : "敦北諾貝爾診所"
    },
    {
      "code" : "3501104135",
      "display" : "啟新診所"
    },
    {
      "code" : "3501104180",
      "display" : "肌優谷診所"
    },
    {
      "code" : "3501104304",
      "display" : "蔡國賢耳鼻喉科診所"
    },
    {
      "code" : "3501104322",
      "display" : "民生承安診所"
    },
    {
      "code" : "3501104331",
      "display" : "全安診所"
    },
    {
      "code" : "3501104546",
      "display" : "雅得麗生活診所"
    },
    {
      "code" : "3501104644",
      "display" : "青山診所"
    },
    {
      "code" : "3501104742",
      "display" : "光華家醫科診所"
    },
    {
      "code" : "3501105105",
      "display" : "宇康復健科診所"
    },
    {
      "code" : "3501105123",
      "display" : "明誠診所"
    },
    {
      "code" : "3501105221",
      "display" : "澄心診所"
    },
    {
      "code" : "3501105310",
      "display" : "高固亷診所"
    },
    {
      "code" : "3501105445",
      "display" : "莊宇龍診所"
    },
    {
      "code" : "3501105472",
      "display" : "創健診所"
    },
    {
      "code" : "3501105543",
      "display" : "長春耳鼻喉科診所"
    },
    {
      "code" : "3501105703",
      "display" : "旭恩復健科診所"
    },
    {
      "code" : "3501105767",
      "display" : "愛鄰診所"
    },
    {
      "code" : "3501105785",
      "display" : "佳禾骨科診所"
    },
    {
      "code" : "3501105856",
      "display" : "思雲診所"
    },
    {
      "code" : "3501105936",
      "display" : "怡仁診所"
    },
    {
      "code" : "3501106004",
      "display" : "星光整形外科診所"
    },
    {
      "code" : "3501106059",
      "display" : "黃偉俐診所"
    },
    {
      "code" : "3501106102",
      "display" : "中山民權王耳鼻喉科診所"
    },
    {
      "code" : "3501106111",
      "display" : "信安診所"
    },
    {
      "code" : "3501106166",
      "display" : "興安診所"
    },
    {
      "code" : "3501106246",
      "display" : "聚英視光眼科診所"
    },
    {
      "code" : "3501106264",
      "display" : "農安診所"
    },
    {
      "code" : "3501106291",
      "display" : "博美名人外科診所"
    },
    {
      "code" : "3501106479",
      "display" : "京硯皮膚科診所"
    },
    {
      "code" : "3501106559",
      "display" : "杏慈診所"
    },
    {
      "code" : "3501106666",
      "display" : "微煦心靈診所"
    },
    {
      "code" : "3501106782",
      "display" : "慶生診所"
    },
    {
      "code" : "3501106906",
      "display" : "施宏男復健科診所"
    },
    {
      "code" : "3501106988",
      "display" : "長安診所"
    },
    {
      "code" : "3501106997",
      "display" : "康心美婦診所"
    },
    {
      "code" : "3501107047",
      "display" : "哲民診所"
    },
    {
      "code" : "3501107109",
      "display" : "群英楊麗珍黃景昱皮膚科診所"
    },
    {
      "code" : "3501107298",
      "display" : "耘康復健科診所"
    },
    {
      "code" : "3501107314",
      "display" : "元林診所"
    },
    {
      "code" : "3501107369",
      "display" : "晴光診所"
    },
    {
      "code" : "3501107458",
      "display" : "安康復健科診所"
    },
    {
      "code" : "3501107501",
      "display" : "聖和骨外科診所"
    },
    {
      "code" : "3501107538",
      "display" : "禾康診所"
    },
    {
      "code" : "3501107547",
      "display" : "陳博光教授診所"
    },
    {
      "code" : "3501107565",
      "display" : "雙連婦產科小兒科診所"
    },
    {
      "code" : "3501107574",
      "display" : "榮星診所"
    },
    {
      "code" : "3501107583",
      "display" : "好美醫美診所"
    },
    {
      "code" : "3501107645",
      "display" : "惟亷診所"
    },
    {
      "code" : "3501107707",
      "display" : "優視眼科診所"
    },
    {
      "code" : "3501107725",
      "display" : "大直佳恩診所"
    },
    {
      "code" : "3501107761",
      "display" : "秀仁整形外科診所"
    },
    {
      "code" : "3501107850",
      "display" : "美麗好診所"
    },
    {
      "code" : "3501107985",
      "display" : "彥靚診所"
    },
    {
      "code" : "3501108008",
      "display" : "四季和安婦幼診所"
    },
    {
      "code" : "3501108053",
      "display" : "心禾診所"
    },
    {
      "code" : "3501108151",
      "display" : "創興診所"
    },
    {
      "code" : "3501108213",
      "display" : "景亷復健科診所"
    },
    {
      "code" : "3501108277",
      "display" : "固亷診所"
    },
    {
      "code" : "3501108320",
      "display" : "鈺璽診所"
    },
    {
      "code" : "3501108366",
      "display" : "上直診所"
    },
    {
      "code" : "3501108393",
      "display" : "育仁診所"
    },
    {
      "code" : "3501108482",
      "display" : "詹益偉耳鼻喉科診所"
    },
    {
      "code" : "3501108517",
      "display" : "尚安診所"
    },
    {
      "code" : "3501108526",
      "display" : "振芝心身醫學診所"
    },
    {
      "code" : "3501108535",
      "display" : "麗安耳鼻喉科診所"
    },
    {
      "code" : "3501108562",
      "display" : "禾宇復健科診所"
    },
    {
      "code" : "3501108580",
      "display" : "永暉診所"
    },
    {
      "code" : "3501108599",
      "display" : "柏安診所"
    },
    {
      "code" : "3501108606",
      "display" : "玉山診所"
    },
    {
      "code" : "3501108759",
      "display" : "生基婦產科診所"
    },
    {
      "code" : "3501108777",
      "display" : "南西光澤診所"
    },
    {
      "code" : "3501108795",
      "display" : "杰膚美診所"
    },
    {
      "code" : "3501108811",
      "display" : "新英格蘭診所"
    },
    {
      "code" : "3501108875",
      "display" : "永育樂群診所"
    },
    {
      "code" : "3501108893",
      "display" : "又喜明眼科診所"
    },
    {
      "code" : "3501108955",
      "display" : "達康診所"
    },
    {
      "code" : "3501109005",
      "display" : "雅苑明萃皮膚科診所"
    },
    {
      "code" : "3501109014",
      "display" : "美麗晶華診所"
    },
    {
      "code" : "3501109130",
      "display" : "李宜霖診所"
    },
    {
      "code" : "3501109176",
      "display" : "民生展欣眼科診所"
    },
    {
      "code" : "3501109210",
      "display" : "進安身心診所"
    },
    {
      "code" : "3501109309",
      "display" : "中山適康復健科診所"
    },
    {
      "code" : "3501109327",
      "display" : "李凱國皮膚科診所"
    },
    {
      "code" : "3501109407",
      "display" : "繼承婦產科診所"
    },
    {
      "code" : "3501109425",
      "display" : "大直佳醫美人診所"
    },
    {
      "code" : "3501109532",
      "display" : "龍江固亷診所"
    },
    {
      "code" : "3501109685",
      "display" : "初日診所"
    },
    {
      "code" : "3501109701",
      "display" : "采騰診所"
    },
    {
      "code" : "3501109765",
      "display" : "台北維德診所"
    },
    {
      "code" : "3501109845",
      "display" : "永育樂群診所"
    },
    {
      "code" : "3501109872",
      "display" : "柏克萊眼科診所"
    },
    {
      "code" : "3501109934",
      "display" : "聖璽診所"
    },
    {
      "code" : "3501109961",
      "display" : "台北維德診所"
    },
    {
      "code" : "350110A039",
      "display" : "永濟診所"
    },
    {
      "code" : "350110A057",
      "display" : "得心身醫學台北總診所"
    },
    {
      "code" : "350110A075",
      "display" : "泓采診所"
    },
    {
      "code" : "350110A137",
      "display" : "聚英尊爵視光眼科診所"
    },
    {
      "code" : "350110A173",
      "display" : "維醫診所"
    },
    {
      "code" : "350110A208",
      "display" : "睦霖復健科診所"
    },
    {
      "code" : "350110A235",
      "display" : "新田身心診所"
    },
    {
      "code" : "350110A244",
      "display" : "偉俐民生診所"
    },
    {
      "code" : "350110A262",
      "display" : "長安東診所"
    },
    {
      "code" : "350110A324",
      "display" : "綠葉親子診所"
    },
    {
      "code" : "350110A360",
      "display" : "存奕美學診所"
    },
    {
      "code" : "350110A388",
      "display" : "新英格蘭診所"
    },
    {
      "code" : "350110A422",
      "display" : "中崙國際診所"
    },
    {
      "code" : "350110A431",
      "display" : "達康診所"
    },
    {
      "code" : "350110A468",
      "display" : "中山顧家泌尿科診所"
    },
    {
      "code" : "350110A548",
      "display" : "沐慕身心診所"
    },
    {
      "code" : "350110A557",
      "display" : "泓采診所"
    },
    {
      "code" : "350110A566",
      "display" : "晨昕診所"
    },
    {
      "code" : "350110A584",
      "display" : "肌優谷大直萬豪診所"
    },
    {
      "code" : "350110A593",
      "display" : "禾康診所"
    },
    {
      "code" : "350110A600",
      "display" : "中山適康復健科診所"
    },
    {
      "code" : "350110A619",
      "display" : "大直佳醫美人診所"
    },
    {
      "code" : "350110A646",
      "display" : "美迪大直婦產科診所"
    },
    {
      "code" : "350110A682",
      "display" : "致好醫學診所"
    },
    {
      "code" : "350110A708",
      "display" : "民權精睿泌尿科診所"
    },
    {
      "code" : "350110A717",
      "display" : "容康診所"
    },
    {
      "code" : "350110A735",
      "display" : "達康診所"
    },
    {
      "code" : "350110A753",
      "display" : "津久診所"
    },
    {
      "code" : "350110A780",
      "display" : "生生優活南京健康管理診所"
    },
    {
      "code" : "350110A799",
      "display" : "行健大直健康管理診所"
    },
    {
      "code" : "350110A815",
      "display" : "中山適康復健科診所"
    },
    {
      "code" : "350110A824",
      "display" : "吉林上尚診所"
    },
    {
      "code" : "350110A888",
      "display" : "心禾診所"
    },
    {
      "code" : "350110A897",
      "display" : "中山美麗馨診所"
    },
    {
      "code" : "350110B009",
      "display" : "茱麗雅整形美學婦產科診所"
    },
    {
      "code" : "350110B027",
      "display" : "森朗森仰診所"
    },
    {
      "code" : "350110B143",
      "display" : "沐晴診所"
    },
    {
      "code" : "350110B161",
      "display" : "竹安骨科診所"
    },
    {
      "code" : "3501110017",
      "display" : "陳德駿婦產科診所"
    },
    {
      "code" : "3501110026",
      "display" : "東湖內兒科診所"
    },
    {
      "code" : "3501110080",
      "display" : "陳森豊診所"
    },
    {
      "code" : "3501110115",
      "display" : "王慶森診所"
    },
    {
      "code" : "3501110142",
      "display" : "敏聖內兒科診所"
    },
    {
      "code" : "3501110188",
      "display" : "魏穀年診所"
    },
    {
      "code" : "3501110231",
      "display" : "康育診所"
    },
    {
      "code" : "3501110240",
      "display" : "宋小兒科診所"
    },
    {
      "code" : "3501110268",
      "display" : "振興內兒科診所"
    },
    {
      "code" : "3501110286",
      "display" : "丁大元診所"
    },
    {
      "code" : "3501110311",
      "display" : "徐醫師診所"
    },
    {
      "code" : "3501110455",
      "display" : "東湖張耳鼻喉科診所"
    },
    {
      "code" : "3501110473",
      "display" : "鍾兆智婦產科診所"
    },
    {
      "code" : "3501110482",
      "display" : "雙湖診所"
    },
    {
      "code" : "3501110508",
      "display" : "達美皮膚專科診所"
    },
    {
      "code" : "3501110571",
      "display" : "劉淦華診所"
    },
    {
      "code" : "3501110679",
      "display" : "施耳鼻喉科診所"
    },
    {
      "code" : "3501110688",
      "display" : "成功眼科診所"
    },
    {
      "code" : "3501110777",
      "display" : "林永正診所"
    },
    {
      "code" : "3501110802",
      "display" : "德文復健科診所"
    },
    {
      "code" : "3501110811",
      "display" : "謝小兒科診所"
    },
    {
      "code" : "3501110857",
      "display" : "弘育診所"
    },
    {
      "code" : "3501110928",
      "display" : "成功耳鼻喉科診所"
    },
    {
      "code" : "3501110937",
      "display" : "鴻文婦產科診所"
    },
    {
      "code" : "3501110973",
      "display" : "東成診所"
    },
    {
      "code" : "3501110982",
      "display" : "馬思特診所"
    },
    {
      "code" : "3501111005",
      "display" : "吳振光眼科診所"
    },
    {
      "code" : "3501111032",
      "display" : "立安診所"
    },
    {
      "code" : "3501111069",
      "display" : "藍曾小兒科診所"
    },
    {
      "code" : "3501111121",
      "display" : "慈銨診所"
    },
    {
      "code" : "3501111167",
      "display" : "西湖安康診所"
    },
    {
      "code" : "3501112235",
      "display" : "康寧診所"
    },
    {
      "code" : "3501112299",
      "display" : "洪永祥診所"
    },
    {
      "code" : "3501112315",
      "display" : "文德耳鼻喉科診所"
    },
    {
      "code" : "3501112324",
      "display" : "內湖長春診所"
    },
    {
      "code" : "3501112477",
      "display" : "弘康復健科診所"
    },
    {
      "code" : "3501112520",
      "display" : "顏鳳麟婦產科診所"
    },
    {
      "code" : "3501112548",
      "display" : "汎美皮膚科診所"
    },
    {
      "code" : "3501112655",
      "display" : "東湖眼科診所"
    },
    {
      "code" : "3501112735",
      "display" : "大愛眼科診所"
    },
    {
      "code" : "3501112762",
      "display" : "麗心診所"
    },
    {
      "code" : "3501112771",
      "display" : "東湖謝耳鼻喉科診所"
    },
    {
      "code" : "3501112780",
      "display" : "宏仁眼科診所"
    },
    {
      "code" : "3501112806",
      "display" : "陳喬鴻眼科診所"
    },
    {
      "code" : "3501112815",
      "display" : "魏之明小兒科診所"
    },
    {
      "code" : "3501112851",
      "display" : "日新診所"
    },
    {
      "code" : "3501112860",
      "display" : "林孟勳診所"
    },
    {
      "code" : "3501112897",
      "display" : "東湖皮膚專科診所"
    },
    {
      "code" : "3501112904",
      "display" : "成安耳鼻喉科診所"
    },
    {
      "code" : "3501112913",
      "display" : "薈安診所"
    },
    {
      "code" : "3501112971",
      "display" : "湖光皮膚專科診所"
    },
    {
      "code" : "3501113018",
      "display" : "成功復健科診所"
    },
    {
      "code" : "3501113036",
      "display" : "祐生復健科診所"
    },
    {
      "code" : "3501113063",
      "display" : "紫陽復健科診所"
    },
    {
      "code" : "3501113072",
      "display" : "加安耳鼻喉科診所"
    },
    {
      "code" : "3501113081",
      "display" : "哈佛眼科診所"
    },
    {
      "code" : "3501113090",
      "display" : "誠康診所"
    },
    {
      "code" : "3501113116",
      "display" : "夏一新身心精神科診所"
    },
    {
      "code" : "3501113134",
      "display" : "焉醫師診所"
    },
    {
      "code" : "3501113170",
      "display" : "晴安診所"
    },
    {
      "code" : "3501113232",
      "display" : "東湖骨外科診所"
    },
    {
      "code" : "3501113269",
      "display" : "內湖翰林眼科診所"
    },
    {
      "code" : "3501113303",
      "display" : "內湖大學眼科診所"
    },
    {
      "code" : "3501113312",
      "display" : "成功皮膚科診所"
    },
    {
      "code" : "3501113321",
      "display" : "林登山耳鼻喉科診所"
    },
    {
      "code" : "3501113330",
      "display" : "仁弘耳鼻喉科診所"
    },
    {
      "code" : "3501113358",
      "display" : "瑞成診所"
    },
    {
      "code" : "3501113367",
      "display" : "瑞健診所"
    },
    {
      "code" : "3501113401",
      "display" : "維仁診所"
    },
    {
      "code" : "3501113410",
      "display" : "康樂診所"
    },
    {
      "code" : "3501113456",
      "display" : "杜耳鼻喉科診所"
    },
    {
      "code" : "3501113572",
      "display" : "全心圓診所"
    },
    {
      "code" : "3501113581",
      "display" : "富康復健科診所"
    },
    {
      "code" : "3501113714",
      "display" : "大湖診所"
    },
    {
      "code" : "3501113750",
      "display" : "禾馨內湖婦幼診所"
    },
    {
      "code" : "3501113769",
      "display" : "吳坤駿診所"
    },
    {
      "code" : "3501113778",
      "display" : "禾安耳鼻喉科診所"
    },
    {
      "code" : "3501113812",
      "display" : "連安診所"
    },
    {
      "code" : "3501113849",
      "display" : "育睿診所"
    },
    {
      "code" : "3501113858",
      "display" : "詠盛診所"
    },
    {
      "code" : "3501113867",
      "display" : "辰星皮膚專科診所"
    },
    {
      "code" : "3501113910",
      "display" : "永長欣診所"
    },
    {
      "code" : "3501113929",
      "display" : "禾馨民權婦幼診所"
    },
    {
      "code" : "3501113965",
      "display" : "適康復健科診所"
    },
    {
      "code" : "3501113974",
      "display" : "晴渼皮膚專科診所"
    },
    {
      "code" : "3501113992",
      "display" : "榮欣骨科診所"
    },
    {
      "code" : "3501114006",
      "display" : "湖欣診所"
    },
    {
      "code" : "3501114015",
      "display" : "曜暘診所"
    },
    {
      "code" : "3501114024",
      "display" : "康研診所"
    },
    {
      "code" : "3501114042",
      "display" : "新明診所"
    },
    {
      "code" : "3501114079",
      "display" : "力康復健科診所"
    },
    {
      "code" : "3501114097",
      "display" : "林威廷身心精神科診所"
    },
    {
      "code" : "3501114104",
      "display" : "心力合診所"
    },
    {
      "code" : "3501114113",
      "display" : "思維診所"
    },
    {
      "code" : "3501114122",
      "display" : "陽光活力診所"
    },
    {
      "code" : "3501114186",
      "display" : "小禾馨民權小兒專科診所"
    },
    {
      "code" : "3501114202",
      "display" : "葫洲診所"
    },
    {
      "code" : "3501114248",
      "display" : "內湖身心精神科診所"
    },
    {
      "code" : "3501114257",
      "display" : "禾馨眼科診所"
    },
    {
      "code" : "3501114266",
      "display" : "美亞健康長壽診所"
    },
    {
      "code" : "3501114284",
      "display" : "艾菲爾全方位健康診所"
    },
    {
      "code" : "3501114300",
      "display" : "麗康診所"
    },
    {
      "code" : "3501114328",
      "display" : "瑞康診所"
    },
    {
      "code" : "3501114337",
      "display" : "哈佛診所"
    },
    {
      "code" : "3501114355",
      "display" : "恆新復健科診所"
    },
    {
      "code" : "3501114373",
      "display" : "展欣眼科診所"
    },
    {
      "code" : "3501114391",
      "display" : "全新圓診所"
    },
    {
      "code" : "3501114417",
      "display" : "維尚泌尿科診所"
    },
    {
      "code" : "3501114426",
      "display" : "理真診所"
    },
    {
      "code" : "3501114453",
      "display" : "奇樂三醫整合醫學診所"
    },
    {
      "code" : "3501114462",
      "display" : "紫陽診所"
    },
    {
      "code" : "3501114471",
      "display" : "禾馨民權內科診所"
    },
    {
      "code" : "3501114480",
      "display" : "瑞宏診所"
    },
    {
      "code" : "3501114499",
      "display" : "內湖健康管理診所"
    },
    {
      "code" : "3501114506",
      "display" : "內湖身心精神科診所"
    },
    {
      "code" : "3501114515",
      "display" : "藝群內湖診所"
    },
    {
      "code" : "3501114579",
      "display" : "鑫美光視光眼科診所"
    },
    {
      "code" : "3501114597",
      "display" : "永育醫療大湖診所"
    },
    {
      "code" : "3501114604",
      "display" : "鑫美光視光眼科診所"
    },
    {
      "code" : "3501114613",
      "display" : "佳霖診所"
    },
    {
      "code" : "3501114659",
      "display" : "樂善診所"
    },
    {
      "code" : "3501114668",
      "display" : "禾馨內湖內科診所"
    },
    {
      "code" : "3501114677",
      "display" : "力康復健科診所"
    },
    {
      "code" : "3501114686",
      "display" : "高峰診所"
    },
    {
      "code" : "3501114702",
      "display" : "抱抱心身醫學診所"
    },
    {
      "code" : "3501114711",
      "display" : "德威診所"
    },
    {
      "code" : "3501114748",
      "display" : "保安診所"
    },
    {
      "code" : "3501114828",
      "display" : "鑫美光視光眼科診所"
    },
    {
      "code" : "3501114882",
      "display" : "永育醫療康樂診所"
    },
    {
      "code" : "3501114891",
      "display" : "內湖容光皮膚專科診所"
    },
    {
      "code" : "3501114908",
      "display" : "益民健康診所"
    },
    {
      "code" : "3501120068",
      "display" : "廖內兒科診所"
    },
    {
      "code" : "3501120095",
      "display" : "杏林內科小兒科診所"
    },
    {
      "code" : "3501120157",
      "display" : "黃家庭醫學科診所"
    },
    {
      "code" : "3501120175",
      "display" : "佑誠診所"
    },
    {
      "code" : "3501120200",
      "display" : "翊群耳鼻喉科診所"
    },
    {
      "code" : "3501120228",
      "display" : "蔣小兒科診所"
    },
    {
      "code" : "3501120255",
      "display" : "湯眼科診所"
    },
    {
      "code" : "3501120335",
      "display" : "陳志鑫診所"
    },
    {
      "code" : "3501120353",
      "display" : "劉聖亞診所"
    },
    {
      "code" : "3501120362",
      "display" : "隆美皮膚科診所"
    },
    {
      "code" : "3501120451",
      "display" : "冠德耳鼻喉科診所"
    },
    {
      "code" : "3501121538",
      "display" : "中研耳鼻喉科診所"
    },
    {
      "code" : "3501121583",
      "display" : "中坡耳鼻喉科診所"
    },
    {
      "code" : "3501121592",
      "display" : "陳勝吉診所"
    },
    {
      "code" : "3501121627",
      "display" : "天仁小兒科診所"
    },
    {
      "code" : "3501121636",
      "display" : "希文耳鼻喉科診所"
    },
    {
      "code" : "3501121716",
      "display" : "興盛診所"
    },
    {
      "code" : "3501121725",
      "display" : "義仁兒科診所"
    },
    {
      "code" : "3501121743",
      "display" : "永育醫療福德診所"
    },
    {
      "code" : "3501121770",
      "display" : "天慈婦產科診所"
    },
    {
      "code" : "3501121814",
      "display" : "李文珍小兒科診所"
    },
    {
      "code" : "3501121823",
      "display" : "天仁健康診所"
    },
    {
      "code" : "3501121832",
      "display" : "維康診所"
    },
    {
      "code" : "3501121878",
      "display" : "優勢皮膚科診所"
    },
    {
      "code" : "3501121912",
      "display" : "泓安耳鼻喉科診所"
    },
    {
      "code" : "3501121994",
      "display" : "奕賢骨科外科診所"
    },
    {
      "code" : "3501122044",
      "display" : "杏安診所"
    },
    {
      "code" : "3501122071",
      "display" : "康禾診所"
    },
    {
      "code" : "3501122080",
      "display" : "南港諾貝爾眼科診所"
    },
    {
      "code" : "3501122099",
      "display" : "吉盛興盛診所"
    },
    {
      "code" : "3501122106",
      "display" : "麗馨診所"
    },
    {
      "code" : "3501122115",
      "display" : "南港復健科診所"
    },
    {
      "code" : "3501122124",
      "display" : "友力耳鼻喉科診所"
    },
    {
      "code" : "3501122133",
      "display" : "開馨診所"
    },
    {
      "code" : "3501122142",
      "display" : "松展診所"
    },
    {
      "code" : "3501122179",
      "display" : "昆陽耳鼻喉科診所"
    },
    {
      "code" : "3501122188",
      "display" : "荃威診所"
    },
    {
      "code" : "3501122197",
      "display" : "多田診所"
    },
    {
      "code" : "3501122286",
      "display" : "向怡診所"
    },
    {
      "code" : "3501150039",
      "display" : "黃金喜婦產科診所"
    },
    {
      "code" : "3501150066",
      "display" : "李文達婦產科診所"
    },
    {
      "code" : "3501150182",
      "display" : "天母許內科家醫科診所"
    },
    {
      "code" : "3501150208",
      "display" : "李世澤小兒科內科診所"
    },
    {
      "code" : "3501150226",
      "display" : "健原診所"
    },
    {
      "code" : "3501150388",
      "display" : "邱世昌診所"
    },
    {
      "code" : "3501150413",
      "display" : "柯耳鼻喉科診所"
    },
    {
      "code" : "3501150422",
      "display" : "存德小兒科診所"
    },
    {
      "code" : "3501150477",
      "display" : "社子陳診所"
    },
    {
      "code" : "3501150548",
      "display" : "蘇家庭醫學科診所"
    },
    {
      "code" : "3501150575",
      "display" : "鄭醫師診所"
    },
    {
      "code" : "3501150708",
      "display" : "吳如壽診所"
    },
    {
      "code" : "3501150735",
      "display" : "元順診所"
    },
    {
      "code" : "3501150744",
      "display" : "惠周內兒科診所"
    },
    {
      "code" : "3501150806",
      "display" : "何啟温診所"
    },
    {
      "code" : "3501150977",
      "display" : "天母耳鼻喉科診所"
    },
    {
      "code" : "3501150995",
      "display" : "廖正義診所"
    },
    {
      "code" : "3501151018",
      "display" : "林博通醫師診所"
    },
    {
      "code" : "3501151054",
      "display" : "德泰耳鼻喉科診所"
    },
    {
      "code" : "3501151090",
      "display" : "杏美皮膚科診所"
    },
    {
      "code" : "3501151125",
      "display" : "蘇惠珍皮膚科診所"
    },
    {
      "code" : "3501151161",
      "display" : "蘇慧卿診所"
    },
    {
      "code" : "3501151232",
      "display" : "仁友皮膚科診所"
    },
    {
      "code" : "3501151269",
      "display" : "粱耳鼻喉科診所"
    },
    {
      "code" : "3501151312",
      "display" : "羅氏皮膚科診所"
    },
    {
      "code" : "3501151358",
      "display" : "林佳宏小兒科診所"
    },
    {
      "code" : "3501151376",
      "display" : "高醫師家庭醫學科診所"
    },
    {
      "code" : "3501151394",
      "display" : "榮庚皮膚專科診所"
    },
    {
      "code" : "3501151401",
      "display" : "柯佑民小兒科診所"
    },
    {
      "code" : "3501151438",
      "display" : "德福診所"
    },
    {
      "code" : "3501151465",
      "display" : "盧金成婦產科診所"
    },
    {
      "code" : "3501151590",
      "display" : "洪楷義耳鼻喉科診所"
    },
    {
      "code" : "3501151607",
      "display" : "張松柏眼科診所"
    },
    {
      "code" : "3501151634",
      "display" : "何英世婦產科診所"
    },
    {
      "code" : "3501151643",
      "display" : "梁如蘭眼科診所"
    },
    {
      "code" : "3501151652",
      "display" : "吳俊昇眼科診所"
    },
    {
      "code" : "3501151661",
      "display" : "家庭醫師張正弘診所"
    },
    {
      "code" : "3501151670",
      "display" : "祐聖眼科診所"
    },
    {
      "code" : "3501151689",
      "display" : "楊是韻皮膚科診所"
    },
    {
      "code" : "3501151698",
      "display" : "王文豪診所"
    },
    {
      "code" : "3501151714",
      "display" : "安寧診所"
    },
    {
      "code" : "3501151750",
      "display" : "芝山診所"
    },
    {
      "code" : "3501151778",
      "display" : "福林診所"
    },
    {
      "code" : "3501151830",
      "display" : "得安耳鼻喉科診所"
    },
    {
      "code" : "3501151849",
      "display" : "忠誠聯合診所"
    },
    {
      "code" : "3501151894",
      "display" : "華齡診所"
    },
    {
      "code" : "3501151901",
      "display" : "慈田耳鼻喉科診所"
    },
    {
      "code" : "3501151938",
      "display" : "何小兒科診所"
    },
    {
      "code" : "3501151965",
      "display" : "政吉內科診所"
    },
    {
      "code" : "3501151974",
      "display" : "蕭雨青小兒科診所"
    },
    {
      "code" : "3501151983",
      "display" : "葉耳鼻喉科診所"
    },
    {
      "code" : "3501152006",
      "display" : "陳彥銘耳鼻喉科診所"
    },
    {
      "code" : "3501153030",
      "display" : "立安復健科診所"
    },
    {
      "code" : "3501153129",
      "display" : "保安眼科診所"
    },
    {
      "code" : "3501153138",
      "display" : "鄭福山婦產科診所"
    },
    {
      "code" : "3501153263",
      "display" : "杏昌診所"
    },
    {
      "code" : "3501153272",
      "display" : "天母雙合耳鼻喉科診所"
    },
    {
      "code" : "3501153281",
      "display" : "柏齡診所"
    },
    {
      "code" : "3501153370",
      "display" : "台美診所"
    },
    {
      "code" : "3501153478",
      "display" : "嘉櫻小兒科診所"
    },
    {
      "code" : "3501153496",
      "display" : "杏暉診所"
    },
    {
      "code" : "3501153512",
      "display" : "志明眼科診所"
    },
    {
      "code" : "3501153567",
      "display" : "平安診所"
    },
    {
      "code" : "3501153576",
      "display" : "雙林皮膚科診所"
    },
    {
      "code" : "3501153594",
      "display" : "元群眼科診所"
    },
    {
      "code" : "3501153656",
      "display" : "百齡診所"
    },
    {
      "code" : "3501153665",
      "display" : "張虔熙小兒科診所"
    },
    {
      "code" : "3501153692",
      "display" : "天母忠明２０２０眼科診所"
    },
    {
      "code" : "3501153709",
      "display" : "天母皮膚科診所"
    },
    {
      "code" : "3501153745",
      "display" : "愛林診所"
    },
    {
      "code" : "3501153781",
      "display" : "林志聰皮膚科診所"
    },
    {
      "code" : "3501153825",
      "display" : "天晴診所"
    },
    {
      "code" : "3501153870",
      "display" : "永安診所"
    },
    {
      "code" : "3501153895",
      "display" : "佳視得眼科診所"
    },
    {
      "code" : "3501153969",
      "display" : "淨美皮膚科診所"
    },
    {
      "code" : "3501153996",
      "display" : "健群骨科診所"
    },
    {
      "code" : "3501154082",
      "display" : "博政骨科診所"
    },
    {
      "code" : "3501154091",
      "display" : "葉眼科診所"
    },
    {
      "code" : "3501154180",
      "display" : "士林小兒科診所"
    },
    {
      "code" : "3501154199",
      "display" : "凱硯診所"
    },
    {
      "code" : "3501154206",
      "display" : "天母品恆復健科診所"
    },
    {
      "code" : "3501154215",
      "display" : "和謙耳鼻喉科診所"
    },
    {
      "code" : "3501154242",
      "display" : "華崗文化診所"
    },
    {
      "code" : "3501154251",
      "display" : "怡德診所"
    },
    {
      "code" : "3501154260",
      "display" : "揚德健康診所"
    },
    {
      "code" : "3501154279",
      "display" : "科安診所"
    },
    {
      "code" : "3501154288",
      "display" : "天母康健身心診所"
    },
    {
      "code" : "3501154297",
      "display" : "佑康診所"
    },
    {
      "code" : "3501154359",
      "display" : "社子安心診所"
    },
    {
      "code" : "3501154377",
      "display" : "永恆美診所"
    },
    {
      "code" : "3501154402",
      "display" : "士林復健科診所"
    },
    {
      "code" : "3501154420",
      "display" : "榮清耳鼻喉科診所"
    },
    {
      "code" : "3501154448",
      "display" : "耀明診所"
    },
    {
      "code" : "3501154475",
      "display" : "樹爸爸親子診所"
    },
    {
      "code" : "3501154493",
      "display" : "鴻林診所"
    },
    {
      "code" : "3501154500",
      "display" : "文林骨科診所"
    },
    {
      "code" : "3501154519",
      "display" : "貝爾診所"
    },
    {
      "code" : "3501154528",
      "display" : "小禾馨士林小兒專科診所"
    },
    {
      "code" : "3501154546",
      "display" : "橙光耳鼻喉科診所"
    },
    {
      "code" : "3501154564",
      "display" : "佩佩婦幼診所"
    },
    {
      "code" : "3501154591",
      "display" : "士林大學眼科診所"
    },
    {
      "code" : "3501154608",
      "display" : "心福內科診所"
    },
    {
      "code" : "3501154617",
      "display" : "朝陽復健科診所"
    },
    {
      "code" : "3501154635",
      "display" : "三玉品恆復健科診所"
    },
    {
      "code" : "3501154644",
      "display" : "伯仁診所"
    },
    {
      "code" : "3501154653",
      "display" : "聯志骨科診所"
    },
    {
      "code" : "3501154662",
      "display" : "境靜眼科診所"
    },
    {
      "code" : "3501154715",
      "display" : "德生診所"
    },
    {
      "code" : "3501154724",
      "display" : "心築身心診所"
    },
    {
      "code" : "3501154733",
      "display" : "士林身心醫學診所"
    },
    {
      "code" : "3501154742",
      "display" : "一七美生活診所"
    },
    {
      "code" : "3501154751",
      "display" : "藝群士林診所"
    },
    {
      "code" : "3501154804",
      "display" : "一森診所"
    },
    {
      "code" : "3501154813",
      "display" : "一七美生活診所"
    },
    {
      "code" : "3501154831",
      "display" : "朝陽復健科診所"
    },
    {
      "code" : "3501154840",
      "display" : "一森診所"
    },
    {
      "code" : "3501154859",
      "display" : "張國榮身心診所"
    },
    {
      "code" : "3501154895",
      "display" : "禾旭診所"
    },
    {
      "code" : "3501154902",
      "display" : "宜達診所"
    },
    {
      "code" : "3501154939",
      "display" : "永捷診所"
    },
    {
      "code" : "3501154975",
      "display" : "士林抱抱心身醫學診所"
    },
    {
      "code" : "3501154984",
      "display" : "仁友皮膚科診所"
    },
    {
      "code" : "3501154993",
      "display" : "得恩皮膚專科診所"
    },
    {
      "code" : "3501155007",
      "display" : "士林欣然耳鼻喉科診所"
    },
    {
      "code" : "3501155025",
      "display" : "柳橙親子診所"
    },
    {
      "code" : "3501155043",
      "display" : "一森診所"
    },
    {
      "code" : "3501155052",
      "display" : "凱硯診所"
    },
    {
      "code" : "3501155070",
      "display" : "明澄眼科診所"
    },
    {
      "code" : "3501155098",
      "display" : "政吉診所"
    },
    {
      "code" : "3501155123",
      "display" : "馥仁診所"
    },
    {
      "code" : "3501160099",
      "display" : "石牌李力成診所"
    },
    {
      "code" : "3501160133",
      "display" : "泰隆診所"
    },
    {
      "code" : "3501160204",
      "display" : "吉安診所"
    },
    {
      "code" : "3501160231",
      "display" : "洪耳鼻喉科診所"
    },
    {
      "code" : "3501160286",
      "display" : "永安家庭醫學科診所"
    },
    {
      "code" : "3501160302",
      "display" : "蔡賡禧婦產科診所"
    },
    {
      "code" : "3501160311",
      "display" : "紀耳鼻喉科診所"
    },
    {
      "code" : "3501160455",
      "display" : "保康耳鼻喉科診所"
    },
    {
      "code" : "3501160464",
      "display" : "怡鳴眼科診所"
    },
    {
      "code" : "3501160482",
      "display" : "宏德診所"
    },
    {
      "code" : "3501160544",
      "display" : "大順耳鼻喉科診所"
    },
    {
      "code" : "3501160731",
      "display" : "林文正耳鼻喉科診所"
    },
    {
      "code" : "3501160820",
      "display" : "揚名皮膚科診所"
    },
    {
      "code" : "3501160866",
      "display" : "長宏診所"
    },
    {
      "code" : "3501160900",
      "display" : "陳如芬眼科診所"
    },
    {
      "code" : "3501160937",
      "display" : "杏華診所"
    },
    {
      "code" : "3501160955",
      "display" : "泓光診所"
    },
    {
      "code" : "3501160973",
      "display" : "蔡秉勳小兒科診所"
    },
    {
      "code" : "3501160982",
      "display" : "清田婦產科家醫科診所"
    },
    {
      "code" : "3501160991",
      "display" : "張參雄診所"
    },
    {
      "code" : "3501161032",
      "display" : "陳獻明小兒科診所"
    },
    {
      "code" : "3501161103",
      "display" : "台新診所"
    },
    {
      "code" : "3501161121",
      "display" : "邱耳鼻喉科診所"
    },
    {
      "code" : "3501161149",
      "display" : "余世仁復健科診所"
    },
    {
      "code" : "3501161176",
      "display" : "文林診所"
    },
    {
      "code" : "3501161185",
      "display" : "李伯匯小兒科診所"
    },
    {
      "code" : "3501161238",
      "display" : "祐民聯合診所"
    },
    {
      "code" : "3501161363",
      "display" : "昱德聯合診所"
    },
    {
      "code" : "3501161372",
      "display" : "萬泰診所"
    },
    {
      "code" : "3501161461",
      "display" : "佳韻婦產科診所"
    },
    {
      "code" : "3501161505",
      "display" : "慈恩耳鼻喉科診所"
    },
    {
      "code" : "3501162486",
      "display" : "王志靈診所"
    },
    {
      "code" : "3501162502",
      "display" : "惠康診所"
    },
    {
      "code" : "3501162584",
      "display" : "美麗新卓玉麗皮膚科診所"
    },
    {
      "code" : "3501162628",
      "display" : "昱新眼科診所"
    },
    {
      "code" : "3501162637",
      "display" : "孫劍鴻眼科診所"
    },
    {
      "code" : "3501162664",
      "display" : "王永良診所"
    },
    {
      "code" : "3501162673",
      "display" : "翰譽耳鼻喉科診所"
    },
    {
      "code" : "3501162682",
      "display" : "張晉豪診所"
    },
    {
      "code" : "3501162717",
      "display" : "家福診所"
    },
    {
      "code" : "3501162726",
      "display" : "王景平眼科診所"
    },
    {
      "code" : "3501162735",
      "display" : "劉明真皮膚科診所"
    },
    {
      "code" : "3501162799",
      "display" : "洪志淳皮膚科診所"
    },
    {
      "code" : "3501162806",
      "display" : "康田診所"
    },
    {
      "code" : "3501162824",
      "display" : "承新診所"
    },
    {
      "code" : "3501162879",
      "display" : "陳珀勳診所"
    },
    {
      "code" : "3501162931",
      "display" : "尤亮惠耳鼻喉科診所"
    },
    {
      "code" : "3501162940",
      "display" : "何叔芳小兒科診所"
    },
    {
      "code" : "3501162959",
      "display" : "華榮診所"
    },
    {
      "code" : "3501162977",
      "display" : "芯悅皮膚科診所"
    },
    {
      "code" : "3501163018",
      "display" : "光明診所"
    },
    {
      "code" : "3501163027",
      "display" : "周仁德診所"
    },
    {
      "code" : "3501163036",
      "display" : "黃正宏診所"
    },
    {
      "code" : "3501163072",
      "display" : "宏恩兒科診所"
    },
    {
      "code" : "3501163081",
      "display" : "衡心診所"
    },
    {
      "code" : "3501163116",
      "display" : "弘德診所"
    },
    {
      "code" : "3501163125",
      "display" : "崇德診所"
    },
    {
      "code" : "3501163134",
      "display" : "李承鴻皮膚科診所"
    },
    {
      "code" : "3501163143",
      "display" : "紀皮膚科診所"
    },
    {
      "code" : "3501163170",
      "display" : "黃浩魁小兒科診所"
    },
    {
      "code" : "3501163232",
      "display" : "陳柏宏親子診所"
    },
    {
      "code" : "3501163241",
      "display" : "陳信方小兒科診所"
    },
    {
      "code" : "3501163250",
      "display" : "奇岩身心診所"
    },
    {
      "code" : "3501163269",
      "display" : "豪康診所"
    },
    {
      "code" : "3501163287",
      "display" : "北投骨科診所"
    },
    {
      "code" : "3501163296",
      "display" : "陽明診所"
    },
    {
      "code" : "3501163303",
      "display" : "慧捷診所"
    },
    {
      "code" : "3501163312",
      "display" : "台北欣安耳鼻喉科診所"
    },
    {
      "code" : "3501163330",
      "display" : "劉怜瑛眼科診所"
    },
    {
      "code" : "3501163349",
      "display" : "黃郁琳皮膚科診所"
    },
    {
      "code" : "3501163385",
      "display" : "倍視眼科診所"
    },
    {
      "code" : "3501163394",
      "display" : "晟幸診所"
    },
    {
      "code" : "3501163410",
      "display" : "石牌鄭身心醫學診所"
    },
    {
      "code" : "3501163429",
      "display" : "和新診所"
    },
    {
      "code" : "3501163438",
      "display" : "鄭宇廷耳鼻喉科診所"
    },
    {
      "code" : "3501163465",
      "display" : "榮陽安心診所"
    },
    {
      "code" : "3501163474",
      "display" : "如翊健康診所"
    },
    {
      "code" : "3501163483",
      "display" : "旭康復健科診所"
    },
    {
      "code" : "3501163492",
      "display" : "文遠診所"
    },
    {
      "code" : "3501163509",
      "display" : "常哲診所"
    },
    {
      "code" : "3501163518",
      "display" : "北辰身心醫學診所"
    },
    {
      "code" : "3501163527",
      "display" : "臻心復健科診所"
    },
    {
      "code" : "3501163536",
      "display" : "欣北投診所"
    },
    {
      "code" : "3501163554",
      "display" : "牛津眼科診所"
    },
    {
      "code" : "3501163563",
      "display" : "橙品耳鼻喉科診所"
    },
    {
      "code" : "3501163572",
      "display" : "石牌實和復健診所"
    },
    {
      "code" : "3501163590",
      "display" : "心樂是診所"
    },
    {
      "code" : "3501163607",
      "display" : "天母力康診所"
    },
    {
      "code" : "3501163616",
      "display" : "文遠診所"
    },
    {
      "code" : "3501163625",
      "display" : "和勤診所"
    },
    {
      "code" : "3501163634",
      "display" : "豪康診所"
    },
    {
      "code" : "3501163643",
      "display" : "石牌實和復健診所"
    },
    {
      "code" : "3501163661",
      "display" : "莊其穆教授婦女醫學診所"
    },
    {
      "code" : "3501163689",
      "display" : "信達雅診所"
    },
    {
      "code" : "3501163698",
      "display" : "文遠診所"
    },
    {
      "code" : "3501170059",
      "display" : "慶峰診所"
    },
    {
      "code" : "3501170237",
      "display" : "信義邱婦產科診所"
    },
    {
      "code" : "3501170246",
      "display" : "連小兒科診所"
    },
    {
      "code" : "3501170255",
      "display" : "朱耳鼻喉科診所"
    },
    {
      "code" : "3501170273",
      "display" : "秀光診所"
    },
    {
      "code" : "3501170317",
      "display" : "彭婦產科診所"
    },
    {
      "code" : "3501170380",
      "display" : "董耳鼻喉科診所"
    },
    {
      "code" : "3501170442",
      "display" : "有成外科診所"
    },
    {
      "code" : "3501170497",
      "display" : "怡安診所"
    },
    {
      "code" : "3501170513",
      "display" : "張葉森診所"
    },
    {
      "code" : "3501170826",
      "display" : "黃正麟皮膚科診所"
    },
    {
      "code" : "3501170835",
      "display" : "黃啟彰診所"
    },
    {
      "code" : "3501170899",
      "display" : "高眼科診所"
    },
    {
      "code" : "3501170915",
      "display" : "詹毅然內科診所"
    },
    {
      "code" : "3501170924",
      "display" : "富陽劉內兒科診所"
    },
    {
      "code" : "3501170942",
      "display" : "劉玄統診所"
    },
    {
      "code" : "3501170979",
      "display" : "劉彥煌耳鼻喉專科診所"
    },
    {
      "code" : "3501171010",
      "display" : "王寬仁診所"
    },
    {
      "code" : "3501171145",
      "display" : "吳潮峰眼科診所"
    },
    {
      "code" : "3501171172",
      "display" : "松山陳耳鼻喉科診所"
    },
    {
      "code" : "3501171207",
      "display" : "鄭光志小兒科診所"
    },
    {
      "code" : "3501171225",
      "display" : "張育驍診所"
    },
    {
      "code" : "3501171261",
      "display" : "康泰診所"
    },
    {
      "code" : "3501171270",
      "display" : "陳威璋耳鼻喉科診所"
    },
    {
      "code" : "3501171341",
      "display" : "伍瑞吉醫師診所"
    },
    {
      "code" : "3501171412",
      "display" : "陳醫師診所"
    },
    {
      "code" : "3501171510",
      "display" : "王剴鏘醫師診所"
    },
    {
      "code" : "3501171565",
      "display" : "明陽診所"
    },
    {
      "code" : "3501171654",
      "display" : "大明診所"
    },
    {
      "code" : "3501171663",
      "display" : "陳國泰皮膚科診所"
    },
    {
      "code" : "3501171716",
      "display" : "長風小兒科診所"
    },
    {
      "code" : "3501171743",
      "display" : "王知行婦產科診所"
    },
    {
      "code" : "3501172786",
      "display" : "德文診所"
    },
    {
      "code" : "3501172848",
      "display" : "松仁耳鼻喉科診所"
    },
    {
      "code" : "3501172857",
      "display" : "悠亞診所"
    },
    {
      "code" : "3501172893",
      "display" : "姚醫師診所"
    },
    {
      "code" : "3501172964",
      "display" : "永吉聯合診所"
    },
    {
      "code" : "3501173005",
      "display" : "佳康內科診所"
    },
    {
      "code" : "3501173032",
      "display" : "陽光耳鼻喉科診所"
    },
    {
      "code" : "3501173041",
      "display" : "黎明眼科診所"
    },
    {
      "code" : "3501173050",
      "display" : "新眼光眼科診所"
    },
    {
      "code" : "3501173103",
      "display" : "陳世卿診所"
    },
    {
      "code" : "3501173149",
      "display" : "日康復健科診所"
    },
    {
      "code" : "3501173176",
      "display" : "德明眼科診所"
    },
    {
      "code" : "3501173210",
      "display" : "美麗信義皮膚科診所"
    },
    {
      "code" : "3501173318",
      "display" : "大新診所"
    },
    {
      "code" : "3501173327",
      "display" : "明輝診所"
    },
    {
      "code" : "3501173336",
      "display" : "登瑞安診所"
    },
    {
      "code" : "3501173390",
      "display" : "陳育鵬內科診所"
    },
    {
      "code" : "3501173416",
      "display" : "福德郭耳鼻喉科診所"
    },
    {
      "code" : "3501173425",
      "display" : "林應然小兒科診所"
    },
    {
      "code" : "3501173505",
      "display" : "博馨診所"
    },
    {
      "code" : "3501173514",
      "display" : "陳逸川眼科診所"
    },
    {
      "code" : "3501173569",
      "display" : "信義耳鼻喉科診所"
    },
    {
      "code" : "3501173685",
      "display" : "新穎全診所"
    },
    {
      "code" : "3501173783",
      "display" : "俊安診所"
    },
    {
      "code" : "3501173836",
      "display" : "松禾診所"
    },
    {
      "code" : "3501173863",
      "display" : "１０１時尚診所"
    },
    {
      "code" : "3501173907",
      "display" : "松德精神科診所"
    },
    {
      "code" : "3501173970",
      "display" : "正興復健科診所"
    },
    {
      "code" : "3501174039",
      "display" : "錦宜診所"
    },
    {
      "code" : "3501174093",
      "display" : "自在診所"
    },
    {
      "code" : "3501174137",
      "display" : "博文診所"
    },
    {
      "code" : "3501174235",
      "display" : "德佑診所"
    },
    {
      "code" : "3501174306",
      "display" : "慧祥診所"
    },
    {
      "code" : "3501174360",
      "display" : "康誠內科診所"
    },
    {
      "code" : "3501174422",
      "display" : "健康吉美診所"
    },
    {
      "code" : "3501174477",
      "display" : "仁瀚骨科診所"
    },
    {
      "code" : "3501174486",
      "display" : "髮拉儷皮膚科診所"
    },
    {
      "code" : "3501174495",
      "display" : "伯特利身心診所"
    },
    {
      "code" : "3501174502",
      "display" : "祐誠骨科診所"
    },
    {
      "code" : "3501174520",
      "display" : "新佑泉診所"
    },
    {
      "code" : "3501174539",
      "display" : "六安復健科診所"
    },
    {
      "code" : "3501174548",
      "display" : "信義身心精神科診所"
    },
    {
      "code" : "3501174593",
      "display" : "理恩診所"
    },
    {
      "code" : "3501174708",
      "display" : "總站１８號診所"
    },
    {
      "code" : "3501174726",
      "display" : "飛悅皮膚科診所"
    },
    {
      "code" : "3501174753",
      "display" : "興雅診所"
    },
    {
      "code" : "3501174806",
      "display" : "永吉羅耳鼻喉科診所"
    },
    {
      "code" : "3501174815",
      "display" : "莊敬診所"
    },
    {
      "code" : "3501174842",
      "display" : "幫痘氏皮膚科診所"
    },
    {
      "code" : "3501174904",
      "display" : "愛利膚皮膚科診所"
    },
    {
      "code" : "3501174968",
      "display" : "新詠康診所"
    },
    {
      "code" : "3501175009",
      "display" : "弘安診所"
    },
    {
      "code" : "3501175018",
      "display" : "順康復健科診所"
    },
    {
      "code" : "3501175045",
      "display" : "原力復健科診所"
    },
    {
      "code" : "3501175054",
      "display" : "心苑診所"
    },
    {
      "code" : "3501175090",
      "display" : "晶愛眼科診所"
    },
    {
      "code" : "3501175223",
      "display" : "彥安診所"
    },
    {
      "code" : "3501175269",
      "display" : "松山班廷建興診所"
    },
    {
      "code" : "3501175278",
      "display" : "合安眼科診所"
    },
    {
      "code" : "3501175287",
      "display" : "靚顏維格診所"
    },
    {
      "code" : "3501175296",
      "display" : "信義健康管理診所"
    },
    {
      "code" : "3501175358",
      "display" : "雅偲皮膚科診所"
    },
    {
      "code" : "3501175367",
      "display" : "美麗馨診所"
    },
    {
      "code" : "3501175376",
      "display" : "謝政興泌尿科診所"
    },
    {
      "code" : "3501175385",
      "display" : "栢麗恆全人診所"
    },
    {
      "code" : "3501175429",
      "display" : "錢本文診所"
    },
    {
      "code" : "3501175438",
      "display" : "康禾復健科診所"
    },
    {
      "code" : "3501175447",
      "display" : "健民診所"
    },
    {
      "code" : "3501175456",
      "display" : "欣欣診所"
    },
    {
      "code" : "3501175465",
      "display" : "嚴敏心耳鼻喉科診所"
    },
    {
      "code" : "3501175492",
      "display" : "有民診所"
    },
    {
      "code" : "3501175554",
      "display" : "美麗馨診所"
    },
    {
      "code" : "3501175572",
      "display" : "劉教授婦產科診所"
    },
    {
      "code" : "3501175581",
      "display" : "靚顏維格診所"
    },
    {
      "code" : "3501175607",
      "display" : "臺北產業醫診所"
    },
    {
      "code" : "3501175616",
      "display" : "健民康禾診所"
    },
    {
      "code" : "3501175634",
      "display" : "美麗信義皮膚科診所"
    },
    {
      "code" : "3501175643",
      "display" : "康璽診所"
    },
    {
      "code" : "3501175661",
      "display" : "信義適康復健科診所"
    },
    {
      "code" : "3501175670",
      "display" : "杏仁復健科診所"
    },
    {
      "code" : "3501175698",
      "display" : "松德耳鼻喉科診所"
    },
    {
      "code" : "3501175714",
      "display" : "儷寶得信義皮膚科診所"
    },
    {
      "code" : "3501175732",
      "display" : "臺北產業醫診所"
    },
    {
      "code" : "3501175741",
      "display" : "承芯耳鼻喉科診所"
    },
    {
      "code" : "3501175750",
      "display" : "健民康禾診所"
    },
    {
      "code" : "3501175769",
      "display" : "健民診所"
    },
    {
      "code" : "3501175778",
      "display" : "靚顏維格診所"
    },
    {
      "code" : "3501175787",
      "display" : "永銘診所"
    },
    {
      "code" : "3501175796",
      "display" : "遠見眼科診所"
    },
    {
      "code" : "3501175803",
      "display" : "忠孝耳鼻喉科診所"
    },
    {
      "code" : "3501175812",
      "display" : "101諾貝爾眼科診所"
    },
    {
      "code" : "3501175849",
      "display" : "愛欣診所"
    },
    {
      "code" : "3501175867",
      "display" : "忠孝診所"
    },
    {
      "code" : "3501175885",
      "display" : "醫願診所"
    },
    {
      "code" : "3501175910",
      "display" : "長源身心診所"
    },
    {
      "code" : "3501175929",
      "display" : "承功診所"
    },
    {
      "code" : "3501175992",
      "display" : "源康診所"
    },
    {
      "code" : "3501176006",
      "display" : "忠孝診所"
    },
    {
      "code" : "3501176024",
      "display" : "忠孝診所"
    },
    {
      "code" : "3501176051",
      "display" : "臻蒔診所"
    },
    {
      "code" : "3501176079",
      "display" : "儷寶得信義皮膚科診所"
    },
    {
      "code" : "3501176113",
      "display" : "樂恬診所"
    },
    {
      "code" : "3501176122",
      "display" : "美麗信義皮膚科診所"
    },
    {
      "code" : "3501176131",
      "display" : "忠孝診所"
    },
    {
      "code" : "3501176168",
      "display" : "太陽雨信義身心診所"
    },
    {
      "code" : "3501180395",
      "display" : "紹毅內兒科診所"
    },
    {
      "code" : "3501180420",
      "display" : "劉瑞聰診所"
    },
    {
      "code" : "3501180582",
      "display" : "惠生診所"
    },
    {
      "code" : "3501180966",
      "display" : "鄭文宗耳鼻喉科診所"
    },
    {
      "code" : "3501181016",
      "display" : "古亭中心耳鼻喉科診所"
    },
    {
      "code" : "3501181258",
      "display" : "林診所"
    },
    {
      "code" : "3501181267",
      "display" : "朱小兒科診所"
    },
    {
      "code" : "3501181454",
      "display" : "戰痘診所"
    },
    {
      "code" : "3501181534",
      "display" : "雙合耳鼻喉科聯合診所"
    },
    {
      "code" : "3501181589",
      "display" : "同泰診所"
    },
    {
      "code" : "3501181614",
      "display" : "張孟源內科診所"
    },
    {
      "code" : "3501181641",
      "display" : "親子診所"
    },
    {
      "code" : "3501181767",
      "display" : "惠恩診所"
    },
    {
      "code" : "3501181810",
      "display" : "周正成小兒科診所"
    },
    {
      "code" : "3501181918",
      "display" : "丞泰耳鼻喉科診所"
    },
    {
      "code" : "3501181945",
      "display" : "蕭耳鼻喉科診所"
    },
    {
      "code" : "3501181981",
      "display" : "彭內科診所"
    },
    {
      "code" : "3501181990",
      "display" : "李相台診所"
    },
    {
      "code" : "3501183056",
      "display" : "池振坤耳鼻喉科診所"
    },
    {
      "code" : "3501183083",
      "display" : "柯滄銘婦產科診所"
    },
    {
      "code" : "3501183172",
      "display" : "蔡明勳診所"
    },
    {
      "code" : "3501183538",
      "display" : "拉菲爾人本診所"
    },
    {
      "code" : "3501183547",
      "display" : "怡和診所"
    },
    {
      "code" : "3501183592",
      "display" : "奕康耳鼻喉科診所"
    },
    {
      "code" : "3501183789",
      "display" : "李世輝耳鼻喉科診所"
    },
    {
      "code" : "3501183850",
      "display" : "健康101診所"
    },
    {
      "code" : "3501183903",
      "display" : "站前大學眼科診所"
    },
    {
      "code" : "3501184197",
      "display" : "美兆診所"
    },
    {
      "code" : "3501184213",
      "display" : "美診所"
    },
    {
      "code" : "3501184222",
      "display" : "星采皮膚專科診所"
    },
    {
      "code" : "3501184384",
      "display" : "匯安診所"
    },
    {
      "code" : "3501184393",
      "display" : "悅心診所"
    },
    {
      "code" : "3501184731",
      "display" : "禾馨婦產科診所"
    },
    {
      "code" : "3501184946",
      "display" : "永康身心診所"
    },
    {
      "code" : "3501184964",
      "display" : "祈新婦產科診所"
    },
    {
      "code" : "3501184973",
      "display" : "平安身心精神科診所"
    },
    {
      "code" : "3501185112",
      "display" : "博士眼科診所"
    },
    {
      "code" : "3501185194",
      "display" : "蔡瑞芳眼科診所"
    },
    {
      "code" : "3501185210",
      "display" : "蘭心診所"
    },
    {
      "code" : "3501185247",
      "display" : "祈約美醫皮膚科診所"
    },
    {
      "code" : "3501185372",
      "display" : "惠森復健科診所"
    },
    {
      "code" : "3501185407",
      "display" : "東妍診所"
    },
    {
      "code" : "3501185425",
      "display" : "宜康診所"
    },
    {
      "code" : "3501185461",
      "display" : "藝群台北診所"
    },
    {
      "code" : "3501185541",
      "display" : "大安皮膚專科診所"
    },
    {
      "code" : "3501185603",
      "display" : "日明耀診所"
    },
    {
      "code" : "3501185658",
      "display" : "立光診所"
    },
    {
      "code" : "3501185676",
      "display" : "和眾綜合診所"
    },
    {
      "code" : "3501185685",
      "display" : "家禾診所"
    },
    {
      "code" : "3501185694",
      "display" : "虹約復健專科診所"
    },
    {
      "code" : "3501185756",
      "display" : "江恩婦產科診所"
    },
    {
      "code" : "3501185774",
      "display" : "小禾馨懷寧小兒專科診所"
    },
    {
      "code" : "3501185827",
      "display" : "李明儒耳鼻喉科診所"
    },
    {
      "code" : "3501185863",
      "display" : "古亭光澤診所"
    },
    {
      "code" : "3501185907",
      "display" : "目急國際診所"
    },
    {
      "code" : "3501185916",
      "display" : "元泰診所"
    },
    {
      "code" : "3501185934",
      "display" : "懷寧復健科診所"
    },
    {
      "code" : "3501185952",
      "display" : "大心古亭診所"
    },
    {
      "code" : "3501185961",
      "display" : "博士診所"
    },
    {
      "code" : "3501185989",
      "display" : "衡觀診所"
    },
    {
      "code" : "3501186011",
      "display" : "鈞安診所"
    },
    {
      "code" : "3501186048",
      "display" : "台北公園諾貝爾眼科診所"
    },
    {
      "code" : "3501186066",
      "display" : "捷思身心醫學診所"
    },
    {
      "code" : "3501186100",
      "display" : "臻健康診所"
    },
    {
      "code" : "3501186119",
      "display" : "立達診所"
    },
    {
      "code" : "3501186164",
      "display" : "永愉診所"
    },
    {
      "code" : "3501186182",
      "display" : "久瑞復健科診所"
    },
    {
      "code" : "3501186208",
      "display" : "好甘心診所"
    },
    {
      "code" : "3501186217",
      "display" : "古亭適康復健科診所"
    },
    {
      "code" : "3501186280",
      "display" : "銘人診所"
    },
    {
      "code" : "3501186299",
      "display" : "立達診所"
    },
    {
      "code" : "3501186306",
      "display" : "力安妥診所"
    },
    {
      "code" : "3501186333",
      "display" : "古亭復健診所"
    },
    {
      "code" : "3501186360",
      "display" : "幫痘氏公館皮膚科診所"
    },
    {
      "code" : "3501186459",
      "display" : "禾瑞印象診所"
    },
    {
      "code" : "3501186495",
      "display" : "台北澄清眼科診所"
    },
    {
      "code" : "3501186502",
      "display" : "慢活靜心診所"
    },
    {
      "code" : "3501186557",
      "display" : "永康身心診所"
    },
    {
      "code" : "3501186575",
      "display" : "亮晴皮膚專科診所"
    },
    {
      "code" : "3501186593",
      "display" : "德和診所"
    },
    {
      "code" : "3501186691",
      "display" : "曜健康整合醫學古亭診所"
    },
    {
      "code" : "3501186708",
      "display" : "台北站前諾貝爾眼科診所"
    },
    {
      "code" : "3501186717",
      "display" : "好心腸診所"
    },
    {
      "code" : "3501186726",
      "display" : "沐生醫學診所"
    },
    {
      "code" : "3501186744",
      "display" : "古亭適康復健科診所"
    },
    {
      "code" : "3501186753",
      "display" : "劉才睿診所"
    },
    {
      "code" : "3501186762",
      "display" : "佳飛雅醫美診所"
    },
    {
      "code" : "3501186771",
      "display" : "疼痛職人診所"
    },
    {
      "code" : "3501186851",
      "display" : "嘉德良醫診所"
    },
    {
      "code" : "3501186879",
      "display" : "美兆診所"
    },
    {
      "code" : "3501186888",
      "display" : "美兆國際診所"
    },
    {
      "code" : "3501186913",
      "display" : "青蒿診所"
    },
    {
      "code" : "3501186968",
      "display" : "泱光健康美學診所"
    },
    {
      "code" : "3501190051",
      "display" : "新東平診所"
    },
    {
      "code" : "3501190168",
      "display" : "萬華劉小兒科診所"
    },
    {
      "code" : "3501190328",
      "display" : "鄭內兒科診所"
    },
    {
      "code" : "3501190426",
      "display" : "樺昌耳鼻喉科診所"
    },
    {
      "code" : "3501190542",
      "display" : "世福診所"
    },
    {
      "code" : "3501190560",
      "display" : "益生婦產科診所"
    },
    {
      "code" : "3501191003",
      "display" : "顏克文診所"
    },
    {
      "code" : "3501191441",
      "display" : "林進雄診所"
    },
    {
      "code" : "3501191549",
      "display" : "鄭眼科診所"
    },
    {
      "code" : "3501191852",
      "display" : "童錫鈺診所"
    },
    {
      "code" : "3501192126",
      "display" : "許士昌診所"
    },
    {
      "code" : "3501192144",
      "display" : "盧漢隆耳鼻喉科診所"
    },
    {
      "code" : "3501192162",
      "display" : "萬華蔡耳鼻喉科診所"
    },
    {
      "code" : "3501192224",
      "display" : "周耳鼻喉科診所"
    },
    {
      "code" : "3501192251",
      "display" : "漢宗小兒科診所"
    },
    {
      "code" : "3501192368",
      "display" : "陳國賢診所"
    },
    {
      "code" : "3501192402",
      "display" : "嘉生診所"
    },
    {
      "code" : "3501192420",
      "display" : "慧洋診所"
    },
    {
      "code" : "3501192519",
      "display" : "視強眼科診所"
    },
    {
      "code" : "3501192528",
      "display" : "聖約翰婦產科診所"
    },
    {
      "code" : "3501192537",
      "display" : "裕仁診所"
    },
    {
      "code" : "3501192582",
      "display" : "大元婦產科診所"
    },
    {
      "code" : "3501192608",
      "display" : "許孟權小兒科診所"
    },
    {
      "code" : "3501192733",
      "display" : "天行健診所"
    },
    {
      "code" : "3501192779",
      "display" : "中山婦產科診所"
    },
    {
      "code" : "3501192804",
      "display" : "長泰耳鼻喉科診所"
    },
    {
      "code" : "3501192813",
      "display" : "陳嘉銘診所"
    },
    {
      "code" : "3501194166",
      "display" : "新和診所"
    },
    {
      "code" : "3501194237",
      "display" : "維恩耳鼻喉科診所"
    },
    {
      "code" : "3501194291",
      "display" : "萬太診所"
    },
    {
      "code" : "3501194308",
      "display" : "豪診所"
    },
    {
      "code" : "3501194424",
      "display" : "快樂兒童診所"
    },
    {
      "code" : "3501194451",
      "display" : "青年診所"
    },
    {
      "code" : "3501194497",
      "display" : "君怡耳鼻喉科診所"
    },
    {
      "code" : "3501194568",
      "display" : "城中瑪麗安婦產科診所"
    },
    {
      "code" : "3501194577",
      "display" : "新田診所"
    },
    {
      "code" : "3501194595",
      "display" : "萬澤內科診所"
    },
    {
      "code" : "3501194602",
      "display" : "萬嘉耳鼻喉科診所"
    },
    {
      "code" : "3501194648",
      "display" : "光耳鼻喉科診所"
    },
    {
      "code" : "3501194657",
      "display" : "永康診所"
    },
    {
      "code" : "3501194728",
      "display" : "吳明修診所"
    },
    {
      "code" : "3501194835",
      "display" : "佳安診所"
    },
    {
      "code" : "3501194924",
      "display" : "好視多眼科診所"
    },
    {
      "code" : "3501195038",
      "display" : "幸福診所"
    },
    {
      "code" : "3501195136",
      "display" : "雙園診所"
    },
    {
      "code" : "3501195234",
      "display" : "健安診所"
    },
    {
      "code" : "3501195270",
      "display" : "萬華衛康內科診所"
    },
    {
      "code" : "3501195289",
      "display" : "艋舺通安診所"
    },
    {
      "code" : "3501195332",
      "display" : "安興診所"
    },
    {
      "code" : "3501195369",
      "display" : "松柏復健科診所"
    },
    {
      "code" : "3501195449",
      "display" : "吳淑芬眼科診所"
    },
    {
      "code" : "3501195538",
      "display" : "日安診所"
    },
    {
      "code" : "3501195574",
      "display" : "呂松竹診所"
    },
    {
      "code" : "3501195592",
      "display" : "日光眼科診所"
    },
    {
      "code" : "3501195618",
      "display" : "雙和診所"
    },
    {
      "code" : "3501195627",
      "display" : "蔣富強皮膚專科診所"
    },
    {
      "code" : "3501195636",
      "display" : "博昌復健科診所"
    },
    {
      "code" : "3501195663",
      "display" : "光晶妍寶島眼科診所"
    },
    {
      "code" : "3501195690",
      "display" : "瑞生診所"
    },
    {
      "code" : "3501195761",
      "display" : "佳德內科診所"
    },
    {
      "code" : "3501195814",
      "display" : "萬華瀚群骨科診所"
    },
    {
      "code" : "3501195823",
      "display" : "榮順診所"
    },
    {
      "code" : "3501195832",
      "display" : "福全身心科診所"
    },
    {
      "code" : "3501195869",
      "display" : "益銓診所"
    },
    {
      "code" : "3501195903",
      "display" : "黃健勇皮膚科診所"
    },
    {
      "code" : "3501195976",
      "display" : "陽光眼科診所"
    },
    {
      "code" : "3501196008",
      "display" : "萬華身心精神科診所"
    },
    {
      "code" : "3501196044",
      "display" : "明峰診所"
    },
    {
      "code" : "3501196053",
      "display" : "台北透析診所"
    },
    {
      "code" : "3501196062",
      "display" : "麗思醫美診所"
    },
    {
      "code" : "3501196071",
      "display" : "名家耳鼻喉科診所"
    },
    {
      "code" : "3501196080",
      "display" : "和煦診所"
    },
    {
      "code" : "3501196099",
      "display" : "復安診所"
    },
    {
      "code" : "3501196106",
      "display" : "可為診所"
    },
    {
      "code" : "3501196115",
      "display" : "日安診所"
    },
    {
      "code" : "3501196124",
      "display" : "晟祐診所"
    },
    {
      "code" : "3501196142",
      "display" : "東京生活診所"
    },
    {
      "code" : "3501196151",
      "display" : "萬華維沐身心診所"
    },
    {
      "code" : "3501196160",
      "display" : "復安診所"
    },
    {
      "code" : "3501196179",
      "display" : "萬大聖心診所"
    },
    {
      "code" : "3501196188",
      "display" : "新田診所"
    },
    {
      "code" : "3501200249",
      "display" : "仁耀診所"
    },
    {
      "code" : "3501200301",
      "display" : "保順診所"
    },
    {
      "code" : "3501200329",
      "display" : "楊向榮耳鼻喉科診所"
    },
    {
      "code" : "3501200338",
      "display" : "興隆李內兒科診所"
    },
    {
      "code" : "3501200374",
      "display" : "永樂診所"
    },
    {
      "code" : "3501200490",
      "display" : "景美蔡登元婦產科診所"
    },
    {
      "code" : "3501200525",
      "display" : "李聯合診所"
    },
    {
      "code" : "3501200534",
      "display" : "興隆內科小兒科診所"
    },
    {
      "code" : "3501200570",
      "display" : "泓仁診所"
    },
    {
      "code" : "3501200614",
      "display" : "澤文診所"
    },
    {
      "code" : "3501200623",
      "display" : "慈慧內科眼科聯合診所"
    },
    {
      "code" : "3501200703",
      "display" : "普仁診所"
    },
    {
      "code" : "3501200785",
      "display" : "陳建業診所"
    },
    {
      "code" : "3501200794",
      "display" : "林建輝小兒科診所"
    },
    {
      "code" : "3501200838",
      "display" : "瀚霖眼科診所"
    },
    {
      "code" : "3501200856",
      "display" : "瑞杏診所"
    },
    {
      "code" : "3501200927",
      "display" : "景升診所"
    },
    {
      "code" : "3501200954",
      "display" : "健誠診所"
    },
    {
      "code" : "3501200963",
      "display" : "葉洪小兒科診所"
    },
    {
      "code" : "3501200972",
      "display" : "吳錫賢診所"
    },
    {
      "code" : "3501201004",
      "display" : "洪佑承小兒專科診所"
    },
    {
      "code" : "3501201013",
      "display" : "徐文治診所"
    },
    {
      "code" : "3501201031",
      "display" : "晉康復健科診所"
    },
    {
      "code" : "3501201040",
      "display" : "黃皮膚科診所"
    },
    {
      "code" : "3501201086",
      "display" : "陳啟義眼科診所"
    },
    {
      "code" : "3501201095",
      "display" : "德安小兒科診所"
    },
    {
      "code" : "3501201120",
      "display" : "春林復健科診所"
    },
    {
      "code" : "3501201139",
      "display" : "欣民診所"
    },
    {
      "code" : "3501201157",
      "display" : "目欣眼科診所"
    },
    {
      "code" : "3501201219",
      "display" : "官世英診所"
    },
    {
      "code" : "3501201228",
      "display" : "慈幼診所"
    },
    {
      "code" : "3501201237",
      "display" : "平安耳鼻喉科診所"
    },
    {
      "code" : "3501201264",
      "display" : "林醫師診所"
    },
    {
      "code" : "3501202270",
      "display" : "觀心眼科診所"
    },
    {
      "code" : "3501202298",
      "display" : "景福眼科診所"
    },
    {
      "code" : "3501202323",
      "display" : "許至文耳鼻喉科診所"
    },
    {
      "code" : "3501202378",
      "display" : "高鳴傑眼科診所"
    },
    {
      "code" : "3501202458",
      "display" : "屈銘軒小兒科診所"
    },
    {
      "code" : "3501202467",
      "display" : "瑞萱診所"
    },
    {
      "code" : "3501202485",
      "display" : "興隆診所"
    },
    {
      "code" : "3501202501",
      "display" : "漂亮１０１皮膚科診所"
    },
    {
      "code" : "3501202510",
      "display" : "徐慧玲診所"
    },
    {
      "code" : "3501202538",
      "display" : "長欣婦產科診所"
    },
    {
      "code" : "3501202592",
      "display" : "震杰小兒科診所"
    },
    {
      "code" : "3501202618",
      "display" : "愛文診所"
    },
    {
      "code" : "3501202636",
      "display" : "黃偉志小兒科診所"
    },
    {
      "code" : "3501202645",
      "display" : "李信成眼科診所"
    },
    {
      "code" : "3501202654",
      "display" : "世誠耳鼻喉科診所"
    },
    {
      "code" : "3501202725",
      "display" : "景安診所"
    },
    {
      "code" : "3501202743",
      "display" : "房國堂小兒專科診所"
    },
    {
      "code" : "3501202798",
      "display" : "定安診所"
    },
    {
      "code" : "3501202823",
      "display" : "林正豐診所"
    },
    {
      "code" : "3501202850",
      "display" : "文山復健科診所"
    },
    {
      "code" : "3501202869",
      "display" : "聯恩診所"
    },
    {
      "code" : "3501202912",
      "display" : "王令時內科診所"
    },
    {
      "code" : "3501202949",
      "display" : "林坤霖耳鼻喉科診所"
    },
    {
      "code" : "3501202967",
      "display" : "東翰診所"
    },
    {
      "code" : "3501202985",
      "display" : "合康復健科診所"
    },
    {
      "code" : "3501203008",
      "display" : "邱成湦皮膚專科診所"
    },
    {
      "code" : "3501203071",
      "display" : "秀明診所"
    },
    {
      "code" : "3501203080",
      "display" : "秀心診所"
    },
    {
      "code" : "3501203106",
      "display" : "王家庭醫學科診所"
    },
    {
      "code" : "3501203115",
      "display" : "木柵身心診所"
    },
    {
      "code" : "3501203124",
      "display" : "芳馨診所"
    },
    {
      "code" : "3501203151",
      "display" : "全心醫學陳醫師診所"
    },
    {
      "code" : "3501203179",
      "display" : "德康耳鼻喉科診所"
    },
    {
      "code" : "3501203222",
      "display" : "健鑫診所"
    },
    {
      "code" : "3501203259",
      "display" : "樂群耳鼻喉科家醫科診所"
    },
    {
      "code" : "3501203268",
      "display" : "仁荔健康診所"
    },
    {
      "code" : "3501203302",
      "display" : "旭明眼科診所"
    },
    {
      "code" : "3501203311",
      "display" : "璟美眼科診所"
    },
    {
      "code" : "3501203320",
      "display" : "慶如診所"
    },
    {
      "code" : "3501203339",
      "display" : "萬隆力康復健科診所"
    },
    {
      "code" : "3501203357",
      "display" : "大豐耳鼻喉科診所"
    },
    {
      "code" : "3501203375",
      "display" : "明瀚骨科診所"
    },
    {
      "code" : "3501203384",
      "display" : "全心醫學林醫師診所"
    },
    {
      "code" : "3501203393",
      "display" : "和沛身心醫學診所"
    },
    {
      "code" : "3501203419",
      "display" : "黃兆宜曙光診所"
    },
    {
      "code" : "3501203428",
      "display" : "順欣診所"
    },
    {
      "code" : "3501203446",
      "display" : "夏安皮膚專科診所"
    },
    {
      "code" : "3501203455",
      "display" : "佳鴻診所"
    },
    {
      "code" : "3501203464",
      "display" : "誠心身心醫學診所"
    },
    {
      "code" : "3501203473",
      "display" : "欣成診所"
    },
    {
      "code" : "3501203482",
      "display" : "蘇黎世診所"
    },
    {
      "code" : "3501203491",
      "display" : "莊豐賓泌尿科診所"
    },
    {
      "code" : "3501203508",
      "display" : "山林診所"
    },
    {
      "code" : "3501203517",
      "display" : "文山上明眼科診所"
    },
    {
      "code" : "3501203553",
      "display" : "萬隆力康復健科診所"
    },
    {
      "code" : "3501203562",
      "display" : "山林診所"
    },
    {
      "code" : "3501203571",
      "display" : "晶贊眼科診所"
    },
    {
      "code" : "3501203580",
      "display" : "方舟身心診所"
    },
    {
      "code" : "3501203599",
      "display" : "文山上明眼科診所"
    },
    {
      "code" : "3501203606",
      "display" : "明峰診所"
    },
    {
      "code" : "3501203615",
      "display" : "晶贊眼科診所"
    },
    {
      "code" : "3501203633",
      "display" : "達特楊璟美眼科診所"
    },
    {
      "code" : "3501203651",
      "display" : "興隆大豐耳鼻喉科診所"
    },
    {
      "code" : "3511010131",
      "display" : "孫邦松兒內科診所"
    },
    {
      "code" : "3511010140",
      "display" : "陳耳鼻喉科診所"
    },
    {
      "code" : "3511010202",
      "display" : "王立文婦產科診所"
    },
    {
      "code" : "3511010355",
      "display" : "孫眼科診所"
    },
    {
      "code" : "3511010408",
      "display" : "仁人診所"
    },
    {
      "code" : "3511010480",
      "display" : "醫療財團法人臺灣區煤礦業基金會礦工基隆診所"
    },
    {
      "code" : "3511010515",
      "display" : "開山診所"
    },
    {
      "code" : "3511010524",
      "display" : "林承興診所"
    },
    {
      "code" : "3511010551",
      "display" : "王孫斌婦產科診所"
    },
    {
      "code" : "3511010588",
      "display" : "合成診所"
    },
    {
      "code" : "3511010597",
      "display" : "瑞光眼科診所"
    },
    {
      "code" : "3511010631",
      "display" : "黃勉倉醫師骨科診所"
    },
    {
      "code" : "3511010668",
      "display" : "陳益村婦產科診所"
    },
    {
      "code" : "3511010702",
      "display" : "博群診所"
    },
    {
      "code" : "3511011727",
      "display" : "河南眼科診所"
    },
    {
      "code" : "3511011807",
      "display" : "聖母聯合診所"
    },
    {
      "code" : "3511011825",
      "display" : "信光眼科診所"
    },
    {
      "code" : "3511011870",
      "display" : "朱僑光婦幼專科診所"
    },
    {
      "code" : "3511011898",
      "display" : "喬復健科診所"
    },
    {
      "code" : "3511011905",
      "display" : "吳婦產科診所"
    },
    {
      "code" : "3511011932",
      "display" : "陳怡穎皮膚科診所"
    },
    {
      "code" : "3511011950",
      "display" : "兒童中心診所"
    },
    {
      "code" : "3511012028",
      "display" : "禾豐１０１診所"
    },
    {
      "code" : "3511012046",
      "display" : "葛萊美診所"
    },
    {
      "code" : "3511012073",
      "display" : "陳如儀兒科診所"
    },
    {
      "code" : "3511012082",
      "display" : "馬德里診所"
    },
    {
      "code" : "3511012117",
      "display" : "八斗子診所"
    },
    {
      "code" : "3511012126",
      "display" : "立康復健科診所"
    },
    {
      "code" : "3511012135",
      "display" : "傅耳鼻喉科診所"
    },
    {
      "code" : "3511012144",
      "display" : "廖國棟皮膚科診所"
    },
    {
      "code" : "3511012162",
      "display" : "全恩親子眼科診所"
    },
    {
      "code" : "3511012171",
      "display" : "漁工診所"
    },
    {
      "code" : "3511012215",
      "display" : "漾診所"
    },
    {
      "code" : "3511012224",
      "display" : "安瀾診所"
    },
    {
      "code" : "3511012233",
      "display" : "譚景文婦產科診所"
    },
    {
      "code" : "3511012242",
      "display" : "晉安診所"
    },
    {
      "code" : "3511012279",
      "display" : "彗恩診所"
    },
    {
      "code" : "3511012297",
      "display" : "文昕診所"
    },
    {
      "code" : "3511012304",
      "display" : "安大心身心診所"
    },
    {
      "code" : "3511012313",
      "display" : "同仁神經內科診所"
    },
    {
      "code" : "3511020066",
      "display" : "廖內兒科診所"
    },
    {
      "code" : "3511020155",
      "display" : "陳章文耳鼻喉科診所"
    },
    {
      "code" : "3511020226",
      "display" : "紀醫師診所"
    },
    {
      "code" : "3511020235",
      "display" : "佑仁聯合診所"
    },
    {
      "code" : "3511020253",
      "display" : "康寧眼科診所"
    },
    {
      "code" : "3511020333",
      "display" : "西華診所"
    },
    {
      "code" : "3511021429",
      "display" : "健福診所"
    },
    {
      "code" : "3511021518",
      "display" : "康博診所"
    },
    {
      "code" : "3511021536",
      "display" : "全安診所"
    },
    {
      "code" : "3511021545",
      "display" : "群健診所"
    },
    {
      "code" : "3511021563",
      "display" : "和睦家診所"
    },
    {
      "code" : "3511021572",
      "display" : "泰安內科診所"
    },
    {
      "code" : "3511021581",
      "display" : "惠安復健科診所"
    },
    {
      "code" : "3511021590",
      "display" : "祐福診所"
    },
    {
      "code" : "3511021607",
      "display" : "正光診所"
    },
    {
      "code" : "3511021616",
      "display" : "杏福診所"
    },
    {
      "code" : "3511030053",
      "display" : "婁診所"
    },
    {
      "code" : "3511031247",
      "display" : "碇內診所"
    },
    {
      "code" : "3511031256",
      "display" : "康合診所"
    },
    {
      "code" : "3511031265",
      "display" : "鴻海診所"
    },
    {
      "code" : "3511031283",
      "display" : "百會診所"
    },
    {
      "code" : "3511031292",
      "display" : "101診所"
    },
    {
      "code" : "3511040022",
      "display" : "全成內兒科診所"
    },
    {
      "code" : "3511040175",
      "display" : "林小兒科診所"
    },
    {
      "code" : "3511040335",
      "display" : "林內兒科診所"
    },
    {
      "code" : "3511040380",
      "display" : "健安婦產科診所"
    },
    {
      "code" : "3511040399",
      "display" : "東大診所"
    },
    {
      "code" : "3511040406",
      "display" : "陳正時婦產科診所"
    },
    {
      "code" : "3511040479",
      "display" : "李任堅小兒科診所"
    },
    {
      "code" : "3511040488",
      "display" : "黃勝雄診所"
    },
    {
      "code" : "3511040497",
      "display" : "楊外骨科診所"
    },
    {
      "code" : "3511040513",
      "display" : "林耳鼻咽喉科診所"
    },
    {
      "code" : "3511040531",
      "display" : "資耳鼻喉科診所"
    },
    {
      "code" : "3511040620",
      "display" : "洪診所"
    },
    {
      "code" : "3511040639",
      "display" : "王孟俊診所"
    },
    {
      "code" : "3511040666",
      "display" : "魏心臟科診所"
    },
    {
      "code" : "3511040684",
      "display" : "王大夫診所"
    },
    {
      "code" : "3511040693",
      "display" : "楊耳鼻喉科診所"
    },
    {
      "code" : "3511040700",
      "display" : "盧耳鼻喉科診所"
    },
    {
      "code" : "3511040728",
      "display" : "陳興達診所"
    },
    {
      "code" : "3511040764",
      "display" : "羅杰診所"
    },
    {
      "code" : "3511040773",
      "display" : "楊光復健診所"
    },
    {
      "code" : "3511040782",
      "display" : "恆生診所"
    },
    {
      "code" : "3511040791",
      "display" : "孫皮膚科診所"
    },
    {
      "code" : "3511040862",
      "display" : "廖曉俊診所"
    },
    {
      "code" : "3511040871",
      "display" : "王順水小兒科診所"
    },
    {
      "code" : "3511040942",
      "display" : "王俊傑耳鼻喉科診所"
    },
    {
      "code" : "3511040988",
      "display" : "安基診所"
    },
    {
      "code" : "3511041001",
      "display" : "安東耳鼻喉科診所"
    },
    {
      "code" : "3511041047",
      "display" : "懷仁診所"
    },
    {
      "code" : "3511041074",
      "display" : "高士振診所"
    },
    {
      "code" : "3511041083",
      "display" : "元翔診所"
    },
    {
      "code" : "3511041172",
      "display" : "正祥復健科診所"
    },
    {
      "code" : "3511041181",
      "display" : "仁愛診所"
    },
    {
      "code" : "3511041190",
      "display" : "佳安診所"
    },
    {
      "code" : "3511041216",
      "display" : "佳基內科診所"
    },
    {
      "code" : "3511041243",
      "display" : "鄭曦診所"
    },
    {
      "code" : "3511041261",
      "display" : "胡耳鼻喉科診所"
    },
    {
      "code" : "3511041323",
      "display" : "重生診所"
    },
    {
      "code" : "3511041332",
      "display" : "基隆心身心精神科診所"
    },
    {
      "code" : "3511041396",
      "display" : "仁祥診所"
    },
    {
      "code" : "3511041430",
      "display" : "長泰診所"
    },
    {
      "code" : "3511041458",
      "display" : "佳冠內科診所"
    },
    {
      "code" : "3511041467",
      "display" : "江文標皮膚科診所"
    },
    {
      "code" : "3511041476",
      "display" : "松禾診所"
    },
    {
      "code" : "3511041485",
      "display" : "喜聖診所"
    },
    {
      "code" : "3511041501",
      "display" : "平安診所"
    },
    {
      "code" : "3511041510",
      "display" : "孟俊診所"
    },
    {
      "code" : "3511041529",
      "display" : "基隆生基婦產科診所"
    },
    {
      "code" : "3511041538",
      "display" : "基隆骨科診所"
    },
    {
      "code" : "3511041547",
      "display" : "基隆平安診所"
    },
    {
      "code" : "3511041565",
      "display" : "康沛診所"
    },
    {
      "code" : "3511041574",
      "display" : "心慈診所"
    },
    {
      "code" : "3511050028",
      "display" : "安一外科診所"
    },
    {
      "code" : "3511050108",
      "display" : "至誠診所"
    },
    {
      "code" : "3511050215",
      "display" : "蔡敬山診所"
    },
    {
      "code" : "3511050224",
      "display" : "李筱隆耳鼻喉科診所"
    },
    {
      "code" : "3511050260",
      "display" : "林義宏診所"
    },
    {
      "code" : "3511050297",
      "display" : "何朝榮診所"
    },
    {
      "code" : "3511050313",
      "display" : "親親診所"
    },
    {
      "code" : "3511050368",
      "display" : "林文毅婦產科診所"
    },
    {
      "code" : "3511051427",
      "display" : "復興診所"
    },
    {
      "code" : "3511051454",
      "display" : "仁傑小兒專科診所"
    },
    {
      "code" : "3511051481",
      "display" : "聖德診所"
    },
    {
      "code" : "3511051507",
      "display" : "安定診所"
    },
    {
      "code" : "3511051525",
      "display" : "安安診所"
    },
    {
      "code" : "3511051534",
      "display" : "民安診所"
    },
    {
      "code" : "3511051543",
      "display" : "王孫毅耳鼻喉科診所"
    },
    {
      "code" : "3511051552",
      "display" : "大慶診所"
    },
    {
      "code" : "3511051561",
      "display" : "永安診所"
    },
    {
      "code" : "3511051570",
      "display" : "得美膚診所"
    },
    {
      "code" : "3511051589",
      "display" : "萬方診所"
    },
    {
      "code" : "3511060159",
      "display" : "李卓為診所"
    },
    {
      "code" : "3511060202",
      "display" : "濟仁診所"
    },
    {
      "code" : "3511060211",
      "display" : "小普派小兒科診所"
    },
    {
      "code" : "3511061325",
      "display" : "李偉華耳鼻喉科診所"
    },
    {
      "code" : "3511061343",
      "display" : "泓翔耳鼻喉科診所"
    },
    {
      "code" : "3511061414",
      "display" : "百會長庚診所"
    },
    {
      "code" : "3511061450",
      "display" : "大德診所"
    },
    {
      "code" : "3511061469",
      "display" : "胡耿豪身心精神科診所"
    },
    {
      "code" : "3511070048",
      "display" : "仁恩診所"
    },
    {
      "code" : "3511070084",
      "display" : "邱診所"
    },
    {
      "code" : "3511070128",
      "display" : "信義診所"
    },
    {
      "code" : "3511070182",
      "display" : "王式鴻診所"
    },
    {
      "code" : "3511070191",
      "display" : "黃振國診所"
    },
    {
      "code" : "3511071358",
      "display" : "陳醫師診所"
    },
    {
      "code" : "3511071376",
      "display" : "東信診所"
    },
    {
      "code" : "3511071385",
      "display" : "世界診所"
    },
    {
      "code" : "3511071394",
      "display" : "詠欣精神科診所"
    },
    {
      "code" : "3511071401",
      "display" : "瀚翔骨科診所"
    },
    {
      "code" : "3511071410",
      "display" : "國泰家醫診所"
    },
    {
      "code" : "3531010020",
      "display" : "曾耳鼻喉科診所"
    },
    {
      "code" : "3531010137",
      "display" : "周耳鼻喉科診所"
    },
    {
      "code" : "3531010217",
      "display" : "板橋李耳鼻喉科診所"
    },
    {
      "code" : "3531010226",
      "display" : "曾文淵內科家庭醫學科診所"
    },
    {
      "code" : "3531010280",
      "display" : "王英權皮膚科診所"
    },
    {
      "code" : "3531010324",
      "display" : "優生婦產科診所"
    },
    {
      "code" : "3531010333",
      "display" : "李皮膚科診所"
    },
    {
      "code" : "3531010379",
      "display" : "雅音眼科診所"
    },
    {
      "code" : "3531010404",
      "display" : "周文通診所"
    },
    {
      "code" : "3531010557",
      "display" : "徐內科小兒科診所"
    },
    {
      "code" : "3531010691",
      "display" : "春和診所"
    },
    {
      "code" : "3531010744",
      "display" : "陳嘉偉診所"
    },
    {
      "code" : "3531010833",
      "display" : "實踐小兒科內科診所"
    },
    {
      "code" : "3531010879",
      "display" : "詹婦產科診所"
    },
    {
      "code" : "3531010940",
      "display" : "張俊明外科婦科診所"
    },
    {
      "code" : "3531011018",
      "display" : "柯明奇耳鼻喉科診所"
    },
    {
      "code" : "3531011027",
      "display" : "中正診所"
    },
    {
      "code" : "3531011205",
      "display" : "長生外科診所"
    },
    {
      "code" : "3531011223",
      "display" : "樂活醫美診所"
    },
    {
      "code" : "3531011278",
      "display" : "葉婦產科診所"
    },
    {
      "code" : "3531011303",
      "display" : "趙小兒科診所"
    },
    {
      "code" : "3531011330",
      "display" : "龍生診所"
    },
    {
      "code" : "3531011394",
      "display" : "巫世平診所"
    },
    {
      "code" : "3531011456",
      "display" : "愛德診所"
    },
    {
      "code" : "3531011527",
      "display" : "薛松茂內科小兒科診所"
    },
    {
      "code" : "3531011536",
      "display" : "鄧茂雄診所"
    },
    {
      "code" : "3531011590",
      "display" : "姚欽祥外科婦產科診所"
    },
    {
      "code" : "3531011670",
      "display" : "潘內科小兒科診所"
    },
    {
      "code" : "3531011750",
      "display" : "慈蕙診所"
    },
    {
      "code" : "3531011901",
      "display" : "陳恩哲小兒科診所"
    },
    {
      "code" : "3531012024",
      "display" : "黃世鑫診所"
    },
    {
      "code" : "3531012033",
      "display" : "蔡眼科診所"
    },
    {
      "code" : "3531012097",
      "display" : "佑幼小兒科診所"
    },
    {
      "code" : "3531012131",
      "display" : "姜條宗內科診所"
    },
    {
      "code" : "3531012168",
      "display" : "王起釮小兒科診所"
    },
    {
      "code" : "3531012195",
      "display" : "謝坤川診所"
    },
    {
      "code" : "3531012211",
      "display" : "馨杏園婦產科診所"
    },
    {
      "code" : "3531012220",
      "display" : "篤翎診所"
    },
    {
      "code" : "3531012257",
      "display" : "全德耳鼻喉科診所"
    },
    {
      "code" : "3531012337",
      "display" : "黃何耳鼻喉科皮膚科聯合診所"
    },
    {
      "code" : "3531012355",
      "display" : "韓眼科診所"
    },
    {
      "code" : "3531012391",
      "display" : "陳孟潮耳鼻喉科診所"
    },
    {
      "code" : "3531012408",
      "display" : "郭基隆診所"
    },
    {
      "code" : "3531012426",
      "display" : "博愛診所"
    },
    {
      "code" : "3531012435",
      "display" : "林皮膚科診所"
    },
    {
      "code" : "3531012444",
      "display" : "陳正忠小兒科診所"
    },
    {
      "code" : "3531012533",
      "display" : "仁民診所"
    },
    {
      "code" : "3531012560",
      "display" : "蔡榮展耳鼻喉科診所"
    },
    {
      "code" : "3531012588",
      "display" : "聖母診所"
    },
    {
      "code" : "3531012613",
      "display" : "後埔永江診所"
    },
    {
      "code" : "3531012640",
      "display" : "燿星小兒科診所"
    },
    {
      "code" : "3531012668",
      "display" : "幼華診所"
    },
    {
      "code" : "3531012677",
      "display" : "雷世陽婦產科診所"
    },
    {
      "code" : "3531012695",
      "display" : "翰生診所"
    },
    {
      "code" : "3531012702",
      "display" : "日光眼科診所"
    },
    {
      "code" : "3531012766",
      "display" : "蕭奕仁診所"
    },
    {
      "code" : "3531012800",
      "display" : "興德診所"
    },
    {
      "code" : "3531012837",
      "display" : "大川診所"
    },
    {
      "code" : "3531012908",
      "display" : "吳懿蒼小兒科診所"
    },
    {
      "code" : "3531012917",
      "display" : "炳榮診所"
    },
    {
      "code" : "3531012980",
      "display" : "宏文小兒科診所"
    },
    {
      "code" : "3531013003",
      "display" : "陳敏玲內科診所"
    },
    {
      "code" : "3531013012",
      "display" : "余立俊診所"
    },
    {
      "code" : "3531013049",
      "display" : "蔡英傑皮膚科診所"
    },
    {
      "code" : "3531013076",
      "display" : "林國本耳鼻喉科診所"
    },
    {
      "code" : "3531013101",
      "display" : "黃景宏診所"
    },
    {
      "code" : "3531013138",
      "display" : "板聯診所"
    },
    {
      "code" : "3531013156",
      "display" : "顏舜隆小兒科診所"
    },
    {
      "code" : "3531013165",
      "display" : "鴻仁診所"
    },
    {
      "code" : "3531013227",
      "display" : "侯世文診所"
    },
    {
      "code" : "3531013281",
      "display" : "杏林診所"
    },
    {
      "code" : "3531013307",
      "display" : "王憲忠診所"
    },
    {
      "code" : "3531013334",
      "display" : "毅宏耳鼻喉科診所"
    },
    {
      "code" : "3531013343",
      "display" : "曾皮膚科診所"
    },
    {
      "code" : "3531013352",
      "display" : "蕭亦裕鹽光診所"
    },
    {
      "code" : "3531013398",
      "display" : "合信診所"
    },
    {
      "code" : "3531013414",
      "display" : "吳建明小兒科診所"
    },
    {
      "code" : "3531013423",
      "display" : "吳宏誠小兒科診所"
    },
    {
      "code" : "3531013432",
      "display" : "麗暘診所"
    },
    {
      "code" : "3531013478",
      "display" : "廣安診所"
    },
    {
      "code" : "3531013487",
      "display" : "盛強耳鼻喉科診所"
    },
    {
      "code" : "3531013512",
      "display" : "蔡利誠診所"
    },
    {
      "code" : "3531013521",
      "display" : "瑞麟診所"
    },
    {
      "code" : "3531013530",
      "display" : "健誠眼科診所"
    },
    {
      "code" : "3531013567",
      "display" : "龍興診所"
    },
    {
      "code" : "3531013576",
      "display" : "江德賢眼科診所"
    },
    {
      "code" : "3531013683",
      "display" : "江致德皮膚科診所"
    },
    {
      "code" : "3531013763",
      "display" : "昕隆診所"
    },
    {
      "code" : "3531013772",
      "display" : "卓仁維耳鼻喉科診所"
    },
    {
      "code" : "3531013781",
      "display" : "黃頌邦診所"
    },
    {
      "code" : "3531013852",
      "display" : "德民耳鼻喉科診所"
    },
    {
      "code" : "3531013898",
      "display" : "康寶診所"
    },
    {
      "code" : "3531013905",
      "display" : "興安診所"
    },
    {
      "code" : "3531013941",
      "display" : "瑞明眼科診所"
    },
    {
      "code" : "3531013950",
      "display" : "新象眼科診所"
    },
    {
      "code" : "3531013987",
      "display" : "李連成耳鼻喉科診所"
    },
    {
      "code" : "3531015089",
      "display" : "成都診所"
    },
    {
      "code" : "3531015169",
      "display" : "常春聯合診所"
    },
    {
      "code" : "3531015187",
      "display" : "揚明診所"
    },
    {
      "code" : "3531015230",
      "display" : "林弘揚耳鼻喉科診所"
    },
    {
      "code" : "3531015329",
      "display" : "廷華耳鼻喉科診所"
    },
    {
      "code" : "3531015365",
      "display" : "志明診所"
    },
    {
      "code" : "3531015383",
      "display" : "林子敬診所"
    },
    {
      "code" : "3531015463",
      "display" : "板橋諾貝爾眼科診所"
    },
    {
      "code" : "3531015472",
      "display" : "陳尚志診所"
    },
    {
      "code" : "3531015481",
      "display" : "徐小兒科診所"
    },
    {
      "code" : "3531015490",
      "display" : "連建安診所"
    },
    {
      "code" : "3531015570",
      "display" : "新恩眼科診所"
    },
    {
      "code" : "3531015589",
      "display" : "駱耳鼻喉科診所"
    },
    {
      "code" : "3531015598",
      "display" : "基祥西醫診所"
    },
    {
      "code" : "3531015678",
      "display" : "孫三源婦產科家庭醫學科診所"
    },
    {
      "code" : "3531015687",
      "display" : "家樺診所"
    },
    {
      "code" : "3531015758",
      "display" : "宜霖小兒科診所"
    },
    {
      "code" : "3531015810",
      "display" : "重慶耳鼻喉科診所"
    },
    {
      "code" : "3531015865",
      "display" : "憲安診所"
    },
    {
      "code" : "3531015918",
      "display" : "張明輝內科診所"
    },
    {
      "code" : "3531015954",
      "display" : "當代聯合診所"
    },
    {
      "code" : "3531016004",
      "display" : "佳醫診所"
    },
    {
      "code" : "3531016095",
      "display" : "宏元小兒科診所"
    },
    {
      "code" : "3531016102",
      "display" : "雙十鄭林診所"
    },
    {
      "code" : "3531016148",
      "display" : "板橋大學眼科診所"
    },
    {
      "code" : "3531016166",
      "display" : "恩典復健家醫科診所"
    },
    {
      "code" : "3531016219",
      "display" : "吉立診所"
    },
    {
      "code" : "3531016228",
      "display" : "朱傳弘骨科診所"
    },
    {
      "code" : "3531016335",
      "display" : "俊安診所"
    },
    {
      "code" : "3531016353",
      "display" : "志善眼科診所"
    },
    {
      "code" : "3531016406",
      "display" : "昇陽診所"
    },
    {
      "code" : "3531016433",
      "display" : "熊明旺耳鼻喉科診所"
    },
    {
      "code" : "3531016442",
      "display" : "福星耳鼻喉科診所"
    },
    {
      "code" : "3531016460",
      "display" : "板橋民富皮膚科診所"
    },
    {
      "code" : "3531016479",
      "display" : "黃外科診所"
    },
    {
      "code" : "3531016488",
      "display" : "建佑診所"
    },
    {
      "code" : "3531016504",
      "display" : "合康婦產科診所"
    },
    {
      "code" : "3531016513",
      "display" : "徐自菱皮膚科診所"
    },
    {
      "code" : "3531016540",
      "display" : "樹仁診所"
    },
    {
      "code" : "3531016568",
      "display" : "王林小兒科診所"
    },
    {
      "code" : "3531016577",
      "display" : "何皮膚科診所"
    },
    {
      "code" : "3531016620",
      "display" : "大佳診所"
    },
    {
      "code" : "3531016639",
      "display" : "健康家庭醫學科診所"
    },
    {
      "code" : "3531016666",
      "display" : "楊思亮診所"
    },
    {
      "code" : "3531016675",
      "display" : "立誠骨科診所"
    },
    {
      "code" : "3531016719",
      "display" : "聯德診所"
    },
    {
      "code" : "3531016782",
      "display" : "弘安耳鼻喉科診所"
    },
    {
      "code" : "3531016791",
      "display" : "名冠診所"
    },
    {
      "code" : "3531016817",
      "display" : "溫大慶小兒科診所"
    },
    {
      "code" : "3531016826",
      "display" : "嘉齡診所"
    },
    {
      "code" : "3531016862",
      "display" : "耀安小兒科診所"
    },
    {
      "code" : "3531016871",
      "display" : "板橋信合美眼科診所"
    },
    {
      "code" : "3531016880",
      "display" : "瑞信眼科診所"
    },
    {
      "code" : "3531016906",
      "display" : "吉仁醫病相談診所"
    },
    {
      "code" : "3531016915",
      "display" : "進益診所"
    },
    {
      "code" : "3531016924",
      "display" : "成安診所"
    },
    {
      "code" : "3531016960",
      "display" : "仁謙診所"
    },
    {
      "code" : "3531017010",
      "display" : "陳榮泰小兒科診所"
    },
    {
      "code" : "3531017056",
      "display" : "瑞誠眼科診所"
    },
    {
      "code" : "3531017083",
      "display" : "樂福診所"
    },
    {
      "code" : "3531017145",
      "display" : "博恩泌尿科外科診所"
    },
    {
      "code" : "3531017181",
      "display" : "楊孟達身心精神科診所"
    },
    {
      "code" : "3531017207",
      "display" : "仁佑耳鼻喉科診所"
    },
    {
      "code" : "3531017217",
      "display" : "板橋長榮診所"
    },
    {
      "code" : "3531017235",
      "display" : "趙昭明皮膚科診所"
    },
    {
      "code" : "3531017270",
      "display" : "板橋安媞婦產科診所"
    },
    {
      "code" : "3531017298",
      "display" : "張博揚小兒科診所"
    },
    {
      "code" : "3531017305",
      "display" : "欣心診所"
    },
    {
      "code" : "3531017332",
      "display" : "晟揚骨科診所"
    },
    {
      "code" : "3531017369",
      "display" : "安慶診所"
    },
    {
      "code" : "3531017396",
      "display" : "翠豐診所"
    },
    {
      "code" : "3531017412",
      "display" : "全生診所"
    },
    {
      "code" : "3531017421",
      "display" : "板橋大愛眼科診所"
    },
    {
      "code" : "3531017430",
      "display" : "宏益信合美診所"
    },
    {
      "code" : "3531017476",
      "display" : "正陽骨科診所"
    },
    {
      "code" : "3531017494",
      "display" : "和安診所"
    },
    {
      "code" : "3531017574",
      "display" : "建明診所"
    },
    {
      "code" : "3531017583",
      "display" : "菡生婦幼診所"
    },
    {
      "code" : "3531017645",
      "display" : "樂為診所"
    },
    {
      "code" : "3531017672",
      "display" : "欣幼婦產科診所"
    },
    {
      "code" : "3531017690",
      "display" : "板橋黃皮膚科診所"
    },
    {
      "code" : "3531017725",
      "display" : "北陽骨科診所"
    },
    {
      "code" : "3531017752",
      "display" : "德一診所"
    },
    {
      "code" : "3531017761",
      "display" : "樂欣診所"
    },
    {
      "code" : "3531017805",
      "display" : "丞志耳鼻喉診所"
    },
    {
      "code" : "3531017814",
      "display" : "佳誠診所"
    },
    {
      "code" : "3531017832",
      "display" : "漢生診所"
    },
    {
      "code" : "3531017850",
      "display" : "兒林小兒科診所"
    },
    {
      "code" : "3531017878",
      "display" : "鄭仕程診所"
    },
    {
      "code" : "3531017903",
      "display" : "陳志洪診所"
    },
    {
      "code" : "3531017912",
      "display" : "林儀文婦產科診所"
    },
    {
      "code" : "3531017921",
      "display" : "張英睿皮膚專科診所"
    },
    {
      "code" : "3531017958",
      "display" : "晨陽診所"
    },
    {
      "code" : "3531017976",
      "display" : "周延隆耳鼻喉科診所"
    },
    {
      "code" : "3531018008",
      "display" : "尚品皮膚科診所"
    },
    {
      "code" : "3531018044",
      "display" : "佑恩小兒科診所"
    },
    {
      "code" : "3531018062",
      "display" : "莒光診所"
    },
    {
      "code" : "3531018099",
      "display" : "和謙診所"
    },
    {
      "code" : "3531018115",
      "display" : "大新復健科診所"
    },
    {
      "code" : "3531018133",
      "display" : "禾安診所"
    },
    {
      "code" : "3531018160",
      "display" : "放開心身心精神科診所"
    },
    {
      "code" : "3531018197",
      "display" : "大鈞診所"
    },
    {
      "code" : "3531018204",
      "display" : "嘉恩診所"
    },
    {
      "code" : "3531018311",
      "display" : "順心診所"
    },
    {
      "code" : "3531018357",
      "display" : "榮恩診所"
    },
    {
      "code" : "3531018400",
      "display" : "榮新診所"
    },
    {
      "code" : "3531018491",
      "display" : "懷諾診所"
    },
    {
      "code" : "3531018508",
      "display" : "佑福診所"
    },
    {
      "code" : "3531018526",
      "display" : "品安診所"
    },
    {
      "code" : "3531018553",
      "display" : "喜樂診所"
    },
    {
      "code" : "3531018615",
      "display" : "辰元復健科診所"
    },
    {
      "code" : "3531018624",
      "display" : "重心診所"
    },
    {
      "code" : "3531018633",
      "display" : "幸怡診所"
    },
    {
      "code" : "3531018642",
      "display" : "板橋光澤診所"
    },
    {
      "code" : "3531018679",
      "display" : "鄭仁瑋耳鼻喉科診所"
    },
    {
      "code" : "3531018722",
      "display" : "裕民診所"
    },
    {
      "code" : "3531018740",
      "display" : "嘉禾診所"
    },
    {
      "code" : "3531018759",
      "display" : "實健診所"
    },
    {
      "code" : "3531018786",
      "display" : "安欣診所"
    },
    {
      "code" : "3531018820",
      "display" : "利人診所"
    },
    {
      "code" : "3531018839",
      "display" : "晨益診所"
    },
    {
      "code" : "3531018893",
      "display" : "坤隆診所"
    },
    {
      "code" : "3531018900",
      "display" : "臣雄診所"
    },
    {
      "code" : "3531018919",
      "display" : "佳愛診所"
    },
    {
      "code" : "3531018928",
      "display" : "仁禾診所"
    },
    {
      "code" : "3531018946",
      "display" : "劉宜光診所"
    },
    {
      "code" : "3531018973",
      "display" : "板橋仁安內科診所"
    },
    {
      "code" : "3531018991",
      "display" : "蕭正輝兒科診所"
    },
    {
      "code" : "3531019005",
      "display" : "晴天家醫科診所"
    },
    {
      "code" : "3531019014",
      "display" : "晴天耳鼻喉科診所"
    },
    {
      "code" : "3531019023",
      "display" : "劉仲彥皮膚專科診所"
    },
    {
      "code" : "3531019032",
      "display" : "京澄皮膚專科診所"
    },
    {
      "code" : "3531019069",
      "display" : "燦明大學眼科診所"
    },
    {
      "code" : "3531019096",
      "display" : "昌弘復健科診所"
    },
    {
      "code" : "3531019112",
      "display" : "健心復健科診所"
    },
    {
      "code" : "3531019130",
      "display" : "大庭診所"
    },
    {
      "code" : "3531019149",
      "display" : "陳正傑骨科診所"
    },
    {
      "code" : "3531019167",
      "display" : "喬美整形外科博仕診所"
    },
    {
      "code" : "3531019176",
      "display" : "蔡明志小兒專科診所"
    },
    {
      "code" : "3531019185",
      "display" : "傑生婦產科診所"
    },
    {
      "code" : "3531019201",
      "display" : "基生婦產科診所"
    },
    {
      "code" : "3531019247",
      "display" : "文瑞診所"
    },
    {
      "code" : "3531019274",
      "display" : "長宏骨科診所"
    },
    {
      "code" : "3531019283",
      "display" : "佳恩耳鼻喉科診所"
    },
    {
      "code" : "3531019318",
      "display" : "心世界身心精神科診所"
    },
    {
      "code" : "3531019327",
      "display" : "方舟復健科診所"
    },
    {
      "code" : "3531019336",
      "display" : "俊亨內科診所"
    },
    {
      "code" : "3531019407",
      "display" : "樂田耳鼻喉科診所"
    },
    {
      "code" : "3531019416",
      "display" : "維力骨科診所"
    },
    {
      "code" : "3531019443",
      "display" : "王祥冠耳鼻喉科診所"
    },
    {
      "code" : "3531019452",
      "display" : "新埔立安診所"
    },
    {
      "code" : "3531019461",
      "display" : "康宏骨科診所"
    },
    {
      "code" : "3531019470",
      "display" : "遠興婦產科診所"
    },
    {
      "code" : "3531019505",
      "display" : "豐禾婦產科診所"
    },
    {
      "code" : "3531019532",
      "display" : "里安診所"
    },
    {
      "code" : "3531019550",
      "display" : "高端眼科診所"
    },
    {
      "code" : "3531019578",
      "display" : "原力復健科診所"
    },
    {
      "code" : "3531019587",
      "display" : "板杏內科診所"
    },
    {
      "code" : "3531019603",
      "display" : "樂澄診所"
    },
    {
      "code" : "3531019612",
      "display" : "府中讚美診所"
    },
    {
      "code" : "3531019658",
      "display" : "昌禾骨科診所"
    },
    {
      "code" : "3531019694",
      "display" : "板橋四維親子診所"
    },
    {
      "code" : "3531019710",
      "display" : "安泰淞鶴診所"
    },
    {
      "code" : "3531019729",
      "display" : "板橋四維皮膚科診所"
    },
    {
      "code" : "3531019738",
      "display" : "板橋四維內科診所"
    },
    {
      "code" : "3531019747",
      "display" : "悅安心復健專科診所"
    },
    {
      "code" : "3531019756",
      "display" : "昕新智慧診所"
    },
    {
      "code" : "3531019765",
      "display" : "全泰診所"
    },
    {
      "code" : "3531019774",
      "display" : "幸福身心精神科診所"
    },
    {
      "code" : "3531019783",
      "display" : "信德診所"
    },
    {
      "code" : "3531019792",
      "display" : "佳腎內科診所"
    },
    {
      "code" : "3531019845",
      "display" : "合誼診所"
    },
    {
      "code" : "3531019863",
      "display" : "板橋四維親子診所"
    },
    {
      "code" : "3531019872",
      "display" : "陳智宏診所"
    },
    {
      "code" : "3531019881",
      "display" : "和一診所"
    },
    {
      "code" : "3531019890",
      "display" : "高端眼科診所"
    },
    {
      "code" : "3531019907",
      "display" : "板橋親親家庭診所"
    },
    {
      "code" : "3531019916",
      "display" : "療寮診所"
    },
    {
      "code" : "3531019925",
      "display" : "謙禾家醫診所"
    },
    {
      "code" : "3531019934",
      "display" : "明品診所"
    },
    {
      "code" : "3531019943",
      "display" : "板橋四維親子診所"
    },
    {
      "code" : "3531019970",
      "display" : "板橋諾貝爾皮膚科美學診所"
    },
    {
      "code" : "353101A011",
      "display" : "合誼診所"
    },
    {
      "code" : "353101A020",
      "display" : "向陽澄思診所"
    },
    {
      "code" : "353101A039",
      "display" : "立竹診所"
    },
    {
      "code" : "353101A048",
      "display" : "安胃診所"
    },
    {
      "code" : "353101A057",
      "display" : "南雅復健科診所"
    },
    {
      "code" : "353101A066",
      "display" : "安泰淞鶴診所"
    },
    {
      "code" : "353101A075",
      "display" : "實健診所"
    },
    {
      "code" : "353101A093",
      "display" : "序康診所"
    },
    {
      "code" : "353101A100",
      "display" : "穎泰診所"
    },
    {
      "code" : "353101A119",
      "display" : "生生優動板橋診所"
    },
    {
      "code" : "353101A137",
      "display" : "皮醫師皮膚專科診所"
    },
    {
      "code" : "353101A146",
      "display" : "合誼診所"
    },
    {
      "code" : "353101A155",
      "display" : "加妃整形外科診所"
    },
    {
      "code" : "353101A164",
      "display" : "豐禾婦產科診所"
    },
    {
      "code" : "353101A182",
      "display" : "憲忠診所"
    },
    {
      "code" : "353101A208",
      "display" : "誠悅耳鼻喉科診所"
    },
    {
      "code" : "353101A217",
      "display" : "研知診所"
    },
    {
      "code" : "353101A253",
      "display" : "振安診所"
    },
    {
      "code" : "353101A262",
      "display" : "振侒診所"
    },
    {
      "code" : "353101A271",
      "display" : "藝群板橋診所"
    },
    {
      "code" : "353101A280",
      "display" : "達特楊眼科診所"
    },
    {
      "code" : "353101A299",
      "display" : "勁安骨科診所"
    },
    {
      "code" : "353101A315",
      "display" : "安泰淞鶴診所"
    },
    {
      "code" : "353101A324",
      "display" : "豐禾文化婦產科診所"
    },
    {
      "code" : "353101A342",
      "display" : "安泰淞鶴診所"
    },
    {
      "code" : "353101A388",
      "display" : "逸家診所"
    },
    {
      "code" : "353101A397",
      "display" : "樂為診所"
    },
    {
      "code" : "353101A404",
      "display" : "研知診所"
    },
    {
      "code" : "353101A413",
      "display" : "板橋親親家庭診所"
    },
    {
      "code" : "353101A422",
      "display" : "茂盛板橋生殖診所"
    },
    {
      "code" : "353101A431",
      "display" : "加妃整形外科診所"
    },
    {
      "code" : "353101A440",
      "display" : "板橋光澤診所"
    },
    {
      "code" : "353101A459",
      "display" : "佳醫診所"
    },
    {
      "code" : "353101A468",
      "display" : "宏遠骨科診所"
    },
    {
      "code" : "353101A477",
      "display" : "新板婦產科診所"
    },
    {
      "code" : "353101A486",
      "display" : "海山診所"
    },
    {
      "code" : "353101A495",
      "display" : "正家診所"
    },
    {
      "code" : "353101A502",
      "display" : "悠越親子耳鼻喉科診所"
    },
    {
      "code" : "353101A511",
      "display" : "心越親子耳鼻喉科診所"
    },
    {
      "code" : "353101A539",
      "display" : "板橋醫憲診所"
    },
    {
      "code" : "353101A548",
      "display" : "元氣診所"
    },
    {
      "code" : "353101A557",
      "display" : "海山診所"
    },
    {
      "code" : "353101A566",
      "display" : "樂佳診所"
    },
    {
      "code" : "353101A575",
      "display" : "荃康診所"
    },
    {
      "code" : "353101A584",
      "display" : "板橋高美泌尿科診所"
    },
    {
      "code" : "353101A600",
      "display" : "心海山診所"
    },
    {
      "code" : "353101A628",
      "display" : "研知診所"
    },
    {
      "code" : "353101A637",
      "display" : "板橋澄清眼科診所"
    },
    {
      "code" : "353101A655",
      "display" : "方舟復健科診所"
    },
    {
      "code" : "353101A664",
      "display" : "山木耳鼻喉科診所"
    },
    {
      "code" : "353101A673",
      "display" : "日新親子診所"
    },
    {
      "code" : "353101A691",
      "display" : "德清診所"
    },
    {
      "code" : "353101A708",
      "display" : "板橋安媞婦產科診所"
    },
    {
      "code" : "353101A744",
      "display" : "童話皮膚專科診所"
    },
    {
      "code" : "353101A753",
      "display" : "樂洋診所"
    },
    {
      "code" : "353101A762",
      "display" : "板橋博診所"
    },
    {
      "code" : "353101A780",
      "display" : "裕心診所"
    },
    {
      "code" : "353101A799",
      "display" : "遠興婦產科診所"
    },
    {
      "code" : "353101A806",
      "display" : "明辰診所"
    },
    {
      "code" : "353101A815",
      "display" : "板橋澄清眼科診所"
    },
    {
      "code" : "353101A833",
      "display" : "宏遠骨科診所"
    },
    {
      "code" : "353101A842",
      "display" : "板聯診所"
    },
    {
      "code" : "353101A851",
      "display" : "板橋怡兒診所"
    },
    {
      "code" : "353101A860",
      "display" : "星幸福美學板橋診所"
    },
    {
      "code" : "353101A879",
      "display" : "坤隆診所"
    },
    {
      "code" : "353101A888",
      "display" : "板橋上明眼科診所"
    },
    {
      "code" : "353101A904",
      "display" : "振銨診所"
    },
    {
      "code" : "353101A922",
      "display" : "板橋德威內科診所"
    },
    {
      "code" : "353101A931",
      "display" : "沐林親子診所"
    },
    {
      "code" : "353101A940",
      "display" : "愛美膚診所"
    },
    {
      "code" : "3531020062",
      "display" : "賴明志婦產科診所"
    },
    {
      "code" : "3531020080",
      "display" : "蘇炫明外科診所"
    },
    {
      "code" : "3531020286",
      "display" : "重德耳鼻喉科診所"
    },
    {
      "code" : "3531020302",
      "display" : "宏誠診所"
    },
    {
      "code" : "3531020357",
      "display" : "趙堅婦產科診所"
    },
    {
      "code" : "3531020384",
      "display" : "美視眼科診所"
    },
    {
      "code" : "3531020400",
      "display" : "李祥德診所"
    },
    {
      "code" : "3531020508",
      "display" : "郭國鐘小兒科診所"
    },
    {
      "code" : "3531020544",
      "display" : "陳耀宗診所"
    },
    {
      "code" : "3531020660",
      "display" : "三民家庭醫學科診所"
    },
    {
      "code" : "3531020786",
      "display" : "李兆政診所"
    },
    {
      "code" : "3531020795",
      "display" : "陳內科小兒科診所"
    },
    {
      "code" : "3531020811",
      "display" : "友祥外科診所"
    },
    {
      "code" : "3531020884",
      "display" : "洪文武診所"
    },
    {
      "code" : "3531021069",
      "display" : "同仁內科小兒科診所"
    },
    {
      "code" : "3531021096",
      "display" : "施芳文內科小兒科診所"
    },
    {
      "code" : "3531021112",
      "display" : "慶安診所"
    },
    {
      "code" : "3531021130",
      "display" : "莊裕安內科診所"
    },
    {
      "code" : "3531021283",
      "display" : "李進忠診所"
    },
    {
      "code" : "3531021354",
      "display" : "厚德診所"
    },
    {
      "code" : "3531021363",
      "display" : "翁華宗小兒科診所"
    },
    {
      "code" : "3531021407",
      "display" : "鄭俊堂診所"
    },
    {
      "code" : "3531021461",
      "display" : "吉田診所"
    },
    {
      "code" : "3531021489",
      "display" : "歐維藩診所"
    },
    {
      "code" : "3531021505",
      "display" : "重仁診所"
    },
    {
      "code" : "3531021532",
      "display" : "游眼科診所"
    },
    {
      "code" : "3531021630",
      "display" : "宏鴻診所"
    },
    {
      "code" : "3531021649",
      "display" : "洪小兒科診所"
    },
    {
      "code" : "3531021747",
      "display" : "聖仁皮膚科診所"
    },
    {
      "code" : "3531021765",
      "display" : "江建中皮膚科診所"
    },
    {
      "code" : "3531021783",
      "display" : "金台診所"
    },
    {
      "code" : "3531021872",
      "display" : "建人診所"
    },
    {
      "code" : "3531021934",
      "display" : "鴻璋婦產科診所"
    },
    {
      "code" : "3531021998",
      "display" : "連眼科診所"
    },
    {
      "code" : "3531022011",
      "display" : "銘泰診所"
    },
    {
      "code" : "3531022039",
      "display" : "王立德婦產科診所"
    },
    {
      "code" : "3531022093",
      "display" : "仁新小兒科診所"
    },
    {
      "code" : "3531022100",
      "display" : "医力耳鼻喉科診所"
    },
    {
      "code" : "3531022119",
      "display" : "三和診所"
    },
    {
      "code" : "3531022208",
      "display" : "德慈聯合診所"
    },
    {
      "code" : "3531022226",
      "display" : "九如聯合診所"
    },
    {
      "code" : "3531022244",
      "display" : "鄭智雄診所"
    },
    {
      "code" : "3531022262",
      "display" : "陳銘賢診所"
    },
    {
      "code" : "3531022333",
      "display" : "德澤診所"
    },
    {
      "code" : "3531022342",
      "display" : "林永權耳鼻喉科診所"
    },
    {
      "code" : "3531022397",
      "display" : "江幸蓉皮膚科診所"
    },
    {
      "code" : "3531022459",
      "display" : "正一耳鼻喉科診所"
    },
    {
      "code" : "3531022502",
      "display" : "梁耳鼻喉科診所"
    },
    {
      "code" : "3531022520",
      "display" : "三重台新診所"
    },
    {
      "code" : "3531022557",
      "display" : "吾佳診所"
    },
    {
      "code" : "3531022600",
      "display" : "江村聯合診所"
    },
    {
      "code" : "3531022664",
      "display" : "良安診所"
    },
    {
      "code" : "3531022673",
      "display" : "呂恆明皮膚科診所"
    },
    {
      "code" : "3531022708",
      "display" : "三重博愛診所"
    },
    {
      "code" : "3531022717",
      "display" : "智信診所"
    },
    {
      "code" : "3531022735",
      "display" : "至安診所"
    },
    {
      "code" : "3531022744",
      "display" : "金港齡小兒科診所"
    },
    {
      "code" : "3531022771",
      "display" : "佳仁診所"
    },
    {
      "code" : "3531022780",
      "display" : "周宏法診所"
    },
    {
      "code" : "3531022815",
      "display" : "吳英芳診所"
    },
    {
      "code" : "3531022922",
      "display" : "侯外科診所"
    },
    {
      "code" : "3531022940",
      "display" : "靜明眼科診所"
    },
    {
      "code" : "3531022959",
      "display" : "李烈委診所"
    },
    {
      "code" : "3531022995",
      "display" : "游奐倫診所"
    },
    {
      "code" : "3531023045",
      "display" : "俊元診所"
    },
    {
      "code" : "3531023054",
      "display" : "德恩診所"
    },
    {
      "code" : "3531024060",
      "display" : "索南婦產科診所"
    },
    {
      "code" : "3531024122",
      "display" : "保順聯合診所"
    },
    {
      "code" : "3531024140",
      "display" : "明安婦產科診所"
    },
    {
      "code" : "3531024186",
      "display" : "謝明宏小兒科診所"
    },
    {
      "code" : "3531024220",
      "display" : "聰明耳鼻喉科診所"
    },
    {
      "code" : "3531024239",
      "display" : "簡修平診所"
    },
    {
      "code" : "3531024328",
      "display" : "正義眼科診所"
    },
    {
      "code" : "3531024408",
      "display" : "東和婦產科家庭醫學科診所"
    },
    {
      "code" : "3531024417",
      "display" : "欣宏診所"
    },
    {
      "code" : "3531024444",
      "display" : "錫安婦產科內科診所"
    },
    {
      "code" : "3531024453",
      "display" : "新視界診所"
    },
    {
      "code" : "3531024462",
      "display" : "德河聯合診所"
    },
    {
      "code" : "3531024506",
      "display" : "杏華診所"
    },
    {
      "code" : "3531024533",
      "display" : "重揚診所"
    },
    {
      "code" : "3531024613",
      "display" : "世鴻耳鼻喉科小兒科聯合診所"
    },
    {
      "code" : "3531024640",
      "display" : "輝德診所"
    },
    {
      "code" : "3531024668",
      "display" : "集美診所"
    },
    {
      "code" : "3531024711",
      "display" : "康全診所"
    },
    {
      "code" : "3531024766",
      "display" : "高柏森耳鼻喉科診所"
    },
    {
      "code" : "3531024775",
      "display" : "敦和診所"
    },
    {
      "code" : "3531024864",
      "display" : "賴美里診所"
    },
    {
      "code" : "3531024882",
      "display" : "三重祥安診所"
    },
    {
      "code" : "3531024935",
      "display" : "惠心婦幼診所"
    },
    {
      "code" : "3531024971",
      "display" : "林偉欣眼科診所"
    },
    {
      "code" : "3531024999",
      "display" : "和平診所"
    },
    {
      "code" : "3531025003",
      "display" : "安禾診所"
    },
    {
      "code" : "3531025067",
      "display" : "德心診所"
    },
    {
      "code" : "3531025085",
      "display" : "江生診所"
    },
    {
      "code" : "3531025101",
      "display" : "合健診所"
    },
    {
      "code" : "3531025110",
      "display" : "仁愛診所"
    },
    {
      "code" : "3531025147",
      "display" : "天亮耳鼻喉科診所"
    },
    {
      "code" : "3531025156",
      "display" : "洋基耳鼻喉科診所"
    },
    {
      "code" : "3531025183",
      "display" : "安安兒童診所"
    },
    {
      "code" : "3531025192",
      "display" : "五華眼科診所"
    },
    {
      "code" : "3531025227",
      "display" : "美上美皮膚科診所"
    },
    {
      "code" : "3531025245",
      "display" : "林慶宗耳鼻喉科診所"
    },
    {
      "code" : "3531025254",
      "display" : "龍華診所"
    },
    {
      "code" : "3531025281",
      "display" : "陳信任精神科診所"
    },
    {
      "code" : "3531025290",
      "display" : "明安耳鼻喉科診所"
    },
    {
      "code" : "3531025307",
      "display" : "詹益智耳鼻喉科診所"
    },
    {
      "code" : "3531025316",
      "display" : "大愛眼科診所"
    },
    {
      "code" : "3531025325",
      "display" : "及美眼科診所"
    },
    {
      "code" : "3531025352",
      "display" : "丁婦產科診所"
    },
    {
      "code" : "3531025361",
      "display" : "仁暉診所"
    },
    {
      "code" : "3531025389",
      "display" : "重新診所"
    },
    {
      "code" : "3531025398",
      "display" : "瑞和耳鼻喉科診所"
    },
    {
      "code" : "3531025405",
      "display" : "三重大學眼科診所"
    },
    {
      "code" : "3531025423",
      "display" : "采新婦幼診所"
    },
    {
      "code" : "3531025432",
      "display" : "輝鴻診所"
    },
    {
      "code" : "3531025441",
      "display" : "建宏骨科診所"
    },
    {
      "code" : "3531025469",
      "display" : "張必正診所"
    },
    {
      "code" : "3531025503",
      "display" : "群康復健診所"
    },
    {
      "code" : "3531025512",
      "display" : "健安骨科診所"
    },
    {
      "code" : "3531025530",
      "display" : "李瑞相診所"
    },
    {
      "code" : "3531025601",
      "display" : "張欽堯小兒科診所"
    },
    {
      "code" : "3531025610",
      "display" : "健福診所"
    },
    {
      "code" : "3531025629",
      "display" : "維德骨科診所"
    },
    {
      "code" : "3531025647",
      "display" : "仁馨診所"
    },
    {
      "code" : "3531025674",
      "display" : "大有診所"
    },
    {
      "code" : "3531025683",
      "display" : "林南診所"
    },
    {
      "code" : "3531025709",
      "display" : "康新診所"
    },
    {
      "code" : "3531025718",
      "display" : "康歆診所"
    },
    {
      "code" : "3531025790",
      "display" : "康昕診所"
    },
    {
      "code" : "3531025825",
      "display" : "京辰耳鼻喉科診所"
    },
    {
      "code" : "3531025843",
      "display" : "慈田診所"
    },
    {
      "code" : "3531025852",
      "display" : "信林大學眼科診所"
    },
    {
      "code" : "3531025861",
      "display" : "益安診所"
    },
    {
      "code" : "3531025889",
      "display" : "宏生診所"
    },
    {
      "code" : "3531025932",
      "display" : "達昇皮膚科診所"
    },
    {
      "code" : "3531025987",
      "display" : "介壽耳鼻喉科診所"
    },
    {
      "code" : "3531026046",
      "display" : "兆興診所"
    },
    {
      "code" : "3531026055",
      "display" : "安興精神科診所"
    },
    {
      "code" : "3531026073",
      "display" : "三重新好診所"
    },
    {
      "code" : "3531026082",
      "display" : "固的診所"
    },
    {
      "code" : "3531026091",
      "display" : "展源內科診所"
    },
    {
      "code" : "3531026108",
      "display" : "長壽耳鼻喉科診所"
    },
    {
      "code" : "3531026171",
      "display" : "仁佳診所"
    },
    {
      "code" : "3531026180",
      "display" : "美麗心成人兒童精神科診所"
    },
    {
      "code" : "3531026206",
      "display" : "正興診所"
    },
    {
      "code" : "3531026224",
      "display" : "宏通診所"
    },
    {
      "code" : "3531026233",
      "display" : "大有診所"
    },
    {
      "code" : "3531026242",
      "display" : "政義診所"
    },
    {
      "code" : "3531026251",
      "display" : "德生診所"
    },
    {
      "code" : "3531026260",
      "display" : "正和診所"
    },
    {
      "code" : "3531026288",
      "display" : "華貞診所"
    },
    {
      "code" : "3531026297",
      "display" : "柯瑞宏皮膚專科診所"
    },
    {
      "code" : "3531026304",
      "display" : "惠心婦產科小兒科診所"
    },
    {
      "code" : "3531026340",
      "display" : "正義骨科診所"
    },
    {
      "code" : "3531026359",
      "display" : "集勇復健科診所"
    },
    {
      "code" : "3531026368",
      "display" : "康倍耳鼻喉科診所"
    },
    {
      "code" : "3531026377",
      "display" : "幸聲耳鼻喉科診所"
    },
    {
      "code" : "3531026395",
      "display" : "膚麗康診所"
    },
    {
      "code" : "3531026402",
      "display" : "三重華泰診所"
    },
    {
      "code" : "3531026420",
      "display" : "皇嘉耳鼻喉科診所"
    },
    {
      "code" : "3531026475",
      "display" : "維德徐匯診所"
    },
    {
      "code" : "3531026493",
      "display" : "德儀皮膚專科診所"
    },
    {
      "code" : "3531026500",
      "display" : "活力復健診所"
    },
    {
      "code" : "3531026519",
      "display" : "大榮耳鼻喉科診所"
    },
    {
      "code" : "3531026537",
      "display" : "三重正義北好評診所"
    },
    {
      "code" : "3531026546",
      "display" : "曜弘診所"
    },
    {
      "code" : "3531026555",
      "display" : "孔繁錦診所"
    },
    {
      "code" : "3531026564",
      "display" : "艾樂堡診所"
    },
    {
      "code" : "3531026573",
      "display" : "皮醫師診所"
    },
    {
      "code" : "3531026582",
      "display" : "友孝診所"
    },
    {
      "code" : "3531026591",
      "display" : "新生活復健科診所"
    },
    {
      "code" : "3531026617",
      "display" : "富康診所"
    },
    {
      "code" : "3531026626",
      "display" : "德謙皮膚科診所"
    },
    {
      "code" : "3531026635",
      "display" : "華謙家醫科診所"
    },
    {
      "code" : "3531026662",
      "display" : "兆興診所"
    },
    {
      "code" : "3531026671",
      "display" : "友孝診所"
    },
    {
      "code" : "3531026680",
      "display" : "培力佳診所"
    },
    {
      "code" : "3531026706",
      "display" : "正興診所"
    },
    {
      "code" : "3531026715",
      "display" : "新生活復健科診所"
    },
    {
      "code" : "3531026724",
      "display" : "佳禾透析診所"
    },
    {
      "code" : "3531026733",
      "display" : "愷馨耳鼻喉科診所"
    },
    {
      "code" : "3531026742",
      "display" : "德維復健科診所"
    },
    {
      "code" : "3531026751",
      "display" : "長泰診所"
    },
    {
      "code" : "3531026760",
      "display" : "葉家伶婦產科診所"
    },
    {
      "code" : "3531026779",
      "display" : "得恩診所"
    },
    {
      "code" : "3531026788",
      "display" : "皮醫師診所"
    },
    {
      "code" : "3531026797",
      "display" : "天亮診所"
    },
    {
      "code" : "3531026804",
      "display" : "同安診所"
    },
    {
      "code" : "3531026813",
      "display" : "好幸福泌尿科診所"
    },
    {
      "code" : "3531026822",
      "display" : "溱美皮膚科診所"
    },
    {
      "code" : "3531026831",
      "display" : "正興診所"
    },
    {
      "code" : "3531026840",
      "display" : "予生診所"
    },
    {
      "code" : "3531026859",
      "display" : "禾順診所"
    },
    {
      "code" : "3531026868",
      "display" : "寶島眼科診所"
    },
    {
      "code" : "3531026877",
      "display" : "芯安診所"
    },
    {
      "code" : "3531026895",
      "display" : "翔安診所"
    },
    {
      "code" : "3531026902",
      "display" : "大重仁復健科診所"
    },
    {
      "code" : "3531026911",
      "display" : "良安診所"
    },
    {
      "code" : "3531026920",
      "display" : "保順皮膚科家醫科診所"
    },
    {
      "code" : "3531026939",
      "display" : "采新婦幼診所"
    },
    {
      "code" : "3531026975",
      "display" : "良全婦產科診所"
    },
    {
      "code" : "3531026993",
      "display" : "連眼科診所"
    },
    {
      "code" : "3531027007",
      "display" : "潤生復健科診所"
    },
    {
      "code" : "3531027016",
      "display" : "皮醫師三重皮膚專科診所"
    },
    {
      "code" : "3531027025",
      "display" : "吳孟書診所"
    },
    {
      "code" : "3531027034",
      "display" : "維爾美診所"
    },
    {
      "code" : "3531027043",
      "display" : "仁暉診所"
    },
    {
      "code" : "3531027061",
      "display" : "仁人診所"
    },
    {
      "code" : "3531030077",
      "display" : "唐小兒科診所"
    },
    {
      "code" : "3531030095",
      "display" : "吉安小兒科診所"
    },
    {
      "code" : "3531030264",
      "display" : "蕭正貴小兒科家庭醫學科診所"
    },
    {
      "code" : "3531030291",
      "display" : "李廣德眼科診所"
    },
    {
      "code" : "3531030371",
      "display" : "聯宏內科診所"
    },
    {
      "code" : "3531030513",
      "display" : "鍾婦產科診所"
    },
    {
      "code" : "3531030559",
      "display" : "愛兒小兒科診所"
    },
    {
      "code" : "3531030666",
      "display" : "明献診所"
    },
    {
      "code" : "3531030684",
      "display" : "陳宏銘婦產科診所"
    },
    {
      "code" : "3531030826",
      "display" : "安康小兒科內科診所"
    },
    {
      "code" : "3531030835",
      "display" : "竹林皮膚科診所"
    },
    {
      "code" : "3531030899",
      "display" : "蘇耳鼻喉科診所"
    },
    {
      "code" : "3531030906",
      "display" : "雙和診所"
    },
    {
      "code" : "3531030942",
      "display" : "賀自立耳鼻喉科診所"
    },
    {
      "code" : "3531030951",
      "display" : "王新亞眼科診所"
    },
    {
      "code" : "3531031047",
      "display" : "曾怡仁診所"
    },
    {
      "code" : "3531031127",
      "display" : "祐祥婦產科診所"
    },
    {
      "code" : "3531031145",
      "display" : "定安皮膚科診所"
    },
    {
      "code" : "3531031154",
      "display" : "謝政璋皮膚科診所"
    },
    {
      "code" : "3531031163",
      "display" : "蔡正平耳鼻喉科聯合診所"
    },
    {
      "code" : "3531031181",
      "display" : "吳銅坤婦產科診所"
    },
    {
      "code" : "3531031234",
      "display" : "黃榮泰診所"
    },
    {
      "code" : "3531031252",
      "display" : "黃柏榮耳鼻喉科診所"
    },
    {
      "code" : "3531031261",
      "display" : "清池診所"
    },
    {
      "code" : "3531031270",
      "display" : "郭烽裕診所"
    },
    {
      "code" : "3531031289",
      "display" : "洪源裕小兒科診所"
    },
    {
      "code" : "3531031369",
      "display" : "林揚內科診所"
    },
    {
      "code" : "3531031421",
      "display" : "悅生婦產科診所"
    },
    {
      "code" : "3531031510",
      "display" : "泰祥婦產科診所"
    },
    {
      "code" : "3531031574",
      "display" : "張婦產科診所"
    },
    {
      "code" : "3531031609",
      "display" : "永信皮膚科診所"
    },
    {
      "code" : "3531031654",
      "display" : "劉宗健小兒科診所"
    },
    {
      "code" : "3531031716",
      "display" : "陳旦陽耳鼻喉科診所"
    },
    {
      "code" : "3531031734",
      "display" : "曾眼科診所"
    },
    {
      "code" : "3531031752",
      "display" : "戴良恭診所"
    },
    {
      "code" : "3531031761",
      "display" : "黃濂輝診所"
    },
    {
      "code" : "3531031841",
      "display" : "博群復健診所"
    },
    {
      "code" : "3531031869",
      "display" : "世芳復健科診所"
    },
    {
      "code" : "3531031878",
      "display" : "博新小兒科家庭醫學科診所"
    },
    {
      "code" : "3531031903",
      "display" : "長欣診所"
    },
    {
      "code" : "3531031921",
      "display" : "趙英進診所"
    },
    {
      "code" : "3531031985",
      "display" : "和信診所"
    },
    {
      "code" : "3531032008",
      "display" : "謝璧光小兒科診所"
    },
    {
      "code" : "3531032026",
      "display" : "吳宗坡耳鼻喉科診所"
    },
    {
      "code" : "3531032053",
      "display" : "惠生聯合診所"
    },
    {
      "code" : "3531032115",
      "display" : "大仁耳鼻喉科診所"
    },
    {
      "code" : "3531032142",
      "display" : "安和耳鼻喉科診所"
    },
    {
      "code" : "3531032179",
      "display" : "國平耳鼻喉科診所"
    },
    {
      "code" : "3531032197",
      "display" : "蕭佩宏小兒科診所"
    },
    {
      "code" : "3531033201",
      "display" : "崇恩診所"
    },
    {
      "code" : "3531033283",
      "display" : "吳志仁診所"
    },
    {
      "code" : "3531033327",
      "display" : "友友小兒科診所"
    },
    {
      "code" : "3531033363",
      "display" : "蕙明眼科診所"
    },
    {
      "code" : "3531033372",
      "display" : "胡淑晶皮膚科診所"
    },
    {
      "code" : "3531033407",
      "display" : "健新耳鼻喉科診所"
    },
    {
      "code" : "3531033425",
      "display" : "章志平小兒科診所"
    },
    {
      "code" : "3531033470",
      "display" : "楊安診所"
    },
    {
      "code" : "3531033489",
      "display" : "王英傑小兒科診所"
    },
    {
      "code" : "3531033498",
      "display" : "蔡維中眼科診所"
    },
    {
      "code" : "3531033523",
      "display" : "光晴復健科診所"
    },
    {
      "code" : "3531033532",
      "display" : "文林診所"
    },
    {
      "code" : "3531033596",
      "display" : "王威鈞婦產科診所"
    },
    {
      "code" : "3531033612",
      "display" : "葉春風耳鼻喉科診所"
    },
    {
      "code" : "3531033649",
      "display" : "林俊銘皮膚科診所"
    },
    {
      "code" : "3531033685",
      "display" : "黎新彬診所"
    },
    {
      "code" : "3531033747",
      "display" : "德美診所"
    },
    {
      "code" : "3531033783",
      "display" : "蔡天惠婦產科診所"
    },
    {
      "code" : "3531033827",
      "display" : "和安耳鼻喉科診所"
    },
    {
      "code" : "3531033854",
      "display" : "銘亮診所"
    },
    {
      "code" : "3531033907",
      "display" : "王杰凱小兒科診所"
    },
    {
      "code" : "3531033952",
      "display" : "呂適存小兒科診所"
    },
    {
      "code" : "3531033961",
      "display" : "天佑眼科診所"
    },
    {
      "code" : "3531033994",
      "display" : "明心診所"
    },
    {
      "code" : "3531034020",
      "display" : "洪碩壎小兒科診所"
    },
    {
      "code" : "3531034039",
      "display" : "德上診所"
    },
    {
      "code" : "3531034048",
      "display" : "上立美學皮膚科診所"
    },
    {
      "code" : "3531034057",
      "display" : "芳瑞皮膚科診所"
    },
    {
      "code" : "3531034066",
      "display" : "柯景馨診所"
    },
    {
      "code" : "3531034155",
      "display" : "頂溪耳鼻喉科診所"
    },
    {
      "code" : "3531034182",
      "display" : "芝妍皮膚專科診所"
    },
    {
      "code" : "3531034208",
      "display" : "樂華診所"
    },
    {
      "code" : "3531034244",
      "display" : "永愛診所"
    },
    {
      "code" : "3531034262",
      "display" : "冠宏骨科診所"
    },
    {
      "code" : "3531034315",
      "display" : "永和大學眼科診所"
    },
    {
      "code" : "3531034333",
      "display" : "黃賜濱皮膚科診所"
    },
    {
      "code" : "3531034342",
      "display" : "御生婦幼診所"
    },
    {
      "code" : "3531034351",
      "display" : "劉志明骨科診所"
    },
    {
      "code" : "3531034379",
      "display" : "柏安診所"
    },
    {
      "code" : "3531034388",
      "display" : "誠新耳鼻喉科診所"
    },
    {
      "code" : "3531034413",
      "display" : "惠恩診所"
    },
    {
      "code" : "3531034459",
      "display" : "永平身心診所"
    },
    {
      "code" : "3531034502",
      "display" : "姚仁青診所"
    },
    {
      "code" : "3531034511",
      "display" : "佑達骨科診所"
    },
    {
      "code" : "3531034520",
      "display" : "晉康診所"
    },
    {
      "code" : "3531034539",
      "display" : "彭程毅診所"
    },
    {
      "code" : "3531034557",
      "display" : "益康診所"
    },
    {
      "code" : "3531034575",
      "display" : "晶耀眼科診所"
    },
    {
      "code" : "3531034628",
      "display" : "飛揚診所"
    },
    {
      "code" : "3531034646",
      "display" : "景愛復健診所"
    },
    {
      "code" : "3531034655",
      "display" : "悅滿意復健專科診所"
    },
    {
      "code" : "3531034664",
      "display" : "薛弘亮醫師診所"
    },
    {
      "code" : "3531034682",
      "display" : "星孕國際診所"
    },
    {
      "code" : "3531034708",
      "display" : "順誠耳鼻喉科診所"
    },
    {
      "code" : "3531034726",
      "display" : "信心診所"
    },
    {
      "code" : "3531034744",
      "display" : "逸原診所"
    },
    {
      "code" : "3531034780",
      "display" : "博愛婦產科診所"
    },
    {
      "code" : "3531034799",
      "display" : "博宏眼科診所"
    },
    {
      "code" : "3531034833",
      "display" : "星幸福美學診所"
    },
    {
      "code" : "3531034860",
      "display" : "頂溪紫陽復健科診所"
    },
    {
      "code" : "3531034879",
      "display" : "杏日診所"
    },
    {
      "code" : "3531034888",
      "display" : "逸全診所"
    },
    {
      "code" : "3531034897",
      "display" : "德謙耳鼻喉科診所"
    },
    {
      "code" : "3531034922",
      "display" : "心晴診所"
    },
    {
      "code" : "3531034931",
      "display" : "佳永診所"
    },
    {
      "code" : "3531034959",
      "display" : "旭恩小兒科診所"
    },
    {
      "code" : "3531034977",
      "display" : "福和診所"
    },
    {
      "code" : "3531034986",
      "display" : "美加婦產科診所"
    },
    {
      "code" : "3531034995",
      "display" : "中永和身心精神科診所"
    },
    {
      "code" : "3531035009",
      "display" : "悅腎診所"
    },
    {
      "code" : "3531035018",
      "display" : "醫憲診所"
    },
    {
      "code" : "3531035027",
      "display" : "永馨復健診所"
    },
    {
      "code" : "3531035045",
      "display" : "永和開心診所"
    },
    {
      "code" : "3531035054",
      "display" : "恆新復健科診所"
    },
    {
      "code" : "3531035063",
      "display" : "頤康診所"
    },
    {
      "code" : "3531035072",
      "display" : "群英皮膚科整形外科診所"
    },
    {
      "code" : "3531035081",
      "display" : "仲信診所"
    },
    {
      "code" : "3531035090",
      "display" : "高健診所"
    },
    {
      "code" : "3531035107",
      "display" : "雙和聚英視光眼科診所"
    },
    {
      "code" : "3531035125",
      "display" : "得揚骨科診所"
    },
    {
      "code" : "3531035134",
      "display" : "杏福診所"
    },
    {
      "code" : "3531035143",
      "display" : "弘泰診所"
    },
    {
      "code" : "3531035152",
      "display" : "四季和悅婦產科診所"
    },
    {
      "code" : "3531035170",
      "display" : "承安內科診所"
    },
    {
      "code" : "3531035189",
      "display" : "得安診所"
    },
    {
      "code" : "3531035198",
      "display" : "永和原力復健科診所"
    },
    {
      "code" : "3531035205",
      "display" : "群英皮膚科整形外科診所"
    },
    {
      "code" : "3531035214",
      "display" : "永和醫憲診所"
    },
    {
      "code" : "3531035223",
      "display" : "益康診所"
    },
    {
      "code" : "3531035232",
      "display" : "懿麟診所"
    },
    {
      "code" : "3531035241",
      "display" : "和順診所"
    },
    {
      "code" : "3531035269",
      "display" : "群麗診所"
    },
    {
      "code" : "3531035278",
      "display" : "得揚診所"
    },
    {
      "code" : "3531035287",
      "display" : "頂和骨科診所"
    },
    {
      "code" : "3531035296",
      "display" : "藝群永和診所"
    },
    {
      "code" : "3531035303",
      "display" : "益康診所"
    },
    {
      "code" : "3531035321",
      "display" : "永和好幸福泌尿科診所"
    },
    {
      "code" : "3531035330",
      "display" : "平安診所"
    },
    {
      "code" : "3531035358",
      "display" : "仁翔診所"
    },
    {
      "code" : "3531035367",
      "display" : "真愛診所"
    },
    {
      "code" : "3531035376",
      "display" : "璞安皮膚專科診所"
    },
    {
      "code" : "3531035385",
      "display" : "蓮恩診所"
    },
    {
      "code" : "3531035394",
      "display" : "宣妍皮膚科診所"
    },
    {
      "code" : "3531035401",
      "display" : "日昇診所"
    },
    {
      "code" : "3531035410",
      "display" : "得揚診所"
    },
    {
      "code" : "3531035438",
      "display" : "永和好幸福泌尿科診所"
    },
    {
      "code" : "3531035447",
      "display" : "得安診所"
    },
    {
      "code" : "3531040153",
      "display" : "良佳診所"
    },
    {
      "code" : "3531040171",
      "display" : "高婦產科診所"
    },
    {
      "code" : "3531040242",
      "display" : "黃兆侃診所"
    },
    {
      "code" : "3531040457",
      "display" : "林眼科診所"
    },
    {
      "code" : "3531040466",
      "display" : "景新診所"
    },
    {
      "code" : "3531040519",
      "display" : "十全外科婦產科診所"
    },
    {
      "code" : "3531040537",
      "display" : "連城外科診所"
    },
    {
      "code" : "3531040564",
      "display" : "戴廣懷小兒科診所"
    },
    {
      "code" : "3531040662",
      "display" : "陳國璋小兒科診所"
    },
    {
      "code" : "3531040715",
      "display" : "劉彭小兒科診所"
    },
    {
      "code" : "3531040797",
      "display" : "顏耳鼻喉科診所"
    },
    {
      "code" : "3531040886",
      "display" : "白家聲診所"
    },
    {
      "code" : "3531040920",
      "display" : "明燦眼科診所"
    },
    {
      "code" : "3531040957",
      "display" : "中和李內科診所"
    },
    {
      "code" : "3531040975",
      "display" : "謝俊民診所"
    },
    {
      "code" : "3531041007",
      "display" : "張榮欽診所"
    },
    {
      "code" : "3531041034",
      "display" : "英生耳鼻喉科診所"
    },
    {
      "code" : "3531041052",
      "display" : "家安診所"
    },
    {
      "code" : "3531041123",
      "display" : "陳高輝耳鼻喉科診所"
    },
    {
      "code" : "3531041178",
      "display" : "日欣診所"
    },
    {
      "code" : "3531041203",
      "display" : "劉全能診所"
    },
    {
      "code" : "3531041285",
      "display" : "蘇年興耳鼻喉科診所"
    },
    {
      "code" : "3531041301",
      "display" : "張維發診所"
    },
    {
      "code" : "3531041392",
      "display" : "黃呈鵬小兒科診所"
    },
    {
      "code" : "3531041454",
      "display" : "彭再成診所"
    },
    {
      "code" : "3531041490",
      "display" : "亞都診所"
    },
    {
      "code" : "3531041516",
      "display" : "黃源泰診所"
    },
    {
      "code" : "3531041534",
      "display" : "振辰外科診所"
    },
    {
      "code" : "3531041589",
      "display" : "冠明診所"
    },
    {
      "code" : "3531041623",
      "display" : "吳嘉生診所"
    },
    {
      "code" : "3531041632",
      "display" : "祥明診所"
    },
    {
      "code" : "3531041650",
      "display" : "榮生診所"
    },
    {
      "code" : "3531041678",
      "display" : "趙耀軍耳鼻喉科診所"
    },
    {
      "code" : "3531041749",
      "display" : "陸義發耳鼻喉科診所"
    },
    {
      "code" : "3531041758",
      "display" : "莊朝傑眼科診所"
    },
    {
      "code" : "3531041767",
      "display" : "張偉哲眼科診所"
    },
    {
      "code" : "3531041776",
      "display" : "西華診所"
    },
    {
      "code" : "3531041785",
      "display" : "德祐診所"
    },
    {
      "code" : "3531041838",
      "display" : "永康診所"
    },
    {
      "code" : "3531041847",
      "display" : "宜生診所"
    },
    {
      "code" : "3531041918",
      "display" : "景民診所"
    },
    {
      "code" : "3531041954",
      "display" : "合吉婦產科診所"
    },
    {
      "code" : "3531041981",
      "display" : "吳家裕耳鼻喉科診所"
    },
    {
      "code" : "3531042031",
      "display" : "上允耳鼻喉科診所"
    },
    {
      "code" : "3531042059",
      "display" : "民樂耳鼻喉科診所"
    },
    {
      "code" : "3531042095",
      "display" : "澤生診所"
    },
    {
      "code" : "3531042237",
      "display" : "蔡承恭診所"
    },
    {
      "code" : "3531042264",
      "display" : "中和仁安診所"
    },
    {
      "code" : "3531042291",
      "display" : "雙怡診所"
    },
    {
      "code" : "3531042317",
      "display" : "晟恩診所"
    },
    {
      "code" : "3531042344",
      "display" : "南勢角復健診所"
    },
    {
      "code" : "3531042362",
      "display" : "家和診所"
    },
    {
      "code" : "3531042380",
      "display" : "王作仁診所"
    },
    {
      "code" : "3531042399",
      "display" : "慧禮診所"
    },
    {
      "code" : "3531042451",
      "display" : "育家聯合診所"
    },
    {
      "code" : "3531042479",
      "display" : "正生婦幼聯合診所"
    },
    {
      "code" : "3531042513",
      "display" : "蔡佳璋婦產科診所"
    },
    {
      "code" : "3531042522",
      "display" : "賴俊元皮膚科診所"
    },
    {
      "code" : "3531042531",
      "display" : "康萊診所"
    },
    {
      "code" : "3531042586",
      "display" : "陳建良耳鼻喉科診所"
    },
    {
      "code" : "3531043618",
      "display" : "郭長堺診所"
    },
    {
      "code" : "3531043627",
      "display" : "曾咸統小兒科診所"
    },
    {
      "code" : "3531043672",
      "display" : "季明眼科診所"
    },
    {
      "code" : "3531043681",
      "display" : "永安眼科診所"
    },
    {
      "code" : "3531043716",
      "display" : "優寶婦產科診所"
    },
    {
      "code" : "3531043752",
      "display" : "嘉櫻診所"
    },
    {
      "code" : "3531043761",
      "display" : "盧建宏耳鼻喉科診所"
    },
    {
      "code" : "3531043770",
      "display" : "王家醫科診所"
    },
    {
      "code" : "3531043823",
      "display" : "欣禾診所"
    },
    {
      "code" : "3531043869",
      "display" : "馮泰龍小兒科診所"
    },
    {
      "code" : "3531043976",
      "display" : "華欣診所"
    },
    {
      "code" : "3531044008",
      "display" : "王上卿婦產科診所"
    },
    {
      "code" : "3531044017",
      "display" : "信望愛眼科診所"
    },
    {
      "code" : "3531044035",
      "display" : "坤暉小兒專科診所"
    },
    {
      "code" : "3531044053",
      "display" : "益德診所"
    },
    {
      "code" : "3531044106",
      "display" : "美和診所"
    },
    {
      "code" : "3531044160",
      "display" : "好家人診所"
    },
    {
      "code" : "3531044286",
      "display" : "承安聯合診所"
    },
    {
      "code" : "3531044320",
      "display" : "友善宜安診所"
    },
    {
      "code" : "3531044339",
      "display" : "創悅皮膚科診所"
    },
    {
      "code" : "3531044366",
      "display" : "陳信吉耳鼻喉科診所"
    },
    {
      "code" : "3531044428",
      "display" : "孫國勝外科診所"
    },
    {
      "code" : "3531044437",
      "display" : "佳新小兒科診所"
    },
    {
      "code" : "3531044464",
      "display" : "民揚診所"
    },
    {
      "code" : "3531044491",
      "display" : "嘉仁診所"
    },
    {
      "code" : "3531044535",
      "display" : "唯安診所"
    },
    {
      "code" : "3531044553",
      "display" : "翰霖耳鼻喉科診所"
    },
    {
      "code" : "3531044615",
      "display" : "廣祥診所"
    },
    {
      "code" : "3531044633",
      "display" : "王俊傑診所"
    },
    {
      "code" : "3531044642",
      "display" : "佳和診所"
    },
    {
      "code" : "3531044651",
      "display" : "莊福仁內科診所"
    },
    {
      "code" : "3531044722",
      "display" : "民治診所"
    },
    {
      "code" : "3531044731",
      "display" : "中和大愛眼科診所"
    },
    {
      "code" : "3531044768",
      "display" : "黃基家小兒科診所"
    },
    {
      "code" : "3531044802",
      "display" : "祐嘉骨科診所"
    },
    {
      "code" : "3531044839",
      "display" : "育晨診所"
    },
    {
      "code" : "3531044875",
      "display" : "宏泰診所"
    },
    {
      "code" : "3531044928",
      "display" : "寧靜海診所"
    },
    {
      "code" : "3531044973",
      "display" : "皇家家醫診所"
    },
    {
      "code" : "3531044982",
      "display" : "南勢角德祐診所"
    },
    {
      "code" : "3531044991",
      "display" : "王伯涵皮膚科診所"
    },
    {
      "code" : "3531045014",
      "display" : "賴凱新診所"
    },
    {
      "code" : "3531045041",
      "display" : "皇秦診所"
    },
    {
      "code" : "3531045050",
      "display" : "通安診所"
    },
    {
      "code" : "3531045069",
      "display" : "尚安診所"
    },
    {
      "code" : "3531045121",
      "display" : "力康骨科診所"
    },
    {
      "code" : "3531045158",
      "display" : "安平家診所"
    },
    {
      "code" : "3531045167",
      "display" : "佑欣診所"
    },
    {
      "code" : "3531045176",
      "display" : "奇安診所"
    },
    {
      "code" : "3531045265",
      "display" : "余泰昌小兒科診所"
    },
    {
      "code" : "3531045274",
      "display" : "里安眼科診所"
    },
    {
      "code" : "3531045283",
      "display" : "劍橋診所"
    },
    {
      "code" : "3531045336",
      "display" : "宜宏泌尿科內科診所"
    },
    {
      "code" : "3531045363",
      "display" : "佳南診所"
    },
    {
      "code" : "3531045381",
      "display" : "中和重慶耳鼻喉科診所"
    },
    {
      "code" : "3531045390",
      "display" : "詠安耳鼻喉科診所"
    },
    {
      "code" : "3531045425",
      "display" : "延生診所"
    },
    {
      "code" : "3531045443",
      "display" : "大興耳鼻喉科診所"
    },
    {
      "code" : "3531045452",
      "display" : "寰康復健診所"
    },
    {
      "code" : "3531045461",
      "display" : "快樂小兒科診所"
    },
    {
      "code" : "3531045489",
      "display" : "杏嘉診所"
    },
    {
      "code" : "3531045505",
      "display" : "連城實和復健診所"
    },
    {
      "code" : "3531045514",
      "display" : "雄鶴診所"
    },
    {
      "code" : "3531045532",
      "display" : "捷安診所"
    },
    {
      "code" : "3531045569",
      "display" : "橋和皮膚專科診所"
    },
    {
      "code" : "3531045612",
      "display" : "正倫診所"
    },
    {
      "code" : "3531045621",
      "display" : "維登診所"
    },
    {
      "code" : "3531045685",
      "display" : "辰安耳鼻喉科診所"
    },
    {
      "code" : "3531045694",
      "display" : "景安眼科診所"
    },
    {
      "code" : "3531045765",
      "display" : "凱程診所"
    },
    {
      "code" : "3531045774",
      "display" : "漳怡內科診所"
    },
    {
      "code" : "3531045792",
      "display" : "晶樣診所"
    },
    {
      "code" : "3531045827",
      "display" : "立翔診所"
    },
    {
      "code" : "3531045836",
      "display" : "穗安復健科診所"
    },
    {
      "code" : "3531045845",
      "display" : "光點眼科診所"
    },
    {
      "code" : "3531045854",
      "display" : "醫品診所"
    },
    {
      "code" : "3531045863",
      "display" : "雅文皮膚科診所"
    },
    {
      "code" : "3531045872",
      "display" : "德泰診所"
    },
    {
      "code" : "3531045890",
      "display" : "朝安診所"
    },
    {
      "code" : "3531045925",
      "display" : "福和身心診所"
    },
    {
      "code" : "3531045934",
      "display" : "中和興南大學眼科診所"
    },
    {
      "code" : "3531045943",
      "display" : "中和班廷謝安慈診所"
    },
    {
      "code" : "3531045961",
      "display" : "橋和光晶妍眼科診所"
    },
    {
      "code" : "3531045989",
      "display" : "健新診所"
    },
    {
      "code" : "3531046002",
      "display" : "王曜庭診所"
    },
    {
      "code" : "3531046020",
      "display" : "新福星診所"
    },
    {
      "code" : "3531046039",
      "display" : "晟新診所"
    },
    {
      "code" : "3531046075",
      "display" : "力禾耳鼻喉科診所"
    },
    {
      "code" : "3531046100",
      "display" : "康陽診所"
    },
    {
      "code" : "3531046119",
      "display" : "南方復健科診所"
    },
    {
      "code" : "3531046128",
      "display" : "維品身心診所"
    },
    {
      "code" : "3531046137",
      "display" : "辰星皮膚專科診所"
    },
    {
      "code" : "3531046164",
      "display" : "昌惟骨科診所"
    },
    {
      "code" : "3531046173",
      "display" : "合慶診所"
    },
    {
      "code" : "3531046182",
      "display" : "尚明眼科診所"
    },
    {
      "code" : "3531046208",
      "display" : "皮醫美南勢角診所"
    },
    {
      "code" : "3531046217",
      "display" : "中和國泰診所"
    },
    {
      "code" : "3531046244",
      "display" : "安和復健科診所"
    },
    {
      "code" : "3531046253",
      "display" : "樂活精神科診所"
    },
    {
      "code" : "3531046262",
      "display" : "淯陞診所"
    },
    {
      "code" : "3531046271",
      "display" : "安祐診所"
    },
    {
      "code" : "3531046280",
      "display" : "健和診所"
    },
    {
      "code" : "3531046299",
      "display" : "聖心診所"
    },
    {
      "code" : "3531046306",
      "display" : "光晶妍寶島診所"
    },
    {
      "code" : "3531046315",
      "display" : "嘉俊骨科診所"
    },
    {
      "code" : "3531046324",
      "display" : "中和容光皮膚專科診所"
    },
    {
      "code" : "3531046333",
      "display" : "李凱國皮膚科診所"
    },
    {
      "code" : "3531046342",
      "display" : "精湛眼科診所"
    },
    {
      "code" : "3531046351",
      "display" : "皮醫美南勢角診所"
    },
    {
      "code" : "3531046379",
      "display" : "雙和諾貝爾眼科診所"
    },
    {
      "code" : "3531046388",
      "display" : "眾心診所"
    },
    {
      "code" : "3531046397",
      "display" : "建良耳鼻喉科診所"
    },
    {
      "code" : "3531046404",
      "display" : "合慶診所"
    },
    {
      "code" : "3531046413",
      "display" : "皇秦診所"
    },
    {
      "code" : "3531046422",
      "display" : "嘉穗診所"
    },
    {
      "code" : "3531046431",
      "display" : "中和双眼明眼科診所"
    },
    {
      "code" : "3531046440",
      "display" : "全裕診所"
    },
    {
      "code" : "3531046459",
      "display" : "源泰診所"
    },
    {
      "code" : "3531046468",
      "display" : "永育醫療南勢角診所"
    },
    {
      "code" : "3531046477",
      "display" : "涵妍美學診所"
    },
    {
      "code" : "3531046486",
      "display" : "光晶妍寶島診所"
    },
    {
      "code" : "3531046495",
      "display" : "雙和諾貝爾眼科診所"
    },
    {
      "code" : "3531046502",
      "display" : "禾益診所"
    },
    {
      "code" : "3531046511",
      "display" : "悅安身心診所"
    },
    {
      "code" : "3531046520",
      "display" : "富力好診所"
    },
    {
      "code" : "3531046548",
      "display" : "周一珊診所"
    },
    {
      "code" : "3531046557",
      "display" : "合慶診所"
    },
    {
      "code" : "3531046566",
      "display" : "維發診所"
    },
    {
      "code" : "3531046584",
      "display" : "傑初診所"
    },
    {
      "code" : "3531046593",
      "display" : "立順診所"
    },
    {
      "code" : "3531046600",
      "display" : "通安診所"
    },
    {
      "code" : "3531046619",
      "display" : "力康骨科診所"
    },
    {
      "code" : "3531046628",
      "display" : "嘉生診所"
    },
    {
      "code" : "3531046637",
      "display" : "坤暉診所"
    },
    {
      "code" : "3531046646",
      "display" : "298就是美診所"
    },
    {
      "code" : "3531050033",
      "display" : "何耳鼻喉科診所"
    },
    {
      "code" : "3531050131",
      "display" : "林慶堂婦產科診所"
    },
    {
      "code" : "3531050195",
      "display" : "永吉外科診所"
    },
    {
      "code" : "3531050248",
      "display" : "中文內科小兒科診所"
    },
    {
      "code" : "3531050293",
      "display" : "陳小兒科診所"
    },
    {
      "code" : "3531050328",
      "display" : "啟生診所"
    },
    {
      "code" : "3531050426",
      "display" : "恩寧眼科診所"
    },
    {
      "code" : "3531050462",
      "display" : "太山家庭醫學科診所"
    },
    {
      "code" : "3531050604",
      "display" : "黃瑛超皮膚科診所"
    },
    {
      "code" : "3531050659",
      "display" : "陳正宗診所"
    },
    {
      "code" : "3531050720",
      "display" : "東陽耳鼻喉科診所"
    },
    {
      "code" : "3531050775",
      "display" : "睛彩眼科診所"
    },
    {
      "code" : "3531050784",
      "display" : "黃宏超眼科診所"
    },
    {
      "code" : "3531050944",
      "display" : "顏秀吉婦產科診所"
    },
    {
      "code" : "3531050962",
      "display" : "惠安診所"
    },
    {
      "code" : "3531050971",
      "display" : "汪耳鼻喉科診所"
    },
    {
      "code" : "3531050999",
      "display" : "高兒科診所"
    },
    {
      "code" : "3531051094",
      "display" : "群惠耳鼻喉科診所"
    },
    {
      "code" : "3531051101",
      "display" : "張榮宗內科診所"
    },
    {
      "code" : "3531051138",
      "display" : "雁秋診所"
    },
    {
      "code" : "3531051147",
      "display" : "吳耳鼻喉科診所"
    },
    {
      "code" : "3531051192",
      "display" : "劉建梅診所"
    },
    {
      "code" : "3531051254",
      "display" : "文玉小兒科診所"
    },
    {
      "code" : "3531051290",
      "display" : "李亭鋒耳鼻喉科診所"
    },
    {
      "code" : "3531051307",
      "display" : "護康診所"
    },
    {
      "code" : "3531051325",
      "display" : "富森診所"
    },
    {
      "code" : "3531051343",
      "display" : "佳音診所"
    },
    {
      "code" : "3531051398",
      "display" : "楊龍駿婦產科診所"
    },
    {
      "code" : "3531051432",
      "display" : "蕭仁哲婦產科診所"
    },
    {
      "code" : "3531051441",
      "display" : "陳沛生耳鼻喉科診所"
    },
    {
      "code" : "3531051512",
      "display" : "呈恩診所"
    },
    {
      "code" : "3531051521",
      "display" : "為宏皮膚科診所"
    },
    {
      "code" : "3531051549",
      "display" : "民康眼科診所"
    },
    {
      "code" : "3531051567",
      "display" : "王慶祥小兒科診所"
    },
    {
      "code" : "3531052635",
      "display" : "林建良耳鼻喉科診所"
    },
    {
      "code" : "3531052715",
      "display" : "和成診所"
    },
    {
      "code" : "3531052760",
      "display" : "欣和診所"
    },
    {
      "code" : "3531052797",
      "display" : "潘如瑾婦產科診所"
    },
    {
      "code" : "3531052804",
      "display" : "林逢慶診所"
    },
    {
      "code" : "3531052831",
      "display" : "幼安小兒科診所"
    },
    {
      "code" : "3531052840",
      "display" : "信安診所"
    },
    {
      "code" : "3531052859",
      "display" : "邱眼科診所"
    },
    {
      "code" : "3531052966",
      "display" : "佑康聯合診所"
    },
    {
      "code" : "3531053034",
      "display" : "德明眼科診所"
    },
    {
      "code" : "3531053052",
      "display" : "維霖內科診所"
    },
    {
      "code" : "3531053070",
      "display" : "健全診所"
    },
    {
      "code" : "3531053098",
      "display" : "九宜診所"
    },
    {
      "code" : "3531053123",
      "display" : "我的診所"
    },
    {
      "code" : "3531053132",
      "display" : "全康診所"
    },
    {
      "code" : "3531053141",
      "display" : "安立診所"
    },
    {
      "code" : "3531053150",
      "display" : "聖新診所"
    },
    {
      "code" : "3531053178",
      "display" : "安民診所"
    },
    {
      "code" : "3531053203",
      "display" : "又新診所"
    },
    {
      "code" : "3531053212",
      "display" : "曾俊睿小兒科診所"
    },
    {
      "code" : "3531053285",
      "display" : "國城診所"
    },
    {
      "code" : "3531053338",
      "display" : "新眼光眼科診所"
    },
    {
      "code" : "3531053409",
      "display" : "耀程耳鼻喉科診所"
    },
    {
      "code" : "3531053433",
      "display" : "加加小兒科診所"
    },
    {
      "code" : "3531053490",
      "display" : "佳禾復健科診所"
    },
    {
      "code" : "3531053525",
      "display" : "健維骨科診所"
    },
    {
      "code" : "3531053543",
      "display" : "楊聰才診所"
    },
    {
      "code" : "3531053632",
      "display" : "邱昰凱小兒科診所"
    },
    {
      "code" : "3531053641",
      "display" : "聖康診所"
    },
    {
      "code" : "3531053650",
      "display" : "大豐耳鼻喉科診所"
    },
    {
      "code" : "3531053678",
      "display" : "家光耳鼻喉科診所"
    },
    {
      "code" : "3531053721",
      "display" : "美膚皮膚專科診所"
    },
    {
      "code" : "3531053730",
      "display" : "碧潭診所"
    },
    {
      "code" : "3531053767",
      "display" : "日安診所"
    },
    {
      "code" : "3531053785",
      "display" : "經典皮膚科診所"
    },
    {
      "code" : "3531053794",
      "display" : "新晨皮膚專科診所"
    },
    {
      "code" : "3531053801",
      "display" : "新店六順診所"
    },
    {
      "code" : "3531053838",
      "display" : "逸安診所"
    },
    {
      "code" : "3531053856",
      "display" : "富新骨科診所"
    },
    {
      "code" : "3531053874",
      "display" : "博德眼科診所"
    },
    {
      "code" : "3531053909",
      "display" : "瑞安耳鼻喉科診所"
    },
    {
      "code" : "3531053918",
      "display" : "康禾診所"
    },
    {
      "code" : "3531053945",
      "display" : "恩康診所"
    },
    {
      "code" : "3531053954",
      "display" : "張振榕診所"
    },
    {
      "code" : "3531053972",
      "display" : "蘇永誠家醫科診所"
    },
    {
      "code" : "3531053990",
      "display" : "星展眼科診所"
    },
    {
      "code" : "3531054013",
      "display" : "101SKIN晶漾診所"
    },
    {
      "code" : "3531054068",
      "display" : "大為診所"
    },
    {
      "code" : "3531054077",
      "display" : "維格皮膚科診所"
    },
    {
      "code" : "3531054086",
      "display" : "仁佑診所"
    },
    {
      "code" : "3531054095",
      "display" : "悅滿意新店復健專科診所"
    },
    {
      "code" : "3531054102",
      "display" : "逸守診所"
    },
    {
      "code" : "3531054157",
      "display" : "禾康復健科診所"
    },
    {
      "code" : "3531054166",
      "display" : "湛明眼科診所"
    },
    {
      "code" : "3531054184",
      "display" : "新店北新身心診所"
    },
    {
      "code" : "3531054193",
      "display" : "蘇景傑診所"
    },
    {
      "code" : "3531054200",
      "display" : "安倍診所"
    },
    {
      "code" : "3531054246",
      "display" : "禾安復健科診所"
    },
    {
      "code" : "3531054264",
      "display" : "順安復健專科診所"
    },
    {
      "code" : "3531054273",
      "display" : "冠新復健科診所"
    },
    {
      "code" : "3531054282",
      "display" : "行一昌勳診所"
    },
    {
      "code" : "3531054291",
      "display" : "睿安診所"
    },
    {
      "code" : "3531054317",
      "display" : "新店大愛眼科診所"
    },
    {
      "code" : "3531054335",
      "display" : "立誠耳鼻喉科診所"
    },
    {
      "code" : "3531054344",
      "display" : "超亮皮膚科診所"
    },
    {
      "code" : "3531054362",
      "display" : "禾康復健科診所"
    },
    {
      "code" : "3531054371",
      "display" : "佳禾復健科診所"
    },
    {
      "code" : "3531054380",
      "display" : "均樂身心診所"
    },
    {
      "code" : "3531054399",
      "display" : "嘉齊診所"
    },
    {
      "code" : "3531054406",
      "display" : "治聿身心醫學診所"
    },
    {
      "code" : "3531054415",
      "display" : "維格皮膚科診所"
    },
    {
      "code" : "3531054424",
      "display" : "新店開心診所"
    },
    {
      "code" : "3531054442",
      "display" : "新店容光皮膚專科診所"
    },
    {
      "code" : "3531054451",
      "display" : "安坑振榕診所"
    },
    {
      "code" : "3531054460",
      "display" : "新店現代診所"
    },
    {
      "code" : "3531054479",
      "display" : "欣安診所"
    },
    {
      "code" : "3531054488",
      "display" : "拾光醫美診所"
    },
    {
      "code" : "3531054504",
      "display" : "好孕診所"
    },
    {
      "code" : "3531054513",
      "display" : "新店現代耳鼻喉科診所"
    },
    {
      "code" : "3531054522",
      "display" : "摩登耳鼻喉科診所"
    },
    {
      "code" : "3531054531",
      "display" : "中外家醫診所"
    },
    {
      "code" : "3531054540",
      "display" : "安坑振榕診所"
    },
    {
      "code" : "3531054568",
      "display" : "中外家醫診所"
    },
    {
      "code" : "3531054577",
      "display" : "睿視眼科診所"
    },
    {
      "code" : "3531054595",
      "display" : "路竹診所"
    },
    {
      "code" : "3531060057",
      "display" : "民泰診所"
    },
    {
      "code" : "3531060084",
      "display" : "陳一隆內科小兒科診所"
    },
    {
      "code" : "3531060128",
      "display" : "柯誠立婦產科診所"
    },
    {
      "code" : "3531060226",
      "display" : "黃政司診所"
    },
    {
      "code" : "3531060324",
      "display" : "鄭骨科耳鼻喉科診所"
    },
    {
      "code" : "3531060397",
      "display" : "林浩昌內科小兒科診所"
    },
    {
      "code" : "3531060440",
      "display" : "洪敏捷耳鼻喉科診所"
    },
    {
      "code" : "3531060459",
      "display" : "陳桔泱診所"
    },
    {
      "code" : "3531060511",
      "display" : "德安婦產科診所"
    },
    {
      "code" : "3531060655",
      "display" : "賀生婦產科診所"
    },
    {
      "code" : "3531060726",
      "display" : "崇仁外科診所"
    },
    {
      "code" : "3531060744",
      "display" : "霖松婦產科診所"
    },
    {
      "code" : "3531060753",
      "display" : "王正華小兒專科診所"
    },
    {
      "code" : "3531060806",
      "display" : "天給婦產科診所"
    },
    {
      "code" : "3531060860",
      "display" : "吉信耳鼻喉科診所"
    },
    {
      "code" : "3531060931",
      "display" : "劉思楨．許永川皮膚科診所"
    },
    {
      "code" : "3531060940",
      "display" : "謝耳鼻喉科診所"
    },
    {
      "code" : "3531060995",
      "display" : "陳世昌婦產科診所"
    },
    {
      "code" : "3531061009",
      "display" : "王中煌診所"
    },
    {
      "code" : "3531061045",
      "display" : "邱欽斌小兒科診所"
    },
    {
      "code" : "3531061143",
      "display" : "劉長達婦產科診所"
    },
    {
      "code" : "3531061198",
      "display" : "曲孝禮診所"
    },
    {
      "code" : "3531061214",
      "display" : "志豪診所"
    },
    {
      "code" : "3531061232",
      "display" : "聶廷憲診所"
    },
    {
      "code" : "3531061278",
      "display" : "聯安診所"
    },
    {
      "code" : "3531061349",
      "display" : "蔡鉅儒診所"
    },
    {
      "code" : "3531061438",
      "display" : "王建民耳鼻喉科診所"
    },
    {
      "code" : "3531061492",
      "display" : "鄭安雄診所"
    },
    {
      "code" : "3531061527",
      "display" : "柏宏診所"
    },
    {
      "code" : "3531061590",
      "display" : "林基正皮膚科診所"
    },
    {
      "code" : "3531061607",
      "display" : "榜生婦產科診所"
    },
    {
      "code" : "3531061643",
      "display" : "祐幼小兒科診所"
    },
    {
      "code" : "3531061652",
      "display" : "民富皮膚科診所"
    },
    {
      "code" : "3531061661",
      "display" : "昭明眼科診所"
    },
    {
      "code" : "3531061670",
      "display" : "陳鼎輔診所"
    },
    {
      "code" : "3531061698",
      "display" : "福華診所"
    },
    {
      "code" : "3531061705",
      "display" : "藍主仕眼科診所"
    },
    {
      "code" : "3531061750",
      "display" : "雅心婦產科診所"
    },
    {
      "code" : "3531061769",
      "display" : "幸福呂耳鼻喉科診所"
    },
    {
      "code" : "3531061812",
      "display" : "照明眼科診所"
    },
    {
      "code" : "3531061830",
      "display" : "王榮文小兒科診所"
    },
    {
      "code" : "3531061867",
      "display" : "聯福診所"
    },
    {
      "code" : "3531061876",
      "display" : "新莊徐耳鼻喉科診所"
    },
    {
      "code" : "3531061929",
      "display" : "林定參診所"
    },
    {
      "code" : "3531061938",
      "display" : "錦明耳鼻喉科診所"
    },
    {
      "code" : "3531061947",
      "display" : "黃信喜診所"
    },
    {
      "code" : "3531061974",
      "display" : "張昱錦診所"
    },
    {
      "code" : "3531061983",
      "display" : "健佑診所"
    },
    {
      "code" : "3531062006",
      "display" : "劉建輝診所"
    },
    {
      "code" : "3531062051",
      "display" : "黃呈榕眼科診所"
    },
    {
      "code" : "3531062060",
      "display" : "吳政德耳鼻喉科診所"
    },
    {
      "code" : "3531062113",
      "display" : "新和耳鼻喉科診所"
    },
    {
      "code" : "3531062131",
      "display" : "陳明哲診所"
    },
    {
      "code" : "3531062168",
      "display" : "馨平耳鼻喉科診所"
    },
    {
      "code" : "3531062186",
      "display" : "康福診所"
    },
    {
      "code" : "3531062195",
      "display" : "林復森耳鼻喉科診所"
    },
    {
      "code" : "3531062202",
      "display" : "蘇診所"
    },
    {
      "code" : "3531063389",
      "display" : "青青診所"
    },
    {
      "code" : "3531063398",
      "display" : "康群診所"
    },
    {
      "code" : "3531063469",
      "display" : "莊申南婦產科診所"
    },
    {
      "code" : "3531063487",
      "display" : "寶健診所"
    },
    {
      "code" : "3531063512",
      "display" : "李復健科骨科診所"
    },
    {
      "code" : "3531063567",
      "display" : "安新診所"
    },
    {
      "code" : "3531063594",
      "display" : "沈耳鼻喉科診所"
    },
    {
      "code" : "3531063601",
      "display" : "中心診所"
    },
    {
      "code" : "3531063629",
      "display" : "志銘小兒科診所"
    },
    {
      "code" : "3531063647",
      "display" : "幸福小兒科診所"
    },
    {
      "code" : "3531063674",
      "display" : "大新大診所"
    },
    {
      "code" : "3531063790",
      "display" : "錦興皮膚科診所"
    },
    {
      "code" : "3531063807",
      "display" : "安諾婦產科診所"
    },
    {
      "code" : "3531063825",
      "display" : "大學眼科診所"
    },
    {
      "code" : "3531063861",
      "display" : "大益診所"
    },
    {
      "code" : "3531063870",
      "display" : "新庚診所"
    },
    {
      "code" : "3531063941",
      "display" : "賴昌和皮膚科診所"
    },
    {
      "code" : "3531063969",
      "display" : "新莊惠欣婦產科小兒科診所"
    },
    {
      "code" : "3531064019",
      "display" : "宏祐診所"
    },
    {
      "code" : "3531064028",
      "display" : "大和復健科診所"
    },
    {
      "code" : "3531064055",
      "display" : "信榮診所"
    },
    {
      "code" : "3531064082",
      "display" : "曜生婦產科診所"
    },
    {
      "code" : "3531064091",
      "display" : "黃宏立診所"
    },
    {
      "code" : "3531064117",
      "display" : "麗新皮膚科診所"
    },
    {
      "code" : "3531064126",
      "display" : "廣田耳鼻喉科診所"
    },
    {
      "code" : "3531064199",
      "display" : "新莊大愛眼科診所"
    },
    {
      "code" : "3531064224",
      "display" : "家豐診所"
    },
    {
      "code" : "3531064233",
      "display" : "瑞和復健科診所"
    },
    {
      "code" : "3531064260",
      "display" : "李蓮宗診所"
    },
    {
      "code" : "3531064304",
      "display" : "公園診所"
    },
    {
      "code" : "3531064313",
      "display" : "一生診所"
    },
    {
      "code" : "3531064331",
      "display" : "隆安診所"
    },
    {
      "code" : "3531064368",
      "display" : "吳小兒科診所"
    },
    {
      "code" : "3531064420",
      "display" : "光華診所"
    },
    {
      "code" : "3531064439",
      "display" : "施博仁診所"
    },
    {
      "code" : "3531064448",
      "display" : "麗安診所"
    },
    {
      "code" : "3531064457",
      "display" : "春詠診所"
    },
    {
      "code" : "3531064466",
      "display" : "佳泰診所"
    },
    {
      "code" : "3531064484",
      "display" : "禾豐骨外科診所"
    },
    {
      "code" : "3531064500",
      "display" : "吳峰璋皮膚科診所"
    },
    {
      "code" : "3531064519",
      "display" : "上和耳鼻喉科診所"
    },
    {
      "code" : "3531064528",
      "display" : "輔大診所"
    },
    {
      "code" : "3531064537",
      "display" : "曉民診所"
    },
    {
      "code" : "3531064617",
      "display" : "家泰耳鼻喉科診所"
    },
    {
      "code" : "3531065123",
      "display" : "志安診所"
    },
    {
      "code" : "3531065133",
      "display" : "禾欣診所"
    },
    {
      "code" : "3531065141",
      "display" : "安庚內科診所"
    },
    {
      "code" : "3531065169",
      "display" : "樂寶兒婦幼診所"
    },
    {
      "code" : "3531065196",
      "display" : "嘉泰耳鼻喉科診所"
    },
    {
      "code" : "3531065221",
      "display" : "和新診所"
    },
    {
      "code" : "3531065230",
      "display" : "元程婦產科診所"
    },
    {
      "code" : "3531065249",
      "display" : "康熙診所"
    },
    {
      "code" : "3531065267",
      "display" : "陳世中耳鼻喉科診所"
    },
    {
      "code" : "3531065276",
      "display" : "泰興耳鼻喉科診所"
    },
    {
      "code" : "3531065294",
      "display" : "晉安診所"
    },
    {
      "code" : "3531065310",
      "display" : "新莊翰林眼科診所"
    },
    {
      "code" : "3531065329",
      "display" : "新莊實和復健診所"
    },
    {
      "code" : "3531065338",
      "display" : "富康骨科診所"
    },
    {
      "code" : "3531065356",
      "display" : "上友兒童診所"
    },
    {
      "code" : "3531065392",
      "display" : "合新診所"
    },
    {
      "code" : "3531065445",
      "display" : "新復興診所"
    },
    {
      "code" : "3531065472",
      "display" : "原華診所"
    },
    {
      "code" : "3531065490",
      "display" : "新莊新仁診所"
    },
    {
      "code" : "3531065507",
      "display" : "禾新耳鼻喉科診所"
    },
    {
      "code" : "3531065525",
      "display" : "新莊睛彩眼科診所"
    },
    {
      "code" : "3531065561",
      "display" : "育慶小兒科診所"
    },
    {
      "code" : "3531065598",
      "display" : "魏皮膚科診所"
    },
    {
      "code" : "3531065605",
      "display" : "文鼎診所"
    },
    {
      "code" : "3531065623",
      "display" : "天佑診所"
    },
    {
      "code" : "3531065669",
      "display" : "恩典診所"
    },
    {
      "code" : "3531065678",
      "display" : "晴美身心診所"
    },
    {
      "code" : "3531065687",
      "display" : "育心身心精神科診所"
    },
    {
      "code" : "3531065703",
      "display" : "幸福骨科診所"
    },
    {
      "code" : "3531065712",
      "display" : "至祥診所"
    },
    {
      "code" : "3531065730",
      "display" : "弘久診所"
    },
    {
      "code" : "3531065794",
      "display" : "自立診所"
    },
    {
      "code" : "3531065829",
      "display" : "樂樂診所"
    },
    {
      "code" : "3531065883",
      "display" : "大方診所"
    },
    {
      "code" : "3531065892",
      "display" : "健恩診所"
    },
    {
      "code" : "3531065909",
      "display" : "盛豐診所"
    },
    {
      "code" : "3531065927",
      "display" : "明新診所"
    },
    {
      "code" : "3531065936",
      "display" : "宏久診所"
    },
    {
      "code" : "3531065945",
      "display" : "昌明耳鼻喉科診所"
    },
    {
      "code" : "3531065972",
      "display" : "新莊至善診所"
    },
    {
      "code" : "3531065981",
      "display" : "微笑23眼科診所"
    },
    {
      "code" : "3531066004",
      "display" : "中平耳鼻喉科診所"
    },
    {
      "code" : "3531066013",
      "display" : "思原內科診所"
    },
    {
      "code" : "3531066022",
      "display" : "新康骨科診所"
    },
    {
      "code" : "3531066040",
      "display" : "信賴皮膚專科診所"
    },
    {
      "code" : "3531066059",
      "display" : "好心情身心精神科診所"
    },
    {
      "code" : "3531066068",
      "display" : "軒琪耳鼻喉科診所"
    },
    {
      "code" : "3531066077",
      "display" : "英群骨科診所"
    },
    {
      "code" : "3531066095",
      "display" : "璟順骨科診所"
    },
    {
      "code" : "3531066111",
      "display" : "成泰診所"
    },
    {
      "code" : "3531066139",
      "display" : "家福診所"
    },
    {
      "code" : "3531066148",
      "display" : "家慈診所"
    },
    {
      "code" : "3531066166",
      "display" : "巧兒親子診所"
    },
    {
      "code" : "3531066228",
      "display" : "安田耳鼻喉科診所"
    },
    {
      "code" : "3531066237",
      "display" : "立安耳鼻喉科診所"
    },
    {
      "code" : "3531066264",
      "display" : "思賢診所"
    },
    {
      "code" : "3531066273",
      "display" : "寶祥診所"
    },
    {
      "code" : "3531066282",
      "display" : "建嘉小兒科診所"
    },
    {
      "code" : "3531066291",
      "display" : "果仁小兒科診所"
    },
    {
      "code" : "3531066308",
      "display" : "杏原診所"
    },
    {
      "code" : "3531066317",
      "display" : "新欣診所"
    },
    {
      "code" : "3531066335",
      "display" : "維修診所"
    },
    {
      "code" : "3531066353",
      "display" : "王一成診所"
    },
    {
      "code" : "3531066415",
      "display" : "家貞診所"
    },
    {
      "code" : "3531066433",
      "display" : "軒禾診所"
    },
    {
      "code" : "3531066451",
      "display" : "童麗娜皮膚專科診所"
    },
    {
      "code" : "3531066460",
      "display" : "馥齡診所"
    },
    {
      "code" : "3531066479",
      "display" : "晶盈眼科診所"
    },
    {
      "code" : "3531066531",
      "display" : "永悅診所"
    },
    {
      "code" : "3531066540",
      "display" : "唯修診所"
    },
    {
      "code" : "3531066559",
      "display" : "新莊葉自強診所"
    },
    {
      "code" : "3531066568",
      "display" : "張博堯診所"
    },
    {
      "code" : "3531066577",
      "display" : "仁大耳鼻喉科診所"
    },
    {
      "code" : "3531066586",
      "display" : "立丞診所"
    },
    {
      "code" : "3531066595",
      "display" : "加恩診所"
    },
    {
      "code" : "3531066602",
      "display" : "杏軒診所"
    },
    {
      "code" : "3531066611",
      "display" : "穩達診所"
    },
    {
      "code" : "3531066620",
      "display" : "頂安診所"
    },
    {
      "code" : "3531066639",
      "display" : "皮醫師新莊診所"
    },
    {
      "code" : "3531066675",
      "display" : "卓新復健科診所"
    },
    {
      "code" : "3531066693",
      "display" : "杏誠診所"
    },
    {
      "code" : "3531066700",
      "display" : "世博診所"
    },
    {
      "code" : "3531066728",
      "display" : "力新診所"
    },
    {
      "code" : "3531066737",
      "display" : "宜新診所"
    },
    {
      "code" : "3531066755",
      "display" : "逸好診所"
    },
    {
      "code" : "3531066782",
      "display" : "恆友精神科診所"
    },
    {
      "code" : "3531066808",
      "display" : "心翔身心精神科診所"
    },
    {
      "code" : "3531066817",
      "display" : "祥佑診所"
    },
    {
      "code" : "3531066844",
      "display" : "幸福大愛眼科診所"
    },
    {
      "code" : "3531066853",
      "display" : "昕康耳鼻喉科診所"
    },
    {
      "code" : "3531066862",
      "display" : "鄭仁壽耳鼻喉科診所"
    },
    {
      "code" : "3531066871",
      "display" : "順新復健科診所"
    },
    {
      "code" : "3531066899",
      "display" : "鉅儒診所"
    },
    {
      "code" : "3531066906",
      "display" : "富都心診所"
    },
    {
      "code" : "3531066915",
      "display" : "宇康診所"
    },
    {
      "code" : "3531066924",
      "display" : "杏誠診所"
    },
    {
      "code" : "3531066933",
      "display" : "新莊軒琪診所"
    },
    {
      "code" : "3531066942",
      "display" : "新和耳鼻喉科診所"
    },
    {
      "code" : "3531066951",
      "display" : "鉅儒診所"
    },
    {
      "code" : "3531066960",
      "display" : "新莊高美泌尿科診所"
    },
    {
      "code" : "3531066979",
      "display" : "信榮診所"
    },
    {
      "code" : "3531066988",
      "display" : "輔大診所"
    },
    {
      "code" : "3531067001",
      "display" : "宥澄診所"
    },
    {
      "code" : "3531067029",
      "display" : "柏宏診所"
    },
    {
      "code" : "3531067038",
      "display" : "鉅儒診所"
    },
    {
      "code" : "3531067047",
      "display" : "吉利診所"
    },
    {
      "code" : "3531067056",
      "display" : "新安小兒科診所"
    },
    {
      "code" : "3531067065",
      "display" : "書心健康管理診所"
    },
    {
      "code" : "3531067074",
      "display" : "百安診所"
    },
    {
      "code" : "3531067083",
      "display" : "威力親子診所"
    },
    {
      "code" : "3531067092",
      "display" : "波力診所"
    },
    {
      "code" : "3531067109",
      "display" : "幸福小兒科診所"
    },
    {
      "code" : "3531067118",
      "display" : "世博診所"
    },
    {
      "code" : "3531067127",
      "display" : "文鼎診所"
    },
    {
      "code" : "3531067136",
      "display" : "好心情身心精神科診所"
    },
    {
      "code" : "3531067154",
      "display" : "暖新診所"
    },
    {
      "code" : "3531067172",
      "display" : "明醫達特楊眼科診所"
    },
    {
      "code" : "3531067181",
      "display" : "吉利診所"
    },
    {
      "code" : "3531067190",
      "display" : "宏太診所"
    },
    {
      "code" : "3531067216",
      "display" : "溫時光診所"
    },
    {
      "code" : "3531067252",
      "display" : "福興馥齡診所"
    },
    {
      "code" : "3531067270",
      "display" : "信賴診所"
    },
    {
      "code" : "3531067298",
      "display" : "宇康診所"
    },
    {
      "code" : "3531067305",
      "display" : "愛寧診所"
    },
    {
      "code" : "3531067314",
      "display" : "吉利診所"
    },
    {
      "code" : "3531067323",
      "display" : "新莊活力復健診所"
    },
    {
      "code" : "3531067332",
      "display" : "言川診所"
    },
    {
      "code" : "3531067341",
      "display" : "丹鳳至祥診所"
    },
    {
      "code" : "3531067350",
      "display" : "富國至祥診所"
    },
    {
      "code" : "3531067378",
      "display" : "家豐診所"
    },
    {
      "code" : "3531067387",
      "display" : "藝群新莊診所"
    },
    {
      "code" : "3531067396",
      "display" : "陳宏達親子診所"
    },
    {
      "code" : "3531067421",
      "display" : "立恩診所"
    },
    {
      "code" : "3531067430",
      "display" : "上京診所"
    },
    {
      "code" : "3531067449",
      "display" : "全威復健科診所"
    },
    {
      "code" : "3531067467",
      "display" : "禾欣診所"
    },
    {
      "code" : "3531067494",
      "display" : "中外醫學診所"
    },
    {
      "code" : "3531067529",
      "display" : "新莊好幸福泌尿科診所"
    },
    {
      "code" : "3531067547",
      "display" : "昀樂身心診所"
    },
    {
      "code" : "3531067565",
      "display" : "新莊寶島眼科診所"
    },
    {
      "code" : "3531067583",
      "display" : "新莊高美泌尿科診所"
    },
    {
      "code" : "3531070017",
      "display" : "賴內科小兒科診所"
    },
    {
      "code" : "3531070099",
      "display" : "許芳豪內科小兒科診所"
    },
    {
      "code" : "3531070133",
      "display" : "賴貞祥婦產科診所"
    },
    {
      "code" : "3531070295",
      "display" : "合聖診所"
    },
    {
      "code" : "3531070339",
      "display" : "杏恩診所"
    },
    {
      "code" : "3531070375",
      "display" : "周眼科診所"
    },
    {
      "code" : "3531070400",
      "display" : "合順診所"
    },
    {
      "code" : "3531070419",
      "display" : "博民診所"
    },
    {
      "code" : "3531070455",
      "display" : "山佳診所"
    },
    {
      "code" : "3531070544",
      "display" : "幼安聯合診所"
    },
    {
      "code" : "3531070599",
      "display" : "敏昌診所"
    },
    {
      "code" : "3531070651",
      "display" : "詠聖診所"
    },
    {
      "code" : "3531070722",
      "display" : "念生耳鼻喉科診所"
    },
    {
      "code" : "3531070759",
      "display" : "佳生婦產科診所"
    },
    {
      "code" : "3531070820",
      "display" : "樹林泰新診所"
    },
    {
      "code" : "3531071907",
      "display" : "遠祺婦產科診所"
    },
    {
      "code" : "3531071943",
      "display" : "朱水松耳鼻喉科診所"
    },
    {
      "code" : "3531071970",
      "display" : "林岳宏小兒科陳德馨皮膚科聯合診所"
    },
    {
      "code" : "3531071998",
      "display" : "安濟診所"
    },
    {
      "code" : "3531072048",
      "display" : "樹新耳鼻喉科診所"
    },
    {
      "code" : "3531072057",
      "display" : "三福診所"
    },
    {
      "code" : "3531072084",
      "display" : "蔡瓊倩內科診所"
    },
    {
      "code" : "3531072137",
      "display" : "何廷裕小兒科診所"
    },
    {
      "code" : "3531072146",
      "display" : "柯盈賢小兒科診所"
    },
    {
      "code" : "3531072164",
      "display" : "興明皮膚專科診所"
    },
    {
      "code" : "3531072182",
      "display" : "正安診所"
    },
    {
      "code" : "3531072208",
      "display" : "家祥診所"
    },
    {
      "code" : "3531072225",
      "display" : "承恩診所"
    },
    {
      "code" : "3531072235",
      "display" : "千歲小兒科診所"
    },
    {
      "code" : "3531072253",
      "display" : "鄭仲欽皮膚科診所"
    },
    {
      "code" : "3531072271",
      "display" : "柚子小兒科診所"
    },
    {
      "code" : "3531072280",
      "display" : "松禾診所"
    },
    {
      "code" : "3531072306",
      "display" : "安泰診所"
    },
    {
      "code" : "3531072315",
      "display" : "揚昇診所"
    },
    {
      "code" : "3531072360",
      "display" : "高啟原復健診所"
    },
    {
      "code" : "3531072379",
      "display" : "大樹診所"
    },
    {
      "code" : "3531072404",
      "display" : "永峰診所"
    },
    {
      "code" : "3531072413",
      "display" : "誠陽復健科診所"
    },
    {
      "code" : "3531072422",
      "display" : "莊豐如診所"
    },
    {
      "code" : "3531072431",
      "display" : "星瞳眼科診所"
    },
    {
      "code" : "3531072440",
      "display" : "惠生保安婦幼診所"
    },
    {
      "code" : "3531072459",
      "display" : "喜悅診所"
    },
    {
      "code" : "3531072468",
      "display" : "信和診所"
    },
    {
      "code" : "3531072477",
      "display" : "信和耳鼻喉科診所"
    },
    {
      "code" : "3531072486",
      "display" : "康普生眼科診所"
    },
    {
      "code" : "3531072502",
      "display" : "三樹金鶯診所"
    },
    {
      "code" : "3531072511",
      "display" : "大英診所"
    },
    {
      "code" : "3531072539",
      "display" : "立康診所"
    },
    {
      "code" : "3531072557",
      "display" : "愛雅婦產科診所"
    },
    {
      "code" : "3531072566",
      "display" : "新北大診所"
    },
    {
      "code" : "3531072575",
      "display" : "樹林金鶯診所"
    },
    {
      "code" : "3531072584",
      "display" : "千惠診所"
    },
    {
      "code" : "3531072593",
      "display" : "順立骨科診所"
    },
    {
      "code" : "3531072600",
      "display" : "興明診所"
    },
    {
      "code" : "3531072619",
      "display" : "欣悅親子耳鼻喉科診所"
    },
    {
      "code" : "3531072628",
      "display" : "欣悅內科診所"
    },
    {
      "code" : "3531072637",
      "display" : "北大診所"
    },
    {
      "code" : "3531072646",
      "display" : "樹林立康診所"
    },
    {
      "code" : "3531072682",
      "display" : "三樹金鶯診所"
    },
    {
      "code" : "3531072691",
      "display" : "樹林現代診所"
    },
    {
      "code" : "3531072708",
      "display" : "興明皮膚專科診所"
    },
    {
      "code" : "3531072717",
      "display" : "胃康診所"
    },
    {
      "code" : "3531072726",
      "display" : "佑宸診所"
    },
    {
      "code" : "3531072753",
      "display" : "立康診所"
    },
    {
      "code" : "3531072762",
      "display" : "泰禾骨科診所"
    },
    {
      "code" : "3531072771",
      "display" : "柚子小兒科診所"
    },
    {
      "code" : "3531080175",
      "display" : "鄭龍傑診所"
    },
    {
      "code" : "3531080193",
      "display" : "黃家庭醫學科診所"
    },
    {
      "code" : "3531080200",
      "display" : "崇文診所"
    },
    {
      "code" : "3531080219",
      "display" : "詹王成婦產科診所"
    },
    {
      "code" : "3531080228",
      "display" : "秦德水家庭醫學科診所"
    },
    {
      "code" : "3531080255",
      "display" : "陳文隆外科診所"
    },
    {
      "code" : "3531080264",
      "display" : "博音診所"
    },
    {
      "code" : "3531080344",
      "display" : "麥婦產科診所"
    },
    {
      "code" : "3531080353",
      "display" : "博美皮膚科診所"
    },
    {
      "code" : "3531080380",
      "display" : "建國耳鼻喉科診所"
    },
    {
      "code" : "3531080406",
      "display" : "韓乃輝診所"
    },
    {
      "code" : "3531080433",
      "display" : "康健家庭醫學科診所"
    },
    {
      "code" : "3531081494",
      "display" : "慈德聯合診所"
    },
    {
      "code" : "3531081529",
      "display" : "明輝眼科診所"
    },
    {
      "code" : "3531081538",
      "display" : "怡兒診所"
    },
    {
      "code" : "3531081574",
      "display" : "立好診所"
    },
    {
      "code" : "3531081636",
      "display" : "維新診所"
    },
    {
      "code" : "3531081654",
      "display" : "養心診所"
    },
    {
      "code" : "3531081663",
      "display" : "金鶯診所"
    },
    {
      "code" : "3531081672",
      "display" : "大山耳鼻喉科診所"
    },
    {
      "code" : "3531081690",
      "display" : "幸安診所"
    },
    {
      "code" : "3531081716",
      "display" : "澄欣復健科診所"
    },
    {
      "code" : "3531081734",
      "display" : "新英診所"
    },
    {
      "code" : "3531081752",
      "display" : "欣慈診所"
    },
    {
      "code" : "3531081770",
      "display" : "家康診所"
    },
    {
      "code" : "3531081789",
      "display" : "佳晟診所"
    },
    {
      "code" : "3531081805",
      "display" : "崇明診所"
    },
    {
      "code" : "3531081823",
      "display" : "金鶯診所"
    },
    {
      "code" : "3531081832",
      "display" : "真秦診所"
    },
    {
      "code" : "3531090055",
      "display" : "主恩診所"
    },
    {
      "code" : "3531090171",
      "display" : "彭耳鼻喉科診所"
    },
    {
      "code" : "3531090206",
      "display" : "永澄診所"
    },
    {
      "code" : "3531090288",
      "display" : "詹小兒科診所"
    },
    {
      "code" : "3531090386",
      "display" : "錦霖診所"
    },
    {
      "code" : "3531090439",
      "display" : "趙敏政耳鼻喉科診所"
    },
    {
      "code" : "3531090448",
      "display" : "吉象診所"
    },
    {
      "code" : "3531091516",
      "display" : "詠康診所"
    },
    {
      "code" : "3531091614",
      "display" : "一盧診所"
    },
    {
      "code" : "3531091623",
      "display" : "慶霖診所"
    },
    {
      "code" : "3531091632",
      "display" : "新安診所"
    },
    {
      "code" : "3531091650",
      "display" : "建民診所"
    },
    {
      "code" : "3531091669",
      "display" : "名家皮膚科診所"
    },
    {
      "code" : "3531091729",
      "display" : "慧安診所"
    },
    {
      "code" : "3531091730",
      "display" : "甲東眼科診所"
    },
    {
      "code" : "3531091801",
      "display" : "謝明福復健科診所"
    },
    {
      "code" : "3531091838",
      "display" : "如原診所"
    },
    {
      "code" : "3531091856",
      "display" : "冠昕診所"
    },
    {
      "code" : "3531091883",
      "display" : "佳佑診所"
    },
    {
      "code" : "3531091909",
      "display" : "晴美眼科診所"
    },
    {
      "code" : "3531091936",
      "display" : "王湘琦身心診所"
    },
    {
      "code" : "3531091954",
      "display" : "安旭診所"
    },
    {
      "code" : "3531091963",
      "display" : "悅兒診所"
    },
    {
      "code" : "3531091972",
      "display" : "三峽大學眼科診所"
    },
    {
      "code" : "3531091981",
      "display" : "博智診所"
    },
    {
      "code" : "3531092013",
      "display" : "敏家診所"
    },
    {
      "code" : "3531092022",
      "display" : "聯鴻骨科診所"
    },
    {
      "code" : "3531092031",
      "display" : "三禾診所"
    },
    {
      "code" : "3531092040",
      "display" : "杏宜診所"
    },
    {
      "code" : "3531092068",
      "display" : "北大小兒科診所"
    },
    {
      "code" : "3531092086",
      "display" : "文化耳鼻喉科診所"
    },
    {
      "code" : "3531092102",
      "display" : "星龍耳鼻喉科診所"
    },
    {
      "code" : "3531092111",
      "display" : "新禾診所"
    },
    {
      "code" : "3531092139",
      "display" : "蕭皓天皮膚專科診所"
    },
    {
      "code" : "3531092157",
      "display" : "中園診所"
    },
    {
      "code" : "3531092166",
      "display" : "清福診所"
    },
    {
      "code" : "3531092175",
      "display" : "泓廷耳鼻喉科診所"
    },
    {
      "code" : "3531092193",
      "display" : "蘋果樹北大內科診所"
    },
    {
      "code" : "3531092200",
      "display" : "錦禾診所"
    },
    {
      "code" : "3531092219",
      "display" : "安膚診所"
    },
    {
      "code" : "3531092228",
      "display" : "慈佑診所"
    },
    {
      "code" : "3531092246",
      "display" : "祥福診所"
    },
    {
      "code" : "3531092264",
      "display" : "欣群耳鼻喉科診所"
    },
    {
      "code" : "3531092273",
      "display" : "蘋果樹北大診所"
    },
    {
      "code" : "3531092282",
      "display" : "常順診所"
    },
    {
      "code" : "3531092291",
      "display" : "文化耳鼻喉科診所"
    },
    {
      "code" : "3531092308",
      "display" : "三峽文化內科診所"
    },
    {
      "code" : "3531092317",
      "display" : "欣寧身心診所"
    },
    {
      "code" : "3531092326",
      "display" : "祥福診所"
    },
    {
      "code" : "3531092335",
      "display" : "蘋果樹北大診所"
    },
    {
      "code" : "3531092344",
      "display" : "安旭診所"
    },
    {
      "code" : "3531092353",
      "display" : "安旭診所"
    },
    {
      "code" : "3531100047",
      "display" : "黃秋陽診所"
    },
    {
      "code" : "3531100074",
      "display" : "林得時婦產科診所"
    },
    {
      "code" : "3531100136",
      "display" : "許景新耳鼻喉科診所"
    },
    {
      "code" : "3531100225",
      "display" : "李文旭內科診所"
    },
    {
      "code" : "3531100234",
      "display" : "陳世芳診所"
    },
    {
      "code" : "3531100314",
      "display" : "劉政耳鼻喉科診所"
    },
    {
      "code" : "3531100323",
      "display" : "新光家醫科診所"
    },
    {
      "code" : "3531100332",
      "display" : "淳仁聯合診所"
    },
    {
      "code" : "3531100341",
      "display" : "滙眾內科診所"
    },
    {
      "code" : "3531100350",
      "display" : "元明眼科診所"
    },
    {
      "code" : "3531100403",
      "display" : "永光眼科診所"
    },
    {
      "code" : "3531100412",
      "display" : "劉小冰兒科診所"
    },
    {
      "code" : "3531100421",
      "display" : "李兆然家醫科診所"
    },
    {
      "code" : "3531100529",
      "display" : "鴻恩診所"
    },
    {
      "code" : "3531100574",
      "display" : "博安診所"
    },
    {
      "code" : "3531104750",
      "display" : "華生家醫科皮膚科聯合診所"
    },
    {
      "code" : "3531104769",
      "display" : "大忠耳鼻喉科診所"
    },
    {
      "code" : "3531104778",
      "display" : "順生婦產科診所"
    },
    {
      "code" : "3531104803",
      "display" : "能安診所"
    },
    {
      "code" : "3531104821",
      "display" : "祐銘耳鼻喉科診所"
    },
    {
      "code" : "3531104876",
      "display" : "睛采眼科診所"
    },
    {
      "code" : "3531104894",
      "display" : "英專耳鼻喉科皮膚科診所"
    },
    {
      "code" : "3531104901",
      "display" : "梁衛賓診所"
    },
    {
      "code" : "3531104929",
      "display" : "黃麟偉診所"
    },
    {
      "code" : "3531104947",
      "display" : "水碓瑞安診所"
    },
    {
      "code" : "3531104956",
      "display" : "彩虹眼科診所"
    },
    {
      "code" : "3531104965",
      "display" : "怡安診所"
    },
    {
      "code" : "3531104974",
      "display" : "祐銘眼科診所"
    },
    {
      "code" : "3531104992",
      "display" : "淡海診所"
    },
    {
      "code" : "3531105006",
      "display" : "恩友診所"
    },
    {
      "code" : "3531105011",
      "display" : "卓訓德診所"
    },
    {
      "code" : "3531105024",
      "display" : "文川耳鼻喉科診所"
    },
    {
      "code" : "3531105060",
      "display" : "康如診所"
    },
    {
      "code" : "3531105104",
      "display" : "榮芳骨科診所"
    },
    {
      "code" : "3531105113",
      "display" : "陳灼彭身心醫診所"
    },
    {
      "code" : "3531105122",
      "display" : "頂好耳鼻喉科診所"
    },
    {
      "code" : "3531105168",
      "display" : "實康復健科診所"
    },
    {
      "code" : "3531105177",
      "display" : "匯康內科診所"
    },
    {
      "code" : "3531105186",
      "display" : "陳正熙診所"
    },
    {
      "code" : "3531105202",
      "display" : "菲絲美診所"
    },
    {
      "code" : "3531105220",
      "display" : "呂仁金皮膚科診所"
    },
    {
      "code" : "3531105239",
      "display" : "旭安診所"
    },
    {
      "code" : "3531105266",
      "display" : "宜禾家醫診所"
    },
    {
      "code" : "3531105284",
      "display" : "心悅身心診所"
    },
    {
      "code" : "3531105293",
      "display" : "沐恩診所"
    },
    {
      "code" : "3531105346",
      "display" : "喜聖診所"
    },
    {
      "code" : "3531105355",
      "display" : "加惠診所"
    },
    {
      "code" : "3531105364",
      "display" : "怡和診所"
    },
    {
      "code" : "3531105373",
      "display" : "禾原內科診所"
    },
    {
      "code" : "3531105382",
      "display" : "公祥診所"
    },
    {
      "code" : "3531105391",
      "display" : "慧腎診所"
    },
    {
      "code" : "3531105408",
      "display" : "新浥診所"
    },
    {
      "code" : "3531105417",
      "display" : "喜聖診所"
    },
    {
      "code" : "3531105426",
      "display" : "新浥診所"
    },
    {
      "code" : "3531105444",
      "display" : "龍安莊耳鼻喉科診所"
    },
    {
      "code" : "3531105453",
      "display" : "怡和診所"
    },
    {
      "code" : "3531105462",
      "display" : "日聖眼科診所"
    },
    {
      "code" : "3531110025",
      "display" : "楊內科小兒科診所"
    },
    {
      "code" : "3531110052",
      "display" : "民生診所"
    },
    {
      "code" : "3531110187",
      "display" : "鄭漢財耳鼻喉科診所"
    },
    {
      "code" : "3531110338",
      "display" : "佑昌內科診所"
    },
    {
      "code" : "3531110356",
      "display" : "佑安診所"
    },
    {
      "code" : "3531110605",
      "display" : "黃玟珍診所"
    },
    {
      "code" : "3531110623",
      "display" : "弘人小兒科診所"
    },
    {
      "code" : "3531110650",
      "display" : "高登眼科診所"
    },
    {
      "code" : "3531110687",
      "display" : "宏彬診所"
    },
    {
      "code" : "3531110829",
      "display" : "蘇右任耳鼻喉科診所"
    },
    {
      "code" : "3531110838",
      "display" : "戴政傑診所"
    },
    {
      "code" : "3531110847",
      "display" : "汐止長青診所"
    },
    {
      "code" : "3531110856",
      "display" : "吳宗憲診所"
    },
    {
      "code" : "3531110874",
      "display" : "羅小兒科診所"
    },
    {
      "code" : "3531110927",
      "display" : "元泰診所"
    },
    {
      "code" : "3531110954",
      "display" : "李懷德小兒科診所"
    },
    {
      "code" : "3531110972",
      "display" : "湖前診所"
    },
    {
      "code" : "3531111022",
      "display" : "陳正恆小兒科診所"
    },
    {
      "code" : "3531111031",
      "display" : "洪皮膚科診所"
    },
    {
      "code" : "3531111077",
      "display" : "東暉診所"
    },
    {
      "code" : "3531112083",
      "display" : "佳祥診所"
    },
    {
      "code" : "3531112154",
      "display" : "彭耳鼻喉專科診所"
    },
    {
      "code" : "3531112216",
      "display" : "蘇小兒科診所"
    },
    {
      "code" : "3531112234",
      "display" : "吳婦產科診所"
    },
    {
      "code" : "3531112323",
      "display" : "許至仁診所"
    },
    {
      "code" : "3531112421",
      "display" : "青山診所"
    },
    {
      "code" : "3531112556",
      "display" : "洪耳鼻喉科診所"
    },
    {
      "code" : "3531112583",
      "display" : "朝芳診所"
    },
    {
      "code" : "3531112609",
      "display" : "雙雙小兒科診所"
    },
    {
      "code" : "3531112618",
      "display" : "福德診所"
    },
    {
      "code" : "3531112627",
      "display" : "世康診所"
    },
    {
      "code" : "3531112654",
      "display" : "祥和診所"
    },
    {
      "code" : "3531112707",
      "display" : "大同耳鼻喉科診所"
    },
    {
      "code" : "3531112716",
      "display" : "人禾小兒科診所"
    },
    {
      "code" : "3531112725",
      "display" : "洪振凱診所"
    },
    {
      "code" : "3531112752",
      "display" : "新和診所"
    },
    {
      "code" : "3531112798",
      "display" : "康寧耳鼻喉科診所"
    },
    {
      "code" : "3531112814",
      "display" : "謝宏杰身心精神科診所"
    },
    {
      "code" : "3531112823",
      "display" : "許哲豪皮膚科診所"
    },
    {
      "code" : "3531112841",
      "display" : "顏志瑋診所"
    },
    {
      "code" : "3531112869",
      "display" : "三益診所"
    },
    {
      "code" : "3531112887",
      "display" : "德祐小兒科診所"
    },
    {
      "code" : "3531112930",
      "display" : "鴻海診所"
    },
    {
      "code" : "3531112958",
      "display" : "新台安診所"
    },
    {
      "code" : "3531112976",
      "display" : "荃盛復健科診所"
    },
    {
      "code" : "3531112985",
      "display" : "美連心診所"
    },
    {
      "code" : "3531113017",
      "display" : "馨生婦產科小兒科診所"
    },
    {
      "code" : "3531113026",
      "display" : "馨悅婦產科診所"
    },
    {
      "code" : "3531113035",
      "display" : "合康診所"
    },
    {
      "code" : "3531113044",
      "display" : "佳林皮膚科診所"
    },
    {
      "code" : "3531113099",
      "display" : "鐊明診所"
    },
    {
      "code" : "3531113106",
      "display" : "皓明眼科診所"
    },
    {
      "code" : "3531113124",
      "display" : "晶華眼科診所"
    },
    {
      "code" : "3531113142",
      "display" : "茂昌眼科診所"
    },
    {
      "code" : "3531113179",
      "display" : "體生診所"
    },
    {
      "code" : "3531113204",
      "display" : "杏萱婦產科診所"
    },
    {
      "code" : "3531113222",
      "display" : "中欣診所"
    },
    {
      "code" : "3531113231",
      "display" : "東辰診所"
    },
    {
      "code" : "3531113268",
      "display" : "宏欣診所"
    },
    {
      "code" : "3531113277",
      "display" : "蘇怡菁家醫科診所"
    },
    {
      "code" : "3531113286",
      "display" : "巴黎國際長春診所"
    },
    {
      "code" : "3531113302",
      "display" : "田安診所"
    },
    {
      "code" : "3531113339",
      "display" : "恆御復健科診所"
    },
    {
      "code" : "3531113348",
      "display" : "汐止陳診所"
    },
    {
      "code" : "3531113357",
      "display" : "健欣骨科診所"
    },
    {
      "code" : "3531113366",
      "display" : "育和診所"
    },
    {
      "code" : "3531113375",
      "display" : "得美皮膚專科診所"
    },
    {
      "code" : "3531113384",
      "display" : "汐止力康復健科診所"
    },
    {
      "code" : "3531113400",
      "display" : "祐一復健科診所"
    },
    {
      "code" : "3531113437",
      "display" : "宏澤診所"
    },
    {
      "code" : "3531113455",
      "display" : "汐止有間診所"
    },
    {
      "code" : "3531113464",
      "display" : "汐止力康復健科診所"
    },
    {
      "code" : "3531113473",
      "display" : "聯成診所"
    },
    {
      "code" : "3531113482",
      "display" : "多麗診所"
    },
    {
      "code" : "3531113491",
      "display" : "汐止力康復健科診所"
    },
    {
      "code" : "3531113508",
      "display" : "安英診所"
    },
    {
      "code" : "3531113517",
      "display" : "幸湖診所"
    },
    {
      "code" : "3531113526",
      "display" : "多麗診所"
    },
    {
      "code" : "3531113535",
      "display" : "榮誠骨科診所"
    },
    {
      "code" : "3531113544",
      "display" : "汐止康麗診所"
    },
    {
      "code" : "3531120076",
      "display" : "簡診所"
    },
    {
      "code" : "3531120174",
      "display" : "家康陳診所"
    },
    {
      "code" : "3531120183",
      "display" : "詠安診所"
    },
    {
      "code" : "3531120227",
      "display" : "安星診所"
    },
    {
      "code" : "3531120254",
      "display" : "瑞光眼科診所"
    },
    {
      "code" : "3531120343",
      "display" : "瑞聯診所"
    },
    {
      "code" : "3531121528",
      "display" : "康橋診所"
    },
    {
      "code" : "3531121537",
      "display" : "健康１０１診所"
    },
    {
      "code" : "3531121546",
      "display" : "福康診所"
    },
    {
      "code" : "3531121573",
      "display" : "偉文診所"
    },
    {
      "code" : "3531121591",
      "display" : "瑞誠診所"
    },
    {
      "code" : "3531121608",
      "display" : "合安診所"
    },
    {
      "code" : "3531121617",
      "display" : "瑞豐診所"
    },
    {
      "code" : "3531121626",
      "display" : "晴安診所"
    },
    {
      "code" : "3531121635",
      "display" : "瑞豐診所"
    },
    {
      "code" : "3531121644",
      "display" : "健康１０１診所"
    },
    {
      "code" : "3531121653",
      "display" : "瑞豐診所"
    },
    {
      "code" : "3531130107",
      "display" : "李外科診所"
    },
    {
      "code" : "3531130125",
      "display" : "秀偉小兒科診所"
    },
    {
      "code" : "3531130189",
      "display" : "郭海昌診所"
    },
    {
      "code" : "3531130296",
      "display" : "余耳鼻喉科診所"
    },
    {
      "code" : "3531130358",
      "display" : "賴家庭醫學科診所"
    },
    {
      "code" : "3531130376",
      "display" : "廣福診所"
    },
    {
      "code" : "3531130401",
      "display" : "曾明禮皮膚科診所"
    },
    {
      "code" : "3531130410",
      "display" : "三安診所"
    },
    {
      "code" : "3531130447",
      "display" : "曾惠坤診所"
    },
    {
      "code" : "3531130483",
      "display" : "土城診所"
    },
    {
      "code" : "3531130536",
      "display" : "維安小兒科診所"
    },
    {
      "code" : "3531130545",
      "display" : "延吉診所"
    },
    {
      "code" : "3531130554",
      "display" : "李楫航小兒科診所"
    },
    {
      "code" : "3531130563",
      "display" : "學府周耳鼻喉科診所"
    },
    {
      "code" : "3531130572",
      "display" : "延平診所"
    },
    {
      "code" : "3531130607",
      "display" : "亞泰診所"
    },
    {
      "code" : "3531130616",
      "display" : "煌昌診所"
    },
    {
      "code" : "3531130634",
      "display" : "蔡永福小兒科診所"
    },
    {
      "code" : "3531130741",
      "display" : "歐家庭醫學科診所"
    },
    {
      "code" : "3531130750",
      "display" : "張國樑診所"
    },
    {
      "code" : "3531130769",
      "display" : "瞿眼科診所"
    },
    {
      "code" : "3531130796",
      "display" : "張孝馨診所"
    },
    {
      "code" : "3531130812",
      "display" : "廣全診所"
    },
    {
      "code" : "3531130830",
      "display" : "家峰耳鼻喉科診所"
    },
    {
      "code" : "3531130876",
      "display" : "鍾眼科診所"
    },
    {
      "code" : "3531130910",
      "display" : "維康診所"
    },
    {
      "code" : "3531130929",
      "display" : "嘉恩耳鼻喉科診所"
    },
    {
      "code" : "3531130956",
      "display" : "郭舒民診所"
    },
    {
      "code" : "3531131024",
      "display" : "王培玲診所"
    },
    {
      "code" : "3531131097",
      "display" : "城安耳鼻喉科診所"
    },
    {
      "code" : "3531131140",
      "display" : "泰康診所"
    },
    {
      "code" : "3531131202",
      "display" : "安祥婦產科診所"
    },
    {
      "code" : "3531132281",
      "display" : "梁診所"
    },
    {
      "code" : "3531132325",
      "display" : "學府實和聯合診所"
    },
    {
      "code" : "3531132334",
      "display" : "莊京憲耳鼻喉科診所"
    },
    {
      "code" : "3531132389",
      "display" : "羅文亮小兒科診所"
    },
    {
      "code" : "3531132414",
      "display" : "廣泉診所"
    },
    {
      "code" : "3531132469",
      "display" : "元福診所"
    },
    {
      "code" : "3531132478",
      "display" : "祐生耳鼻喉科診所"
    },
    {
      "code" : "3531132496",
      "display" : "宏陽耳鼻喉科診所"
    },
    {
      "code" : "3531132530",
      "display" : "康合診所"
    },
    {
      "code" : "3531132585",
      "display" : "吉康小兒科診所"
    },
    {
      "code" : "3531132638",
      "display" : "育昇診所"
    },
    {
      "code" : "3531132656",
      "display" : "新明診所"
    },
    {
      "code" : "3531132683",
      "display" : "吳俊穎眼科診所"
    },
    {
      "code" : "3531132709",
      "display" : "洪正祝小兒科診所"
    },
    {
      "code" : "3531132718",
      "display" : "土城劉內科診所"
    },
    {
      "code" : "3531132727",
      "display" : "祐生眼科診所"
    },
    {
      "code" : "3531132763",
      "display" : "林林診所"
    },
    {
      "code" : "3531132772",
      "display" : "健兒診所"
    },
    {
      "code" : "3531132816",
      "display" : "元佳診所"
    },
    {
      "code" : "3531132843",
      "display" : "蔡侑儒皮膚科診所"
    },
    {
      "code" : "3531132852",
      "display" : "土城學府皮膚科診所"
    },
    {
      "code" : "3531132889",
      "display" : "羅林小兒科診所"
    },
    {
      "code" : "3531132905",
      "display" : "惟馨婦產科診所"
    },
    {
      "code" : "3531132985",
      "display" : "健業診所"
    },
    {
      "code" : "3531133000",
      "display" : "誠安耳鼻喉科診所"
    },
    {
      "code" : "3531133037",
      "display" : "永佳婦產專科診所"
    },
    {
      "code" : "3531133064",
      "display" : "頂埔中心診所"
    },
    {
      "code" : "3531133117",
      "display" : "維誠小兒科診所"
    },
    {
      "code" : "3531133153",
      "display" : "城林小兒科診所"
    },
    {
      "code" : "3531133162",
      "display" : "謝志偉皮膚專科診所"
    },
    {
      "code" : "3531133171",
      "display" : "裕安診所"
    },
    {
      "code" : "3531133180",
      "display" : "誠康耳鼻喉科診所"
    },
    {
      "code" : "3531133206",
      "display" : "民安復健科診所"
    },
    {
      "code" : "3531133279",
      "display" : "永康身心診所"
    },
    {
      "code" : "3531133313",
      "display" : "上吉診所"
    },
    {
      "code" : "3531133331",
      "display" : "廣益診所"
    },
    {
      "code" : "3531133368",
      "display" : "博盛耳鼻喉科診所"
    },
    {
      "code" : "3531133377",
      "display" : "仁祐骨科診所"
    },
    {
      "code" : "3531133402",
      "display" : "博聖診所"
    },
    {
      "code" : "3531133420",
      "display" : "裕立診所"
    },
    {
      "code" : "3531133439",
      "display" : "名仁診所"
    },
    {
      "code" : "3531133475",
      "display" : "博勝診所"
    },
    {
      "code" : "3531133484",
      "display" : "立吉診所"
    },
    {
      "code" : "3531133500",
      "display" : "人人診所"
    },
    {
      "code" : "3531133519",
      "display" : "穗城復健科診所"
    },
    {
      "code" : "3531133537",
      "display" : "悠活精神科診所"
    },
    {
      "code" : "3531133546",
      "display" : "元德診所"
    },
    {
      "code" : "3531133555",
      "display" : "仁康診所"
    },
    {
      "code" : "3531133564",
      "display" : "建馨復健科診所"
    },
    {
      "code" : "3531133582",
      "display" : "光晶妍寶島眼科診所"
    },
    {
      "code" : "3531133591",
      "display" : "傾心婦產科診所"
    },
    {
      "code" : "3531133608",
      "display" : "大昌診所"
    },
    {
      "code" : "3531133617",
      "display" : "合康身心診所"
    },
    {
      "code" : "3531133626",
      "display" : "上承診所"
    },
    {
      "code" : "3531133635",
      "display" : "杏光骨科診所"
    },
    {
      "code" : "3531133644",
      "display" : "土城中央診所"
    },
    {
      "code" : "3531133653",
      "display" : "興城骨科診所"
    },
    {
      "code" : "3531133662",
      "display" : "涵恩婦產科診所"
    },
    {
      "code" : "3531133671",
      "display" : "祥恩診所"
    },
    {
      "code" : "3531133680",
      "display" : "立全診所"
    },
    {
      "code" : "3531133699",
      "display" : "上承診所"
    },
    {
      "code" : "3531133706",
      "display" : "奕馨親子診所"
    },
    {
      "code" : "3531133715",
      "display" : "瑞明診所"
    },
    {
      "code" : "3531133724",
      "display" : "裕民至祥診所"
    },
    {
      "code" : "3531133733",
      "display" : "青禾診所"
    },
    {
      "code" : "3531133742",
      "display" : "名仁診所"
    },
    {
      "code" : "3531133751",
      "display" : "土城光晶妍寶島診所"
    },
    {
      "code" : "3531133779",
      "display" : "裕民至祥診所"
    },
    {
      "code" : "3531133788",
      "display" : "圓心診所"
    },
    {
      "code" : "3531133797",
      "display" : "土城金鶯診所"
    },
    {
      "code" : "3531133804",
      "display" : "延和祥恩診所"
    },
    {
      "code" : "3531133813",
      "display" : "康城診所"
    },
    {
      "code" : "3531133822",
      "display" : "土城光晶妍寶島診所"
    },
    {
      "code" : "3531133831",
      "display" : "維恩骨科診所"
    },
    {
      "code" : "3531133840",
      "display" : "土城桃庚診所"
    },
    {
      "code" : "3531133859",
      "display" : "土城維力骨科診所"
    },
    {
      "code" : "3531133868",
      "display" : "同心學府診所"
    },
    {
      "code" : "3531133877",
      "display" : "土城康澤復健科診所"
    },
    {
      "code" : "3531133886",
      "display" : "廣詮診所"
    },
    {
      "code" : "3531133895",
      "display" : "土城康澤復健科診所"
    },
    {
      "code" : "3531133902",
      "display" : "土城桃庚診所"
    },
    {
      "code" : "3531133911",
      "display" : "土城金鶯診所"
    },
    {
      "code" : "3531133920",
      "display" : "同心學樂身心科診所"
    },
    {
      "code" : "3531133939",
      "display" : "土城康澤復健科診所"
    },
    {
      "code" : "3531133948",
      "display" : "合康身心診所"
    },
    {
      "code" : "3531140014",
      "display" : "李鴻圖診所"
    },
    {
      "code" : "3531140130",
      "display" : "共和診所"
    },
    {
      "code" : "3531140149",
      "display" : "莊炳煌診所"
    },
    {
      "code" : "3531140229",
      "display" : "洪文能診所"
    },
    {
      "code" : "3531140265",
      "display" : "顏鴻仁家庭醫學科診所"
    },
    {
      "code" : "3531140274",
      "display" : "王國欽耳鼻喉科診所"
    },
    {
      "code" : "3531140318",
      "display" : "陳介臣婦產科診所"
    },
    {
      "code" : "3531140354",
      "display" : "協和診所"
    },
    {
      "code" : "3531140372",
      "display" : "永全診所"
    },
    {
      "code" : "3531140489",
      "display" : "林錦榮小兒科診所"
    },
    {
      "code" : "3531140505",
      "display" : "蘆洲李耳鼻喉科診所"
    },
    {
      "code" : "3531140523",
      "display" : "潘眼科診所"
    },
    {
      "code" : "3531140587",
      "display" : "宏國診所"
    },
    {
      "code" : "3531140621",
      "display" : "宏康診所"
    },
    {
      "code" : "3531140710",
      "display" : "鴻昇診所"
    },
    {
      "code" : "3531140738",
      "display" : "劉安邦耳鼻喉科診所"
    },
    {
      "code" : "3531140747",
      "display" : "啟安婦產科家庭醫學科診所"
    },
    {
      "code" : "3531140774",
      "display" : "集賢內科診所"
    },
    {
      "code" : "3531140783",
      "display" : "曉兒耳鼻喉科診所"
    },
    {
      "code" : "3531140845",
      "display" : "華邦診所"
    },
    {
      "code" : "3531140907",
      "display" : "蘇眼科診所"
    },
    {
      "code" : "3531140916",
      "display" : "林昭良耳鼻喉科診所"
    },
    {
      "code" : "3531140934",
      "display" : "張眼科診所"
    },
    {
      "code" : "3531140943",
      "display" : "蘆洲成功耳鼻喉科診所"
    },
    {
      "code" : "3531142081",
      "display" : "聯邦診所"
    },
    {
      "code" : "3531142090",
      "display" : "鴻文耳鼻喉科診所"
    },
    {
      "code" : "3531142198",
      "display" : "詠贊聯合診所"
    },
    {
      "code" : "3531142250",
      "display" : "大安診所"
    },
    {
      "code" : "3531142269",
      "display" : "田眼科診所"
    },
    {
      "code" : "3531142358",
      "display" : "蘆洲立民診所"
    },
    {
      "code" : "3531142367",
      "display" : "寶明診所"
    },
    {
      "code" : "3531142394",
      "display" : "超群耳鼻喉科診所"
    },
    {
      "code" : "3531142410",
      "display" : "李明哲診所"
    },
    {
      "code" : "3531142456",
      "display" : "仁美診所"
    },
    {
      "code" : "3531142509",
      "display" : "民族診所"
    },
    {
      "code" : "3531142536",
      "display" : "群安診所"
    },
    {
      "code" : "3531142545",
      "display" : "長榮耳鼻喉科診所"
    },
    {
      "code" : "3531142616",
      "display" : "趙國雄診所"
    },
    {
      "code" : "3531142634",
      "display" : "蘆洲實和復健診所"
    },
    {
      "code" : "3531142661",
      "display" : "昱明診所"
    },
    {
      "code" : "3531142705",
      "display" : "宥宥婦幼診所"
    },
    {
      "code" : "3531142714",
      "display" : "上安診所"
    },
    {
      "code" : "3531142732",
      "display" : "真善美婦產科診所"
    },
    {
      "code" : "3531142769",
      "display" : "乾祐診所"
    },
    {
      "code" : "3531142803",
      "display" : "佑明眼科診所"
    },
    {
      "code" : "3531142830",
      "display" : "蘆洲大愛眼科診所"
    },
    {
      "code" : "3531142885",
      "display" : "蔡嘉哲骨科診所"
    },
    {
      "code" : "3531142894",
      "display" : "許修平診所"
    },
    {
      "code" : "3531142901",
      "display" : "樂活診所"
    },
    {
      "code" : "3531142938",
      "display" : "黃天一耳鼻喉科診所"
    },
    {
      "code" : "3531142947",
      "display" : "本一診所"
    },
    {
      "code" : "3531142974",
      "display" : "安美皮膚科診所"
    },
    {
      "code" : "3531142992",
      "display" : "壬康精神科診所"
    },
    {
      "code" : "3531143024",
      "display" : "宥宥小兒科診所"
    },
    {
      "code" : "3531143033",
      "display" : "杏東診所"
    },
    {
      "code" : "3531143060",
      "display" : "健群診所"
    },
    {
      "code" : "3531143088",
      "display" : "人安診所"
    },
    {
      "code" : "3531143097",
      "display" : "建群診所"
    },
    {
      "code" : "3531143104",
      "display" : "全嘉耳鼻喉科診所"
    },
    {
      "code" : "3531143113",
      "display" : "聖哲耳鼻喉科診所"
    },
    {
      "code" : "3531143140",
      "display" : "愛林鑫北診所"
    },
    {
      "code" : "3531143159",
      "display" : "湯瑪士親子兒科診所"
    },
    {
      "code" : "3531143177",
      "display" : "健群耳鼻喉科診所"
    },
    {
      "code" : "3531143186",
      "display" : "陳彥廷診所"
    },
    {
      "code" : "3531143275",
      "display" : "福田診所"
    },
    {
      "code" : "3531143284",
      "display" : "佑安耳鼻喉科診所"
    },
    {
      "code" : "3531143293",
      "display" : "欣彥身心診所"
    },
    {
      "code" : "3531143328",
      "display" : "仁川診所"
    },
    {
      "code" : "3531143364",
      "display" : "俊亨婦產科診所"
    },
    {
      "code" : "3531143373",
      "display" : "中山骨科診所"
    },
    {
      "code" : "3531143382",
      "display" : "愛麗生婦產科診所"
    },
    {
      "code" : "3531143391",
      "display" : "菁采皮膚專科診所"
    },
    {
      "code" : "3531143444",
      "display" : "兒樂吉診所"
    },
    {
      "code" : "3531143453",
      "display" : "安馨婦產科診所"
    },
    {
      "code" : "3531143462",
      "display" : "德興診所"
    },
    {
      "code" : "3531143471",
      "display" : "佳聖診所"
    },
    {
      "code" : "3531143480",
      "display" : "弘一診所"
    },
    {
      "code" : "3531143499",
      "display" : "東大眼科診所"
    },
    {
      "code" : "3531143506",
      "display" : "沅昇復健科診所"
    },
    {
      "code" : "3531143533",
      "display" : "六福診所"
    },
    {
      "code" : "3531143551",
      "display" : "健勇皮診所"
    },
    {
      "code" : "3531143579",
      "display" : "巨鼎骨科診所"
    },
    {
      "code" : "3531143604",
      "display" : "欣向美診所"
    },
    {
      "code" : "3531143613",
      "display" : "丁良文內科診所"
    },
    {
      "code" : "3531143622",
      "display" : "健安診所"
    },
    {
      "code" : "3531143631",
      "display" : "建安診所"
    },
    {
      "code" : "3531143640",
      "display" : "長安骨科診所"
    },
    {
      "code" : "3531143659",
      "display" : "明暘診所"
    },
    {
      "code" : "3531143686",
      "display" : "蘆洲現代耳鼻喉科診所"
    },
    {
      "code" : "3531143695",
      "display" : "蘆洲集賢耳鼻喉科診所"
    },
    {
      "code" : "3531143702",
      "display" : "蘆洲現代內科診所"
    },
    {
      "code" : "3531143711",
      "display" : "欣宥婦產科診所"
    },
    {
      "code" : "3531143720",
      "display" : "集安診所"
    },
    {
      "code" : "3531143766",
      "display" : "愛樂親子診所"
    },
    {
      "code" : "3531143775",
      "display" : "開心生活診所"
    },
    {
      "code" : "3531143784",
      "display" : "康廷耳鼻喉科診所"
    },
    {
      "code" : "3531143800",
      "display" : "健侒診所"
    },
    {
      "code" : "3531143819",
      "display" : "慶明眼科診所"
    },
    {
      "code" : "3531143828",
      "display" : "宜興診所"
    },
    {
      "code" : "3531143837",
      "display" : "泓安內科診所"
    },
    {
      "code" : "3531143855",
      "display" : "福安小兒科診所"
    },
    {
      "code" : "3531143864",
      "display" : "禾峰診所"
    },
    {
      "code" : "3531143873",
      "display" : "皮醫師蘆洲診所"
    },
    {
      "code" : "3531143882",
      "display" : "華安診所"
    },
    {
      "code" : "3531143917",
      "display" : "容光皮膚專科診所"
    },
    {
      "code" : "3531143926",
      "display" : "立博診所"
    },
    {
      "code" : "3531143935",
      "display" : "黃皮醫師診所"
    },
    {
      "code" : "3531143944",
      "display" : "長興骨科診所"
    },
    {
      "code" : "3531143953",
      "display" : "宜興診所"
    },
    {
      "code" : "3531143962",
      "display" : "華安診所"
    },
    {
      "code" : "3531143971",
      "display" : "杏暉復健科診所"
    },
    {
      "code" : "3531143999",
      "display" : "蘆洲上禾耳鼻喉科診所"
    },
    {
      "code" : "3531144003",
      "display" : "蘆洲上禾內科診所"
    },
    {
      "code" : "3531144021",
      "display" : "泓安內科診所"
    },
    {
      "code" : "3531144030",
      "display" : "天佑復健診所"
    },
    {
      "code" : "3531144049",
      "display" : "蘆洲諾貝爾眼科診所"
    },
    {
      "code" : "3531144058",
      "display" : "蘆洲現代皮膚科診所"
    },
    {
      "code" : "3531144067",
      "display" : "辰林診所"
    },
    {
      "code" : "3531144076",
      "display" : "品安安診所"
    },
    {
      "code" : "3531144085",
      "display" : "安邦耳鼻喉科診所"
    },
    {
      "code" : "3531144094",
      "display" : "合誼身心診所"
    },
    {
      "code" : "3531144101",
      "display" : "祐全復健科診所"
    },
    {
      "code" : "3531144129",
      "display" : "永欣骨科診所"
    },
    {
      "code" : "3531144138",
      "display" : "一生安診所"
    },
    {
      "code" : "3531150118",
      "display" : "黃志勳診所"
    },
    {
      "code" : "3531150163",
      "display" : "成洲診所"
    },
    {
      "code" : "3531150190",
      "display" : "英安診所"
    },
    {
      "code" : "3531150216",
      "display" : "鴻佑診所"
    },
    {
      "code" : "3531150323",
      "display" : "鐘耳鼻喉科診所"
    },
    {
      "code" : "3531151428",
      "display" : "信恆診所"
    },
    {
      "code" : "3531151517",
      "display" : "祐聖小兒科診所"
    },
    {
      "code" : "3531151535",
      "display" : "健泰診所"
    },
    {
      "code" : "3531151562",
      "display" : "嘉安小兒科診所"
    },
    {
      "code" : "3531151580",
      "display" : "宏昇診所"
    },
    {
      "code" : "3531151651",
      "display" : "德音診所"
    },
    {
      "code" : "3531151731",
      "display" : "五股水碓診所"
    },
    {
      "code" : "3531151768",
      "display" : "五福診所"
    },
    {
      "code" : "3531151777",
      "display" : "仁滙診所"
    },
    {
      "code" : "3531151795",
      "display" : "永任診所"
    },
    {
      "code" : "3531151802",
      "display" : "吉浤診所"
    },
    {
      "code" : "3531151811",
      "display" : "林筱琪診所"
    },
    {
      "code" : "3531151820",
      "display" : "翔展診所"
    },
    {
      "code" : "3531151839",
      "display" : "倍康復健科診所"
    },
    {
      "code" : "3531151848",
      "display" : "安忻診所"
    },
    {
      "code" : "3531160025",
      "display" : "陽明外科診所"
    },
    {
      "code" : "3531160043",
      "display" : "葉啟東婦產科診所"
    },
    {
      "code" : "3531160070",
      "display" : "泰生內科診所"
    },
    {
      "code" : "3531160089",
      "display" : "周外科診所"
    },
    {
      "code" : "3531160203",
      "display" : "溫法烈耳鼻喉科診所"
    },
    {
      "code" : "3531160230",
      "display" : "林慶國耳鼻喉科診所"
    },
    {
      "code" : "3531160258",
      "display" : "蔡興龍小兒科診所"
    },
    {
      "code" : "3531160267",
      "display" : "賴和鴻診所"
    },
    {
      "code" : "3531160285",
      "display" : "陳獻宗診所"
    },
    {
      "code" : "3531160294",
      "display" : "康泰診所"
    },
    {
      "code" : "3531160374",
      "display" : "黃耀立診所"
    },
    {
      "code" : "3531160418",
      "display" : "懷安小兒科診所"
    },
    {
      "code" : "3531161479",
      "display" : "余小兒科診所"
    },
    {
      "code" : "3531161497",
      "display" : "葆安診所"
    },
    {
      "code" : "3531161531",
      "display" : "楓江診所"
    },
    {
      "code" : "3531161540",
      "display" : "宏明診所"
    },
    {
      "code" : "3531161559",
      "display" : "佳欣診所"
    },
    {
      "code" : "3531161568",
      "display" : "泰和診所"
    },
    {
      "code" : "3531161577",
      "display" : "懷恩婦產科診所"
    },
    {
      "code" : "3531161595",
      "display" : "王嘉興診所"
    },
    {
      "code" : "3531161639",
      "display" : "雅致皮膚科診所"
    },
    {
      "code" : "3531161648",
      "display" : "泰安診所"
    },
    {
      "code" : "3531161657",
      "display" : "明泰診所"
    },
    {
      "code" : "3531161666",
      "display" : "弘森診所"
    },
    {
      "code" : "3531161684",
      "display" : "永旭診所"
    },
    {
      "code" : "3531161755",
      "display" : "仁愛家醫診所"
    },
    {
      "code" : "3531161764",
      "display" : "普生眼科診所"
    },
    {
      "code" : "3531161773",
      "display" : "永安診所"
    },
    {
      "code" : "3531161782",
      "display" : "泰山新庚診所"
    },
    {
      "code" : "3531161791",
      "display" : "頂好骨科診所"
    },
    {
      "code" : "3531161808",
      "display" : "倍嘉骨科診所"
    },
    {
      "code" : "3531161826",
      "display" : "泰山新庚診所"
    },
    {
      "code" : "3531161835",
      "display" : "惠安內科診所"
    },
    {
      "code" : "3531161844",
      "display" : "維德泰山診所"
    },
    {
      "code" : "3531161853",
      "display" : "泰山英仁診所"
    },
    {
      "code" : "3531170147",
      "display" : "仲全診所"
    },
    {
      "code" : "3531170174",
      "display" : "明揚診所"
    },
    {
      "code" : "3531170192",
      "display" : "捷仁診所"
    },
    {
      "code" : "3531170209",
      "display" : "佳眼科診所"
    },
    {
      "code" : "3531171304",
      "display" : "宏愛診所"
    },
    {
      "code" : "3531171322",
      "display" : "健雄診所"
    },
    {
      "code" : "3531171331",
      "display" : "豐家診所"
    },
    {
      "code" : "3531171340",
      "display" : "全英眼科診所"
    },
    {
      "code" : "3531171368",
      "display" : "侯志龍小兒科診所"
    },
    {
      "code" : "3531171386",
      "display" : "林漢邦診所"
    },
    {
      "code" : "3531171402",
      "display" : "麗林耳鼻喉科診所"
    },
    {
      "code" : "3531171439",
      "display" : "黃紹基診所"
    },
    {
      "code" : "3531171466",
      "display" : "宗男診所"
    },
    {
      "code" : "3531171484",
      "display" : "未來小兒科診所"
    },
    {
      "code" : "3531171493",
      "display" : "仁邦診所"
    },
    {
      "code" : "3531171519",
      "display" : "劉乃豪診所"
    },
    {
      "code" : "3531171528",
      "display" : "陽光耳鼻喉科診所"
    },
    {
      "code" : "3531171546",
      "display" : "未來婦產科診所"
    },
    {
      "code" : "3531171573",
      "display" : "何文藻皮膚科診所"
    },
    {
      "code" : "3531171617",
      "display" : "勝康骨科診所"
    },
    {
      "code" : "3531171635",
      "display" : "忠孝復健專科診所"
    },
    {
      "code" : "3531171671",
      "display" : "德林診所"
    },
    {
      "code" : "3531171706",
      "display" : "林口新康骨科診所"
    },
    {
      "code" : "3531171715",
      "display" : "陽光皮膚科診所"
    },
    {
      "code" : "3531171733",
      "display" : "陽光內科診所"
    },
    {
      "code" : "3531171742",
      "display" : "長泰皮膚科診所"
    },
    {
      "code" : "3531171779",
      "display" : "穎欣診所"
    },
    {
      "code" : "3531171804",
      "display" : "耀耀親子眼科診所"
    },
    {
      "code" : "3531171813",
      "display" : "親子耳鼻喉科診所"
    },
    {
      "code" : "3531171840",
      "display" : "宏觀眼科診所"
    },
    {
      "code" : "3531171859",
      "display" : "欣泉身心診所"
    },
    {
      "code" : "3531171895",
      "display" : "橙安親子診所"
    },
    {
      "code" : "3531171902",
      "display" : "拉法睡眠診所"
    },
    {
      "code" : "3531171957",
      "display" : "林口微笑親子耳鼻喉科診所"
    },
    {
      "code" : "3531171966",
      "display" : "博思診所"
    },
    {
      "code" : "3531171993",
      "display" : "林口微笑內科診所"
    },
    {
      "code" : "3531172007",
      "display" : "羊咩咩親子診所"
    },
    {
      "code" : "3531172025",
      "display" : "宇禾診所"
    },
    {
      "code" : "3531172034",
      "display" : "龍霖身心診所"
    },
    {
      "code" : "3531172052",
      "display" : "佑安內科診所"
    },
    {
      "code" : "3531172070",
      "display" : "杏蒔診所"
    },
    {
      "code" : "3531172089",
      "display" : "林口新康骨科診所"
    },
    {
      "code" : "3531172114",
      "display" : "博診所"
    },
    {
      "code" : "3531172123",
      "display" : "庚長優質診所"
    },
    {
      "code" : "3531172132",
      "display" : "林口微笑內科診所"
    },
    {
      "code" : "3531172141",
      "display" : "全英眼科診所"
    },
    {
      "code" : "3531172169",
      "display" : "耀耀親子眼科診所"
    },
    {
      "code" : "3531172178",
      "display" : "陽光皮膚科診所"
    },
    {
      "code" : "3531172187",
      "display" : "龍霖身心診所"
    },
    {
      "code" : "3531172196",
      "display" : "琢原診所"
    },
    {
      "code" : "3531172221",
      "display" : "林口抱抱心身醫學診所"
    },
    {
      "code" : "3531172230",
      "display" : "馬可耳鼻喉科診所"
    },
    {
      "code" : "3531172258",
      "display" : "雅丰林口診所"
    },
    {
      "code" : "3531172276",
      "display" : "慈韻美學婦科診所"
    },
    {
      "code" : "3531172329",
      "display" : "微笑耳鼻喉科診所"
    },
    {
      "code" : "3531172347",
      "display" : "林口樂誠診所"
    },
    {
      "code" : "3531172365",
      "display" : "成柏泌尿專科診所"
    },
    {
      "code" : "3531172374",
      "display" : "森冠診所"
    },
    {
      "code" : "3531172383",
      "display" : "森康診所"
    },
    {
      "code" : "3531172392",
      "display" : "貓頭鷹親子診所"
    },
    {
      "code" : "3531172409",
      "display" : "森宇耳鼻喉科診所"
    },
    {
      "code" : "3531172418",
      "display" : "微笑診所"
    },
    {
      "code" : "3531180081",
      "display" : "謝家庭醫學科診所"
    },
    {
      "code" : "3531180090",
      "display" : "淞德診所"
    },
    {
      "code" : "3531180152",
      "display" : "林振得診所"
    },
    {
      "code" : "3531180161",
      "display" : "健順診所"
    },
    {
      "code" : "3531180198",
      "display" : "幼恩診所"
    },
    {
      "code" : "3531181319",
      "display" : "麒安診所"
    },
    {
      "code" : "3531181337",
      "display" : "紹善診所"
    },
    {
      "code" : "3531181346",
      "display" : "妤皮診所"
    },
    {
      "code" : "3531181355",
      "display" : "瑞和診所"
    },
    {
      "code" : "3531181364",
      "display" : "詠靜診所"
    },
    {
      "code" : "3531181373",
      "display" : "詠靜診所"
    },
    {
      "code" : "3531210039",
      "display" : "常安診所"
    },
    {
      "code" : "3531211081",
      "display" : "三芝彭小兒科診所"
    },
    {
      "code" : "3531211090",
      "display" : "曾明診所"
    },
    {
      "code" : "3531230086",
      "display" : "施世明診所"
    },
    {
      "code" : "3531231136",
      "display" : "台加診所"
    },
    {
      "code" : "3531231145",
      "display" : "弘安診所"
    },
    {
      "code" : "3531231154",
      "display" : "文心診所"
    },
    {
      "code" : "3531231181",
      "display" : "周文煜診所"
    },
    {
      "code" : "3531231190",
      "display" : "誠泰診所"
    },
    {
      "code" : "3531231207",
      "display" : "維醫耳鼻喉科診所"
    },
    {
      "code" : "3531231216",
      "display" : "明醫診所"
    },
    {
      "code" : "3531231225",
      "display" : "安里診所"
    },
    {
      "code" : "3531231243",
      "display" : "安里診所"
    },
    {
      "code" : "3531241043",
      "display" : "瑞安診所"
    },
    {
      "code" : "3531251361",
      "display" : "冠麒診所"
    },
    {
      "code" : "3531251414",
      "display" : "保惠診所"
    },
    {
      "code" : "3531261134",
      "display" : "樂文診所"
    },
    {
      "code" : "3531270188",
      "display" : "東大診所"
    },
    {
      "code" : "3531271238",
      "display" : "百勝診所"
    },
    {
      "code" : "3531271292",
      "display" : "宜佑診所"
    },
    {
      "code" : "3531280059",
      "display" : "萬里診所"
    },
    {
      "code" : "3531281172",
      "display" : "享悅診所"
    },
    {
      "code" : "3531290028",
      "display" : "烏來安泰診所"
    },
    {
      "code" : "3531291123",
      "display" : "華成診所"
    },
    {
      "code" : "3534010031",
      "display" : "第一診所"
    },
    {
      "code" : "3534010157",
      "display" : "李富逸診所"
    },
    {
      "code" : "3534010166",
      "display" : "林內兒科診所"
    },
    {
      "code" : "3534010219",
      "display" : "莊耳鼻喉科診所"
    },
    {
      "code" : "3534010273",
      "display" : "周明偉診所"
    },
    {
      "code" : "3534010282",
      "display" : "李碧峯小兒科診所"
    },
    {
      "code" : "3534010308",
      "display" : "蔡仰中眼科診所"
    },
    {
      "code" : "3534010317",
      "display" : "黃芳裕診所"
    },
    {
      "code" : "3534010326",
      "display" : "明仁眼科診所"
    },
    {
      "code" : "3534010415",
      "display" : "華杏診所"
    },
    {
      "code" : "3534010433",
      "display" : "譚國勇婦產科診所"
    },
    {
      "code" : "3534010451",
      "display" : "徐英忠耳鼻喉科美形診所"
    },
    {
      "code" : "3534010497",
      "display" : "張志強眼科診所"
    },
    {
      "code" : "3534010522",
      "display" : "曹天德診所"
    },
    {
      "code" : "3534010531",
      "display" : "吳宗儒復健科診所"
    },
    {
      "code" : "3534010586",
      "display" : "陳義文小兒科診所"
    },
    {
      "code" : "3534010657",
      "display" : "林耳鼻喉科診所"
    },
    {
      "code" : "3534010684",
      "display" : "徐瑪里婦產科診所"
    },
    {
      "code" : "3534010693",
      "display" : "李耳鼻喉科診所"
    },
    {
      "code" : "3534010737",
      "display" : "李文生皮膚科診所"
    },
    {
      "code" : "3534010755",
      "display" : "黃建財診所"
    },
    {
      "code" : "3534010773",
      "display" : "潘仁進診所"
    },
    {
      "code" : "3534011789",
      "display" : "和信診所"
    },
    {
      "code" : "3534011805",
      "display" : "陳漢憲診所"
    },
    {
      "code" : "3534011814",
      "display" : "蔡俊逸診所"
    },
    {
      "code" : "3534011841",
      "display" : "陳耳鼻喉科診所"
    },
    {
      "code" : "3534011850",
      "display" : "永合診所"
    },
    {
      "code" : "3534011887",
      "display" : "聖恩診所"
    },
    {
      "code" : "3534011903",
      "display" : "聖心仁和診所"
    },
    {
      "code" : "3534011912",
      "display" : "鄭在鈞復健科診所"
    },
    {
      "code" : "3534011949",
      "display" : "宜蘭翰林眼科診所"
    },
    {
      "code" : "3534011994",
      "display" : "林宏俊診所"
    },
    {
      "code" : "3534012008",
      "display" : "建成診所"
    },
    {
      "code" : "3534012044",
      "display" : "卓越整形外科診所"
    },
    {
      "code" : "3534012053",
      "display" : "厚生診所"
    },
    {
      "code" : "3534012062",
      "display" : "開蘭安心診所"
    },
    {
      "code" : "3534012071",
      "display" : "得安診所"
    },
    {
      "code" : "3534012099",
      "display" : "許明哲耳鼻喉科診所"
    },
    {
      "code" : "3534012106",
      "display" : "青田診所"
    },
    {
      "code" : "3534012115",
      "display" : "呂學劼診所"
    },
    {
      "code" : "3534012124",
      "display" : "光中身心診所"
    },
    {
      "code" : "3534012151",
      "display" : "胡進忠眼科診所"
    },
    {
      "code" : "3534012160",
      "display" : "宜美皮膚科診所"
    },
    {
      "code" : "3534012197",
      "display" : "羅恭箎內科診所"
    },
    {
      "code" : "3534012204",
      "display" : "雅信診所"
    },
    {
      "code" : "3534012213",
      "display" : "小河馬診所"
    },
    {
      "code" : "3534012222",
      "display" : "朱俊源診所"
    },
    {
      "code" : "3534012231",
      "display" : "宜林大診所"
    },
    {
      "code" : "3534012240",
      "display" : "博幼親子診所"
    },
    {
      "code" : "3534012286",
      "display" : "曹思宏復健專科診所"
    },
    {
      "code" : "3534012295",
      "display" : "黃允吳診所"
    },
    {
      "code" : "3534012302",
      "display" : "長庚家安診所"
    },
    {
      "code" : "3534012311",
      "display" : "宜昇復健科診所"
    },
    {
      "code" : "3534012339",
      "display" : "潘仁佑診所"
    },
    {
      "code" : "3534012348",
      "display" : "李國賢內科診所"
    },
    {
      "code" : "3534012357",
      "display" : "松禾診所"
    },
    {
      "code" : "3534012366",
      "display" : "周中凱診所"
    },
    {
      "code" : "3534012375",
      "display" : "劉祖德內科診所"
    },
    {
      "code" : "3534012384",
      "display" : "嵐峰診所"
    },
    {
      "code" : "3534012393",
      "display" : "安欣耳鼻喉科診所"
    },
    {
      "code" : "3534012400",
      "display" : "泰山診所"
    },
    {
      "code" : "3534012419",
      "display" : "陳聖昌診所"
    },
    {
      "code" : "3534012428",
      "display" : "怡然診所"
    },
    {
      "code" : "3534012446",
      "display" : "松禾診所"
    },
    {
      "code" : "3534012455",
      "display" : "李子診所家庭醫學專科"
    },
    {
      "code" : "3534012464",
      "display" : "宜蘭好幸福泌尿科診所"
    },
    {
      "code" : "3534012473",
      "display" : "青田診所"
    },
    {
      "code" : "3534012482",
      "display" : "宜心內科診所"
    },
    {
      "code" : "3534020028",
      "display" : "優昇診所"
    },
    {
      "code" : "3534020046",
      "display" : "仁和診所"
    },
    {
      "code" : "3534020055",
      "display" : "明堂診所"
    },
    {
      "code" : "3534020153",
      "display" : "黃耀發小兒科診所"
    },
    {
      "code" : "3534020162",
      "display" : "五福診所"
    },
    {
      "code" : "3534020180",
      "display" : "吳眼科診所"
    },
    {
      "code" : "3534020206",
      "display" : "洪內兒科診所"
    },
    {
      "code" : "3534020215",
      "display" : "詹內兒科診所"
    },
    {
      "code" : "3534020224",
      "display" : "陳內兒科診所"
    },
    {
      "code" : "3534020288",
      "display" : "藍內兒科診所"
    },
    {
      "code" : "3534020304",
      "display" : "泰林診所"
    },
    {
      "code" : "3534020313",
      "display" : "石耳鼻喉科診所"
    },
    {
      "code" : "3534020340",
      "display" : "李建政耳鼻喉科診所"
    },
    {
      "code" : "3534020359",
      "display" : "謝漢池診所"
    },
    {
      "code" : "3534020368",
      "display" : "仁壽診所"
    },
    {
      "code" : "3534020395",
      "display" : "王維昌診所"
    },
    {
      "code" : "3534020411",
      "display" : "王步幸耳鼻喉科診所"
    },
    {
      "code" : "3534020420",
      "display" : "顏江龍整形外科診所"
    },
    {
      "code" : "3534020439",
      "display" : "呂耳鼻喉科診所"
    },
    {
      "code" : "3534020448",
      "display" : "侯眼科診所"
    },
    {
      "code" : "3534020537",
      "display" : "普濟診所"
    },
    {
      "code" : "3534020555",
      "display" : "溫家麟診所"
    },
    {
      "code" : "3534020573",
      "display" : "林正權婦產科診所"
    },
    {
      "code" : "3534020582",
      "display" : "北成診所"
    },
    {
      "code" : "3534020608",
      "display" : "陳文貴診所"
    },
    {
      "code" : "3534020626",
      "display" : "洪眼科診所"
    },
    {
      "code" : "3534020635",
      "display" : "吳振華小兒科診所"
    },
    {
      "code" : "3534020653",
      "display" : "洪仁宗診所"
    },
    {
      "code" : "3534020662",
      "display" : "信德診所"
    },
    {
      "code" : "3534020671",
      "display" : "芳山診所"
    },
    {
      "code" : "3534020680",
      "display" : "佳美診所"
    },
    {
      "code" : "3534020699",
      "display" : "羅東翰林眼科診所"
    },
    {
      "code" : "3534021730",
      "display" : "佳音診所"
    },
    {
      "code" : "3534021749",
      "display" : "黃圭龍小兒科診所"
    },
    {
      "code" : "3534021776",
      "display" : "蔡孟吉耳鼻喉科診所"
    },
    {
      "code" : "3534021801",
      "display" : "趙耳鼻喉科診所"
    },
    {
      "code" : "3534021838",
      "display" : "陳重慶診所"
    },
    {
      "code" : "3534021847",
      "display" : "吳得中診所"
    },
    {
      "code" : "3534021856",
      "display" : "謝世雄診所"
    },
    {
      "code" : "3534021883",
      "display" : "陳思衡復健科診所"
    },
    {
      "code" : "3534021892",
      "display" : "王仁暉皮膚科診所"
    },
    {
      "code" : "3534021909",
      "display" : "游信得診所"
    },
    {
      "code" : "3534021927",
      "display" : "游能俊診所"
    },
    {
      "code" : "3534021954",
      "display" : "藍正州小兒科診所"
    },
    {
      "code" : "3534021963",
      "display" : "維揚診所"
    },
    {
      "code" : "3534021990",
      "display" : "王東生診所"
    },
    {
      "code" : "3534022004",
      "display" : "林榆森小兒科診所"
    },
    {
      "code" : "3534022031",
      "display" : "家家診所"
    },
    {
      "code" : "3534022059",
      "display" : "光澤診所"
    },
    {
      "code" : "3534022068",
      "display" : "黃志賢婦產科診所"
    },
    {
      "code" : "3534022077",
      "display" : "羅東眼科診所"
    },
    {
      "code" : "3534022086",
      "display" : "東興婦產科診所"
    },
    {
      "code" : "3534022095",
      "display" : "林育全皮膚專科診所"
    },
    {
      "code" : "3534022102",
      "display" : "劉醫師小兒科診所"
    },
    {
      "code" : "3534022120",
      "display" : "傳康診所"
    },
    {
      "code" : "3534022139",
      "display" : "鍾昇亮內科診所"
    },
    {
      "code" : "3534022148",
      "display" : "簡世霖復健科診所"
    },
    {
      "code" : "3534022157",
      "display" : "陳煥文內科診所"
    },
    {
      "code" : "3534022175",
      "display" : "林嵩雅診所"
    },
    {
      "code" : "3534022184",
      "display" : "村却診所"
    },
    {
      "code" : "3534022193",
      "display" : "忠欣骨科診所"
    },
    {
      "code" : "3534022219",
      "display" : "王瀚生眼科診所"
    },
    {
      "code" : "3534022237",
      "display" : "佳恩醫療新活診所"
    },
    {
      "code" : "3534022255",
      "display" : "五餅二魚身心科診所"
    },
    {
      "code" : "3534022264",
      "display" : "大夫診所"
    },
    {
      "code" : "3534022291",
      "display" : "佳恩診所"
    },
    {
      "code" : "3534022308",
      "display" : "哈德診所"
    },
    {
      "code" : "3534030122",
      "display" : "吳慶順診所"
    },
    {
      "code" : "3534030140",
      "display" : "俞國棟診所"
    },
    {
      "code" : "3534030159",
      "display" : "周金章診所"
    },
    {
      "code" : "3534030284",
      "display" : "愛生診所"
    },
    {
      "code" : "3534031370",
      "display" : "金明診所"
    },
    {
      "code" : "3534031432",
      "display" : "曾家庭醫學科診所"
    },
    {
      "code" : "3534031469",
      "display" : "健生全民診所"
    },
    {
      "code" : "3534031503",
      "display" : "吳昌達診所"
    },
    {
      "code" : "3534031549",
      "display" : "健仁內科診所"
    },
    {
      "code" : "3534031558",
      "display" : "瑞明眼科診所"
    },
    {
      "code" : "3534031567",
      "display" : "徐世明診所"
    },
    {
      "code" : "3534031585",
      "display" : "建生診所"
    },
    {
      "code" : "3534040039",
      "display" : "李彰義診所"
    },
    {
      "code" : "3534040084",
      "display" : "仁宏診所"
    },
    {
      "code" : "3534040093",
      "display" : "博生診所"
    },
    {
      "code" : "3534040100",
      "display" : "頭城診所"
    },
    {
      "code" : "3534040119",
      "display" : "照仁診所"
    },
    {
      "code" : "3534040137",
      "display" : "吳芳霖眼科診所"
    },
    {
      "code" : "3534041189",
      "display" : "慈心診所"
    },
    {
      "code" : "3534041198",
      "display" : "大溪聖母診所"
    },
    {
      "code" : "3534050151",
      "display" : "周診所"
    },
    {
      "code" : "3534050197",
      "display" : "吳震世診所"
    },
    {
      "code" : "3534050204",
      "display" : "岱山診所"
    },
    {
      "code" : "3534051274",
      "display" : "安信診所"
    },
    {
      "code" : "3534051292",
      "display" : "岳成診所"
    },
    {
      "code" : "3534051309",
      "display" : "簡再興診所"
    },
    {
      "code" : "3534051318",
      "display" : "林智偉診所"
    },
    {
      "code" : "3534060059",
      "display" : "陳登賢診所"
    },
    {
      "code" : "3534061092",
      "display" : "大福診所"
    },
    {
      "code" : "3534061109",
      "display" : "楊崑診所"
    },
    {
      "code" : "3534061118",
      "display" : "愛德仁診所"
    },
    {
      "code" : "3534070108",
      "display" : "張世屏診所"
    },
    {
      "code" : "3534071123",
      "display" : "信望愛診所"
    },
    {
      "code" : "3534071141",
      "display" : "心安診所"
    },
    {
      "code" : "3534080104",
      "display" : "徐診所"
    },
    {
      "code" : "3534080113",
      "display" : "林聰源診所"
    },
    {
      "code" : "3534080122",
      "display" : "吳建志診所"
    },
    {
      "code" : "3534080131",
      "display" : "王內科診所"
    },
    {
      "code" : "3534080140",
      "display" : "江心修診所"
    },
    {
      "code" : "3534081165",
      "display" : "振生診所"
    },
    {
      "code" : "3534081183",
      "display" : "古醫生保健診所"
    },
    {
      "code" : "3534081192",
      "display" : "吳靜雯診所"
    },
    {
      "code" : "3534081209",
      "display" : "奕康內科診所"
    },
    {
      "code" : "3534091189",
      "display" : "吉祥診所"
    },
    {
      "code" : "3534091214",
      "display" : "宏安診所"
    },
    {
      "code" : "3534091287",
      "display" : "平和身心診所"
    },
    {
      "code" : "3534091312",
      "display" : "協和診所"
    },
    {
      "code" : "3534100030",
      "display" : "三星診所"
    },
    {
      "code" : "3534101064",
      "display" : "仁佑診所"
    },
    {
      "code" : "3534101082",
      "display" : "聖路加診所"
    },
    {
      "code" : "3534110554",
      "display" : "南山診所"
    },
    {
      "code" : "3534110563",
      "display" : "朝陽診所"
    },
    {
      "code" : "3534120023",
      "display" : "皇尚診所"
    },
    {
      "code" : "3534121039",
      "display" : "文平診所"
    },
    {
      "code" : "3534121075",
      "display" : "大愛診所"
    },
    {
      "code" : "3590010033",
      "display" : "大眾診所"
    },
    {
      "code" : "3590010060",
      "display" : "陳耳鼻喉科診所"
    },
    {
      "code" : "3590010097",
      "display" : "蔡建鑫小兒科家醫科診所"
    },
    {
      "code" : "3590011101",
      "display" : "長庚林小兒科診所"
    },
    {
      "code" : "3590011110",
      "display" : "李月娥家醫科婦產科診所"
    },
    {
      "code" : "3590011147",
      "display" : "惠明眼科診所"
    },
    {
      "code" : "3590011192",
      "display" : "陳毅書皮膚科診所"
    },
    {
      "code" : "3590011209",
      "display" : "王文君小兒科家庭醫學科診所"
    },
    {
      "code" : "3590011218",
      "display" : "吾家診所"
    },
    {
      "code" : "3590011236",
      "display" : "佑城診所"
    },
    {
      "code" : "3590011272",
      "display" : "金城診所"
    },
    {
      "code" : "3590011281",
      "display" : "安仁家醫科內科診所"
    },
    {
      "code" : "3590011316",
      "display" : "禾心診所"
    },
    {
      "code" : "3590011352",
      "display" : "健康診所"
    },
    {
      "code" : "3590011370",
      "display" : "康健診所"
    },
    {
      "code" : "3590011405",
      "display" : "傅仰賢診所"
    },
    {
      "code" : "3590011441",
      "display" : "鑫美光視光眼科診所"
    },
    {
      "code" : "3590011450",
      "display" : "愛人放心診所"
    },
    {
      "code" : "3590011478",
      "display" : "林怡廷皮膚科診所"
    },
    {
      "code" : "3590011487",
      "display" : "台大中心診所"
    },
    {
      "code" : "3590011496",
      "display" : "朗朗診所"
    },
    {
      "code" : "3590011503",
      "display" : "鑫美光診所"
    },
    {
      "code" : "3590021054",
      "display" : "重成診所"
    },
    {
      "code" : "3590021063",
      "display" : "金門美兆診所骨科"
    },
    {
      "code" : "3590030526",
      "display" : "彭小兒科診所"
    },
    {
      "code" : "3590030599",
      "display" : "三大診所"
    },
    {
      "code" : "3590030615",
      "display" : "康橋診所"
    },
    {
      "code" : "3590030624",
      "display" : "曾杏榕診所"
    },
    {
      "code" : "3590040013",
      "display" : "陳水湖診所"
    },
    {
      "code" : "3590040068",
      "display" : "合康家庭診所"
    },
    {
      "code" : "3590040102",
      "display" : "愛私醫診所"
    },
    {
      "code" : "3590050046",
      "display" : "安康診所"
    },
    {
      "code" : "3701010034",
      "display" : "長泰牙醫診所"
    },
    {
      "code" : "3701010043",
      "display" : "大統牙醫診所"
    },
    {
      "code" : "3701010061",
      "display" : "政雄牙醫診所"
    },
    {
      "code" : "3701010070",
      "display" : "新中牙醫診所"
    },
    {
      "code" : "3701010105",
      "display" : "哲伸牙醫診所"
    },
    {
      "code" : "3701010114",
      "display" : "明義牙醫診所"
    },
    {
      "code" : "3701010123",
      "display" : "國峰牙醫診所"
    },
    {
      "code" : "3701010169",
      "display" : "正信牙醫診所"
    },
    {
      "code" : "3701010178",
      "display" : "新華南牙醫診所"
    },
    {
      "code" : "3701010196",
      "display" : "李玉閣牙醫診所"
    },
    {
      "code" : "3701010203",
      "display" : "宏慈牙醫診所"
    },
    {
      "code" : "3701010212",
      "display" : "正斌牙醫診所"
    },
    {
      "code" : "3701010230",
      "display" : "偉德牙醫診所"
    },
    {
      "code" : "3701010249",
      "display" : "惠民牙醫診所"
    },
    {
      "code" : "3701010276",
      "display" : "施牙醫診所"
    },
    {
      "code" : "3701010285",
      "display" : "光泰牙醫診所"
    },
    {
      "code" : "3701010294",
      "display" : "得揚牙醫診所"
    },
    {
      "code" : "3701010374",
      "display" : "吉聖牙醫診所"
    },
    {
      "code" : "3701010383",
      "display" : "竹君牙醫診所"
    },
    {
      "code" : "3701010436",
      "display" : "元榜牙醫診所"
    },
    {
      "code" : "3701010472",
      "display" : "王樣牙醫診所"
    },
    {
      "code" : "3701010507",
      "display" : "周牙醫診所"
    },
    {
      "code" : "3701010534",
      "display" : "健本牙醫診所"
    },
    {
      "code" : "3701010543",
      "display" : "西松牙醫診所"
    },
    {
      "code" : "3701010570",
      "display" : "一泰牙醫診所"
    },
    {
      "code" : "3701010598",
      "display" : "怡德牙醫診所"
    },
    {
      "code" : "3701010605",
      "display" : "丘牙醫診所"
    },
    {
      "code" : "3701010776",
      "display" : "固榮牙醫診所"
    },
    {
      "code" : "3701010785",
      "display" : "西華牙醫診所"
    },
    {
      "code" : "3701010810",
      "display" : "麟翔牙醫診所"
    },
    {
      "code" : "3701010829",
      "display" : "生春牙醫診所"
    },
    {
      "code" : "3701010945",
      "display" : "雅安牙醫診所"
    },
    {
      "code" : "3701010963",
      "display" : "向虹牙醫診所"
    },
    {
      "code" : "3701010990",
      "display" : "景仲牙醫診所"
    },
    {
      "code" : "3701011013",
      "display" : "王誌牙醫診所"
    },
    {
      "code" : "3701011022",
      "display" : "立達牙醫診所"
    },
    {
      "code" : "3701011068",
      "display" : "仁惠牙醫診所"
    },
    {
      "code" : "3701011086",
      "display" : "慶華牙醫診所"
    },
    {
      "code" : "3701011139",
      "display" : "宏國牙醫診所"
    },
    {
      "code" : "3701011148",
      "display" : "史丹佛牙醫診所"
    },
    {
      "code" : "3701011157",
      "display" : "李國師牙醫診所"
    },
    {
      "code" : "3701011184",
      "display" : "延齡牙醫診所"
    },
    {
      "code" : "3701011200",
      "display" : "凱悅牙醫診所"
    },
    {
      "code" : "3701011228",
      "display" : "揚登牙醫診所"
    },
    {
      "code" : "3701011273",
      "display" : "上傑牙醫診所"
    },
    {
      "code" : "3701011308",
      "display" : "小林牙醫診所"
    },
    {
      "code" : "3701011317",
      "display" : "立人牙醫診所"
    },
    {
      "code" : "3701011371",
      "display" : "高登牙醫診所"
    },
    {
      "code" : "3701011399",
      "display" : "林翰牙醫診所"
    },
    {
      "code" : "3701011479",
      "display" : "峰牙醫診所"
    },
    {
      "code" : "3701011513",
      "display" : "嵩峯牙醫診所"
    },
    {
      "code" : "3701011522",
      "display" : "明君牙醫診所"
    },
    {
      "code" : "3701011666",
      "display" : "元品牙醫診所"
    },
    {
      "code" : "3701011693",
      "display" : "杏典牙醫診所"
    },
    {
      "code" : "3701011728",
      "display" : "暘昇牙醫診所"
    },
    {
      "code" : "3701011764",
      "display" : "啟瑞牙醫診所"
    },
    {
      "code" : "3701011773",
      "display" : "台新牙醫診所"
    },
    {
      "code" : "3701011791",
      "display" : "毛冠人牙醫診所"
    },
    {
      "code" : "3701011808",
      "display" : "宏昌牙醫診所"
    },
    {
      "code" : "3701011817",
      "display" : "饒河牙醫診所"
    },
    {
      "code" : "3701011835",
      "display" : "黃系倫牙醫診所"
    },
    {
      "code" : "3701011862",
      "display" : "敦品牙醫診所"
    },
    {
      "code" : "3701011899",
      "display" : "冠亞牙醫診所"
    },
    {
      "code" : "3701011915",
      "display" : "樂福牙醫診所"
    },
    {
      "code" : "3701011924",
      "display" : "德基牙醫診所"
    },
    {
      "code" : "3701011933",
      "display" : "虹福牙醫診所"
    },
    {
      "code" : "3701011951",
      "display" : "長島牙醫診所"
    },
    {
      "code" : "3701011979",
      "display" : "華美牙醫診所"
    },
    {
      "code" : "3701011988",
      "display" : "泛美牙醫診所"
    },
    {
      "code" : "3701011997",
      "display" : "群益牙醫診所"
    },
    {
      "code" : "3701012001",
      "display" : "新東牙醫診所"
    },
    {
      "code" : "3701012038",
      "display" : "碧礽牙醫診所"
    },
    {
      "code" : "3701012065",
      "display" : "臻品牙醫診所"
    },
    {
      "code" : "3701013106",
      "display" : "富錦牙醫診所"
    },
    {
      "code" : "3701013133",
      "display" : "遠景牙醫診所"
    },
    {
      "code" : "3701013142",
      "display" : "李美玲牙醫診所"
    },
    {
      "code" : "3701013151",
      "display" : "張萬屏牙醫診所"
    },
    {
      "code" : "3701013188",
      "display" : "大都會牙醫診所"
    },
    {
      "code" : "3701013213",
      "display" : "康健牙醫診所"
    },
    {
      "code" : "3701013240",
      "display" : "康霖牙醫診所"
    },
    {
      "code" : "3701013268",
      "display" : "東方牙醫診所"
    },
    {
      "code" : "3701013320",
      "display" : "多倫多牙醫診所"
    },
    {
      "code" : "3701013348",
      "display" : "誠美牙醫診所"
    },
    {
      "code" : "3701013419",
      "display" : "南加州牙醫診所"
    },
    {
      "code" : "3701013428",
      "display" : "紀泓輝牙醫診所"
    },
    {
      "code" : "3701013473",
      "display" : "泰康牙醫診所"
    },
    {
      "code" : "3701013491",
      "display" : "華中牙醫診所"
    },
    {
      "code" : "3701013508",
      "display" : "馨牙醫診所"
    },
    {
      "code" : "3701013517",
      "display" : "傑美牙醫診所"
    },
    {
      "code" : "3701013526",
      "display" : "采鴻牙醫診所"
    },
    {
      "code" : "3701013544",
      "display" : "微風牙醫診所"
    },
    {
      "code" : "3701013553",
      "display" : "祥和牙醫診所"
    },
    {
      "code" : "3701013562",
      "display" : "原點牙醫診所"
    },
    {
      "code" : "3701013580",
      "display" : "久恆牙醫診所"
    },
    {
      "code" : "3701013599",
      "display" : "康和牙醫診所"
    },
    {
      "code" : "3701013606",
      "display" : "博美牙醫診所"
    },
    {
      "code" : "3701013624",
      "display" : "松展牙醫診所"
    },
    {
      "code" : "3701013660",
      "display" : "胡廣煜牙醫診所"
    },
    {
      "code" : "3701013679",
      "display" : "品睿牙醫診所"
    },
    {
      "code" : "3701013713",
      "display" : "大友牙醫診所"
    },
    {
      "code" : "3701013731",
      "display" : "崇皓牙醫診所"
    },
    {
      "code" : "3701013740",
      "display" : "采德牙醫診所"
    },
    {
      "code" : "3701013759",
      "display" : "森之谷美學牙醫診所"
    },
    {
      "code" : "3701013777",
      "display" : "得意牙醫診所"
    },
    {
      "code" : "3701013802",
      "display" : "佳禾牙醫診所"
    },
    {
      "code" : "3701013811",
      "display" : "恩信牙醫診所"
    },
    {
      "code" : "3701013820",
      "display" : "雅客牙醫診所"
    },
    {
      "code" : "3701013848",
      "display" : "泰華牙醫診所"
    },
    {
      "code" : "3701013875",
      "display" : "澄品牙醫診所"
    },
    {
      "code" : "3701013900",
      "display" : "誠楷牙醫診所"
    },
    {
      "code" : "3701013955",
      "display" : "美學牙醫診所"
    },
    {
      "code" : "3701013964",
      "display" : "康河牙醫診所"
    },
    {
      "code" : "3701013973",
      "display" : "佳誠美學牙醫診所"
    },
    {
      "code" : "3701013982",
      "display" : "魔法兔牙醫診所"
    },
    {
      "code" : "3701014005",
      "display" : "新尊榮牙醫診所"
    },
    {
      "code" : "3701014032",
      "display" : "博飛迅牙醫診所"
    },
    {
      "code" : "3701014050",
      "display" : "喜樂芽牙醫診所"
    },
    {
      "code" : "3701014078",
      "display" : "誼欣牙醫診所"
    },
    {
      "code" : "3701014087",
      "display" : "兆恩牙醫診所"
    },
    {
      "code" : "3701014096",
      "display" : "柏林牙醫診所"
    },
    {
      "code" : "3701014103",
      "display" : "直德牙醫診所"
    },
    {
      "code" : "3701014112",
      "display" : "八德牙醫診所"
    },
    {
      "code" : "3701014121",
      "display" : "維一牙醫診所"
    },
    {
      "code" : "3701014130",
      "display" : "本質牙醫診所"
    },
    {
      "code" : "3701014149",
      "display" : "勤美民生牙醫診所"
    },
    {
      "code" : "3701014158",
      "display" : "靜巷美學牙醫診所"
    },
    {
      "code" : "3701014167",
      "display" : "康士美牙醫診所"
    },
    {
      "code" : "3701014185",
      "display" : "誠楷牙醫診所"
    },
    {
      "code" : "3701014194",
      "display" : "勤美民生牙醫診所"
    },
    {
      "code" : "3701014201",
      "display" : "繼康美學牙醫診所"
    },
    {
      "code" : "3701014210",
      "display" : "怡德牙醫診所"
    },
    {
      "code" : "3701014229",
      "display" : "光與綠牙醫診所"
    },
    {
      "code" : "3701014238",
      "display" : "嘉一牙醫診所"
    },
    {
      "code" : "3701014247",
      "display" : "大衛牙醫診所"
    },
    {
      "code" : "3701014256",
      "display" : "佳斯緹牙醫診所"
    },
    {
      "code" : "3701014265",
      "display" : "博飛迅牙醫診所"
    },
    {
      "code" : "3701014274",
      "display" : "維一牙醫診所"
    },
    {
      "code" : "3701014283",
      "display" : "大友牙醫診所"
    },
    {
      "code" : "3701014292",
      "display" : "勤美民生牙醫診所"
    },
    {
      "code" : "3701014309",
      "display" : "鉑金牙醫診所"
    },
    {
      "code" : "3701014318",
      "display" : "金欣牙醫診所"
    },
    {
      "code" : "3701014327",
      "display" : "松新牙醫診所"
    },
    {
      "code" : "3701014336",
      "display" : "慶城牙醫診所"
    },
    {
      "code" : "3701014345",
      "display" : "杏頤牙醫診所"
    },
    {
      "code" : "3701014363",
      "display" : "允品牙醫診所"
    },
    {
      "code" : "3701014372",
      "display" : "新和牙醫診所"
    },
    {
      "code" : "3701014381",
      "display" : "安悅美學牙醫診所"
    },
    {
      "code" : "3701014390",
      "display" : "遇見美好牙醫診所"
    },
    {
      "code" : "3701014407",
      "display" : "秝康牙醫診所"
    },
    {
      "code" : "3701014416",
      "display" : "繼康美學牙醫診所"
    },
    {
      "code" : "3701014425",
      "display" : "山石牙醫診所"
    },
    {
      "code" : "3701020049",
      "display" : "吳致毅牙醫診所"
    },
    {
      "code" : "3701020058",
      "display" : "金華牙醫診所"
    },
    {
      "code" : "3701020067",
      "display" : "蔡牙醫診所"
    },
    {
      "code" : "3701020094",
      "display" : "天仁牙醫診所"
    },
    {
      "code" : "3701020110",
      "display" : "泰仁牙醫診所"
    },
    {
      "code" : "3701020138",
      "display" : "天祥牙醫診所"
    },
    {
      "code" : "3701020156",
      "display" : "龍泉牙醫診所"
    },
    {
      "code" : "3701020209",
      "display" : "名祥牙醫診所"
    },
    {
      "code" : "3701020316",
      "display" : "保仁牙醫診所"
    },
    {
      "code" : "3701020343",
      "display" : "及人牙醫診所"
    },
    {
      "code" : "3701020405",
      "display" : "麗水牙醫診所"
    },
    {
      "code" : "3701020503",
      "display" : "金翎牙醫診所"
    },
    {
      "code" : "3701020576",
      "display" : "倫泰牙醫診所"
    },
    {
      "code" : "3701020585",
      "display" : "翔麟牙醫診所"
    },
    {
      "code" : "3701020610",
      "display" : "聖心牙醫診所"
    },
    {
      "code" : "3701020638",
      "display" : "建豐牙醫診所"
    },
    {
      "code" : "3701020674",
      "display" : "泰福牙醫診所"
    },
    {
      "code" : "3701020683",
      "display" : "宗翰牙醫診所"
    },
    {
      "code" : "3701020709",
      "display" : "上鵬牙醫診所"
    },
    {
      "code" : "3701020727",
      "display" : "新象牙醫診所"
    },
    {
      "code" : "3701020736",
      "display" : "榮愛牙醫診所"
    },
    {
      "code" : "3701020790",
      "display" : "愛育牙醫診所"
    },
    {
      "code" : "3701020843",
      "display" : "元華牙醫診所"
    },
    {
      "code" : "3701020987",
      "display" : "白宮牙醫診所"
    },
    {
      "code" : "3701020996",
      "display" : "廣大牙醫診所"
    },
    {
      "code" : "3701021000",
      "display" : "杏和牙醫診所"
    },
    {
      "code" : "3701021046",
      "display" : "正品牙醫診所"
    },
    {
      "code" : "3701021055",
      "display" : "華仁牙醫診所"
    },
    {
      "code" : "3701021108",
      "display" : "欣欣牙醫診所"
    },
    {
      "code" : "3701021162",
      "display" : "立大牙醫診所"
    },
    {
      "code" : "3701021199",
      "display" : "三普牙醫診所"
    },
    {
      "code" : "3701021206",
      "display" : "偉明牙醫診所"
    },
    {
      "code" : "3701021215",
      "display" : "大勝牙醫診所"
    },
    {
      "code" : "3701021251",
      "display" : "復光牙醫診所"
    },
    {
      "code" : "3701021279",
      "display" : "名人牙科診所"
    },
    {
      "code" : "3701021340",
      "display" : "名流牙醫診所"
    },
    {
      "code" : "3701021359",
      "display" : "偉成牙醫診所"
    },
    {
      "code" : "3701021411",
      "display" : "宗聖牙醫診所"
    },
    {
      "code" : "3701021484",
      "display" : "國安牙醫診所"
    },
    {
      "code" : "3701021500",
      "display" : "欣民牙醫診所"
    },
    {
      "code" : "3701021519",
      "display" : "僑展牙醫診所"
    },
    {
      "code" : "3701021582",
      "display" : "守禮牙醫診所"
    },
    {
      "code" : "3701021617",
      "display" : "懷仁牙醫診所"
    },
    {
      "code" : "3701021706",
      "display" : "永大牙醫診所"
    },
    {
      "code" : "3701021715",
      "display" : "健元牙醫診所"
    },
    {
      "code" : "3701021822",
      "display" : "首都牙醫診所"
    },
    {
      "code" : "3701021840",
      "display" : "洛城牙醫診所"
    },
    {
      "code" : "3701021868",
      "display" : "十全牙醫診所"
    },
    {
      "code" : "3701021911",
      "display" : "磊磊牙醫診所"
    },
    {
      "code" : "3701022052",
      "display" : "定國牙醫診所"
    },
    {
      "code" : "3701022105",
      "display" : "天津牙醫診所"
    },
    {
      "code" : "3701022178",
      "display" : "雅品牙醫診所"
    },
    {
      "code" : "3701022203",
      "display" : "洪介文牙醫診所"
    },
    {
      "code" : "3701022221",
      "display" : "許必靈牙醫診所"
    },
    {
      "code" : "3701022249",
      "display" : "全家福牙醫診所"
    },
    {
      "code" : "3701022276",
      "display" : "童安牙醫診所"
    },
    {
      "code" : "3701022294",
      "display" : "明泰牙醫診所"
    },
    {
      "code" : "3701022310",
      "display" : "保順牙醫診所"
    },
    {
      "code" : "3701022329",
      "display" : "當代牙醫診所"
    },
    {
      "code" : "3701022338",
      "display" : "長青牙醫診所"
    },
    {
      "code" : "3701022365",
      "display" : "名格牙醫診所"
    },
    {
      "code" : "3701022374",
      "display" : "美佳牙醫診所"
    },
    {
      "code" : "3701022383",
      "display" : "懷生牙醫診所"
    },
    {
      "code" : "3701022392",
      "display" : "慈恩牙醫診所"
    },
    {
      "code" : "3701022409",
      "display" : "以諾牙醫診所"
    },
    {
      "code" : "3701022427",
      "display" : "致強牙醫診所"
    },
    {
      "code" : "3701022481",
      "display" : "卓越牙醫診所"
    },
    {
      "code" : "3701022507",
      "display" : "黃明仁牙醫診所"
    },
    {
      "code" : "3701022543",
      "display" : "王叔岩牙醫診所"
    },
    {
      "code" : "3701022552",
      "display" : "偉恩牙醫診所"
    },
    {
      "code" : "3701022589",
      "display" : "華成牙醫診所"
    },
    {
      "code" : "3701022614",
      "display" : "康泰牙醫診所"
    },
    {
      "code" : "3701022641",
      "display" : "仁本牙醫診所"
    },
    {
      "code" : "3701022678",
      "display" : "見安牙醫診所"
    },
    {
      "code" : "3701022749",
      "display" : "立祥牙醫診所"
    },
    {
      "code" : "3701022767",
      "display" : "力仁牙醫診所"
    },
    {
      "code" : "3701022785",
      "display" : "尚群牙醫診所"
    },
    {
      "code" : "3701022810",
      "display" : "永恩牙醫診所"
    },
    {
      "code" : "3701022883",
      "display" : "三上牙醫診所"
    },
    {
      "code" : "3701022936",
      "display" : "名範牙醫診所"
    },
    {
      "code" : "3701022945",
      "display" : "安德牙醫診所"
    },
    {
      "code" : "3701022963",
      "display" : "美齡牙醫診所"
    },
    {
      "code" : "3701023004",
      "display" : "鴻林牙醫診所"
    },
    {
      "code" : "3701023013",
      "display" : "謝牙醫診所"
    },
    {
      "code" : "3701023031",
      "display" : "經典牙醫診所"
    },
    {
      "code" : "3701023111",
      "display" : "弘全牙醫診所"
    },
    {
      "code" : "3701023120",
      "display" : "麗晶牙醫診所"
    },
    {
      "code" : "3701023166",
      "display" : "祥齡牙醫診所"
    },
    {
      "code" : "3701023193",
      "display" : "懷恩牙醫診所"
    },
    {
      "code" : "3701023353",
      "display" : "明道牙醫診所"
    },
    {
      "code" : "3701023415",
      "display" : "逸群牙醫診所"
    },
    {
      "code" : "3701023433",
      "display" : "大地牙醫診所"
    },
    {
      "code" : "3701023460",
      "display" : "德美牙醫診所"
    },
    {
      "code" : "3701023568",
      "display" : "惠天牙醫診所"
    },
    {
      "code" : "3701023577",
      "display" : "復興牙醫診所"
    },
    {
      "code" : "3701023648",
      "display" : "佳恩牙醫診所"
    },
    {
      "code" : "3701023657",
      "display" : "幸園全方位牙醫診所"
    },
    {
      "code" : "3701023693",
      "display" : "陽昇牙醫診所"
    },
    {
      "code" : "3701023700",
      "display" : "常榮牙醫診所"
    },
    {
      "code" : "3701023746",
      "display" : "博恩牙醫診所"
    },
    {
      "code" : "3701023755",
      "display" : "敦煌牙醫診所"
    },
    {
      "code" : "3701023782",
      "display" : "鑫辰牙醫診所"
    },
    {
      "code" : "3701023808",
      "display" : "康萊牙醫診所"
    },
    {
      "code" : "3701023844",
      "display" : "童兆鯤牙醫診所"
    },
    {
      "code" : "3701023915",
      "display" : "得康牙醫診所"
    },
    {
      "code" : "3701023924",
      "display" : "弘名牙醫診所"
    },
    {
      "code" : "3701023933",
      "display" : "群容牙醫診所"
    },
    {
      "code" : "3701024001",
      "display" : "輝揚牙醫診所"
    },
    {
      "code" : "3701024047",
      "display" : "皓群牙醫診所"
    },
    {
      "code" : "3701024154",
      "display" : "慶祥牙醫診所"
    },
    {
      "code" : "3701024190",
      "display" : "明曜牙醫診所"
    },
    {
      "code" : "3701024216",
      "display" : "上德牙醫診所"
    },
    {
      "code" : "3701024243",
      "display" : "德尚牙醫診所"
    },
    {
      "code" : "3701024270",
      "display" : "亞德牙醫診所"
    },
    {
      "code" : "3701024314",
      "display" : "慧安牙醫診所"
    },
    {
      "code" : "3701024332",
      "display" : "周彥儒牙醫診所"
    },
    {
      "code" : "3701024396",
      "display" : "上上牙醫診所"
    },
    {
      "code" : "3701024412",
      "display" : "巧聖牙醫診所"
    },
    {
      "code" : "3701024421",
      "display" : "波士頓牙醫診所"
    },
    {
      "code" : "3701024476",
      "display" : "佳德牙醫診所"
    },
    {
      "code" : "3701024510",
      "display" : "翰佑牙醫診所"
    },
    {
      "code" : "3701024529",
      "display" : "誠良牙醫診所"
    },
    {
      "code" : "3701024565",
      "display" : "正誠牙醫診所"
    },
    {
      "code" : "3701025679",
      "display" : "潘國輝牙醫診所"
    },
    {
      "code" : "3701025688",
      "display" : "景泰牙醫診所"
    },
    {
      "code" : "3701025697",
      "display" : "柏登牙醫診所"
    },
    {
      "code" : "3701025722",
      "display" : "中日美聯合牙醫診所"
    },
    {
      "code" : "3701025768",
      "display" : "誠安牙醫診所"
    },
    {
      "code" : "3701025839",
      "display" : "全方位牙醫診所"
    },
    {
      "code" : "3701025848",
      "display" : "敦化芝加哥牙醫診所"
    },
    {
      "code" : "3701025866",
      "display" : "銘揚牙醫診所"
    },
    {
      "code" : "3701025946",
      "display" : "維鈞牙醫診所"
    },
    {
      "code" : "3701025982",
      "display" : "群和牙醫診所"
    },
    {
      "code" : "3701025991",
      "display" : "逸品牙醫診所"
    },
    {
      "code" : "3701026014",
      "display" : "康軒牙醫診所"
    },
    {
      "code" : "3701026096",
      "display" : "橘子牙醫診所"
    },
    {
      "code" : "3701026103",
      "display" : "嘉正牙醫診所"
    },
    {
      "code" : "3701026112",
      "display" : "程國慶牙醫診所"
    },
    {
      "code" : "3701026130",
      "display" : "小太陽牙醫診所"
    },
    {
      "code" : "3701026167",
      "display" : "敦南牙醫聯合診所"
    },
    {
      "code" : "3701026194",
      "display" : "得人牙醫診所"
    },
    {
      "code" : "3701026247",
      "display" : "瑞品牙醫診所"
    },
    {
      "code" : "3701026283",
      "display" : "伊美學牙醫診所"
    },
    {
      "code" : "3701026292",
      "display" : "小王子牙醫診所"
    },
    {
      "code" : "3701026309",
      "display" : "漢光牙醫診所"
    },
    {
      "code" : "3701026318",
      "display" : "群智牙醫診所"
    },
    {
      "code" : "3701026327",
      "display" : "來德牙醫診所"
    },
    {
      "code" : "3701026336",
      "display" : "惠群牙醫診所"
    },
    {
      "code" : "3701026354",
      "display" : "月馨牙醫診所"
    },
    {
      "code" : "3701026381",
      "display" : "貝爾牙醫診所"
    },
    {
      "code" : "3701026416",
      "display" : "理想家牙醫診所"
    },
    {
      "code" : "3701026443",
      "display" : "碩美牙醫診所"
    },
    {
      "code" : "3701026452",
      "display" : "旭光美學牙醫診所"
    },
    {
      "code" : "3701026461",
      "display" : "林孟文牙醫診所"
    },
    {
      "code" : "3701026489",
      "display" : "日禾牙醫診所"
    },
    {
      "code" : "3701026523",
      "display" : "祥仁牙醫診所"
    },
    {
      "code" : "3701026550",
      "display" : "本華牙醫診所"
    },
    {
      "code" : "3701026578",
      "display" : "超仁牙醫診所"
    },
    {
      "code" : "3701026587",
      "display" : "青田牙醫診所"
    },
    {
      "code" : "3701026603",
      "display" : "翔恩牙醫診所"
    },
    {
      "code" : "3701026612",
      "display" : "八號牙醫診所"
    },
    {
      "code" : "3701026649",
      "display" : "孩子王牙醫診所"
    },
    {
      "code" : "3701026676",
      "display" : "奕品牙醫診所"
    },
    {
      "code" : "3701026701",
      "display" : "至善牙醫診所"
    },
    {
      "code" : "3701026729",
      "display" : "群星牙醫診所"
    },
    {
      "code" : "3701026738",
      "display" : "胡桃鉗牙醫診所"
    },
    {
      "code" : "3701026756",
      "display" : "美登牙醫診所"
    },
    {
      "code" : "3701026783",
      "display" : "永峰台北牙醫診所"
    },
    {
      "code" : "3701026809",
      "display" : "敦維牙醫診所"
    },
    {
      "code" : "3701026812",
      "display" : "敦里牙醫診所"
    },
    {
      "code" : "3701026845",
      "display" : "嘉士美牙醫診所"
    },
    {
      "code" : "3701026863",
      "display" : "魏牙醫診所"
    },
    {
      "code" : "3701026872",
      "display" : "極緻美學牙醫診所"
    },
    {
      "code" : "3701026881",
      "display" : "世旻牙醫診所"
    },
    {
      "code" : "3701026916",
      "display" : "大安牙醫診所"
    },
    {
      "code" : "3701026943",
      "display" : "復安牙醫診所"
    },
    {
      "code" : "3701026961",
      "display" : "品範牙醫診所"
    },
    {
      "code" : "3701027011",
      "display" : "亞典牙醫診所"
    },
    {
      "code" : "3701027100",
      "display" : "品安牙醫診所"
    },
    {
      "code" : "3701027119",
      "display" : "朝代牙醫診所"
    },
    {
      "code" : "3701027128",
      "display" : "白石牙醫診所"
    },
    {
      "code" : "3701027137",
      "display" : "菁英牙醫診所"
    },
    {
      "code" : "3701027182",
      "display" : "華盛頓牙醫診所"
    },
    {
      "code" : "3701027191",
      "display" : "磐石牙醫診所"
    },
    {
      "code" : "3701027208",
      "display" : "詹成晚牙醫診所"
    },
    {
      "code" : "3701027235",
      "display" : "瑞誠牙醫診所"
    },
    {
      "code" : "3701027244",
      "display" : "西雅圖牙醫診所"
    },
    {
      "code" : "3701027262",
      "display" : "舊金山牙醫診所"
    },
    {
      "code" : "3701027271",
      "display" : "志清牙醫診所"
    },
    {
      "code" : "3701027299",
      "display" : "安麗牙醫診所"
    },
    {
      "code" : "3701027306",
      "display" : "怡登采風牙醫診所"
    },
    {
      "code" : "3701027315",
      "display" : "史邁爾牙醫診所"
    },
    {
      "code" : "3701027342",
      "display" : "信義牙醫診所"
    },
    {
      "code" : "3701027360",
      "display" : "安信牙醫診所"
    },
    {
      "code" : "3701027388",
      "display" : "加得牙醫診所"
    },
    {
      "code" : "3701027397",
      "display" : "來家牙醫診所"
    },
    {
      "code" : "3701027413",
      "display" : "維藝美學牙醫診所"
    },
    {
      "code" : "3701027459",
      "display" : "誠樂牙醫診所"
    },
    {
      "code" : "3701027502",
      "display" : "皓美牙醫診所"
    },
    {
      "code" : "3701027520",
      "display" : "采悅牙醫診所"
    },
    {
      "code" : "3701027548",
      "display" : "誠鼎牙醫診所"
    },
    {
      "code" : "3701027575",
      "display" : "華研牙醫診所"
    },
    {
      "code" : "3701027584",
      "display" : "昱典牙醫診所"
    },
    {
      "code" : "3701027593",
      "display" : "新苑牙醫診所"
    },
    {
      "code" : "3701027600",
      "display" : "天下牙醫診所"
    },
    {
      "code" : "3701027628",
      "display" : "巧玉牙醫診所"
    },
    {
      "code" : "3701027637",
      "display" : "郭儒銓牙醫診所"
    },
    {
      "code" : "3701027646",
      "display" : "植善牙醫診所"
    },
    {
      "code" : "3701027655",
      "display" : "城東牙醫診所"
    },
    {
      "code" : "3701027664",
      "display" : "安若牙醫診所"
    },
    {
      "code" : "3701027708",
      "display" : "品程牙醫診所"
    },
    {
      "code" : "3701027726",
      "display" : "佛牙昌牙醫診所"
    },
    {
      "code" : "3701027753",
      "display" : "金品牙醫診所"
    },
    {
      "code" : "3701027780",
      "display" : "中央公園精品牙醫診所"
    },
    {
      "code" : "3701027799",
      "display" : "璞心牙醫診所"
    },
    {
      "code" : "3701027824",
      "display" : "貝麗牙醫診所"
    },
    {
      "code" : "3701027842",
      "display" : "捷安牙醫診所"
    },
    {
      "code" : "3701027851",
      "display" : "新紐約牙醫診所"
    },
    {
      "code" : "3701027860",
      "display" : "新禾牙醫診所"
    },
    {
      "code" : "3701027888",
      "display" : "茉莉牙醫診所"
    },
    {
      "code" : "3701027913",
      "display" : "雋品牙醫診所"
    },
    {
      "code" : "3701027922",
      "display" : "錠珹牙醫診所"
    },
    {
      "code" : "3701027940",
      "display" : "仁愛傑生牙醫診所"
    },
    {
      "code" : "3701027959",
      "display" : "宣品牙醫診所"
    },
    {
      "code" : "3701027977",
      "display" : "踏石牙醫診所"
    },
    {
      "code" : "3701027986",
      "display" : "健誌牙醫診所"
    },
    {
      "code" : "3701027995",
      "display" : "琳安牙醫診所"
    },
    {
      "code" : "3701028009",
      "display" : "安曼牙醫診所"
    },
    {
      "code" : "3701028018",
      "display" : "世貿牙醫診所"
    },
    {
      "code" : "3701028027",
      "display" : "明日美牙醫診所"
    },
    {
      "code" : "3701028036",
      "display" : "泰樺美學牙醫診所"
    },
    {
      "code" : "3701028045",
      "display" : "舒麗爾牙醫診所"
    },
    {
      "code" : "3701028054",
      "display" : "安若牙醫診所"
    },
    {
      "code" : "3701028063",
      "display" : "松林牙醫診所"
    },
    {
      "code" : "3701028072",
      "display" : "怡登牙醫診所"
    },
    {
      "code" : "3701028090",
      "display" : "仁愛心悅牙醫診所"
    },
    {
      "code" : "3701028107",
      "display" : "耀美牙醫診所"
    },
    {
      "code" : "3701028116",
      "display" : "佳安牙醫診所"
    },
    {
      "code" : "3701028134",
      "display" : "大馨牙醫診所"
    },
    {
      "code" : "3701028161",
      "display" : "榮杰美學牙醫診所"
    },
    {
      "code" : "3701028170",
      "display" : "富國牙醫診所"
    },
    {
      "code" : "3701028198",
      "display" : "里昂哈佛仁愛牙醫診所"
    },
    {
      "code" : "3701028250",
      "display" : "安居牙醫診所"
    },
    {
      "code" : "3701028287",
      "display" : "瑞安牙醫診所"
    },
    {
      "code" : "3701028296",
      "display" : "品口牙醫診所"
    },
    {
      "code" : "3701028303",
      "display" : "晨光牙醫診所"
    },
    {
      "code" : "3701028312",
      "display" : "馨適牙醫診所"
    },
    {
      "code" : "3701028330",
      "display" : "大安傑生牙醫診所"
    },
    {
      "code" : "3701028349",
      "display" : "怡登唯美牙醫診所"
    },
    {
      "code" : "3701028367",
      "display" : "芽苑牙醫診所"
    },
    {
      "code" : "3701028376",
      "display" : "得愉牙醫診所"
    },
    {
      "code" : "3701028385",
      "display" : "優特牙醫暨兒童牙醫診所"
    },
    {
      "code" : "3701028394",
      "display" : "怡登敦南牙醫診所"
    },
    {
      "code" : "3701028401",
      "display" : "美德美學牙醫診所"
    },
    {
      "code" : "3701028410",
      "display" : "吳岳龍牙醫診所"
    },
    {
      "code" : "3701028429",
      "display" : "日亞美牙醫診所"
    },
    {
      "code" : "3701028438",
      "display" : "嶺先牙醫診所"
    },
    {
      "code" : "3701028447",
      "display" : "晶喜美牙醫診所"
    },
    {
      "code" : "3701028456",
      "display" : "瑞佛牙醫診所"
    },
    {
      "code" : "3701028465",
      "display" : "師苑牙醫診所"
    },
    {
      "code" : "3701028474",
      "display" : "台北亞緻牙醫診所"
    },
    {
      "code" : "3701028483",
      "display" : "康妍牙醫診所"
    },
    {
      "code" : "3701028509",
      "display" : "生活家牙醫診所"
    },
    {
      "code" : "3701028518",
      "display" : "光悅牙醫診所"
    },
    {
      "code" : "3701028527",
      "display" : "大安丰采美學牙醫診所"
    },
    {
      "code" : "3701028545",
      "display" : "仁愛牙醫診所"
    },
    {
      "code" : "3701028563",
      "display" : "康禾牙醫診所"
    },
    {
      "code" : "3701028572",
      "display" : "創新牙醫診所"
    },
    {
      "code" : "3701028590",
      "display" : "真愛貝齒牙醫診所"
    },
    {
      "code" : "3701028607",
      "display" : "君漾美牙醫診所"
    },
    {
      "code" : "3701028616",
      "display" : "仁一牙醫診所"
    },
    {
      "code" : "3701028625",
      "display" : "璽恩牙醫診所"
    },
    {
      "code" : "3701028634",
      "display" : "臥和彩日牙醫診所"
    },
    {
      "code" : "3701028643",
      "display" : "小小怡登兒童牙醫診所"
    },
    {
      "code" : "3701028652",
      "display" : "敦南麗緻牙醫診所"
    },
    {
      "code" : "3701028661",
      "display" : "時晴牙醫診所"
    },
    {
      "code" : "3701028670",
      "display" : "祐民牙醫診所"
    },
    {
      "code" : "3701028689",
      "display" : "仁愛傑生二樓牙醫診所"
    },
    {
      "code" : "3701028698",
      "display" : "羅福牙醫診所"
    },
    {
      "code" : "3701028705",
      "display" : "好牙屋牙醫診所"
    },
    {
      "code" : "3701028723",
      "display" : "一家牙醫診所"
    },
    {
      "code" : "3701028732",
      "display" : "渥爾牙醫診所"
    },
    {
      "code" : "3701028750",
      "display" : "光悅牙醫診所"
    },
    {
      "code" : "3701028769",
      "display" : "雅德思植牙美學牙醫診所"
    },
    {
      "code" : "3701028778",
      "display" : "大安傑生牙醫診所"
    },
    {
      "code" : "3701028796",
      "display" : "從心牙醫診所"
    },
    {
      "code" : "3701028803",
      "display" : "健格牙醫診所"
    },
    {
      "code" : "3701028812",
      "display" : "華盛頓牙醫診所"
    },
    {
      "code" : "3701028821",
      "display" : "哲恩美學牙醫診所"
    },
    {
      "code" : "3701028830",
      "display" : "維藝美學牙醫診所"
    },
    {
      "code" : "3701028849",
      "display" : "全方位牙醫診所"
    },
    {
      "code" : "3701028858",
      "display" : "樂晨牙醫診所"
    },
    {
      "code" : "3701028867",
      "display" : "創新牙醫診所"
    },
    {
      "code" : "3701028876",
      "display" : "微光牙醫診所"
    },
    {
      "code" : "3701028885",
      "display" : "群富牙醫診所"
    },
    {
      "code" : "3701028894",
      "display" : "渥爾牙醫診所"
    },
    {
      "code" : "3701028901",
      "display" : "和穆牙醫診所"
    },
    {
      "code" : "3701028910",
      "display" : "信愛牙醫診所"
    },
    {
      "code" : "3701028929",
      "display" : "宗翰牙醫診所"
    },
    {
      "code" : "3701028938",
      "display" : "大安雲天牙醫診所"
    },
    {
      "code" : "3701028947",
      "display" : "琢白美學牙醫診所"
    },
    {
      "code" : "3701028956",
      "display" : "名山牙醫診所"
    },
    {
      "code" : "3701028965",
      "display" : "良鑫牙醫診所"
    },
    {
      "code" : "3701028974",
      "display" : "語悅牙醫診所"
    },
    {
      "code" : "3701028983",
      "display" : "翔恩牙醫診所"
    },
    {
      "code" : "3701029006",
      "display" : "杏和牙醫診所"
    },
    {
      "code" : "3701029015",
      "display" : "忠孝三井牙醫診所"
    },
    {
      "code" : "3701029024",
      "display" : "琢悅牙醫診所"
    },
    {
      "code" : "3701029033",
      "display" : "雅德思植牙美學牙醫診所"
    },
    {
      "code" : "3701029042",
      "display" : "維心牙醫診所"
    },
    {
      "code" : "3701029051",
      "display" : "宗翰牙醫診所"
    },
    {
      "code" : "3701029060",
      "display" : "恩美牙醫診所"
    },
    {
      "code" : "3701029079",
      "display" : "沂星牙醫診所"
    },
    {
      "code" : "3701029088",
      "display" : "敦南上境牙醫診所"
    },
    {
      "code" : "3701029104",
      "display" : "捷晞美學牙醫診所"
    },
    {
      "code" : "3701029113",
      "display" : "三禮美學牙醫診所"
    },
    {
      "code" : "3701029122",
      "display" : "悦淳牙醫診所"
    },
    {
      "code" : "3701029131",
      "display" : "語悅牙醫診所"
    },
    {
      "code" : "3701029140",
      "display" : "植善牙醫診所"
    },
    {
      "code" : "3701029159",
      "display" : "科技渥爾牙醫診所"
    },
    {
      "code" : "3701029168",
      "display" : "上德牙醫診所"
    },
    {
      "code" : "3701029177",
      "display" : "沐品牙醫診所"
    },
    {
      "code" : "3701029186",
      "display" : "時晴雅緻牙醫診所"
    },
    {
      "code" : "3701029195",
      "display" : "琢耀美學牙醫診所"
    },
    {
      "code" : "3701029202",
      "display" : "渥爾牙醫診所"
    },
    {
      "code" : "3701029211",
      "display" : "誠靜牙醫診所"
    },
    {
      "code" : "3701029220",
      "display" : "康妍牙醫診所"
    },
    {
      "code" : "3701029239",
      "display" : "海德堡牙醫診所"
    },
    {
      "code" : "3701029248",
      "display" : "榮杰美學牙醫診所"
    },
    {
      "code" : "3701029257",
      "display" : "儒願牙醫診所"
    },
    {
      "code" : "3701029266",
      "display" : "海棠牙醫診所"
    },
    {
      "code" : "3701029275",
      "display" : "明日美牙醫診所"
    },
    {
      "code" : "3701029284",
      "display" : "雅德思植牙美學牙醫診所"
    },
    {
      "code" : "3701029293",
      "display" : "泰仁牙醫診所"
    },
    {
      "code" : "3701029300",
      "display" : "怡登大安牙醫診所"
    },
    {
      "code" : "3701029319",
      "display" : "菩森牙醫診所"
    },
    {
      "code" : "3701090014",
      "display" : "英士牙醫診所"
    },
    {
      "code" : "3701090032",
      "display" : "文山堂牙醫診所"
    },
    {
      "code" : "3701090041",
      "display" : "吳震鵬牙醫診所"
    },
    {
      "code" : "3701090087",
      "display" : "杜瑞煙牙醫診所"
    },
    {
      "code" : "3701090130",
      "display" : "宏偉牙醫診所"
    },
    {
      "code" : "3701090167",
      "display" : "瑞和牙醫診所"
    },
    {
      "code" : "3701090210",
      "display" : "西寧安泰牙醫診所"
    },
    {
      "code" : "3701090265",
      "display" : "杏仁牙醫診所"
    },
    {
      "code" : "3701090283",
      "display" : "建成牙醫診所"
    },
    {
      "code" : "3701090416",
      "display" : "維明牙醫診所"
    },
    {
      "code" : "3701090452",
      "display" : "劍橋牙醫診所"
    },
    {
      "code" : "3701090470",
      "display" : "李牙醫診所"
    },
    {
      "code" : "3701090489",
      "display" : "美堅牙醫診所"
    },
    {
      "code" : "3701090505",
      "display" : "哲安牙醫診所"
    },
    {
      "code" : "3701090569",
      "display" : "新林牙醫診所"
    },
    {
      "code" : "3701090578",
      "display" : "順然牙醫診所"
    },
    {
      "code" : "3701090596",
      "display" : "宏嘉牙醫診所"
    },
    {
      "code" : "3701090612",
      "display" : "長興牙醫診所"
    },
    {
      "code" : "3701090621",
      "display" : "久豐牙醫診所"
    },
    {
      "code" : "3701090630",
      "display" : "章牙醫診所"
    },
    {
      "code" : "3701090676",
      "display" : "仁偉牙醫診所"
    },
    {
      "code" : "3701090685",
      "display" : "永達牙醫診所"
    },
    {
      "code" : "3701090701",
      "display" : "曾鳳飛牙醫診所"
    },
    {
      "code" : "3701090729",
      "display" : "良朋牙醫診所"
    },
    {
      "code" : "3701090774",
      "display" : "旭揚牙醫診所"
    },
    {
      "code" : "3701090818",
      "display" : "朝陽牙醫診所"
    },
    {
      "code" : "3701090836",
      "display" : "全品牙醫診所"
    },
    {
      "code" : "3701090863",
      "display" : "三德牙醫診所"
    },
    {
      "code" : "3701090890",
      "display" : "英瑞牙醫診所"
    },
    {
      "code" : "3701090907",
      "display" : "欣華牙醫診所"
    },
    {
      "code" : "3701090916",
      "display" : "欣容牙醫診所"
    },
    {
      "code" : "3701090934",
      "display" : "大仁牙醫診所"
    },
    {
      "code" : "3701090970",
      "display" : "台一牙醫診所"
    },
    {
      "code" : "3701090998",
      "display" : "傑品牙醫診所"
    },
    {
      "code" : "3701091048",
      "display" : "博群牙醫診所"
    },
    {
      "code" : "3701091084",
      "display" : "永新聯合牙醫診所"
    },
    {
      "code" : "3701092107",
      "display" : "天喜牙醫診所"
    },
    {
      "code" : "3701092125",
      "display" : "立全牙醫診所"
    },
    {
      "code" : "3701092170",
      "display" : "欣恩牙醫診所"
    },
    {
      "code" : "3701092198",
      "display" : "雅晴牙醫診所"
    },
    {
      "code" : "3701092214",
      "display" : "大龍牙醫診所"
    },
    {
      "code" : "3701092303",
      "display" : "松柏牙醫診所"
    },
    {
      "code" : "3701092312",
      "display" : "晶悅美學牙醫診所"
    },
    {
      "code" : "3701092321",
      "display" : "京站全人牙醫診所"
    },
    {
      "code" : "3701092330",
      "display" : "忻安牙醫診所"
    },
    {
      "code" : "3701092349",
      "display" : "路易牙醫診所"
    },
    {
      "code" : "3701092358",
      "display" : "大翔牙醫診所"
    },
    {
      "code" : "3701092376",
      "display" : "名柏牙醫診所"
    },
    {
      "code" : "3701092394",
      "display" : "森田牙醫診所"
    },
    {
      "code" : "3701092410",
      "display" : "中山一日誠臻牙醫診所"
    },
    {
      "code" : "3701092438",
      "display" : "圓山長麗牙醫診所"
    },
    {
      "code" : "3701092465",
      "display" : "尊榮美學牙醫診所"
    },
    {
      "code" : "3701092474",
      "display" : "御森美學牙醫診所"
    },
    {
      "code" : "3701092483",
      "display" : "博裕牙醫診所"
    },
    {
      "code" : "3701092492",
      "display" : "御翔美學牙醫診所"
    },
    {
      "code" : "3701092509",
      "display" : "立威口腔顎面外科牙醫診所"
    },
    {
      "code" : "3701092518",
      "display" : "新緻美學牙醫診所"
    },
    {
      "code" : "3701092527",
      "display" : "泉玥牙醫診所"
    },
    {
      "code" : "3701092536",
      "display" : "永東牙醫診所"
    },
    {
      "code" : "3701092554",
      "display" : "李牙醫診所"
    },
    {
      "code" : "3701092563",
      "display" : "唯媜牙醫診所"
    },
    {
      "code" : "3701092572",
      "display" : "京站全人牙醫診所"
    },
    {
      "code" : "3701092581",
      "display" : "橋思牙醫診所"
    },
    {
      "code" : "3701092590",
      "display" : "新緻美學牙醫診所"
    },
    {
      "code" : "3701092607",
      "display" : "采玥英皇牙醫診所"
    },
    {
      "code" : "3701092616",
      "display" : "橋思牙醫診所"
    },
    {
      "code" : "3701092625",
      "display" : "泉玥牙醫診所"
    },
    {
      "code" : "3701092634",
      "display" : "大同時光美牙醫診所"
    },
    {
      "code" : "3701100015",
      "display" : "承正牙醫診所"
    },
    {
      "code" : "3701100024",
      "display" : "蔡朝雄牙醫診所"
    },
    {
      "code" : "3701100060",
      "display" : "鑫牙醫診所"
    },
    {
      "code" : "3701100079",
      "display" : "華齡牙醫診所"
    },
    {
      "code" : "3701100088",
      "display" : "隆昌牙醫診所"
    },
    {
      "code" : "3701100104",
      "display" : "健康牙醫診所"
    },
    {
      "code" : "3701100122",
      "display" : "信心牙醫診所"
    },
    {
      "code" : "3701100140",
      "display" : "崧江牙醫診所"
    },
    {
      "code" : "3701100202",
      "display" : "黃大偉牙醫診所"
    },
    {
      "code" : "3701100211",
      "display" : "大明牙醫診所"
    },
    {
      "code" : "3701100220",
      "display" : "康寧牙醫診所"
    },
    {
      "code" : "3701100293",
      "display" : "康福牙醫診所"
    },
    {
      "code" : "3701100337",
      "display" : "陳均牙醫診所"
    },
    {
      "code" : "3701100364",
      "display" : "新現代牙醫診所"
    },
    {
      "code" : "3701100408",
      "display" : "吉安牙醫診所"
    },
    {
      "code" : "3701100417",
      "display" : "上格牙醫診所"
    },
    {
      "code" : "3701100426",
      "display" : "傅牙醫診所"
    },
    {
      "code" : "3701100435",
      "display" : "普大牙醫診所"
    },
    {
      "code" : "3701100471",
      "display" : "柏齡牙醫診所"
    },
    {
      "code" : "3701100480",
      "display" : "呈祥牙醫診所"
    },
    {
      "code" : "3701100499",
      "display" : "大富牙醫診所"
    },
    {
      "code" : "3701100542",
      "display" : "陽安牙醫診所"
    },
    {
      "code" : "3701100597",
      "display" : "大華牙醫診所"
    },
    {
      "code" : "3701100631",
      "display" : "榮星牙醫診所"
    },
    {
      "code" : "3701100668",
      "display" : "張永恭牙醫診所"
    },
    {
      "code" : "3701100739",
      "display" : "健生牙醫診所"
    },
    {
      "code" : "3701100766",
      "display" : "三和牙醫診所"
    },
    {
      "code" : "3701100784",
      "display" : "泰祺牙醫診所"
    },
    {
      "code" : "3701100819",
      "display" : "峰茂牙醫診所"
    },
    {
      "code" : "3701100855",
      "display" : "祐德牙醫診所"
    },
    {
      "code" : "3701100891",
      "display" : "大台北牙醫診所"
    },
    {
      "code" : "3701100917",
      "display" : "佳佳牙醫診所"
    },
    {
      "code" : "3701100926",
      "display" : "欣林牙醫診所"
    },
    {
      "code" : "3701100962",
      "display" : "嘉新牙醫診所"
    },
    {
      "code" : "3701100980",
      "display" : "大千牙醫診所"
    },
    {
      "code" : "3701101030",
      "display" : "中二牙醫診所"
    },
    {
      "code" : "3701101076",
      "display" : "上恩牙醫診所"
    },
    {
      "code" : "3701101094",
      "display" : "標準牙醫診所"
    },
    {
      "code" : "3701101156",
      "display" : "民安牙醫診所"
    },
    {
      "code" : "3701101183",
      "display" : "全美牙醫診所"
    },
    {
      "code" : "3701101218",
      "display" : "百年牙醫診所"
    },
    {
      "code" : "3701101254",
      "display" : "美儀牙醫診所"
    },
    {
      "code" : "3701101290",
      "display" : "永固牙醫診所"
    },
    {
      "code" : "3701101325",
      "display" : "惠潔牙醫診所"
    },
    {
      "code" : "3701101343",
      "display" : "曾賢德牙醫診所"
    },
    {
      "code" : "3701101405",
      "display" : "威世牙醫診所"
    },
    {
      "code" : "3701101423",
      "display" : "雙城牙醫診所"
    },
    {
      "code" : "3701101432",
      "display" : "日進牙醫診所"
    },
    {
      "code" : "3701101450",
      "display" : "久大牙醫診所"
    },
    {
      "code" : "3701101487",
      "display" : "德惠牙醫診所"
    },
    {
      "code" : "3701101521",
      "display" : "慶泰牙醫診所"
    },
    {
      "code" : "3701101861",
      "display" : "承新牙醫診所"
    },
    {
      "code" : "3701101996",
      "display" : "松安牙醫診所"
    },
    {
      "code" : "3701102091",
      "display" : "佳慶牙醫診所"
    },
    {
      "code" : "3701102108",
      "display" : "瑞祥牙醫診所"
    },
    {
      "code" : "3701102180",
      "display" : "東海牙醫診所"
    },
    {
      "code" : "3701102582",
      "display" : "天心牙醫診所"
    },
    {
      "code" : "3701102608",
      "display" : "田青牙醫診所"
    },
    {
      "code" : "3701102626",
      "display" : "豐正牙醫診所"
    },
    {
      "code" : "3701102644",
      "display" : "明新牙醫診所"
    },
    {
      "code" : "3701102699",
      "display" : "喜信牙醫診所"
    },
    {
      "code" : "3701102920",
      "display" : "吉林牙醫診所"
    },
    {
      "code" : "3701102957",
      "display" : "明水牙醫診所"
    },
    {
      "code" : "3701102975",
      "display" : "惠普牙醫診所"
    },
    {
      "code" : "3701103043",
      "display" : "龍江牙醫診所"
    },
    {
      "code" : "3701103052",
      "display" : "嚴牙醫診所"
    },
    {
      "code" : "3701103098",
      "display" : "重九牙醫診所"
    },
    {
      "code" : "3701103169",
      "display" : "品維牙醫診所"
    },
    {
      "code" : "3701103178",
      "display" : "偉格牙醫診所"
    },
    {
      "code" : "3701103187",
      "display" : "亞太牙醫診所"
    },
    {
      "code" : "3701103230",
      "display" : "靜心牙醫診所"
    },
    {
      "code" : "3701103294",
      "display" : "高標準牙醫診所"
    },
    {
      "code" : "3701103338",
      "display" : "弘丞牙醫診所"
    },
    {
      "code" : "3701103347",
      "display" : "常青牙醫診所"
    },
    {
      "code" : "3701103374",
      "display" : "張文乾牙醫診所"
    },
    {
      "code" : "3701103383",
      "display" : "翠真牙醫診所"
    },
    {
      "code" : "3701103409",
      "display" : "志安牙醫診所"
    },
    {
      "code" : "3701103418",
      "display" : "仁光牙醫診所"
    },
    {
      "code" : "3701103445",
      "display" : "智欽牙醫診所"
    },
    {
      "code" : "3701103463",
      "display" : "福聯牙醫診所"
    },
    {
      "code" : "3701103472",
      "display" : "迪士尼數位美學牙醫診所"
    },
    {
      "code" : "3701103481",
      "display" : "禾森牙醫診所"
    },
    {
      "code" : "3701103516",
      "display" : "２１世紀牙醫診所"
    },
    {
      "code" : "3701103525",
      "display" : "祺甯牙醫診所"
    },
    {
      "code" : "3701103552",
      "display" : "北安牙醫診所"
    },
    {
      "code" : "3701103561",
      "display" : "立馨牙醫診所"
    },
    {
      "code" : "3701103598",
      "display" : "北大牙醫診所"
    },
    {
      "code" : "3701103614",
      "display" : "陽順牙醫診所"
    },
    {
      "code" : "3701103632",
      "display" : "睿智牙醫診所"
    },
    {
      "code" : "3701103650",
      "display" : "復北惠普牙醫診所"
    },
    {
      "code" : "3701103669",
      "display" : "杏華牙醫診所"
    },
    {
      "code" : "3701103696",
      "display" : "上允牙醫診所"
    },
    {
      "code" : "3701103712",
      "display" : "常春藤牙醫診所"
    },
    {
      "code" : "3701103721",
      "display" : "嘉得牙醫診所"
    },
    {
      "code" : "3701103749",
      "display" : "簡富堅牙醫診所"
    },
    {
      "code" : "3701103758",
      "display" : "景福牙醫診所"
    },
    {
      "code" : "3701103810",
      "display" : "協合牙醫診所"
    },
    {
      "code" : "3701103874",
      "display" : "任惠民牙醫診所"
    },
    {
      "code" : "3701103883",
      "display" : "極品牙醫診所"
    },
    {
      "code" : "3701103892",
      "display" : "佳醫牙醫診所"
    },
    {
      "code" : "3701103909",
      "display" : "印象牙醫診所"
    },
    {
      "code" : "3701103918",
      "display" : "遠見牙醫診所"
    },
    {
      "code" : "3701103927",
      "display" : "玩美數位牙醫診所"
    },
    {
      "code" : "3701103954",
      "display" : "鴻生牙醫診所"
    },
    {
      "code" : "3701103981",
      "display" : "悅世牙醫診所"
    },
    {
      "code" : "3701104031",
      "display" : "恆美牙醫診所"
    },
    {
      "code" : "3701104040",
      "display" : "恩慈牙醫診所"
    },
    {
      "code" : "3701104120",
      "display" : "品誠牙醫診所"
    },
    {
      "code" : "3701104157",
      "display" : "安美牙醫診所"
    },
    {
      "code" : "3701104193",
      "display" : "春風牙醫診所"
    },
    {
      "code" : "3701104826",
      "display" : "京鼎牙醫診所"
    },
    {
      "code" : "3701104880",
      "display" : "景正牙醫診所"
    },
    {
      "code" : "3701104899",
      "display" : "如意牙醫診所"
    },
    {
      "code" : "3701104915",
      "display" : "英皇牙醫診所"
    },
    {
      "code" : "3701104924",
      "display" : "華城牙醫診所"
    },
    {
      "code" : "3701104933",
      "display" : "光與綠牙醫診所"
    },
    {
      "code" : "3701104942",
      "display" : "北歐牙醫診所"
    },
    {
      "code" : "3701104979",
      "display" : "天籟牙醫診所"
    },
    {
      "code" : "3701104988",
      "display" : "悠植牙醫診所"
    },
    {
      "code" : "3701105001",
      "display" : "品澄牙醫診所"
    },
    {
      "code" : "3701105038",
      "display" : "簡雅緻牙醫診所"
    },
    {
      "code" : "3701105047",
      "display" : "晶緻牙醫診所"
    },
    {
      "code" : "3701105074",
      "display" : "博康牙醫診所"
    },
    {
      "code" : "3701105127",
      "display" : "和美牙醫診所"
    },
    {
      "code" : "3701105145",
      "display" : "王品牙醫診所"
    },
    {
      "code" : "3701105163",
      "display" : "爵美牙醫診所"
    },
    {
      "code" : "3701105190",
      "display" : "晴美牙醫診所"
    },
    {
      "code" : "3701105216",
      "display" : "魔法牙醫診所"
    },
    {
      "code" : "3701105234",
      "display" : "風尚雅緻牙醫診所"
    },
    {
      "code" : "3701105243",
      "display" : "永潔牙醫診所"
    },
    {
      "code" : "3701105261",
      "display" : "幸恩牙醫診所"
    },
    {
      "code" : "3701105270",
      "display" : "欣安牙醫診所"
    },
    {
      "code" : "3701105298",
      "display" : "晶點牙醫診所"
    },
    {
      "code" : "3701105314",
      "display" : "長安牙醫診所"
    },
    {
      "code" : "3701105323",
      "display" : "陽光牙醫診所"
    },
    {
      "code" : "3701105350",
      "display" : "瀛海牙醫診所"
    },
    {
      "code" : "3701105378",
      "display" : "泰宏牙醫診所"
    },
    {
      "code" : "3701105387",
      "display" : "哲全牙醫診所"
    },
    {
      "code" : "3701105396",
      "display" : "辰品牙醫診所"
    },
    {
      "code" : "3701105403",
      "display" : "勤美悠植牙醫診所"
    },
    {
      "code" : "3701105421",
      "display" : "迪昇牙醫診所"
    },
    {
      "code" : "3701105430",
      "display" : "花栗鼠牙醫診所"
    },
    {
      "code" : "3701105449",
      "display" : "康卓牙醫診所"
    },
    {
      "code" : "3701105458",
      "display" : "順馨牙醫診所"
    },
    {
      "code" : "3701105467",
      "display" : "上博牙醫診所"
    },
    {
      "code" : "3701105476",
      "display" : "聖偉牙醫診所"
    },
    {
      "code" : "3701105485",
      "display" : "禮凡牙醫診所"
    },
    {
      "code" : "3701105494",
      "display" : "頤康美學牙醫診所"
    },
    {
      "code" : "3701105501",
      "display" : "星晴牙醫診所"
    },
    {
      "code" : "3701105529",
      "display" : "承錡馬楷牙醫診所"
    },
    {
      "code" : "3701105538",
      "display" : "維成牙醫診所"
    },
    {
      "code" : "3701105556",
      "display" : "東昇牙醫診所"
    },
    {
      "code" : "3701105592",
      "display" : "小星星牙醫診所"
    },
    {
      "code" : "3701105618",
      "display" : "義美牙醫診所"
    },
    {
      "code" : "3701105627",
      "display" : "爵世牙醫診所"
    },
    {
      "code" : "3701105636",
      "display" : "植仕美數位美學牙醫診所"
    },
    {
      "code" : "3701105645",
      "display" : "尊榮優植牙醫診所"
    },
    {
      "code" : "3701105654",
      "display" : "三代生物能牙醫診所"
    },
    {
      "code" : "3701105663",
      "display" : "九之牙醫診所"
    },
    {
      "code" : "3701105672",
      "display" : "慕光牙醫診所"
    },
    {
      "code" : "3701105681",
      "display" : "煥顏牙醫診所"
    },
    {
      "code" : "3701105690",
      "display" : "品傑牙醫診所"
    },
    {
      "code" : "3701105707",
      "display" : "優植牙醫診所"
    },
    {
      "code" : "3701105716",
      "display" : "星誠牙醫診所"
    },
    {
      "code" : "3701105725",
      "display" : "旭恩牙醫診所"
    },
    {
      "code" : "3701105734",
      "display" : "不二親子牙醫診所"
    },
    {
      "code" : "3701105743",
      "display" : "裕見美牙醫診所"
    },
    {
      "code" : "3701105752",
      "display" : "勢喬牙醫診所"
    },
    {
      "code" : "3701105770",
      "display" : "安貝牙醫診所"
    },
    {
      "code" : "3701105789",
      "display" : "英皇美學牙醫診所"
    },
    {
      "code" : "3701105798",
      "display" : "尚達牙醫診所"
    },
    {
      "code" : "3701105805",
      "display" : "陽安日和齒顎矯正專科牙醫診所"
    },
    {
      "code" : "3701105814",
      "display" : "安貝牙醫診所"
    },
    {
      "code" : "3701105823",
      "display" : "緻美牙醫診所"
    },
    {
      "code" : "3701105832",
      "display" : "健誌牙醫診所"
    },
    {
      "code" : "3701105878",
      "display" : "伯樂牙醫診所"
    },
    {
      "code" : "3701105887",
      "display" : "甯境牙醫診所"
    },
    {
      "code" : "3701105896",
      "display" : "長安東牙醫診所"
    },
    {
      "code" : "3701105903",
      "display" : "薇光御境牙醫診所"
    },
    {
      "code" : "3701105912",
      "display" : "順馨牙醫診所"
    },
    {
      "code" : "3701105921",
      "display" : "旭恩牙醫診所"
    },
    {
      "code" : "3701105930",
      "display" : "迪昇牙醫診所"
    },
    {
      "code" : "3701105949",
      "display" : "景正牙醫診所"
    },
    {
      "code" : "3701105958",
      "display" : "龍江牙醫診所"
    },
    {
      "code" : "3701105967",
      "display" : "景正牙醫診所"
    },
    {
      "code" : "3701105976",
      "display" : "上博牙醫診所"
    },
    {
      "code" : "3701105985",
      "display" : "榮星龍江牙醫診所"
    },
    {
      "code" : "3701105994",
      "display" : "禮悅牙醫診所"
    },
    {
      "code" : "3701106008",
      "display" : "一予中山牙醫診所"
    },
    {
      "code" : "3701106017",
      "display" : "優生活美學牙醫診所"
    },
    {
      "code" : "3701106026",
      "display" : "禾玥牙醫診所"
    },
    {
      "code" : "3701106035",
      "display" : "慶泰牙醫診所"
    },
    {
      "code" : "3701106044",
      "display" : "一予大直牙醫診所"
    },
    {
      "code" : "3701106053",
      "display" : "瑞恩牙醫診所"
    },
    {
      "code" : "3701106062",
      "display" : "英格牙醫診所"
    },
    {
      "code" : "3701106071",
      "display" : "東海牙醫診所"
    },
    {
      "code" : "3701106080",
      "display" : "一予中山牙醫診所"
    },
    {
      "code" : "3701106106",
      "display" : "心嚮牙醫診所"
    },
    {
      "code" : "3701110020",
      "display" : "一峰牙醫診所"
    },
    {
      "code" : "3701110093",
      "display" : "麗正牙醫診所"
    },
    {
      "code" : "3701110137",
      "display" : "文心牙醫診所"
    },
    {
      "code" : "3701110155",
      "display" : "信光牙醫診所"
    },
    {
      "code" : "3701110164",
      "display" : "大湖牙醫診所"
    },
    {
      "code" : "3701110182",
      "display" : "興雅牙醫診所"
    },
    {
      "code" : "3701110191",
      "display" : "微笑牙醫診所"
    },
    {
      "code" : "3701110226",
      "display" : "北一牙醫診所"
    },
    {
      "code" : "3701110253",
      "display" : "深博牙醫診所"
    },
    {
      "code" : "3701110262",
      "display" : "健恩牙醫診所"
    },
    {
      "code" : "3701110280",
      "display" : "元亨牙醫診所"
    },
    {
      "code" : "3701110299",
      "display" : "忠信牙醫診所"
    },
    {
      "code" : "3701110324",
      "display" : "仁宏牙醫診所"
    },
    {
      "code" : "3701110333",
      "display" : "大方牙醫診所"
    },
    {
      "code" : "3701110342",
      "display" : "名嘉牙醫診所"
    },
    {
      "code" : "3701110397",
      "display" : "東湖牙醫診所"
    },
    {
      "code" : "3701110502",
      "display" : "林牙醫診所"
    },
    {
      "code" : "3701110511",
      "display" : "永霖牙醫診所"
    },
    {
      "code" : "3701110539",
      "display" : "德馨牙醫診所"
    },
    {
      "code" : "3701110548",
      "display" : "博雅牙醫診所"
    },
    {
      "code" : "3701110575",
      "display" : "皇家牙醫診所"
    },
    {
      "code" : "3701110600",
      "display" : "耀生牙醫診所"
    },
    {
      "code" : "3701110646",
      "display" : "元德牙醫診所"
    },
    {
      "code" : "3701110664",
      "display" : "力奇牙醫診所"
    },
    {
      "code" : "3701110735",
      "display" : "弘林牙醫診所"
    },
    {
      "code" : "3701110753",
      "display" : "宏欣牙醫診所"
    },
    {
      "code" : "3701110762",
      "display" : "敬偉牙醫診所"
    },
    {
      "code" : "3701110771",
      "display" : "明湖牙醫診所"
    },
    {
      "code" : "3701110780",
      "display" : "西湖牙醫診所"
    },
    {
      "code" : "3701110833",
      "display" : "恩光牙醫診所"
    },
    {
      "code" : "3701110842",
      "display" : "康絜牙醫診所"
    },
    {
      "code" : "3701110851",
      "display" : "傑出牙醫診所"
    },
    {
      "code" : "3701110897",
      "display" : "麗湖牙醫診所"
    },
    {
      "code" : "3701110913",
      "display" : "龍昌牙醫診所"
    },
    {
      "code" : "3701110959",
      "display" : "光美牙醫診所"
    },
    {
      "code" : "3701110968",
      "display" : "潘渭祥牙醫診所"
    },
    {
      "code" : "3701110986",
      "display" : "前衛牙醫診所"
    },
    {
      "code" : "3701110995",
      "display" : "康德牙醫診所"
    },
    {
      "code" : "3701111009",
      "display" : "漢翎牙醫診所"
    },
    {
      "code" : "3701111027",
      "display" : "林俊民牙醫診所"
    },
    {
      "code" : "3701111036",
      "display" : "欣仁牙醫診所"
    },
    {
      "code" : "3701112079",
      "display" : "辰龍牙醫診所"
    },
    {
      "code" : "3701112104",
      "display" : "康鄰牙醫診所"
    },
    {
      "code" : "3701112113",
      "display" : "菁華牙醫診所"
    },
    {
      "code" : "3701112122",
      "display" : "平安牙醫診所"
    },
    {
      "code" : "3701112131",
      "display" : "湖山牙醫診所"
    },
    {
      "code" : "3701112177",
      "display" : "文德牙醫診所"
    },
    {
      "code" : "3701112202",
      "display" : "專加牙醫診所"
    },
    {
      "code" : "3701112211",
      "display" : "安政牙醫診所"
    },
    {
      "code" : "3701112248",
      "display" : "白金牙醫診所"
    },
    {
      "code" : "3701112266",
      "display" : "麗緻牙醫診所"
    },
    {
      "code" : "3701112293",
      "display" : "亞卓牙醫診所"
    },
    {
      "code" : "3701112300",
      "display" : "萬居牙醫診所"
    },
    {
      "code" : "3701112319",
      "display" : "京威聯合牙醫診所"
    },
    {
      "code" : "3701112337",
      "display" : "翠柏牙醫診所"
    },
    {
      "code" : "3701112346",
      "display" : "德康牙醫診所"
    },
    {
      "code" : "3701112373",
      "display" : "仁人牙醫診所"
    },
    {
      "code" : "3701112382",
      "display" : "瑞光牙醫診所"
    },
    {
      "code" : "3701112391",
      "display" : "仁澤牙醫診所"
    },
    {
      "code" : "3701112408",
      "display" : "康豪牙醫診所"
    },
    {
      "code" : "3701112417",
      "display" : "丰采牙醫診所"
    },
    {
      "code" : "3701112426",
      "display" : "誠心牙醫診所"
    },
    {
      "code" : "3701112444",
      "display" : "錸雅牙醫診所"
    },
    {
      "code" : "3701112453",
      "display" : "丞康牙醫診所"
    },
    {
      "code" : "3701112471",
      "display" : "宏瑞牙醫診所"
    },
    {
      "code" : "3701112499",
      "display" : "德軒津牙醫診所"
    },
    {
      "code" : "3701112560",
      "display" : "華倫牙醫診所"
    },
    {
      "code" : "3701112579",
      "display" : "萬和牙醫診所"
    },
    {
      "code" : "3701112597",
      "display" : "晴天牙醫診所"
    },
    {
      "code" : "3701112622",
      "display" : "康民牙醫診所"
    },
    {
      "code" : "3701112631",
      "display" : "庭軒牙醫診所"
    },
    {
      "code" : "3701112640",
      "display" : "韻昇牙醫診所"
    },
    {
      "code" : "3701112668",
      "display" : "元康牙醫診所"
    },
    {
      "code" : "3701112686",
      "display" : "維悅牙醫診所"
    },
    {
      "code" : "3701112702",
      "display" : "品潔牙醫診所"
    },
    {
      "code" : "3701112711",
      "display" : "心美牙醫診所"
    },
    {
      "code" : "3701112739",
      "display" : "宸采牙醫診所"
    },
    {
      "code" : "3701112748",
      "display" : "優生活牙醫診所"
    },
    {
      "code" : "3701112757",
      "display" : "似真牙醫診所"
    },
    {
      "code" : "3701112766",
      "display" : "澄美牙醫診所"
    },
    {
      "code" : "3701112775",
      "display" : "品牙醫診所"
    },
    {
      "code" : "3701112793",
      "display" : "維晟牙醫診所"
    },
    {
      "code" : "3701112800",
      "display" : "喜悅牙醫診所"
    },
    {
      "code" : "3701112819",
      "display" : "仁亨牙醫診所"
    },
    {
      "code" : "3701112855",
      "display" : "文湖牙醫診所"
    },
    {
      "code" : "3701112864",
      "display" : "金陽牙醫診所"
    },
    {
      "code" : "3701112873",
      "display" : "維欣牙醫診所"
    },
    {
      "code" : "3701112908",
      "display" : "涵堤牙醫診所"
    },
    {
      "code" : "3701112935",
      "display" : "惟君美學牙醫診所"
    },
    {
      "code" : "3701112944",
      "display" : "欣悅牙醫診所"
    },
    {
      "code" : "3701112953",
      "display" : "象阿姨牙科診所"
    },
    {
      "code" : "3701112971",
      "display" : "璟品牙醫診所"
    },
    {
      "code" : "3701112999",
      "display" : "美立華牙醫診所"
    },
    {
      "code" : "3701113012",
      "display" : "美學地圖牙醫診所"
    },
    {
      "code" : "3701113021",
      "display" : "怡安牙醫診所"
    },
    {
      "code" : "3701113030",
      "display" : "明品牙醫診所"
    },
    {
      "code" : "3701113049",
      "display" : "德威國際牙醫診所"
    },
    {
      "code" : "3701113067",
      "display" : "優秀牙醫診所"
    },
    {
      "code" : "3701113094",
      "display" : "文湖美學牙醫診所"
    },
    {
      "code" : "3701113101",
      "display" : "新東京牙醫診所"
    },
    {
      "code" : "3701113110",
      "display" : "佳一牙醫診所"
    },
    {
      "code" : "3701113129",
      "display" : "皇齊牙醫診所"
    },
    {
      "code" : "3701113138",
      "display" : "舒美牙醫診所"
    },
    {
      "code" : "3701113147",
      "display" : "紐大牙醫診所"
    },
    {
      "code" : "3701113156",
      "display" : "年代牙醫診所"
    },
    {
      "code" : "3701113165",
      "display" : "格唯牙醫診所"
    },
    {
      "code" : "3701113183",
      "display" : "湖美牙醫診所"
    },
    {
      "code" : "3701113192",
      "display" : "榮登牙醫診所"
    },
    {
      "code" : "3701113218",
      "display" : "舒湖牙醫診所"
    },
    {
      "code" : "3701113227",
      "display" : "喬治牙醫診所"
    },
    {
      "code" : "3701113236",
      "display" : "金臨牙醫診所"
    },
    {
      "code" : "3701113245",
      "display" : "內湖雅德思牙醫診所"
    },
    {
      "code" : "3701113254",
      "display" : "澄正牙醫診所"
    },
    {
      "code" : "3701113263",
      "display" : "旭東牙醫診所"
    },
    {
      "code" : "3701113281",
      "display" : "737媄蒔美學牙醫診所"
    },
    {
      "code" : "3701113290",
      "display" : "星耀牙醫診所"
    },
    {
      "code" : "3701120017",
      "display" : "玉成牙醫診所"
    },
    {
      "code" : "3701120035",
      "display" : "緯泰牙醫診所"
    },
    {
      "code" : "3701120044",
      "display" : "德聲牙醫診所"
    },
    {
      "code" : "3701120062",
      "display" : "弘光牙醫診所"
    },
    {
      "code" : "3701120106",
      "display" : "南港牙醫診所"
    },
    {
      "code" : "3701120197",
      "display" : "一品牙醫診所"
    },
    {
      "code" : "3701120222",
      "display" : "宏昇牙醫診所"
    },
    {
      "code" : "3701120268",
      "display" : "瓊萻牙醫診所"
    },
    {
      "code" : "3701120302",
      "display" : "重生牙醫診所"
    },
    {
      "code" : "3701120320",
      "display" : "華德牙醫診所"
    },
    {
      "code" : "3701120339",
      "display" : "美嘉牙醫診所"
    },
    {
      "code" : "3701120428",
      "display" : "弘生牙醫診所"
    },
    {
      "code" : "3701120455",
      "display" : "德心牙醫診所"
    },
    {
      "code" : "3701120482",
      "display" : "芝加哥牙醫診所"
    },
    {
      "code" : "3701121550",
      "display" : "大成牙醫診所"
    },
    {
      "code" : "3701121569",
      "display" : "上品牙醫診所"
    },
    {
      "code" : "3701121578",
      "display" : "昆陽牙醫診所"
    },
    {
      "code" : "3701121587",
      "display" : "聖欣牙醫診所"
    },
    {
      "code" : "3701121596",
      "display" : "祐生牙醫診所"
    },
    {
      "code" : "3701121630",
      "display" : "東豐牙醫診所"
    },
    {
      "code" : "3701121649",
      "display" : "新洋牙醫診所"
    },
    {
      "code" : "3701121667",
      "display" : "向陽牙醫診所"
    },
    {
      "code" : "3701121676",
      "display" : "世展牙醫診所"
    },
    {
      "code" : "3701121685",
      "display" : "和群牙醫診所"
    },
    {
      "code" : "3701121694",
      "display" : "惠正牙醫診所"
    },
    {
      "code" : "3701121729",
      "display" : "東明牙醫診所"
    },
    {
      "code" : "3701121836",
      "display" : "蒔堤牙醫診所"
    },
    {
      "code" : "3701121845",
      "display" : "定遠新天地牙醫診所"
    },
    {
      "code" : "3701121863",
      "display" : "樂美牙醫診所"
    },
    {
      "code" : "3701121872",
      "display" : "安民牙醫診所"
    },
    {
      "code" : "3701121881",
      "display" : "真福牙醫診所"
    },
    {
      "code" : "3701121890",
      "display" : "寰宇牙醫診所"
    },
    {
      "code" : "3701121907",
      "display" : "菘興牙醫診所"
    },
    {
      "code" : "3701121916",
      "display" : "優聖美牙醫診所"
    },
    {
      "code" : "3701121925",
      "display" : "皓亞牙醫診所"
    },
    {
      "code" : "3701121934",
      "display" : "安民牙醫診所"
    },
    {
      "code" : "3701121943",
      "display" : "寰星牙醫診所"
    },
    {
      "code" : "3701121952",
      "display" : "韋登牙醫診所"
    },
    {
      "code" : "3701121970",
      "display" : "沐澄美學牙醫診所"
    },
    {
      "code" : "3701121989",
      "display" : "暁美牙醫診所"
    },
    {
      "code" : "3701121998",
      "display" : "禾顏牙醫診所"
    },
    {
      "code" : "3701122002",
      "display" : "和煦牙醫診所"
    },
    {
      "code" : "3701150015",
      "display" : "忠誠牙醫診所"
    },
    {
      "code" : "3701150024",
      "display" : "大雅牙醫診所"
    },
    {
      "code" : "3701150042",
      "display" : "賴牙醫診所"
    },
    {
      "code" : "3701150097",
      "display" : "嘉民牙醫診所"
    },
    {
      "code" : "3701150131",
      "display" : "弘佑牙醫診所"
    },
    {
      "code" : "3701150140",
      "display" : "第一牙醫診所"
    },
    {
      "code" : "3701150159",
      "display" : "光華牙醫診所"
    },
    {
      "code" : "3701150168",
      "display" : "雅鄰牙醫診所"
    },
    {
      "code" : "3701150177",
      "display" : "親親牙醫診所"
    },
    {
      "code" : "3701150195",
      "display" : "陳慶成牙醫診所"
    },
    {
      "code" : "3701150202",
      "display" : "長虹牙醫診所"
    },
    {
      "code" : "3701150239",
      "display" : "宏誠牙醫診所"
    },
    {
      "code" : "3701150266",
      "display" : "凱健牙醫診所"
    },
    {
      "code" : "3701150284",
      "display" : "喬森牙醫診所"
    },
    {
      "code" : "3701150293",
      "display" : "信誼牙醫診所"
    },
    {
      "code" : "3701150328",
      "display" : "光和牙醫診所"
    },
    {
      "code" : "3701150337",
      "display" : "信美牙醫診所"
    },
    {
      "code" : "3701150346",
      "display" : "端容牙醫診所"
    },
    {
      "code" : "3701150364",
      "display" : "士東牙醫診所"
    },
    {
      "code" : "3701150373",
      "display" : "蘇鴻輝牙醫診所"
    },
    {
      "code" : "3701150417",
      "display" : "德行牙醫診所"
    },
    {
      "code" : "3701150426",
      "display" : "亨皓牙醫診所"
    },
    {
      "code" : "3701150444",
      "display" : "瑞陽牙醫診所"
    },
    {
      "code" : "3701150515",
      "display" : "新民牙醫診所"
    },
    {
      "code" : "3701150560",
      "display" : "永芳牙醫診所"
    },
    {
      "code" : "3701150579",
      "display" : "愛齒牙醫診所"
    },
    {
      "code" : "3701150588",
      "display" : "劉牙醫診所"
    },
    {
      "code" : "3701150604",
      "display" : "健群牙醫診所"
    },
    {
      "code" : "3701150640",
      "display" : "慶仁牙醫診所"
    },
    {
      "code" : "3701150659",
      "display" : "弘美牙醫診所"
    },
    {
      "code" : "3701150695",
      "display" : "周欽定牙醫診所"
    },
    {
      "code" : "3701150711",
      "display" : "社子黃牙醫診所"
    },
    {
      "code" : "3701150720",
      "display" : "昭亮牙醫診所"
    },
    {
      "code" : "3701150748",
      "display" : "嚴永強牙醫診所"
    },
    {
      "code" : "3701150775",
      "display" : "立安牙醫診所"
    },
    {
      "code" : "3701150784",
      "display" : "千賀牙醫診所"
    },
    {
      "code" : "3701150819",
      "display" : "永泰牙醫診所"
    },
    {
      "code" : "3701150891",
      "display" : "鄭文韶牙醫診所"
    },
    {
      "code" : "3701150908",
      "display" : "祥瑞牙醫診所"
    },
    {
      "code" : "3701150926",
      "display" : "以新牙醫診所"
    },
    {
      "code" : "3701150935",
      "display" : "博浩牙醫診所"
    },
    {
      "code" : "3701150999",
      "display" : "揚明牙醫診所"
    },
    {
      "code" : "3701151183",
      "display" : "念華牙醫診所"
    },
    {
      "code" : "3701151192",
      "display" : "永信牙醫診所"
    },
    {
      "code" : "3701151209",
      "display" : "昇陽牙醫診所"
    },
    {
      "code" : "3701151227",
      "display" : "芝山牙醫診所"
    },
    {
      "code" : "3701151352",
      "display" : "威廉牙醫診所"
    },
    {
      "code" : "3701151361",
      "display" : "世安牙醫診所"
    },
    {
      "code" : "3701151423",
      "display" : "博信牙醫診所"
    },
    {
      "code" : "3701151432",
      "display" : "家福牙醫診所"
    },
    {
      "code" : "3701151450",
      "display" : "經緯牙醫診所"
    },
    {
      "code" : "3701151478",
      "display" : "揚信牙醫診所"
    },
    {
      "code" : "3701151496",
      "display" : "廣都牙醫診所"
    },
    {
      "code" : "3701151503",
      "display" : "福元牙醫診所"
    },
    {
      "code" : "3701151512",
      "display" : "佳樺牙醫診所"
    },
    {
      "code" : "3701151530",
      "display" : "吳越夫牙醫診所"
    },
    {
      "code" : "3701151549",
      "display" : "東成牙醫診所"
    },
    {
      "code" : "3701151610",
      "display" : "育生牙醫診所"
    },
    {
      "code" : "3701151629",
      "display" : "福國牙醫診所"
    },
    {
      "code" : "3701151638",
      "display" : "邱瑋光牙醫診所"
    },
    {
      "code" : "3701151647",
      "display" : "茂林牙醫診所"
    },
    {
      "code" : "3701151683",
      "display" : "三船牙醫診所"
    },
    {
      "code" : "3701151709",
      "display" : "傅家義牙醫診所"
    },
    {
      "code" : "3701151718",
      "display" : "有仁牙醫診所"
    },
    {
      "code" : "3701151763",
      "display" : "佑成牙醫診所"
    },
    {
      "code" : "3701151772",
      "display" : "保齡牙醫診所"
    },
    {
      "code" : "3701156688",
      "display" : "天母牙醫診所"
    },
    {
      "code" : "3701156713",
      "display" : "福臨牙醫診所"
    },
    {
      "code" : "3701156722",
      "display" : "吳方棟牙醫診所"
    },
    {
      "code" : "3701156731",
      "display" : "哲瑞牙醫診所"
    },
    {
      "code" : "3701156740",
      "display" : "許牙醫診所"
    },
    {
      "code" : "3701156768",
      "display" : "立宸牙醫診所"
    },
    {
      "code" : "3701156777",
      "display" : "聯有牙醫診所"
    },
    {
      "code" : "3701156786",
      "display" : "旺德牙醫診所"
    },
    {
      "code" : "3701156795",
      "display" : "宗賢牙醫診所"
    },
    {
      "code" : "3701156875",
      "display" : "京東牙醫診所"
    },
    {
      "code" : "3701156884",
      "display" : "劭陽牙醫診所"
    },
    {
      "code" : "3701156919",
      "display" : "國聯牙醫診所"
    },
    {
      "code" : "3701156928",
      "display" : "維美牙醫診所"
    },
    {
      "code" : "3701156937",
      "display" : "大偉牙醫診所"
    },
    {
      "code" : "3701156964",
      "display" : "美加牙醫診所"
    },
    {
      "code" : "3701156973",
      "display" : "正齡牙醫診所"
    },
    {
      "code" : "3701157023",
      "display" : "國維牙醫診所"
    },
    {
      "code" : "3701157103",
      "display" : "三愛牙醫診所"
    },
    {
      "code" : "3701157121",
      "display" : "中美牙醫診所"
    },
    {
      "code" : "3701157130",
      "display" : "天泉牙醫診所"
    },
    {
      "code" : "3701157167",
      "display" : "楊恭熙牙醫診所"
    },
    {
      "code" : "3701157176",
      "display" : "芳川牙醫診所"
    },
    {
      "code" : "3701157185",
      "display" : "宏仁牙醫診所"
    },
    {
      "code" : "3701157201",
      "display" : "賓大牙醫診所"
    },
    {
      "code" : "3701157247",
      "display" : "戴得育牙醫診所"
    },
    {
      "code" : "3701157274",
      "display" : "聖林牙醫診所"
    },
    {
      "code" : "3701157283",
      "display" : "達美牙醫診所"
    },
    {
      "code" : "3701157309",
      "display" : "天玉牙醫診所"
    },
    {
      "code" : "3701157318",
      "display" : "美齊牙醫診所"
    },
    {
      "code" : "3701157336",
      "display" : "立芙美學牙醫診所"
    },
    {
      "code" : "3701157345",
      "display" : "博格牙醫診所"
    },
    {
      "code" : "3701157372",
      "display" : "倍爾牙醫診所"
    },
    {
      "code" : "3701157381",
      "display" : "可潔牙醫診所"
    },
    {
      "code" : "3701157390",
      "display" : "合聖牙醫診所"
    },
    {
      "code" : "3701157407",
      "display" : "維育牙醫診所"
    },
    {
      "code" : "3701157443",
      "display" : "彭志綱牙醫診所"
    },
    {
      "code" : "3701157452",
      "display" : "和彩牙醫診所"
    },
    {
      "code" : "3701157470",
      "display" : "悅庭牙醫診所"
    },
    {
      "code" : "3701157489",
      "display" : "英倫牙醫診所"
    },
    {
      "code" : "3701157505",
      "display" : "優德牙醫診所"
    },
    {
      "code" : "3701157523",
      "display" : "林政毅牙醫診所"
    },
    {
      "code" : "3701157541",
      "display" : "廖宥程齒顎矯正專科診所"
    },
    {
      "code" : "3701157578",
      "display" : "亮顏美學牙醫診所"
    },
    {
      "code" : "3701157587",
      "display" : "品耀牙醫診所"
    },
    {
      "code" : "3701157596",
      "display" : "晶亮牙醫診所"
    },
    {
      "code" : "3701157603",
      "display" : "慕樂牙醫診所"
    },
    {
      "code" : "3701157621",
      "display" : "奧森牙醫診所"
    },
    {
      "code" : "3701157630",
      "display" : "順祥牙醫診所"
    },
    {
      "code" : "3701157649",
      "display" : "晶綻牙醫診所"
    },
    {
      "code" : "3701157667",
      "display" : "博識牙醫診所"
    },
    {
      "code" : "3701157676",
      "display" : "天悅牙醫診所"
    },
    {
      "code" : "3701157685",
      "display" : "柏麗牙醫診所"
    },
    {
      "code" : "3701157694",
      "display" : "新鼎牙醫診所"
    },
    {
      "code" : "3701157701",
      "display" : "格子牙醫診所"
    },
    {
      "code" : "3701157710",
      "display" : "永慶牙醫診所"
    },
    {
      "code" : "3701157729",
      "display" : "太仁牙醫診所"
    },
    {
      "code" : "3701157738",
      "display" : "嘉芮牙醫診所"
    },
    {
      "code" : "3701157765",
      "display" : "士林頌恩齒顎矯正牙醫診所"
    },
    {
      "code" : "3701157774",
      "display" : "和玉牙醫診所"
    },
    {
      "code" : "3701157792",
      "display" : "悅美牙醫診所"
    },
    {
      "code" : "3701157809",
      "display" : "悅馨牙醫診所"
    },
    {
      "code" : "3701157818",
      "display" : "嘉芮牙醫診所"
    },
    {
      "code" : "3701157827",
      "display" : "劍潭璞軒牙醫診所"
    },
    {
      "code" : "3701157836",
      "display" : "唯心牙醫診所"
    },
    {
      "code" : "3701157845",
      "display" : "梅西牙醫診所"
    },
    {
      "code" : "3701157863",
      "display" : "海蒂牙醫診所"
    },
    {
      "code" : "3701157872",
      "display" : "亮顏美學牙醫診所"
    },
    {
      "code" : "3701157881",
      "display" : "維娜斯美學牙醫診所"
    },
    {
      "code" : "3701157890",
      "display" : "天母一日誠臻牙醫診所"
    },
    {
      "code" : "3701157907",
      "display" : "安星牙醫診所"
    },
    {
      "code" : "3701157916",
      "display" : "旭天牙醫診所"
    },
    {
      "code" : "3701157925",
      "display" : "沐晴牙醫診所"
    },
    {
      "code" : "3701160020",
      "display" : "英華牙醫診所"
    },
    {
      "code" : "3701160048",
      "display" : "榮恩牙醫診所"
    },
    {
      "code" : "3701160066",
      "display" : "中和牙醫診所"
    },
    {
      "code" : "3701160084",
      "display" : "永光牙醫診所"
    },
    {
      "code" : "3701160128",
      "display" : "啟仁牙醫診所"
    },
    {
      "code" : "3701160155",
      "display" : "五洲牙醫診所"
    },
    {
      "code" : "3701160164",
      "display" : "倪牙醫診所"
    },
    {
      "code" : "3701160182",
      "display" : "世界牙醫診所"
    },
    {
      "code" : "3701160217",
      "display" : "宏恩牙科診所"
    },
    {
      "code" : "3701160226",
      "display" : "方仁牙醫診所"
    },
    {
      "code" : "3701160262",
      "display" : "益群牙醫診所"
    },
    {
      "code" : "3701160271",
      "display" : "大程牙醫診所"
    },
    {
      "code" : "3701160315",
      "display" : "慶全牙醫診所"
    },
    {
      "code" : "3701160351",
      "display" : "青島牙醫診所"
    },
    {
      "code" : "3701160397",
      "display" : "幸福牙醫診所"
    },
    {
      "code" : "3701160404",
      "display" : "長生堂牙醫診所"
    },
    {
      "code" : "3701160459",
      "display" : "樂奇牙醫診所"
    },
    {
      "code" : "3701160495",
      "display" : "德祥牙醫診所"
    },
    {
      "code" : "3701160539",
      "display" : "健惠牙醫診所"
    },
    {
      "code" : "3701160593",
      "display" : "瑞泰牙醫診所"
    },
    {
      "code" : "3701160637",
      "display" : "信安牙醫診所"
    },
    {
      "code" : "3701160646",
      "display" : "德安牙醫診所"
    },
    {
      "code" : "3701160664",
      "display" : "迦美牙醫診所"
    },
    {
      "code" : "3701160673",
      "display" : "致遠牙醫診所"
    },
    {
      "code" : "3701160682",
      "display" : "方圓牙醫診所"
    },
    {
      "code" : "3701160735",
      "display" : "家康牙醫診所"
    },
    {
      "code" : "3701160753",
      "display" : "林璞牙醫診所"
    },
    {
      "code" : "3701160780",
      "display" : "惠生牙醫聯合診所"
    },
    {
      "code" : "3701160806",
      "display" : "明德牙醫診所"
    },
    {
      "code" : "3701160842",
      "display" : "群昇牙醫診所"
    },
    {
      "code" : "3701160879",
      "display" : "大眾牙醫診所"
    },
    {
      "code" : "3701160888",
      "display" : "永翰牙醫診所"
    },
    {
      "code" : "3701160913",
      "display" : "李國屏牙醫診所"
    },
    {
      "code" : "3701160995",
      "display" : "啟容牙醫診所"
    },
    {
      "code" : "3701161018",
      "display" : "新市牙醫診所"
    },
    {
      "code" : "3701161027",
      "display" : "恆安牙醫診所"
    },
    {
      "code" : "3701161036",
      "display" : "群欣牙醫診所"
    },
    {
      "code" : "3701161045",
      "display" : "柏菱牙醫診所"
    },
    {
      "code" : "3701161054",
      "display" : "微美牙醫診所"
    },
    {
      "code" : "3701162051",
      "display" : "宇隆牙醫診所"
    },
    {
      "code" : "3701162079",
      "display" : "喜美牙醫診所"
    },
    {
      "code" : "3701162097",
      "display" : "金牙醫診所"
    },
    {
      "code" : "3701162122",
      "display" : "富群牙醫診所"
    },
    {
      "code" : "3701162186",
      "display" : "明月牙醫診所"
    },
    {
      "code" : "3701162195",
      "display" : "京品牙醫診所"
    },
    {
      "code" : "3701162202",
      "display" : "志強牙醫診所"
    },
    {
      "code" : "3701162211",
      "display" : "禾睿牙醫診所"
    },
    {
      "code" : "3701162220",
      "display" : "廖峻宏牙醫診所"
    },
    {
      "code" : "3701162248",
      "display" : "陽明牙醫診所"
    },
    {
      "code" : "3701162257",
      "display" : "博泰牙醫診所"
    },
    {
      "code" : "3701162275",
      "display" : "天倚牙醫診所"
    },
    {
      "code" : "3701162293",
      "display" : "東欣牙醫診所"
    },
    {
      "code" : "3701162319",
      "display" : "典藏牙醫診所"
    },
    {
      "code" : "3701162328",
      "display" : "長麗牙醫診所"
    },
    {
      "code" : "3701162337",
      "display" : "聯美牙醫診所"
    },
    {
      "code" : "3701162346",
      "display" : "定鼎牙醫診所"
    },
    {
      "code" : "3701162355",
      "display" : "詠恩牙醫診所"
    },
    {
      "code" : "3701162364",
      "display" : "向日葵牙醫診所"
    },
    {
      "code" : "3701162373",
      "display" : "品緻牙醫診所"
    },
    {
      "code" : "3701162382",
      "display" : "藝術家牙醫診所"
    },
    {
      "code" : "3701162391",
      "display" : "維格牙醫診所"
    },
    {
      "code" : "3701162408",
      "display" : "永成牙醫診所"
    },
    {
      "code" : "3701162426",
      "display" : "晨緹牙醫珍所"
    },
    {
      "code" : "3701162462",
      "display" : "安心牙醫診所"
    },
    {
      "code" : "3701162471",
      "display" : "誠鴻牙醫診所"
    },
    {
      "code" : "3701162480",
      "display" : "况叔叔齒顎矯正專科牙醫診所"
    },
    {
      "code" : "3701162524",
      "display" : "洪榮杰牙醫診所"
    },
    {
      "code" : "3701162533",
      "display" : "鑫鑫牙醫診所"
    },
    {
      "code" : "3701162542",
      "display" : "陽明格子牙醫診所"
    },
    {
      "code" : "3701162551",
      "display" : "風荷牙醫診所"
    },
    {
      "code" : "3701162560",
      "display" : "薇美牙醫診所"
    },
    {
      "code" : "3701162579",
      "display" : "迪生牙醫診所"
    },
    {
      "code" : "3701162588",
      "display" : "沐沐牙醫診所"
    },
    {
      "code" : "3701162597",
      "display" : "迪生牙醫診所"
    },
    {
      "code" : "3701162604",
      "display" : "群欣牙醫診所"
    },
    {
      "code" : "3701162613",
      "display" : "群岳牙醫診所"
    },
    {
      "code" : "3701162622",
      "display" : "風和美學牙醫診所"
    },
    {
      "code" : "3701162631",
      "display" : "樂植牙醫診所"
    },
    {
      "code" : "3701162659",
      "display" : "晴空翡儷牙醫診所"
    },
    {
      "code" : "3701162668",
      "display" : "沐沐美學牙醫診所"
    },
    {
      "code" : "3701162677",
      "display" : "維格牙醫診所"
    },
    {
      "code" : "3701162686",
      "display" : "嘉宥牙醫診所"
    },
    {
      "code" : "3701162695",
      "display" : "鑫鑫牙醫診所"
    },
    {
      "code" : "3701170053",
      "display" : "達新牙醫診所"
    },
    {
      "code" : "3701170099",
      "display" : "明仁牙醫診所"
    },
    {
      "code" : "3701170106",
      "display" : "錫口牙醫診所"
    },
    {
      "code" : "3701170133",
      "display" : "福德牙醫診所"
    },
    {
      "code" : "3701170160",
      "display" : "朝宏牙醫診所"
    },
    {
      "code" : "3701170197",
      "display" : "松山仁祥牙醫診所"
    },
    {
      "code" : "3701170222",
      "display" : "唐風牙醫診所"
    },
    {
      "code" : "3701170231",
      "display" : "弘益牙醫診所"
    },
    {
      "code" : "3701170240",
      "display" : "永吉牙醫診所"
    },
    {
      "code" : "3701170295",
      "display" : "陳明繁牙醫診所"
    },
    {
      "code" : "3701170302",
      "display" : "安人牙醫診所"
    },
    {
      "code" : "3701170311",
      "display" : "華明牙醫診所"
    },
    {
      "code" : "3701170339",
      "display" : "臺元牙醫診所"
    },
    {
      "code" : "3701170348",
      "display" : "美麗華牙醫診所"
    },
    {
      "code" : "3701170400",
      "display" : "中光牙醫診所"
    },
    {
      "code" : "3701170419",
      "display" : "林聰明牙醫診所"
    },
    {
      "code" : "3701170428",
      "display" : "天成牙醫診所"
    },
    {
      "code" : "3701170508",
      "display" : "東群牙醫診所"
    },
    {
      "code" : "3701170544",
      "display" : "韋倫牙醫診所"
    },
    {
      "code" : "3701170571",
      "display" : "建全牙醫診所"
    },
    {
      "code" : "3701170580",
      "display" : "尚德牙醫診所"
    },
    {
      "code" : "3701170633",
      "display" : "松德牙醫診所"
    },
    {
      "code" : "3701170642",
      "display" : "吉欣牙醫診所"
    },
    {
      "code" : "3701170660",
      "display" : "上林牙醫診所"
    },
    {
      "code" : "3701170713",
      "display" : "星光牙醫診所"
    },
    {
      "code" : "3701170740",
      "display" : "賴獻章牙醫診所"
    },
    {
      "code" : "3701170759",
      "display" : "永齡牙醫診所"
    },
    {
      "code" : "3701170795",
      "display" : "成品牙醫診所"
    },
    {
      "code" : "3701170839",
      "display" : "正揚牙醫診所"
    },
    {
      "code" : "3701170893",
      "display" : "富陽牙醫診所"
    },
    {
      "code" : "3701170900",
      "display" : "松志牙醫診所"
    },
    {
      "code" : "3701170937",
      "display" : "陳彥傑牙醫診所"
    },
    {
      "code" : "3701170964",
      "display" : "彩虹牙醫診所"
    },
    {
      "code" : "3701170973",
      "display" : "佳曏牙醫診所"
    },
    {
      "code" : "3701171096",
      "display" : "百齡牙醫診所"
    },
    {
      "code" : "3701171103",
      "display" : "上宏牙醫診所"
    },
    {
      "code" : "3701171130",
      "display" : "亮傑牙醫診所"
    },
    {
      "code" : "3701171167",
      "display" : "美好牙醫診所"
    },
    {
      "code" : "3701171194",
      "display" : "吳牙醫診所"
    },
    {
      "code" : "3701171201",
      "display" : "萬福牙醫診所"
    },
    {
      "code" : "3701171210",
      "display" : "阿波羅牙醫診所"
    },
    {
      "code" : "3701171256",
      "display" : "莊敬牙醫診所"
    },
    {
      "code" : "3701171265",
      "display" : "佳興牙醫診所"
    },
    {
      "code" : "3701171274",
      "display" : "同德牙醫診所"
    },
    {
      "code" : "3701171309",
      "display" : "沈牙醫診所"
    },
    {
      "code" : "3701171336",
      "display" : "鴻利牙醫診所"
    },
    {
      "code" : "3701171470",
      "display" : "全日牙醫診所"
    },
    {
      "code" : "3701171541",
      "display" : "聯安牙醫診所"
    },
    {
      "code" : "3701171603",
      "display" : "國瑞牙醫診所"
    },
    {
      "code" : "3701171658",
      "display" : "明清牙醫診所"
    },
    {
      "code" : "3701171667",
      "display" : "健家牙醫診所"
    },
    {
      "code" : "3701171710",
      "display" : "郭牙醫診所"
    },
    {
      "code" : "3701171792",
      "display" : "松華牙醫診所"
    },
    {
      "code" : "3701171818",
      "display" : "輝煌牙醫診所"
    },
    {
      "code" : "3701171854",
      "display" : "誠泰牙醫診所"
    },
    {
      "code" : "3701172879",
      "display" : "吳興牙醫診所"
    },
    {
      "code" : "3701172913",
      "display" : "芳林牙醫診所"
    },
    {
      "code" : "3701172931",
      "display" : "優品牙醫診所"
    },
    {
      "code" : "3701172977",
      "display" : "古德牙醫診所"
    },
    {
      "code" : "3701172986",
      "display" : "強棒牙醫診所"
    },
    {
      "code" : "3701173018",
      "display" : "華信牙醫診所"
    },
    {
      "code" : "3701173036",
      "display" : "聯華牙醫診所"
    },
    {
      "code" : "3701173090",
      "display" : "世樺牙醫診所"
    },
    {
      "code" : "3701173107",
      "display" : "東風牙醫診所"
    },
    {
      "code" : "3701173116",
      "display" : "佳和牙醫診所"
    },
    {
      "code" : "3701173143",
      "display" : "滕起民牙醫診所"
    },
    {
      "code" : "3701173189",
      "display" : "豐荷牙醫診所"
    },
    {
      "code" : "3701173232",
      "display" : "柏皓牙醫診所"
    },
    {
      "code" : "3701173278",
      "display" : "松信牙醫診所"
    },
    {
      "code" : "3701173312",
      "display" : "鄒志揚牙醫診所"
    },
    {
      "code" : "3701173349",
      "display" : "京典牙醫診所"
    },
    {
      "code" : "3701173367",
      "display" : "和安牙醫診所"
    },
    {
      "code" : "3701173394",
      "display" : "御瑄牙醫診所"
    },
    {
      "code" : "3701173401",
      "display" : "瑞比牙醫診所"
    },
    {
      "code" : "3701173429",
      "display" : "美麗永春牙醫診所"
    },
    {
      "code" : "3701173438",
      "display" : "群博牙醫診所"
    },
    {
      "code" : "3701173483",
      "display" : "松仁牙醫診所"
    },
    {
      "code" : "3701173492",
      "display" : "榮德牙醫診所"
    },
    {
      "code" : "3701173509",
      "display" : "鼎泰牙醫診所"
    },
    {
      "code" : "3701173545",
      "display" : "致再牙醫診所"
    },
    {
      "code" : "3701173554",
      "display" : "晶彩牙醫診所"
    },
    {
      "code" : "3701173590",
      "display" : "東南牙醫診所"
    },
    {
      "code" : "3701173616",
      "display" : "儀佳牙醫診所"
    },
    {
      "code" : "3701173625",
      "display" : "優式牙醫診所"
    },
    {
      "code" : "3701173670",
      "display" : "友達牙醫診所"
    },
    {
      "code" : "3701173689",
      "display" : "艾來牙醫診所"
    },
    {
      "code" : "3701173705",
      "display" : "國泰牙醫診所"
    },
    {
      "code" : "3701173723",
      "display" : "道明牙醫診所"
    },
    {
      "code" : "3701173732",
      "display" : "陳麗妃牙醫診所"
    },
    {
      "code" : "3701173741",
      "display" : "雅術牙醫診所"
    },
    {
      "code" : "3701173750",
      "display" : "敦美牙醫診所"
    },
    {
      "code" : "3701173769",
      "display" : "仁愛傑仕牙醫診所"
    },
    {
      "code" : "3701173778",
      "display" : "忠孝牙醫診所"
    },
    {
      "code" : "3701173787",
      "display" : "美爵牙醫診所"
    },
    {
      "code" : "3701173796",
      "display" : "美麗潔美學牙醫診所"
    },
    {
      "code" : "3701173803",
      "display" : "維京牙醫診所"
    },
    {
      "code" : "3701173812",
      "display" : "陳靜宜牙醫診所"
    },
    {
      "code" : "3701173821",
      "display" : "雅美信牙醫診所"
    },
    {
      "code" : "3701173849",
      "display" : "睿宏牙醫診所"
    },
    {
      "code" : "3701173858",
      "display" : "御瑞牙醫診所"
    },
    {
      "code" : "3701173867",
      "display" : "良品牙醫診所"
    },
    {
      "code" : "3701173876",
      "display" : "艾潔牙醫診所"
    },
    {
      "code" : "3701173901",
      "display" : "翡冷翠牙醫診所"
    },
    {
      "code" : "3701173910",
      "display" : "加林牙醫診所"
    },
    {
      "code" : "3701173929",
      "display" : "康森牙醫診所"
    },
    {
      "code" : "3701173938",
      "display" : "一杏牙醫診所"
    },
    {
      "code" : "3701173947",
      "display" : "品軒牙醫診所"
    },
    {
      "code" : "3701173965",
      "display" : "福樂牙醫診所"
    },
    {
      "code" : "3701173983",
      "display" : "哈佛永春牙醫診所"
    },
    {
      "code" : "3701173992",
      "display" : "艾來公園牙醫診所"
    },
    {
      "code" : "3701174006",
      "display" : "松仁牙醫診所"
    },
    {
      "code" : "3701174015",
      "display" : "沐群牙醫診所"
    },
    {
      "code" : "3701174024",
      "display" : "布布齒科牙醫診所"
    },
    {
      "code" : "3701174033",
      "display" : "品軒唯美牙醫診所"
    },
    {
      "code" : "3701174042",
      "display" : "聯安牙醫診所"
    },
    {
      "code" : "3701174051",
      "display" : "康森牙醫診所"
    },
    {
      "code" : "3701174079",
      "display" : "羅氏美學牙醫診所"
    },
    {
      "code" : "3701180031",
      "display" : "中明牙醫診所"
    },
    {
      "code" : "3701180111",
      "display" : "聯嘉牙醫診所"
    },
    {
      "code" : "3701180120",
      "display" : "慶聲牙醫診所"
    },
    {
      "code" : "3701180157",
      "display" : "俊廣牙醫診所"
    },
    {
      "code" : "3701180166",
      "display" : "華山周牙醫診所"
    },
    {
      "code" : "3701180200",
      "display" : "新光牙醫診所"
    },
    {
      "code" : "3701180237",
      "display" : "清河牙醫診所"
    },
    {
      "code" : "3701180255",
      "display" : "逢生牙醫診所"
    },
    {
      "code" : "3701180264",
      "display" : "三民牙醫診所"
    },
    {
      "code" : "3701180282",
      "display" : "名華牙醫診所"
    },
    {
      "code" : "3701180317",
      "display" : "同泰牙醫診所"
    },
    {
      "code" : "3701180344",
      "display" : "康平牙醫診所"
    },
    {
      "code" : "3701180362",
      "display" : "尚義牙醫診所"
    },
    {
      "code" : "3701180442",
      "display" : "新欣牙醫診所"
    },
    {
      "code" : "3701180460",
      "display" : "幸安牙醫診所"
    },
    {
      "code" : "3701180497",
      "display" : "鐘牙醫診所"
    },
    {
      "code" : "3701180586",
      "display" : "聯合牙醫診所"
    },
    {
      "code" : "3701180595",
      "display" : "名家牙醫診所"
    },
    {
      "code" : "3701180611",
      "display" : "志明牙醫診所"
    },
    {
      "code" : "3701180657",
      "display" : "強弘牙醫診所"
    },
    {
      "code" : "3701180684",
      "display" : "快安牙醫診所"
    },
    {
      "code" : "3701180693",
      "display" : "杏安牙醫診所"
    },
    {
      "code" : "3701180700",
      "display" : "展光牙醫診所"
    },
    {
      "code" : "3701180773",
      "display" : "金山牙醫診所"
    },
    {
      "code" : "3701180880",
      "display" : "名一牙醫診所"
    },
    {
      "code" : "3701180915",
      "display" : "蕭煥嘉牙醫診所"
    },
    {
      "code" : "3701181010",
      "display" : "連生牙醫診所"
    },
    {
      "code" : "3701181065",
      "display" : "鼎佳牙醫診所"
    },
    {
      "code" : "3701181083",
      "display" : "明皓牙醫診所"
    },
    {
      "code" : "3701181154",
      "display" : "米奇牙醫診所"
    },
    {
      "code" : "3701181163",
      "display" : "博瀚牙醫診所"
    },
    {
      "code" : "3701181172",
      "display" : "仁安牙醫診所"
    },
    {
      "code" : "3701181190",
      "display" : "英哲牙醫診所"
    },
    {
      "code" : "3701181261",
      "display" : "紐約牙醫診所"
    },
    {
      "code" : "3701181270",
      "display" : "大宇牙醫診所"
    },
    {
      "code" : "3701181305",
      "display" : "黃牙醫診所"
    },
    {
      "code" : "3701181341",
      "display" : "大埔牙醫診所"
    },
    {
      "code" : "3701181449",
      "display" : "九大牙醫診所"
    },
    {
      "code" : "3701181458",
      "display" : "天惠牙醫診所"
    },
    {
      "code" : "3701181467",
      "display" : "長弓牙醫診所"
    },
    {
      "code" : "3701181476",
      "display" : "博世牙醫診所"
    },
    {
      "code" : "3701181485",
      "display" : "玉霖牙醫診所"
    },
    {
      "code" : "3701181583",
      "display" : "博安牙醫診所"
    },
    {
      "code" : "3701181636",
      "display" : "瑞石牙醫診所"
    },
    {
      "code" : "3701181681",
      "display" : "偉華牙醫診所"
    },
    {
      "code" : "3701181725",
      "display" : "華恩牙醫診所"
    },
    {
      "code" : "3701181743",
      "display" : "口天牙醫診所"
    },
    {
      "code" : "3701181761",
      "display" : "安安牙醫診所"
    },
    {
      "code" : "3701182848",
      "display" : "慈聖牙醫診所"
    },
    {
      "code" : "3701182955",
      "display" : "大佳牙醫診所"
    },
    {
      "code" : "3701182982",
      "display" : "優登牙醫診所"
    },
    {
      "code" : "3701183005",
      "display" : "皓齒牙醫診所"
    },
    {
      "code" : "3701183032",
      "display" : "君品牙醫診所"
    },
    {
      "code" : "3701183050",
      "display" : "和逸牙醫診所"
    },
    {
      "code" : "3701183069",
      "display" : "金恩牙醫診所"
    },
    {
      "code" : "3701183112",
      "display" : "西北聯合牙醫診所"
    },
    {
      "code" : "3701183167",
      "display" : "拉圖牙醫診所"
    },
    {
      "code" : "3701183176",
      "display" : "璞鼎牙醫診所"
    },
    {
      "code" : "3701183201",
      "display" : "誠伸牙醫診所"
    },
    {
      "code" : "3701183229",
      "display" : "長齡牙醫診所"
    },
    {
      "code" : "3701183238",
      "display" : "琠雅牙醫診所"
    },
    {
      "code" : "3701183274",
      "display" : "廖春美牙醫診所"
    },
    {
      "code" : "3701183292",
      "display" : "南門牙醫診所"
    },
    {
      "code" : "3701183363",
      "display" : "典樺牙醫診所"
    },
    {
      "code" : "3701183390",
      "display" : "清川牙醫診所"
    },
    {
      "code" : "3701183407",
      "display" : "橙品牙醫診所"
    },
    {
      "code" : "3701183425",
      "display" : "富麗牙醫診所"
    },
    {
      "code" : "3701183443",
      "display" : "德華牙醫診所"
    },
    {
      "code" : "3701183452",
      "display" : "謝明吉口腔顎面外科牙醫診所"
    },
    {
      "code" : "3701183461",
      "display" : "雙子星牙醫診所"
    },
    {
      "code" : "3701183470",
      "display" : "啟琮牙醫診所"
    },
    {
      "code" : "3701183489",
      "display" : "品瑞牙醫診所"
    },
    {
      "code" : "3701183505",
      "display" : "信義東暘牙醫診所"
    },
    {
      "code" : "3701183514",
      "display" : "新芽牙醫診所"
    },
    {
      "code" : "3701183532",
      "display" : "雅偲牙醫診所"
    },
    {
      "code" : "3701183541",
      "display" : "愛迪牙醫診所"
    },
    {
      "code" : "3701183569",
      "display" : "東門牙醫診所"
    },
    {
      "code" : "3701183578",
      "display" : "蘇黎世牙醫診所"
    },
    {
      "code" : "3701183596",
      "display" : "典雅牙醫診所"
    },
    {
      "code" : "3701183603",
      "display" : "氧樂多牙醫診所"
    },
    {
      "code" : "3701183621",
      "display" : "齊杏齒顎矯正專科牙醫診所"
    },
    {
      "code" : "3701183630",
      "display" : "華泰牙醫診所"
    },
    {
      "code" : "3701183649",
      "display" : "公園景福牙醫診所"
    },
    {
      "code" : "3701183658",
      "display" : "齊美牙醫診所"
    },
    {
      "code" : "3701183667",
      "display" : "美國傳奇牙醫診所"
    },
    {
      "code" : "3701183676",
      "display" : "怡樺牙醫診所"
    },
    {
      "code" : "3701183685",
      "display" : "維昕牙醫診所"
    },
    {
      "code" : "3701183694",
      "display" : "合睿牙醫診所"
    },
    {
      "code" : "3701183701",
      "display" : "林志聲牙醫診所"
    },
    {
      "code" : "3701183738",
      "display" : "美日牙醫診所"
    },
    {
      "code" : "3701183747",
      "display" : "永恆牙醫診所"
    },
    {
      "code" : "3701183756",
      "display" : "博齡牙醫診所"
    },
    {
      "code" : "3701183765",
      "display" : "仁崇牙醫診所"
    },
    {
      "code" : "3701183774",
      "display" : "師院牙醫診所"
    },
    {
      "code" : "3701183783",
      "display" : "怡賀牙醫診所"
    },
    {
      "code" : "3701183792",
      "display" : "華慶牙醫診所"
    },
    {
      "code" : "3701183809",
      "display" : "慶輝牙醫診所"
    },
    {
      "code" : "3701183818",
      "display" : "嘉貝牙醫診所"
    },
    {
      "code" : "3701183827",
      "display" : "東北大牙醫診所"
    },
    {
      "code" : "3701183836",
      "display" : "家禾牙醫診所"
    },
    {
      "code" : "3701183845",
      "display" : "雅德思牙醫診所"
    },
    {
      "code" : "3701183854",
      "display" : "良鑫牙醫診所"
    },
    {
      "code" : "3701183863",
      "display" : "優政牙醫診所"
    },
    {
      "code" : "3701183872",
      "display" : "喜樂牙醫診所"
    },
    {
      "code" : "3701183916",
      "display" : "晨新牙醫診所"
    },
    {
      "code" : "3701183925",
      "display" : "星采牙醫診所"
    },
    {
      "code" : "3701183934",
      "display" : "星創牙醫診所"
    },
    {
      "code" : "3701183943",
      "display" : "仁崇牙醫診所"
    },
    {
      "code" : "3701183952",
      "display" : "合睿牙醫診所"
    },
    {
      "code" : "3701183961",
      "display" : "仁崇牙醫診所"
    },
    {
      "code" : "3701183970",
      "display" : "沐康美學牙醫診所"
    },
    {
      "code" : "3701183989",
      "display" : "雅德思牙醫診所"
    },
    {
      "code" : "3701183998",
      "display" : "百分百牙醫診所"
    },
    {
      "code" : "3701184002",
      "display" : "涵悅牙醫診所"
    },
    {
      "code" : "3701184011",
      "display" : "仁愛牙醫診所"
    },
    {
      "code" : "3701184020",
      "display" : "華山蒔美牙醫診所"
    },
    {
      "code" : "3701184039",
      "display" : "金山蒔美牙醫診所"
    },
    {
      "code" : "3701184048",
      "display" : "喜樂新生牙醫診所"
    },
    {
      "code" : "3701184057",
      "display" : "蒔穗美學牙醫診所"
    },
    {
      "code" : "3701184066",
      "display" : "北歐贋復補綴牙科專科牙醫診所"
    },
    {
      "code" : "3701184075",
      "display" : "仁愛牙醫診所"
    },
    {
      "code" : "3701184084",
      "display" : "雅德思牙醫診所"
    },
    {
      "code" : "3701184093",
      "display" : "西北聯合牙醫診所"
    },
    {
      "code" : "3701184119",
      "display" : "南門牙醫診所"
    },
    {
      "code" : "3701190028",
      "display" : "水波牙醫診所"
    },
    {
      "code" : "3701190082",
      "display" : "高一牙醫診所"
    },
    {
      "code" : "3701190108",
      "display" : "再欣牙醫診所"
    },
    {
      "code" : "3701190117",
      "display" : "文林牙醫診所"
    },
    {
      "code" : "3701190135",
      "display" : "孝忠牙醫診所"
    },
    {
      "code" : "3701190153",
      "display" : "進安牙醫診所"
    },
    {
      "code" : "3701190215",
      "display" : "永亨牙醫診所"
    },
    {
      "code" : "3701190251",
      "display" : "南光牙醫診所"
    },
    {
      "code" : "3701190260",
      "display" : "弘旭牙醫診所"
    },
    {
      "code" : "3701190279",
      "display" : "信恩牙醫診所"
    },
    {
      "code" : "3701190359",
      "display" : "潘再榮牙醫診所"
    },
    {
      "code" : "3701190377",
      "display" : "如春牙醫診所"
    },
    {
      "code" : "3701190386",
      "display" : "桂林牙醫診所"
    },
    {
      "code" : "3701190395",
      "display" : "世欣牙醫診所"
    },
    {
      "code" : "3701190402",
      "display" : "正一牙醫診所"
    },
    {
      "code" : "3701190411",
      "display" : "蕭輝隆牙醫診所"
    },
    {
      "code" : "3701190466",
      "display" : "邦安牙醫診所"
    },
    {
      "code" : "3701190475",
      "display" : "周建堂牙醫診所"
    },
    {
      "code" : "3701190484",
      "display" : "敦祥牙醫診所"
    },
    {
      "code" : "3701190500",
      "display" : "明誌牙醫診所"
    },
    {
      "code" : "3701190528",
      "display" : "佳新牙醫診所"
    },
    {
      "code" : "3701190537",
      "display" : "林民健牙醫診所"
    },
    {
      "code" : "3701190555",
      "display" : "青年牙醫診所"
    },
    {
      "code" : "3701190564",
      "display" : "天一牙醫診所"
    },
    {
      "code" : "3701190573",
      "display" : "仁真牙醫診所"
    },
    {
      "code" : "3701190591",
      "display" : "孝德牙醫診所"
    },
    {
      "code" : "3701190680",
      "display" : "張建昌牙醫診所"
    },
    {
      "code" : "3701190715",
      "display" : "國民牙醫診所"
    },
    {
      "code" : "3701190724",
      "display" : "寶健牙醫診所"
    },
    {
      "code" : "3701190742",
      "display" : "惠德牙醫診所"
    },
    {
      "code" : "3701190760",
      "display" : "宏德牙醫診所"
    },
    {
      "code" : "3701190779",
      "display" : "三福牙醫診所"
    },
    {
      "code" : "3701190840",
      "display" : "同仁牙醫診所"
    },
    {
      "code" : "3701190868",
      "display" : "鑫慧牙醫診所"
    },
    {
      "code" : "3701192059",
      "display" : "保誠牙醫診所"
    },
    {
      "code" : "3701192068",
      "display" : "白牙醫診所"
    },
    {
      "code" : "3701192077",
      "display" : "信華牙醫診所"
    },
    {
      "code" : "3701192086",
      "display" : "信元牙醫診所"
    },
    {
      "code" : "3701192095",
      "display" : "台新園牙醫診所"
    },
    {
      "code" : "3701192102",
      "display" : "艋舺牙醫診所"
    },
    {
      "code" : "3701192193",
      "display" : "欣揚牙醫診所"
    },
    {
      "code" : "3701192291",
      "display" : "正弘牙醫診所"
    },
    {
      "code" : "3701192308",
      "display" : "植美牙醫診所"
    },
    {
      "code" : "3701192326",
      "display" : "仁康牙醫診所"
    },
    {
      "code" : "3701192344",
      "display" : "典華牙醫診所"
    },
    {
      "code" : "3701192362",
      "display" : "萬大牙醫診所"
    },
    {
      "code" : "3701192371",
      "display" : "德泰牙醫診所"
    },
    {
      "code" : "3701192380",
      "display" : "雲品牙醫診所"
    },
    {
      "code" : "3701192399",
      "display" : "尚潔牙醫診所"
    },
    {
      "code" : "3701192415",
      "display" : "立誠牙醫診所"
    },
    {
      "code" : "3701192424",
      "display" : "立新口腔顎面外科牙醫診所"
    },
    {
      "code" : "3701192451",
      "display" : "大久美學牙醫診所"
    },
    {
      "code" : "3701192460",
      "display" : "福華美學牙醫診所"
    },
    {
      "code" : "3701192479",
      "display" : "雅意牙醫診所"
    },
    {
      "code" : "3701192488",
      "display" : "萬華賴牙醫診所"
    },
    {
      "code" : "3701192497",
      "display" : "爵華牙醫診所"
    },
    {
      "code" : "3701192504",
      "display" : "雅毓牙醫診所"
    },
    {
      "code" : "3701192513",
      "display" : "嘉樂美學牙醫診所"
    },
    {
      "code" : "3701192531",
      "display" : "北極星牙醫診所"
    },
    {
      "code" : "3701192540",
      "display" : "台新美學牙醫診所"
    },
    {
      "code" : "3701192559",
      "display" : "旭日牙醫診所"
    },
    {
      "code" : "3701192568",
      "display" : "仁真牙醫診所"
    },
    {
      "code" : "3701192586",
      "display" : "久久牙醫診所"
    },
    {
      "code" : "3701192595",
      "display" : "日森牙醫診所"
    },
    {
      "code" : "3701192602",
      "display" : "嘉樂美學牙醫診所"
    },
    {
      "code" : "3701192611",
      "display" : "信元優質牙醫診所"
    },
    {
      "code" : "3701200010",
      "display" : "實踐牙醫診所"
    },
    {
      "code" : "3701200047",
      "display" : "慶聯牙醫診所"
    },
    {
      "code" : "3701200092",
      "display" : "北持牙醫診所"
    },
    {
      "code" : "3701200109",
      "display" : "德佳牙醫診所"
    },
    {
      "code" : "3701200154",
      "display" : "大木柵陳牙醫診所"
    },
    {
      "code" : "3701200172",
      "display" : "寶島牙醫診所"
    },
    {
      "code" : "3701200207",
      "display" : "忠順牙醫診所"
    },
    {
      "code" : "3701200225",
      "display" : "木新牙醫診所"
    },
    {
      "code" : "3701200289",
      "display" : "新同仁牙醫診所"
    },
    {
      "code" : "3701200314",
      "display" : "杏昌牙醫診所"
    },
    {
      "code" : "3701200378",
      "display" : "德全牙醫診所"
    },
    {
      "code" : "3701200387",
      "display" : "協和牙醫診所"
    },
    {
      "code" : "3701200449",
      "display" : "仁泰牙醫診所"
    },
    {
      "code" : "3701200539",
      "display" : "正勳牙醫診所"
    },
    {
      "code" : "3701200547",
      "display" : "台欣牙醫診所"
    },
    {
      "code" : "3701200574",
      "display" : "西安牙醫診所"
    },
    {
      "code" : "3701200609",
      "display" : "新典牙醫診所"
    },
    {
      "code" : "3701200636",
      "display" : "精英牙醫診所"
    },
    {
      "code" : "3701200645",
      "display" : "頌恩牙醫診所"
    },
    {
      "code" : "3701200716",
      "display" : "永健牙醫診所"
    },
    {
      "code" : "3701200734",
      "display" : "詹牙醫診所"
    },
    {
      "code" : "3701200770",
      "display" : "力行牙醫診所"
    },
    {
      "code" : "3701200789",
      "display" : "文山牙醫診所"
    },
    {
      "code" : "3701200814",
      "display" : "天丞牙醫診所"
    },
    {
      "code" : "3701200878",
      "display" : "景華牙醫診所"
    },
    {
      "code" : "3701200887",
      "display" : "樸園牙醫診所"
    },
    {
      "code" : "3701200896",
      "display" : "陳世傑牙醫診所"
    },
    {
      "code" : "3701200903",
      "display" : "西歐牙醫診所"
    },
    {
      "code" : "3701200912",
      "display" : "新安牙醫診所"
    },
    {
      "code" : "3701200921",
      "display" : "協群牙醫診所"
    },
    {
      "code" : "3701200949",
      "display" : "雅田牙醫診所"
    },
    {
      "code" : "3701200958",
      "display" : "人本家庭牙醫診所"
    },
    {
      "code" : "3701200976",
      "display" : "家家牙醫診所"
    },
    {
      "code" : "3701200985",
      "display" : "建宏牙醫診所"
    },
    {
      "code" : "3701201008",
      "display" : "威登牙醫診所"
    },
    {
      "code" : "3701201026",
      "display" : "康翔牙醫診所"
    },
    {
      "code" : "3701201062",
      "display" : "怡佳牙醫診所"
    },
    {
      "code" : "3701201080",
      "display" : "晶品牙醫診所"
    },
    {
      "code" : "3701201099",
      "display" : "大中牙醫診所"
    },
    {
      "code" : "3701201115",
      "display" : "驊陽牙醫診所"
    },
    {
      "code" : "3701201124",
      "display" : "全家牙醫診所"
    },
    {
      "code" : "3701202130",
      "display" : "安薪牙醫診所"
    },
    {
      "code" : "3701202149",
      "display" : "敦揚牙醫診所"
    },
    {
      "code" : "3701202176",
      "display" : "堤岸牙醫診所"
    },
    {
      "code" : "3701202194",
      "display" : "信和牙醫診所"
    },
    {
      "code" : "3701202201",
      "display" : "德在牙醫診所"
    },
    {
      "code" : "3701202238",
      "display" : "德威牙醫診所"
    },
    {
      "code" : "3701202265",
      "display" : "福祥牙醫診所"
    },
    {
      "code" : "3701202274",
      "display" : "亞美光聯合牙醫診所"
    },
    {
      "code" : "3701202309",
      "display" : "一心牙醫診所"
    },
    {
      "code" : "3701202336",
      "display" : "生活牙醫診所"
    },
    {
      "code" : "3701202345",
      "display" : "喬齡牙醫診所"
    },
    {
      "code" : "3701202354",
      "display" : "維新牙醫診所"
    },
    {
      "code" : "3701202363",
      "display" : "景美喜信牙醫診所"
    },
    {
      "code" : "3701202381",
      "display" : "廣泉牙醫診所"
    },
    {
      "code" : "3701202407",
      "display" : "昱翔牙醫診所"
    },
    {
      "code" : "3701202425",
      "display" : "多美牙醫診所"
    },
    {
      "code" : "3701202470",
      "display" : "品橙牙醫診所"
    },
    {
      "code" : "3701202489",
      "display" : "景美陳牙醫診所"
    },
    {
      "code" : "3701202498",
      "display" : "家樂牙醫診所"
    },
    {
      "code" : "3701202505",
      "display" : "格林牙醫診所"
    },
    {
      "code" : "3701202514",
      "display" : "臻美牙醫診所"
    },
    {
      "code" : "3701202523",
      "display" : "欣美牙醫診所"
    },
    {
      "code" : "3701202532",
      "display" : "正大牙醫診所"
    },
    {
      "code" : "3701202541",
      "display" : "木柵１０１牙醫診所"
    },
    {
      "code" : "3701202550",
      "display" : "唯芯牙醫診所"
    },
    {
      "code" : "3701202578",
      "display" : "叁代牙醫診所"
    },
    {
      "code" : "3701202587",
      "display" : "瑞雲牙醫診所"
    },
    {
      "code" : "3701202596",
      "display" : "永麗牙醫診所"
    },
    {
      "code" : "3701202603",
      "display" : "誠一牙醫診所"
    },
    {
      "code" : "3701202612",
      "display" : "吉品牙醫診所"
    },
    {
      "code" : "3701202630",
      "display" : "美學辰安牙醫診所"
    },
    {
      "code" : "3701202658",
      "display" : "童元釔齒顎矯正專科牙醫診所"
    },
    {
      "code" : "3701202667",
      "display" : "沐芯牙醫診所"
    },
    {
      "code" : "3701202676",
      "display" : "睿安牙醫診所"
    },
    {
      "code" : "3701202685",
      "display" : "羅斯福臻美牙醫診所"
    },
    {
      "code" : "3701202694",
      "display" : "童芯牙醫診所"
    },
    {
      "code" : "3701202701",
      "display" : "心田美學牙醫診所"
    },
    {
      "code" : "3701202710",
      "display" : "采新牙醫診所"
    },
    {
      "code" : "3701202729",
      "display" : "吉品牙醫診所"
    },
    {
      "code" : "3701202738",
      "display" : "雅興牙醫診所"
    },
    {
      "code" : "3701202747",
      "display" : "洵美牙醫診所"
    },
    {
      "code" : "3701202756",
      "display" : "吉品牙醫診所"
    },
    {
      "code" : "3701202765",
      "display" : "靜心芙荃牙醫診所"
    },
    {
      "code" : "3701202774",
      "display" : "綵登美學牙醫診所"
    },
    {
      "code" : "3701202783",
      "display" : "慕美牙醫診所"
    },
    {
      "code" : "3711010037",
      "display" : "謝牙醫診所"
    },
    {
      "code" : "3711010055",
      "display" : "蘇牙醫診所"
    },
    {
      "code" : "3711010064",
      "display" : "資生堂牙醫診所"
    },
    {
      "code" : "3711010091",
      "display" : "勝斌牙醫診所"
    },
    {
      "code" : "3711010108",
      "display" : "新雅牙醫診所"
    },
    {
      "code" : "3711010144",
      "display" : "達美牙醫診所"
    },
    {
      "code" : "3711010171",
      "display" : "佳暉牙醫診所"
    },
    {
      "code" : "3711010199",
      "display" : "新光牙醫診所"
    },
    {
      "code" : "3711011267",
      "display" : "鼎泰牙醫診所"
    },
    {
      "code" : "3711011285",
      "display" : "新豐牙醫診所"
    },
    {
      "code" : "3711011301",
      "display" : "天工牙醫診所"
    },
    {
      "code" : "3711011310",
      "display" : "祥豐牙醫診所"
    },
    {
      "code" : "3711011338",
      "display" : "藝美牙醫診所"
    },
    {
      "code" : "3711011347",
      "display" : "澄星牙醫診所"
    },
    {
      "code" : "3711011356",
      "display" : "雅德思牙醫診所"
    },
    {
      "code" : "3711020015",
      "display" : "維康牙醫診所"
    },
    {
      "code" : "3711020033",
      "display" : "永生牙醫診所"
    },
    {
      "code" : "3711020060",
      "display" : "永全牙醫診所"
    },
    {
      "code" : "3711020104",
      "display" : "華仁牙醫診所"
    },
    {
      "code" : "3711020131",
      "display" : "百福牙醫診所"
    },
    {
      "code" : "3711021174",
      "display" : "立仁牙醫診所"
    },
    {
      "code" : "3711021192",
      "display" : "宏大牙醫診所"
    },
    {
      "code" : "3711021209",
      "display" : "晶采美學牙醫診所"
    },
    {
      "code" : "3711021227",
      "display" : "尊悅牙醫診所"
    },
    {
      "code" : "3711021236",
      "display" : "凱悅牙醫診所"
    },
    {
      "code" : "3711021245",
      "display" : "涵悅顯微牙醫診所"
    },
    {
      "code" : "3711021254",
      "display" : "萬福牙醫診所"
    },
    {
      "code" : "3711021263",
      "display" : "涵悅美學牙醫診所"
    },
    {
      "code" : "3711021272",
      "display" : "永全牙醫診所"
    },
    {
      "code" : "3711030011",
      "display" : "長春牙醫診所"
    },
    {
      "code" : "3711031063",
      "display" : "正榮牙醫診所"
    },
    {
      "code" : "3711031072",
      "display" : "永安牙醫診所"
    },
    {
      "code" : "3711031090",
      "display" : "源遠牙醫診所"
    },
    {
      "code" : "3711031107",
      "display" : "潔安牙醫"
    },
    {
      "code" : "3711031116",
      "display" : "微風牙醫診所"
    },
    {
      "code" : "3711031125",
      "display" : "柏悅牙醫診所"
    },
    {
      "code" : "3711031134",
      "display" : "青森牙醫診所"
    },
    {
      "code" : "3711040026",
      "display" : "永年牙醫診所"
    },
    {
      "code" : "3711040071",
      "display" : "長壽牙醫診所"
    },
    {
      "code" : "3711040099",
      "display" : "安生牙醫診所"
    },
    {
      "code" : "3711040142",
      "display" : "英哲牙醫診所"
    },
    {
      "code" : "3711040151",
      "display" : "良仁牙醫診所"
    },
    {
      "code" : "3711040204",
      "display" : "陽明牙醫診所"
    },
    {
      "code" : "3711040231",
      "display" : "柏齡牙醫診所"
    },
    {
      "code" : "3711040259",
      "display" : "安泰牙醫診所"
    },
    {
      "code" : "3711040268",
      "display" : "趙牙醫診所"
    },
    {
      "code" : "3711040311",
      "display" : "蔡志明牙醫診所"
    },
    {
      "code" : "3711040357",
      "display" : "超群牙醫診所"
    },
    {
      "code" : "3711040366",
      "display" : "曜聖牙醫診所"
    },
    {
      "code" : "3711041416",
      "display" : "滕起民牙醫診所"
    },
    {
      "code" : "3711041425",
      "display" : "駱明德牙醫診所"
    },
    {
      "code" : "3711041434",
      "display" : "國泰牙醫診所"
    },
    {
      "code" : "3711041443",
      "display" : "承成牙醫診所"
    },
    {
      "code" : "3711041452",
      "display" : "光華牙醫診所"
    },
    {
      "code" : "3711041489",
      "display" : "成美牙醫診所"
    },
    {
      "code" : "3711041498",
      "display" : "其筠牙醫診所"
    },
    {
      "code" : "3711041523",
      "display" : "經典牙醫診所"
    },
    {
      "code" : "3711041550",
      "display" : "楨品美學牙醫診所"
    },
    {
      "code" : "3711041569",
      "display" : "貝陽兒童牙醫診所"
    },
    {
      "code" : "3711041587",
      "display" : "品馨牙醫診所"
    },
    {
      "code" : "3711041596",
      "display" : "台北大鎮健康牙醫診所"
    },
    {
      "code" : "3711041603",
      "display" : "君悅牙醫診所"
    },
    {
      "code" : "3711041612",
      "display" : "麗星美學牙醫診所"
    },
    {
      "code" : "3711041630",
      "display" : "一日尊榮牙醫診所"
    },
    {
      "code" : "3711050013",
      "display" : "日榮牙醫診所"
    },
    {
      "code" : "3711050040",
      "display" : "北大牙醫診所"
    },
    {
      "code" : "3711050059",
      "display" : "協和牙醫診所"
    },
    {
      "code" : "3711050095",
      "display" : "許牙醫診所"
    },
    {
      "code" : "3711050102",
      "display" : "隆源牙醫診所"
    },
    {
      "code" : "3711050111",
      "display" : "德和牙醫診所"
    },
    {
      "code" : "3711050120",
      "display" : "中山牙醫診所"
    },
    {
      "code" : "3711050148",
      "display" : "展望牙醫診所"
    },
    {
      "code" : "3711050166",
      "display" : "金華牙醫診所"
    },
    {
      "code" : "3711050175",
      "display" : "永吉牙醫診所"
    },
    {
      "code" : "3711051190",
      "display" : "李台光牙醫診所"
    },
    {
      "code" : "3711051261",
      "display" : "禾安牙醫診所"
    },
    {
      "code" : "3711051270",
      "display" : "柏泰牙醫診所"
    },
    {
      "code" : "3711051289",
      "display" : "海悅牙醫診所"
    },
    {
      "code" : "3711060037",
      "display" : "光民牙醫診所"
    },
    {
      "code" : "3711060082",
      "display" : "立安牙醫診所"
    },
    {
      "code" : "3711060108",
      "display" : "宏福牙醫診所"
    },
    {
      "code" : "3711060153",
      "display" : "武嶺牙醫診所"
    },
    {
      "code" : "3711060162",
      "display" : "欣隆牙醫診所"
    },
    {
      "code" : "3711060171",
      "display" : "亞德牙醫診所"
    },
    {
      "code" : "3711061187",
      "display" : "健翔牙醫診所"
    },
    {
      "code" : "3711061203",
      "display" : "安信牙醫診所"
    },
    {
      "code" : "3711061221",
      "display" : "悅來牙醫診所"
    },
    {
      "code" : "3711061230",
      "display" : "欣城牙醫診所"
    },
    {
      "code" : "3711061249",
      "display" : "潔心牙醫診所"
    },
    {
      "code" : "3711061258",
      "display" : "馨晴牙醫診所"
    },
    {
      "code" : "3711061267",
      "display" : "愛沐牙醫診所"
    },
    {
      "code" : "3711061276",
      "display" : "夢悅美學牙醫診所"
    },
    {
      "code" : "3711061285",
      "display" : "星尚牙醫診所"
    },
    {
      "code" : "3711061294",
      "display" : "國華牙醫診所"
    },
    {
      "code" : "3711070122",
      "display" : "新大牙醫診所"
    },
    {
      "code" : "3711070159",
      "display" : "優美牙醫診所"
    },
    {
      "code" : "3711070168",
      "display" : "金石牙醫診所"
    },
    {
      "code" : "3711070177",
      "display" : "楊宗源牙醫診所"
    },
    {
      "code" : "3711071209",
      "display" : "一品牙醫診所"
    },
    {
      "code" : "3711071218",
      "display" : "仁心牙醫診所"
    },
    {
      "code" : "3711071227",
      "display" : "中華牙醫診所"
    },
    {
      "code" : "3711071236",
      "display" : "德安牙醫診所"
    },
    {
      "code" : "3711071245",
      "display" : "兆康牙醫診所"
    },
    {
      "code" : "3711071254",
      "display" : "臺大牙醫診所"
    },
    {
      "code" : "3711071263",
      "display" : "金聲牙醫診所"
    },
    {
      "code" : "3711071281",
      "display" : "元璞牙醫診所"
    },
    {
      "code" : "3711071290",
      "display" : "御鈿牙醫診所"
    },
    {
      "code" : "3731010015",
      "display" : "華美牙醫診所"
    },
    {
      "code" : "3731010051",
      "display" : "府中牙醫診所"
    },
    {
      "code" : "3731010060",
      "display" : "廖牙醫診所"
    },
    {
      "code" : "3731010097",
      "display" : "瑞億牙醫診所"
    },
    {
      "code" : "3731010104",
      "display" : "民川牙醫診所"
    },
    {
      "code" : "3731010113",
      "display" : "蔡牙醫診所"
    },
    {
      "code" : "3731010140",
      "display" : "子欽牙醫診所"
    },
    {
      "code" : "3731010177",
      "display" : "泰民牙醫診所"
    },
    {
      "code" : "3731010186",
      "display" : "鴻元牙醫診所"
    },
    {
      "code" : "3731010195",
      "display" : "辭林牙醫診所"
    },
    {
      "code" : "3731010202",
      "display" : "元齡牙醫診所"
    },
    {
      "code" : "3731010211",
      "display" : "偉仁牙醫診所"
    },
    {
      "code" : "3731010220",
      "display" : "胡牙醫診所"
    },
    {
      "code" : "3731010239",
      "display" : "後站徐牙醫診所"
    },
    {
      "code" : "3731010248",
      "display" : "光仁牙醫診所"
    },
    {
      "code" : "3731010257",
      "display" : "上揚牙醫診所"
    },
    {
      "code" : "3731010266",
      "display" : "板橋林牙醫診所"
    },
    {
      "code" : "3731010284",
      "display" : "揚名牙醫診所"
    },
    {
      "code" : "3731010300",
      "display" : "潘牙醫診所"
    },
    {
      "code" : "3731010328",
      "display" : "大林牙醫診所"
    },
    {
      "code" : "3731010337",
      "display" : "麗德牙醫診所"
    },
    {
      "code" : "3731010346",
      "display" : "中心牙醫診所"
    },
    {
      "code" : "3731010364",
      "display" : "正昌牙醫診所"
    },
    {
      "code" : "3731010373",
      "display" : "博仁牙醫診所"
    },
    {
      "code" : "3731010382",
      "display" : "頂好牙醫診所"
    },
    {
      "code" : "3731010408",
      "display" : "益新牙醫診所"
    },
    {
      "code" : "3731010435",
      "display" : "章牙醫診所"
    },
    {
      "code" : "3731010444",
      "display" : "福倫牙醫診所"
    },
    {
      "code" : "3731010480",
      "display" : "今日牙醫診所"
    },
    {
      "code" : "3731010515",
      "display" : "安信牙醫診所"
    },
    {
      "code" : "3731010551",
      "display" : "簡牙醫診所"
    },
    {
      "code" : "3731010560",
      "display" : "兆祥牙醫診所"
    },
    {
      "code" : "3731010604",
      "display" : "德聲牙醫診所"
    },
    {
      "code" : "3731010622",
      "display" : "玉山牙醫診所"
    },
    {
      "code" : "3731010659",
      "display" : "慶安牙醫診所"
    },
    {
      "code" : "3731010668",
      "display" : "培源牙醫診所"
    },
    {
      "code" : "3731010702",
      "display" : "吉祥牙醫診所"
    },
    {
      "code" : "3731010739",
      "display" : "雙安牙醫診所"
    },
    {
      "code" : "3731010748",
      "display" : "寰宇牙醫診所"
    },
    {
      "code" : "3731010757",
      "display" : "江子翠林牙醫診所"
    },
    {
      "code" : "3731010800",
      "display" : "鴻安牙醫診所"
    },
    {
      "code" : "3731010819",
      "display" : "智中牙醫診所"
    },
    {
      "code" : "3731010828",
      "display" : "呂忠孝牙醫診所"
    },
    {
      "code" : "3731010837",
      "display" : "遠東牙醫診所"
    },
    {
      "code" : "3731010846",
      "display" : "建國牙醫診所"
    },
    {
      "code" : "3731010926",
      "display" : "智群牙醫診所"
    },
    {
      "code" : "3731010944",
      "display" : "卓群牙醫診所"
    },
    {
      "code" : "3731010953",
      "display" : "揚齡牙醫診所"
    },
    {
      "code" : "3731011067",
      "display" : "瑞安牙醫診所"
    },
    {
      "code" : "3731011076",
      "display" : "大學牙醫診所"
    },
    {
      "code" : "3731011094",
      "display" : "偉新牙醫診所"
    },
    {
      "code" : "3731011110",
      "display" : "天下牙醫診所"
    },
    {
      "code" : "3731011174",
      "display" : "聖潔牙醫診所"
    },
    {
      "code" : "3731011218",
      "display" : "海山牙醫聯合診所"
    },
    {
      "code" : "3731011254",
      "display" : "浩恩牙醫診所"
    },
    {
      "code" : "3731011316",
      "display" : "益群牙醫診所"
    },
    {
      "code" : "3731011343",
      "display" : "仁宏牙醫診所"
    },
    {
      "code" : "3731011352",
      "display" : "大觀牙醫診所"
    },
    {
      "code" : "3731011414",
      "display" : "勇年牙醫診所"
    },
    {
      "code" : "3731011423",
      "display" : "陽信牙醫診所"
    },
    {
      "code" : "3731011549",
      "display" : "台笙牙醫診所"
    },
    {
      "code" : "3731011558",
      "display" : "重慶牙醫診所"
    },
    {
      "code" : "3731011576",
      "display" : "良鴻牙醫診所"
    },
    {
      "code" : "3731011585",
      "display" : "浩明牙醫診所"
    },
    {
      "code" : "3731011629",
      "display" : "健和牙醫診所"
    },
    {
      "code" : "3731011638",
      "display" : "翰生牙醫診所"
    },
    {
      "code" : "3731011665",
      "display" : "惠康牙醫診所"
    },
    {
      "code" : "3731011718",
      "display" : "健倫牙醫診所"
    },
    {
      "code" : "3731011727",
      "display" : "法華牙醫診所"
    },
    {
      "code" : "3731011745",
      "display" : "吳國柱牙醫診所"
    },
    {
      "code" : "3731011816",
      "display" : "康喬牙醫診所"
    },
    {
      "code" : "3731011834",
      "display" : "東北牙醫診所"
    },
    {
      "code" : "3731011852",
      "display" : "展望牙醫診所"
    },
    {
      "code" : "3731011941",
      "display" : "育德牙醫診所"
    },
    {
      "code" : "3731011950",
      "display" : "時代牙醫診所"
    },
    {
      "code" : "3731012037",
      "display" : "時尚牙醫診所"
    },
    {
      "code" : "3731012126",
      "display" : "民懷牙醫診所"
    },
    {
      "code" : "3731012153",
      "display" : "全安牙醫診所"
    },
    {
      "code" : "3731012162",
      "display" : "松柏牙醫診所"
    },
    {
      "code" : "3731012171",
      "display" : "太平洋牙醫診所"
    },
    {
      "code" : "3731012206",
      "display" : "新品牙醫診所"
    },
    {
      "code" : "3731012215",
      "display" : "新安牙醫診所"
    },
    {
      "code" : "3731012251",
      "display" : "喜樂牙醫診所"
    },
    {
      "code" : "3731012260",
      "display" : "國新德威牙醫診所"
    },
    {
      "code" : "3731012304",
      "display" : "誼康美學牙醫診所"
    },
    {
      "code" : "3731013338",
      "display" : "南雅牙醫診所"
    },
    {
      "code" : "3731013347",
      "display" : "立潔牙醫診所"
    },
    {
      "code" : "3731013365",
      "display" : "誠信牙醫診所"
    },
    {
      "code" : "3731013392",
      "display" : "板橋現代牙醫診所"
    },
    {
      "code" : "3731013418",
      "display" : "佳園牙醫診所"
    },
    {
      "code" : "3731013490",
      "display" : "懷安牙醫診所"
    },
    {
      "code" : "3731013525",
      "display" : "邱慶來牙醫診所"
    },
    {
      "code" : "3731013552",
      "display" : "昱盛牙醫診所"
    },
    {
      "code" : "3731013589",
      "display" : "忠丞牙醫診所"
    },
    {
      "code" : "3731013614",
      "display" : "晶美牙醫診所"
    },
    {
      "code" : "3731013669",
      "display" : "振榮牙醫診所"
    },
    {
      "code" : "3731013678",
      "display" : "家德牙醫診所"
    },
    {
      "code" : "3731013687",
      "display" : "惟美牙醫診所"
    },
    {
      "code" : "3731013696",
      "display" : "晴天牙醫診所"
    },
    {
      "code" : "3731013703",
      "display" : "薪馨牙醫診所"
    },
    {
      "code" : "3731013712",
      "display" : "板橋誠品牙醫診所"
    },
    {
      "code" : "3731013758",
      "display" : "聖恩牙醫診所"
    },
    {
      "code" : "3731013776",
      "display" : "德崴聯合牙醫診所"
    },
    {
      "code" : "3731013801",
      "display" : "菁樺牙醫診所"
    },
    {
      "code" : "3731013829",
      "display" : "岳德聯合牙醫診所"
    },
    {
      "code" : "3731013838",
      "display" : "大立牙醫診所"
    },
    {
      "code" : "3731013847",
      "display" : "正欣牙醫診所"
    },
    {
      "code" : "3731013856",
      "display" : "盈仁牙醫診所"
    },
    {
      "code" : "3731013874",
      "display" : "馬太牙醫診所"
    },
    {
      "code" : "3731013909",
      "display" : "安和牙醫診所"
    },
    {
      "code" : "3731013936",
      "display" : "匯通牙醫診所"
    },
    {
      "code" : "3731013963",
      "display" : "德全牙醫診所"
    },
    {
      "code" : "3731013981",
      "display" : "軒品牙醫診所"
    },
    {
      "code" : "3731013990",
      "display" : "台達牙醫診所"
    },
    {
      "code" : "3731014013",
      "display" : "潔品牙醫聯合診所"
    },
    {
      "code" : "3731014031",
      "display" : "東華牙醫診所"
    },
    {
      "code" : "3731014059",
      "display" : "正安牙醫診所"
    },
    {
      "code" : "3731014068",
      "display" : "日麗牙醫診所"
    },
    {
      "code" : "3731014077",
      "display" : "新埔牙醫診所"
    },
    {
      "code" : "3731014111",
      "display" : "冠德牙醫診所"
    },
    {
      "code" : "3731014120",
      "display" : "京品牙醫診所"
    },
    {
      "code" : "3731014148",
      "display" : "嘉呈牙醫診所"
    },
    {
      "code" : "3731014157",
      "display" : "得雅牙醫診所"
    },
    {
      "code" : "3731014228",
      "display" : "東暘牙醫診所"
    },
    {
      "code" : "3731014237",
      "display" : "晨軒牙醫診所"
    },
    {
      "code" : "3731014255",
      "display" : "貴興牙醫診所"
    },
    {
      "code" : "3731014264",
      "display" : "合美牙醫診所"
    },
    {
      "code" : "3731014282",
      "display" : "杏橋牙醫診所"
    },
    {
      "code" : "3731014291",
      "display" : "康祐牙醫診所"
    },
    {
      "code" : "3731014308",
      "display" : "大原牙醫診所"
    },
    {
      "code" : "3731014335",
      "display" : "喆品牙醫診所"
    },
    {
      "code" : "3731014344",
      "display" : "恩美牙醫診所"
    },
    {
      "code" : "3731014371",
      "display" : "宜聖牙醫診所"
    },
    {
      "code" : "3731014380",
      "display" : "舒活牙醫診所"
    },
    {
      "code" : "3731014399",
      "display" : "辰宏牙醫診所"
    },
    {
      "code" : "3731014406",
      "display" : "長殷牙醫診所"
    },
    {
      "code" : "3731014433",
      "display" : "杏福牙醫診所"
    },
    {
      "code" : "3731014460",
      "display" : "精英牙醫診所"
    },
    {
      "code" : "3731014479",
      "display" : "典揚牙醫診所"
    },
    {
      "code" : "3731014488",
      "display" : "嘉得牙醫診所"
    },
    {
      "code" : "3731014504",
      "display" : "德恩牙醫診所"
    },
    {
      "code" : "3731014513",
      "display" : "小林美學牙醫診所"
    },
    {
      "code" : "3731014522",
      "display" : "蔡進富牙醫診所"
    },
    {
      "code" : "3731014559",
      "display" : "潔美牙醫診所"
    },
    {
      "code" : "3731014577",
      "display" : "史丹佛牙醫診所"
    },
    {
      "code" : "3731014586",
      "display" : "尚美美學牙醫診所"
    },
    {
      "code" : "3731014595",
      "display" : "尚誠牙醫診所"
    },
    {
      "code" : "3731014602",
      "display" : "鼎極牙醫診所"
    },
    {
      "code" : "3731014611",
      "display" : "靜思牙醫診所"
    },
    {
      "code" : "3731014648",
      "display" : "海棠牙醫診所"
    },
    {
      "code" : "3731014666",
      "display" : "上安牙醫診所"
    },
    {
      "code" : "3731014675",
      "display" : "御品牙醫診所"
    },
    {
      "code" : "3731014693",
      "display" : "旺福牙醫診所"
    },
    {
      "code" : "3731014700",
      "display" : "信安牙醫診所"
    },
    {
      "code" : "3731014728",
      "display" : "新板耀美牙醫診所"
    },
    {
      "code" : "3731014746",
      "display" : "樂真牙醫診所"
    },
    {
      "code" : "3731014764",
      "display" : "新優植牙醫診所"
    },
    {
      "code" : "3731014773",
      "display" : "品皓牙醫診所"
    },
    {
      "code" : "3731014782",
      "display" : "康祐臻品牙醫診所"
    },
    {
      "code" : "3731014791",
      "display" : "艾美牙醫診所"
    },
    {
      "code" : "3731014808",
      "display" : "絕美牙醫診所"
    },
    {
      "code" : "3731014826",
      "display" : "東壕牙醫診所"
    },
    {
      "code" : "3731014853",
      "display" : "嘉品牙醫診所"
    },
    {
      "code" : "3731014862",
      "display" : "晶耀牙醫診所"
    },
    {
      "code" : "3731014871",
      "display" : "至維牙醫診所"
    },
    {
      "code" : "3731014880",
      "display" : "精品牙醫診所"
    },
    {
      "code" : "3731014899",
      "display" : "汎宇牙醫診所"
    },
    {
      "code" : "3731014906",
      "display" : "康維牙醫診所"
    },
    {
      "code" : "3731014915",
      "display" : "史書華牙醫診所"
    },
    {
      "code" : "3731014951",
      "display" : "欣采美學牙醫診所"
    },
    {
      "code" : "3731014960",
      "display" : "禾樺牙醫診所"
    },
    {
      "code" : "3731014979",
      "display" : "藝大美學牙醫診所"
    },
    {
      "code" : "3731015010",
      "display" : "健哲牙醫診所"
    },
    {
      "code" : "3731015029",
      "display" : "精英美學牙醫診所"
    },
    {
      "code" : "3731015038",
      "display" : "美麗浮洲牙醫診所"
    },
    {
      "code" : "3731015056",
      "display" : "優客牙醫診所"
    },
    {
      "code" : "3731015065",
      "display" : "莫札特牙醫診所"
    },
    {
      "code" : "3731015074",
      "display" : "板橋雙十牙醫診所"
    },
    {
      "code" : "3731015092",
      "display" : "展揚牙醫診所"
    },
    {
      "code" : "3731015109",
      "display" : "麗晶牙醫診所"
    },
    {
      "code" : "3731015118",
      "display" : "一心牙醫診所"
    },
    {
      "code" : "3731015136",
      "display" : "牙醫先生牙醫診所"
    },
    {
      "code" : "3731015145",
      "display" : "英倫牙醫診所"
    },
    {
      "code" : "3731015154",
      "display" : "板橋蒔美牙醫診所"
    },
    {
      "code" : "3731015163",
      "display" : "藝文牙醫診所"
    },
    {
      "code" : "3731015172",
      "display" : "江翠牙醫診所"
    },
    {
      "code" : "3731015181",
      "display" : "謙岳美學牙醫診所"
    },
    {
      "code" : "3731015190",
      "display" : "麗緻美學牙醫診所"
    },
    {
      "code" : "3731015207",
      "display" : "向日葵美學牙醫診所"
    },
    {
      "code" : "3731015216",
      "display" : "星皓牙醫診所"
    },
    {
      "code" : "3731015225",
      "display" : "健哲牙醫診所"
    },
    {
      "code" : "3731015234",
      "display" : "鼎吉牙醫診所"
    },
    {
      "code" : "3731015243",
      "display" : "環球美學牙醫診所"
    },
    {
      "code" : "3731015252",
      "display" : "江翠牙醫診所"
    },
    {
      "code" : "3731015261",
      "display" : "亮白牙醫診所"
    },
    {
      "code" : "3731015270",
      "display" : "日煦牙醫診所"
    },
    {
      "code" : "3731015289",
      "display" : "偉恩牙醫診所"
    },
    {
      "code" : "3731015298",
      "display" : "尊榮悠陽牙醫診所"
    },
    {
      "code" : "3731015305",
      "display" : "樂惟牙醫診所"
    },
    {
      "code" : "3731015314",
      "display" : "森凡牙醫診所"
    },
    {
      "code" : "3731015323",
      "display" : "安信星曜牙醫診所"
    },
    {
      "code" : "3731015332",
      "display" : "恩美牙醫診所"
    },
    {
      "code" : "3731015341",
      "display" : "江翠牙醫診所"
    },
    {
      "code" : "3731015350",
      "display" : "久美牙醫診所"
    },
    {
      "code" : "3731015369",
      "display" : "芯悦牙醫診所"
    },
    {
      "code" : "3731015378",
      "display" : "江翠牙醫診所"
    },
    {
      "code" : "3731015387",
      "display" : "謙岳美學牙醫診所"
    },
    {
      "code" : "3731015396",
      "display" : "英倫牙醫診所"
    },
    {
      "code" : "3731015403",
      "display" : "至維牙醫診所"
    },
    {
      "code" : "3731015412",
      "display" : "詠心牙醫診所"
    },
    {
      "code" : "3731015421",
      "display" : "光玥牙醫診所"
    },
    {
      "code" : "3731015430",
      "display" : "品安牙醫診所"
    },
    {
      "code" : "3731015449",
      "display" : "絕美板橋牙醫診所"
    },
    {
      "code" : "3731015467",
      "display" : "霖佳華苑牙醫診所"
    },
    {
      "code" : "3731015476",
      "display" : "誠新牙醫診所"
    },
    {
      "code" : "3731015485",
      "display" : "明新牙醫診所"
    },
    {
      "code" : "3731020048",
      "display" : "重陽牙醫診所"
    },
    {
      "code" : "3731020057",
      "display" : "弘益牙醫診所"
    },
    {
      "code" : "3731020066",
      "display" : "三重新欣牙醫診所"
    },
    {
      "code" : "3731020084",
      "display" : "大洋牙醫診所"
    },
    {
      "code" : "3731020119",
      "display" : "蔡立人牙醫診所"
    },
    {
      "code" : "3731020128",
      "display" : "聯大牙醫診所"
    },
    {
      "code" : "3731020146",
      "display" : "光明牙醫診所"
    },
    {
      "code" : "3731020155",
      "display" : "厚德牙醫診所"
    },
    {
      "code" : "3731020164",
      "display" : "仁貴牙醫診所"
    },
    {
      "code" : "3731020217",
      "display" : "和國牙醫診所"
    },
    {
      "code" : "3731020299",
      "display" : "莊牙醫診所"
    },
    {
      "code" : "3731020342",
      "display" : "英仁牙醫診所"
    },
    {
      "code" : "3731020360",
      "display" : "久敦牙醫診所"
    },
    {
      "code" : "3731020379",
      "display" : "李牙醫診所"
    },
    {
      "code" : "3731020388",
      "display" : "林牙醫診所"
    },
    {
      "code" : "3731020397",
      "display" : "正光牙醫診所"
    },
    {
      "code" : "3731020404",
      "display" : "三富牙醫診所"
    },
    {
      "code" : "3731020431",
      "display" : "翁牙醫診所"
    },
    {
      "code" : "3731020440",
      "display" : "星輝牙醫診所"
    },
    {
      "code" : "3731020495",
      "display" : "正揚牙醫診所"
    },
    {
      "code" : "3731020520",
      "display" : "上宏牙醫診所"
    },
    {
      "code" : "3731020557",
      "display" : "吾佳牙醫診所"
    },
    {
      "code" : "3731020575",
      "display" : "文陽牙醫診所"
    },
    {
      "code" : "3731020584",
      "display" : "龍門牙醫診所"
    },
    {
      "code" : "3731020619",
      "display" : "三重埔展新牙醫診所"
    },
    {
      "code" : "3731020628",
      "display" : "慶長牙醫診所"
    },
    {
      "code" : "3731020637",
      "display" : "榮恩牙醫診所"
    },
    {
      "code" : "3731020682",
      "display" : "育安牙醫診所"
    },
    {
      "code" : "3731020708",
      "display" : "崇愛牙醫診所"
    },
    {
      "code" : "3731020717",
      "display" : "和平牙醫診所"
    },
    {
      "code" : "3731020744",
      "display" : "大新牙醫診所"
    },
    {
      "code" : "3731020780",
      "display" : "華信牙醫診所"
    },
    {
      "code" : "3731020799",
      "display" : "湯城牙醫診所"
    },
    {
      "code" : "3731020904",
      "display" : "健林牙醫診所"
    },
    {
      "code" : "3731020913",
      "display" : "金龍牙醫診所"
    },
    {
      "code" : "3731020922",
      "display" : "吳文財牙醫診所"
    },
    {
      "code" : "3731020986",
      "display" : "福信牙醫診所"
    },
    {
      "code" : "3731020995",
      "display" : "德倫牙醫診所"
    },
    {
      "code" : "3731021018",
      "display" : "三重埔牙醫診所"
    },
    {
      "code" : "3731021054",
      "display" : "東山牙醫診所"
    },
    {
      "code" : "3731021081",
      "display" : "聯合牙醫診所"
    },
    {
      "code" : "3731021116",
      "display" : "大眾牙醫診所"
    },
    {
      "code" : "3731021134",
      "display" : "欣華牙醫診所"
    },
    {
      "code" : "3731021143",
      "display" : "興和牙醫診所"
    },
    {
      "code" : "3731021287",
      "display" : "江村牙醫診所"
    },
    {
      "code" : "3731021296",
      "display" : "桂冠牙醫診所"
    },
    {
      "code" : "3731021312",
      "display" : "捷登牙醫診所"
    },
    {
      "code" : "3731021376",
      "display" : "華健牙醫診所"
    },
    {
      "code" : "3731022391",
      "display" : "品辰牙醫診所"
    },
    {
      "code" : "3731022417",
      "display" : "重新牙醫診所"
    },
    {
      "code" : "3731022426",
      "display" : "金中華牙醫診所"
    },
    {
      "code" : "3731022453",
      "display" : "順祥牙醫診所"
    },
    {
      "code" : "3731022471",
      "display" : "美善牙醫診所"
    },
    {
      "code" : "3731022506",
      "display" : "全鴻牙醫診所"
    },
    {
      "code" : "3731022515",
      "display" : "余延年牙醫診所"
    },
    {
      "code" : "3731022560",
      "display" : "日盛植牙美學牙醫診所"
    },
    {
      "code" : "3731022588",
      "display" : "欣誼牙醫診所"
    },
    {
      "code" : "3731022597",
      "display" : "維昌牙醫診所"
    },
    {
      "code" : "3731022613",
      "display" : "光美牙醫診所"
    },
    {
      "code" : "3731022622",
      "display" : "妙典牙醫診所"
    },
    {
      "code" : "3731022631",
      "display" : "長榮牙醫診所"
    },
    {
      "code" : "3731022640",
      "display" : "傑出聯合牙醫診所"
    },
    {
      "code" : "3731022702",
      "display" : "永福牙醫診所"
    },
    {
      "code" : "3731022757",
      "display" : "泛美牙醫診所"
    },
    {
      "code" : "3731022793",
      "display" : "保誠牙醫診所"
    },
    {
      "code" : "3731022800",
      "display" : "勝華牙醫診所"
    },
    {
      "code" : "3731022819",
      "display" : "群和牙醫診所"
    },
    {
      "code" : "3731022828",
      "display" : "馬克牙醫診所"
    },
    {
      "code" : "3731022837",
      "display" : "親德牙醫診所"
    },
    {
      "code" : "3731022846",
      "display" : "安慶牙醫診所"
    },
    {
      "code" : "3731022855",
      "display" : "華品牙醫診所"
    },
    {
      "code" : "3731022864",
      "display" : "奇美牙醫診所"
    },
    {
      "code" : "3731022873",
      "display" : "石公燦牙醫診所"
    },
    {
      "code" : "3731022882",
      "display" : "宜德牙醫診所"
    },
    {
      "code" : "3731022908",
      "display" : "景康牙醫診所"
    },
    {
      "code" : "3731022926",
      "display" : "元品牙醫診所"
    },
    {
      "code" : "3731022935",
      "display" : "晶典牙醫診所"
    },
    {
      "code" : "3731022971",
      "display" : "威登牙醫診所"
    },
    {
      "code" : "3731022980",
      "display" : "吉祐牙醫診所"
    },
    {
      "code" : "3731022999",
      "display" : "首席牙醫診所"
    },
    {
      "code" : "3731023012",
      "display" : "詠琦牙醫診所"
    },
    {
      "code" : "3731023021",
      "display" : "冠華牙醫診所"
    },
    {
      "code" : "3731023076",
      "display" : "龍騰牙醫診所"
    },
    {
      "code" : "3731023085",
      "display" : "寶石牙醫診所"
    },
    {
      "code" : "3731023101",
      "display" : "寶徠牙醫診所"
    },
    {
      "code" : "3731023110",
      "display" : "綺美牙醫診所"
    },
    {
      "code" : "3731023138",
      "display" : "宸禾牙醫診所"
    },
    {
      "code" : "3731023147",
      "display" : "太安牙醫診所"
    },
    {
      "code" : "3731023165",
      "display" : "創健牙醫診所"
    },
    {
      "code" : "3731023174",
      "display" : "美緹牙醫診所"
    },
    {
      "code" : "3731023183",
      "display" : "威登美學牙醫診所"
    },
    {
      "code" : "3731023192",
      "display" : "宏誠牙醫診所"
    },
    {
      "code" : "3731023209",
      "display" : "佳德牙醫診所"
    },
    {
      "code" : "3731023218",
      "display" : "遠傳牙醫診所"
    },
    {
      "code" : "3731023227",
      "display" : "怡品美學牙醫診所"
    },
    {
      "code" : "3731023236",
      "display" : "寶華牙醫診所"
    },
    {
      "code" : "3731023245",
      "display" : "微笑美學牙醫診所"
    },
    {
      "code" : "3731023254",
      "display" : "康緹牙醫診所"
    },
    {
      "code" : "3731023272",
      "display" : "丰采牙醫診所"
    },
    {
      "code" : "3731023316",
      "display" : "三重蒔美牙醫診所"
    },
    {
      "code" : "3731023325",
      "display" : "頌恩牙醫診所"
    },
    {
      "code" : "3731023343",
      "display" : "銓皓牙醫診所"
    },
    {
      "code" : "3731023352",
      "display" : "臻禾牙醫診所"
    },
    {
      "code" : "3731023370",
      "display" : "澄心牙醫診所"
    },
    {
      "code" : "3731023389",
      "display" : "悅心牙醫診所"
    },
    {
      "code" : "3731023398",
      "display" : "詠悅牙醫診所"
    },
    {
      "code" : "3731023405",
      "display" : "合暄牙醫診所"
    },
    {
      "code" : "3731023414",
      "display" : "曜華牙醫診所"
    },
    {
      "code" : "3731023423",
      "display" : "五華牙醫診所"
    },
    {
      "code" : "3731023432",
      "display" : "重心美學牙醫診所"
    },
    {
      "code" : "3731023441",
      "display" : "三重丰采牙醫診所"
    },
    {
      "code" : "3731023450",
      "display" : "輝瑞牙醫診所"
    },
    {
      "code" : "3731023469",
      "display" : "青青草美學牙醫診所"
    },
    {
      "code" : "3731023478",
      "display" : "丰禾牙醫診所"
    },
    {
      "code" : "3731023487",
      "display" : "合祐牙醫診所"
    },
    {
      "code" : "3731023496",
      "display" : "極光牙醫診所"
    },
    {
      "code" : "3731023503",
      "display" : "晶品牙醫診所"
    },
    {
      "code" : "3731023512",
      "display" : "御辰牙醫診所"
    },
    {
      "code" : "3731023521",
      "display" : "五華牙醫診所"
    },
    {
      "code" : "3731023530",
      "display" : "三富牙醫診所"
    },
    {
      "code" : "3731023549",
      "display" : "丰尚牙醫診所"
    },
    {
      "code" : "3731023558",
      "display" : "臻呈牙醫診所"
    },
    {
      "code" : "3731023567",
      "display" : "荷堤美學牙醫診所"
    },
    {
      "code" : "3731023576",
      "display" : "大德牙醫診所"
    },
    {
      "code" : "3731023585",
      "display" : "厚德牙醫診所"
    },
    {
      "code" : "3731023594",
      "display" : "三重蒔美牙醫診所"
    },
    {
      "code" : "3731023601",
      "display" : "樂天牙醫診所"
    },
    {
      "code" : "3731023610",
      "display" : "極光牙醫診所"
    },
    {
      "code" : "3731023629",
      "display" : "倢偲諾美學牙醫診所"
    },
    {
      "code" : "3731023638",
      "display" : "大新牙醫診所"
    },
    {
      "code" : "3731023647",
      "display" : "樂天牙醫診所"
    },
    {
      "code" : "3731023656",
      "display" : "康緹牙醫診所"
    },
    {
      "code" : "3731023665",
      "display" : "謙美牙醫診所"
    },
    {
      "code" : "3731023674",
      "display" : "專洗牙醫診所"
    },
    {
      "code" : "3731023683",
      "display" : "新緻美學牙醫診所"
    },
    {
      "code" : "3731023692",
      "display" : "心宇牙醫診所"
    },
    {
      "code" : "3731023709",
      "display" : "心晨牙醫診所"
    },
    {
      "code" : "3731023718",
      "display" : "舒芙美牙醫診所"
    },
    {
      "code" : "3731030035",
      "display" : "進安牙醫診所"
    },
    {
      "code" : "3731030071",
      "display" : "宜康牙醫診所"
    },
    {
      "code" : "3731030099",
      "display" : "光泰牙醫診所"
    },
    {
      "code" : "3731030106",
      "display" : "得和牙醫診所"
    },
    {
      "code" : "3731030124",
      "display" : "王宏仁牙醫診所"
    },
    {
      "code" : "3731030142",
      "display" : "美讓牙醫診所"
    },
    {
      "code" : "3731030213",
      "display" : "智光牙醫診所"
    },
    {
      "code" : "3731030231",
      "display" : "仁德牙醫診所"
    },
    {
      "code" : "3731030277",
      "display" : "葉牙醫診所"
    },
    {
      "code" : "3731030295",
      "display" : "慶星牙醫診所"
    },
    {
      "code" : "3731030357",
      "display" : "泰安牙醫診所"
    },
    {
      "code" : "3731030366",
      "display" : "文華牙醫診所"
    },
    {
      "code" : "3731030384",
      "display" : "光田牙醫診所"
    },
    {
      "code" : "3731030455",
      "display" : "永和牙醫診所"
    },
    {
      "code" : "3731030473",
      "display" : "崇恩牙醫診所"
    },
    {
      "code" : "3731030517",
      "display" : "國良牙醫診所"
    },
    {
      "code" : "3731030526",
      "display" : "鴻林牙醫診所"
    },
    {
      "code" : "3731030535",
      "display" : "雷鳴牙醫診所"
    },
    {
      "code" : "3731030544",
      "display" : "上林牙醫診所"
    },
    {
      "code" : "3731030599",
      "display" : "玉齡牙醫診所"
    },
    {
      "code" : "3731030615",
      "display" : "仁仁牙醫診所"
    },
    {
      "code" : "3731030633",
      "display" : "啟隆牙醫診所"
    },
    {
      "code" : "3731030642",
      "display" : "光耀牙醫診所"
    },
    {
      "code" : "3731030740",
      "display" : "惠忠牙醫診所"
    },
    {
      "code" : "3731030795",
      "display" : "秀和牙醫診所"
    },
    {
      "code" : "3731030811",
      "display" : "名德牙醫診所"
    },
    {
      "code" : "3731030820",
      "display" : "日新牙醫診所"
    },
    {
      "code" : "3731030839",
      "display" : "永慶牙醫診所"
    },
    {
      "code" : "3731030866",
      "display" : "保福牙醫診所"
    },
    {
      "code" : "3731030884",
      "display" : "名陽牙醫診所"
    },
    {
      "code" : "3731030893",
      "display" : "群芳牙醫診所"
    },
    {
      "code" : "3731030900",
      "display" : "漢聲牙醫診所"
    },
    {
      "code" : "3731031005",
      "display" : "得翔牙醫診所"
    },
    {
      "code" : "3731031014",
      "display" : "民生張牙醫診所"
    },
    {
      "code" : "3731031032",
      "display" : "新和牙醫診所"
    },
    {
      "code" : "3731031041",
      "display" : "東捷牙醫診所"
    },
    {
      "code" : "3731031096",
      "display" : "瓔美牙醫診所"
    },
    {
      "code" : "3731031158",
      "display" : "喜田牙醫診所"
    },
    {
      "code" : "3731031176",
      "display" : "蕙齡牙醫診所"
    },
    {
      "code" : "3731031201",
      "display" : "安潔牙醫診所"
    },
    {
      "code" : "3731031238",
      "display" : "遠丁牙醫診所"
    },
    {
      "code" : "3731031265",
      "display" : "晉安牙醫診所"
    },
    {
      "code" : "3731031336",
      "display" : "永和嘉仁牙醫診所"
    },
    {
      "code" : "3731031354",
      "display" : "永信牙醫診所"
    },
    {
      "code" : "3731031363",
      "display" : "唯登牙醫診所"
    },
    {
      "code" : "3731031381",
      "display" : "歐首牙醫診所"
    },
    {
      "code" : "3731031407",
      "display" : "慶齡牙醫診所"
    },
    {
      "code" : "3731031461",
      "display" : "博新牙醫診所"
    },
    {
      "code" : "3731032637",
      "display" : "郁遠牙醫診所"
    },
    {
      "code" : "3731032646",
      "display" : "誼安牙醫診所"
    },
    {
      "code" : "3731032655",
      "display" : "小木屋牙醫聯合診所"
    },
    {
      "code" : "3731032691",
      "display" : "荷風牙醫診所"
    },
    {
      "code" : "3731032717",
      "display" : "維康牙醫診所"
    },
    {
      "code" : "3731032726",
      "display" : "宏康牙醫診所"
    },
    {
      "code" : "3731032744",
      "display" : "瑞樺牙醫診所"
    },
    {
      "code" : "3731032806",
      "display" : "懷源牙醫診所"
    },
    {
      "code" : "3731032824",
      "display" : "竹琳牙醫診所"
    },
    {
      "code" : "3731032879",
      "display" : "貝瑞牙醫診所"
    },
    {
      "code" : "3731032897",
      "display" : "先進牙醫診所"
    },
    {
      "code" : "3731032904",
      "display" : "昱雅牙醫診所"
    },
    {
      "code" : "3731032922",
      "display" : "頂真牙醫診所"
    },
    {
      "code" : "3731032940",
      "display" : "卓越牙醫診所"
    },
    {
      "code" : "3731032959",
      "display" : "光毅牙醫診所"
    },
    {
      "code" : "3731032968",
      "display" : "世樺牙醫診所"
    },
    {
      "code" : "3731033054",
      "display" : "維恆牙醫診所"
    },
    {
      "code" : "3731033081",
      "display" : "匯豐牙醫診所"
    },
    {
      "code" : "3731033107",
      "display" : "御登牙醫診所"
    },
    {
      "code" : "3731033125",
      "display" : "鍾山牙醫診所"
    },
    {
      "code" : "3731033189",
      "display" : "豐富牙醫診所"
    },
    {
      "code" : "3731033198",
      "display" : "幸鼎牙醫診所"
    },
    {
      "code" : "3731033223",
      "display" : "椰林牙醫診所"
    },
    {
      "code" : "3731033232",
      "display" : "康承牙醫診所"
    },
    {
      "code" : "3731033241",
      "display" : "丰荷牙醫診所"
    },
    {
      "code" : "3731033269",
      "display" : "博世牙醫診所"
    },
    {
      "code" : "3731033296",
      "display" : "成品牙醫診所"
    },
    {
      "code" : "3731033303",
      "display" : "夏爾秀朗牙醫診所"
    },
    {
      "code" : "3731033330",
      "display" : "奇煒牙醫診所"
    },
    {
      "code" : "3731033358",
      "display" : "群英牙醫診所"
    },
    {
      "code" : "3731033385",
      "display" : "美麗永安牙醫診所"
    },
    {
      "code" : "3731033394",
      "display" : "艾莘牙醫診所"
    },
    {
      "code" : "3731033410",
      "display" : "潔登牙醫診所"
    },
    {
      "code" : "3731033447",
      "display" : "嘉康牙醫診所"
    },
    {
      "code" : "3731033456",
      "display" : "榛品牙醫診所"
    },
    {
      "code" : "3731033483",
      "display" : "永悅牙醫診所"
    },
    {
      "code" : "3731033492",
      "display" : "新維恩牙醫診所"
    },
    {
      "code" : "3731033527",
      "display" : "博祥牙醫診所"
    },
    {
      "code" : "3731033536",
      "display" : "博誠牙醫診所"
    },
    {
      "code" : "3731033554",
      "display" : "辰翰牙醫診所"
    },
    {
      "code" : "3731033563",
      "display" : "康馨牙醫診所"
    },
    {
      "code" : "3731033581",
      "display" : "仁美牙醫診所"
    },
    {
      "code" : "3731033590",
      "display" : "禾丰牙醫診所"
    },
    {
      "code" : "3731033607",
      "display" : "如意牙醫診所"
    },
    {
      "code" : "3731033616",
      "display" : "夏爾牙醫診所"
    },
    {
      "code" : "3731033625",
      "display" : "采豐牙醫診所"
    },
    {
      "code" : "3731033634",
      "display" : "清池牙醫診所"
    },
    {
      "code" : "3731033643",
      "display" : "華賢牙醫診所"
    },
    {
      "code" : "3731033652",
      "display" : "永安艾美牙醫診所"
    },
    {
      "code" : "3731033661",
      "display" : "尊榮牙醫診所"
    },
    {
      "code" : "3731033689",
      "display" : "永漾美學牙醫診所"
    },
    {
      "code" : "3731033698",
      "display" : "嘉祐牙醫診所"
    },
    {
      "code" : "3731033705",
      "display" : "京日牙醫診所"
    },
    {
      "code" : "3731033714",
      "display" : "保仁牙醫診所"
    },
    {
      "code" : "3731033723",
      "display" : "齊美牙醫診所"
    },
    {
      "code" : "3731033732",
      "display" : "加恩美學牙醫診所"
    },
    {
      "code" : "3731033741",
      "display" : "歐仕美牙醫診所"
    },
    {
      "code" : "3731033750",
      "display" : "旭光美學牙醫診所"
    },
    {
      "code" : "3731033769",
      "display" : "博誠牙醫診所"
    },
    {
      "code" : "3731033778",
      "display" : "欣品牙醫診所"
    },
    {
      "code" : "3731033787",
      "display" : "白光牙醫診所"
    },
    {
      "code" : "3731033796",
      "display" : "嘉祐牙醫診所"
    },
    {
      "code" : "3731033803",
      "display" : "博誠美學牙醫診所"
    },
    {
      "code" : "3731033812",
      "display" : "仁艾牙醫診所"
    },
    {
      "code" : "3731033821",
      "display" : "永漾恆美牙醫診所"
    },
    {
      "code" : "3731033830",
      "display" : "永漾美學牙醫診所"
    },
    {
      "code" : "3731033849",
      "display" : "一日誠臻牙醫診所"
    },
    {
      "code" : "3731033858",
      "display" : "嘉祐牙醫診所"
    },
    {
      "code" : "3731033867",
      "display" : "博誠牙醫診所"
    },
    {
      "code" : "3731033876",
      "display" : "永和雅德思牙醫診所"
    },
    {
      "code" : "3731033885",
      "display" : "星澄牙醫診所"
    },
    {
      "code" : "3731033894",
      "display" : "國良牙醫診所"
    },
    {
      "code" : "3731033901",
      "display" : "加恩美學牙醫診所"
    },
    {
      "code" : "3731033910",
      "display" : "晨瑞牙醫診所"
    },
    {
      "code" : "3731033929",
      "display" : "仁艾牙醫診所"
    },
    {
      "code" : "3731040013",
      "display" : "立安牙醫診所"
    },
    {
      "code" : "3731040077",
      "display" : "瑞祥牙醫診所"
    },
    {
      "code" : "3731040086",
      "display" : "景平牙醫診所"
    },
    {
      "code" : "3731040111",
      "display" : "華泰牙醫診所"
    },
    {
      "code" : "3731040120",
      "display" : "錦和牙醫診所"
    },
    {
      "code" : "3731040139",
      "display" : "清成牙醫診所"
    },
    {
      "code" : "3731040148",
      "display" : "大中和牙醫診所"
    },
    {
      "code" : "3731040157",
      "display" : "三民牙醫診所"
    },
    {
      "code" : "3731040184",
      "display" : "雙和牙醫診所"
    },
    {
      "code" : "3731040193",
      "display" : "如美牙醫診所"
    },
    {
      "code" : "3731040228",
      "display" : "中和牙醫診所"
    },
    {
      "code" : "3731040255",
      "display" : "薛牙醫診所"
    },
    {
      "code" : "3731040264",
      "display" : "俞牙醫診所"
    },
    {
      "code" : "3731040273",
      "display" : "智上牙醫診所"
    },
    {
      "code" : "3731040326",
      "display" : "新格牙醫診所"
    },
    {
      "code" : "3731040371",
      "display" : "名人牙醫診所"
    },
    {
      "code" : "3731040380",
      "display" : "中和林牙醫診所"
    },
    {
      "code" : "3731040399",
      "display" : "一成牙醫診所"
    },
    {
      "code" : "3731040406",
      "display" : "聯慶牙醫診所"
    },
    {
      "code" : "3731040433",
      "display" : "美安牙醫診所"
    },
    {
      "code" : "3731040460",
      "display" : "景新牙醫診所"
    },
    {
      "code" : "3731040504",
      "display" : "博雅牙醫診所"
    },
    {
      "code" : "3731040540",
      "display" : "祥和牙醫診所"
    },
    {
      "code" : "3731040586",
      "display" : "東大牙醫診所"
    },
    {
      "code" : "3731040602",
      "display" : "新雅牙醫診所"
    },
    {
      "code" : "3731040639",
      "display" : "揚昇牙醫診所"
    },
    {
      "code" : "3731040657",
      "display" : "朋詡牙醫診所"
    },
    {
      "code" : "3731040684",
      "display" : "煥強牙醫診所"
    },
    {
      "code" : "3731040700",
      "display" : "福雅牙醫診所"
    },
    {
      "code" : "3731040719",
      "display" : "吉仁牙醫診所"
    },
    {
      "code" : "3731040728",
      "display" : "永正牙醫診所"
    },
    {
      "code" : "3731040737",
      "display" : "林承德牙醫診所"
    },
    {
      "code" : "3731040746",
      "display" : "伍牙醫診所"
    },
    {
      "code" : "3731040862",
      "display" : "鴻宜牙醫診所"
    },
    {
      "code" : "3731040871",
      "display" : "東和牙醫診所"
    },
    {
      "code" : "3731040880",
      "display" : "慶恩牙醫診所"
    },
    {
      "code" : "3731040906",
      "display" : "天仁牙醫診所"
    },
    {
      "code" : "3731040979",
      "display" : "十方牙醫診所"
    },
    {
      "code" : "3731040997",
      "display" : "允安牙醫診所"
    },
    {
      "code" : "3731041001",
      "display" : "中山牙醫診所"
    },
    {
      "code" : "3731041038",
      "display" : "敦品牙醫診所"
    },
    {
      "code" : "3731041109",
      "display" : "陽明微笑牙醫診所"
    },
    {
      "code" : "3731041127",
      "display" : "實踐牙醫診所"
    },
    {
      "code" : "3731041136",
      "display" : "修德牙醫診所"
    },
    {
      "code" : "3731041163",
      "display" : "群益牙醫診所"
    },
    {
      "code" : "3731041216",
      "display" : "盈成牙醫診所"
    },
    {
      "code" : "3731041270",
      "display" : "柏安牙醫診所"
    },
    {
      "code" : "3731041298",
      "display" : "茂榕牙醫診所"
    },
    {
      "code" : "3731041350",
      "display" : "宋家牙醫診所"
    },
    {
      "code" : "3731041387",
      "display" : "中和德威牙醫診所"
    },
    {
      "code" : "3731041396",
      "display" : "文心牙醫診所"
    },
    {
      "code" : "3731041467",
      "display" : "聖欣牙醫診所"
    },
    {
      "code" : "3731041529",
      "display" : "興南牙醫聯合診所"
    },
    {
      "code" : "3731042553",
      "display" : "榮華牙醫診所"
    },
    {
      "code" : "3731042562",
      "display" : "中和大元牙醫診所"
    },
    {
      "code" : "3731042580",
      "display" : "虹佳牙醫診所"
    },
    {
      "code" : "3731042599",
      "display" : "全品牙醫診所"
    },
    {
      "code" : "3731042606",
      "display" : "華新牙醫診所"
    },
    {
      "code" : "3731042615",
      "display" : "嘉美牙醫診所"
    },
    {
      "code" : "3731042624",
      "display" : "德綸牙醫診所"
    },
    {
      "code" : "3731042651",
      "display" : "建隆牙醫診所"
    },
    {
      "code" : "3731042660",
      "display" : "愛華牙醫診所"
    },
    {
      "code" : "3731042679",
      "display" : "瑞星牙醫診所"
    },
    {
      "code" : "3731042688",
      "display" : "潔生牙醫診所"
    },
    {
      "code" : "3731042697",
      "display" : "昱軒牙醫診所"
    },
    {
      "code" : "3731042704",
      "display" : "徐錦堂牙醫診所"
    },
    {
      "code" : "3731042713",
      "display" : "菁英牙醫診所"
    },
    {
      "code" : "3731042731",
      "display" : "邱牙醫診所"
    },
    {
      "code" : "3731042795",
      "display" : "宏瑞牙醫診所"
    },
    {
      "code" : "3731042811",
      "display" : "東陽牙醫診所"
    },
    {
      "code" : "3731042820",
      "display" : "禾欣牙醫診所"
    },
    {
      "code" : "3731042839",
      "display" : "怡翔牙醫診所"
    },
    {
      "code" : "3731042848",
      "display" : "康橋牙醫診所"
    },
    {
      "code" : "3731042857",
      "display" : "合安牙醫診所"
    },
    {
      "code" : "3731042866",
      "display" : "哈佛牙醫診所"
    },
    {
      "code" : "3731042884",
      "display" : "宏軒牙醫診所"
    },
    {
      "code" : "3731042937",
      "display" : "金群牙醫診所"
    },
    {
      "code" : "3731042946",
      "display" : "景安牙醫診所"
    },
    {
      "code" : "3731042955",
      "display" : "尚恩牙醫診所"
    },
    {
      "code" : "3731042964",
      "display" : "采石牙醫診所"
    },
    {
      "code" : "3731042973",
      "display" : "榮祥牙醫診所"
    },
    {
      "code" : "3731042991",
      "display" : "安平牙醫診所"
    },
    {
      "code" : "3731043023",
      "display" : "柯牙醫診所"
    },
    {
      "code" : "3731043032",
      "display" : "向日葵牙醫診所"
    },
    {
      "code" : "3731043041",
      "display" : "迪康牙醫診所"
    },
    {
      "code" : "3731043069",
      "display" : "誠美牙醫診所"
    },
    {
      "code" : "3731043078",
      "display" : "佑康牙醫診所"
    },
    {
      "code" : "3731043112",
      "display" : "久大牙醫診所"
    },
    {
      "code" : "3731043158",
      "display" : "東鴻牙醫診所"
    },
    {
      "code" : "3731043185",
      "display" : "悠活牙醫診所"
    },
    {
      "code" : "3731043201",
      "display" : "君品牙醫診所"
    },
    {
      "code" : "3731043210",
      "display" : "遠雄牙醫診所"
    },
    {
      "code" : "3731043229",
      "display" : "關心牙醫診所"
    },
    {
      "code" : "3731043256",
      "display" : "里昂牙醫診所"
    },
    {
      "code" : "3731043274",
      "display" : "鼎爵牙醫診所"
    },
    {
      "code" : "3731043283",
      "display" : "瑞光牙醫診所"
    },
    {
      "code" : "3731043292",
      "display" : "景揚牙醫診所"
    },
    {
      "code" : "3731043327",
      "display" : "永立牙醫診所"
    },
    {
      "code" : "3731043345",
      "display" : "琇品牙醫診所"
    },
    {
      "code" : "3731043363",
      "display" : "晶璽牙醫診所"
    },
    {
      "code" : "3731043372",
      "display" : "群安牙醫診所"
    },
    {
      "code" : "3731043381",
      "display" : "臻美牙醫診所"
    },
    {
      "code" : "3731043443",
      "display" : "明煜牙醫診所"
    },
    {
      "code" : "3731043452",
      "display" : "景心牙醫診所"
    },
    {
      "code" : "3731043461",
      "display" : "佳欣牙醫診所"
    },
    {
      "code" : "3731043470",
      "display" : "鈦和牙醫診所"
    },
    {
      "code" : "3731043489",
      "display" : "齊心牙醫診所"
    },
    {
      "code" : "3731043498",
      "display" : "達運牙醫診所"
    },
    {
      "code" : "3731043505",
      "display" : "湛美牙醫診所"
    },
    {
      "code" : "3731043514",
      "display" : "均潔牙醫診所"
    },
    {
      "code" : "3731043532",
      "display" : "晶漾牙醫診所"
    },
    {
      "code" : "3731043541",
      "display" : "佳美牙醫診所"
    },
    {
      "code" : "3731043550",
      "display" : "馨悅牙醫診所"
    },
    {
      "code" : "3731043569",
      "display" : "南星美學牙醫診所"
    },
    {
      "code" : "3731043596",
      "display" : "璟安牙醫診所"
    },
    {
      "code" : "3731043603",
      "display" : "米雅美學牙醫診所"
    },
    {
      "code" : "3731043612",
      "display" : "曜新牙醫診所"
    },
    {
      "code" : "3731043621",
      "display" : "秀恩美學牙醫診所"
    },
    {
      "code" : "3731043630",
      "display" : "祥齡牙醫診所"
    },
    {
      "code" : "3731043649",
      "display" : "漾潔牙醫診所"
    },
    {
      "code" : "3731043658",
      "display" : "守遠牙醫診所"
    },
    {
      "code" : "3731043667",
      "display" : "臻星美學牙醫診所"
    },
    {
      "code" : "3731043676",
      "display" : "晶漾牙醫診所"
    },
    {
      "code" : "3731043685",
      "display" : "璟安牙醫診所"
    },
    {
      "code" : "3731043694",
      "display" : "日安牙醫診所"
    },
    {
      "code" : "3731043701",
      "display" : "東陽牙醫診所"
    },
    {
      "code" : "3731043710",
      "display" : "禾家牙醫診所"
    },
    {
      "code" : "3731043729",
      "display" : "立新美學牙醫診所"
    },
    {
      "code" : "3731043738",
      "display" : "沐德牙醫診所"
    },
    {
      "code" : "3731043756",
      "display" : "臻星美學牙醫診所"
    },
    {
      "code" : "3731043765",
      "display" : "臻美牙醫診所"
    },
    {
      "code" : "3731043774",
      "display" : "詠恩美學牙醫診所"
    },
    {
      "code" : "3731043783",
      "display" : "東陽牙醫診所"
    },
    {
      "code" : "3731043792",
      "display" : "皓悅牙醫診所"
    },
    {
      "code" : "3731043809",
      "display" : "晶亮牙醫診所"
    },
    {
      "code" : "3731043827",
      "display" : "臻星美學牙醫診所"
    },
    {
      "code" : "3731043836",
      "display" : "詠恩美學牙醫診所"
    },
    {
      "code" : "3731043845",
      "display" : "立薇美學牙醫診所"
    },
    {
      "code" : "3731043854",
      "display" : "琇品牙醫診所"
    },
    {
      "code" : "3731043863",
      "display" : "漾潔牙醫診所"
    },
    {
      "code" : "3731043872",
      "display" : "品嘉牙醫診所"
    },
    {
      "code" : "3731043881",
      "display" : "南星美學牙醫診所"
    },
    {
      "code" : "3731043907",
      "display" : "木村牙醫診所"
    },
    {
      "code" : "3731043916",
      "display" : "臻星美學牙醫診所"
    },
    {
      "code" : "3731050028",
      "display" : "百年牙醫診所"
    },
    {
      "code" : "3731050073",
      "display" : "裕仁牙醫診所"
    },
    {
      "code" : "3731050108",
      "display" : "凱旋牙醫診所"
    },
    {
      "code" : "3731050117",
      "display" : "戚崇龍牙醫診所"
    },
    {
      "code" : "3731050135",
      "display" : "李震強牙醫診所"
    },
    {
      "code" : "3731050180",
      "display" : "高牙醫診所"
    },
    {
      "code" : "3731050206",
      "display" : "品雅牙醫診所"
    },
    {
      "code" : "3731050233",
      "display" : "盧牙醫診所"
    },
    {
      "code" : "3731050242",
      "display" : "進新牙醫診所"
    },
    {
      "code" : "3731050297",
      "display" : "北新牙醫診所"
    },
    {
      "code" : "3731050340",
      "display" : "北大牙醫診所"
    },
    {
      "code" : "3731050359",
      "display" : "泰達牙醫診所"
    },
    {
      "code" : "3731050386",
      "display" : "黃牙醫診所"
    },
    {
      "code" : "3731050395",
      "display" : "郭濠生牙醫診所"
    },
    {
      "code" : "3731050402",
      "display" : "展新牙醫診所"
    },
    {
      "code" : "3731050411",
      "display" : "寶麒牙醫診所"
    },
    {
      "code" : "3731050439",
      "display" : "孫牙醫診所"
    },
    {
      "code" : "3731050457",
      "display" : "恒愛牙醫診所"
    },
    {
      "code" : "3731050475",
      "display" : "江陵牙醫診所"
    },
    {
      "code" : "3731050493",
      "display" : "親親牙醫診所"
    },
    {
      "code" : "3731050582",
      "display" : "旺威牙醫診所"
    },
    {
      "code" : "3731050617",
      "display" : "新進牙醫診所"
    },
    {
      "code" : "3731050626",
      "display" : "弘安牙醫診所"
    },
    {
      "code" : "3731050653",
      "display" : "迦南牙醫診所"
    },
    {
      "code" : "3731050662",
      "display" : "許正傑牙醫診所"
    },
    {
      "code" : "3731050680",
      "display" : "康保牙醫診所"
    },
    {
      "code" : "3731050699",
      "display" : "永佳牙醫診所"
    },
    {
      "code" : "3731050706",
      "display" : "凱悅牙醫診所"
    },
    {
      "code" : "3731050715",
      "display" : "豐田牙醫診所"
    },
    {
      "code" : "3731050797",
      "display" : "明潔牙醫診所"
    },
    {
      "code" : "3731050804",
      "display" : "佑恩牙醫診所"
    },
    {
      "code" : "3731050813",
      "display" : "同愛牙醫診所"
    },
    {
      "code" : "3731050831",
      "display" : "青潭牙醫診所"
    },
    {
      "code" : "3731050840",
      "display" : "心殿牙醫診所"
    },
    {
      "code" : "3731050868",
      "display" : "德威牙醫診所"
    },
    {
      "code" : "3731050886",
      "display" : "柏格牙醫診所"
    },
    {
      "code" : "3731050895",
      "display" : "紐約牙醫診所"
    },
    {
      "code" : "3731050911",
      "display" : "康和牙醫診所"
    },
    {
      "code" : "3731050939",
      "display" : "新寶元牙醫診所"
    },
    {
      "code" : "3731050948",
      "display" : "上耀牙醫診所"
    },
    {
      "code" : "3731051945",
      "display" : "蕙安牙醫診所"
    },
    {
      "code" : "3731051990",
      "display" : "冠雅牙醫診所"
    },
    {
      "code" : "3731052013",
      "display" : "元祥牙醫診所"
    },
    {
      "code" : "3731052068",
      "display" : "北都牙醫診所"
    },
    {
      "code" : "3731052095",
      "display" : "得恩牙醫診所"
    },
    {
      "code" : "3731052102",
      "display" : "新益牙醫診所"
    },
    {
      "code" : "3731052139",
      "display" : "東北大牙醫診所"
    },
    {
      "code" : "3731052148",
      "display" : "清新牙醫診所"
    },
    {
      "code" : "3731052157",
      "display" : "安琪兒牙醫診所"
    },
    {
      "code" : "3731052166",
      "display" : "吉安牙醫診所"
    },
    {
      "code" : "3731052237",
      "display" : "群林牙醫診所"
    },
    {
      "code" : "3731052264",
      "display" : "維美牙醫診所"
    },
    {
      "code" : "3731052273",
      "display" : "新采牙醫診所"
    },
    {
      "code" : "3731052282",
      "display" : "欣和牙醫診所"
    },
    {
      "code" : "3731052291",
      "display" : "品淳牙醫診所"
    },
    {
      "code" : "3731052308",
      "display" : "吉恩牙醫診所"
    },
    {
      "code" : "3731052344",
      "display" : "千悅牙醫診所"
    },
    {
      "code" : "3731052362",
      "display" : "晶采牙醫診所"
    },
    {
      "code" : "3731052371",
      "display" : "維彥牙醫診所"
    },
    {
      "code" : "3731052399",
      "display" : "敦鄰牙醫診所"
    },
    {
      "code" : "3731052406",
      "display" : "薪寶牙醫診所"
    },
    {
      "code" : "3731052415",
      "display" : "聖美牙醫診所"
    },
    {
      "code" : "3731052424",
      "display" : "舒美牙醫診所"
    },
    {
      "code" : "3731052442",
      "display" : "大坪林牙醫診所"
    },
    {
      "code" : "3731052479",
      "display" : "丰采美學牙醫診所"
    },
    {
      "code" : "3731052497",
      "display" : "鄺懷德牙醫診所"
    },
    {
      "code" : "3731052504",
      "display" : "盈佳牙醫診所"
    },
    {
      "code" : "3731052577",
      "display" : "愛美牙醫診所"
    },
    {
      "code" : "3731052586",
      "display" : "傑仁牙醫診所"
    },
    {
      "code" : "3731052602",
      "display" : "晶湛牙醫診所"
    },
    {
      "code" : "3731052639",
      "display" : "利林牙醫診所"
    },
    {
      "code" : "3731052648",
      "display" : "利新牙醫診所"
    },
    {
      "code" : "3731052666",
      "display" : "柏恩牙醫診所"
    },
    {
      "code" : "3731052675",
      "display" : "安康牙醫診所"
    },
    {
      "code" : "3731052693",
      "display" : "澄牙醫診所"
    },
    {
      "code" : "3731052700",
      "display" : "怡美牙醫診所"
    },
    {
      "code" : "3731052737",
      "display" : "如薏牙醫診所"
    },
    {
      "code" : "3731052746",
      "display" : "卓業牙醫診所"
    },
    {
      "code" : "3731052764",
      "display" : "好牙醫診所"
    },
    {
      "code" : "3731052773",
      "display" : "大衛牙醫診所"
    },
    {
      "code" : "3731052782",
      "display" : "安欣牙醫診所"
    },
    {
      "code" : "3731052817",
      "display" : "白玉牙醫診所"
    },
    {
      "code" : "3731052826",
      "display" : "臻晨美學牙醫診所"
    },
    {
      "code" : "3731052835",
      "display" : "美日牙醫診所"
    },
    {
      "code" : "3731052853",
      "display" : "卓悅牙醫診所"
    },
    {
      "code" : "3731052862",
      "display" : "育傑牙醫診所"
    },
    {
      "code" : "3731052871",
      "display" : "維風牙醫診所"
    },
    {
      "code" : "3731052880",
      "display" : "御田牙醫診所"
    },
    {
      "code" : "3731052899",
      "display" : "沐晨牙醫診所"
    },
    {
      "code" : "3731052906",
      "display" : "高端牙醫診所"
    },
    {
      "code" : "3731052915",
      "display" : "和田美學牙醫診所"
    },
    {
      "code" : "3731052924",
      "display" : "立悅美學牙醫診所"
    },
    {
      "code" : "3731052933",
      "display" : "廣䄷牙醫診所"
    },
    {
      "code" : "3731052942",
      "display" : "玉美學牙醫診所"
    },
    {
      "code" : "3731052951",
      "display" : "立誠美學牙醫診所"
    },
    {
      "code" : "3731052960",
      "display" : "樂齒牙醫診所"
    },
    {
      "code" : "3731052979",
      "display" : "吉安牙醫診所"
    },
    {
      "code" : "3731052988",
      "display" : "榛成牙醫診所"
    },
    {
      "code" : "3731052997",
      "display" : "沐光牙醫診所"
    },
    {
      "code" : "3731053001",
      "display" : "星嶼牙醫診所"
    },
    {
      "code" : "3731053010",
      "display" : "新店一日誠臻牙醫診所"
    },
    {
      "code" : "3731053038",
      "display" : "玉美學牙醫診所"
    },
    {
      "code" : "3731053047",
      "display" : "維娜斯牙醫診所"
    },
    {
      "code" : "3731053056",
      "display" : "旺威牙醫診所"
    },
    {
      "code" : "3731053065",
      "display" : "森林玉兒童牙醫診所"
    },
    {
      "code" : "3731053074",
      "display" : "日暖良玉牙醫診所"
    },
    {
      "code" : "3731053083",
      "display" : "權葳時尚美學牙醫診所"
    },
    {
      "code" : "3731053092",
      "display" : "立源美學牙醫診所"
    },
    {
      "code" : "3731053109",
      "display" : "和田美學牙醫診所"
    },
    {
      "code" : "3731053118",
      "display" : "璞臻新美學牙醫診所"
    },
    {
      "code" : "3731060015",
      "display" : "康德牙醫診所"
    },
    {
      "code" : "3731060051",
      "display" : "長興牙醫診所"
    },
    {
      "code" : "3731060097",
      "display" : "和泰牙醫診所"
    },
    {
      "code" : "3731060122",
      "display" : "懷恩牙醫診所"
    },
    {
      "code" : "3731060177",
      "display" : "輔仁牙醫診所"
    },
    {
      "code" : "3731060186",
      "display" : "宏林牙醫診所"
    },
    {
      "code" : "3731060195",
      "display" : "北陵牙醫診所"
    },
    {
      "code" : "3731060202",
      "display" : "安德牙醫診所"
    },
    {
      "code" : "3731060220",
      "display" : "康勝牙醫診所"
    },
    {
      "code" : "3731060257",
      "display" : "新華牙醫診所"
    },
    {
      "code" : "3731060284",
      "display" : "德安牙醫診所"
    },
    {
      "code" : "3731060319",
      "display" : "德旺牙醫診所"
    },
    {
      "code" : "3731060337",
      "display" : "博群牙醫診所"
    },
    {
      "code" : "3731060355",
      "display" : "家祥牙醫診所"
    },
    {
      "code" : "3731060373",
      "display" : "三愛牙醫診所"
    },
    {
      "code" : "3731060435",
      "display" : "龍安牙醫診所"
    },
    {
      "code" : "3731060444",
      "display" : "昇佑牙醫診所"
    },
    {
      "code" : "3731060499",
      "display" : "宏明牙醫診所"
    },
    {
      "code" : "3731060533",
      "display" : "慧安牙醫診所"
    },
    {
      "code" : "3731060597",
      "display" : "趙大地牙醫診所"
    },
    {
      "code" : "3731060604",
      "display" : "冠倫牙醫診所"
    },
    {
      "code" : "3731060677",
      "display" : "新莊謝牙醫診所"
    },
    {
      "code" : "3731060686",
      "display" : "健群牙醫診所"
    },
    {
      "code" : "3731060702",
      "display" : "思賢微笑牙醫診所"
    },
    {
      "code" : "3731060711",
      "display" : "裕民牙醫診所"
    },
    {
      "code" : "3731060766",
      "display" : "新超群牙醫診所"
    },
    {
      "code" : "3731060828",
      "display" : "富國牙醫診所"
    },
    {
      "code" : "3731060855",
      "display" : "開惠牙醫診所"
    },
    {
      "code" : "3731060873",
      "display" : "輔大牙醫診所"
    },
    {
      "code" : "3731060882",
      "display" : "震林牙醫診所"
    },
    {
      "code" : "3731060891",
      "display" : "鈺川牙醫診所"
    },
    {
      "code" : "3731060908",
      "display" : "大唐牙醫診所"
    },
    {
      "code" : "3731060917",
      "display" : "名仕牙醫診所"
    },
    {
      "code" : "3731060999",
      "display" : "聯華牙醫診所"
    },
    {
      "code" : "3731061030",
      "display" : "修正牙醫診所"
    },
    {
      "code" : "3731061067",
      "display" : "高泰牙醫診所"
    },
    {
      "code" : "3731061094",
      "display" : "許文政牙醫診所"
    },
    {
      "code" : "3731061110",
      "display" : "欣安牙醫診所"
    },
    {
      "code" : "3731061129",
      "display" : "名家牙醫診所"
    },
    {
      "code" : "3731061147",
      "display" : "全家福牙醫診所"
    },
    {
      "code" : "3731061174",
      "display" : "新莊尚品牙醫診所"
    },
    {
      "code" : "3731061183",
      "display" : "元富牙醫診所"
    },
    {
      "code" : "3731061254",
      "display" : "祐康牙醫診所"
    },
    {
      "code" : "3731061325",
      "display" : "安心牙醫診所"
    },
    {
      "code" : "3731061334",
      "display" : "冠霖牙醫診所"
    },
    {
      "code" : "3731061398",
      "display" : "建福牙醫診所"
    },
    {
      "code" : "3731062420",
      "display" : "富邦牙醫診所"
    },
    {
      "code" : "3731062475",
      "display" : "虹霖牙醫診所"
    },
    {
      "code" : "3731062500",
      "display" : "博安牙醫診所"
    },
    {
      "code" : "3731062519",
      "display" : "元華牙醫診所"
    },
    {
      "code" : "3731062528",
      "display" : "四維牙醫診所"
    },
    {
      "code" : "3731062537",
      "display" : "誠泰牙醫診所"
    },
    {
      "code" : "3731062546",
      "display" : "康泰牙醫診所"
    },
    {
      "code" : "3731062582",
      "display" : "劍橋牙醫診所"
    },
    {
      "code" : "3731062608",
      "display" : "菁美牙醫診所"
    },
    {
      "code" : "3731062626",
      "display" : "麗安牙醫診所"
    },
    {
      "code" : "3731062635",
      "display" : "大都會牙醫診所"
    },
    {
      "code" : "3731062699",
      "display" : "捷美牙醫診所"
    },
    {
      "code" : "3731062706",
      "display" : "景福牙醫診所"
    },
    {
      "code" : "3731062715",
      "display" : "榮和牙醫診所"
    },
    {
      "code" : "3731062742",
      "display" : "風尚牙醫診所"
    },
    {
      "code" : "3731062760",
      "display" : "全冠牙醫診所"
    },
    {
      "code" : "3731062788",
      "display" : "大象牙醫診所"
    },
    {
      "code" : "3731062822",
      "display" : "欣佑牙醫診所"
    },
    {
      "code" : "3731062831",
      "display" : "鴻金寶牙醫診所"
    },
    {
      "code" : "3731062886",
      "display" : "慶城牙醫診所"
    },
    {
      "code" : "3731062911",
      "display" : "幸福88牙醫診所"
    },
    {
      "code" : "3731062957",
      "display" : "尊爵牙醫診所"
    },
    {
      "code" : "3731062966",
      "display" : "博飛牙醫診所"
    },
    {
      "code" : "3731062984",
      "display" : "公園牙醫診所"
    },
    {
      "code" : "3731063025",
      "display" : "健安牙醫診所"
    },
    {
      "code" : "3731063043",
      "display" : "輔園牙醫診所"
    },
    {
      "code" : "3731063052",
      "display" : "恆合牙醫診所"
    },
    {
      "code" : "3731063089",
      "display" : "新樹聯合牙醫診所"
    },
    {
      "code" : "3731063105",
      "display" : "承心牙醫診所"
    },
    {
      "code" : "3731063123",
      "display" : "晶華牙醫診所"
    },
    {
      "code" : "3731063141",
      "display" : "祐新牙醫診所"
    },
    {
      "code" : "3731063169",
      "display" : "西盛牙醫診所"
    },
    {
      "code" : "3731063178",
      "display" : "艾登牙醫診所"
    },
    {
      "code" : "3731063196",
      "display" : "煥采牙醫診所"
    },
    {
      "code" : "3731063203",
      "display" : "新城牙醫診所"
    },
    {
      "code" : "3731063249",
      "display" : "明安牙醫診所"
    },
    {
      "code" : "3731063258",
      "display" : "緯群牙醫診所"
    },
    {
      "code" : "3731063276",
      "display" : "佑安牙醫診所"
    },
    {
      "code" : "3731063285",
      "display" : "君悅牙醫診所"
    },
    {
      "code" : "3731063294",
      "display" : "雙美牙醫診所"
    },
    {
      "code" : "3731063310",
      "display" : "美麗華牙醫診所"
    },
    {
      "code" : "3731063329",
      "display" : "全球牙醫診所"
    },
    {
      "code" : "3731063338",
      "display" : "爵美牙醫診所"
    },
    {
      "code" : "3731063356",
      "display" : "沐風牙醫診所"
    },
    {
      "code" : "3731063365",
      "display" : "幸福三三牙醫診所"
    },
    {
      "code" : "3731063383",
      "display" : "富安牙醫診所"
    },
    {
      "code" : "3731063392",
      "display" : "明揚牙醫診所"
    },
    {
      "code" : "3731063418",
      "display" : "大新莊牙醫診所"
    },
    {
      "code" : "3731063427",
      "display" : "欣尚牙醫診所"
    },
    {
      "code" : "3731063445",
      "display" : "艾旎牙醫診所"
    },
    {
      "code" : "3731063454",
      "display" : "福美牙醫診所"
    },
    {
      "code" : "3731063463",
      "display" : "大正牙醫診所"
    },
    {
      "code" : "3731063472",
      "display" : "頂新牙醫診所"
    },
    {
      "code" : "3731063490",
      "display" : "皓美牙醫診所"
    },
    {
      "code" : "3731063507",
      "display" : "皇霖牙醫診所"
    },
    {
      "code" : "3731063525",
      "display" : "上博牙醫診所"
    },
    {
      "code" : "3731063534",
      "display" : "緻美牙醫診所"
    },
    {
      "code" : "3731063543",
      "display" : "副都心牙醫診所"
    },
    {
      "code" : "3731063561",
      "display" : "師恩牙醫診所"
    },
    {
      "code" : "3731063570",
      "display" : "品森美學牙醫診所"
    },
    {
      "code" : "3731063589",
      "display" : "尊凡牙醫診所"
    },
    {
      "code" : "3731063598",
      "display" : "晶瑞牙醫診所"
    },
    {
      "code" : "3731063605",
      "display" : "幸福家牙醫診所"
    },
    {
      "code" : "3731063614",
      "display" : "非凡牙醫診所"
    },
    {
      "code" : "3731063623",
      "display" : "明星牙醫診所"
    },
    {
      "code" : "3731063641",
      "display" : "新月牙醫診所"
    },
    {
      "code" : "3731063650",
      "display" : "康軒牙醫診所"
    },
    {
      "code" : "3731063669",
      "display" : "全欣牙醫診所"
    },
    {
      "code" : "3731063678",
      "display" : "凱樂牙醫診所"
    },
    {
      "code" : "3731063687",
      "display" : "爵悅牙醫診所"
    },
    {
      "code" : "3731063696",
      "display" : "御美牙醫診所"
    },
    {
      "code" : "3731063703",
      "display" : "開惠牙醫診所"
    },
    {
      "code" : "3731063712",
      "display" : "長興牙醫診所"
    },
    {
      "code" : "3731063721",
      "display" : "頂尖牙醫診所"
    },
    {
      "code" : "3731063730",
      "display" : "星爵牙醫診所"
    },
    {
      "code" : "3731063749",
      "display" : "沐暮牙醫診所"
    },
    {
      "code" : "3731063758",
      "display" : "頂尖牙醫診所"
    },
    {
      "code" : "3731063767",
      "display" : "珺美牙醫診所"
    },
    {
      "code" : "3731063776",
      "display" : "幸福贊牙醫診所"
    },
    {
      "code" : "3731063785",
      "display" : "舒適美數位牙醫診所"
    },
    {
      "code" : "3731063794",
      "display" : "輔園牙醫診所"
    },
    {
      "code" : "3731063810",
      "display" : "品熙美學牙醫診所"
    },
    {
      "code" : "3731063829",
      "display" : "副都心牙醫診所"
    },
    {
      "code" : "3731063838",
      "display" : "秀泰牙醫診所"
    },
    {
      "code" : "3731063847",
      "display" : "大正牙醫診所"
    },
    {
      "code" : "3731063856",
      "display" : "新莊雲天牙醫診所"
    },
    {
      "code" : "3731063865",
      "display" : "雙美美學牙醫診所"
    },
    {
      "code" : "3731063874",
      "display" : "中信勝牙醫診所"
    },
    {
      "code" : "3731063883",
      "display" : "開惠牙醫診所"
    },
    {
      "code" : "3731070039",
      "display" : "四德牙醫診所"
    },
    {
      "code" : "3731070084",
      "display" : "又怡牙醫診所"
    },
    {
      "code" : "3731070100",
      "display" : "和美牙醫診所"
    },
    {
      "code" : "3731070119",
      "display" : "鴻仁牙醫診所"
    },
    {
      "code" : "3731070182",
      "display" : "佳新牙醫診所"
    },
    {
      "code" : "3731070191",
      "display" : "宇昇牙醫診所"
    },
    {
      "code" : "3731070208",
      "display" : "樹德牙醫診所"
    },
    {
      "code" : "3731070271",
      "display" : "元生牙醫診所"
    },
    {
      "code" : "3731070299",
      "display" : "何牙醫診所"
    },
    {
      "code" : "3731070315",
      "display" : "上好牙醫診所"
    },
    {
      "code" : "3731070379",
      "display" : "中華牙醫診所"
    },
    {
      "code" : "3731070388",
      "display" : "大山牙醫診所"
    },
    {
      "code" : "3731070397",
      "display" : "三榮牙醫診所"
    },
    {
      "code" : "3731070431",
      "display" : "家福牙醫診所"
    },
    {
      "code" : "3731070468",
      "display" : "復新牙醫診所"
    },
    {
      "code" : "3731070486",
      "display" : "保安牙醫診所"
    },
    {
      "code" : "3731071492",
      "display" : "佳樹牙醫診所"
    },
    {
      "code" : "3731071518",
      "display" : "傑夫牙醫診所"
    },
    {
      "code" : "3731071554",
      "display" : "康耀牙醫診所"
    },
    {
      "code" : "3731071563",
      "display" : "曙光牙醫診所"
    },
    {
      "code" : "3731071581",
      "display" : "辰林牙醫診所"
    },
    {
      "code" : "3731071616",
      "display" : "奇新牙醫診所"
    },
    {
      "code" : "3731071625",
      "display" : "晶致牙醫診所"
    },
    {
      "code" : "3731071634",
      "display" : "樹禾牙醫診所"
    },
    {
      "code" : "3731071643",
      "display" : "雅登牙醫診所"
    },
    {
      "code" : "3731071652",
      "display" : "金威牙醫診所"
    },
    {
      "code" : "3731071661",
      "display" : "佳豐牙醫診所"
    },
    {
      "code" : "3731071670",
      "display" : "欣瑞牙醫診所"
    },
    {
      "code" : "3731071705",
      "display" : "民安牙醫診所"
    },
    {
      "code" : "3731071714",
      "display" : "品橙牙醫診所"
    },
    {
      "code" : "3731071732",
      "display" : "佩福牙醫診所"
    },
    {
      "code" : "3731071769",
      "display" : "麗世牙醫診所"
    },
    {
      "code" : "3731071778",
      "display" : "樹欣牙醫診所"
    },
    {
      "code" : "3731071787",
      "display" : "北大昕成牙醫診所"
    },
    {
      "code" : "3731071796",
      "display" : "同心牙醫診所"
    },
    {
      "code" : "3731071803",
      "display" : "萬好牙醫診所"
    },
    {
      "code" : "3731071812",
      "display" : "日月辰心牙醫診所"
    },
    {
      "code" : "3731071821",
      "display" : "宏年牙醫診所"
    },
    {
      "code" : "3731071830",
      "display" : "得意牙醫診所"
    },
    {
      "code" : "3731071849",
      "display" : "樹禾牙醫診所"
    },
    {
      "code" : "3731071867",
      "display" : "樹林日月辰心牙醫診所"
    },
    {
      "code" : "3731071876",
      "display" : "德安美樹林牙醫診所"
    },
    {
      "code" : "3731071885",
      "display" : "萬好牙醫診所"
    },
    {
      "code" : "3731071894",
      "display" : "群峰牙醫診所"
    },
    {
      "code" : "3731071901",
      "display" : "蒔樂牙醫診所"
    },
    {
      "code" : "3731071910",
      "display" : "高明牙醫診所"
    },
    {
      "code" : "3731071929",
      "display" : "日月辰心樹林牙醫診所"
    },
    {
      "code" : "3731080017",
      "display" : "魏牙醫診所"
    },
    {
      "code" : "3731080026",
      "display" : "大慶牙醫診所"
    },
    {
      "code" : "3731080053",
      "display" : "青山牙醫診所"
    },
    {
      "code" : "3731080071",
      "display" : "謝彥中牙醫診所"
    },
    {
      "code" : "3731080106",
      "display" : "鶯歌牙醫診所"
    },
    {
      "code" : "3731080160",
      "display" : "國慶牙醫診所"
    },
    {
      "code" : "3731080188",
      "display" : "聖心牙醫診所"
    },
    {
      "code" : "3731080197",
      "display" : "鼎安牙醫診所"
    },
    {
      "code" : "3731081247",
      "display" : "楓林牙醫診所"
    },
    {
      "code" : "3731081256",
      "display" : "名品牙醫診所"
    },
    {
      "code" : "3731081283",
      "display" : "林明堂牙醫診所"
    },
    {
      "code" : "3731081327",
      "display" : "誠悅牙醫診所"
    },
    {
      "code" : "3731081354",
      "display" : "茁越牙醫診所"
    },
    {
      "code" : "3731081372",
      "display" : "樂康牙醫診所"
    },
    {
      "code" : "3731081381",
      "display" : "亞致牙醫診所"
    },
    {
      "code" : "3731081390",
      "display" : "鈞英牙醫診所"
    },
    {
      "code" : "3731081416",
      "display" : "亞致牙醫診所"
    },
    {
      "code" : "3731081425",
      "display" : "大心牙醫診所"
    },
    {
      "code" : "3731090022",
      "display" : "救生牙醫診所"
    },
    {
      "code" : "3731090040",
      "display" : "真善美牙醫診所"
    },
    {
      "code" : "3731090059",
      "display" : "華德牙醫診所"
    },
    {
      "code" : "3731090077",
      "display" : "優美牙醫診所"
    },
    {
      "code" : "3731090086",
      "display" : "蘇牙醫診所"
    },
    {
      "code" : "3731090095",
      "display" : "賴萬華牙醫診所"
    },
    {
      "code" : "3731090102",
      "display" : "惠恩牙醫診所"
    },
    {
      "code" : "3731090120",
      "display" : "大瀚牙醫診所"
    },
    {
      "code" : "3731090148",
      "display" : "宏志牙醫診所"
    },
    {
      "code" : "3731091190",
      "display" : "勝美牙醫診所"
    },
    {
      "code" : "3731091225",
      "display" : "佑辰牙醫診所"
    },
    {
      "code" : "3731091234",
      "display" : "高品牙醫診所"
    },
    {
      "code" : "3731091243",
      "display" : "協和牙醫診所"
    },
    {
      "code" : "3731091252",
      "display" : "學城牙醫診所"
    },
    {
      "code" : "3731091289",
      "display" : "北大蒔美牙醫診所"
    },
    {
      "code" : "3731091298",
      "display" : "大同牙醫診所"
    },
    {
      "code" : "3731091305",
      "display" : "擎天牙醫診所"
    },
    {
      "code" : "3731091323",
      "display" : "飛悅北大牙醫診所"
    },
    {
      "code" : "3731091341",
      "display" : "鼎晶牙醫診所"
    },
    {
      "code" : "3731091350",
      "display" : "小雲朵兒童牙醫診所"
    },
    {
      "code" : "3731091378",
      "display" : "得意牙醫診所"
    },
    {
      "code" : "3731091387",
      "display" : "明美學牙醫診所"
    },
    {
      "code" : "3731091396",
      "display" : "吉盛牙醫診所"
    },
    {
      "code" : "3731091403",
      "display" : "璞實牙醫診所"
    },
    {
      "code" : "3731091412",
      "display" : "美利亞牙醫診所"
    },
    {
      "code" : "3731091421",
      "display" : "植美美學牙醫診所"
    },
    {
      "code" : "3731091430",
      "display" : "昕月牙醫診所"
    },
    {
      "code" : "3731091449",
      "display" : "賴萬華牙醫診所"
    },
    {
      "code" : "3731091458",
      "display" : "樂同牙醫診所"
    },
    {
      "code" : "3731091485",
      "display" : "三峽一日誠臻牙醫診所"
    },
    {
      "code" : "3731091494",
      "display" : "植德美牙醫診所"
    },
    {
      "code" : "3731100023",
      "display" : "民生牙醫診所"
    },
    {
      "code" : "3731100041",
      "display" : "汪牙醫診所"
    },
    {
      "code" : "3731100087",
      "display" : "劉牙醫診所"
    },
    {
      "code" : "3731100096",
      "display" : "陳牙醫診所"
    },
    {
      "code" : "3731100103",
      "display" : "昇宏牙醫診所"
    },
    {
      "code" : "3731100149",
      "display" : "竹圍牙醫診所"
    },
    {
      "code" : "3731100167",
      "display" : "康華牙醫診所"
    },
    {
      "code" : "3731100176",
      "display" : "淡江牙醫診所"
    },
    {
      "code" : "3731100210",
      "display" : "衡德牙醫診所"
    },
    {
      "code" : "3731100229",
      "display" : "百成牙醫診所"
    },
    {
      "code" : "3731100238",
      "display" : "鄧公牙醫診所"
    },
    {
      "code" : "3731100247",
      "display" : "同陽牙醫診所"
    },
    {
      "code" : "3731100256",
      "display" : "淡水新埔牙醫診所"
    },
    {
      "code" : "3731100336",
      "display" : "大盛牙醫診所"
    },
    {
      "code" : "3731100345",
      "display" : "宏瑋牙醫診所"
    },
    {
      "code" : "3731100381",
      "display" : "華民牙醫診所"
    },
    {
      "code" : "3731100390",
      "display" : "朝日牙醫診所"
    },
    {
      "code" : "3731100443",
      "display" : "煥然牙醫診所"
    },
    {
      "code" : "3731101477",
      "display" : "晶晶牙科診所"
    },
    {
      "code" : "3731101495",
      "display" : "瑞竹醫典牙醫診所"
    },
    {
      "code" : "3731101502",
      "display" : "宏儒牙醫診所"
    },
    {
      "code" : "3731101511",
      "display" : "新偕牙醫診所"
    },
    {
      "code" : "3731101520",
      "display" : "蒞恩牙醫診所"
    },
    {
      "code" : "3731101539",
      "display" : "淡水聯合牙醫診所"
    },
    {
      "code" : "3731101575",
      "display" : "美白牙醫診所"
    },
    {
      "code" : "3731101619",
      "display" : "蒞美牙醫診所"
    },
    {
      "code" : "3731101628",
      "display" : "新光牙醫診所"
    },
    {
      "code" : "3731101646",
      "display" : "佛仁牙醫診所"
    },
    {
      "code" : "3731101655",
      "display" : "文化牙醫診所"
    },
    {
      "code" : "3731101664",
      "display" : "皓恩牙醫診所"
    },
    {
      "code" : "3731101673",
      "display" : "矯政牙醫診所"
    },
    {
      "code" : "3731101682",
      "display" : "皇嘉牙醫診所"
    },
    {
      "code" : "3731101726",
      "display" : "恩霖牙醫診所"
    },
    {
      "code" : "3731101735",
      "display" : "悠植牙醫診所"
    },
    {
      "code" : "3731101744",
      "display" : "李元瑞牙醫診所"
    },
    {
      "code" : "3731101753",
      "display" : "皇誠牙醫診所"
    },
    {
      "code" : "3731101762",
      "display" : "皇閣牙醫診所"
    },
    {
      "code" : "3731101771",
      "display" : "荷星牙醫診所"
    },
    {
      "code" : "3731101780",
      "display" : "植仕美數位美學牙醫診所"
    },
    {
      "code" : "3731101799",
      "display" : "璞安牙醫診所"
    },
    {
      "code" : "3731101806",
      "display" : "皇瑞牙醫診所"
    },
    {
      "code" : "3731101815",
      "display" : "植仕美數位美學牙醫診所"
    },
    {
      "code" : "3731101824",
      "display" : "民生牙醫診所"
    },
    {
      "code" : "3731101833",
      "display" : "立徠美學牙醫診所"
    },
    {
      "code" : "3731101842",
      "display" : "皇瑞牙醫診所"
    },
    {
      "code" : "3731101851",
      "display" : "沐光美學牙醫診所"
    },
    {
      "code" : "3731101860",
      "display" : "植仕美數位美學牙醫診所"
    },
    {
      "code" : "3731101879",
      "display" : "大谷牙醫診所"
    },
    {
      "code" : "3731101888",
      "display" : "淡水一日誠臻牙醫診所"
    },
    {
      "code" : "3731101897",
      "display" : "築心牙醫診所"
    },
    {
      "code" : "3731110038",
      "display" : "永琦牙醫診所"
    },
    {
      "code" : "3731110047",
      "display" : "江北牙醫診所"
    },
    {
      "code" : "3731110065",
      "display" : "復全牙醫診所"
    },
    {
      "code" : "3731110163",
      "display" : "德惠牙醫診所"
    },
    {
      "code" : "3731110172",
      "display" : "宏國牙醫診所"
    },
    {
      "code" : "3731110207",
      "display" : "和昌牙醫診所"
    },
    {
      "code" : "3731110216",
      "display" : "佑昌牙醫診所"
    },
    {
      "code" : "3731110289",
      "display" : "翔齡牙醫診所"
    },
    {
      "code" : "3731110341",
      "display" : "嘉仁牙醫診所"
    },
    {
      "code" : "3731110430",
      "display" : "東波牙醫診所"
    },
    {
      "code" : "3731110467",
      "display" : "柏元牙醫診所"
    },
    {
      "code" : "3731110547",
      "display" : "經典聯合牙醫診所"
    },
    {
      "code" : "3731110583",
      "display" : "詠翔牙醫診所"
    },
    {
      "code" : "3731110618",
      "display" : "向陽牙醫診所"
    },
    {
      "code" : "3731111679",
      "display" : "成合牙醫診所"
    },
    {
      "code" : "3731111731",
      "display" : "康普森牙醫診所"
    },
    {
      "code" : "3731111759",
      "display" : "陽明牙醫診所"
    },
    {
      "code" : "3731111777",
      "display" : "牙典牙醫診所"
    },
    {
      "code" : "3731111795",
      "display" : "倍得牙醫診所"
    },
    {
      "code" : "3731111802",
      "display" : "雙雙牙醫診所"
    },
    {
      "code" : "3731111839",
      "display" : "唯真牙醫診所"
    },
    {
      "code" : "3731111848",
      "display" : "艾美集牙醫診所"
    },
    {
      "code" : "3731111857",
      "display" : "秀峰牙醫診所"
    },
    {
      "code" : "3731111866",
      "display" : "七采牙醫診所"
    },
    {
      "code" : "3731111884",
      "display" : "微風牙醫診所"
    },
    {
      "code" : "3731111893",
      "display" : "安興牙醫診所"
    },
    {
      "code" : "3731111919",
      "display" : "品美牙醫診所"
    },
    {
      "code" : "3731111928",
      "display" : "采風牙醫診所"
    },
    {
      "code" : "3731111937",
      "display" : "尚風牙醫診所"
    },
    {
      "code" : "3731111946",
      "display" : "悠悅牙醫診所"
    },
    {
      "code" : "3731111955",
      "display" : "汐緻牙醫診所"
    },
    {
      "code" : "3731111964",
      "display" : "汐心牙醫診所"
    },
    {
      "code" : "3731111973",
      "display" : "汐潔牙醫診所"
    },
    {
      "code" : "3731111991",
      "display" : "汐科牙醫診所"
    },
    {
      "code" : "3731112005",
      "display" : "汐美學牙醫診所"
    },
    {
      "code" : "3731112014",
      "display" : "汐止蒔美牙醫診所"
    },
    {
      "code" : "3731112032",
      "display" : "登美牙醫診所"
    },
    {
      "code" : "3731112041",
      "display" : "御洺牙醫診所"
    },
    {
      "code" : "3731112050",
      "display" : "雲品牙醫診所"
    },
    {
      "code" : "3731112069",
      "display" : "幸福牙醫診所"
    },
    {
      "code" : "3731112078",
      "display" : "雲天牙醫診所"
    },
    {
      "code" : "3731112087",
      "display" : "多麗美學牙醫診所"
    },
    {
      "code" : "3731112096",
      "display" : "悅康牙醫診所"
    },
    {
      "code" : "3731112103",
      "display" : "幸福牙醫診所"
    },
    {
      "code" : "3731112112",
      "display" : "心芽美學牙醫診所"
    },
    {
      "code" : "3731112121",
      "display" : "多麗美學牙醫診所"
    },
    {
      "code" : "3731112130",
      "display" : "旭川牙醫診所"
    },
    {
      "code" : "3731112149",
      "display" : "樂霖牙醫診所"
    },
    {
      "code" : "3731112158",
      "display" : "多麗牙醫診所"
    },
    {
      "code" : "3731120016",
      "display" : "中美牙醫診所"
    },
    {
      "code" : "3731120061",
      "display" : "瑞芳李牙醫診所"
    },
    {
      "code" : "3731120070",
      "display" : "泰順牙醫診所"
    },
    {
      "code" : "3731120089",
      "display" : "芳德牙醫診所"
    },
    {
      "code" : "3731120123",
      "display" : "潔新牙醫診所"
    },
    {
      "code" : "3731120132",
      "display" : "瑞芳一日誠臻牙醫診所"
    },
    {
      "code" : "3731130012",
      "display" : "杏林牙醫診所"
    },
    {
      "code" : "3731130021",
      "display" : "怡安牙醫診所"
    },
    {
      "code" : "3731130058",
      "display" : "土城許牙醫診所"
    },
    {
      "code" : "3731130110",
      "display" : "顏式模牙醫診所"
    },
    {
      "code" : "3731130138",
      "display" : "仁安牙醫診所"
    },
    {
      "code" : "3731130183",
      "display" : "振興牙醫診所"
    },
    {
      "code" : "3731130236",
      "display" : "楊偉澤牙醫診所"
    },
    {
      "code" : "3731130245",
      "display" : "加州牙醫診所"
    },
    {
      "code" : "3731130254",
      "display" : "宏恩牙醫診所"
    },
    {
      "code" : "3731130272",
      "display" : "錫安牙醫診所"
    },
    {
      "code" : "3731130316",
      "display" : "嘉銳牙醫診所"
    },
    {
      "code" : "3731130334",
      "display" : "大宇牙醫診所"
    },
    {
      "code" : "3731130487",
      "display" : "良一牙醫診所"
    },
    {
      "code" : "3731130512",
      "display" : "盛泓牙醫診所"
    },
    {
      "code" : "3731130521",
      "display" : "明治牙醫診所"
    },
    {
      "code" : "3731130567",
      "display" : "土城芳鄰牙醫診所"
    },
    {
      "code" : "3731130629",
      "display" : "新亞牙醫診所"
    },
    {
      "code" : "3731130665",
      "display" : "莒光牙醫診所"
    },
    {
      "code" : "3731130683",
      "display" : "施潔慧牙醫診所"
    },
    {
      "code" : "3731130692",
      "display" : "學林牙醫診所"
    },
    {
      "code" : "3731130718",
      "display" : "瑞康牙醫診所"
    },
    {
      "code" : "3731130727",
      "display" : "仁和牙醫診所"
    },
    {
      "code" : "3731130736",
      "display" : "嘉德沈牙醫診所"
    },
    {
      "code" : "3731130763",
      "display" : "傑聖牙醫診所"
    },
    {
      "code" : "3731130772",
      "display" : "成安牙醫診所"
    },
    {
      "code" : "3731130781",
      "display" : "聯揚牙醫診所"
    },
    {
      "code" : "3731130790",
      "display" : "德祥牙醫診所"
    },
    {
      "code" : "3731131813",
      "display" : "誼家牙醫診所"
    },
    {
      "code" : "3731131859",
      "display" : "康群牙醫診所"
    },
    {
      "code" : "3731131868",
      "display" : "宏維牙醫診所"
    },
    {
      "code" : "3731131877",
      "display" : "土城新雅牙醫診所"
    },
    {
      "code" : "3731131886",
      "display" : "宏大牙醫診所"
    },
    {
      "code" : "3731131895",
      "display" : "嘉恩牙醫診所"
    },
    {
      "code" : "3731131902",
      "display" : "信誠牙醫診所"
    },
    {
      "code" : "3731131920",
      "display" : "天華牙醫診所"
    },
    {
      "code" : "3731131993",
      "display" : "佳楷牙醫診所"
    },
    {
      "code" : "3731132007",
      "display" : "東方牙醫診所"
    },
    {
      "code" : "3731132016",
      "display" : "富康牙醫診所"
    },
    {
      "code" : "3731132025",
      "display" : "沅鴻牙醫診所"
    },
    {
      "code" : "3731132043",
      "display" : "永光牙醫診所"
    },
    {
      "code" : "3731132098",
      "display" : "萬芳牙醫診所"
    },
    {
      "code" : "3731132114",
      "display" : "岳揚牙醫診所"
    },
    {
      "code" : "3731132132",
      "display" : "精湛牙醫診所"
    },
    {
      "code" : "3731132178",
      "display" : "明曜牙醫診所"
    },
    {
      "code" : "3731132196",
      "display" : "麗品牙醫診所"
    },
    {
      "code" : "3731132249",
      "display" : "思安牙醫診所"
    },
    {
      "code" : "3731132267",
      "display" : "悅揚牙醫診所"
    },
    {
      "code" : "3731132285",
      "display" : "富城牙醫診所"
    },
    {
      "code" : "3731132294",
      "display" : "星曜牙醫診所"
    },
    {
      "code" : "3731132301",
      "display" : "星采牙醫診所"
    },
    {
      "code" : "3731132338",
      "display" : "金城牙醫診所"
    },
    {
      "code" : "3731132347",
      "display" : "佑祥美學牙醫診所"
    },
    {
      "code" : "3731132356",
      "display" : "冠菲牙醫診所"
    },
    {
      "code" : "3731132365",
      "display" : "康捷牙醫診所"
    },
    {
      "code" : "3731132374",
      "display" : "禾心牙醫診所"
    },
    {
      "code" : "3731132383",
      "display" : "東松牙醫診所"
    },
    {
      "code" : "3731132392",
      "display" : "亞欣牙醫診所"
    },
    {
      "code" : "3731132409",
      "display" : "精湛牙醫診所"
    },
    {
      "code" : "3731132418",
      "display" : "精誠牙醫診所"
    },
    {
      "code" : "3731132427",
      "display" : "精心牙醫診所"
    },
    {
      "code" : "3731132436",
      "display" : "日光牙醫診所"
    },
    {
      "code" : "3731132445",
      "display" : "康捷牙醫診所"
    },
    {
      "code" : "3731132454",
      "display" : "金城牙醫診所"
    },
    {
      "code" : "3731132463",
      "display" : "星漾牙醫診所"
    },
    {
      "code" : "3731132472",
      "display" : "澄美牙醫診所"
    },
    {
      "code" : "3731132481",
      "display" : "鐵齒牙醫診所"
    },
    {
      "code" : "3731132490",
      "display" : "土城雅德思牙醫診所"
    },
    {
      "code" : "3731132507",
      "display" : "噬合牙醫診所"
    },
    {
      "code" : "3731132516",
      "display" : "超泓牙醫診所"
    },
    {
      "code" : "3731132525",
      "display" : "雅東潔韻牙醫診所"
    },
    {
      "code" : "3731132534",
      "display" : "聯揚牙醫診所"
    },
    {
      "code" : "3731132543",
      "display" : "卓逸牙醫診所"
    },
    {
      "code" : "3731132552",
      "display" : "日和美牙醫診所"
    },
    {
      "code" : "3731132561",
      "display" : "富城牙醫診所"
    },
    {
      "code" : "3731132570",
      "display" : "仁和牙醫診所"
    },
    {
      "code" : "3731132589",
      "display" : "土城捷晞美學牙醫診所"
    },
    {
      "code" : "3731132598",
      "display" : "星承牙醫診所"
    },
    {
      "code" : "3731140018",
      "display" : "宏昇牙醫診所"
    },
    {
      "code" : "3731140027",
      "display" : "仁愛牙醫診所"
    },
    {
      "code" : "3731140054",
      "display" : "晉泰牙醫診所"
    },
    {
      "code" : "3731140072",
      "display" : "嘉齡牙醫診所"
    },
    {
      "code" : "3731140090",
      "display" : "長安牙醫診所"
    },
    {
      "code" : "3731140125",
      "display" : "水湳牙醫診所"
    },
    {
      "code" : "3731140161",
      "display" : "蘆洲陳牙醫診所"
    },
    {
      "code" : "3731140189",
      "display" : "永全牙醫診所"
    },
    {
      "code" : "3731140198",
      "display" : "普惠牙醫診所"
    },
    {
      "code" : "3731140223",
      "display" : "永富牙醫診所"
    },
    {
      "code" : "3731140269",
      "display" : "鄭書珉牙醫診所"
    },
    {
      "code" : "3731140278",
      "display" : "雙宏牙醫診所"
    },
    {
      "code" : "3731140321",
      "display" : "建德牙醫診所"
    },
    {
      "code" : "3731140385",
      "display" : "信義牙醫診所"
    },
    {
      "code" : "3731140394",
      "display" : "康福牙醫診所"
    },
    {
      "code" : "3731140447",
      "display" : "傑美牙醫診所"
    },
    {
      "code" : "3731140483",
      "display" : "華心牙醫診所"
    },
    {
      "code" : "3731140492",
      "display" : "昌輝牙醫診所"
    },
    {
      "code" : "3731140527",
      "display" : "英文牙醫診所"
    },
    {
      "code" : "3731141622",
      "display" : "上晴牙醫診所"
    },
    {
      "code" : "3731141631",
      "display" : "博育牙醫診所"
    },
    {
      "code" : "3731141640",
      "display" : "偉齡牙醫診所"
    },
    {
      "code" : "3731141748",
      "display" : "美華牙醫診所"
    },
    {
      "code" : "3731141784",
      "display" : "欣葉牙醫診所"
    },
    {
      "code" : "3731141793",
      "display" : "全家聯合牙醫診所"
    },
    {
      "code" : "3731141800",
      "display" : "元大牙醫診所"
    },
    {
      "code" : "3731141846",
      "display" : "盛德牙醫診所"
    },
    {
      "code" : "3731141864",
      "display" : "京華牙醫診所"
    },
    {
      "code" : "3731141873",
      "display" : "拾健牙醫診所"
    },
    {
      "code" : "3731141882",
      "display" : "東揚牙醫診所"
    },
    {
      "code" : "3731141891",
      "display" : "臻品牙醫診所"
    },
    {
      "code" : "3731141908",
      "display" : "豐華牙醫診所"
    },
    {
      "code" : "3731141926",
      "display" : "博士牙醫診所"
    },
    {
      "code" : "3731141935",
      "display" : "大德牙醫診所"
    },
    {
      "code" : "3731141953",
      "display" : "本一牙醫診所"
    },
    {
      "code" : "3731141999",
      "display" : "晶品牙醫診所"
    },
    {
      "code" : "3731142012",
      "display" : "學進牙醫診所"
    },
    {
      "code" : "3731142021",
      "display" : "璀璨美學牙醫診所"
    },
    {
      "code" : "3731142058",
      "display" : "冠植牙醫診所"
    },
    {
      "code" : "3731142067",
      "display" : "家園牙醫診所"
    },
    {
      "code" : "3731142085",
      "display" : "鎰安牙醫診所"
    },
    {
      "code" : "3731142094",
      "display" : "華康牙醫診所"
    },
    {
      "code" : "3731142110",
      "display" : "美加牙醫診所"
    },
    {
      "code" : "3731142129",
      "display" : "杏美牙醫診所"
    },
    {
      "code" : "3731142138",
      "display" : "明勝牙醫診所"
    },
    {
      "code" : "3731142147",
      "display" : "樂澄牙醫診所"
    },
    {
      "code" : "3731142165",
      "display" : "禾新牙醫診所"
    },
    {
      "code" : "3731142183",
      "display" : "麗璽牙醫診所"
    },
    {
      "code" : "3731142192",
      "display" : "京典牙醫診所"
    },
    {
      "code" : "3731142209",
      "display" : "御鼎牙醫診所"
    },
    {
      "code" : "3731142218",
      "display" : "品鑽牙醫診所"
    },
    {
      "code" : "3731142236",
      "display" : "盈綵牙醫診所"
    },
    {
      "code" : "3731142245",
      "display" : "柏鎂牙醫診所"
    },
    {
      "code" : "3731142263",
      "display" : "蘆美學牙醫診所"
    },
    {
      "code" : "3731142272",
      "display" : "心安牙醫診所"
    },
    {
      "code" : "3731142281",
      "display" : "成美牙醫診所"
    },
    {
      "code" : "3731142290",
      "display" : "家源牙醫診所"
    },
    {
      "code" : "3731142307",
      "display" : "愛惜牙醫診所"
    },
    {
      "code" : "3731142316",
      "display" : "柏韋牙醫診所"
    },
    {
      "code" : "3731142325",
      "display" : "遇見牙醫診所"
    },
    {
      "code" : "3731142334",
      "display" : "御森牙醫診所"
    },
    {
      "code" : "3731142343",
      "display" : "愛惜牙醫診所"
    },
    {
      "code" : "3731142352",
      "display" : "登士美數位牙醫診所"
    },
    {
      "code" : "3731142361",
      "display" : "沐心牙醫診所"
    },
    {
      "code" : "3731142370",
      "display" : "大德牙醫診所"
    },
    {
      "code" : "3731142389",
      "display" : "蘆美學牙醫診所"
    },
    {
      "code" : "3731142398",
      "display" : "遇見兒童牙醫診所"
    },
    {
      "code" : "3731142405",
      "display" : "家源牙醫診所"
    },
    {
      "code" : "3731142414",
      "display" : "富境牙醫診所"
    },
    {
      "code" : "3731142423",
      "display" : "茉莉牙醫診所"
    },
    {
      "code" : "3731142432",
      "display" : "遇見兒童牙醫診所"
    },
    {
      "code" : "3731150096",
      "display" : "明志牙醫診所"
    },
    {
      "code" : "3731150238",
      "display" : "鄭牙醫診所"
    },
    {
      "code" : "3731150256",
      "display" : "恩新牙醫診所"
    },
    {
      "code" : "3731150265",
      "display" : "德音牙醫診所"
    },
    {
      "code" : "3731151299",
      "display" : "亰橋牙醫診所"
    },
    {
      "code" : "3731151333",
      "display" : "冠美牙醫診所"
    },
    {
      "code" : "3731151351",
      "display" : "義美牙醫診所"
    },
    {
      "code" : "3731151360",
      "display" : "瑞林牙醫診所"
    },
    {
      "code" : "3731151422",
      "display" : "皇尚牙醫診所"
    },
    {
      "code" : "3731151486",
      "display" : "上禾牙醫診所"
    },
    {
      "code" : "3731151511",
      "display" : "晴美牙醫診所"
    },
    {
      "code" : "3731151539",
      "display" : "唯一牙醫診所"
    },
    {
      "code" : "3731151548",
      "display" : "好治牙醫診所"
    },
    {
      "code" : "3731151566",
      "display" : "心城牙醫診所"
    },
    {
      "code" : "3731151575",
      "display" : "悠亞牙醫診所"
    },
    {
      "code" : "3731151584",
      "display" : "立渼美學牙醫診所"
    },
    {
      "code" : "3731151593",
      "display" : "好治牙醫診所"
    },
    {
      "code" : "3731151600",
      "display" : "唯一牙醫診所"
    },
    {
      "code" : "3731151619",
      "display" : "五心吉牙醫診所"
    },
    {
      "code" : "3731151628",
      "display" : "蕓心牙醫診所"
    },
    {
      "code" : "3731160047",
      "display" : "大新泰牙醫診所"
    },
    {
      "code" : "3731160056",
      "display" : "明泰牙醫診所"
    },
    {
      "code" : "3731160065",
      "display" : "泰上牙醫診所"
    },
    {
      "code" : "3731160092",
      "display" : "安仁牙醫診所"
    },
    {
      "code" : "3731160154",
      "display" : "新象牙醫診所"
    },
    {
      "code" : "3731160163",
      "display" : "泰山牙醫診所"
    },
    {
      "code" : "3731161188",
      "display" : "李天堯牙醫診所"
    },
    {
      "code" : "3731161197",
      "display" : "信美牙醫診所"
    },
    {
      "code" : "3731161204",
      "display" : "喜美牙醫診所"
    },
    {
      "code" : "3731161213",
      "display" : "唐氏牙醫診所"
    },
    {
      "code" : "3731161231",
      "display" : "泰美牙醫診所"
    },
    {
      "code" : "3731161259",
      "display" : "城康牙醫診所"
    },
    {
      "code" : "3731161268",
      "display" : "京硯牙醫診所"
    },
    {
      "code" : "3731161277",
      "display" : "舒禾牙醫診所"
    },
    {
      "code" : "3731161286",
      "display" : "亞昕牙醫診所"
    },
    {
      "code" : "3731161295",
      "display" : "禾杏牙醫診所"
    },
    {
      "code" : "3731161302",
      "display" : "泰然牙醫診所"
    },
    {
      "code" : "3731161311",
      "display" : "城康美學牙醫診所"
    },
    {
      "code" : "3731161320",
      "display" : "新五泰牙醫診所"
    },
    {
      "code" : "3731161339",
      "display" : "凱星牙醫診所"
    },
    {
      "code" : "3731161348",
      "display" : "昕光牙醫診所"
    },
    {
      "code" : "3731170034",
      "display" : "超群牙醫診所"
    },
    {
      "code" : "3731170043",
      "display" : "吉隆牙醫診所"
    },
    {
      "code" : "3731170052",
      "display" : "林口周牙醫診所"
    },
    {
      "code" : "3731170061",
      "display" : "坤冉牙醫診所"
    },
    {
      "code" : "3731170089",
      "display" : "麗園牙醫診所"
    },
    {
      "code" : "3731171102",
      "display" : "麗林牙醫診所"
    },
    {
      "code" : "3731171139",
      "display" : "林安牙醫診所"
    },
    {
      "code" : "3731171148",
      "display" : "惠群牙醫診所"
    },
    {
      "code" : "3731171166",
      "display" : "天翔牙醫診所"
    },
    {
      "code" : "3731171184",
      "display" : "禾林牙醫診所"
    },
    {
      "code" : "3731171193",
      "display" : "沃德牙醫診所"
    },
    {
      "code" : "3731171200",
      "display" : "心悅牙醫診所"
    },
    {
      "code" : "3731171219",
      "display" : "四季牙醫診所"
    },
    {
      "code" : "3731171228",
      "display" : "澄明牙醫診所"
    },
    {
      "code" : "3731171237",
      "display" : "翰品牙醫診所"
    },
    {
      "code" : "3731171246",
      "display" : "汎德牙醫診所"
    },
    {
      "code" : "3731171264",
      "display" : "亞德牙醫診所"
    },
    {
      "code" : "3731171273",
      "display" : "馨禾牙醫診所"
    },
    {
      "code" : "3731171282",
      "display" : "康澤牙醫診所"
    },
    {
      "code" : "3731171291",
      "display" : "展心牙醫診所"
    },
    {
      "code" : "3731171308",
      "display" : "東佑牙醫診所"
    },
    {
      "code" : "3731171326",
      "display" : "極致美學牙醫診所"
    },
    {
      "code" : "3731171344",
      "display" : "萊德美學牙醫診所"
    },
    {
      "code" : "3731171362",
      "display" : "華航牙醫診所"
    },
    {
      "code" : "3731171371",
      "display" : "中悅牙醫診所"
    },
    {
      "code" : "3731171380",
      "display" : "勤美牙醫診所"
    },
    {
      "code" : "3731171399",
      "display" : "頭等艙牙醫診所"
    },
    {
      "code" : "3731171406",
      "display" : "波音牙醫診所"
    },
    {
      "code" : "3731171415",
      "display" : "展研牙醫診所"
    },
    {
      "code" : "3731171424",
      "display" : "好好牙醫診所"
    },
    {
      "code" : "3731171433",
      "display" : "彤學牙醫診所"
    },
    {
      "code" : "3731171442",
      "display" : "三井牙醫診所"
    },
    {
      "code" : "3731171451",
      "display" : "葡萄柚兒童牙醫診所"
    },
    {
      "code" : "3731171460",
      "display" : "新林牙醫診所"
    },
    {
      "code" : "3731171479",
      "display" : "日沐勤美牙醫診所"
    },
    {
      "code" : "3731171488",
      "display" : "沃德忠孝牙醫診所"
    },
    {
      "code" : "3731171497",
      "display" : "彤學牙醫診所"
    },
    {
      "code" : "3731171504",
      "display" : "沃德牙醫診所"
    },
    {
      "code" : "3731171513",
      "display" : "禾林牙醫診所"
    },
    {
      "code" : "3731171531",
      "display" : "巧益牙醫診所"
    },
    {
      "code" : "3731171540",
      "display" : "波音牙醫診所"
    },
    {
      "code" : "3731171559",
      "display" : "禾林牙醫診所"
    },
    {
      "code" : "3731171568",
      "display" : "沃德牙醫診所"
    },
    {
      "code" : "3731171577",
      "display" : "林口一日誠臻牙醫診所"
    },
    {
      "code" : "3731171586",
      "display" : "小日子兒童牙醫診所"
    },
    {
      "code" : "3731171595",
      "display" : "林口一日誠臻牙醫診所"
    },
    {
      "code" : "3731171602",
      "display" : "禾瑞牙醫診所"
    },
    {
      "code" : "3731171611",
      "display" : "林口小周牙醫診所"
    },
    {
      "code" : "3731171620",
      "display" : "展晨牙醫診所"
    },
    {
      "code" : "3731180012",
      "display" : "世華牙醫診所"
    },
    {
      "code" : "3731180030",
      "display" : "榮泰牙醫診所"
    },
    {
      "code" : "3731180058",
      "display" : "陳建志牙醫診所"
    },
    {
      "code" : "3731181082",
      "display" : "埔新牙醫診所"
    },
    {
      "code" : "3731181091",
      "display" : "皇家牙醫診所"
    },
    {
      "code" : "3731190527",
      "display" : "虹淇牙醫診所"
    },
    {
      "code" : "3731210015",
      "display" : "宏達牙醫診所"
    },
    {
      "code" : "3731210033",
      "display" : "華峰牙醫診所"
    },
    {
      "code" : "3731210060",
      "display" : "理想牙醫診所"
    },
    {
      "code" : "3731210079",
      "display" : "翔禾牙醫診所"
    },
    {
      "code" : "3731230026",
      "display" : "國華牙醫診所"
    },
    {
      "code" : "3731231069",
      "display" : "左岸牙醫診所"
    },
    {
      "code" : "3731231096",
      "display" : "皇翔牙醫診所"
    },
    {
      "code" : "3731231103",
      "display" : "薰衣草牙醫診所"
    },
    {
      "code" : "3731231112",
      "display" : "豪美牙醫診所"
    },
    {
      "code" : "3731231121",
      "display" : "八里世家牙醫診所"
    },
    {
      "code" : "3731250019",
      "display" : "偉華牙醫診所"
    },
    {
      "code" : "3731270011",
      "display" : "慶美牙醫診所"
    },
    {
      "code" : "3731270066",
      "display" : "晶山牙醫診所"
    },
    {
      "code" : "3731270075",
      "display" : "禾牙醫診所"
    },
    {
      "code" : "3731280017",
      "display" : "恒生牙醫診所"
    },
    {
      "code" : "3734010017",
      "display" : "大統牙醫診所"
    },
    {
      "code" : "3734010026",
      "display" : "弘恩牙醫診所"
    },
    {
      "code" : "3734010071",
      "display" : "統一牙醫診所"
    },
    {
      "code" : "3734010106",
      "display" : "宏宇牙醫診所"
    },
    {
      "code" : "3734010115",
      "display" : "全友牙醫診所"
    },
    {
      "code" : "3734010124",
      "display" : "仁人牙醫診所"
    },
    {
      "code" : "3734010133",
      "display" : "和睦牙醫診所"
    },
    {
      "code" : "3734010142",
      "display" : "平安牙醫診所"
    },
    {
      "code" : "3734010151",
      "display" : "陳志超牙醫診所"
    },
    {
      "code" : "3734010160",
      "display" : "陳宜誠牙醫診所"
    },
    {
      "code" : "3734010188",
      "display" : "清華牙醫診所"
    },
    {
      "code" : "3734010213",
      "display" : "通安全牙醫診所"
    },
    {
      "code" : "3734010240",
      "display" : "張登富牙醫診所"
    },
    {
      "code" : "3734010259",
      "display" : "宏林牙醫診所"
    },
    {
      "code" : "3734010268",
      "display" : "中山牙醫診所"
    },
    {
      "code" : "3734010295",
      "display" : "李玉珍牙醫診所"
    },
    {
      "code" : "3734011336",
      "display" : "為楷牙醫診所"
    },
    {
      "code" : "3734011345",
      "display" : "智勝科技牙醫診所"
    },
    {
      "code" : "3734011354",
      "display" : "大安麗緻牙醫診所"
    },
    {
      "code" : "3734011363",
      "display" : "饒正美牙醫診所"
    },
    {
      "code" : "3734011381",
      "display" : "超群牙醫診所"
    },
    {
      "code" : "3734011390",
      "display" : "一德牙醫診所"
    },
    {
      "code" : "3734011407",
      "display" : "自強牙醫診所"
    },
    {
      "code" : "3734011416",
      "display" : "銘世成牙醫診所"
    },
    {
      "code" : "3734011425",
      "display" : "康全牙醫診所"
    },
    {
      "code" : "3734011434",
      "display" : "佳康牙醫診所"
    },
    {
      "code" : "3734011443",
      "display" : "１００１楊牙醫診所"
    },
    {
      "code" : "3734011470",
      "display" : "達文西牙醫診所"
    },
    {
      "code" : "3734011489",
      "display" : "陳信甫牙醫診所"
    },
    {
      "code" : "3734011498",
      "display" : "怡安牙醫診所"
    },
    {
      "code" : "3734011505",
      "display" : "英菲特口腔外科牙醫診所"
    },
    {
      "code" : "3734011514",
      "display" : "喜樂芽牙醫診所"
    },
    {
      "code" : "3734011523",
      "display" : "橙星牙醫診所"
    },
    {
      "code" : "3734011532",
      "display" : "伊人牙醫診所"
    },
    {
      "code" : "3734011541",
      "display" : "欣美牙醫診所"
    },
    {
      "code" : "3734011550",
      "display" : "小星球牙醫診所"
    },
    {
      "code" : "3734011569",
      "display" : "沐蘭牙醫診所"
    },
    {
      "code" : "3734011578",
      "display" : "悦光牙醫診所"
    },
    {
      "code" : "3734011596",
      "display" : "倍恩牙醫診所"
    },
    {
      "code" : "3734011603",
      "display" : "木木牙醫診所"
    },
    {
      "code" : "3734011630",
      "display" : "小超人兒童牙醫診所"
    },
    {
      "code" : "3734011649",
      "display" : "喨喨牙醫診所"
    },
    {
      "code" : "3734011658",
      "display" : "雅德思牙醫診所"
    },
    {
      "code" : "3734020013",
      "display" : "藍牙醫診所"
    },
    {
      "code" : "3734020040",
      "display" : "延林牙醫診所"
    },
    {
      "code" : "3734020068",
      "display" : "東安牙醫診所"
    },
    {
      "code" : "3734020077",
      "display" : "中興牙醫診所"
    },
    {
      "code" : "3734020120",
      "display" : "光仁牙醫診所"
    },
    {
      "code" : "3734020139",
      "display" : "文雅牙醫診所"
    },
    {
      "code" : "3734020166",
      "display" : "昭全牙醫診所"
    },
    {
      "code" : "3734020175",
      "display" : "瑞祥牙醫診所"
    },
    {
      "code" : "3734020200",
      "display" : "啟誠牙醫診所"
    },
    {
      "code" : "3734020219",
      "display" : "名人牙醫診所"
    },
    {
      "code" : "3734020237",
      "display" : "順泰牙醫診所"
    },
    {
      "code" : "3734020273",
      "display" : "佳恩牙醫診所"
    },
    {
      "code" : "3734020282",
      "display" : "仲輝牙醫診所"
    },
    {
      "code" : "3734020291",
      "display" : "陳清輝牙醫診所"
    },
    {
      "code" : "3734020308",
      "display" : "梁博文牙醫診所"
    },
    {
      "code" : "3734020317",
      "display" : "陳鴻政牙醫診所"
    },
    {
      "code" : "3734020335",
      "display" : "徐牙醫診所"
    },
    {
      "code" : "3734020344",
      "display" : "左巴牙醫診所"
    },
    {
      "code" : "3734020353",
      "display" : "許明哲牙醫診所"
    },
    {
      "code" : "3734020362",
      "display" : "健菖牙醫診所"
    },
    {
      "code" : "3734021378",
      "display" : "周仁紅牙醫診所"
    },
    {
      "code" : "3734021387",
      "display" : "多耐牙醫診所"
    },
    {
      "code" : "3734021396",
      "display" : "林慧玲牙醫診所"
    },
    {
      "code" : "3734021403",
      "display" : "李懷德牙醫診所"
    },
    {
      "code" : "3734021412",
      "display" : "陳維德牙醫診所"
    },
    {
      "code" : "3734021421",
      "display" : "一心牙醫診所"
    },
    {
      "code" : "3734021430",
      "display" : "詮佳牙醫診所"
    },
    {
      "code" : "3734021449",
      "display" : "王平安牙醫診所"
    },
    {
      "code" : "3734021458",
      "display" : "李繼武牙醫診所"
    },
    {
      "code" : "3734021467",
      "display" : "冠緯牙醫診所"
    },
    {
      "code" : "3734021494",
      "display" : "頂尖牙醫診所"
    },
    {
      "code" : "3734021501",
      "display" : "植新牙醫診所"
    },
    {
      "code" : "3734021510",
      "display" : "禮綸牙醫診所"
    },
    {
      "code" : "3734021529",
      "display" : "康慧牙醫診所"
    },
    {
      "code" : "3734021538",
      "display" : "鼎祐牙醫診所"
    },
    {
      "code" : "3734021547",
      "display" : "斑比牙醫診所"
    },
    {
      "code" : "3734021556",
      "display" : "易宏牙醫診所"
    },
    {
      "code" : "3734021565",
      "display" : "好日牙醫診所"
    },
    {
      "code" : "3734021574",
      "display" : "優植牙醫診所"
    },
    {
      "code" : "3734021592",
      "display" : "晨星牙醫診所"
    },
    {
      "code" : "3734021609",
      "display" : "東美牙醫診所"
    },
    {
      "code" : "3734021618",
      "display" : "羅東雲天牙醫診所"
    },
    {
      "code" : "3734030019",
      "display" : "今日牙醫診所"
    },
    {
      "code" : "3734030028",
      "display" : "永安牙醫診所"
    },
    {
      "code" : "3734030064",
      "display" : "陽明牙醫診所"
    },
    {
      "code" : "3734031070",
      "display" : "黃牙醫診所"
    },
    {
      "code" : "3734040015",
      "display" : "李牙醫診所"
    },
    {
      "code" : "3734040033",
      "display" : "順源牙醫診所"
    },
    {
      "code" : "3734040042",
      "display" : "喜美牙醫診所"
    },
    {
      "code" : "3734040060",
      "display" : "建樺牙醫診所"
    },
    {
      "code" : "3734050011",
      "display" : "育生牙醫診所"
    },
    {
      "code" : "3734050039",
      "display" : "張牙醫診所"
    },
    {
      "code" : "3734050057",
      "display" : "美佳牙醫診所"
    },
    {
      "code" : "3734050066",
      "display" : "協安牙醫診所"
    },
    {
      "code" : "3734050075",
      "display" : "嘉心牙醫診所"
    },
    {
      "code" : "3734050084",
      "display" : "快樂牙醫診所"
    },
    {
      "code" : "3734050093",
      "display" : "樸石牙醫診所"
    },
    {
      "code" : "3734060017",
      "display" : "和平牙醫診所"
    },
    {
      "code" : "3734061023",
      "display" : "慈安牙醫診所"
    },
    {
      "code" : "3734070513",
      "display" : "心德牙醫診所"
    },
    {
      "code" : "3734080037",
      "display" : "我家牙醫診所"
    },
    {
      "code" : "3734080046",
      "display" : "奧麗薇牙醫診所"
    },
    {
      "code" : "3734080055",
      "display" : "永銨牙醫診所"
    },
    {
      "code" : "3734090015",
      "display" : "利生牙醫診所"
    },
    {
      "code" : "3734090024",
      "display" : "林文通牙醫診所"
    },
    {
      "code" : "3734091049",
      "display" : "五福牙醫診所"
    },
    {
      "code" : "3734100025",
      "display" : "田園牙醫診所"
    },
    {
      "code" : "3734100034",
      "display" : "以馬內利牙醫診所"
    },
    {
      "code" : "3790011034",
      "display" : "千禧牙醫診所"
    },
    {
      "code" : "3790011043",
      "display" : "民生牙醫診所"
    },
    {
      "code" : "3790011052",
      "display" : "大安牙醫聯合診所"
    },
    {
      "code" : "3790011132",
      "display" : "大千牙醫診所"
    },
    {
      "code" : "3790011169",
      "display" : "人愛牙醫診所"
    },
    {
      "code" : "3790011196",
      "display" : "一心牙醫診所"
    },
    {
      "code" : "3790011203",
      "display" : "晨曦牙醫診所"
    },
    {
      "code" : "3790011212",
      "display" : "洪長享牙醫診所"
    },
    {
      "code" : "3790011221",
      "display" : "金鼎牙醫診所"
    },
    {
      "code" : "3790020515",
      "display" : "建中牙醫診所"
    },
    {
      "code" : "3790030017",
      "display" : "盧冠宇牙醫診所"
    },
    {
      "code" : "3790031036",
      "display" : "許耀人牙醫診所"
    },
    {
      "code" : "3790031054",
      "display" : "仁仁牙醫診所"
    },
    {
      "code" : "3790031072",
      "display" : "享悅牙醫診所"
    },
    {
      "code" : "3790040535",
      "display" : "金寧盧冠宇牙醫診所"
    },
    {
      "code" : "3790050531",
      "display" : "十方牙醫診所"
    },
    {
      "code" : "3801010054",
      "display" : "尊生堂中醫診所"
    },
    {
      "code" : "3801010090",
      "display" : "顏長春中醫診所"
    },
    {
      "code" : "3801010205",
      "display" : "振誠中醫診所"
    },
    {
      "code" : "3801010287",
      "display" : "國晉中醫診所"
    },
    {
      "code" : "3801010394",
      "display" : "桂堂中醫診所"
    },
    {
      "code" : "3801010518",
      "display" : "理想中醫診所"
    },
    {
      "code" : "3801011748",
      "display" : "延吉中醫診所"
    },
    {
      "code" : "3801011855",
      "display" : "維哲中醫診所"
    },
    {
      "code" : "3801011926",
      "display" : "永昌漢方中醫診所"
    },
    {
      "code" : "3801012030",
      "display" : "仁和堂中醫診所"
    },
    {
      "code" : "3801012049",
      "display" : "仲佑中醫診所"
    },
    {
      "code" : "3801012094",
      "display" : "育晟中醫診所"
    },
    {
      "code" : "3801012101",
      "display" : "和豐中醫診所"
    },
    {
      "code" : "3801012138",
      "display" : "楠桐中醫診所"
    },
    {
      "code" : "3801012174",
      "display" : "益茂中醫診所"
    },
    {
      "code" : "3801012236",
      "display" : "百漢中醫診所"
    },
    {
      "code" : "3801012249",
      "display" : "德昌中醫診所"
    },
    {
      "code" : "3801012272",
      "display" : "弘祐中醫診所"
    },
    {
      "code" : "3801012325",
      "display" : "宜陞中醫診所"
    },
    {
      "code" : "3801012389",
      "display" : "祐瑞中醫診所"
    },
    {
      "code" : "3801012398",
      "display" : "聖唐中醫診所"
    },
    {
      "code" : "3801012405",
      "display" : "新富錦中醫診所"
    },
    {
      "code" : "3801012478",
      "display" : "博康中醫診所"
    },
    {
      "code" : "3801012496",
      "display" : "皇脈中醫診所"
    },
    {
      "code" : "3801012512",
      "display" : "東青中醫診所"
    },
    {
      "code" : "3801012530",
      "display" : "青花瓷養生中醫診所"
    },
    {
      "code" : "3801012549",
      "display" : "慈和中醫診所"
    },
    {
      "code" : "3801012567",
      "display" : "漢浤堂健康中醫診所"
    },
    {
      "code" : "3801012594",
      "display" : "茶米中醫診所"
    },
    {
      "code" : "3801012601",
      "display" : "民生漢唐中醫診所"
    },
    {
      "code" : "3801012610",
      "display" : "民昇中醫診所"
    },
    {
      "code" : "3801012629",
      "display" : "伍德中醫診所"
    },
    {
      "code" : "3801012638",
      "display" : "欣悅中醫診所"
    },
    {
      "code" : "3801012647",
      "display" : "鳳凰中醫診所"
    },
    {
      "code" : "3801012656",
      "display" : "杏莆堂中醫診所"
    },
    {
      "code" : "3801012674",
      "display" : "渼生堂中醫診所"
    },
    {
      "code" : "3801012683",
      "display" : "華泰中醫診所"
    },
    {
      "code" : "3801012692",
      "display" : "春日和中醫診所"
    },
    {
      "code" : "3801012718",
      "display" : "民生漢唐中醫診所"
    },
    {
      "code" : "3801012727",
      "display" : "欣百漢中醫診所"
    },
    {
      "code" : "3801012736",
      "display" : "民生瀚威中醫診所"
    },
    {
      "code" : "3801012745",
      "display" : "彥明中醫診所"
    },
    {
      "code" : "3801012754",
      "display" : "頤鳴堂中醫診所"
    },
    {
      "code" : "3801012763",
      "display" : "渼生堂中醫診所"
    },
    {
      "code" : "3801012772",
      "display" : "君綺中醫診所"
    },
    {
      "code" : "3801012781",
      "display" : "好康中醫診所"
    },
    {
      "code" : "3801012790",
      "display" : "馨安中醫診所"
    },
    {
      "code" : "3801012807",
      "display" : "君綺中醫診所"
    },
    {
      "code" : "3801012816",
      "display" : "初鳴堂中醫診所"
    },
    {
      "code" : "3801012825",
      "display" : "源珍中醫診所"
    },
    {
      "code" : "3801020050",
      "display" : "金龍堂中醫診所"
    },
    {
      "code" : "3801020078",
      "display" : "鴻安中醫診所"
    },
    {
      "code" : "3801020158",
      "display" : "國仁中醫診所"
    },
    {
      "code" : "3801020274",
      "display" : "粗淡中醫診所"
    },
    {
      "code" : "3801020532",
      "display" : "醫道堂黃中醫診所"
    },
    {
      "code" : "3801020694",
      "display" : "吉辰中醫診所"
    },
    {
      "code" : "3801020890",
      "display" : "當代漢醫苑中醫診所"
    },
    {
      "code" : "3801020934",
      "display" : "麗華中醫診所"
    },
    {
      "code" : "3801022036",
      "display" : "李穎哲中醫診所"
    },
    {
      "code" : "3801022072",
      "display" : "宏秀堂中醫診所"
    },
    {
      "code" : "3801022116",
      "display" : "維康中醫診所"
    },
    {
      "code" : "3801022134",
      "display" : "長春中醫診所"
    },
    {
      "code" : "3801022143",
      "display" : "天慈中醫診所"
    },
    {
      "code" : "3801022161",
      "display" : "杏福中醫診所"
    },
    {
      "code" : "3801022269",
      "display" : "宜仁堂中醫診所"
    },
    {
      "code" : "3801022330",
      "display" : "佶安中醫診所"
    },
    {
      "code" : "3801022367",
      "display" : "育群中醫診所"
    },
    {
      "code" : "3801022410",
      "display" : "保源中醫診所"
    },
    {
      "code" : "3801022438",
      "display" : "瑞康中醫診所"
    },
    {
      "code" : "3801022492",
      "display" : "介良中醫診所"
    },
    {
      "code" : "3801022607",
      "display" : "明圓中醫診所"
    },
    {
      "code" : "3801022705",
      "display" : "育揚中醫診所"
    },
    {
      "code" : "3801022750",
      "display" : "御絨中醫診所"
    },
    {
      "code" : "3801022787",
      "display" : "杏霖中醫診所"
    },
    {
      "code" : "3801022796",
      "display" : "康和中醫診所"
    },
    {
      "code" : "3801022803",
      "display" : "美成中醫診所"
    },
    {
      "code" : "3801022821",
      "display" : "御庭中醫診所"
    },
    {
      "code" : "3801022849",
      "display" : "大安尊生堂中醫診所"
    },
    {
      "code" : "3801022885",
      "display" : "大安元氣堂中醫診所"
    },
    {
      "code" : "3801022969",
      "display" : "一嚴堂中醫診所"
    },
    {
      "code" : "3801022978",
      "display" : "全德中醫診所"
    },
    {
      "code" : "3801023015",
      "display" : "京禾中醫診所"
    },
    {
      "code" : "3801023033",
      "display" : "德恩中醫診所"
    },
    {
      "code" : "3801023042",
      "display" : "薇晶中醫診所"
    },
    {
      "code" : "3801023079",
      "display" : "靖妃中醫診所"
    },
    {
      "code" : "3801023113",
      "display" : "華品中醫診所"
    },
    {
      "code" : "3801023186",
      "display" : "宜民時尚中醫診所"
    },
    {
      "code" : "3801023202",
      "display" : "景崧現代中醫診所"
    },
    {
      "code" : "3801023266",
      "display" : "甘露中醫診所"
    },
    {
      "code" : "3801023293",
      "display" : "大觀堂中醫診所"
    },
    {
      "code" : "3801023426",
      "display" : "昇陽中醫診所"
    },
    {
      "code" : "3801023480",
      "display" : "恩典中醫診所"
    },
    {
      "code" : "3801023499",
      "display" : "璞真中醫診所"
    },
    {
      "code" : "3801023542",
      "display" : "雅丰唯心中醫診所"
    },
    {
      "code" : "3801023560",
      "display" : "吉升堂中醫診所"
    },
    {
      "code" : "3801023604",
      "display" : "愛群中醫診所"
    },
    {
      "code" : "3801023613",
      "display" : "田安然中醫診所"
    },
    {
      "code" : "3801023659",
      "display" : "嵐亭中醫診所"
    },
    {
      "code" : "3801023668",
      "display" : "汾陽中醫診所"
    },
    {
      "code" : "3801023686",
      "display" : "陳運瑩中醫診所"
    },
    {
      "code" : "3801023720",
      "display" : "欣華安中醫診所"
    },
    {
      "code" : "3801023766",
      "display" : "奇璞光經方中醫診所"
    },
    {
      "code" : "3801023828",
      "display" : "大安悅兒親子中醫診所"
    },
    {
      "code" : "3801023846",
      "display" : "張若偉中醫診所"
    },
    {
      "code" : "3801023908",
      "display" : "陳光華中醫診所"
    },
    {
      "code" : "3801023944",
      "display" : "醫心堂中醫診所"
    },
    {
      "code" : "3801023962",
      "display" : "心齋中醫診所"
    },
    {
      "code" : "3801023999",
      "display" : "樂業中醫診所"
    },
    {
      "code" : "3801024003",
      "display" : "御守堂中醫診所"
    },
    {
      "code" : "3801024012",
      "display" : "和圓中醫診所"
    },
    {
      "code" : "3801024058",
      "display" : "天一堂中醫診所"
    },
    {
      "code" : "3801024067",
      "display" : "芊月堂中醫診所"
    },
    {
      "code" : "3801024094",
      "display" : "璽悅中醫診所"
    },
    {
      "code" : "3801024101",
      "display" : "鄭振鴻中醫診所"
    },
    {
      "code" : "3801024129",
      "display" : "禾頤中醫診所"
    },
    {
      "code" : "3801024138",
      "display" : "漢補世家中醫診所"
    },
    {
      "code" : "3801024147",
      "display" : "雲品中醫診所"
    },
    {
      "code" : "3801024192",
      "display" : "張惠琴中醫診所"
    },
    {
      "code" : "3801024218",
      "display" : "翰德國際中醫診所"
    },
    {
      "code" : "3801024227",
      "display" : "明悅中醫診所"
    },
    {
      "code" : "3801024236",
      "display" : "佑昌中醫診所"
    },
    {
      "code" : "3801024254",
      "display" : "上璽中醫診所"
    },
    {
      "code" : "3801024263",
      "display" : "元天中醫診所"
    },
    {
      "code" : "3801024281",
      "display" : "古亭京都堂中醫診所"
    },
    {
      "code" : "3801024352",
      "display" : "易明中醫診所"
    },
    {
      "code" : "3801024361",
      "display" : "康禾中醫診所"
    },
    {
      "code" : "3801024370",
      "display" : "京都堂中醫診所"
    },
    {
      "code" : "3801024389",
      "display" : "家中醫診所"
    },
    {
      "code" : "3801024398",
      "display" : "樂陽中醫診所"
    },
    {
      "code" : "3801024405",
      "display" : "葉姿麟中醫診所"
    },
    {
      "code" : "3801024432",
      "display" : "瑩中醫診所"
    },
    {
      "code" : "3801024441",
      "display" : "全相中醫診所"
    },
    {
      "code" : "3801024450",
      "display" : "鼎妍中醫診所"
    },
    {
      "code" : "3801024469",
      "display" : "愛群信安中醫診所"
    },
    {
      "code" : "3801024496",
      "display" : "大安中醫診所"
    },
    {
      "code" : "3801024503",
      "display" : "惠澤中醫診所"
    },
    {
      "code" : "3801024512",
      "display" : "忠孝昌盛堂中醫診所"
    },
    {
      "code" : "3801024521",
      "display" : "雲鼎中醫診所"
    },
    {
      "code" : "3801024558",
      "display" : "時英中醫診所"
    },
    {
      "code" : "3801024567",
      "display" : "覺世中醫診所"
    },
    {
      "code" : "3801024576",
      "display" : "勝安中醫診所"
    },
    {
      "code" : "3801024585",
      "display" : "百弘中醫診所"
    },
    {
      "code" : "3801024594",
      "display" : "德霖中醫診所"
    },
    {
      "code" : "3801024601",
      "display" : "詠恩中醫診所"
    },
    {
      "code" : "3801024629",
      "display" : "名漾中醫診所"
    },
    {
      "code" : "3801024638",
      "display" : "昱安中醫診所"
    },
    {
      "code" : "3801024647",
      "display" : "昇陽一品中醫診所"
    },
    {
      "code" : "3801024656",
      "display" : "保惠中醫診所"
    },
    {
      "code" : "3801024665",
      "display" : "彭燕婷中醫診所"
    },
    {
      "code" : "3801024674",
      "display" : "德霖中醫診所"
    },
    {
      "code" : "3801024683",
      "display" : "通化祥寧中醫診所"
    },
    {
      "code" : "3801024692",
      "display" : "國健中醫診所"
    },
    {
      "code" : "3801024709",
      "display" : "溫州泰昌堂中醫診所"
    },
    {
      "code" : "3801024718",
      "display" : "時英中醫診所"
    },
    {
      "code" : "3801024736",
      "display" : "師大昌盛堂中醫診所"
    },
    {
      "code" : "3801024745",
      "display" : "紹光中醫診所"
    },
    {
      "code" : "3801024754",
      "display" : "杏霖中醫診所"
    },
    {
      "code" : "3801024772",
      "display" : "大安漢補世家中醫診所"
    },
    {
      "code" : "3801024790",
      "display" : "芙曦中醫診所"
    },
    {
      "code" : "3801024816",
      "display" : "芙曦中醫診所"
    },
    {
      "code" : "3801024825",
      "display" : "雲濤中醫診所"
    },
    {
      "code" : "3801024834",
      "display" : "李瑞玉中醫診所"
    },
    {
      "code" : "3801024843",
      "display" : "易明中醫診所"
    },
    {
      "code" : "3801024852",
      "display" : "涂育嘉中醫診所"
    },
    {
      "code" : "3801024889",
      "display" : "翰醫堂復興中醫診所"
    },
    {
      "code" : "3801024905",
      "display" : "百合堂中醫診所"
    },
    {
      "code" : "3801024914",
      "display" : "樂活中醫診所"
    },
    {
      "code" : "3801024923",
      "display" : "大安中醫診所"
    },
    {
      "code" : "3801024932",
      "display" : "覺世中醫診所"
    },
    {
      "code" : "3801024941",
      "display" : "和楗中醫診所"
    },
    {
      "code" : "3801024950",
      "display" : "德霖中醫診所"
    },
    {
      "code" : "3801024969",
      "display" : "瑩中醫診所"
    },
    {
      "code" : "3801024978",
      "display" : "時英中醫診所"
    },
    {
      "code" : "3801024996",
      "display" : "忠孝祥寧中醫診所"
    },
    {
      "code" : "3801025019",
      "display" : "秀庭中醫診所"
    },
    {
      "code" : "3801025028",
      "display" : "桂枝香中醫診所"
    },
    {
      "code" : "3801025046",
      "display" : "安和泰昌堂中醫診所"
    },
    {
      "code" : "3801090098",
      "display" : "正記中醫診所"
    },
    {
      "code" : "3801090187",
      "display" : "信陽中醫診所"
    },
    {
      "code" : "3801090267",
      "display" : "陳潮宗中醫診所"
    },
    {
      "code" : "3801090356",
      "display" : "華源堂中醫診所"
    },
    {
      "code" : "3801090392",
      "display" : "廣順中醫診所"
    },
    {
      "code" : "3801090463",
      "display" : "保順中醫診所"
    },
    {
      "code" : "3801090801",
      "display" : "一聖堂中醫診所"
    },
    {
      "code" : "3801091040",
      "display" : "陳月琴中醫診所"
    },
    {
      "code" : "3801091344",
      "display" : "全生中醫診所"
    },
    {
      "code" : "3801092681",
      "display" : "御聖堂中醫診所"
    },
    {
      "code" : "3801092761",
      "display" : "立安中醫診所"
    },
    {
      "code" : "3801092976",
      "display" : "順天堂中醫診所"
    },
    {
      "code" : "3801092994",
      "display" : "林志宏中醫診所"
    },
    {
      "code" : "3801093008",
      "display" : "濟民中醫診所"
    },
    {
      "code" : "3801093124",
      "display" : "天一中醫診所"
    },
    {
      "code" : "3801093179",
      "display" : "明昇中醫診所"
    },
    {
      "code" : "3801093197",
      "display" : "重慶堂中醫診所"
    },
    {
      "code" : "3801093231",
      "display" : "頌華中醫診所"
    },
    {
      "code" : "3801093295",
      "display" : "楊基中醫診所"
    },
    {
      "code" : "3801093455",
      "display" : "翰鳴堂中醫診所"
    },
    {
      "code" : "3801093508",
      "display" : "吳忠澤中醫診所"
    },
    {
      "code" : "3801093517",
      "display" : "光點中醫診所"
    },
    {
      "code" : "3801093562",
      "display" : "原平中醫診所"
    },
    {
      "code" : "3801093606",
      "display" : "佳安中醫診所"
    },
    {
      "code" : "3801093660",
      "display" : "良元中醫診所"
    },
    {
      "code" : "3801093688",
      "display" : "新悅中醫診所"
    },
    {
      "code" : "3801093704",
      "display" : "學而中醫診所"
    },
    {
      "code" : "3801093713",
      "display" : "京水堂中醫診所"
    },
    {
      "code" : "3801093731",
      "display" : "琥珀中醫診所"
    },
    {
      "code" : "3801093740",
      "display" : "知田中醫診所"
    },
    {
      "code" : "3801093759",
      "display" : "雙連同仁中醫診所"
    },
    {
      "code" : "3801093768",
      "display" : "信賴堂中醫診所"
    },
    {
      "code" : "3801093777",
      "display" : "阡禾中醫診所"
    },
    {
      "code" : "3801093820",
      "display" : "迪化馬光中醫診所"
    },
    {
      "code" : "3801100017",
      "display" : "信德中醫診所"
    },
    {
      "code" : "3801100053",
      "display" : "德全中醫診所"
    },
    {
      "code" : "3801100526",
      "display" : "高麝芬中醫診所"
    },
    {
      "code" : "3801100679",
      "display" : "朝暉中醫診所"
    },
    {
      "code" : "3801100688",
      "display" : "有聲中醫診所"
    },
    {
      "code" : "3801100713",
      "display" : "福田中醫診所"
    },
    {
      "code" : "3801100722",
      "display" : "恩濟堂中醫診所"
    },
    {
      "code" : "3801100848",
      "display" : "漢明中醫診所"
    },
    {
      "code" : "3801100866",
      "display" : "滋和堂中醫診所"
    },
    {
      "code" : "3801100884",
      "display" : "鐳力中醫診所"
    },
    {
      "code" : "3801101201",
      "display" : "龍江中醫診所"
    },
    {
      "code" : "3801101210",
      "display" : "慎德堂中醫診所"
    },
    {
      "code" : "3801101274",
      "display" : "龍心堂中醫診所"
    },
    {
      "code" : "3801101283",
      "display" : "駿琳大直中醫診所"
    },
    {
      "code" : "3801101345",
      "display" : "京元中醫診所"
    },
    {
      "code" : "3801101354",
      "display" : "常生中醫診所"
    },
    {
      "code" : "3801101381",
      "display" : "元氣堂中醫診所"
    },
    {
      "code" : "3801101416",
      "display" : "仁心堂中醫診所"
    },
    {
      "code" : "3801101498",
      "display" : "文化中醫診所"
    },
    {
      "code" : "3801101505",
      "display" : "新生中醫診所"
    },
    {
      "code" : "3801101514",
      "display" : "漢坤中醫診所"
    },
    {
      "code" : "3801101961",
      "display" : "景欣中醫診所"
    },
    {
      "code" : "3801102002",
      "display" : "禾儒中醫診所"
    },
    {
      "code" : "3801102075",
      "display" : "長榮中醫診所"
    },
    {
      "code" : "3801102128",
      "display" : "延安中醫診所"
    },
    {
      "code" : "3801102137",
      "display" : "鼎昌中醫診所"
    },
    {
      "code" : "3801102146",
      "display" : "品君中醫診所"
    },
    {
      "code" : "3801102155",
      "display" : "傳愛經典中醫診所"
    },
    {
      "code" : "3801102173",
      "display" : "澄觀中醫診所"
    },
    {
      "code" : "3801102182",
      "display" : "居仁堂中醫診所"
    },
    {
      "code" : "3801102235",
      "display" : "杜李威中醫診所"
    },
    {
      "code" : "3801102262",
      "display" : "王倩梅中醫診所"
    },
    {
      "code" : "3801102299",
      "display" : "詠生中醫診所"
    },
    {
      "code" : "3801102315",
      "display" : "益曼中醫診所"
    },
    {
      "code" : "3801102333",
      "display" : "東仁中醫診所"
    },
    {
      "code" : "3801102388",
      "display" : "漢研中醫診所"
    },
    {
      "code" : "3801102404",
      "display" : "林佳瑩中醫診所"
    },
    {
      "code" : "3801102431",
      "display" : "祺祥中醫診所"
    },
    {
      "code" : "3801102440",
      "display" : "得原中醫診所"
    },
    {
      "code" : "3801102459",
      "display" : "璞心中醫診所"
    },
    {
      "code" : "3801102502",
      "display" : "大直北安中醫診所"
    },
    {
      "code" : "3801102539",
      "display" : "學德堂中醫診所"
    },
    {
      "code" : "3801102548",
      "display" : "雲門中醫診所"
    },
    {
      "code" : "3801102557",
      "display" : "林國榮中醫診所"
    },
    {
      "code" : "3801102566",
      "display" : "宏品中醫診所"
    },
    {
      "code" : "3801102575",
      "display" : "昌盛堂中醫診所"
    },
    {
      "code" : "3801102584",
      "display" : "祥瑞堂中醫診所"
    },
    {
      "code" : "3801102619",
      "display" : "興安養生堂中醫診所"
    },
    {
      "code" : "3801102637",
      "display" : "力慈科學中醫診所"
    },
    {
      "code" : "3801102664",
      "display" : "新昇中醫診所"
    },
    {
      "code" : "3801102691",
      "display" : "正元中醫診所"
    },
    {
      "code" : "3801102708",
      "display" : "京華中醫診所"
    },
    {
      "code" : "3801102717",
      "display" : "吉林中醫診所"
    },
    {
      "code" : "3801102726",
      "display" : "科學中醫診所"
    },
    {
      "code" : "3801102735",
      "display" : "南京京都堂中醫診所"
    },
    {
      "code" : "3801102744",
      "display" : "馥林中醫診所"
    },
    {
      "code" : "3801102753",
      "display" : "芸安堂中醫診所"
    },
    {
      "code" : "3801102762",
      "display" : "集英中醫診所"
    },
    {
      "code" : "3801102771",
      "display" : "雙連中醫診所"
    },
    {
      "code" : "3801102780",
      "display" : "濱江中醫診所"
    },
    {
      "code" : "3801102806",
      "display" : "御通中醫診所"
    },
    {
      "code" : "3801102815",
      "display" : "聆心中醫診所"
    },
    {
      "code" : "3801102824",
      "display" : "國興中醫診所"
    },
    {
      "code" : "3801102833",
      "display" : "勝耀中醫診所"
    },
    {
      "code" : "3801102842",
      "display" : "醫誠堂中醫診所"
    },
    {
      "code" : "3801102851",
      "display" : "麗風堂中醫診所"
    },
    {
      "code" : "3801102860",
      "display" : "晴光中醫診所"
    },
    {
      "code" : "3801102879",
      "display" : "和心中醫診所"
    },
    {
      "code" : "3801102888",
      "display" : "聖璽中醫診所"
    },
    {
      "code" : "3801102897",
      "display" : "祐瑞中醫診所"
    },
    {
      "code" : "3801102904",
      "display" : "漢補世家中醫診所"
    },
    {
      "code" : "3801102913",
      "display" : "澄玥中醫診所"
    },
    {
      "code" : "3801102922",
      "display" : "益壽堂中醫診所"
    },
    {
      "code" : "3801102931",
      "display" : "聖璽中醫診所"
    },
    {
      "code" : "3801102940",
      "display" : "科學中醫診所"
    },
    {
      "code" : "3801102959",
      "display" : "吉林中醫診所"
    },
    {
      "code" : "3801102977",
      "display" : "斯林中醫診所"
    },
    {
      "code" : "3801102986",
      "display" : "龍江中醫診所"
    },
    {
      "code" : "3801103009",
      "display" : "劉氏松鶴中醫診所"
    },
    {
      "code" : "3801103018",
      "display" : "太初中醫診所"
    },
    {
      "code" : "3801103027",
      "display" : "八通關中醫診所"
    },
    {
      "code" : "3801103045",
      "display" : "聖璽中醫診所"
    },
    {
      "code" : "3801103054",
      "display" : "楊基中醫診所"
    },
    {
      "code" : "3801103063",
      "display" : "日禾中醫診所"
    },
    {
      "code" : "3801103072",
      "display" : "潤中醫診所"
    },
    {
      "code" : "3801103081",
      "display" : "吉林中醫診所"
    },
    {
      "code" : "3801103090",
      "display" : "斯林中醫診所"
    },
    {
      "code" : "3801103107",
      "display" : "帖人中醫診所"
    },
    {
      "code" : "3801103125",
      "display" : "聖璽中醫診所"
    },
    {
      "code" : "3801103134",
      "display" : "京元中醫診所"
    },
    {
      "code" : "3801103143",
      "display" : "長榮中醫診所"
    },
    {
      "code" : "3801103152",
      "display" : "康銓中醫診所"
    },
    {
      "code" : "3801103161",
      "display" : "大直錦禾中醫診所"
    },
    {
      "code" : "3801103170",
      "display" : "中漢良中醫診所"
    },
    {
      "code" : "3801103189",
      "display" : "聖陽堂中醫診所"
    },
    {
      "code" : "3801103214",
      "display" : "吉玥中醫診所"
    },
    {
      "code" : "3801103232",
      "display" : "翰醫堂中山中醫診所"
    },
    {
      "code" : "3801103241",
      "display" : "南京京都堂中醫診所"
    },
    {
      "code" : "3801110086",
      "display" : "卓家泉安堂老舖中醫診所"
    },
    {
      "code" : "3801110102",
      "display" : "林德中醫診所"
    },
    {
      "code" : "3801110200",
      "display" : "蘇中醫診所"
    },
    {
      "code" : "3801110288",
      "display" : "內湖中醫診所"
    },
    {
      "code" : "3801111403",
      "display" : "祐康中醫診所"
    },
    {
      "code" : "3801111510",
      "display" : "璟榮中醫診所"
    },
    {
      "code" : "3801111609",
      "display" : "憫泰中醫診所"
    },
    {
      "code" : "3801111663",
      "display" : "健崴中醫診所"
    },
    {
      "code" : "3801111672",
      "display" : "萬安堂中醫診所"
    },
    {
      "code" : "3801111681",
      "display" : "和慶中醫診所"
    },
    {
      "code" : "3801111716",
      "display" : "鴻成中醫診所"
    },
    {
      "code" : "3801111725",
      "display" : "聿麒中醫診所"
    },
    {
      "code" : "3801111798",
      "display" : "龍門中醫診所"
    },
    {
      "code" : "3801111841",
      "display" : "麗馨中醫診所"
    },
    {
      "code" : "3801111850",
      "display" : "騏安中醫診所"
    },
    {
      "code" : "3801111903",
      "display" : "文華內湖中醫診所"
    },
    {
      "code" : "3801111921",
      "display" : "双湖中醫診所"
    },
    {
      "code" : "3801111930",
      "display" : "允康中醫診所"
    },
    {
      "code" : "3801111967",
      "display" : "韻德中醫診所"
    },
    {
      "code" : "3801111985",
      "display" : "錦禾中醫診所"
    },
    {
      "code" : "3801111994",
      "display" : "臻澄中醫診所"
    },
    {
      "code" : "3801112008",
      "display" : "恩光中醫診所"
    },
    {
      "code" : "3801112026",
      "display" : "建榮中醫診所"
    },
    {
      "code" : "3801112035",
      "display" : "鍾醫中醫診所"
    },
    {
      "code" : "3801112062",
      "display" : "詠樂中醫診所"
    },
    {
      "code" : "3801112071",
      "display" : "善品中醫診所"
    },
    {
      "code" : "3801112080",
      "display" : "信任中醫診所"
    },
    {
      "code" : "3801112099",
      "display" : "瀚威中醫診所"
    },
    {
      "code" : "3801112106",
      "display" : "泰興中醫診所"
    },
    {
      "code" : "3801112115",
      "display" : "照境中醫診所"
    },
    {
      "code" : "3801112133",
      "display" : "圓覺中醫診所"
    },
    {
      "code" : "3801112142",
      "display" : "建榮中醫診所"
    },
    {
      "code" : "3801112151",
      "display" : "詠樂中醫診所"
    },
    {
      "code" : "3801112160",
      "display" : "佳鄰中醫診所"
    },
    {
      "code" : "3801112179",
      "display" : "濟淵堂中醫診所"
    },
    {
      "code" : "3801112188",
      "display" : "內湖芸安堂中醫診所"
    },
    {
      "code" : "3801112197",
      "display" : "湖光杞子中醫診所"
    },
    {
      "code" : "3801112204",
      "display" : "臻悅中醫診所"
    },
    {
      "code" : "3801112213",
      "display" : "睦顏中醫診所"
    },
    {
      "code" : "3801112222",
      "display" : "濟淵堂中醫診所"
    },
    {
      "code" : "3801112231",
      "display" : "善熙中醫診所"
    },
    {
      "code" : "3801112240",
      "display" : "文德橡實中醫診所"
    },
    {
      "code" : "3801112259",
      "display" : "內湖川岳中醫診所"
    },
    {
      "code" : "3801112268",
      "display" : "禾妍堂中醫診所"
    },
    {
      "code" : "3801112277",
      "display" : "臻慕中醫診所"
    },
    {
      "code" : "3801120028",
      "display" : "洪澤安中醫診所"
    },
    {
      "code" : "3801121169",
      "display" : "天滋中醫診所"
    },
    {
      "code" : "3801121212",
      "display" : "聖原中醫診所"
    },
    {
      "code" : "3801121221",
      "display" : "宏勝中醫診所"
    },
    {
      "code" : "3801121230",
      "display" : "翰林中醫診所"
    },
    {
      "code" : "3801121249",
      "display" : "龍銓中醫診所"
    },
    {
      "code" : "3801121258",
      "display" : "羅撒中醫診所"
    },
    {
      "code" : "3801121276",
      "display" : "張一凡中醫診所"
    },
    {
      "code" : "3801121285",
      "display" : "赫奕中醫診所"
    },
    {
      "code" : "3801121301",
      "display" : "同德中醫診所"
    },
    {
      "code" : "3801121310",
      "display" : "杞子中醫診所"
    },
    {
      "code" : "3801121329",
      "display" : "戴承杰中醫診所"
    },
    {
      "code" : "3801121338",
      "display" : "漢唐經方中醫診所"
    },
    {
      "code" : "3801121347",
      "display" : "漢唐經方中醫診所"
    },
    {
      "code" : "3801121356",
      "display" : "南港泰興中醫診所"
    },
    {
      "code" : "3801121365",
      "display" : "杞子中醫診所"
    },
    {
      "code" : "3801150044",
      "display" : "存安堂中醫診所"
    },
    {
      "code" : "3801150179",
      "display" : "政德中醫診所"
    },
    {
      "code" : "3801150188",
      "display" : "信愛中醫診所"
    },
    {
      "code" : "3801150339",
      "display" : "栢宏中醫診所"
    },
    {
      "code" : "3801150348",
      "display" : "新長庚中醫診所"
    },
    {
      "code" : "3801150384",
      "display" : "易元堂中醫診所"
    },
    {
      "code" : "3801150393",
      "display" : "寬安中醫診所"
    },
    {
      "code" : "3801150446",
      "display" : "瀚儒中醫診所"
    },
    {
      "code" : "3801150455",
      "display" : "天母中醫診所"
    },
    {
      "code" : "3801150491",
      "display" : "常甡中醫診所"
    },
    {
      "code" : "3801150508",
      "display" : "顏居雲中醫診所"
    },
    {
      "code" : "3801151612",
      "display" : "士東中醫診所"
    },
    {
      "code" : "3801151649",
      "display" : "普濟中醫診所"
    },
    {
      "code" : "3801151667",
      "display" : "仰德中醫診所"
    },
    {
      "code" : "3801151694",
      "display" : "福華中醫診所"
    },
    {
      "code" : "3801151818",
      "display" : "易和中醫診所"
    },
    {
      "code" : "3801151827",
      "display" : "慶昇中醫診所"
    },
    {
      "code" : "3801151836",
      "display" : "漢醫堂中醫診所"
    },
    {
      "code" : "3801151845",
      "display" : "惠眾中醫診所"
    },
    {
      "code" : "3801151890",
      "display" : "天御中醫診所"
    },
    {
      "code" : "3801151916",
      "display" : "保晟中醫診所"
    },
    {
      "code" : "3801151952",
      "display" : "天方中醫診所"
    },
    {
      "code" : "3801152002",
      "display" : "一春堂中醫診所"
    },
    {
      "code" : "3801152075",
      "display" : "歐彥君中醫診所"
    },
    {
      "code" : "3801152093",
      "display" : "昀樣中醫診所"
    },
    {
      "code" : "3801152100",
      "display" : "崇生中醫診所"
    },
    {
      "code" : "3801152182",
      "display" : "世康中醫診所"
    },
    {
      "code" : "3801152235",
      "display" : "澄隆中醫診所"
    },
    {
      "code" : "3801152244",
      "display" : "仁佑中醫診所"
    },
    {
      "code" : "3801152333",
      "display" : "畢士大中醫診所"
    },
    {
      "code" : "3801152342",
      "display" : "悅展中醫診所"
    },
    {
      "code" : "3801152388",
      "display" : "指筌中醫診所"
    },
    {
      "code" : "3801152397",
      "display" : "源遠堂中醫診所"
    },
    {
      "code" : "3801152404",
      "display" : "同慶中醫診所"
    },
    {
      "code" : "3801152422",
      "display" : "寶安中醫診所"
    },
    {
      "code" : "3801152431",
      "display" : "芝音中醫診所"
    },
    {
      "code" : "3801152459",
      "display" : "劍潭中醫診所"
    },
    {
      "code" : "3801152468",
      "display" : "承新中醫診所"
    },
    {
      "code" : "3801152477",
      "display" : "社子中醫診所"
    },
    {
      "code" : "3801152486",
      "display" : "承德中醫診所"
    },
    {
      "code" : "3801152495",
      "display" : "百齡中醫診所"
    },
    {
      "code" : "3801152511",
      "display" : "蓉平中醫診所"
    },
    {
      "code" : "3801152539",
      "display" : "士林錦禾中醫診所"
    },
    {
      "code" : "3801152548",
      "display" : "存德中醫診所"
    },
    {
      "code" : "3801152557",
      "display" : "士林同仁中醫診所"
    },
    {
      "code" : "3801152593",
      "display" : "泓景中醫診所"
    },
    {
      "code" : "3801152600",
      "display" : "泰昌堂中醫診所"
    },
    {
      "code" : "3801152628",
      "display" : "天梁堂中醫診所"
    },
    {
      "code" : "3801152637",
      "display" : "璟元中醫診所"
    },
    {
      "code" : "3801152646",
      "display" : "爾康中醫診所"
    },
    {
      "code" : "3801152655",
      "display" : "天宇中醫診所"
    },
    {
      "code" : "3801152664",
      "display" : "茂澤中醫診所"
    },
    {
      "code" : "3801152673",
      "display" : "梅花中醫診所"
    },
    {
      "code" : "3801152691",
      "display" : "美福中醫診所"
    },
    {
      "code" : "3801152708",
      "display" : "承新中醫診所"
    },
    {
      "code" : "3801152717",
      "display" : "仁慈中醫診所"
    },
    {
      "code" : "3801160077",
      "display" : "人德中醫診所"
    },
    {
      "code" : "3801160102",
      "display" : "順建中醫診所"
    },
    {
      "code" : "3801160184",
      "display" : "耕德中醫診所"
    },
    {
      "code" : "3801160273",
      "display" : "茂元中醫診所"
    },
    {
      "code" : "3801160317",
      "display" : "華杏中醫診所"
    },
    {
      "code" : "3801161467",
      "display" : "東華中醫診所"
    },
    {
      "code" : "3801161476",
      "display" : "慈愛中醫診所"
    },
    {
      "code" : "3801161510",
      "display" : "十方中醫診所"
    },
    {
      "code" : "3801161547",
      "display" : "懸壺中醫診所"
    },
    {
      "code" : "3801161556",
      "display" : "懷德中醫診所"
    },
    {
      "code" : "3801161565",
      "display" : "普生中醫診所"
    },
    {
      "code" : "3801161583",
      "display" : "康禾堂中醫診所"
    },
    {
      "code" : "3801161654",
      "display" : "北投華夏中醫診所"
    },
    {
      "code" : "3801161663",
      "display" : "逢春中醫診所"
    },
    {
      "code" : "3801161672",
      "display" : "大易中醫診所"
    },
    {
      "code" : "3801161716",
      "display" : "豐禾中醫診所"
    },
    {
      "code" : "3801161734",
      "display" : "佳禾中醫診所"
    },
    {
      "code" : "3801161789",
      "display" : "定傳中醫診所"
    },
    {
      "code" : "3801161850",
      "display" : "石牌尊賢中醫診所"
    },
    {
      "code" : "3801161887",
      "display" : "悅馨中醫診所"
    },
    {
      "code" : "3801161896",
      "display" : "和悅經典中醫診所"
    },
    {
      "code" : "3801161903",
      "display" : "三合中醫診所"
    },
    {
      "code" : "3801161930",
      "display" : "全禾中醫診所"
    },
    {
      "code" : "3801161958",
      "display" : "健群中醫診所"
    },
    {
      "code" : "3801161976",
      "display" : "天璽中醫診所"
    },
    {
      "code" : "3801162008",
      "display" : "光美中醫診所"
    },
    {
      "code" : "3801162017",
      "display" : "善揚中醫診所"
    },
    {
      "code" : "3801162026",
      "display" : "謙懿中醫診所"
    },
    {
      "code" : "3801162035",
      "display" : "健群中醫診所"
    },
    {
      "code" : "3801162044",
      "display" : "潔品中醫診所"
    },
    {
      "code" : "3801162053",
      "display" : "隆豪中醫診所"
    },
    {
      "code" : "3801162071",
      "display" : "三進中醫診所"
    },
    {
      "code" : "3801162080",
      "display" : "沐荷中醫診所"
    },
    {
      "code" : "3801162099",
      "display" : "健群中醫診所"
    },
    {
      "code" : "3801162106",
      "display" : "人德中醫診所"
    },
    {
      "code" : "3801170064",
      "display" : "蔡榮鏡中醫診所"
    },
    {
      "code" : "3801170082",
      "display" : "欣佑許寶童中醫診所"
    },
    {
      "code" : "3801170162",
      "display" : "進安中醫診所"
    },
    {
      "code" : "3801170171",
      "display" : "錦德中醫診所"
    },
    {
      "code" : "3801170279",
      "display" : "三稜中醫診所"
    },
    {
      "code" : "3801170322",
      "display" : "陽明中醫診所"
    },
    {
      "code" : "3801170644",
      "display" : "大同中醫診所"
    },
    {
      "code" : "3801170733",
      "display" : "健生堂中醫診所"
    },
    {
      "code" : "3801171829",
      "display" : "健銨中醫診所"
    },
    {
      "code" : "3801171918",
      "display" : "成功中醫診所"
    },
    {
      "code" : "3801171927",
      "display" : "寶晟紀中醫診所"
    },
    {
      "code" : "3801171945",
      "display" : "聖心中醫診所"
    },
    {
      "code" : "3801172059",
      "display" : "聖醫中醫診所"
    },
    {
      "code" : "3801172095",
      "display" : "大成中醫診所"
    },
    {
      "code" : "3801172120",
      "display" : "世芳中醫診所"
    },
    {
      "code" : "3801172148",
      "display" : "天元中醫診所"
    },
    {
      "code" : "3801172193",
      "display" : "陳士源中醫診所"
    },
    {
      "code" : "3801172344",
      "display" : "格康中醫診所"
    },
    {
      "code" : "3801172362",
      "display" : "長安中醫診所"
    },
    {
      "code" : "3801172433",
      "display" : "鐵椎中醫診所"
    },
    {
      "code" : "3801172460",
      "display" : "興漢中醫診所"
    },
    {
      "code" : "3801172497",
      "display" : "梁美鳳中醫診所"
    },
    {
      "code" : "3801172504",
      "display" : "康華中醫診所"
    },
    {
      "code" : "3801172602",
      "display" : "昱華中醫診所"
    },
    {
      "code" : "3801172648",
      "display" : "佳合中醫診所"
    },
    {
      "code" : "3801172666",
      "display" : "岐綝中醫診所"
    },
    {
      "code" : "3801172693",
      "display" : "頂心中醫診所"
    },
    {
      "code" : "3801172700",
      "display" : "微笑中醫診所"
    },
    {
      "code" : "3801172719",
      "display" : "心悅中醫診所"
    },
    {
      "code" : "3801172737",
      "display" : "宏森中醫診所"
    },
    {
      "code" : "3801172808",
      "display" : "歸元中醫診所"
    },
    {
      "code" : "3801172835",
      "display" : "太淵中醫診所"
    },
    {
      "code" : "3801172844",
      "display" : "元貞中醫診所"
    },
    {
      "code" : "3801172862",
      "display" : "陳彥良中醫診所"
    },
    {
      "code" : "3801172880",
      "display" : "濟德中醫診所"
    },
    {
      "code" : "3801172906",
      "display" : "頌讚中醫診所"
    },
    {
      "code" : "3801172933",
      "display" : "昫安中醫診所"
    },
    {
      "code" : "3801172960",
      "display" : "國暉中醫診所"
    },
    {
      "code" : "3801172979",
      "display" : "之華中醫診所"
    },
    {
      "code" : "3801172988",
      "display" : "慈護晶璽中醫診所"
    },
    {
      "code" : "3801173001",
      "display" : "慈昱中醫診所"
    },
    {
      "code" : "3801173010",
      "display" : "永吉中醫診所"
    },
    {
      "code" : "3801173029",
      "display" : "新六福堂中醫診所"
    },
    {
      "code" : "3801173038",
      "display" : "景得中醫診所"
    },
    {
      "code" : "3801173065",
      "display" : "青禾中醫診所"
    },
    {
      "code" : "3801173074",
      "display" : "沄禾中醫診所"
    },
    {
      "code" : "3801173083",
      "display" : "詠淳中醫診所"
    },
    {
      "code" : "3801173092",
      "display" : "昱明中醫診所"
    },
    {
      "code" : "3801173118",
      "display" : "松山漢唐中醫診所"
    },
    {
      "code" : "3801173127",
      "display" : "杏中醫診所"
    },
    {
      "code" : "3801173145",
      "display" : "大曜中醫診所"
    },
    {
      "code" : "3801173163",
      "display" : "信義順祿中醫診所"
    },
    {
      "code" : "3801173172",
      "display" : "信義順祿中醫診所"
    },
    {
      "code" : "3801173190",
      "display" : "象山中醫診所"
    },
    {
      "code" : "3801173207",
      "display" : "信義馬光中醫診所"
    },
    {
      "code" : "3801173234",
      "display" : "福鈺中醫診所"
    },
    {
      "code" : "3801173243",
      "display" : "沐澄中醫診所"
    },
    {
      "code" : "3801180042",
      "display" : "幸吉堂中醫診所"
    },
    {
      "code" : "3801180293",
      "display" : "漢神中醫診所"
    },
    {
      "code" : "3801180346",
      "display" : "同安中醫診所"
    },
    {
      "code" : "3801180480",
      "display" : "仁愛中醫診所"
    },
    {
      "code" : "3801180499",
      "display" : "德義堂中醫診所"
    },
    {
      "code" : "3801180551",
      "display" : "吳龍源中醫診所"
    },
    {
      "code" : "3801180604",
      "display" : "寧波中醫診所"
    },
    {
      "code" : "3801180695",
      "display" : "珍仁堂中醫診所"
    },
    {
      "code" : "3801181852",
      "display" : "儒德中醫診所"
    },
    {
      "code" : "3801181870",
      "display" : "和平中醫診所"
    },
    {
      "code" : "3801181889",
      "display" : "李明潤中醫診所"
    },
    {
      "code" : "3801181898",
      "display" : "順天中醫診所"
    },
    {
      "code" : "3801181914",
      "display" : "勝昌現代中醫診所"
    },
    {
      "code" : "3801182064",
      "display" : "恆美中醫診所"
    },
    {
      "code" : "3801182108",
      "display" : "洪麗妃中醫診所"
    },
    {
      "code" : "3801182126",
      "display" : "張順晶中醫診所"
    },
    {
      "code" : "3801182135",
      "display" : "嘉柏中醫診所"
    },
    {
      "code" : "3801182153",
      "display" : "劉桂蘭中醫診所"
    },
    {
      "code" : "3801182215",
      "display" : "寶生堂中醫診所"
    },
    {
      "code" : "3801182224",
      "display" : "長德中醫診所"
    },
    {
      "code" : "3801182288",
      "display" : "峻毅中醫診所"
    },
    {
      "code" : "3801182322",
      "display" : "永康中醫診所"
    },
    {
      "code" : "3801182331",
      "display" : "佳譽堂中醫診所"
    },
    {
      "code" : "3801182359",
      "display" : "仲景中醫診所"
    },
    {
      "code" : "3801182386",
      "display" : "華御中醫診所"
    },
    {
      "code" : "3801182420",
      "display" : "日明耀中醫診所"
    },
    {
      "code" : "3801182475",
      "display" : "華陽中醫診所"
    },
    {
      "code" : "3801182484",
      "display" : "益壽中醫診所"
    },
    {
      "code" : "3801182573",
      "display" : "李思儀中醫診所"
    },
    {
      "code" : "3801182582",
      "display" : "宏達中醫診所"
    },
    {
      "code" : "3801182626",
      "display" : "榮星中醫診所"
    },
    {
      "code" : "3801182671",
      "display" : "六節中醫診所"
    },
    {
      "code" : "3801182706",
      "display" : "喜豐堂中醫診所"
    },
    {
      "code" : "3801182724",
      "display" : "時代中醫診所"
    },
    {
      "code" : "3801182733",
      "display" : "天心中醫診所"
    },
    {
      "code" : "3801182742",
      "display" : "東門中醫診所"
    },
    {
      "code" : "3801182760",
      "display" : "茂澤中醫診所"
    },
    {
      "code" : "3801182788",
      "display" : "汀洲中醫診所"
    },
    {
      "code" : "3801182797",
      "display" : "厚德中醫診所"
    },
    {
      "code" : "3801182804",
      "display" : "怡安堂中醫診所"
    },
    {
      "code" : "3801182822",
      "display" : "極上中醫診所"
    },
    {
      "code" : "3801182831",
      "display" : "慕義中醫診所"
    },
    {
      "code" : "3801182840",
      "display" : "彭燕婷中醫診所"
    },
    {
      "code" : "3801182868",
      "display" : "拾光新生中醫診所"
    },
    {
      "code" : "3801182877",
      "display" : "羅福中醫診所"
    },
    {
      "code" : "3801182895",
      "display" : "南陽中醫診所"
    },
    {
      "code" : "3801182911",
      "display" : "溪垣中醫診所"
    },
    {
      "code" : "3801182920",
      "display" : "大道中醫診所"
    },
    {
      "code" : "3801182939",
      "display" : "睿鳴堂中醫診所"
    },
    {
      "code" : "3801182948",
      "display" : "建成中醫診所"
    },
    {
      "code" : "3801182966",
      "display" : "松澤中醫診所"
    },
    {
      "code" : "3801182975",
      "display" : "慧明中醫診所"
    },
    {
      "code" : "3801182984",
      "display" : "侑澄中醫診所"
    },
    {
      "code" : "3801183007",
      "display" : "建成中醫診所"
    },
    {
      "code" : "3801183016",
      "display" : "楓樂中醫診所"
    },
    {
      "code" : "3801183034",
      "display" : "晉暘中醫診所"
    },
    {
      "code" : "3801190039",
      "display" : "瑞安堂中醫診所"
    },
    {
      "code" : "3801190048",
      "display" : "常懿中醫診所"
    },
    {
      "code" : "3801190057",
      "display" : "冬水中醫診所"
    },
    {
      "code" : "3801190388",
      "display" : "播生中醫診所"
    },
    {
      "code" : "3801190440",
      "display" : "原億中醫診所"
    },
    {
      "code" : "3801190511",
      "display" : "張碧蓮中醫診所"
    },
    {
      "code" : "3801192515",
      "display" : "漢方中醫聯合診所"
    },
    {
      "code" : "3801193987",
      "display" : "守謙中醫診所"
    },
    {
      "code" : "3801194064",
      "display" : "群笙中醫診所"
    },
    {
      "code" : "3801194082",
      "display" : "旭生中醫診所"
    },
    {
      "code" : "3801194108",
      "display" : "聯安中醫診所"
    },
    {
      "code" : "3801194224",
      "display" : "程惠政中醫診所"
    },
    {
      "code" : "3801194313",
      "display" : "丞安堂中醫診所"
    },
    {
      "code" : "3801194322",
      "display" : "全心中醫診所"
    },
    {
      "code" : "3801194331",
      "display" : "王新于中醫診所"
    },
    {
      "code" : "3801194457",
      "display" : "興宏中醫診所"
    },
    {
      "code" : "3801194466",
      "display" : "致元中醫診所"
    },
    {
      "code" : "3801194484",
      "display" : "岐善中醫診所"
    },
    {
      "code" : "3801194493",
      "display" : "仁善美中醫診所"
    },
    {
      "code" : "3801194573",
      "display" : "博安中醫診所"
    },
    {
      "code" : "3801194582",
      "display" : "昱安堂中醫診所"
    },
    {
      "code" : "3801194591",
      "display" : "博華中醫診所"
    },
    {
      "code" : "3801194608",
      "display" : "馥毓中醫診所"
    },
    {
      "code" : "3801194617",
      "display" : "億靇中醫診所"
    },
    {
      "code" : "3801194635",
      "display" : "全昌堂中醫診所"
    },
    {
      "code" : "3801194662",
      "display" : "蓮樺中醫診所"
    },
    {
      "code" : "3801194680",
      "display" : "元祐中醫診所"
    },
    {
      "code" : "3801194699",
      "display" : "鴻海中醫診所"
    },
    {
      "code" : "3801194706",
      "display" : "鴻海中醫診所"
    },
    {
      "code" : "3801194715",
      "display" : "博安中醫診所"
    },
    {
      "code" : "3801194724",
      "display" : "唐門中醫診所"
    },
    {
      "code" : "3801194733",
      "display" : "廣益中醫診所"
    },
    {
      "code" : "3801194742",
      "display" : "蓮樺中醫診所"
    },
    {
      "code" : "3801194751",
      "display" : "醫略中醫診所"
    },
    {
      "code" : "3801194760",
      "display" : "丞安堂中醫診所"
    },
    {
      "code" : "3801200030",
      "display" : "意一堂中醫診所"
    },
    {
      "code" : "3801200068",
      "display" : "陳鐵誠中醫診所"
    },
    {
      "code" : "3801200076",
      "display" : "信願堂中醫診所"
    },
    {
      "code" : "3801200094",
      "display" : "生德堂中醫診所"
    },
    {
      "code" : "3801200165",
      "display" : "黃嘉欣中醫診所"
    },
    {
      "code" : "3801200183",
      "display" : "乾元中醫診所"
    },
    {
      "code" : "3801200192",
      "display" : "東山中醫診所"
    },
    {
      "code" : "3801200236",
      "display" : "豫章堂中醫診所"
    },
    {
      "code" : "3801200254",
      "display" : "元昌堂中醫診所"
    },
    {
      "code" : "3801201313",
      "display" : "宏福中醫診所"
    },
    {
      "code" : "3801201402",
      "display" : "天和堂中醫診所"
    },
    {
      "code" : "3801201448",
      "display" : "耿誠中醫診所"
    },
    {
      "code" : "3801201475",
      "display" : "吳明珠中醫診所"
    },
    {
      "code" : "3801201500",
      "display" : "長青傳統中醫診所"
    },
    {
      "code" : "3801201546",
      "display" : "育德堂中醫診所"
    },
    {
      "code" : "3801201555",
      "display" : "元品中醫診所"
    },
    {
      "code" : "3801201582",
      "display" : "張純龍中醫診所"
    },
    {
      "code" : "3801201617",
      "display" : "安德中醫診所"
    },
    {
      "code" : "3801201644",
      "display" : "寶顧中醫診所"
    },
    {
      "code" : "3801201671",
      "display" : "慧安堂中醫診所"
    },
    {
      "code" : "3801201706",
      "display" : "游正賢中醫診所"
    },
    {
      "code" : "3801201760",
      "display" : "常春藤中醫診所"
    },
    {
      "code" : "3801201779",
      "display" : "保儀中醫診所"
    },
    {
      "code" : "3801201788",
      "display" : "真善美中醫診所"
    },
    {
      "code" : "3801201804",
      "display" : "楊麗姝中醫診所"
    },
    {
      "code" : "3801201822",
      "display" : "京順中醫診所"
    },
    {
      "code" : "3801201840",
      "display" : "聞容中醫診所"
    },
    {
      "code" : "3801201859",
      "display" : "星福中醫診所"
    },
    {
      "code" : "3801201868",
      "display" : "玉函中醫診所"
    },
    {
      "code" : "3801201877",
      "display" : "至善醫坊中醫診所"
    },
    {
      "code" : "3801201886",
      "display" : "千順中醫診所"
    },
    {
      "code" : "3801201895",
      "display" : "養生堂中醫診所"
    },
    {
      "code" : "3801201911",
      "display" : "雙全漢醫中醫診所"
    },
    {
      "code" : "3801201920",
      "display" : "合春中醫診所"
    },
    {
      "code" : "3801201939",
      "display" : "養生堂中醫診所"
    },
    {
      "code" : "3801201948",
      "display" : "德方中醫診所"
    },
    {
      "code" : "3801201957",
      "display" : "合春中醫診所"
    },
    {
      "code" : "3801201966",
      "display" : "長青傳統中醫診所"
    },
    {
      "code" : "3801201975",
      "display" : "禎美中醫診所"
    },
    {
      "code" : "3801201984",
      "display" : "泰明堂中醫診所"
    },
    {
      "code" : "3801201993",
      "display" : "晴明中醫診所"
    },
    {
      "code" : "3801202007",
      "display" : "至善醫坊中醫診所"
    },
    {
      "code" : "3801202016",
      "display" : "安心堂中醫診所"
    },
    {
      "code" : "3801202025",
      "display" : "臻和中醫診所"
    },
    {
      "code" : "3801202034",
      "display" : "泰明堂中醫診所"
    },
    {
      "code" : "3801202052",
      "display" : "頤光中醫診所"
    },
    {
      "code" : "3811010084",
      "display" : "慈恩中醫診所"
    },
    {
      "code" : "3811010100",
      "display" : "陳字斌中醫診所"
    },
    {
      "code" : "3811011349",
      "display" : "邵秉家中醫診所"
    },
    {
      "code" : "3811011394",
      "display" : "天仁中醫診所"
    },
    {
      "code" : "3811011410",
      "display" : "協和中醫診所"
    },
    {
      "code" : "3811011465",
      "display" : "忠生中醫診所"
    },
    {
      "code" : "3811011474",
      "display" : "明和中醫診所"
    },
    {
      "code" : "3811011483",
      "display" : "張浩緯中醫診所"
    },
    {
      "code" : "3811011492",
      "display" : "新豐杏子中醫診所"
    },
    {
      "code" : "3811020035",
      "display" : "阿蔓中醫診所"
    },
    {
      "code" : "3811020044",
      "display" : "佳緣中醫診所"
    },
    {
      "code" : "3811021176",
      "display" : "蓁禾中醫診所"
    },
    {
      "code" : "3811021185",
      "display" : "鈺峰中醫診所"
    },
    {
      "code" : "3811021201",
      "display" : "廣濟堂中醫診所"
    },
    {
      "code" : "3811021210",
      "display" : "鈺筌中醫診所"
    },
    {
      "code" : "3811021229",
      "display" : "慈靉中醫診所"
    },
    {
      "code" : "3811021238",
      "display" : "濟德中醫診所"
    },
    {
      "code" : "3811021247",
      "display" : "七堵杞子中醫診所"
    },
    {
      "code" : "3811030013",
      "display" : "華碇中醫診所"
    },
    {
      "code" : "3811030022",
      "display" : "佛生中醫診所"
    },
    {
      "code" : "3811031056",
      "display" : "頤康中醫診所"
    },
    {
      "code" : "3811040019",
      "display" : "一元堂中醫診所"
    },
    {
      "code" : "3811040073",
      "display" : "聯合中醫診所"
    },
    {
      "code" : "3811040144",
      "display" : "良德堂中醫診所"
    },
    {
      "code" : "3811040251",
      "display" : "姜晴中醫診所"
    },
    {
      "code" : "3811041356",
      "display" : "李金澤中醫診所"
    },
    {
      "code" : "3811041365",
      "display" : "逍遙中醫診所"
    },
    {
      "code" : "3811041383",
      "display" : "德勳中醫診所"
    },
    {
      "code" : "3811041436",
      "display" : "百草堂中醫診所"
    },
    {
      "code" : "3811041445",
      "display" : "悅心中醫診所"
    },
    {
      "code" : "3811041454",
      "display" : "上久中醫診所"
    },
    {
      "code" : "3811041463",
      "display" : "李上知中醫診所"
    },
    {
      "code" : "3811041472",
      "display" : "基隆生基中醫診所"
    },
    {
      "code" : "3811041481",
      "display" : "謝富合中醫診所"
    },
    {
      "code" : "3811050051",
      "display" : "仁愛中醫診所"
    },
    {
      "code" : "3811051085",
      "display" : "允安中醫診所"
    },
    {
      "code" : "3811051101",
      "display" : "明觀現代科學中醫診所"
    },
    {
      "code" : "3811051129",
      "display" : "同仁堂中醫診所"
    },
    {
      "code" : "3811051147",
      "display" : "安一杏子中醫診所"
    },
    {
      "code" : "3811060039",
      "display" : "同德中醫診所"
    },
    {
      "code" : "3811061063",
      "display" : "聖康中醫診所"
    },
    {
      "code" : "3811061090",
      "display" : "逢安中醫診所"
    },
    {
      "code" : "3811070035",
      "display" : "世杰中醫診所"
    },
    {
      "code" : "3811071112",
      "display" : "瑞明中醫診所"
    },
    {
      "code" : "3811071167",
      "display" : "世家中醫診所"
    },
    {
      "code" : "3831010044",
      "display" : "竹林中醫診所"
    },
    {
      "code" : "3831010115",
      "display" : "吉安堂中醫診所"
    },
    {
      "code" : "3831010124",
      "display" : "生永中醫診所"
    },
    {
      "code" : "3831010277",
      "display" : "新榮盛中醫診所"
    },
    {
      "code" : "3831010357",
      "display" : "壽春中醫診所"
    },
    {
      "code" : "3831010393",
      "display" : "惠群中醫診所"
    },
    {
      "code" : "3831010508",
      "display" : "福安堂中醫診所"
    },
    {
      "code" : "3831010580",
      "display" : "林園中醫診所"
    },
    {
      "code" : "3831010599",
      "display" : "廖世輝中醫診所"
    },
    {
      "code" : "3831010679",
      "display" : "泰源中醫診所"
    },
    {
      "code" : "3831010731",
      "display" : "儒林居中醫診所"
    },
    {
      "code" : "3831010740",
      "display" : "廣生堂中醫診所"
    },
    {
      "code" : "3831010839",
      "display" : "德昇中醫診所"
    },
    {
      "code" : "3831010946",
      "display" : "陳榮文中醫診所"
    },
    {
      "code" : "3831011005",
      "display" : "國光中醫診所"
    },
    {
      "code" : "3831011256",
      "display" : "板橋聖昌中醫診所"
    },
    {
      "code" : "3831011283",
      "display" : "陳東熙中醫診所"
    },
    {
      "code" : "3831011309",
      "display" : "日祥中醫診所"
    },
    {
      "code" : "3831011318",
      "display" : "漢光中醫診所"
    },
    {
      "code" : "3831011345",
      "display" : "健福中醫診所"
    },
    {
      "code" : "3831011354",
      "display" : "家福中醫診所"
    },
    {
      "code" : "3831011363",
      "display" : "人和中醫診所"
    },
    {
      "code" : "3831011425",
      "display" : "聖原中醫診所"
    },
    {
      "code" : "3831012593",
      "display" : "同心堂中醫診所"
    },
    {
      "code" : "3831012691",
      "display" : "板橋同仁堂中醫診所"
    },
    {
      "code" : "3831012753",
      "display" : "和康中醫診所"
    },
    {
      "code" : "3831012815",
      "display" : "全心中醫診所"
    },
    {
      "code" : "3831012959",
      "display" : "蓁禾堂中醫診所"
    },
    {
      "code" : "3831013009",
      "display" : "遠東中醫診所"
    },
    {
      "code" : "3831013072",
      "display" : "鈺安中醫診所"
    },
    {
      "code" : "3831013107",
      "display" : "洪金蘭中醫診所"
    },
    {
      "code" : "3831013189",
      "display" : "裕芳中醫診所"
    },
    {
      "code" : "3831013278",
      "display" : "仁心中醫診所"
    },
    {
      "code" : "3831013330",
      "display" : "明德中醫診所"
    },
    {
      "code" : "3831013367",
      "display" : "回春中醫診所"
    },
    {
      "code" : "3831013394",
      "display" : "華康中醫診所"
    },
    {
      "code" : "3831013410",
      "display" : "榮德中醫診所"
    },
    {
      "code" : "3831013429",
      "display" : "鴻仁中醫診所"
    },
    {
      "code" : "3831013438",
      "display" : "福霖堂中醫診所"
    },
    {
      "code" : "3831013509",
      "display" : "施丞修中醫診所"
    },
    {
      "code" : "3831013518",
      "display" : "坤儒中醫診所"
    },
    {
      "code" : "3831013527",
      "display" : "隆安中醫診所"
    },
    {
      "code" : "3831013536",
      "display" : "洪天註中醫診所"
    },
    {
      "code" : "3831013554",
      "display" : "宏國中醫診所"
    },
    {
      "code" : "3831013581",
      "display" : "鴻林中醫診所"
    },
    {
      "code" : "3831013616",
      "display" : "程維德中醫診所"
    },
    {
      "code" : "3831013634",
      "display" : "勝濟堂中醫診所"
    },
    {
      "code" : "3831013643",
      "display" : "善仁堂中醫診所"
    },
    {
      "code" : "3831013652",
      "display" : "全泰中醫診所"
    },
    {
      "code" : "3831013661",
      "display" : "向德中醫診所"
    },
    {
      "code" : "3831013670",
      "display" : "杏禾中醫診所"
    },
    {
      "code" : "3831013689",
      "display" : "蓁佑中醫診所"
    },
    {
      "code" : "3831013714",
      "display" : "晨軒中醫診所"
    },
    {
      "code" : "3831013732",
      "display" : "吉安中醫診所"
    },
    {
      "code" : "3831013778",
      "display" : "太乙中醫診所"
    },
    {
      "code" : "3831013787",
      "display" : "皇漢中醫診所"
    },
    {
      "code" : "3831013796",
      "display" : "菩提中醫診所"
    },
    {
      "code" : "3831013812",
      "display" : "康宸中醫診所"
    },
    {
      "code" : "3831013830",
      "display" : "謙合科學中醫診所"
    },
    {
      "code" : "3831013858",
      "display" : "祐新中醫診所"
    },
    {
      "code" : "3831013876",
      "display" : "一心中醫診所"
    },
    {
      "code" : "3831013885",
      "display" : "耀祥中醫診所"
    },
    {
      "code" : "3831013965",
      "display" : "江翠中醫診所"
    },
    {
      "code" : "3831013974",
      "display" : "宏昌中醫診所"
    },
    {
      "code" : "3831013983",
      "display" : "裕安中醫診所"
    },
    {
      "code" : "3831014024",
      "display" : "翰林居中醫診所"
    },
    {
      "code" : "3831014033",
      "display" : "大雄中醫診所"
    },
    {
      "code" : "3831014042",
      "display" : "鼎鈞中醫診所"
    },
    {
      "code" : "3831014079",
      "display" : "鼎超中醫診所"
    },
    {
      "code" : "3831014088",
      "display" : "一生中醫診所"
    },
    {
      "code" : "3831014122",
      "display" : "弘恩中醫診所"
    },
    {
      "code" : "3831014177",
      "display" : "春易安中醫診所"
    },
    {
      "code" : "3831014195",
      "display" : "天寧中醫診所"
    },
    {
      "code" : "3831014211",
      "display" : "仁得中醫診所"
    },
    {
      "code" : "3831014239",
      "display" : "德川中醫診所"
    },
    {
      "code" : "3831014248",
      "display" : "璞和中醫診所"
    },
    {
      "code" : "3831014257",
      "display" : "蘇鴻昶中醫診所"
    },
    {
      "code" : "3831014275",
      "display" : "郭中醫診所"
    },
    {
      "code" : "3831014284",
      "display" : "華晟中醫診所"
    },
    {
      "code" : "3831014300",
      "display" : "梁中醫診所"
    },
    {
      "code" : "3831014328",
      "display" : "健昇中醫診所"
    },
    {
      "code" : "3831014337",
      "display" : "老記保壽堂中醫診所"
    },
    {
      "code" : "3831014373",
      "display" : "祥德中醫診所"
    },
    {
      "code" : "3831014391",
      "display" : "仲德中醫診所"
    },
    {
      "code" : "3831014408",
      "display" : "倪國欽中醫診所"
    },
    {
      "code" : "3831014426",
      "display" : "靈群閣中醫診所"
    },
    {
      "code" : "3831014462",
      "display" : "樂昕中醫診所"
    },
    {
      "code" : "3831014524",
      "display" : "全懋中醫診所"
    },
    {
      "code" : "3831014533",
      "display" : "榮美中醫診所"
    },
    {
      "code" : "3831014542",
      "display" : "寶生中醫診所"
    },
    {
      "code" : "3831014551",
      "display" : "板橋新生堂中醫診所"
    },
    {
      "code" : "3831014560",
      "display" : "建全中醫診所"
    },
    {
      "code" : "3831014579",
      "display" : "慈護一品中醫診所"
    },
    {
      "code" : "3831014588",
      "display" : "福全中醫診所"
    },
    {
      "code" : "3831014604",
      "display" : "東芳榮妹中醫診所"
    },
    {
      "code" : "3831014613",
      "display" : "文達中醫診所"
    },
    {
      "code" : "3831014640",
      "display" : "保翔中醫診所"
    },
    {
      "code" : "3831014659",
      "display" : "六合堂中醫診所"
    },
    {
      "code" : "3831014677",
      "display" : "御品堂中醫診所"
    },
    {
      "code" : "3831014695",
      "display" : "林衡毅中醫診所"
    },
    {
      "code" : "3831014702",
      "display" : "薇晶中醫診所"
    },
    {
      "code" : "3831014711",
      "display" : "建中堂中醫診所"
    },
    {
      "code" : "3831014720",
      "display" : "潤宇堂中醫診所"
    },
    {
      "code" : "3831014739",
      "display" : "橘泉中醫診所"
    },
    {
      "code" : "3831014748",
      "display" : "老德燕中醫診所"
    },
    {
      "code" : "3831014757",
      "display" : "明遠中醫診所"
    },
    {
      "code" : "3831014766",
      "display" : "正大中醫診所"
    },
    {
      "code" : "3831014775",
      "display" : "百善堂中醫診所"
    },
    {
      "code" : "3831014793",
      "display" : "德睿中醫診所"
    },
    {
      "code" : "3831014819",
      "display" : "天祐中醫診所"
    },
    {
      "code" : "3831014837",
      "display" : "聖恩中醫診所"
    },
    {
      "code" : "3831014846",
      "display" : "六安堂中醫診所"
    },
    {
      "code" : "3831014855",
      "display" : "御品堂中醫診所"
    },
    {
      "code" : "3831014864",
      "display" : "杏蘊中醫診所"
    },
    {
      "code" : "3831014873",
      "display" : "德康中醫診所"
    },
    {
      "code" : "3831014882",
      "display" : "新昌中醫診所"
    },
    {
      "code" : "3831014891",
      "display" : "德睿中醫診所"
    },
    {
      "code" : "3831014908",
      "display" : "翰醫堂新板中醫診所"
    },
    {
      "code" : "3831014917",
      "display" : "保翔中醫診所"
    },
    {
      "code" : "3831014926",
      "display" : "華江中醫診所"
    },
    {
      "code" : "3831014935",
      "display" : "全人中醫診所"
    },
    {
      "code" : "3831014944",
      "display" : "金正中醫診所"
    },
    {
      "code" : "3831014953",
      "display" : "板橋京都堂中醫診所"
    },
    {
      "code" : "3831014962",
      "display" : "天祐中醫診所"
    },
    {
      "code" : "3831014971",
      "display" : "晨軒中醫診所"
    },
    {
      "code" : "3831014980",
      "display" : "薇晶中醫診所"
    },
    {
      "code" : "3831015003",
      "display" : "樂昕中醫診所"
    },
    {
      "code" : "3831015012",
      "display" : "回春中醫診所"
    },
    {
      "code" : "3831015021",
      "display" : "金正中醫診所"
    },
    {
      "code" : "3831015030",
      "display" : "百善堂中醫診所"
    },
    {
      "code" : "3831015049",
      "display" : "德睿中醫診所"
    },
    {
      "code" : "3831015058",
      "display" : "板橋板樹風澤中醫診所"
    },
    {
      "code" : "3831015067",
      "display" : "澤林中醫診所"
    },
    {
      "code" : "3831015076",
      "display" : "耀康中醫診所"
    },
    {
      "code" : "3831015085",
      "display" : "板新風澤中醫診所"
    },
    {
      "code" : "3831015094",
      "display" : "全人中醫診所"
    },
    {
      "code" : "3831015101",
      "display" : "德睿中醫診所"
    },
    {
      "code" : "3831015110",
      "display" : "站前新生堂中醫診所"
    },
    {
      "code" : "3831015129",
      "display" : "健福中醫診所"
    },
    {
      "code" : "3831015138",
      "display" : "板橋昱安堂中醫診所"
    },
    {
      "code" : "3831015147",
      "display" : "元曦堂中醫診所"
    },
    {
      "code" : "3831015156",
      "display" : "丞喆中醫診所"
    },
    {
      "code" : "3831015165",
      "display" : "心慕中醫診所"
    },
    {
      "code" : "3831015174",
      "display" : "老德燕中醫診所"
    },
    {
      "code" : "3831020012",
      "display" : "百昌堂中醫診所"
    },
    {
      "code" : "3831020077",
      "display" : "長興中醫診所"
    },
    {
      "code" : "3831020166",
      "display" : "林寶華中醫診所"
    },
    {
      "code" : "3831020219",
      "display" : "慧光中醫診所"
    },
    {
      "code" : "3831020282",
      "display" : "寶鶴堂中醫診所"
    },
    {
      "code" : "3831020479",
      "display" : "正五華中醫診所"
    },
    {
      "code" : "3831020513",
      "display" : "東華堂中醫診所"
    },
    {
      "code" : "3831020586",
      "display" : "三和中醫診所"
    },
    {
      "code" : "3831020657",
      "display" : "永昇中醫診所"
    },
    {
      "code" : "3831020675",
      "display" : "國嘉中醫診所"
    },
    {
      "code" : "3831020906",
      "display" : "陳逸德中醫診所"
    },
    {
      "code" : "3831020915",
      "display" : "集美中醫診所"
    },
    {
      "code" : "3831027414",
      "display" : "忠孝龍安中醫診所"
    },
    {
      "code" : "3831027629",
      "display" : "龍安中醫診所"
    },
    {
      "code" : "3831027665",
      "display" : "益成中醫診所"
    },
    {
      "code" : "3831027683",
      "display" : "健康中醫診所"
    },
    {
      "code" : "3831027709",
      "display" : "保安堂中醫診所"
    },
    {
      "code" : "3831027852",
      "display" : "六福中醫診所"
    },
    {
      "code" : "3831027870",
      "display" : "仁祥中醫診所"
    },
    {
      "code" : "3831027923",
      "display" : "林源泉中醫診所"
    },
    {
      "code" : "3831027987",
      "display" : "福田中醫診所"
    },
    {
      "code" : "3831028171",
      "display" : "厚生堂中醫診所"
    },
    {
      "code" : "3831028199",
      "display" : "三重建成中醫診所"
    },
    {
      "code" : "3831028251",
      "display" : "長駥堂中醫診所"
    },
    {
      "code" : "3831028279",
      "display" : "三重養生堂中醫診所"
    },
    {
      "code" : "3831028322",
      "display" : "善慧堂中醫診所"
    },
    {
      "code" : "3831028331",
      "display" : "康欣中醫診所"
    },
    {
      "code" : "3831028359",
      "display" : "寶田中醫診所"
    },
    {
      "code" : "3831028368",
      "display" : "惟康中醫診所"
    },
    {
      "code" : "3831028386",
      "display" : "京品中醫診所"
    },
    {
      "code" : "3831028395",
      "display" : "璟欣中醫診所"
    },
    {
      "code" : "3831028402",
      "display" : "六福堂中醫診所"
    },
    {
      "code" : "3831028411",
      "display" : "宏安中醫診所"
    },
    {
      "code" : "3831028439",
      "display" : "佑安中醫診所"
    },
    {
      "code" : "3831028448",
      "display" : "重安養生中醫診所"
    },
    {
      "code" : "3831028466",
      "display" : "鼎安堂中醫診所"
    },
    {
      "code" : "3831028484",
      "display" : "真如中醫診所"
    },
    {
      "code" : "3831028519",
      "display" : "軒林中醫診所"
    },
    {
      "code" : "3831028528",
      "display" : "天德堂中醫診所"
    },
    {
      "code" : "3831028537",
      "display" : "欣億中醫診所"
    },
    {
      "code" : "3831028555",
      "display" : "慶竹中醫診所"
    },
    {
      "code" : "3831028564",
      "display" : "松鶴中醫診所"
    },
    {
      "code" : "3831028582",
      "display" : "禾豐中醫診所"
    },
    {
      "code" : "3831028591",
      "display" : "醫道中醫診所"
    },
    {
      "code" : "3831028608",
      "display" : "安美中醫診所"
    },
    {
      "code" : "3831028626",
      "display" : "喜悅中醫診所"
    },
    {
      "code" : "3831028644",
      "display" : "弘曜中醫診所"
    },
    {
      "code" : "3831028671",
      "display" : "全心堂中醫診所"
    },
    {
      "code" : "3831028699",
      "display" : "漢民中醫診所"
    },
    {
      "code" : "3831028706",
      "display" : "仲聖中醫診所"
    },
    {
      "code" : "3831028724",
      "display" : "健安堂中醫診所"
    },
    {
      "code" : "3831028733",
      "display" : "健安中醫診所"
    },
    {
      "code" : "3831028742",
      "display" : "三重同仁堂中醫診所"
    },
    {
      "code" : "3831028751",
      "display" : "鼎真中醫診所"
    },
    {
      "code" : "3831028760",
      "display" : "麗水堂中醫診所"
    },
    {
      "code" : "3831028779",
      "display" : "仁安堂中醫診所"
    },
    {
      "code" : "3831028788",
      "display" : "新昌中醫診所"
    },
    {
      "code" : "3831028797",
      "display" : "沐澤時尚中醫診所"
    },
    {
      "code" : "3831028804",
      "display" : "三重天慕堂中醫診所"
    },
    {
      "code" : "3831028813",
      "display" : "三重宥聖中醫診所"
    },
    {
      "code" : "3831028822",
      "display" : "和璞中醫診所"
    },
    {
      "code" : "3831028831",
      "display" : "沐澤時尚中醫診所"
    },
    {
      "code" : "3831028840",
      "display" : "大耀中醫診所"
    },
    {
      "code" : "3831028859",
      "display" : "大同中醫診所"
    },
    {
      "code" : "3831028868",
      "display" : "真如中醫診所"
    },
    {
      "code" : "3831028877",
      "display" : "三重菩提中醫診所"
    },
    {
      "code" : "3831028886",
      "display" : "三重菩提中醫診所"
    },
    {
      "code" : "3831028895",
      "display" : "三重又一春中醫診所"
    },
    {
      "code" : "3831028902",
      "display" : "仰德中醫診所"
    },
    {
      "code" : "3831028911",
      "display" : "三重天慕堂中醫診所"
    },
    {
      "code" : "3831028920",
      "display" : "正雅堂中醫診所"
    },
    {
      "code" : "3831028939",
      "display" : "沐稼親子中醫診所"
    },
    {
      "code" : "3831028948",
      "display" : "健安堂中醫診所"
    },
    {
      "code" : "3831028957",
      "display" : "軒林中醫診所"
    },
    {
      "code" : "3831030028",
      "display" : "泰華內科針灸科中醫診所"
    },
    {
      "code" : "3831030073",
      "display" : "康源中醫診所"
    },
    {
      "code" : "3831030162",
      "display" : "俊發內科中醫診所"
    },
    {
      "code" : "3831030206",
      "display" : "竹林堂中醫診所"
    },
    {
      "code" : "3831030260",
      "display" : "竹安堂中醫診所"
    },
    {
      "code" : "3831030331",
      "display" : "上海堂中醫診所"
    },
    {
      "code" : "3831030340",
      "display" : "獻寶中醫診所"
    },
    {
      "code" : "3831030402",
      "display" : "合元中醫診所"
    },
    {
      "code" : "3831030411",
      "display" : "利源中醫診所"
    },
    {
      "code" : "3831030420",
      "display" : "永豐中醫診所"
    },
    {
      "code" : "3831030475",
      "display" : "華興中醫診所"
    },
    {
      "code" : "3831030546",
      "display" : "秀朗中醫診所"
    },
    {
      "code" : "3831030635",
      "display" : "新時代中醫診所"
    },
    {
      "code" : "3831031829",
      "display" : "清華中醫診所"
    },
    {
      "code" : "3831031838",
      "display" : "崇愛中醫聯合診所"
    },
    {
      "code" : "3831031883",
      "display" : "聖元中醫診所"
    },
    {
      "code" : "3831031892",
      "display" : "華信中醫診所"
    },
    {
      "code" : "3831031927",
      "display" : "聖昇中醫診所"
    },
    {
      "code" : "3831031981",
      "display" : "健祐中醫診所"
    },
    {
      "code" : "3831032013",
      "display" : "福德中醫診所"
    },
    {
      "code" : "3831032102",
      "display" : "家康中醫診所"
    },
    {
      "code" : "3831032111",
      "display" : "祺元堂中醫診所"
    },
    {
      "code" : "3831032148",
      "display" : "明仁中醫診所"
    },
    {
      "code" : "3831032157",
      "display" : "永和易元堂中醫診所"
    },
    {
      "code" : "3831032175",
      "display" : "祥寧中醫診所"
    },
    {
      "code" : "3831032193",
      "display" : "泉安堂中醫診所"
    },
    {
      "code" : "3831032228",
      "display" : "臻觀中醫診所"
    },
    {
      "code" : "3831032237",
      "display" : "康福中醫診所"
    },
    {
      "code" : "3831032255",
      "display" : "妙華中醫診所"
    },
    {
      "code" : "3831032264",
      "display" : "惠康中醫診所"
    },
    {
      "code" : "3831032344",
      "display" : "祥同中醫診所"
    },
    {
      "code" : "3831032362",
      "display" : "從容中醫診所"
    },
    {
      "code" : "3831032380",
      "display" : "順和堂中醫診所"
    },
    {
      "code" : "3831032399",
      "display" : "永和健生堂中醫診所"
    },
    {
      "code" : "3831032406",
      "display" : "世峰中醫診所"
    },
    {
      "code" : "3831032442",
      "display" : "進昌中醫診所"
    },
    {
      "code" : "3831032451",
      "display" : "佑憲中醫診所"
    },
    {
      "code" : "3831032488",
      "display" : "術德中醫診所"
    },
    {
      "code" : "3831032504",
      "display" : "甘霖中醫診所"
    },
    {
      "code" : "3831032513",
      "display" : "永和明師中醫診所"
    },
    {
      "code" : "3831032568",
      "display" : "普門中醫診所"
    },
    {
      "code" : "3831032595",
      "display" : "永樂中醫診所"
    },
    {
      "code" : "3831032620",
      "display" : "樂源中醫診所"
    },
    {
      "code" : "3831032648",
      "display" : "宜庭中醫診所"
    },
    {
      "code" : "3831032657",
      "display" : "有明中醫診所"
    },
    {
      "code" : "3831032666",
      "display" : "元新中醫診所"
    },
    {
      "code" : "3831032684",
      "display" : "靖林中醫診所"
    },
    {
      "code" : "3831032693",
      "display" : "健祐中醫診所"
    },
    {
      "code" : "3831032700",
      "display" : "元化中醫診所"
    },
    {
      "code" : "3831032719",
      "display" : "有明中醫診所"
    },
    {
      "code" : "3831032728",
      "display" : "永和澄杏中醫診所"
    },
    {
      "code" : "3831032737",
      "display" : "健祐中醫診所"
    },
    {
      "code" : "3831032746",
      "display" : "言嘉中醫診所"
    },
    {
      "code" : "3831032755",
      "display" : "有明中醫診所"
    },
    {
      "code" : "3831032764",
      "display" : "仁聿中醫診所"
    },
    {
      "code" : "3831032773",
      "display" : "千醫堂中醫診所"
    },
    {
      "code" : "3831032782",
      "display" : "永和風澤中醫診所"
    },
    {
      "code" : "3831040015",
      "display" : "華星中醫診所"
    },
    {
      "code" : "3831040033",
      "display" : "朝春中醫診所"
    },
    {
      "code" : "3831040042",
      "display" : "三元中醫診所"
    },
    {
      "code" : "3831040051",
      "display" : "福星中醫診所"
    },
    {
      "code" : "3831040079",
      "display" : "陳南中醫診所"
    },
    {
      "code" : "3831040097",
      "display" : "進安中醫診所"
    },
    {
      "code" : "3831040122",
      "display" : "長安堂中醫診所"
    },
    {
      "code" : "3831040220",
      "display" : "中安中醫診所"
    },
    {
      "code" : "3831040417",
      "display" : "寶島中醫診所"
    },
    {
      "code" : "3831040471",
      "display" : "元隆堂中醫診所"
    },
    {
      "code" : "3831040622",
      "display" : "培敦中醫診所"
    },
    {
      "code" : "3831040748",
      "display" : "大眾中醫診所"
    },
    {
      "code" : "3831040766",
      "display" : "培真中醫診所"
    },
    {
      "code" : "3831040784",
      "display" : "景新中醫診所"
    },
    {
      "code" : "3831040819",
      "display" : "中和健宏中醫聯合診所"
    },
    {
      "code" : "3831040864",
      "display" : "元慶中醫診所"
    },
    {
      "code" : "3831040926",
      "display" : "漢唐中醫診所"
    },
    {
      "code" : "3831042019",
      "display" : "國耀中醫診所"
    },
    {
      "code" : "3831042073",
      "display" : "常榮中醫診所"
    },
    {
      "code" : "3831042233",
      "display" : "詠德中醫診所"
    },
    {
      "code" : "3831042297",
      "display" : "三大中醫診所"
    },
    {
      "code" : "3831042386",
      "display" : "慈育廣合中醫診所"
    },
    {
      "code" : "3831042420",
      "display" : "雋恩中醫診所"
    },
    {
      "code" : "3831042457",
      "display" : "中和保源中醫診所"
    },
    {
      "code" : "3831042500",
      "display" : "申一中醫診所"
    },
    {
      "code" : "3831042537",
      "display" : "宜佑中醫診所"
    },
    {
      "code" : "3831042760",
      "display" : "元宇中醫診所"
    },
    {
      "code" : "3831042779",
      "display" : "詹錫彥中醫診所"
    },
    {
      "code" : "3831042788",
      "display" : "元真堂中醫診所"
    },
    {
      "code" : "3831042813",
      "display" : "玖德中醫診所"
    },
    {
      "code" : "3831042831",
      "display" : "刁仁杰中醫診所"
    },
    {
      "code" : "3831042859",
      "display" : "富邦中醫診所"
    },
    {
      "code" : "3831042877",
      "display" : "明安堂中醫診所"
    },
    {
      "code" : "3831042957",
      "display" : "康泉中醫診所"
    },
    {
      "code" : "3831042966",
      "display" : "中禾堂中醫診所"
    },
    {
      "code" : "3831043025",
      "display" : "康乃馨中醫診所"
    },
    {
      "code" : "3831043043",
      "display" : "中和明師中醫診所"
    },
    {
      "code" : "3831043089",
      "display" : "陳承吉中醫診所"
    },
    {
      "code" : "3831043098",
      "display" : "華漢中醫診所"
    },
    {
      "code" : "3831043132",
      "display" : "耕德中醫診所"
    },
    {
      "code" : "3831043150",
      "display" : "正宏堂中醫診所"
    },
    {
      "code" : "3831043169",
      "display" : "揚銘中醫診所"
    },
    {
      "code" : "3831043187",
      "display" : "真品堂中醫診所"
    },
    {
      "code" : "3831043267",
      "display" : "澄品中醫診所"
    },
    {
      "code" : "3831043294",
      "display" : "龍恩中醫診所"
    },
    {
      "code" : "3831043374",
      "display" : "宣景中醫診所"
    },
    {
      "code" : "3831043383",
      "display" : "天安中醫診所"
    },
    {
      "code" : "3831043463",
      "display" : "立安中醫診所"
    },
    {
      "code" : "3831043472",
      "display" : "明儒中醫診所"
    },
    {
      "code" : "3831043481",
      "display" : "杏林中醫診所"
    },
    {
      "code" : "3831043507",
      "display" : "精誠中醫診所"
    },
    {
      "code" : "3831043516",
      "display" : "永貞明師中醫診所"
    },
    {
      "code" : "3831043525",
      "display" : "秀景中醫診所"
    },
    {
      "code" : "3831043534",
      "display" : "康博中醫診所"
    },
    {
      "code" : "3831043543",
      "display" : "潤泰中醫診所"
    },
    {
      "code" : "3831043552",
      "display" : "承光中醫診所"
    },
    {
      "code" : "3831043561",
      "display" : "景安現代中醫診所"
    },
    {
      "code" : "3831043570",
      "display" : "沐心中醫診所"
    },
    {
      "code" : "3831043589",
      "display" : "永安健康中醫診所"
    },
    {
      "code" : "3831043598",
      "display" : "新生堂中醫診所"
    },
    {
      "code" : "3831043605",
      "display" : "行願中醫診所"
    },
    {
      "code" : "3831043614",
      "display" : "世安中醫診所"
    },
    {
      "code" : "3831043623",
      "display" : "明芯中醫診所"
    },
    {
      "code" : "3831043632",
      "display" : "永欣中醫診所"
    },
    {
      "code" : "3831043641",
      "display" : "辛中醫診所"
    },
    {
      "code" : "3831043650",
      "display" : "妍喜中醫診所"
    },
    {
      "code" : "3831043669",
      "display" : "頌和中醫診所"
    },
    {
      "code" : "3831043678",
      "display" : "宣達中醫診所"
    },
    {
      "code" : "3831043687",
      "display" : "致中和中醫診所"
    },
    {
      "code" : "3831043696",
      "display" : "天安中醫診所"
    },
    {
      "code" : "3831043703",
      "display" : "天安中醫診所"
    },
    {
      "code" : "3831043712",
      "display" : "心俞堂中醫診所"
    },
    {
      "code" : "3831043721",
      "display" : "中和世峰中醫診所"
    },
    {
      "code" : "3831043730",
      "display" : "願行中醫診所"
    },
    {
      "code" : "3831043749",
      "display" : "逸心堂中醫診所"
    },
    {
      "code" : "3831043758",
      "display" : "圉閎中醫診所"
    },
    {
      "code" : "3831043776",
      "display" : "台安中醫診所"
    },
    {
      "code" : "3831043785",
      "display" : "從容中醫診所"
    },
    {
      "code" : "3831043794",
      "display" : "宣達中醫診所"
    },
    {
      "code" : "3831043801",
      "display" : "彤安中醫診所"
    },
    {
      "code" : "3831050011",
      "display" : "德昌中醫診所"
    },
    {
      "code" : "3831050020",
      "display" : "順安堂傷科中醫診所"
    },
    {
      "code" : "3831050048",
      "display" : "仁安中醫診所"
    },
    {
      "code" : "3831050182",
      "display" : "健宏中醫診所"
    },
    {
      "code" : "3831050208",
      "display" : "新店建成中醫診所"
    },
    {
      "code" : "3831050226",
      "display" : "新福安中醫診所"
    },
    {
      "code" : "3831050235",
      "display" : "長庚中醫聯合診所"
    },
    {
      "code" : "3831050244",
      "display" : "育豐中醫診所"
    },
    {
      "code" : "3831051438",
      "display" : "新店榮星中醫診所"
    },
    {
      "code" : "3831051616",
      "display" : "百漢中醫診所"
    },
    {
      "code" : "3831051661",
      "display" : "安慶中醫診所"
    },
    {
      "code" : "3831051778",
      "display" : "岐伯齋中醫診所"
    },
    {
      "code" : "3831051803",
      "display" : "覺真中醫診所"
    },
    {
      "code" : "3831051812",
      "display" : "瑞清中醫診所"
    },
    {
      "code" : "3831051830",
      "display" : "鈺晟中醫診所"
    },
    {
      "code" : "3831051849",
      "display" : "陳炳文中醫診所"
    },
    {
      "code" : "3831051858",
      "display" : "北新中醫診所"
    },
    {
      "code" : "3831051894",
      "display" : "邱世宗中醫診所"
    },
    {
      "code" : "3831051901",
      "display" : "安康中醫診所"
    },
    {
      "code" : "3831051910",
      "display" : "天祥中醫診所"
    },
    {
      "code" : "3831051929",
      "display" : "禪心中醫診所"
    },
    {
      "code" : "3831051938",
      "display" : "品宣中醫診所"
    },
    {
      "code" : "3831051947",
      "display" : "思邈堂中醫診所"
    },
    {
      "code" : "3831051974",
      "display" : "新店漢唐經方中醫診所"
    },
    {
      "code" : "3831051983",
      "display" : "國華中醫診所"
    },
    {
      "code" : "3831051992",
      "display" : "易豐中醫診所"
    },
    {
      "code" : "3831052006",
      "display" : "懷臨親子中醫診所"
    },
    {
      "code" : "3831052024",
      "display" : "必安中醫診所"
    },
    {
      "code" : "3831052033",
      "display" : "上醫堂中醫診所"
    },
    {
      "code" : "3831052042",
      "display" : "大豐中醫診所"
    },
    {
      "code" : "3831052051",
      "display" : "思邈堂中醫診所"
    },
    {
      "code" : "3831052060",
      "display" : "易豐中醫診所"
    },
    {
      "code" : "3831052079",
      "display" : "桂枝香中醫診所"
    },
    {
      "code" : "3831052088",
      "display" : "達泰中醫診所"
    },
    {
      "code" : "3831052104",
      "display" : "新店京都堂中醫診所"
    },
    {
      "code" : "3831052113",
      "display" : "新意中醫診所"
    },
    {
      "code" : "3831052122",
      "display" : "頤光中醫診所"
    },
    {
      "code" : "3831052131",
      "display" : "心圓中醫診所"
    },
    {
      "code" : "3831052140",
      "display" : "禪心中醫診所"
    },
    {
      "code" : "3831052159",
      "display" : "易豐中醫診所"
    },
    {
      "code" : "3831052168",
      "display" : "中正頤光中醫診所"
    },
    {
      "code" : "3831052177",
      "display" : "思邈堂中醫診所"
    },
    {
      "code" : "3831052186",
      "display" : "桂枝香中醫診所"
    },
    {
      "code" : "3831060099",
      "display" : "樹德中醫診所"
    },
    {
      "code" : "3831060106",
      "display" : "聯安中醫診所"
    },
    {
      "code" : "3831060133",
      "display" : "平安中醫診所"
    },
    {
      "code" : "3831060142",
      "display" : "曾亨安中醫診所"
    },
    {
      "code" : "3831060153",
      "display" : "民安中醫診所"
    },
    {
      "code" : "3831060179",
      "display" : "楊中醫診所"
    },
    {
      "code" : "3831060197",
      "display" : "瑞宏中醫診所"
    },
    {
      "code" : "3831060240",
      "display" : "安心中醫診所"
    },
    {
      "code" : "3831060286",
      "display" : "仁山中醫診所"
    },
    {
      "code" : "3831060311",
      "display" : "劉茂祥中醫診所"
    },
    {
      "code" : "3831060473",
      "display" : "至寶堂中醫聯合診所"
    },
    {
      "code" : "3831060508",
      "display" : "永福中醫診所"
    },
    {
      "code" : "3831060606",
      "display" : "江吉亮中醫診所"
    },
    {
      "code" : "3831060679",
      "display" : "豐生中醫診所"
    },
    {
      "code" : "3831061765",
      "display" : "健元中醫診所"
    },
    {
      "code" : "3831061890",
      "display" : "賀安中醫診所"
    },
    {
      "code" : "3831061998",
      "display" : "神農中醫診所"
    },
    {
      "code" : "3831062011",
      "display" : "長青中醫診所"
    },
    {
      "code" : "3831062048",
      "display" : "大德中醫診所"
    },
    {
      "code" : "3831062084",
      "display" : "佑德中醫診所"
    },
    {
      "code" : "3831062100",
      "display" : "慶安居中醫診所"
    },
    {
      "code" : "3831062217",
      "display" : "天澤中醫診所"
    },
    {
      "code" : "3831062235",
      "display" : "仁愛中醫診所"
    },
    {
      "code" : "3831062306",
      "display" : "美恩中醫診所"
    },
    {
      "code" : "3831062360",
      "display" : "有慶中醫診所"
    },
    {
      "code" : "3831062379",
      "display" : "御漢堂中醫診所"
    },
    {
      "code" : "3831062388",
      "display" : "九和堂中醫診所"
    },
    {
      "code" : "3831062413",
      "display" : "彤發中醫診所"
    },
    {
      "code" : "3831062477",
      "display" : "慈護上品中醫診所"
    },
    {
      "code" : "3831062495",
      "display" : "聯合中醫診所"
    },
    {
      "code" : "3831062502",
      "display" : "超群中醫診所"
    },
    {
      "code" : "3831062511",
      "display" : "大大中醫診所"
    },
    {
      "code" : "3831062520",
      "display" : "三德中醫診所"
    },
    {
      "code" : "3831062539",
      "display" : "岐黃中醫診所"
    },
    {
      "code" : "3831062566",
      "display" : "麗景中醫診所"
    },
    {
      "code" : "3831062584",
      "display" : "傳愛中醫診所"
    },
    {
      "code" : "3831062628",
      "display" : "國寶中醫診所"
    },
    {
      "code" : "3831062637",
      "display" : "至真中醫診所"
    },
    {
      "code" : "3831062646",
      "display" : "昌隆中醫診所"
    },
    {
      "code" : "3831062655",
      "display" : "德安中醫診所"
    },
    {
      "code" : "3831062673",
      "display" : "尊生堂中醫診所"
    },
    {
      "code" : "3831062691",
      "display" : "舞鶴中醫診所"
    },
    {
      "code" : "3831062717",
      "display" : "心宇中醫診所"
    },
    {
      "code" : "3831062726",
      "display" : "宏泰中醫診所"
    },
    {
      "code" : "3831062744",
      "display" : "幸福中醫診所"
    },
    {
      "code" : "3831062762",
      "display" : "新莊易元堂中醫診所"
    },
    {
      "code" : "3831062771",
      "display" : "翰醫堂中醫診所"
    },
    {
      "code" : "3831062780",
      "display" : "極上中醫診所"
    },
    {
      "code" : "3831062799",
      "display" : "新莊國寶堂中醫診所"
    },
    {
      "code" : "3831062806",
      "display" : "至美中醫診所"
    },
    {
      "code" : "3831062815",
      "display" : "至善堂中醫診所"
    },
    {
      "code" : "3831062824",
      "display" : "宏嘉中醫診所"
    },
    {
      "code" : "3831062833",
      "display" : "品妍中醫診所"
    },
    {
      "code" : "3831062842",
      "display" : "又一春中醫診所"
    },
    {
      "code" : "3831062851",
      "display" : "福澤國際中醫診所"
    },
    {
      "code" : "3831062879",
      "display" : "一草中醫診所"
    },
    {
      "code" : "3831062897",
      "display" : "澄杏中醫診所"
    },
    {
      "code" : "3831062904",
      "display" : "康健堂中醫診所"
    },
    {
      "code" : "3831062913",
      "display" : "靜好中醫診所"
    },
    {
      "code" : "3831062922",
      "display" : "真禾中醫診所"
    },
    {
      "code" : "3831062931",
      "display" : "幸福翰醫堂中醫診所"
    },
    {
      "code" : "3831062940",
      "display" : "泰和中醫診所"
    },
    {
      "code" : "3831062959",
      "display" : "宥聖中醫診所"
    },
    {
      "code" : "3831062968",
      "display" : "林豊詔中醫診所"
    },
    {
      "code" : "3831062977",
      "display" : "昇源中醫診所"
    },
    {
      "code" : "3831062986",
      "display" : "瑞和中醫診所"
    },
    {
      "code" : "3831062995",
      "display" : "聖康中醫診所"
    },
    {
      "code" : "3831063009",
      "display" : "新莊易元堂中醫診所"
    },
    {
      "code" : "3831063018",
      "display" : "大禾中醫診所"
    },
    {
      "code" : "3831063027",
      "display" : "至善堂中醫診所"
    },
    {
      "code" : "3831063036",
      "display" : "澄心中醫診所"
    },
    {
      "code" : "3831063045",
      "display" : "醫莘堂中醫診所"
    },
    {
      "code" : "3831063054",
      "display" : "幸福中醫診所"
    },
    {
      "code" : "3831063063",
      "display" : "行懿堂中醫診所"
    },
    {
      "code" : "3831063072",
      "display" : "醫莘堂中醫診所"
    },
    {
      "code" : "3831063081",
      "display" : "啟新中醫診所"
    },
    {
      "code" : "3831063090",
      "display" : "新莊江翠中醫診所"
    },
    {
      "code" : "3831063107",
      "display" : "瑞和中醫診所"
    },
    {
      "code" : "3831063116",
      "display" : "新莊江翠中醫診所"
    },
    {
      "code" : "3831063125",
      "display" : "一時中醫診所"
    },
    {
      "code" : "3831063134",
      "display" : "仁予中醫診所"
    },
    {
      "code" : "3831063143",
      "display" : "傳愛中醫診所"
    },
    {
      "code" : "3831063152",
      "display" : "新莊光華風澤中醫診所"
    },
    {
      "code" : "3831063161",
      "display" : "新莊江翠中醫診所"
    },
    {
      "code" : "3831063170",
      "display" : "新莊易元堂中醫診所"
    },
    {
      "code" : "3831063189",
      "display" : "德安中醫診所"
    },
    {
      "code" : "3831063198",
      "display" : "新莊京都堂中醫診所"
    },
    {
      "code" : "3831063205",
      "display" : "仁愛中醫診所"
    },
    {
      "code" : "3831070031",
      "display" : "新永生中醫診所"
    },
    {
      "code" : "3831070148",
      "display" : "陳春錦中醫診所"
    },
    {
      "code" : "3831070362",
      "display" : "賀元中醫聯合診所"
    },
    {
      "code" : "3831071369",
      "display" : "漢昌中醫診所"
    },
    {
      "code" : "3831071387",
      "display" : "游中醫診所"
    },
    {
      "code" : "3831071458",
      "display" : "樹林同欣堂中醫診所"
    },
    {
      "code" : "3831071476",
      "display" : "祥瑞中醫診所"
    },
    {
      "code" : "3831071485",
      "display" : "樹林建全中醫診所"
    },
    {
      "code" : "3831071494",
      "display" : "福康中醫診所"
    },
    {
      "code" : "3831071501",
      "display" : "吉人堂中醫診所"
    },
    {
      "code" : "3831071529",
      "display" : "慈愛中醫診所"
    },
    {
      "code" : "3831071538",
      "display" : "佑康中醫診所"
    },
    {
      "code" : "3831071547",
      "display" : "鈺唐中醫診所"
    },
    {
      "code" : "3831071565",
      "display" : "仁人中醫診所"
    },
    {
      "code" : "3831071574",
      "display" : "厚德中醫診所"
    },
    {
      "code" : "3831071592",
      "display" : "仁人中醫診所"
    },
    {
      "code" : "3831080046",
      "display" : "世達中醫診所"
    },
    {
      "code" : "3831081222",
      "display" : "孫中醫診所"
    },
    {
      "code" : "3831081310",
      "display" : "心醫堂中醫診所"
    },
    {
      "code" : "3831081338",
      "display" : "國慶中醫診所"
    },
    {
      "code" : "3831081347",
      "display" : "羅晉專中醫診所"
    },
    {
      "code" : "3831081356",
      "display" : "正峰中醫診所"
    },
    {
      "code" : "3831081365",
      "display" : "廣安中醫診所"
    },
    {
      "code" : "3831081374",
      "display" : "鶯桃中醫診所"
    },
    {
      "code" : "3831090033",
      "display" : "太元堂中醫診所"
    },
    {
      "code" : "3831090042",
      "display" : "同福堂中醫診所"
    },
    {
      "code" : "3831091110",
      "display" : "慈恩中醫診所"
    },
    {
      "code" : "3831091227",
      "display" : "元津堂中醫診所"
    },
    {
      "code" : "3831091263",
      "display" : "易安中醫診所"
    },
    {
      "code" : "3831091290",
      "display" : "仁合中醫診所"
    },
    {
      "code" : "3831091316",
      "display" : "賢明中醫診所"
    },
    {
      "code" : "3831091325",
      "display" : "北大承光中醫診所"
    },
    {
      "code" : "3831091334",
      "display" : "踏雪齋中醫診所"
    },
    {
      "code" : "3831091343",
      "display" : "踏雪齋中醫診所"
    },
    {
      "code" : "3831091352",
      "display" : "黃麟峰中醫診所"
    },
    {
      "code" : "3831091361",
      "display" : "北大風澤中醫診所"
    },
    {
      "code" : "3831091370",
      "display" : "雲禾中醫診所"
    },
    {
      "code" : "3831091389",
      "display" : "龍學安傳中醫診所"
    },
    {
      "code" : "3831091398",
      "display" : "皇霖中醫診所"
    },
    {
      "code" : "3831091405",
      "display" : "橙陽中醫診所"
    },
    {
      "code" : "3831100034",
      "display" : "慶安中醫診所"
    },
    {
      "code" : "3831100098",
      "display" : "金德中醫診所"
    },
    {
      "code" : "3831100178",
      "display" : "大愛中醫診所"
    },
    {
      "code" : "3831101317",
      "display" : "仙台中醫診所"
    },
    {
      "code" : "3831101335",
      "display" : "建順中醫診所"
    },
    {
      "code" : "3831101362",
      "display" : "仁禾中醫診所"
    },
    {
      "code" : "3831101380",
      "display" : "達觀中醫診所"
    },
    {
      "code" : "3831101406",
      "display" : "陽明中醫診所"
    },
    {
      "code" : "3831101415",
      "display" : "祐安中醫診所"
    },
    {
      "code" : "3831101479",
      "display" : "寶樹堂中醫診所"
    },
    {
      "code" : "3831101504",
      "display" : "祐興中醫診所"
    },
    {
      "code" : "3831101531",
      "display" : "富康中醫診所"
    },
    {
      "code" : "3831101540",
      "display" : "淡海中醫診所"
    },
    {
      "code" : "3831101559",
      "display" : "順心中醫診所"
    },
    {
      "code" : "3831101568",
      "display" : "三易中醫診所"
    },
    {
      "code" : "3831101577",
      "display" : "全元堂中醫診所"
    },
    {
      "code" : "3831101611",
      "display" : "水碓中醫診所"
    },
    {
      "code" : "3831101620",
      "display" : "竹圍中醫診所"
    },
    {
      "code" : "3831101648",
      "display" : "金向德中醫診所"
    },
    {
      "code" : "3831101657",
      "display" : "新悅中醫診所"
    },
    {
      "code" : "3831101666",
      "display" : "藍瀅中醫診所"
    },
    {
      "code" : "3831101675",
      "display" : "金微笑中醫診所"
    },
    {
      "code" : "3831101684",
      "display" : "真傳中醫診所"
    },
    {
      "code" : "3831101693",
      "display" : "金向德中醫診所"
    },
    {
      "code" : "3831101700",
      "display" : "珍寶中醫診所"
    },
    {
      "code" : "3831101719",
      "display" : "金向德中醫診所"
    },
    {
      "code" : "3831110012",
      "display" : "世樺中醫診所"
    },
    {
      "code" : "3831110076",
      "display" : "華佗中醫診所"
    },
    {
      "code" : "3831110094",
      "display" : "醫心館中醫診所"
    },
    {
      "code" : "3831110101",
      "display" : "華成中醫診所"
    },
    {
      "code" : "3831111126",
      "display" : "健榮中醫診所"
    },
    {
      "code" : "3831111242",
      "display" : "廣緣堂中醫診所"
    },
    {
      "code" : "3831111251",
      "display" : "青蓮中醫診所"
    },
    {
      "code" : "3831111260",
      "display" : "周得民中醫診所"
    },
    {
      "code" : "3831111297",
      "display" : "敦揚中醫診所"
    },
    {
      "code" : "3831111304",
      "display" : "佳德中醫診所"
    },
    {
      "code" : "3831111313",
      "display" : "秀峰中醫診所"
    },
    {
      "code" : "3831111322",
      "display" : "李春風中醫診所"
    },
    {
      "code" : "3831111331",
      "display" : "大新中醫診所"
    },
    {
      "code" : "3831111340",
      "display" : "唯其中醫診所"
    },
    {
      "code" : "3831111359",
      "display" : "杞子中醫診所"
    },
    {
      "code" : "3831111377",
      "display" : "大漢中醫診所"
    },
    {
      "code" : "3831111386",
      "display" : "和昌唐中醫診所"
    },
    {
      "code" : "3831111395",
      "display" : "依紜中醫診所"
    },
    {
      "code" : "3831111402",
      "display" : "汐科杞子中醫診所"
    },
    {
      "code" : "3831111411",
      "display" : "汐止泰興中醫診所"
    },
    {
      "code" : "3831111439",
      "display" : "依紜中醫診所"
    },
    {
      "code" : "3831111448",
      "display" : "明心堂中醫診所"
    },
    {
      "code" : "3831111457",
      "display" : "汐止風澤中醫診所"
    },
    {
      "code" : "3831111466",
      "display" : "秀峰中醫診所"
    },
    {
      "code" : "3831111475",
      "display" : "泓萃中醫診所"
    },
    {
      "code" : "3831111484",
      "display" : "汐止泰興中醫診所"
    },
    {
      "code" : "3831121131",
      "display" : "冠誠中醫診所"
    },
    {
      "code" : "3831121159",
      "display" : "大宏中醫診所"
    },
    {
      "code" : "3831130010",
      "display" : "世桓中醫診所"
    },
    {
      "code" : "3831130121",
      "display" : "吉德中醫診所"
    },
    {
      "code" : "3831130238",
      "display" : "延和中醫診所"
    },
    {
      "code" : "3831130550",
      "display" : "祐生中醫診所"
    },
    {
      "code" : "3831130569",
      "display" : "陳鴻翔中醫診所"
    },
    {
      "code" : "3831131575",
      "display" : "土城明師中醫聯合診所"
    },
    {
      "code" : "3831131584",
      "display" : "清水建全中醫診所"
    },
    {
      "code" : "3831131600",
      "display" : "林原億中醫診所"
    },
    {
      "code" : "3831131619",
      "display" : "建明中醫診所"
    },
    {
      "code" : "3831131799",
      "display" : "聖和中醫診所"
    },
    {
      "code" : "3831131806",
      "display" : "和揚中醫診所"
    },
    {
      "code" : "3831131815",
      "display" : "渼林中醫診所"
    },
    {
      "code" : "3831131860",
      "display" : "易元堂中醫診所"
    },
    {
      "code" : "3831131897",
      "display" : "弘祐中醫診所"
    },
    {
      "code" : "3831131977",
      "display" : "耆康中醫診所"
    },
    {
      "code" : "3831131995",
      "display" : "土城仁安堂中醫診所"
    },
    {
      "code" : "3831132027",
      "display" : "欣揚中醫診所"
    },
    {
      "code" : "3831132045",
      "display" : "漢榮中醫診所"
    },
    {
      "code" : "3831132054",
      "display" : "成德中醫診所"
    },
    {
      "code" : "3831132063",
      "display" : "玉生堂中醫診所"
    },
    {
      "code" : "3831132072",
      "display" : "合安中醫診所"
    },
    {
      "code" : "3831132090",
      "display" : "漢邦中醫診所"
    },
    {
      "code" : "3831132107",
      "display" : "土城建宏中醫診所"
    },
    {
      "code" : "3831132116",
      "display" : "福滿堂中醫診所"
    },
    {
      "code" : "3831132125",
      "display" : "聖滄中醫診所"
    },
    {
      "code" : "3831132143",
      "display" : "維濃中醫診所"
    },
    {
      "code" : "3831132152",
      "display" : "太醫殿中醫診所"
    },
    {
      "code" : "3831132161",
      "display" : "弘新中醫診所"
    },
    {
      "code" : "3831132189",
      "display" : "弘新中醫診所"
    },
    {
      "code" : "3831132198",
      "display" : "土城建宏中醫診所"
    },
    {
      "code" : "3831132205",
      "display" : "三合堂中醫診所"
    },
    {
      "code" : "3831132214",
      "display" : "慶儒中醫診所"
    },
    {
      "code" : "3831132223",
      "display" : "奕翔中醫診所"
    },
    {
      "code" : "3831132232",
      "display" : "和陽中醫診所"
    },
    {
      "code" : "3831132241",
      "display" : "土城風澤中醫診所"
    },
    {
      "code" : "3831132250",
      "display" : "富海中醫診所"
    },
    {
      "code" : "3831140056",
      "display" : "培元中醫診所"
    },
    {
      "code" : "3831140065",
      "display" : "一品堂中醫診所"
    },
    {
      "code" : "3831140136",
      "display" : "同仁堂中醫診所"
    },
    {
      "code" : "3831140449",
      "display" : "勝原堂中醫診所"
    },
    {
      "code" : "3831141688",
      "display" : "新立中醫診所"
    },
    {
      "code" : "3831141722",
      "display" : "大春中醫診所"
    },
    {
      "code" : "3831141839",
      "display" : "同慶堂中醫診所"
    },
    {
      "code" : "3831141857",
      "display" : "長榮中醫診所"
    },
    {
      "code" : "3831141866",
      "display" : "得康中醫診所"
    },
    {
      "code" : "3831141884",
      "display" : "信義中醫診所"
    },
    {
      "code" : "3831141893",
      "display" : "良和中醫診所"
    },
    {
      "code" : "3831141982",
      "display" : "啟新中醫診所"
    },
    {
      "code" : "3831141991",
      "display" : "永濟中醫診所"
    },
    {
      "code" : "3831142014",
      "display" : "大祐中醫診所"
    },
    {
      "code" : "3831142078",
      "display" : "芊瓏中醫診所"
    },
    {
      "code" : "3831142087",
      "display" : "張志遠中醫診所"
    },
    {
      "code" : "3831142167",
      "display" : "鴻昇中醫診所"
    },
    {
      "code" : "3831142238",
      "display" : "宜德中醫診所"
    },
    {
      "code" : "3831142292",
      "display" : "合安堂中醫診所"
    },
    {
      "code" : "3831142327",
      "display" : "華泰中醫診所"
    },
    {
      "code" : "3831142345",
      "display" : "百和中醫診所"
    },
    {
      "code" : "3831142363",
      "display" : "祥永中醫診所"
    },
    {
      "code" : "3831142381",
      "display" : "六善堂中醫診所"
    },
    {
      "code" : "3831142416",
      "display" : "鷺江中醫診所"
    },
    {
      "code" : "3831142425",
      "display" : "安信中醫診所"
    },
    {
      "code" : "3831142434",
      "display" : "興霖中醫診所"
    },
    {
      "code" : "3831142443",
      "display" : "春陽中醫診所"
    },
    {
      "code" : "3831142452",
      "display" : "萬鎰堂中醫診所"
    },
    {
      "code" : "3831142461",
      "display" : "宏怡中醫診所"
    },
    {
      "code" : "3831142470",
      "display" : "宏怡中醫診所"
    },
    {
      "code" : "3831142489",
      "display" : "六善堂中醫診所"
    },
    {
      "code" : "3831150043",
      "display" : "周中醫診所"
    },
    {
      "code" : "3831151175",
      "display" : "大順中醫診所"
    },
    {
      "code" : "3831151200",
      "display" : "成泰中醫診所"
    },
    {
      "code" : "3831151219",
      "display" : "五股璞和中醫診所"
    },
    {
      "code" : "3831160030",
      "display" : "黎明中醫聯合診所"
    },
    {
      "code" : "3831160049",
      "display" : "天仁堂中醫診所"
    },
    {
      "code" : "3831161144",
      "display" : "星光中醫診所"
    },
    {
      "code" : "3831161224",
      "display" : "懷聖中醫診所"
    },
    {
      "code" : "3831161233",
      "display" : "耀德中醫診所"
    },
    {
      "code" : "3831161297",
      "display" : "清祥中醫診所"
    },
    {
      "code" : "3831161313",
      "display" : "時珍中醫診所"
    },
    {
      "code" : "3831161322",
      "display" : "泰明中醫診所"
    },
    {
      "code" : "3831161331",
      "display" : "泰一中醫診所"
    },
    {
      "code" : "3831161340",
      "display" : "泰一中醫診所"
    },
    {
      "code" : "3831161359",
      "display" : "耀德中醫診所"
    },
    {
      "code" : "3831161368",
      "display" : "馨德中醫診所"
    },
    {
      "code" : "3831161377",
      "display" : "黎明中醫診所"
    },
    {
      "code" : "3831171168",
      "display" : "國寶堂中醫診所"
    },
    {
      "code" : "3831171211",
      "display" : "元康中醫診所"
    },
    {
      "code" : "3831171220",
      "display" : "鼎豐中醫診所"
    },
    {
      "code" : "3831171239",
      "display" : "佳恩中醫診所"
    },
    {
      "code" : "3831171248",
      "display" : "妙吉祥中醫診所"
    },
    {
      "code" : "3831171257",
      "display" : "信隆堂中醫診所"
    },
    {
      "code" : "3831171266",
      "display" : "林口真如中醫診所"
    },
    {
      "code" : "3831171275",
      "display" : "嘉德中醫診所"
    },
    {
      "code" : "3831171284",
      "display" : "懷臨堂中醫診所"
    },
    {
      "code" : "3831171293",
      "display" : "德心中醫診所"
    },
    {
      "code" : "3831171300",
      "display" : "林口悅兒親子中醫診所"
    },
    {
      "code" : "3831171319",
      "display" : "丰荷中醫診所"
    },
    {
      "code" : "3831171328",
      "display" : "聯生中醫診所"
    },
    {
      "code" : "3831171337",
      "display" : "合元堂中醫診所"
    },
    {
      "code" : "3831171346",
      "display" : "林口真如中醫診所"
    },
    {
      "code" : "3831171355",
      "display" : "六丼中醫診所"
    },
    {
      "code" : "3831171364",
      "display" : "吉祥中醫診所"
    },
    {
      "code" : "3831171373",
      "display" : "林口風澤中醫診所"
    },
    {
      "code" : "3831171382",
      "display" : "森奕閣中醫診所"
    },
    {
      "code" : "3831171391",
      "display" : "吉祥中醫診所"
    },
    {
      "code" : "3831171408",
      "display" : "林口京都堂中醫診所"
    },
    {
      "code" : "3831171417",
      "display" : "雅丰唯心中醫診所"
    },
    {
      "code" : "3831171426",
      "display" : "鵲杏中醫診所"
    },
    {
      "code" : "3831171435",
      "display" : "時麥中醫診所"
    },
    {
      "code" : "3831171444",
      "display" : "林口真如中醫診所"
    },
    {
      "code" : "3831171453",
      "display" : "吉祥中醫診所"
    },
    {
      "code" : "3831181075",
      "display" : "深耕中醫診所"
    },
    {
      "code" : "3831181084",
      "display" : "禾生堂中醫診所"
    },
    {
      "code" : "3831190010",
      "display" : "阿讚中醫診所"
    },
    {
      "code" : "3831210026",
      "display" : "昆德中醫診所"
    },
    {
      "code" : "3831230528",
      "display" : "九如中醫診所"
    },
    {
      "code" : "3831230546",
      "display" : "建達中醫診所"
    },
    {
      "code" : "3831260017",
      "display" : "旗盛中醫診所"
    },
    {
      "code" : "3831271047",
      "display" : "吉元堂中醫診所"
    },
    {
      "code" : "3831280019",
      "display" : "天寶堂中醫診所"
    },
    {
      "code" : "3834010082",
      "display" : "六安堂中醫診所"
    },
    {
      "code" : "3834010091",
      "display" : "慶安中醫診所"
    },
    {
      "code" : "3834010108",
      "display" : "仁德堂中醫診所"
    },
    {
      "code" : "3834010117",
      "display" : "林鴻飛中醫診所"
    },
    {
      "code" : "3834010153",
      "display" : "德安中醫診所"
    },
    {
      "code" : "3834011178",
      "display" : "六順中醫診所"
    },
    {
      "code" : "3834011196",
      "display" : "仁濟中醫聯合診所"
    },
    {
      "code" : "3834011203",
      "display" : "慶餘堂中醫診所"
    },
    {
      "code" : "3834011221",
      "display" : "成春中醫診所"
    },
    {
      "code" : "3834011276",
      "display" : "國泰中醫診所"
    },
    {
      "code" : "3834011285",
      "display" : "新南大中醫診所"
    },
    {
      "code" : "3834011329",
      "display" : "宜蘭現代中醫診所"
    },
    {
      "code" : "3834011356",
      "display" : "明悅中醫診所"
    },
    {
      "code" : "3834011383",
      "display" : "宜康中醫診所"
    },
    {
      "code" : "3834011392",
      "display" : "慧仁中醫診所"
    },
    {
      "code" : "3834011418",
      "display" : "新悅中醫診所"
    },
    {
      "code" : "3834011427",
      "display" : "見康中醫診所"
    },
    {
      "code" : "3834011436",
      "display" : "一新堂中醫診所"
    },
    {
      "code" : "3834011445",
      "display" : "太一中醫診所"
    },
    {
      "code" : "3834011454",
      "display" : "神農中醫診所"
    },
    {
      "code" : "3834011463",
      "display" : "沐禾中醫診所"
    },
    {
      "code" : "3834020104",
      "display" : "羅國鶴中醫診所"
    },
    {
      "code" : "3834020122",
      "display" : "現代中醫診所"
    },
    {
      "code" : "3834021183",
      "display" : "佳恩中醫診所"
    },
    {
      "code" : "3834021209",
      "display" : "同仁堂中醫聯合診所"
    },
    {
      "code" : "3834021236",
      "display" : "愛欣中醫診所"
    },
    {
      "code" : "3834021245",
      "display" : "羅東仁濟中醫聯合診所"
    },
    {
      "code" : "3834021263",
      "display" : "羅東南大中醫診所"
    },
    {
      "code" : "3834021281",
      "display" : "養生堂中醫診所"
    },
    {
      "code" : "3834021307",
      "display" : "一生中醫診所"
    },
    {
      "code" : "3834021343",
      "display" : "存仁堂中醫診所"
    },
    {
      "code" : "3834021352",
      "display" : "怡得心中醫診所"
    },
    {
      "code" : "3834021379",
      "display" : "得福中醫診所"
    },
    {
      "code" : "3834021389",
      "display" : "六福中醫診所"
    },
    {
      "code" : "3834021398",
      "display" : "觀自在中醫診所"
    },
    {
      "code" : "3834021405",
      "display" : "三星堂中醫診所"
    },
    {
      "code" : "3834021423",
      "display" : "李冠儀中醫診所"
    },
    {
      "code" : "3834021441",
      "display" : "晉揚中醫診所"
    },
    {
      "code" : "3834021450",
      "display" : "醫心堂中醫診所"
    },
    {
      "code" : "3834021469",
      "display" : "林熙哲中醫診所"
    },
    {
      "code" : "3834021478",
      "display" : "寶生堂中醫診所"
    },
    {
      "code" : "3834021487",
      "display" : "樸實中醫診所"
    },
    {
      "code" : "3834021496",
      "display" : "菩提樹中醫診所"
    },
    {
      "code" : "3834030020",
      "display" : "世揚中醫診所"
    },
    {
      "code" : "3834040017",
      "display" : "仁安中醫診所"
    },
    {
      "code" : "3834041023",
      "display" : "陳春光中醫診所"
    },
    {
      "code" : "3834041032",
      "display" : "悅恩中醫診所"
    },
    {
      "code" : "3834050059",
      "display" : "曾燦傑中醫診所"
    },
    {
      "code" : "3834051074",
      "display" : "大新中醫診所"
    },
    {
      "code" : "3834051109",
      "display" : "信惠中醫診所"
    },
    {
      "code" : "3834060019",
      "display" : "易安中醫診所"
    },
    {
      "code" : "3834070015",
      "display" : "員山中醫診所"
    },
    {
      "code" : "3834070042",
      "display" : "謙睿中醫診所"
    },
    {
      "code" : "3834081054",
      "display" : "醫心堂中醫診所"
    },
    {
      "code" : "3834090026",
      "display" : "同濟中醫診所"
    },
    {
      "code" : "3834090035",
      "display" : "益生中醫診所"
    },
    {
      "code" : "3834090062",
      "display" : "太一堂中醫診所"
    },
    {
      "code" : "3834101033",
      "display" : "星現代中醫診所"
    },
    {
      "code" : "3890010020",
      "display" : "弘恩中醫診所"
    },
    {
      "code" : "3890011036",
      "display" : "廣濟中醫診所"
    },
    {
      "code" : "3890011045",
      "display" : "顏存仁中醫診所"
    },
    {
      "code" : "3890011054",
      "display" : "大方中醫診所"
    },
    {
      "code" : "3890020035",
      "display" : "卓家老舖中醫診所"
    },
    {
      "code" : "3890030559",
      "display" : "福慧中醫診所"
    },
    {
      "code" : "3890030577",
      "display" : "揚中醫診所"
    },
    {
      "code" : "3890030586",
      "display" : "維中醫診所"
    },
    {
      "code" : "3890030595",
      "display" : "戴君強中醫診所"
    },
    {
      "code" : "3890040019",
      "display" : "豐元中醫診所"
    },
    {
      "code" : "3890040037",
      "display" : "欣欣醫學中醫診所"
    },
    {
      "code" : "3890040046",
      "display" : "欣欣醫學中醫診所"
    },
    {
      "code" : "4001020019",
      "display" : "基督復臨安息日會醫療財團法人臺安診所"
    },
    {
      "code" : "4001020028",
      "display" : "尹書田醫療財團法人書田泌尿科眼科診所"
    },
    {
      "code" : "4001020037",
      "display" : "台灣地區婦幼衛生中心醫療財團法人婦幼保健診所"
    },
    {
      "code" : "4001110018",
      "display" : "國泰醫療財團法人內湖國泰診所"
    },
    {
      "code" : "4001180010",
      "display" : "醫療財團法人徐元智先生醫藥基金會遠東聯合診所"
    },
    {
      "code" : "4001180029",
      "display" : "醫療財團法人好心肝基金會好心肝診所"
    },
    {
      "code" : "4001190016",
      "display" : "同仁院醫療財團法人貴陽診所"
    },
    {
      "code" : "4031050016",
      "display" : "天主教耕莘醫療財團法人耕莘診所"
    },
    {
      "code" : "4034010017",
      "display" : "宜蘭員山醫療財團法人普門診所"
    },
    {
      "code" : "4101200019",
      "display" : "有全醫療社團法人景美牙醫診所"
    },
    {
      "code" : "4131050027",
      "display" : "有全醫療社團法人有全牙醫診所"
    },
    {
      "code" : "4201020022",
      "display" : "中華民國防癌篩檢中心醫療財團法人"
    },
    {
      "code" : "4201090015",
      "display" : "醫療財團法人病理發展基金會台北病理中心"
    },
    {
      "code" : "4201090024",
      "display" : "李豐病理中心"
    },
    {
      "code" : "4201180023",
      "display" : "醫療財團法人好心肝基金會好心肝病理中心"
    },
    {
      "code" : "4501020028",
      "display" : "聯醫病理中心"
    },
    {
      "code" : "4501090020",
      "display" : "聯醫病理中心"
    },
    {
      "code" : "4501100021",
      "display" : "衛康病理中心"
    },
    {
      "code" : "4531040010",
      "display" : "新柏氏病理中心"
    },
    {
      "code" : "4Y01090019",
      "display" : "永昱居家呼吸照護所"
    },
    {
      "code" : "4Y01090028",
      "display" : "美悅居家呼吸照護所"
    },
    {
      "code" : "4Y01100029",
      "display" : "泰安醫院附設居家呼吸照護所"
    },
    {
      "code" : "4Y01100038",
      "display" : "福慧居家呼吸照護所"
    },
    {
      "code" : "4Y01150029",
      "display" : "宜寧居家呼吸照護所"
    },
    {
      "code" : "4Y01180018",
      "display" : "好康居家呼吸照護所"
    },
    {
      "code" : "4Y11050018",
      "display" : "瑞之盟居家呼吸照護所"
    },
    {
      "code" : "4Y31030012",
      "display" : "永宜居家呼吸照護所"
    },
    {
      "code" : "4Y31030021",
      "display" : "喜樂居家呼吸照護所"
    },
    {
      "code" : "4Y31060010",
      "display" : "美心居家呼吸照護所"
    },
    {
      "code" : "4Y31170011",
      "display" : "辛蒂居家呼吸照護所"
    },
    {
      "code" : "5901010058",
      "display" : "安郁藥局"
    },
    {
      "code" : "5901010076",
      "display" : "榮星藥局"
    },
    {
      "code" : "5901010085",
      "display" : "安世藥局"
    },
    {
      "code" : "5901010094",
      "display" : "明一藥局"
    },
    {
      "code" : "5901010165",
      "display" : "傑安藥局"
    },
    {
      "code" : "5901010174",
      "display" : "仁弘藥局"
    },
    {
      "code" : "5901010192",
      "display" : "益華藥局"
    },
    {
      "code" : "5901010272",
      "display" : "德靈藥局"
    },
    {
      "code" : "5901010290",
      "display" : "健全藥局"
    },
    {
      "code" : "5901010389",
      "display" : "李得安藥局"
    },
    {
      "code" : "5901010496",
      "display" : "瑞昌大藥局"
    },
    {
      "code" : "5901010576",
      "display" : "合生藥局"
    },
    {
      "code" : "5901011662",
      "display" : "上允藥局"
    },
    {
      "code" : "5901011699",
      "display" : "建東大藥局"
    },
    {
      "code" : "5901011733",
      "display" : "和諧藥局"
    },
    {
      "code" : "5901011760",
      "display" : "延壽藥局"
    },
    {
      "code" : "5901011975",
      "display" : "萬泰藥局"
    },
    {
      "code" : "5901012203",
      "display" : "博荃藥局"
    },
    {
      "code" : "5901012383",
      "display" : "德川中西藥局"
    },
    {
      "code" : "5901012409",
      "display" : "家音藥局"
    },
    {
      "code" : "5901012490",
      "display" : "中美藥局"
    },
    {
      "code" : "5901012516",
      "display" : "惠登藥局"
    },
    {
      "code" : "5901012561",
      "display" : "松田藥局"
    },
    {
      "code" : "5901012570",
      "display" : "予志藥局"
    },
    {
      "code" : "5901012598",
      "display" : "婕登藥局"
    },
    {
      "code" : "5901012632",
      "display" : "晨安藥局"
    },
    {
      "code" : "5901012650",
      "display" : "銘德藥局"
    },
    {
      "code" : "5901012712",
      "display" : "立康大藥局"
    },
    {
      "code" : "5901012749",
      "display" : "躍獅松和藥局"
    },
    {
      "code" : "5901012758",
      "display" : "京東藥局"
    },
    {
      "code" : "5901012767",
      "display" : "晨新藥局"
    },
    {
      "code" : "5901012918",
      "display" : "躍獅京華藥局"
    },
    {
      "code" : "5901012963",
      "display" : "綠之家藥局"
    },
    {
      "code" : "5901013095",
      "display" : "康采藥局"
    },
    {
      "code" : "5901013120",
      "display" : "誠康中西藥局"
    },
    {
      "code" : "5901013148",
      "display" : "唯康藥局"
    },
    {
      "code" : "5901013175",
      "display" : "台北長庚維康藥局"
    },
    {
      "code" : "5901013200",
      "display" : "專品南京藥局"
    },
    {
      "code" : "5901013246",
      "display" : "芝欣藥局"
    },
    {
      "code" : "5901013308",
      "display" : "立赫敦北藥局"
    },
    {
      "code" : "5901013326",
      "display" : "富景藥局"
    },
    {
      "code" : "5901013344",
      "display" : "健康活力藥師藥局"
    },
    {
      "code" : "5901013362",
      "display" : "啄木鳥藥局"
    },
    {
      "code" : "5901013371",
      "display" : "玖田藥局"
    },
    {
      "code" : "5901013380",
      "display" : "澄馨藥局"
    },
    {
      "code" : "5901013399",
      "display" : "一安正昇藥局"
    },
    {
      "code" : "5901013433",
      "display" : "杏一延吉藥局"
    },
    {
      "code" : "5901013442",
      "display" : "松山八德藥局"
    },
    {
      "code" : "5901013451",
      "display" : "新德大藥局"
    },
    {
      "code" : "5901013460",
      "display" : "光點延新藥局"
    },
    {
      "code" : "5901013488",
      "display" : "欣生藥局"
    },
    {
      "code" : "5901013504",
      "display" : "杏一台北長庚藥局"
    },
    {
      "code" : "5901013513",
      "display" : "立赫民生藥局"
    },
    {
      "code" : "5901013531",
      "display" : "佑全松山南京東藥局"
    },
    {
      "code" : "5901013586",
      "display" : "安禾大藥局"
    },
    {
      "code" : "5901013595",
      "display" : "巧心藥局"
    },
    {
      "code" : "5901013620",
      "display" : "躍獅敦北藥局"
    },
    {
      "code" : "5901013648",
      "display" : "慶昌藥局"
    },
    {
      "code" : "5901013657",
      "display" : "順儷中崙藥局"
    },
    {
      "code" : "5901013666",
      "display" : "晨心藥局"
    },
    {
      "code" : "5901013675",
      "display" : "家育藥局"
    },
    {
      "code" : "5901013684",
      "display" : "佑翔藥局"
    },
    {
      "code" : "5901013693",
      "display" : "民生盛康藥局"
    },
    {
      "code" : "5901013700",
      "display" : "杏一台北台安藥局"
    },
    {
      "code" : "5901013719",
      "display" : "大樹松山藥局"
    },
    {
      "code" : "5901013728",
      "display" : "康麗藥局"
    },
    {
      "code" : "5901013737",
      "display" : "全欣藥局"
    },
    {
      "code" : "5901013746",
      "display" : "富景藥局"
    },
    {
      "code" : "5901013755",
      "display" : "逸菁中西特約藥局"
    },
    {
      "code" : "5901013764",
      "display" : "駿俏藥局"
    },
    {
      "code" : "5901013782",
      "display" : "佑全松山南京東藥局"
    },
    {
      "code" : "5901013808",
      "display" : "豐澤藥局"
    },
    {
      "code" : "5901013817",
      "display" : "德安藥局"
    },
    {
      "code" : "5901013826",
      "display" : "南京春天藥局"
    },
    {
      "code" : "5901013835",
      "display" : "美仁藥局"
    },
    {
      "code" : "5901013844",
      "display" : "躍獅敦北藥局"
    },
    {
      "code" : "5901013853",
      "display" : "誠康中西藥局"
    },
    {
      "code" : "5901013862",
      "display" : "禾宜藥局"
    },
    {
      "code" : "5901013871",
      "display" : "大樹松山藥局"
    },
    {
      "code" : "5901013880",
      "display" : "康是美建華藥局"
    },
    {
      "code" : "5901013899",
      "display" : "康麗藥局"
    },
    {
      "code" : "5901013906",
      "display" : "達昌健康藥局"
    },
    {
      "code" : "5901013924",
      "display" : "立健美中西藥局"
    },
    {
      "code" : "5901013933",
      "display" : "吉仁藥局"
    },
    {
      "code" : "5901013942",
      "display" : "專品南京藥局"
    },
    {
      "code" : "5901013951",
      "display" : "欣生藥局"
    },
    {
      "code" : "5901013960",
      "display" : "延吉春天藥局"
    },
    {
      "code" : "5901013979",
      "display" : "新東藥局"
    },
    {
      "code" : "5901013997",
      "display" : "萬芯中西藥局"
    },
    {
      "code" : "5901014001",
      "display" : "領悅藥局"
    },
    {
      "code" : "5901014010",
      "display" : "興宸藥局"
    },
    {
      "code" : "5901014029",
      "display" : "立赫民生藥局"
    },
    {
      "code" : "5901014038",
      "display" : "康是美建華藥局"
    },
    {
      "code" : "5901014047",
      "display" : "富景藥局"
    },
    {
      "code" : "5901014056",
      "display" : "富凱延壽藥局"
    },
    {
      "code" : "5901014065",
      "display" : "躍獅敦北藥局"
    },
    {
      "code" : "5901014074",
      "display" : "興宸藥局"
    },
    {
      "code" : "5901014083",
      "display" : "躍獅京華藥局"
    },
    {
      "code" : "5901014092",
      "display" : "康是美建華藥局"
    },
    {
      "code" : "5901014109",
      "display" : "八德藥局"
    },
    {
      "code" : "5901014118",
      "display" : "萬芯中西藥局"
    },
    {
      "code" : "5901014127",
      "display" : "躍獅京華藥局"
    },
    {
      "code" : "5901014136",
      "display" : "躍獅松和藥局"
    },
    {
      "code" : "5901014154",
      "display" : "躍獅京華藥局"
    },
    {
      "code" : "5901014163",
      "display" : "八德藥局"
    },
    {
      "code" : "5901020296",
      "display" : "百立藥局"
    },
    {
      "code" : "5901020303",
      "display" : "宏恩藥局"
    },
    {
      "code" : "5901020376",
      "display" : "靜園藥局"
    },
    {
      "code" : "5901020385",
      "display" : "延吉大藥局"
    },
    {
      "code" : "5901020456",
      "display" : "北陸藥局"
    },
    {
      "code" : "5901020465",
      "display" : "杏友藥局"
    },
    {
      "code" : "5901020554",
      "display" : "師大藥局"
    },
    {
      "code" : "5901020563",
      "display" : "施寶藥局"
    },
    {
      "code" : "5901020590",
      "display" : "燕福藥局"
    },
    {
      "code" : "5901020616",
      "display" : "龍護大藥局"
    },
    {
      "code" : "5901020634",
      "display" : "新廣生藥局"
    },
    {
      "code" : "5901020652",
      "display" : "寶德藥局"
    },
    {
      "code" : "5901020661",
      "display" : "泰佑藥局"
    },
    {
      "code" : "5901020670",
      "display" : "杏安堂藥局"
    },
    {
      "code" : "5901020689",
      "display" : "四維藥局"
    },
    {
      "code" : "5901020698",
      "display" : "羅斯福藥局"
    },
    {
      "code" : "5901020732",
      "display" : "赫慶藥局"
    },
    {
      "code" : "5901020787",
      "display" : "吉成藥局"
    },
    {
      "code" : "5901020858",
      "display" : "順天堂藥局"
    },
    {
      "code" : "5901020876",
      "display" : "大興藥局"
    },
    {
      "code" : "5901020901",
      "display" : "辰安藥局"
    },
    {
      "code" : "5901021122",
      "display" : "青康藥局"
    },
    {
      "code" : "5901021248",
      "display" : "永誠藥局"
    },
    {
      "code" : "5901021346",
      "display" : "正昌藥局"
    },
    {
      "code" : "5901021382",
      "display" : "建如藥局"
    },
    {
      "code" : "5901021408",
      "display" : "生百藥局"
    },
    {
      "code" : "5901022521",
      "display" : "台安藥局"
    },
    {
      "code" : "5901022601",
      "display" : "生光藥局"
    },
    {
      "code" : "5901022898",
      "display" : "永康藥局"
    },
    {
      "code" : "5901023073",
      "display" : "世中欣藥局"
    },
    {
      "code" : "5901023091",
      "display" : "加豐藥局"
    },
    {
      "code" : "5901023153",
      "display" : "崇光藥局"
    },
    {
      "code" : "5901023215",
      "display" : "大愛健康藥局"
    },
    {
      "code" : "5901023304",
      "display" : "麗樺藥師藥局"
    },
    {
      "code" : "5901023313",
      "display" : "安和藥局"
    },
    {
      "code" : "5901023331",
      "display" : "佑安藥局"
    },
    {
      "code" : "5901023386",
      "display" : "弘昇藥局"
    },
    {
      "code" : "5901023411",
      "display" : "長虹藥局"
    },
    {
      "code" : "5901023519",
      "display" : "惠盈藥局"
    },
    {
      "code" : "5901023523",
      "display" : "聯合仁愛藥局"
    },
    {
      "code" : "5901023591",
      "display" : "一心藥局"
    },
    {
      "code" : "5901023653",
      "display" : "信安健康藥局"
    },
    {
      "code" : "5901023680",
      "display" : "新富川藥局"
    },
    {
      "code" : "5901023706",
      "display" : "聖英藥局"
    },
    {
      "code" : "5901023724",
      "display" : "元氣生活健保藥局"
    },
    {
      "code" : "5901023831",
      "display" : "康乃馨藥局"
    },
    {
      "code" : "5901023886",
      "display" : "世康藥局"
    },
    {
      "code" : "5901023902",
      "display" : "惠良藥局"
    },
    {
      "code" : "5901023966",
      "display" : "愛維康生活藥局"
    },
    {
      "code" : "5901024007",
      "display" : "古亭健康人生藥局"
    },
    {
      "code" : "5901024098",
      "display" : "杏一瑞安藥局"
    },
    {
      "code" : "5901024114",
      "display" : "好安心藥局"
    },
    {
      "code" : "5901024123",
      "display" : "中山樂方藥局"
    },
    {
      "code" : "5901024178",
      "display" : "誠心藥局"
    },
    {
      "code" : "5901024221",
      "display" : "安居藥局"
    },
    {
      "code" : "5901024310",
      "display" : "躍獅新生藥局"
    },
    {
      "code" : "5901024347",
      "display" : "博大藥局"
    },
    {
      "code" : "5901024427",
      "display" : "博昱仁愛藥局"
    },
    {
      "code" : "5901024472",
      "display" : "忠孝康承健保藥局"
    },
    {
      "code" : "5901024481",
      "display" : "微笑藥師藥局"
    },
    {
      "code" : "5901024490",
      "display" : "明星大藥局"
    },
    {
      "code" : "5901024516",
      "display" : "博昱師大藥局"
    },
    {
      "code" : "5901024525",
      "display" : "國泰維康藥局"
    },
    {
      "code" : "5901024543",
      "display" : "奇威藥局"
    },
    {
      "code" : "5901024632",
      "display" : "艾登安和藥局"
    },
    {
      "code" : "5901024669",
      "display" : "百岳藥局"
    },
    {
      "code" : "5901024678",
      "display" : "大安健康人生藥局"
    },
    {
      "code" : "5901024687",
      "display" : "博昱大藥局"
    },
    {
      "code" : "5901024696",
      "display" : "仁華藥局"
    },
    {
      "code" : "5901024703",
      "display" : "吾家藥局"
    },
    {
      "code" : "5901024721",
      "display" : "麗泰藥局"
    },
    {
      "code" : "5901024767",
      "display" : "杏一樂業藥局"
    },
    {
      "code" : "5901024810",
      "display" : "博興藥局"
    },
    {
      "code" : "5901024838",
      "display" : "昶青藥局"
    },
    {
      "code" : "5901024856",
      "display" : "杏一台北國泰藥局"
    },
    {
      "code" : "5901024865",
      "display" : "沛林東區生活藥粧藥局"
    },
    {
      "code" : "5901024874",
      "display" : "奇異果大安藥局"
    },
    {
      "code" : "5901024892",
      "display" : "太醫藥局"
    },
    {
      "code" : "5901024909",
      "display" : "康維健保藥局"
    },
    {
      "code" : "5901024918",
      "display" : "康祥藥局"
    },
    {
      "code" : "5901024945",
      "display" : "威康藥局"
    },
    {
      "code" : "5901024954",
      "display" : "佑全大安敦南藥局"
    },
    {
      "code" : "5901024981",
      "display" : "專品六張犁藥局"
    },
    {
      "code" : "5901025004",
      "display" : "早安藥局"
    },
    {
      "code" : "5901025013",
      "display" : "頤品中西藥局"
    },
    {
      "code" : "5901025022",
      "display" : "躍獅敦和藥局"
    },
    {
      "code" : "5901025031",
      "display" : "中力信義藥局"
    },
    {
      "code" : "5901025040",
      "display" : "弘昌藥局"
    },
    {
      "code" : "5901025059",
      "display" : "博醫仁愛藥局"
    },
    {
      "code" : "5901025068",
      "display" : "鎮安中西安和藥局"
    },
    {
      "code" : "5901025077",
      "display" : "敦南春天藥局"
    },
    {
      "code" : "5901025102",
      "display" : "博興藥局"
    },
    {
      "code" : "5901025111",
      "display" : "太醫藥局"
    },
    {
      "code" : "5901025120",
      "display" : "十二願永藥局"
    },
    {
      "code" : "5901025139",
      "display" : "愛立藥局"
    },
    {
      "code" : "5901025148",
      "display" : "康是美仁愛藥局"
    },
    {
      "code" : "5901025166",
      "display" : "佳鄰藥局"
    },
    {
      "code" : "5901025175",
      "display" : "國泰藥局"
    },
    {
      "code" : "5901025184",
      "display" : "伊生藥局"
    },
    {
      "code" : "5901025193",
      "display" : "信義欣辰藥局"
    },
    {
      "code" : "5901025200",
      "display" : "中力信義藥局"
    },
    {
      "code" : "5901025228",
      "display" : "康是美巨富藥局"
    },
    {
      "code" : "5901025237",
      "display" : "伊生藥局"
    },
    {
      "code" : "5901025246",
      "display" : "康是美仁愛藥局"
    },
    {
      "code" : "5901025255",
      "display" : "宏大藥師藥局"
    },
    {
      "code" : "5901025264",
      "display" : "康祥藥局"
    },
    {
      "code" : "5901025273",
      "display" : "百立藥局"
    },
    {
      "code" : "5901025282",
      "display" : "國泰藥局"
    },
    {
      "code" : "5901025291",
      "display" : "太醫藥局"
    },
    {
      "code" : "5901025308",
      "display" : "吉成藥局"
    },
    {
      "code" : "5901025317",
      "display" : "安東藥局"
    },
    {
      "code" : "5901025335",
      "display" : "加佳藥局"
    },
    {
      "code" : "5901025344",
      "display" : "昶青藥局"
    },
    {
      "code" : "5901025353",
      "display" : "康是美安居藥局"
    },
    {
      "code" : "5901025362",
      "display" : "美心藥局"
    },
    {
      "code" : "5901025371",
      "display" : "吾家藥局"
    },
    {
      "code" : "5901025380",
      "display" : "康是美巨富藥局"
    },
    {
      "code" : "5901025399",
      "display" : "敦南春天藥局"
    },
    {
      "code" : "5901025406",
      "display" : "博昱師大藥局"
    },
    {
      "code" : "5901025415",
      "display" : "安東藥局"
    },
    {
      "code" : "5901025424",
      "display" : "博興藥局"
    },
    {
      "code" : "5901025442",
      "display" : "美心藥局"
    },
    {
      "code" : "5901025479",
      "display" : "博昱師大藥局"
    },
    {
      "code" : "5901025488",
      "display" : "博興藥局"
    },
    {
      "code" : "5901025497",
      "display" : "國泰藥局"
    },
    {
      "code" : "5901025513",
      "display" : "敦南春天藥局"
    },
    {
      "code" : "5901025522",
      "display" : "安森藥局"
    },
    {
      "code" : "5901025531",
      "display" : "康是美安居藥局"
    },
    {
      "code" : "5901025559",
      "display" : "太醫藥局"
    },
    {
      "code" : "5901025568",
      "display" : "奇異果大安藥局"
    },
    {
      "code" : "5901025577",
      "display" : "博大藥局"
    },
    {
      "code" : "5901025586",
      "display" : "美心藥局"
    },
    {
      "code" : "5901025595",
      "display" : "仁慈藥局"
    },
    {
      "code" : "5901025611",
      "display" : "康是美巨富藥局"
    },
    {
      "code" : "5901025639",
      "display" : "伊生藥局"
    },
    {
      "code" : "5901025648",
      "display" : "早安藥局"
    },
    {
      "code" : "5901025657",
      "display" : "柚心藥局"
    },
    {
      "code" : "5901090074",
      "display" : "慈仁藥局"
    },
    {
      "code" : "5901090127",
      "display" : "三銘大藥局"
    },
    {
      "code" : "5901090154",
      "display" : "柯藥局"
    },
    {
      "code" : "5901090181",
      "display" : "時春藥局"
    },
    {
      "code" : "5901090216",
      "display" : "裕仁藥局"
    },
    {
      "code" : "5901090243",
      "display" : "建祥藥局"
    },
    {
      "code" : "5901090289",
      "display" : "正利民藥局"
    },
    {
      "code" : "5901090323",
      "display" : "泰元藥局"
    },
    {
      "code" : "5901090341",
      "display" : "正中藥局"
    },
    {
      "code" : "5901090369",
      "display" : "保慶藥局"
    },
    {
      "code" : "5901091473",
      "display" : "快安藥局"
    },
    {
      "code" : "5901091544",
      "display" : "得意藥師藥局"
    },
    {
      "code" : "5901091624",
      "display" : "健康美藥局"
    },
    {
      "code" : "5901091688",
      "display" : "宏泰藥師藥局"
    },
    {
      "code" : "5901091759",
      "display" : "儷安藥局"
    },
    {
      "code" : "5901091820",
      "display" : "富康藥局"
    },
    {
      "code" : "5901091857",
      "display" : "佳禾藥局"
    },
    {
      "code" : "5901091884",
      "display" : "躍獅雙蓮藥局"
    },
    {
      "code" : "5901091973",
      "display" : "延平新聖安藥局"
    },
    {
      "code" : "5901091991",
      "display" : "德芳藥局"
    },
    {
      "code" : "5901092014",
      "display" : "旭豐藥局"
    },
    {
      "code" : "5901092050",
      "display" : "中興聯合藥局"
    },
    {
      "code" : "5901092069",
      "display" : "躍獅遠東藥局"
    },
    {
      "code" : "5901092087",
      "display" : "躍獅文昌藥局"
    },
    {
      "code" : "5901092096",
      "display" : "春鄰藥局"
    },
    {
      "code" : "5901092103",
      "display" : "新聖安藥局"
    },
    {
      "code" : "5901092112",
      "display" : "酒泉春天藥局"
    },
    {
      "code" : "5901092130",
      "display" : "大同民生藥局"
    },
    {
      "code" : "5901092149",
      "display" : "123宅藥局"
    },
    {
      "code" : "5901092158",
      "display" : "慶福藥局"
    },
    {
      "code" : "5901092176",
      "display" : "延平藥局"
    },
    {
      "code" : "5901092194",
      "display" : "立赫大龍藥局"
    },
    {
      "code" : "5901092210",
      "display" : "春鄰藥局"
    },
    {
      "code" : "5901092238",
      "display" : "酒泉春天藥局"
    },
    {
      "code" : "5901092247",
      "display" : "圓保藥局"
    },
    {
      "code" : "5901092256",
      "display" : "德芳藥局"
    },
    {
      "code" : "5901092265",
      "display" : "光年藥局"
    },
    {
      "code" : "5901092274",
      "display" : "圓保藥局"
    },
    {
      "code" : "5901092292",
      "display" : "揚雅藥局"
    },
    {
      "code" : "5901092309",
      "display" : "保安藥局"
    },
    {
      "code" : "5901092318",
      "display" : "北醫大藥局"
    },
    {
      "code" : "5901100057",
      "display" : "百源堂大藥局"
    },
    {
      "code" : "5901100066",
      "display" : "名祥藥局"
    },
    {
      "code" : "5901100155",
      "display" : "大信藥局"
    },
    {
      "code" : "5901100244",
      "display" : "定好大藥局"
    },
    {
      "code" : "5901100333",
      "display" : "明美藥局"
    },
    {
      "code" : "5901100342",
      "display" : "順泰藥局"
    },
    {
      "code" : "5901100422",
      "display" : "滿順藥局"
    },
    {
      "code" : "5901100431",
      "display" : "長生藥局"
    },
    {
      "code" : "5901100440",
      "display" : "優豐藥局"
    },
    {
      "code" : "5901100495",
      "display" : "能康藥局"
    },
    {
      "code" : "5901100628",
      "display" : "貢玄藥局"
    },
    {
      "code" : "5901100664",
      "display" : "阿里藥局"
    },
    {
      "code" : "5901100717",
      "display" : "榮昌藥局"
    },
    {
      "code" : "5901100735",
      "display" : "華友藥局"
    },
    {
      "code" : "5901100771",
      "display" : "良佑藥局"
    },
    {
      "code" : "5901100799",
      "display" : "立大藥局"
    },
    {
      "code" : "5901100959",
      "display" : "武璋大藥局"
    },
    {
      "code" : "5901101072",
      "display" : "長青藥局"
    },
    {
      "code" : "5901101161",
      "display" : "晏晟藥局"
    },
    {
      "code" : "5901101205",
      "display" : "大直藥局"
    },
    {
      "code" : "5901101250",
      "display" : "美日藥局"
    },
    {
      "code" : "5901101278",
      "display" : "人人藥局"
    },
    {
      "code" : "5901101321",
      "display" : "文德藥局"
    },
    {
      "code" : "5901101509",
      "display" : "永直藥局"
    },
    {
      "code" : "5901101536",
      "display" : "展佑藥局"
    },
    {
      "code" : "5901101607",
      "display" : "蓁榛健康生活藥局"
    },
    {
      "code" : "5901101625",
      "display" : "中崙藥局"
    },
    {
      "code" : "5901101652",
      "display" : "祥泰藥局"
    },
    {
      "code" : "5901101910",
      "display" : "嘉恩藥局"
    },
    {
      "code" : "5901101929",
      "display" : "樂活苑藥局"
    },
    {
      "code" : "5901101992",
      "display" : "大愛藥師藥局"
    },
    {
      "code" : "5901102015",
      "display" : "久大藥局"
    },
    {
      "code" : "5901102060",
      "display" : "專心藥局"
    },
    {
      "code" : "5901102408",
      "display" : "康林藥局"
    },
    {
      "code" : "5901102417",
      "display" : "民生興安藥局"
    },
    {
      "code" : "5901102444",
      "display" : "啟美藥師藥局"
    },
    {
      "code" : "5901102515",
      "display" : "華康藥局"
    },
    {
      "code" : "5901102560",
      "display" : "龍江藥局"
    },
    {
      "code" : "5901102579",
      "display" : "躍獅晴光藥局"
    },
    {
      "code" : "5901102597",
      "display" : "德惠藥局"
    },
    {
      "code" : "5901102631",
      "display" : "金生藥局"
    },
    {
      "code" : "5901102677",
      "display" : "興康源藥局"
    },
    {
      "code" : "5901102686",
      "display" : "富宥康藥局"
    },
    {
      "code" : "5901102748",
      "display" : "淮濟藥師藥局"
    },
    {
      "code" : "5901102828",
      "display" : "逸帆藥局"
    },
    {
      "code" : "5901102837",
      "display" : "正傑健保藥局"
    },
    {
      "code" : "5901102855",
      "display" : "錦西春天生活藥局"
    },
    {
      "code" : "5901102891",
      "display" : "中山藥局"
    },
    {
      "code" : "5901102962",
      "display" : "中興藥局"
    },
    {
      "code" : "5901102971",
      "display" : "保德明水藥局"
    },
    {
      "code" : "5901102999",
      "display" : "廣福中西藥局"
    },
    {
      "code" : "5901103110",
      "display" : "大直健康藥局"
    },
    {
      "code" : "5901103147",
      "display" : "娸淇藥局"
    },
    {
      "code" : "5901103183",
      "display" : "OK藥師藥局"
    },
    {
      "code" : "5901103192",
      "display" : "昶青林森藥局"
    },
    {
      "code" : "5901103209",
      "display" : "麗恩藥局"
    },
    {
      "code" : "5901103227",
      "display" : "建誠中西藥局"
    },
    {
      "code" : "5901103236",
      "display" : "誠意中西藥局"
    },
    {
      "code" : "5901103272",
      "display" : "長安藥局"
    },
    {
      "code" : "5901103325",
      "display" : "仁一藥局"
    },
    {
      "code" : "5901103334",
      "display" : "大直小太陽藥局"
    },
    {
      "code" : "5901103343",
      "display" : "王中興藥局"
    },
    {
      "code" : "5901103352",
      "display" : "美康正康藥局"
    },
    {
      "code" : "5901103405",
      "display" : "大直永安藥局"
    },
    {
      "code" : "5901103414",
      "display" : "元宏藥局"
    },
    {
      "code" : "5901103423",
      "display" : "農安藥局"
    },
    {
      "code" : "5901103469",
      "display" : "聖晨藥局"
    },
    {
      "code" : "5901103487",
      "display" : "錦州春天生活藥局"
    },
    {
      "code" : "5901103521",
      "display" : "中華藥局"
    },
    {
      "code" : "5901103530",
      "display" : "農安盛康藥局"
    },
    {
      "code" : "5901103558",
      "display" : "佳頤中西藥局"
    },
    {
      "code" : "5901103576",
      "display" : "康銓藥局"
    },
    {
      "code" : "5901103585",
      "display" : "禾全藥局"
    },
    {
      "code" : "5901103629",
      "display" : "十二願藥局"
    },
    {
      "code" : "5901103647",
      "display" : "禾康藥局"
    },
    {
      "code" : "5901103656",
      "display" : "大樹龍江藥局"
    },
    {
      "code" : "5901103665",
      "display" : "安悅藥局"
    },
    {
      "code" : "5901103674",
      "display" : "康廷藥局"
    },
    {
      "code" : "5901103683",
      "display" : "東東藥局"
    },
    {
      "code" : "5901103692",
      "display" : "誠果中西藥局"
    },
    {
      "code" : "5901103727",
      "display" : "盛康藥局"
    },
    {
      "code" : "5901103736",
      "display" : "杏一龍錦藥局"
    },
    {
      "code" : "5901103745",
      "display" : "吉林藥局"
    },
    {
      "code" : "5901103754",
      "display" : "永育康暉藥局"
    },
    {
      "code" : "5901103772",
      "display" : "興耀生活藥局"
    },
    {
      "code" : "5901103781",
      "display" : "龍江台安藥局"
    },
    {
      "code" : "5901103790",
      "display" : "可康藥局"
    },
    {
      "code" : "5901103807",
      "display" : "專品龍江藥局"
    },
    {
      "code" : "5901103816",
      "display" : "躍獅龍江藥局"
    },
    {
      "code" : "5901103834",
      "display" : "弘元中西藥局"
    },
    {
      "code" : "5901103843",
      "display" : "錦西春天生活藥局"
    },
    {
      "code" : "5901103852",
      "display" : "農安台安藥局"
    },
    {
      "code" : "5901103870",
      "display" : "杏一龍錦藥局"
    },
    {
      "code" : "5901103889",
      "display" : "吉林藥局"
    },
    {
      "code" : "5901103898",
      "display" : "康廷藥局"
    },
    {
      "code" : "5901103905",
      "display" : "興耀生活藥局"
    },
    {
      "code" : "5901103932",
      "display" : "喜康中西藥局"
    },
    {
      "code" : "5901103941",
      "display" : "興耀生活藥局"
    },
    {
      "code" : "5901103950",
      "display" : "沛久藥局"
    },
    {
      "code" : "5901103969",
      "display" : "龍江台安藥局"
    },
    {
      "code" : "5901103987",
      "display" : "龍江台安藥局"
    },
    {
      "code" : "5901103996",
      "display" : "艾禾藥局"
    },
    {
      "code" : "5901104000",
      "display" : "中崙藥局"
    },
    {
      "code" : "5901104019",
      "display" : "明水藥局"
    },
    {
      "code" : "5901104028",
      "display" : "錦州藥局"
    },
    {
      "code" : "5901104037",
      "display" : "農安藥局"
    },
    {
      "code" : "5901104046",
      "display" : "吉林藥局"
    },
    {
      "code" : "5901104055",
      "display" : "龍江台安藥局"
    },
    {
      "code" : "5901104064",
      "display" : "杏一龍錦藥局"
    },
    {
      "code" : "5901104082",
      "display" : "滿順藥局"
    },
    {
      "code" : "5901104091",
      "display" : "躍獅冠冠藥局"
    },
    {
      "code" : "5901104117",
      "display" : "永直藥局"
    },
    {
      "code" : "5901104135",
      "display" : "美康正康藥局"
    },
    {
      "code" : "5901104144",
      "display" : "中山伊通藥局"
    },
    {
      "code" : "5901104153",
      "display" : "杏一龍錦藥局"
    },
    {
      "code" : "5901104162",
      "display" : "十二願湛藥局"
    },
    {
      "code" : "5901104171",
      "display" : "明水藥局"
    },
    {
      "code" : "5901104199",
      "display" : "吉林台安藥局"
    },
    {
      "code" : "5901104206",
      "display" : "起點藥局"
    },
    {
      "code" : "5901104224",
      "display" : "吉林台安藥局"
    },
    {
      "code" : "5901104233",
      "display" : "農安台安藥局"
    },
    {
      "code" : "5901104242",
      "display" : "美康正康藥局"
    },
    {
      "code" : "5901104251",
      "display" : "易康藥局"
    },
    {
      "code" : "5901104260",
      "display" : "星安藥局"
    },
    {
      "code" : "5901104279",
      "display" : "躍健康藥局"
    },
    {
      "code" : "5901104288",
      "display" : "農安台安藥局"
    },
    {
      "code" : "5901110080",
      "display" : "葛蘭素藥局"
    },
    {
      "code" : "5901110133",
      "display" : "泰成藥局"
    },
    {
      "code" : "5901110268",
      "display" : "赫得藥局"
    },
    {
      "code" : "5901110302",
      "display" : "富盛藥局"
    },
    {
      "code" : "5901110311",
      "display" : "永安藥局"
    },
    {
      "code" : "5901110339",
      "display" : "富山藥局"
    },
    {
      "code" : "5901110393",
      "display" : "明湖藥局"
    },
    {
      "code" : "5901110446",
      "display" : "清白藥局"
    },
    {
      "code" : "5901110624",
      "display" : "宏光藥局"
    },
    {
      "code" : "5901111863",
      "display" : "杏佳藥局"
    },
    {
      "code" : "5901111890",
      "display" : "安康藥局"
    },
    {
      "code" : "5901111934",
      "display" : "至康藥局"
    },
    {
      "code" : "5901112011",
      "display" : "文新藥局"
    },
    {
      "code" : "5901112100",
      "display" : "盧狄聯合藥局"
    },
    {
      "code" : "5901112351",
      "display" : "康信藥局"
    },
    {
      "code" : "5901112593",
      "display" : "康健藥局"
    },
    {
      "code" : "5901112600",
      "display" : "匯安藥局"
    },
    {
      "code" : "5901112682",
      "display" : "富康東湖藥局"
    },
    {
      "code" : "5901112726",
      "display" : "高昱藥局"
    },
    {
      "code" : "5901112762",
      "display" : "樂活藥師藥局"
    },
    {
      "code" : "5901112780",
      "display" : "樂康藥妝藥局"
    },
    {
      "code" : "5901112824",
      "display" : "思恩藥局"
    },
    {
      "code" : "5901112842",
      "display" : "早安元氣藥局"
    },
    {
      "code" : "5901112860",
      "display" : "展恩藥局"
    },
    {
      "code" : "5901112879",
      "display" : "壹零捌藥局"
    },
    {
      "code" : "5901112977",
      "display" : "瑞光藥局"
    },
    {
      "code" : "5901112995",
      "display" : "昇龍藥局"
    },
    {
      "code" : "5901113018",
      "display" : "桔子藥局"
    },
    {
      "code" : "5901113027",
      "display" : "晟安藥局"
    },
    {
      "code" : "5901113081",
      "display" : "宜昇優良藥局"
    },
    {
      "code" : "5901113143",
      "display" : "躍獅寶湖藥局"
    },
    {
      "code" : "5901113198",
      "display" : "傑昇藥局"
    },
    {
      "code" : "5901113205",
      "display" : "新安健保藥局"
    },
    {
      "code" : "5901113223",
      "display" : "仕德安藥局"
    },
    {
      "code" : "5901113232",
      "display" : "躍獅東湖藥局"
    },
    {
      "code" : "5901113250",
      "display" : "大內湖藥局"
    },
    {
      "code" : "5901113269",
      "display" : "樂齡藥師藥局"
    },
    {
      "code" : "5901113296",
      "display" : "喜越藥局"
    },
    {
      "code" : "5901113312",
      "display" : "江南大藥局"
    },
    {
      "code" : "5901113330",
      "display" : "躍獅大湖藥局"
    },
    {
      "code" : "5901113349",
      "display" : "澴山藥局"
    },
    {
      "code" : "5901113367",
      "display" : "瑞暉藥局"
    },
    {
      "code" : "5901113385",
      "display" : "躍獅康成藥局"
    },
    {
      "code" : "5901113401",
      "display" : "躍獅麗湖藥局"
    },
    {
      "code" : "5901113438",
      "display" : "晶龍藥局"
    },
    {
      "code" : "5901113456",
      "display" : "佑全內湖康寧藥局"
    },
    {
      "code" : "5901113509",
      "display" : "安安藥局"
    },
    {
      "code" : "5901113536",
      "display" : "原大藥局"
    },
    {
      "code" : "5901113545",
      "display" : "和康健保藥局"
    },
    {
      "code" : "5901113563",
      "display" : "耀元藥局"
    },
    {
      "code" : "5901113572",
      "display" : "西湖藥局"
    },
    {
      "code" : "5901113590",
      "display" : "維安藥局"
    },
    {
      "code" : "5901113616",
      "display" : "瑞陽藥局"
    },
    {
      "code" : "5901113625",
      "display" : "富康文德藥局"
    },
    {
      "code" : "5901113643",
      "display" : "博昱東福藥局"
    },
    {
      "code" : "5901113652",
      "display" : "加一藥師藥局"
    },
    {
      "code" : "5901113661",
      "display" : "內湖藥局"
    },
    {
      "code" : "5901113689",
      "display" : "葫光藥局"
    },
    {
      "code" : "5901113698",
      "display" : "禾馨民權藥局"
    },
    {
      "code" : "5901113705",
      "display" : "富康活力湖光藥局"
    },
    {
      "code" : "5901113723",
      "display" : "杏一港墘藥局"
    },
    {
      "code" : "5901113732",
      "display" : "富康活力誠功藥局"
    },
    {
      "code" : "5901113741",
      "display" : "原大藥局"
    },
    {
      "code" : "5901113750",
      "display" : "杏佳藥師藥局"
    },
    {
      "code" : "5901113769",
      "display" : "瑞陽藥局"
    },
    {
      "code" : "5901113787",
      "display" : "富田藥局"
    },
    {
      "code" : "5901113796",
      "display" : "健成藥局"
    },
    {
      "code" : "5901113803",
      "display" : "五分藥局"
    },
    {
      "code" : "5901113812",
      "display" : "佑全內湖東湖藥局"
    },
    {
      "code" : "5901113821",
      "display" : "原大藥局"
    },
    {
      "code" : "5901113849",
      "display" : "佳德健保藥局"
    },
    {
      "code" : "5901113858",
      "display" : "五分藥局"
    },
    {
      "code" : "5901113867",
      "display" : "富康活力湖光藥局"
    },
    {
      "code" : "5901113876",
      "display" : "江楠欣辰藥局"
    },
    {
      "code" : "5901113885",
      "display" : "內湖春天藥局"
    },
    {
      "code" : "5901113894",
      "display" : "六本熊藥局"
    },
    {
      "code" : "5901113901",
      "display" : "原大藥局"
    },
    {
      "code" : "5901113910",
      "display" : "新資生西湖大藥局"
    },
    {
      "code" : "5901113938",
      "display" : "德威藥局"
    },
    {
      "code" : "5901113947",
      "display" : "永樂藥局"
    },
    {
      "code" : "5901113956",
      "display" : "新資生康寧大藥局"
    },
    {
      "code" : "5901113965",
      "display" : "東湖藥局"
    },
    {
      "code" : "5901113974",
      "display" : "五分藥局"
    },
    {
      "code" : "5901113992",
      "display" : "富康活力誠功藥局"
    },
    {
      "code" : "5901114015",
      "display" : "知壹藥局"
    },
    {
      "code" : "5901114024",
      "display" : "內湖春天藥局"
    },
    {
      "code" : "5901114033",
      "display" : "康是美麗湖藥局"
    },
    {
      "code" : "5901114042",
      "display" : "安安藥局"
    },
    {
      "code" : "5901114051",
      "display" : "躍獅麗湖藥局"
    },
    {
      "code" : "5901114060",
      "display" : "安康藥局"
    },
    {
      "code" : "5901114079",
      "display" : "內湖春天藥局"
    },
    {
      "code" : "5901114088",
      "display" : "躍獅麗湖藥局"
    },
    {
      "code" : "5901114097",
      "display" : "成功啄木鳥藥局"
    },
    {
      "code" : "5901114104",
      "display" : "新資生西湖大藥局"
    },
    {
      "code" : "5901114113",
      "display" : "江楠欣辰藥局"
    },
    {
      "code" : "5901114122",
      "display" : "東湖藥局"
    },
    {
      "code" : "5901114131",
      "display" : "瑞陽藥局"
    },
    {
      "code" : "5901114140",
      "display" : "躍獅麗湖藥局"
    },
    {
      "code" : "5901114159",
      "display" : "康樂藥局"
    },
    {
      "code" : "5901114177",
      "display" : "西湖桔子藥局"
    },
    {
      "code" : "5901114186",
      "display" : "江楠欣辰藥局"
    },
    {
      "code" : "5901114195",
      "display" : "躍獅陽光藥局"
    },
    {
      "code" : "5901114211",
      "display" : "富康活力誠功藥局"
    },
    {
      "code" : "5901120022",
      "display" : "旭村藥局"
    },
    {
      "code" : "5901120139",
      "display" : "裕成藥局"
    },
    {
      "code" : "5901120175",
      "display" : "新錦安藥局"
    },
    {
      "code" : "5901120184",
      "display" : "仁泰藥局"
    },
    {
      "code" : "5901120308",
      "display" : "加欣藥局"
    },
    {
      "code" : "5901121421",
      "display" : "祥安藥局"
    },
    {
      "code" : "5901121449",
      "display" : "麗康藥局"
    },
    {
      "code" : "5901121494",
      "display" : "德鴻藥局"
    },
    {
      "code" : "5901121501",
      "display" : "親親藥局"
    },
    {
      "code" : "5901121583",
      "display" : "健園藥局"
    },
    {
      "code" : "5901121618",
      "display" : "新東發藥局"
    },
    {
      "code" : "5901121627",
      "display" : "富康活力藥局"
    },
    {
      "code" : "5901121672",
      "display" : "亞博藥師藥局"
    },
    {
      "code" : "5901121725",
      "display" : "佳龍藥局"
    },
    {
      "code" : "5901121734",
      "display" : "湳港藥局"
    },
    {
      "code" : "5901121798",
      "display" : "進慧藥局"
    },
    {
      "code" : "5901121823",
      "display" : "儀安健保藥局"
    },
    {
      "code" : "5901121841",
      "display" : "泓安藥局"
    },
    {
      "code" : "5901121850",
      "display" : "健涵藥局"
    },
    {
      "code" : "5901121869",
      "display" : "南港藥局"
    },
    {
      "code" : "5901121896",
      "display" : "順翔藥局"
    },
    {
      "code" : "5901121903",
      "display" : "景星藥局"
    },
    {
      "code" : "5901121912",
      "display" : "成恩藥局"
    },
    {
      "code" : "5901121930",
      "display" : "小藥師健保藥局"
    },
    {
      "code" : "5901121958",
      "display" : "心亮藥局"
    },
    {
      "code" : "5901121985",
      "display" : "勝安藥局"
    },
    {
      "code" : "5901122053",
      "display" : "開欣藥局"
    },
    {
      "code" : "5901122062",
      "display" : "躍獅忠孝藥局"
    },
    {
      "code" : "5901122080",
      "display" : "成福大藥局"
    },
    {
      "code" : "5901122099",
      "display" : "心心藥局"
    },
    {
      "code" : "5901122115",
      "display" : "上丞藥師藥局"
    },
    {
      "code" : "5901122124",
      "display" : "杏安藥局"
    },
    {
      "code" : "5901122142",
      "display" : "東明藥局"
    },
    {
      "code" : "5901122151",
      "display" : "成福大藥局"
    },
    {
      "code" : "5901122188",
      "display" : "群悅藥局"
    },
    {
      "code" : "5901122197",
      "display" : "康是美港研藥局"
    },
    {
      "code" : "5901122204",
      "display" : "上丞藥師藥局"
    },
    {
      "code" : "5901122222",
      "display" : "富凱昆陽藥局"
    },
    {
      "code" : "5901122240",
      "display" : "日出藥局"
    },
    {
      "code" : "5901122259",
      "display" : "康是美港研藥局"
    },
    {
      "code" : "5901122268",
      "display" : "富康活力眾坡藥局"
    },
    {
      "code" : "5901122286",
      "display" : "康是美港研藥局"
    },
    {
      "code" : "5901122295",
      "display" : "麗康藥局"
    },
    {
      "code" : "5901150011",
      "display" : "南風藥局"
    },
    {
      "code" : "5901150057",
      "display" : "菁安藥局"
    },
    {
      "code" : "5901150128",
      "display" : "新興藥局"
    },
    {
      "code" : "5901150146",
      "display" : "坤成泰藥局"
    },
    {
      "code" : "5901150235",
      "display" : "杏城藥局"
    },
    {
      "code" : "5901150244",
      "display" : "佳赫藥局"
    },
    {
      "code" : "5901150253",
      "display" : "文祥藥局"
    },
    {
      "code" : "5901150271",
      "display" : "建芳藥局"
    },
    {
      "code" : "5901150280",
      "display" : "慈航藥局"
    },
    {
      "code" : "5901150342",
      "display" : "士林三安藥局"
    },
    {
      "code" : "5901150351",
      "display" : "啓宏藥局"
    },
    {
      "code" : "5901150397",
      "display" : "博惠藥局"
    },
    {
      "code" : "5901150459",
      "display" : "有德堂大藥局"
    },
    {
      "code" : "5901150468",
      "display" : "太安藥局"
    },
    {
      "code" : "5901150548",
      "display" : "田倉藥局"
    },
    {
      "code" : "5901150575",
      "display" : "日康藥局"
    },
    {
      "code" : "5901150593",
      "display" : "安寧藥局"
    },
    {
      "code" : "5901150600",
      "display" : "環安藥局"
    },
    {
      "code" : "5901150682",
      "display" : "加赫藥局"
    },
    {
      "code" : "5901150762",
      "display" : "麗森藥局"
    },
    {
      "code" : "5901150771",
      "display" : "天母大和藥師藥局"
    },
    {
      "code" : "5901150815",
      "display" : "陽明藥局"
    },
    {
      "code" : "5901151956",
      "display" : "康鈺藥局"
    },
    {
      "code" : "5901152024",
      "display" : "今欣藥局"
    },
    {
      "code" : "5901152079",
      "display" : "資生堂藥局"
    },
    {
      "code" : "5901152122",
      "display" : "社子全民藥局"
    },
    {
      "code" : "5901152131",
      "display" : "康華藥局"
    },
    {
      "code" : "5901152186",
      "display" : "詠恩藥局"
    },
    {
      "code" : "5901152293",
      "display" : "安泰藥師藥局"
    },
    {
      "code" : "5901152453",
      "display" : "家赫藥局"
    },
    {
      "code" : "5901152471",
      "display" : "得安藥局"
    },
    {
      "code" : "5901152604",
      "display" : "達揚藥局"
    },
    {
      "code" : "5901152640",
      "display" : "仁大藥局"
    },
    {
      "code" : "5901152659",
      "display" : "和樹藥局"
    },
    {
      "code" : "5901152686",
      "display" : "三光藥局"
    },
    {
      "code" : "5901152720",
      "display" : "博信藥局"
    },
    {
      "code" : "5901152739",
      "display" : "芳圓藥局"
    },
    {
      "code" : "5901152748",
      "display" : "柏雅大藥局"
    },
    {
      "code" : "5901152793",
      "display" : "信光藥局"
    },
    {
      "code" : "5901152873",
      "display" : "幸福藥局"
    },
    {
      "code" : "5901152882",
      "display" : "天爵藥局"
    },
    {
      "code" : "5901152971",
      "display" : "石川藥師藥局"
    },
    {
      "code" : "5901153058",
      "display" : "誼安藥局"
    },
    {
      "code" : "5901153101",
      "display" : "聖賢藥局"
    },
    {
      "code" : "5901153110",
      "display" : "美麗田藥局"
    },
    {
      "code" : "5901153245",
      "display" : "大東健保藥局"
    },
    {
      "code" : "5901153263",
      "display" : "健揚藥局"
    },
    {
      "code" : "5901153272",
      "display" : "光榮藥局"
    },
    {
      "code" : "5901153325",
      "display" : "天母康甯健保藥局"
    },
    {
      "code" : "5901153432",
      "display" : "大南春天生活藥局"
    },
    {
      "code" : "5901153487",
      "display" : "和謙藥局"
    },
    {
      "code" : "5901153496",
      "display" : "躍獅忠誠藥局"
    },
    {
      "code" : "5901153503",
      "display" : "祥新藥局"
    },
    {
      "code" : "5901153521",
      "display" : "天母台安藥局"
    },
    {
      "code" : "5901153567",
      "display" : "華齡春天生活藥局"
    },
    {
      "code" : "5901153585",
      "display" : "德行春天生活藥局"
    },
    {
      "code" : "5901153610",
      "display" : "家安健保藥局"
    },
    {
      "code" : "5901153665",
      "display" : "康佑藥局"
    },
    {
      "code" : "5901153674",
      "display" : "愛佳藥局"
    },
    {
      "code" : "5901153683",
      "display" : "安奕藥局"
    },
    {
      "code" : "5901153709",
      "display" : "全予藥局"
    },
    {
      "code" : "5901153727",
      "display" : "前港盛康藥局"
    },
    {
      "code" : "5901153825",
      "display" : "太和堂中西藥局"
    },
    {
      "code" : "5901153861",
      "display" : "佩佩藥局"
    },
    {
      "code" : "5901153870",
      "display" : "容育藥局"
    },
    {
      "code" : "5901153905",
      "display" : "躍獅芝山藥局"
    },
    {
      "code" : "5901153923",
      "display" : "三原藥局"
    },
    {
      "code" : "5901153941",
      "display" : "士東藥局"
    },
    {
      "code" : "5901153969",
      "display" : "杏一士林延平藥局"
    },
    {
      "code" : "5901153996",
      "display" : "文昌春天藥局"
    },
    {
      "code" : "5901154000",
      "display" : "文昌大藥局"
    },
    {
      "code" : "5901154019",
      "display" : "忠義台安藥局"
    },
    {
      "code" : "5901154028",
      "display" : "向宇藥局"
    },
    {
      "code" : "5901154055",
      "display" : "天母盛康藥局"
    },
    {
      "code" : "5901154073",
      "display" : "中山盛康藥局"
    },
    {
      "code" : "5901154082",
      "display" : "德行盛康藥局"
    },
    {
      "code" : "5901154091",
      "display" : "社正藥局"
    },
    {
      "code" : "5901154108",
      "display" : "藥本家藥局"
    },
    {
      "code" : "5901154135",
      "display" : "誠泰中西藥局"
    },
    {
      "code" : "5901154144",
      "display" : "加赫藥局"
    },
    {
      "code" : "5901154153",
      "display" : "美麗田藥局"
    },
    {
      "code" : "5901154162",
      "display" : "慈航藥局"
    },
    {
      "code" : "5901154171",
      "display" : "德行盛康藥局"
    },
    {
      "code" : "5901154180",
      "display" : "劍潭藥局"
    },
    {
      "code" : "5901154199",
      "display" : "心晴藥局"
    },
    {
      "code" : "5901154206",
      "display" : "向謙未來藥局"
    },
    {
      "code" : "5901154215",
      "display" : "沐光中西藥局"
    },
    {
      "code" : "5901154224",
      "display" : "文昌春天藥局"
    },
    {
      "code" : "5901154233",
      "display" : "向宇藥局"
    },
    {
      "code" : "5901154251",
      "display" : "千盛台安藥局"
    },
    {
      "code" : "5901154260",
      "display" : "健揚藥局"
    },
    {
      "code" : "5901154279",
      "display" : "千盛台安藥局"
    },
    {
      "code" : "5901154288",
      "display" : "康是美士東藥局"
    },
    {
      "code" : "5901154297",
      "display" : "社正藥局"
    },
    {
      "code" : "5901154313",
      "display" : "社子藥局"
    },
    {
      "code" : "5901154331",
      "display" : "天養藥局"
    },
    {
      "code" : "5901154340",
      "display" : "士林泰安藥局"
    },
    {
      "code" : "5901154377",
      "display" : "晨熙藥局"
    },
    {
      "code" : "5901154386",
      "display" : "千盛台安藥局"
    },
    {
      "code" : "5901154395",
      "display" : "躍獅福港藥局"
    },
    {
      "code" : "5901154402",
      "display" : "宜家藥局"
    },
    {
      "code" : "5901154411",
      "display" : "家赫宇盛藥局"
    },
    {
      "code" : "5901154420",
      "display" : "前港台安藥局"
    },
    {
      "code" : "5901154448",
      "display" : "向宇藥局"
    },
    {
      "code" : "5901154457",
      "display" : "天母藥局"
    },
    {
      "code" : "5901154466",
      "display" : "大田大藥局"
    },
    {
      "code" : "5901154475",
      "display" : "有為藥局"
    },
    {
      "code" : "5901154484",
      "display" : "忠義台安藥局"
    },
    {
      "code" : "5901154493",
      "display" : "芝山藥局"
    },
    {
      "code" : "5901154500",
      "display" : "富康活力通河藥局"
    },
    {
      "code" : "5901154519",
      "display" : "通河藥局"
    },
    {
      "code" : "5901154528",
      "display" : "文林藥局"
    },
    {
      "code" : "5901154546",
      "display" : "士東藥局"
    },
    {
      "code" : "5901154555",
      "display" : "沐光中西藥局"
    },
    {
      "code" : "5901154564",
      "display" : "德行春天生活藥局"
    },
    {
      "code" : "5901154573",
      "display" : "喜越士東藥局"
    },
    {
      "code" : "5901154582",
      "display" : "仁馥中西藥局"
    },
    {
      "code" : "5901154591",
      "display" : "天母台安藥局"
    },
    {
      "code" : "5901154608",
      "display" : "通河藥局"
    },
    {
      "code" : "5901160044",
      "display" : "石牌藥局"
    },
    {
      "code" : "5901160053",
      "display" : "天蓮藥局"
    },
    {
      "code" : "5901160062",
      "display" : "丸三大藥局"
    },
    {
      "code" : "5901160099",
      "display" : "進春藥局"
    },
    {
      "code" : "5901160142",
      "display" : "德昇藥局"
    },
    {
      "code" : "5901160197",
      "display" : "川秀藥局"
    },
    {
      "code" : "5901160222",
      "display" : "新祥藥局"
    },
    {
      "code" : "5901160259",
      "display" : "啟春藥局"
    },
    {
      "code" : "5901160277",
      "display" : "建民藥局"
    },
    {
      "code" : "5901160286",
      "display" : "昌源藥局"
    },
    {
      "code" : "5901160320",
      "display" : "益元藥局"
    },
    {
      "code" : "5901160400",
      "display" : "世全藥局"
    },
    {
      "code" : "5901160428",
      "display" : "九福藥局"
    },
    {
      "code" : "5901160517",
      "display" : "弘安藥局"
    },
    {
      "code" : "5901160544",
      "display" : "黎明藥局"
    },
    {
      "code" : "5901160562",
      "display" : "名山藥局"
    },
    {
      "code" : "5901160704",
      "display" : "明華藥局"
    },
    {
      "code" : "5901160802",
      "display" : "美康藥局"
    },
    {
      "code" : "5901161890",
      "display" : "良興藥局"
    },
    {
      "code" : "5901161934",
      "display" : "康揚藥局"
    },
    {
      "code" : "5901161961",
      "display" : "聯合藥局"
    },
    {
      "code" : "5901161998",
      "display" : "玉山藥局"
    },
    {
      "code" : "5901162002",
      "display" : "實踐藥局"
    },
    {
      "code" : "5901162066",
      "display" : "嘉禾大藥局"
    },
    {
      "code" : "5901162119",
      "display" : "祐鄰藥局"
    },
    {
      "code" : "5901162173",
      "display" : "小明藥局"
    },
    {
      "code" : "5901162182",
      "display" : "祐民藥局"
    },
    {
      "code" : "5901162306",
      "display" : "上頤藥局"
    },
    {
      "code" : "5901162459",
      "display" : "國泰藥師藥局"
    },
    {
      "code" : "5901162477",
      "display" : "長宜藥局"
    },
    {
      "code" : "5901162520",
      "display" : "妮妮藥局"
    },
    {
      "code" : "5901162780",
      "display" : "康賢藥局"
    },
    {
      "code" : "5901162806",
      "display" : "大家藥局"
    },
    {
      "code" : "5901162833",
      "display" : "維康藥局"
    },
    {
      "code" : "5901162879",
      "display" : "杏嘉藥局"
    },
    {
      "code" : "5901163107",
      "display" : "冠亞藥局"
    },
    {
      "code" : "5901163152",
      "display" : "石牌健康人生藥局"
    },
    {
      "code" : "5901163214",
      "display" : "鴻恩藥局"
    },
    {
      "code" : "5901163241",
      "display" : "昱仁藥局"
    },
    {
      "code" : "5901163250",
      "display" : "關渡松藥局"
    },
    {
      "code" : "5901163269",
      "display" : "佳祈健保藥局"
    },
    {
      "code" : "5901163296",
      "display" : "天禧大藥局"
    },
    {
      "code" : "5901163312",
      "display" : "秝安藥局"
    },
    {
      "code" : "5901163330",
      "display" : "萬信藥局"
    },
    {
      "code" : "5901163376",
      "display" : "北投春天藥局"
    },
    {
      "code" : "5901163394",
      "display" : "致遠春天藥局"
    },
    {
      "code" : "5901163410",
      "display" : "尊賢藥局"
    },
    {
      "code" : "5901163438",
      "display" : "漢藥局"
    },
    {
      "code" : "5901163465",
      "display" : "振生大藥局"
    },
    {
      "code" : "5901163474",
      "display" : "怡人藥局"
    },
    {
      "code" : "5901163492",
      "display" : "全家藥粧藥局"
    },
    {
      "code" : "5901163509",
      "display" : "吉利春天生活藥局"
    },
    {
      "code" : "5901163518",
      "display" : "生活藥局"
    },
    {
      "code" : "5901163527",
      "display" : "理得藥局"
    },
    {
      "code" : "5901163536",
      "display" : "天富大藥局"
    },
    {
      "code" : "5901163545",
      "display" : "天康大藥局"
    },
    {
      "code" : "5901163554",
      "display" : "良哲藥局"
    },
    {
      "code" : "5901163563",
      "display" : "躍獅光明藥局"
    },
    {
      "code" : "5901163572",
      "display" : "永欣中西藥局"
    },
    {
      "code" : "5901163581",
      "display" : "陳藥師藥局"
    },
    {
      "code" : "5901163616",
      "display" : "江南育仁大藥局"
    },
    {
      "code" : "5901163634",
      "display" : "心樂藥局"
    },
    {
      "code" : "5901163643",
      "display" : "致遠盛康藥局"
    },
    {
      "code" : "5901163652",
      "display" : "康賢藥局"
    },
    {
      "code" : "5901163661",
      "display" : "合宸藥局"
    },
    {
      "code" : "5901163689",
      "display" : "良哲藥局"
    },
    {
      "code" : "5901163698",
      "display" : "石牌春天藥局"
    },
    {
      "code" : "5901163705",
      "display" : "康是美北投藥局"
    },
    {
      "code" : "5901163714",
      "display" : "石牌健康人生藥局"
    },
    {
      "code" : "5901163732",
      "display" : "石牌春天藥局"
    },
    {
      "code" : "5901163741",
      "display" : "石牌有間藥局"
    },
    {
      "code" : "5901163750",
      "display" : "新資生北投中和大藥局"
    },
    {
      "code" : "5901163778",
      "display" : "新資生北投中和大藥局"
    },
    {
      "code" : "5901163787",
      "display" : "心樂藥局"
    },
    {
      "code" : "5901163796",
      "display" : "致遠台安藥局"
    },
    {
      "code" : "5901163803",
      "display" : "關渡松藥局"
    },
    {
      "code" : "5901163812",
      "display" : "吉利春天生活藥局"
    },
    {
      "code" : "5901163849",
      "display" : "赫爾振華藥局"
    },
    {
      "code" : "5901163858",
      "display" : "中北生活藥局"
    },
    {
      "code" : "5901163867",
      "display" : "心樂藥局"
    },
    {
      "code" : "5901163876",
      "display" : "新資生北投中和大藥局"
    },
    {
      "code" : "5901163885",
      "display" : "祐民藥局"
    },
    {
      "code" : "5901163894",
      "display" : "雁行出雲藥局"
    },
    {
      "code" : "5901163901",
      "display" : "創富藥局"
    },
    {
      "code" : "5901163910",
      "display" : "小明藥局"
    },
    {
      "code" : "5901163929",
      "display" : "小明藥局"
    },
    {
      "code" : "5901163938",
      "display" : "專品石牌藥局"
    },
    {
      "code" : "5901163947",
      "display" : "吉利春天生活藥局"
    },
    {
      "code" : "5901170022",
      "display" : "良美藥局"
    },
    {
      "code" : "5901170040",
      "display" : "惠群藥局"
    },
    {
      "code" : "5901170059",
      "display" : "必欣藥局"
    },
    {
      "code" : "5901170139",
      "display" : "福華藥局"
    },
    {
      "code" : "5901170184",
      "display" : "臺陽藥局"
    },
    {
      "code" : "5901170255",
      "display" : "松隆藥局"
    },
    {
      "code" : "5901170264",
      "display" : "杏康藥局"
    },
    {
      "code" : "5901170282",
      "display" : "光成藥局"
    },
    {
      "code" : "5901170335",
      "display" : "慧生藥局"
    },
    {
      "code" : "5901170406",
      "display" : "鼎泰藥局"
    },
    {
      "code" : "5901170433",
      "display" : "松山大藥局"
    },
    {
      "code" : "5901170442",
      "display" : "大順安藥局"
    },
    {
      "code" : "5901170648",
      "display" : "立信藥局"
    },
    {
      "code" : "5901170906",
      "display" : "吳興藥局"
    },
    {
      "code" : "5901170915",
      "display" : "杏仁藥局"
    },
    {
      "code" : "5901172071",
      "display" : "百康藥局"
    },
    {
      "code" : "5901172160",
      "display" : "佑華藥局"
    },
    {
      "code" : "5901172179",
      "display" : "新和平藥局"
    },
    {
      "code" : "5901172197",
      "display" : "得揚藥局"
    },
    {
      "code" : "5901172213",
      "display" : "華泰藥局"
    },
    {
      "code" : "5901172240",
      "display" : "德康大藥局"
    },
    {
      "code" : "5901172268",
      "display" : "皇佳大藥局"
    },
    {
      "code" : "5901172508",
      "display" : "好康藥局"
    },
    {
      "code" : "5901172544",
      "display" : "麗中藥局"
    },
    {
      "code" : "5901172580",
      "display" : "文興藥局"
    },
    {
      "code" : "5901172651",
      "display" : "康杏藥局"
    },
    {
      "code" : "5901172688",
      "display" : "昆陽藥局"
    },
    {
      "code" : "5901172697",
      "display" : "綠杏大藥局"
    },
    {
      "code" : "5901172704",
      "display" : "鴻濟藥局"
    },
    {
      "code" : "5901172740",
      "display" : "信桉藥局"
    },
    {
      "code" : "5901172786",
      "display" : "安佑藥局"
    },
    {
      "code" : "5901172820",
      "display" : "安心藥局"
    },
    {
      "code" : "5901172839",
      "display" : "九州藥局"
    },
    {
      "code" : "5901172857",
      "display" : "永吉藥局"
    },
    {
      "code" : "5901172924",
      "display" : "躍獅松仁藥局"
    },
    {
      "code" : "5901172933",
      "display" : "喜樂藥局"
    },
    {
      "code" : "5901172964",
      "display" : "榮泰藥局"
    },
    {
      "code" : "5901173041",
      "display" : "皇昇大藥局"
    },
    {
      "code" : "5901173050",
      "display" : "貴臨藥局"
    },
    {
      "code" : "5901173176",
      "display" : "三立藥局"
    },
    {
      "code" : "5901173201",
      "display" : "大鳥藥局"
    },
    {
      "code" : "5901173210",
      "display" : "濟生中西藥局"
    },
    {
      "code" : "5901173238",
      "display" : "正和藥局"
    },
    {
      "code" : "5901173283",
      "display" : "上禾藥師藥局"
    },
    {
      "code" : "5901173292",
      "display" : "荐荃藥師藥局"
    },
    {
      "code" : "5901173372",
      "display" : "新永春藥局"
    },
    {
      "code" : "5901173390",
      "display" : "馨馨藥局"
    },
    {
      "code" : "5901173407",
      "display" : "康怡健保藥局"
    },
    {
      "code" : "5901173587",
      "display" : "新興健保藥局"
    },
    {
      "code" : "5901173603",
      "display" : "松德盛康藥局"
    },
    {
      "code" : "5901173685",
      "display" : "富熙藥局"
    },
    {
      "code" : "5901173694",
      "display" : "洪暘藥局"
    },
    {
      "code" : "5901173710",
      "display" : "專品光復藥局"
    },
    {
      "code" : "5901173729",
      "display" : "仁聖藥局"
    },
    {
      "code" : "5901173738",
      "display" : "尚頤中西藥局"
    },
    {
      "code" : "5901173783",
      "display" : "北一健康人生藥局"
    },
    {
      "code" : "5901173818",
      "display" : "博亞藥局"
    },
    {
      "code" : "5901173827",
      "display" : "松美藥局"
    },
    {
      "code" : "5901173836",
      "display" : "艾登市府藥局"
    },
    {
      "code" : "5901173845",
      "display" : "躍獅永吉藥局"
    },
    {
      "code" : "5901173854",
      "display" : "杏一後山埤藥局"
    },
    {
      "code" : "5901173863",
      "display" : "立赫北醫藥局"
    },
    {
      "code" : "5901173872",
      "display" : "柏愛藥局"
    },
    {
      "code" : "5901173881",
      "display" : "壹間藥師藥局"
    },
    {
      "code" : "5901173916",
      "display" : "御安藥局"
    },
    {
      "code" : "5901173925",
      "display" : "杏一光復藥局"
    },
    {
      "code" : "5901173934",
      "display" : "躍獅光復藥局"
    },
    {
      "code" : "5901173943",
      "display" : "躍獅興雅藥局"
    },
    {
      "code" : "5901173952",
      "display" : "上好藥師藥局"
    },
    {
      "code" : "5901173961",
      "display" : "北一忠孝藥局"
    },
    {
      "code" : "5901173989",
      "display" : "富凱藥師藥局"
    },
    {
      "code" : "5901173998",
      "display" : "愛維喜藥局"
    },
    {
      "code" : "5901174002",
      "display" : "吳興春天藥局"
    },
    {
      "code" : "5901174011",
      "display" : "寶春藥局"
    },
    {
      "code" : "5901174020",
      "display" : "信義盛康藥局"
    },
    {
      "code" : "5901174039",
      "display" : "日安藥局"
    },
    {
      "code" : "5901174048",
      "display" : "光點信義松仁藥局"
    },
    {
      "code" : "5901174057",
      "display" : "詠晴中西藥局"
    },
    {
      "code" : "5901174066",
      "display" : "愛維喜藥局"
    },
    {
      "code" : "5901174075",
      "display" : "信義盛康藥局"
    },
    {
      "code" : "5901174084",
      "display" : "市政藥局"
    },
    {
      "code" : "5901174093",
      "display" : "杏一後山埤藥局"
    },
    {
      "code" : "5901174137",
      "display" : "光點信義松仁藥局"
    },
    {
      "code" : "5901174146",
      "display" : "躍獅興雅藥局"
    },
    {
      "code" : "5901174155",
      "display" : "詠晴中西藥局"
    },
    {
      "code" : "5901174164",
      "display" : "合生光復藥局"
    },
    {
      "code" : "5901174182",
      "display" : "松德欣辰藥局"
    },
    {
      "code" : "5901174191",
      "display" : "晴天大藥局"
    },
    {
      "code" : "5901174208",
      "display" : "小熊藥局"
    },
    {
      "code" : "5901174217",
      "display" : "康楊藥局"
    },
    {
      "code" : "5901174235",
      "display" : "柏愛藥局"
    },
    {
      "code" : "5901174244",
      "display" : "小熊藥局"
    },
    {
      "code" : "5901174253",
      "display" : "上好松山藥局"
    },
    {
      "code" : "5901174280",
      "display" : "保順大藥局"
    },
    {
      "code" : "5901174299",
      "display" : "十二願玥藥局"
    },
    {
      "code" : "5901174306",
      "display" : "松德台安藥局"
    },
    {
      "code" : "5901174315",
      "display" : "天康文豐藥局"
    },
    {
      "code" : "5901174324",
      "display" : "上禾藥師藥局"
    },
    {
      "code" : "5901174333",
      "display" : "健生活國泰置地藥局"
    },
    {
      "code" : "5901174342",
      "display" : "新資生北信義大藥局"
    },
    {
      "code" : "5901174351",
      "display" : "合生光復藥局"
    },
    {
      "code" : "5901174360",
      "display" : "新資生北醫大藥局"
    },
    {
      "code" : "5901174388",
      "display" : "天康文豐藥局"
    },
    {
      "code" : "5901174397",
      "display" : "上好松山藥局"
    },
    {
      "code" : "5901174404",
      "display" : "呼嚕嚕藥局"
    },
    {
      "code" : "5901174422",
      "display" : "松德台安藥局"
    },
    {
      "code" : "5901174431",
      "display" : "小熊藥局"
    },
    {
      "code" : "5901174440",
      "display" : "永樂藥局"
    },
    {
      "code" : "5901174459",
      "display" : "天康文豐藥局"
    },
    {
      "code" : "5901174468",
      "display" : "小熊藥局"
    },
    {
      "code" : "5901174477",
      "display" : "康怡健保藥局"
    },
    {
      "code" : "5901174486",
      "display" : "松美藥局"
    },
    {
      "code" : "5901174495",
      "display" : "上好松山藥局"
    },
    {
      "code" : "5901174502",
      "display" : "躍獅松仁藥局"
    },
    {
      "code" : "5901174511",
      "display" : "藥幸福藥局"
    },
    {
      "code" : "5901174539",
      "display" : "昱芯中西藥局"
    },
    {
      "code" : "5901174548",
      "display" : "北一健康人生藥局"
    },
    {
      "code" : "5901174575",
      "display" : "日新藥局"
    },
    {
      "code" : "5901180037",
      "display" : "崇信藥局"
    },
    {
      "code" : "5901180055",
      "display" : "日生大藥局"
    },
    {
      "code" : "5901180108",
      "display" : "三元藥局"
    },
    {
      "code" : "5901180126",
      "display" : "民生藥局"
    },
    {
      "code" : "5901180162",
      "display" : "濟仁藥局"
    },
    {
      "code" : "5901180206",
      "display" : "大安藥局"
    },
    {
      "code" : "5901180215",
      "display" : "上海聯合藥局"
    },
    {
      "code" : "5901180224",
      "display" : "中心藥局"
    },
    {
      "code" : "5901180304",
      "display" : "祥全藥局"
    },
    {
      "code" : "5901180322",
      "display" : "南昌大藥局"
    },
    {
      "code" : "5901180368",
      "display" : "古亭藥局"
    },
    {
      "code" : "5901182031",
      "display" : "新獻安藥局"
    },
    {
      "code" : "5901182068",
      "display" : "永興藥局"
    },
    {
      "code" : "5901182086",
      "display" : "國杏藥師示範藥局"
    },
    {
      "code" : "5901182111",
      "display" : "東華藥局"
    },
    {
      "code" : "5901182219",
      "display" : "連雲藥局"
    },
    {
      "code" : "5901182228",
      "display" : "合泰大藥局"
    },
    {
      "code" : "5901182255",
      "display" : "全民藥局"
    },
    {
      "code" : "5901183323",
      "display" : "和平藥局"
    },
    {
      "code" : "5901183387",
      "display" : "丞良藥局"
    },
    {
      "code" : "5901183396",
      "display" : "慶安藥局"
    },
    {
      "code" : "5901183510",
      "display" : "怡誠藥局"
    },
    {
      "code" : "5901183529",
      "display" : "達昌藥局"
    },
    {
      "code" : "5901183645",
      "display" : "大愛生活藥局"
    },
    {
      "code" : "5901183716",
      "display" : "台醫藥局"
    },
    {
      "code" : "5901183789",
      "display" : "佑康大藥局"
    },
    {
      "code" : "5901183798",
      "display" : "佳和藥局"
    },
    {
      "code" : "5901183985",
      "display" : "正康藥局"
    },
    {
      "code" : "5901184062",
      "display" : "建祥武昌藥局"
    },
    {
      "code" : "5901184071",
      "display" : "進達健保藥局"
    },
    {
      "code" : "5901184080",
      "display" : "活力健康藥妝藥局"
    },
    {
      "code" : "5901184106",
      "display" : "信康藥局"
    },
    {
      "code" : "5901184179",
      "display" : "保德中華藥局"
    },
    {
      "code" : "5901184213",
      "display" : "71恩典藥局"
    },
    {
      "code" : "5901184222",
      "display" : "豐仁藥局"
    },
    {
      "code" : "5901184240",
      "display" : "立赫健保藥局"
    },
    {
      "code" : "5901184259",
      "display" : "汀州健康人生藥局"
    },
    {
      "code" : "5901184366",
      "display" : "宏越藥局"
    },
    {
      "code" : "5901184375",
      "display" : "大盛藥局"
    },
    {
      "code" : "5901184446",
      "display" : "北車維康藥局"
    },
    {
      "code" : "5901184464",
      "display" : "和眾藥局"
    },
    {
      "code" : "5901184473",
      "display" : "中力藥局"
    },
    {
      "code" : "5901184491",
      "display" : "躍獅南門藥局"
    },
    {
      "code" : "5901184535",
      "display" : "桐心藥局"
    },
    {
      "code" : "5901184544",
      "display" : "逸菁中西特約藥局"
    },
    {
      "code" : "5901184553",
      "display" : "珍忻藥局"
    },
    {
      "code" : "5901184562",
      "display" : "博昱連雲藥局"
    },
    {
      "code" : "5901184599",
      "display" : "長頸鹿藥師藥局"
    },
    {
      "code" : "5901184606",
      "display" : "躍獅南寧藥局"
    },
    {
      "code" : "5901184624",
      "display" : "鈞安藥局"
    },
    {
      "code" : "5901184633",
      "display" : "躍獅東門藥局"
    },
    {
      "code" : "5901184642",
      "display" : "康呈安藥局"
    },
    {
      "code" : "5901184651",
      "display" : "立赫景福藥局"
    },
    {
      "code" : "5901184660",
      "display" : "南昌春天藥局"
    },
    {
      "code" : "5901184679",
      "display" : "汀州藥局"
    },
    {
      "code" : "5901184697",
      "display" : "中英大藥局"
    },
    {
      "code" : "5901184713",
      "display" : "建祥武昌藥局"
    },
    {
      "code" : "5901184722",
      "display" : "博醫和平藥局"
    },
    {
      "code" : "5901184731",
      "display" : "子榕藥局"
    },
    {
      "code" : "5901184740",
      "display" : "愛國藥局"
    },
    {
      "code" : "5901184759",
      "display" : "躍獅南寧藥局"
    },
    {
      "code" : "5901184768",
      "display" : "中力藥局"
    },
    {
      "code" : "5901184777",
      "display" : "專品公園藥局"
    },
    {
      "code" : "5901184786",
      "display" : "建祥武昌藥局"
    },
    {
      "code" : "5901184795",
      "display" : "青澤藥局"
    },
    {
      "code" : "5901184820",
      "display" : "博醫和平藥局"
    },
    {
      "code" : "5901184839",
      "display" : "臨沂中西藥局"
    },
    {
      "code" : "5901184848",
      "display" : "躍獅南寧藥局"
    },
    {
      "code" : "5901184857",
      "display" : "專品南昌藥局"
    },
    {
      "code" : "5901184875",
      "display" : "建祥武昌藥局"
    },
    {
      "code" : "5901184884",
      "display" : "南昌春天藥局"
    },
    {
      "code" : "5901184893",
      "display" : "健歆藥局"
    },
    {
      "code" : "5901184900",
      "display" : "翊萱藥局"
    },
    {
      "code" : "5901184919",
      "display" : "和平藥局"
    },
    {
      "code" : "5901184928",
      "display" : "立赫景福藥局"
    },
    {
      "code" : "5901184937",
      "display" : "十二願禮藥局"
    },
    {
      "code" : "5901184955",
      "display" : "華山原美學藥局"
    },
    {
      "code" : "5901184964",
      "display" : "建祥武昌藥局"
    },
    {
      "code" : "5901184991",
      "display" : "森詠藥局"
    },
    {
      "code" : "5901185005",
      "display" : "華山原美學藥局"
    },
    {
      "code" : "5901185014",
      "display" : "愛國藥局"
    },
    {
      "code" : "5901185023",
      "display" : "上海聯合藥局"
    },
    {
      "code" : "5901190024",
      "display" : "長泰藥局"
    },
    {
      "code" : "5901190033",
      "display" : "世欣藥局"
    },
    {
      "code" : "5901190042",
      "display" : "裕和藥局"
    },
    {
      "code" : "5901190051",
      "display" : "忠信藥局"
    },
    {
      "code" : "5901190060",
      "display" : "秀全藥局"
    },
    {
      "code" : "5901190079",
      "display" : "建和藥局"
    },
    {
      "code" : "5901190104",
      "display" : "大嘉藥局"
    },
    {
      "code" : "5901190122",
      "display" : "老永茂大藥局"
    },
    {
      "code" : "5901190177",
      "display" : "信昌藥局"
    },
    {
      "code" : "5901190211",
      "display" : "民和藥局"
    },
    {
      "code" : "5901190220",
      "display" : "生活大藥局"
    },
    {
      "code" : "5901190284",
      "display" : "民鈺藥局"
    },
    {
      "code" : "5901190408",
      "display" : "您永安藥局"
    },
    {
      "code" : "5901190426",
      "display" : "皇祥藥局"
    },
    {
      "code" : "5901190444",
      "display" : "安聖藥局"
    },
    {
      "code" : "5901190515",
      "display" : "日昇藥局"
    },
    {
      "code" : "5901190668",
      "display" : "聯慶大藥局"
    },
    {
      "code" : "5901190686",
      "display" : "信義藥局"
    },
    {
      "code" : "5901190695",
      "display" : "益源藥局"
    },
    {
      "code" : "5901190784",
      "display" : "欣安藥局"
    },
    {
      "code" : "5901192064",
      "display" : "三源藥局"
    },
    {
      "code" : "5901192144",
      "display" : "健華藥局"
    },
    {
      "code" : "5901192153",
      "display" : "永康大藥局"
    },
    {
      "code" : "5901192162",
      "display" : "寶興大藥局"
    },
    {
      "code" : "5901192180",
      "display" : "康之友藥局"
    },
    {
      "code" : "5901192233",
      "display" : "仁仁藥局"
    },
    {
      "code" : "5901192448",
      "display" : "健誠大藥局"
    },
    {
      "code" : "5901192546",
      "display" : "躍獅西園藥局"
    },
    {
      "code" : "5901192653",
      "display" : "吉安藥局"
    },
    {
      "code" : "5901192751",
      "display" : "好視多藥局"
    },
    {
      "code" : "5901192822",
      "display" : "專品藥局"
    },
    {
      "code" : "5901192831",
      "display" : "偉安藥局"
    },
    {
      "code" : "5901192877",
      "display" : "瑞生藥局"
    },
    {
      "code" : "5901192975",
      "display" : "萬華藥局"
    },
    {
      "code" : "5901192993",
      "display" : "萬華健業藥局"
    },
    {
      "code" : "5901193025",
      "display" : "華達藥局"
    },
    {
      "code" : "5901193070",
      "display" : "榮勝藥局"
    },
    {
      "code" : "5901193105",
      "display" : "安誠貴陽藥局"
    },
    {
      "code" : "5901193123",
      "display" : "千誠北護藥局"
    },
    {
      "code" : "5901193132",
      "display" : "松本藥局"
    },
    {
      "code" : "5901193150",
      "display" : "日森人文藥局"
    },
    {
      "code" : "5901193169",
      "display" : "柏祥藥局"
    },
    {
      "code" : "5901193196",
      "display" : "青年宏越藥局"
    },
    {
      "code" : "5901193221",
      "display" : "正盛藥局"
    },
    {
      "code" : "5901193230",
      "display" : "啟仁藥局"
    },
    {
      "code" : "5901193249",
      "display" : "光華藥局"
    },
    {
      "code" : "5901193294",
      "display" : "恩達藥局"
    },
    {
      "code" : "5901193301",
      "display" : "富安藥局"
    },
    {
      "code" : "5901193310",
      "display" : "和德藥局"
    },
    {
      "code" : "5901193329",
      "display" : "西園宏越藥局"
    },
    {
      "code" : "5901193338",
      "display" : "艾米力藥師藥局"
    },
    {
      "code" : "5901193356",
      "display" : "展源健康藥局"
    },
    {
      "code" : "5901193365",
      "display" : "企鵝藥局"
    },
    {
      "code" : "5901193374",
      "display" : "康是美長沙藥局"
    },
    {
      "code" : "5901193383",
      "display" : "福澤萬大藥局"
    },
    {
      "code" : "5901193392",
      "display" : "逸菁中西特約藥局"
    },
    {
      "code" : "5901193445",
      "display" : "康是美萬鑫藥局"
    },
    {
      "code" : "5901193454",
      "display" : "福澤萬大藥局"
    },
    {
      "code" : "5901193463",
      "display" : "東京生活藥局"
    },
    {
      "code" : "5901193472",
      "display" : "小太陽元氣藥局"
    },
    {
      "code" : "5901193481",
      "display" : "日森人文藥局"
    },
    {
      "code" : "5901193507",
      "display" : "青年宏越藥局"
    },
    {
      "code" : "5901193516",
      "display" : "西園宏越藥局"
    },
    {
      "code" : "5901193525",
      "display" : "南機場中西藥局"
    },
    {
      "code" : "5901193534",
      "display" : "青年宏越藥局"
    },
    {
      "code" : "5901193543",
      "display" : "西園宏越藥局"
    },
    {
      "code" : "5901200070",
      "display" : "裕康藥局"
    },
    {
      "code" : "5901200105",
      "display" : "建興藥局"
    },
    {
      "code" : "5901200114",
      "display" : "健群藥局"
    },
    {
      "code" : "5901200123",
      "display" : "瑞安藥局"
    },
    {
      "code" : "5901200141",
      "display" : "景美藥局"
    },
    {
      "code" : "5901200187",
      "display" : "全銨藥局"
    },
    {
      "code" : "5901200490",
      "display" : "永明大藥局"
    },
    {
      "code" : "5901200534",
      "display" : "日信專業藥局"
    },
    {
      "code" : "5901201540",
      "display" : "逸仙藥師藥局"
    },
    {
      "code" : "5901201568",
      "display" : "康宜庭生活藥局"
    },
    {
      "code" : "5901201675",
      "display" : "博揚藥局"
    },
    {
      "code" : "5901201728",
      "display" : "東京晟藥局"
    },
    {
      "code" : "5901201746",
      "display" : "仙瑩藥局"
    },
    {
      "code" : "5901201755",
      "display" : "銘依藥局"
    },
    {
      "code" : "5901201826",
      "display" : "舒博威藥局"
    },
    {
      "code" : "5901201835",
      "display" : "巧康藥局"
    },
    {
      "code" : "5901201871",
      "display" : "佳醫景美藥局"
    },
    {
      "code" : "5901201951",
      "display" : "慶豐好藥局"
    },
    {
      "code" : "5901202047",
      "display" : "華君藥局"
    },
    {
      "code" : "5901202154",
      "display" : "安誠藥局"
    },
    {
      "code" : "5901202216",
      "display" : "皇興藥師藥局"
    },
    {
      "code" : "5901202396",
      "display" : "宇康藥局"
    },
    {
      "code" : "5901202592",
      "display" : "人人健保藥局"
    },
    {
      "code" : "5901202627",
      "display" : "杏隆藥局"
    },
    {
      "code" : "5901202645",
      "display" : "永源大藥局"
    },
    {
      "code" : "5901202654",
      "display" : "康宜庭萬隆藥局"
    },
    {
      "code" : "5901202672",
      "display" : "美迦藥局"
    },
    {
      "code" : "5901202681",
      "display" : "振大藥局"
    },
    {
      "code" : "5901202752",
      "display" : "躍獅奕新藥局"
    },
    {
      "code" : "5901202789",
      "display" : "宜康藥局"
    },
    {
      "code" : "5901202841",
      "display" : "欣安景美藥局"
    },
    {
      "code" : "5901202850",
      "display" : "北一藥師藥局"
    },
    {
      "code" : "5901202949",
      "display" : "萬隆大藥局"
    },
    {
      "code" : "5901202958",
      "display" : "杏一萬安藥局"
    },
    {
      "code" : "5901202976",
      "display" : "健康家藥局"
    },
    {
      "code" : "5901202994",
      "display" : "躍獅永健藥局"
    },
    {
      "code" : "5901203026",
      "display" : "健康人生藥局"
    },
    {
      "code" : "5901203044",
      "display" : "木新健康人生藥局"
    },
    {
      "code" : "5901203062",
      "display" : "大樹文山藥局"
    },
    {
      "code" : "5901203080",
      "display" : "杏一木柵藥局"
    },
    {
      "code" : "5901203106",
      "display" : "光明大藥局"
    },
    {
      "code" : "5901203124",
      "display" : "福興藥局"
    },
    {
      "code" : "5901203160",
      "display" : "路加健康藥局"
    },
    {
      "code" : "5901203179",
      "display" : "健安藥局"
    },
    {
      "code" : "5901203188",
      "display" : "逸全生活藥局"
    },
    {
      "code" : "5901203204",
      "display" : "躍獅新芳藥局"
    },
    {
      "code" : "5901203213",
      "display" : "綠杏萬芳藥局"
    },
    {
      "code" : "5901203240",
      "display" : "大愛幸福藥局"
    },
    {
      "code" : "5901203268",
      "display" : "躍獅木柵藥局"
    },
    {
      "code" : "5901203295",
      "display" : "專品政大藥局"
    },
    {
      "code" : "5901203357",
      "display" : "圓鼎藥局"
    },
    {
      "code" : "5901203366",
      "display" : "大樹木柵藥局"
    },
    {
      "code" : "5901203375",
      "display" : "大樹景美藥局"
    },
    {
      "code" : "5901203384",
      "display" : "光點文山景華藥局"
    },
    {
      "code" : "5901203393",
      "display" : "躍獅景新藥局"
    },
    {
      "code" : "5901203400",
      "display" : "富康活力睦新藥局"
    },
    {
      "code" : "5901203419",
      "display" : "康宜庭興隆藥局"
    },
    {
      "code" : "5901203428",
      "display" : "康宜庭景文藥局"
    },
    {
      "code" : "5901203446",
      "display" : "景華盛康藥局"
    },
    {
      "code" : "5901203455",
      "display" : "全球萬芳藥局"
    },
    {
      "code" : "5901203464",
      "display" : "大愛幸福藥局"
    },
    {
      "code" : "5901203473",
      "display" : "晴天藥局"
    },
    {
      "code" : "5901203482",
      "display" : "健康家藥局"
    },
    {
      "code" : "5901203491",
      "display" : "健康人生藥局"
    },
    {
      "code" : "5901203508",
      "display" : "健康家藥局"
    },
    {
      "code" : "5901203517",
      "display" : "健安藥局"
    },
    {
      "code" : "5901203526",
      "display" : "木新健康人生藥局"
    },
    {
      "code" : "5901203535",
      "display" : "大樹木柵藥局"
    },
    {
      "code" : "5901203553",
      "display" : "富康活力睦柵藥局"
    },
    {
      "code" : "5901203562",
      "display" : "政大台安藥局"
    },
    {
      "code" : "5901203571",
      "display" : "木新健康人生藥局"
    },
    {
      "code" : "5901203599",
      "display" : "健康人生藥局"
    },
    {
      "code" : "5901203606",
      "display" : "大樹景美藥局"
    },
    {
      "code" : "5901203615",
      "display" : "專品政大藥局"
    },
    {
      "code" : "5901203624",
      "display" : "歆鈺藥局"
    },
    {
      "code" : "5901203651",
      "display" : "景豐藥局"
    },
    {
      "code" : "5901203660",
      "display" : "杏一木柵藥局"
    },
    {
      "code" : "5901203679",
      "display" : "富康活力景驊藥局"
    },
    {
      "code" : "5901203697",
      "display" : "專品政大藥局"
    },
    {
      "code" : "5901203704",
      "display" : "柒品藥局"
    },
    {
      "code" : "5901203713",
      "display" : "大心藥局"
    },
    {
      "code" : "5901203731",
      "display" : "合欣藥局"
    },
    {
      "code" : "5901203740",
      "display" : "健安藥局"
    },
    {
      "code" : "5901203759",
      "display" : "躍獅景新藥局"
    },
    {
      "code" : "5901203768",
      "display" : "康宜庭景文藥局"
    },
    {
      "code" : "5901203777",
      "display" : "興隆藥局"
    },
    {
      "code" : "5901203786",
      "display" : "景華台安藥局"
    },
    {
      "code" : "5901203795",
      "display" : "康宜庭景文藥局"
    },
    {
      "code" : "5901203802",
      "display" : "躍獅果子藥局"
    },
    {
      "code" : "5901203811",
      "display" : "杏一萬芳藥局"
    },
    {
      "code" : "5901203820",
      "display" : "富康活力景驊藥局"
    },
    {
      "code" : "5911010015",
      "display" : "喬寶藥局"
    },
    {
      "code" : "5911010097",
      "display" : "俊德藥局"
    },
    {
      "code" : "5911010168",
      "display" : "承泰藥局"
    },
    {
      "code" : "5911011227",
      "display" : "和平大藥局"
    },
    {
      "code" : "5911011290",
      "display" : "家康大藥局"
    },
    {
      "code" : "5911011325",
      "display" : "永好藥局"
    },
    {
      "code" : "5911011334",
      "display" : "海大藥局"
    },
    {
      "code" : "5911011370",
      "display" : "艾美藥局"
    },
    {
      "code" : "5911011450",
      "display" : "文裕藥局"
    },
    {
      "code" : "5911011469",
      "display" : "維元社區藥局"
    },
    {
      "code" : "5911011478",
      "display" : "天康新豐藥局"
    },
    {
      "code" : "5911011496",
      "display" : "源昌藥局"
    },
    {
      "code" : "5911011512",
      "display" : "八斗子東亞藥局"
    },
    {
      "code" : "5911011521",
      "display" : "禎宸藥局"
    },
    {
      "code" : "5911011530",
      "display" : "吉上藥局"
    },
    {
      "code" : "5911011576",
      "display" : "百福義一藥師藥局"
    },
    {
      "code" : "5911011585",
      "display" : "雙鶴藥局"
    },
    {
      "code" : "5911011594",
      "display" : "禾新藥局"
    },
    {
      "code" : "5911011601",
      "display" : "義一啄木鳥藥局"
    },
    {
      "code" : "5911011610",
      "display" : "躍獅大藥局"
    },
    {
      "code" : "5911011629",
      "display" : "百福新豐活力藥局"
    },
    {
      "code" : "5911011638",
      "display" : "中正藥局"
    },
    {
      "code" : "5911011647",
      "display" : "豐年藥局"
    },
    {
      "code" : "5911011656",
      "display" : "承泰藥局"
    },
    {
      "code" : "5911011665",
      "display" : "中正藥局"
    },
    {
      "code" : "5911011674",
      "display" : "安仁心藥局"
    },
    {
      "code" : "5911011683",
      "display" : "維元社區藥局"
    },
    {
      "code" : "5911011692",
      "display" : "百福新豐活力藥局"
    },
    {
      "code" : "5911011709",
      "display" : "中正藥局"
    },
    {
      "code" : "5911011718",
      "display" : "百福新豐活力藥局"
    },
    {
      "code" : "5911011727",
      "display" : "一加醫立文藥局"
    },
    {
      "code" : "5911011736",
      "display" : "艾美藥局"
    },
    {
      "code" : "5911011745",
      "display" : "一加醫立文藥局"
    },
    {
      "code" : "5911011754",
      "display" : "予恩藥局"
    },
    {
      "code" : "5911011763",
      "display" : "光唯藥局"
    },
    {
      "code" : "5911011772",
      "display" : "八斗子東亞藥局"
    },
    {
      "code" : "5911011781",
      "display" : "百福義一藥師藥局"
    },
    {
      "code" : "5911011790",
      "display" : "維元社區藥局"
    },
    {
      "code" : "5911020039",
      "display" : "民安藥局"
    },
    {
      "code" : "5911020057",
      "display" : "合豐藥局"
    },
    {
      "code" : "5911020084",
      "display" : "北安藥局"
    },
    {
      "code" : "5911021170",
      "display" : "康蘋藥局"
    },
    {
      "code" : "5911021214",
      "display" : "合康藥局"
    },
    {
      "code" : "5911021330",
      "display" : "鴻辰藥局"
    },
    {
      "code" : "5911021385",
      "display" : "長樂藥局"
    },
    {
      "code" : "5911021394",
      "display" : "百福專業藥師藥局"
    },
    {
      "code" : "5911021401",
      "display" : "福恬藥局"
    },
    {
      "code" : "5911021429",
      "display" : "雅登藥局"
    },
    {
      "code" : "5911021438",
      "display" : "正心藥局"
    },
    {
      "code" : "5911021456",
      "display" : "雅登藥局"
    },
    {
      "code" : "5911021465",
      "display" : "泰安健保藥局"
    },
    {
      "code" : "5911030026",
      "display" : "欣華藥局"
    },
    {
      "code" : "5911030035",
      "display" : "陸記藥局"
    },
    {
      "code" : "5911030053",
      "display" : "杏福藥局"
    },
    {
      "code" : "5911031096",
      "display" : "東方藥局"
    },
    {
      "code" : "5911031158",
      "display" : "柏林藥局"
    },
    {
      "code" : "5911031176",
      "display" : "家宏藥局"
    },
    {
      "code" : "5911031238",
      "display" : "碇內東亞藥師藥局"
    },
    {
      "code" : "5911031274",
      "display" : "宏展藥局"
    },
    {
      "code" : "5911031283",
      "display" : "福安藥局"
    },
    {
      "code" : "5911031318",
      "display" : "安安藥局"
    },
    {
      "code" : "5911031327",
      "display" : "百福暖暖專業藥局"
    },
    {
      "code" : "5911031336",
      "display" : "青森健保藥局"
    },
    {
      "code" : "5911031345",
      "display" : "青森健保藥局"
    },
    {
      "code" : "5911031354",
      "display" : "青森健保藥局"
    },
    {
      "code" : "5911031363",
      "display" : "百福暖暖專業藥局"
    },
    {
      "code" : "5911031372",
      "display" : "青森健保藥局"
    },
    {
      "code" : "5911031381",
      "display" : "青森健保藥局"
    },
    {
      "code" : "5911031390",
      "display" : "碇安藥局"
    },
    {
      "code" : "5911040059",
      "display" : "賢杰藥局"
    },
    {
      "code" : "5911040175",
      "display" : "回春藥局"
    },
    {
      "code" : "5911040228",
      "display" : "大田大藥局"
    },
    {
      "code" : "5911040273",
      "display" : "第一藥局"
    },
    {
      "code" : "5911041305",
      "display" : "婕登藥局"
    },
    {
      "code" : "5911041332",
      "display" : "光華藥局"
    },
    {
      "code" : "5911041350",
      "display" : "何房藥局"
    },
    {
      "code" : "5911041387",
      "display" : "順安藥局"
    },
    {
      "code" : "5911041403",
      "display" : "佑昌藥局"
    },
    {
      "code" : "5911041510",
      "display" : "聯安藥局"
    },
    {
      "code" : "5911041618",
      "display" : "永樂藥局"
    },
    {
      "code" : "5911041690",
      "display" : "佑聖藥局"
    },
    {
      "code" : "5911041743",
      "display" : "全昱藥局"
    },
    {
      "code" : "5911041805",
      "display" : "長安藥師藥局"
    },
    {
      "code" : "5911041823",
      "display" : "威陽藥局"
    },
    {
      "code" : "5911041832",
      "display" : "東京藥局"
    },
    {
      "code" : "5911041878",
      "display" : "天康大藥局"
    },
    {
      "code" : "5911041903",
      "display" : "長虹藥師藥局"
    },
    {
      "code" : "5911041921",
      "display" : "祥新藥局"
    },
    {
      "code" : "5911041949",
      "display" : "捷登藥局"
    },
    {
      "code" : "5911041958",
      "display" : "百福仁愛專業藥局"
    },
    {
      "code" : "5911041967",
      "display" : "東隆藥局"
    },
    {
      "code" : "5911041985",
      "display" : "令合藥師藥局"
    },
    {
      "code" : "5911041994",
      "display" : "藥安心基隆藥局"
    },
    {
      "code" : "5911042008",
      "display" : "百福仁愛專業藥局"
    },
    {
      "code" : "5911042026",
      "display" : "牧風藥局"
    },
    {
      "code" : "5911050037",
      "display" : "吉安藥局"
    },
    {
      "code" : "5911050064",
      "display" : "日星藥局"
    },
    {
      "code" : "5911050073",
      "display" : "中山藥局"
    },
    {
      "code" : "5911050153",
      "display" : "隆泰藥局"
    },
    {
      "code" : "5911050162",
      "display" : "錦泰藥局"
    },
    {
      "code" : "5911051258",
      "display" : "聖鑫藥局"
    },
    {
      "code" : "5911051267",
      "display" : "親親藥局"
    },
    {
      "code" : "5911051365",
      "display" : "大慶大藥局"
    },
    {
      "code" : "5911051392",
      "display" : "寶慷藥局"
    },
    {
      "code" : "5911051409",
      "display" : "順豐藥局"
    },
    {
      "code" : "5911051463",
      "display" : "宏海藥局"
    },
    {
      "code" : "5911051472",
      "display" : "外木山藥局"
    },
    {
      "code" : "5911051481",
      "display" : "仁登藥局"
    },
    {
      "code" : "5911051490",
      "display" : "大哈密藥局"
    },
    {
      "code" : "5911051507",
      "display" : "百福安一藥局"
    },
    {
      "code" : "5911051525",
      "display" : "高登藥局"
    },
    {
      "code" : "5911051543",
      "display" : "復興藥局"
    },
    {
      "code" : "5911051552",
      "display" : "仁登藥局"
    },
    {
      "code" : "5911051561",
      "display" : "宏海藥局"
    },
    {
      "code" : "5911051570",
      "display" : "佑全基隆復興藥局"
    },
    {
      "code" : "5911051589",
      "display" : "復興藥局"
    },
    {
      "code" : "5911060015",
      "display" : "福泰藥局"
    },
    {
      "code" : "5911060051",
      "display" : "濟生藥局"
    },
    {
      "code" : "5911060079",
      "display" : "祐寧藥局"
    },
    {
      "code" : "5911060088",
      "display" : "宏仁藥局"
    },
    {
      "code" : "5911060131",
      "display" : "長春藥局"
    },
    {
      "code" : "5911061236",
      "display" : "康美藥局"
    },
    {
      "code" : "5911061272",
      "display" : "立登藥局"
    },
    {
      "code" : "5911061281",
      "display" : "羅森堡藥局"
    },
    {
      "code" : "5911061307",
      "display" : "宏基藥局"
    },
    {
      "code" : "5911061334",
      "display" : "大武崙藥局"
    },
    {
      "code" : "5911061343",
      "display" : "基金藥局"
    },
    {
      "code" : "5911061361",
      "display" : "青樺藥局"
    },
    {
      "code" : "5911061370",
      "display" : "佑全基隆麥金藥局"
    },
    {
      "code" : "5911061389",
      "display" : "芸湖藥局"
    },
    {
      "code" : "5911061398",
      "display" : "佑全基隆麥金藥局"
    },
    {
      "code" : "5911061405",
      "display" : "大武崙藥局"
    },
    {
      "code" : "5911061414",
      "display" : "安樂藥局"
    },
    {
      "code" : "5911061423",
      "display" : "立登藥局"
    },
    {
      "code" : "5911061441",
      "display" : "基隆麥金藥局"
    },
    {
      "code" : "5911061450",
      "display" : "樂利藥局"
    },
    {
      "code" : "5911061469",
      "display" : "安樂藥局"
    },
    {
      "code" : "5911070011",
      "display" : "信安藥局"
    },
    {
      "code" : "5911071376",
      "display" : "祐康藥局"
    },
    {
      "code" : "5911071456",
      "display" : "深美藥局"
    },
    {
      "code" : "5911071483",
      "display" : "蘋果藥局"
    },
    {
      "code" : "5911071536",
      "display" : "小不點健保藥局"
    },
    {
      "code" : "5911071572",
      "display" : "元登藥局"
    },
    {
      "code" : "5911071581",
      "display" : "心禾藥局"
    },
    {
      "code" : "5911071590",
      "display" : "基隆藥局"
    },
    {
      "code" : "5911071607",
      "display" : "家安藥師藥局"
    },
    {
      "code" : "5911071616",
      "display" : "睿聲藥局"
    },
    {
      "code" : "5911071625",
      "display" : "基隆藥局"
    },
    {
      "code" : "5911071634",
      "display" : "基隆藥局"
    },
    {
      "code" : "5931010011",
      "display" : "埔墘藥局"
    },
    {
      "code" : "5931010066",
      "display" : "翰林藥局"
    },
    {
      "code" : "5931010217",
      "display" : "皇安藥局"
    },
    {
      "code" : "5931010235",
      "display" : "友祥藥局"
    },
    {
      "code" : "5931010306",
      "display" : "義友藥局"
    },
    {
      "code" : "5931010315",
      "display" : "優良藥局"
    },
    {
      "code" : "5931010342",
      "display" : "宏達大藥局"
    },
    {
      "code" : "5931010397",
      "display" : "正成藥師藥局"
    },
    {
      "code" : "5931010459",
      "display" : "欣民藥局"
    },
    {
      "code" : "5931010477",
      "display" : "華傳綜合大藥局"
    },
    {
      "code" : "5931010646",
      "display" : "人民藥局"
    },
    {
      "code" : "5931010708",
      "display" : "一誠藥局"
    },
    {
      "code" : "5931010726",
      "display" : "賜您康大藥局"
    },
    {
      "code" : "5931010744",
      "display" : "啟暉藥局"
    },
    {
      "code" : "5931010842",
      "display" : "大福藥局"
    },
    {
      "code" : "5931010888",
      "display" : "俊昌藥局"
    },
    {
      "code" : "5931010977",
      "display" : "穎川藥局"
    },
    {
      "code" : "5931011009",
      "display" : "祥聖藥局"
    },
    {
      "code" : "5931011045",
      "display" : "進發大藥局"
    },
    {
      "code" : "5931011054",
      "display" : "國光藥師藥局"
    },
    {
      "code" : "5931011107",
      "display" : "安祥藥局"
    },
    {
      "code" : "5931011152",
      "display" : "福勝堂藥局"
    },
    {
      "code" : "5931011161",
      "display" : "全國藥局"
    },
    {
      "code" : "5931011223",
      "display" : "民侑藥局"
    },
    {
      "code" : "5931011241",
      "display" : "利安藥局"
    },
    {
      "code" : "5931011250",
      "display" : "錦龍藥局"
    },
    {
      "code" : "5931011330",
      "display" : "戴安藥局"
    },
    {
      "code" : "5931011376",
      "display" : "杏泰藥局"
    },
    {
      "code" : "5931011438",
      "display" : "萬壽藥局"
    },
    {
      "code" : "5931011447",
      "display" : "日生大藥局"
    },
    {
      "code" : "5931011474",
      "display" : "新欣藥局"
    },
    {
      "code" : "5931011545",
      "display" : "眾安大藥局"
    },
    {
      "code" : "5931011938",
      "display" : "正吉藥局"
    },
    {
      "code" : "5931011947",
      "display" : "長弘藥局"
    },
    {
      "code" : "5931012042",
      "display" : "喬治藥局"
    },
    {
      "code" : "5931012051",
      "display" : "全曜藥局"
    },
    {
      "code" : "5931012060",
      "display" : "溪北藥局"
    },
    {
      "code" : "5931012131",
      "display" : "中山大藥局"
    },
    {
      "code" : "5931012140",
      "display" : "南雅藥局"
    },
    {
      "code" : "5931012239",
      "display" : "信昌藥局"
    },
    {
      "code" : "5931012257",
      "display" : "大昌藥局"
    },
    {
      "code" : "5931013343",
      "display" : "晉麟藥局"
    },
    {
      "code" : "5931013361",
      "display" : "長欣藥師藥局"
    },
    {
      "code" : "5931013389",
      "display" : "谷全藥局"
    },
    {
      "code" : "5931013441",
      "display" : "擎天藥局"
    },
    {
      "code" : "5931013478",
      "display" : "富盛藥局"
    },
    {
      "code" : "5931013629",
      "display" : "安聯藥局"
    },
    {
      "code" : "5931013692",
      "display" : "合泰藥局"
    },
    {
      "code" : "5931013736",
      "display" : "杏華藥局"
    },
    {
      "code" : "5931013781",
      "display" : "佳和藥局"
    },
    {
      "code" : "5931013790",
      "display" : "力康藥局"
    },
    {
      "code" : "5931013843",
      "display" : "快安藥局"
    },
    {
      "code" : "5931013852",
      "display" : "瑞明藥局"
    },
    {
      "code" : "5931013889",
      "display" : "宏周藥局"
    },
    {
      "code" : "5931014028",
      "display" : "康德藥局"
    },
    {
      "code" : "5931014046",
      "display" : "欣安藥局"
    },
    {
      "code" : "5931014199",
      "display" : "廷好藥局"
    },
    {
      "code" : "5931014206",
      "display" : "翰生藥局"
    },
    {
      "code" : "5931014224",
      "display" : "大峰藥局"
    },
    {
      "code" : "5931014420",
      "display" : "萬泰藥局"
    },
    {
      "code" : "5931014439",
      "display" : "旭全藥局"
    },
    {
      "code" : "5931014528",
      "display" : "文德藥局"
    },
    {
      "code" : "5931014537",
      "display" : "友虹藥師藥局"
    },
    {
      "code" : "5931014555",
      "display" : "廣益藥局"
    },
    {
      "code" : "5931014635",
      "display" : "健全藥局"
    },
    {
      "code" : "5931014699",
      "display" : "惠林藥局"
    },
    {
      "code" : "5931014751",
      "display" : "活泉藥局"
    },
    {
      "code" : "5931014822",
      "display" : "常仁藥局"
    },
    {
      "code" : "5931014831",
      "display" : "詠濟藥局"
    },
    {
      "code" : "5931014868",
      "display" : "安佑藥局"
    },
    {
      "code" : "5931014993",
      "display" : "景好藥師藥局"
    },
    {
      "code" : "5931015061",
      "display" : "雙十健保藥局"
    },
    {
      "code" : "5931015187",
      "display" : "皇慶藥局"
    },
    {
      "code" : "5931015285",
      "display" : "廣安健保藥師藥局"
    },
    {
      "code" : "5931015301",
      "display" : "利安中西藥局"
    },
    {
      "code" : "5931015329",
      "display" : "杏澤藥局"
    },
    {
      "code" : "5931015454",
      "display" : "府中藥局"
    },
    {
      "code" : "5931015605",
      "display" : "僑中藥師藥局"
    },
    {
      "code" : "5931015641",
      "display" : "廣明藥局"
    },
    {
      "code" : "5931015687",
      "display" : "正康健保藥局"
    },
    {
      "code" : "5931015703",
      "display" : "信美藥局"
    },
    {
      "code" : "5931015721",
      "display" : "新進發大藥局"
    },
    {
      "code" : "5931015749",
      "display" : "品品藥局"
    },
    {
      "code" : "5931015767",
      "display" : "信安藥師藥局"
    },
    {
      "code" : "5931015776",
      "display" : "亞季藥局"
    },
    {
      "code" : "5931015829",
      "display" : "德一藥局"
    },
    {
      "code" : "5931015874",
      "display" : "家碩藥局"
    },
    {
      "code" : "5931015883",
      "display" : "宜康藥局"
    },
    {
      "code" : "5931015909",
      "display" : "向康藥局"
    },
    {
      "code" : "5931015972",
      "display" : "德豐健保藥局"
    },
    {
      "code" : "5931015981",
      "display" : "立安中西藥局"
    },
    {
      "code" : "5931015990",
      "display" : "名安藥局"
    },
    {
      "code" : "5931016004",
      "display" : "晴天藥局"
    },
    {
      "code" : "5931016111",
      "display" : "京躍藥局"
    },
    {
      "code" : "5931016219",
      "display" : "樺新健保藥局"
    },
    {
      "code" : "5931016237",
      "display" : "幸福健保藥局"
    },
    {
      "code" : "5931016273",
      "display" : "湯明藥局"
    },
    {
      "code" : "5931016308",
      "display" : "嘉恩健保藥局"
    },
    {
      "code" : "5931016317",
      "display" : "正陽藥局"
    },
    {
      "code" : "5931016326",
      "display" : "楓康藥局"
    },
    {
      "code" : "5931016335",
      "display" : "康匯藥局"
    },
    {
      "code" : "5931016371",
      "display" : "廣信健保藥局"
    },
    {
      "code" : "5931016433",
      "display" : "利安社區藥局"
    },
    {
      "code" : "5931016460",
      "display" : "力安藥局"
    },
    {
      "code" : "5931016504",
      "display" : "仁泰藥局"
    },
    {
      "code" : "5931016540",
      "display" : "新海藥局"
    },
    {
      "code" : "5931016568",
      "display" : "廣欣藥師藥局"
    },
    {
      "code" : "5931016577",
      "display" : "廣泰藥師藥局"
    },
    {
      "code" : "5931016586",
      "display" : "賜安藥局"
    },
    {
      "code" : "5931016595",
      "display" : "宥康婦幼健保藥局"
    },
    {
      "code" : "5931016611",
      "display" : "民川藥局"
    },
    {
      "code" : "5931016639",
      "display" : "佳聯藥局"
    },
    {
      "code" : "5931016657",
      "display" : "溪崑藥局"
    },
    {
      "code" : "5931016719",
      "display" : "王林藥局"
    },
    {
      "code" : "5931016737",
      "display" : "必生好藥局"
    },
    {
      "code" : "5931016755",
      "display" : "禾田藥局"
    },
    {
      "code" : "5931016791",
      "display" : "廣和藥師藥局"
    },
    {
      "code" : "5931016808",
      "display" : "正安健保藥局"
    },
    {
      "code" : "5931016817",
      "display" : "浮洲藥局"
    },
    {
      "code" : "5931016880",
      "display" : "漢民藥局"
    },
    {
      "code" : "5931016899",
      "display" : "晨晰藥局"
    },
    {
      "code" : "5931016915",
      "display" : "微笑藥局"
    },
    {
      "code" : "5931016924",
      "display" : "裕苠藥局"
    },
    {
      "code" : "5931016942",
      "display" : "金瑞藥局"
    },
    {
      "code" : "5931016960",
      "display" : "愛美得藥局"
    },
    {
      "code" : "5931017001",
      "display" : "聯康藥局"
    },
    {
      "code" : "5931017010",
      "display" : "醫安藥局"
    },
    {
      "code" : "5931017047",
      "display" : "永欣藥師藥局"
    },
    {
      "code" : "5931017056",
      "display" : "迦佰麗藥局"
    },
    {
      "code" : "5931017083",
      "display" : "和安藥局"
    },
    {
      "code" : "5931017092",
      "display" : "康橋藥局"
    },
    {
      "code" : "5931017136",
      "display" : "國慶藥局"
    },
    {
      "code" : "5931017163",
      "display" : "快樂藥局中山店"
    },
    {
      "code" : "5931017172",
      "display" : "順儷府中藥局"
    },
    {
      "code" : "5931017190",
      "display" : "晴光藥局"
    },
    {
      "code" : "5931017207",
      "display" : "振昌藥局"
    },
    {
      "code" : "5931017216",
      "display" : "康鑫藥局"
    },
    {
      "code" : "5931017243",
      "display" : "大川藥局"
    },
    {
      "code" : "5931017261",
      "display" : "正康新埔藥局"
    },
    {
      "code" : "5931017270",
      "display" : "躍獅新埔藥局"
    },
    {
      "code" : "5931017289",
      "display" : "板橋大樹藥局"
    },
    {
      "code" : "5931017314",
      "display" : "大楓藥師藥局"
    },
    {
      "code" : "5931017323",
      "display" : "樂多藥局"
    },
    {
      "code" : "5931017341",
      "display" : "台安藥局"
    },
    {
      "code" : "5931017369",
      "display" : "軒源藥局"
    },
    {
      "code" : "5931017387",
      "display" : "華安藥局"
    },
    {
      "code" : "5931017396",
      "display" : "美康四維藥局"
    },
    {
      "code" : "5931017403",
      "display" : "光澤醫美藥局"
    },
    {
      "code" : "5931017430",
      "display" : "麥田健保藥局"
    },
    {
      "code" : "5931017449",
      "display" : "順儷長安藥局"
    },
    {
      "code" : "5931017494",
      "display" : "佑全板橋四川藥局"
    },
    {
      "code" : "5931017529",
      "display" : "埔全藥局"
    },
    {
      "code" : "5931017538",
      "display" : "麗森藥師藥局連鎖麗寶藥局"
    },
    {
      "code" : "5931017547",
      "display" : "好爸爸藥局"
    },
    {
      "code" : "5931017556",
      "display" : "光鹽藥局"
    },
    {
      "code" : "5931017574",
      "display" : "福安藥局"
    },
    {
      "code" : "5931017592",
      "display" : "重慶藥局"
    },
    {
      "code" : "5931017618",
      "display" : "新埔健保藥局"
    },
    {
      "code" : "5931017636",
      "display" : "福澤藥局"
    },
    {
      "code" : "5931017645",
      "display" : "松立藥局"
    },
    {
      "code" : "5931017654",
      "display" : "葆康藥局"
    },
    {
      "code" : "5931017663",
      "display" : "盛生藥局"
    },
    {
      "code" : "5931017672",
      "display" : "文化藥局"
    },
    {
      "code" : "5931017681",
      "display" : "浣熊藥局"
    },
    {
      "code" : "5931017690",
      "display" : "杏文藥局"
    },
    {
      "code" : "5931017707",
      "display" : "上嘉藥局"
    },
    {
      "code" : "5931017716",
      "display" : "星辰藥局"
    },
    {
      "code" : "5931017725",
      "display" : "合佳藥局"
    },
    {
      "code" : "5931017743",
      "display" : "欣德藥局"
    },
    {
      "code" : "5931017752",
      "display" : "泓泰藥局"
    },
    {
      "code" : "5931017761",
      "display" : "晨恩藥局"
    },
    {
      "code" : "5931017770",
      "display" : "光環藥局"
    },
    {
      "code" : "5931017789",
      "display" : "明翠藥局"
    },
    {
      "code" : "5931017805",
      "display" : "利安藥師藥局"
    },
    {
      "code" : "5931017814",
      "display" : "順儷新板藥局"
    },
    {
      "code" : "5931017823",
      "display" : "明灃專業藥局"
    },
    {
      "code" : "5931017832",
      "display" : "躍獅莒光藥局"
    },
    {
      "code" : "5931017841",
      "display" : "莊敬健康人生藥局"
    },
    {
      "code" : "5931017869",
      "display" : "躍獅國慶藥局"
    },
    {
      "code" : "5931017878",
      "display" : "順儷國泰藥局"
    },
    {
      "code" : "5931017887",
      "display" : "仁康藥局"
    },
    {
      "code" : "5931017896",
      "display" : "樂心藥局"
    },
    {
      "code" : "5931017903",
      "display" : "吉發藥局"
    },
    {
      "code" : "5931017912",
      "display" : "社後藥局"
    },
    {
      "code" : "5931017921",
      "display" : "順儷民權藥局"
    },
    {
      "code" : "5931017949",
      "display" : "合宜藥局"
    },
    {
      "code" : "5931017967",
      "display" : "曉品中西藥局"
    },
    {
      "code" : "5931017976",
      "display" : "豐禾藥局"
    },
    {
      "code" : "5931017985",
      "display" : "松柏藥局"
    },
    {
      "code" : "5931017994",
      "display" : "後埔藥局"
    },
    {
      "code" : "5931018017",
      "display" : "有田藥局"
    },
    {
      "code" : "5931018026",
      "display" : "莊敬藥局"
    },
    {
      "code" : "5931018035",
      "display" : "福澤館前藥局"
    },
    {
      "code" : "5931018044",
      "display" : "重成藥局"
    },
    {
      "code" : "5931018053",
      "display" : "廣福健保藥局"
    },
    {
      "code" : "5931018062",
      "display" : "明灃專業藥局"
    },
    {
      "code" : "5931018080",
      "display" : "樂心藥局"
    },
    {
      "code" : "5931018099",
      "display" : "廣品藥局"
    },
    {
      "code" : "5931018106",
      "display" : "力安藥局"
    },
    {
      "code" : "5931018115",
      "display" : "振昌藥局"
    },
    {
      "code" : "5931018124",
      "display" : "大楓藥師藥局"
    },
    {
      "code" : "5931018133",
      "display" : "綠洲藥局"
    },
    {
      "code" : "5931018142",
      "display" : "重慶藥局"
    },
    {
      "code" : "5931018160",
      "display" : "晴天藥局"
    },
    {
      "code" : "5931018179",
      "display" : "謙禾藥局"
    },
    {
      "code" : "5931018188",
      "display" : "蘋果樹藥局"
    },
    {
      "code" : "5931018197",
      "display" : "陸品藥局"
    },
    {
      "code" : "5931018204",
      "display" : "欣德藥局"
    },
    {
      "code" : "5931018213",
      "display" : "松江健保藥局"
    },
    {
      "code" : "5931018222",
      "display" : "福澤館前藥局"
    },
    {
      "code" : "5931018231",
      "display" : "躍獅莒光藥局"
    },
    {
      "code" : "5931018240",
      "display" : "微笑藥局"
    },
    {
      "code" : "5931018259",
      "display" : "斯麥爾藥局"
    },
    {
      "code" : "5931018268",
      "display" : "躍獅國慶藥局"
    },
    {
      "code" : "5931018277",
      "display" : "莊敬藥局"
    },
    {
      "code" : "5931018295",
      "display" : "樂心藥局"
    },
    {
      "code" : "5931018302",
      "display" : "仁康藥局"
    },
    {
      "code" : "5931018311",
      "display" : "裕民藥局"
    },
    {
      "code" : "5931018320",
      "display" : "吉豐藥局"
    },
    {
      "code" : "5931018339",
      "display" : "埔全藥局"
    },
    {
      "code" : "5931018348",
      "display" : "義友藥局"
    },
    {
      "code" : "5931018357",
      "display" : "樂心藥局"
    },
    {
      "code" : "5931018366",
      "display" : "柏裕藥局"
    },
    {
      "code" : "5931018375",
      "display" : "景好藥師藥局"
    },
    {
      "code" : "5931018384",
      "display" : "廣欣藥師藥局"
    },
    {
      "code" : "5931018393",
      "display" : "廣仁藥師藥局"
    },
    {
      "code" : "5931018400",
      "display" : "順儷府中藥局"
    },
    {
      "code" : "5931018419",
      "display" : "順儷長安藥局"
    },
    {
      "code" : "5931018428",
      "display" : "愛心藥局"
    },
    {
      "code" : "5931018437",
      "display" : "祥民藥局"
    },
    {
      "code" : "5931018446",
      "display" : "益友藥局"
    },
    {
      "code" : "5931018455",
      "display" : "翰生藥局"
    },
    {
      "code" : "5931018464",
      "display" : "明灃專業藥局"
    },
    {
      "code" : "5931018473",
      "display" : "樺新健保藥局"
    },
    {
      "code" : "5931018482",
      "display" : "方舟藥局"
    },
    {
      "code" : "5931018491",
      "display" : "麥田健保藥局"
    },
    {
      "code" : "5931018508",
      "display" : "柏仁藥局"
    },
    {
      "code" : "5931018517",
      "display" : "樂心藥局"
    },
    {
      "code" : "5931018526",
      "display" : "廣躍健保藥局"
    },
    {
      "code" : "5931018535",
      "display" : "富康活力華德藥局"
    },
    {
      "code" : "5931018544",
      "display" : "曜康藥局"
    },
    {
      "code" : "5931018553",
      "display" : "謙禾藥局"
    },
    {
      "code" : "5931018562",
      "display" : "金大心長照藥局"
    },
    {
      "code" : "5931018571",
      "display" : "振安藥局"
    },
    {
      "code" : "5931018580",
      "display" : "順儷府中藥局"
    },
    {
      "code" : "5931018599",
      "display" : "福安藥局"
    },
    {
      "code" : "5931018606",
      "display" : "匯康藥局"
    },
    {
      "code" : "5931018615",
      "display" : "杏澤藥局"
    },
    {
      "code" : "5931018624",
      "display" : "大福藥局"
    },
    {
      "code" : "5931018633",
      "display" : "莊敬藥局"
    },
    {
      "code" : "5931018651",
      "display" : "重慶藥局"
    },
    {
      "code" : "5931018660",
      "display" : "躍獅莒光藥局"
    },
    {
      "code" : "5931018679",
      "display" : "廣欣南雅藥師藥局"
    },
    {
      "code" : "5931018688",
      "display" : "順儷民權藥局"
    },
    {
      "code" : "5931018697",
      "display" : "豐禾藥局"
    },
    {
      "code" : "5931018704",
      "display" : "柏裕藥局"
    },
    {
      "code" : "5931018713",
      "display" : "和平藥局"
    },
    {
      "code" : "5931018722",
      "display" : "詠笙藥局"
    },
    {
      "code" : "5931018731",
      "display" : "躍獅國慶藥局"
    },
    {
      "code" : "5931018740",
      "display" : "四維春天藥局"
    },
    {
      "code" : "5931018759",
      "display" : "陸品藥局"
    },
    {
      "code" : "5931018768",
      "display" : "順儷府中藥局"
    },
    {
      "code" : "5931018777",
      "display" : "悠樂健保藥局"
    },
    {
      "code" : "5931018786",
      "display" : "新資生幸福大藥局"
    },
    {
      "code" : "5931018795",
      "display" : "富元聯合專科藥局"
    },
    {
      "code" : "5931018802",
      "display" : "禾林藥局"
    },
    {
      "code" : "5931018811",
      "display" : "振安藥局"
    },
    {
      "code" : "5931018820",
      "display" : "廣木藥局"
    },
    {
      "code" : "5931018839",
      "display" : "新資生幸福大藥局"
    },
    {
      "code" : "5931018848",
      "display" : "廣泓藥局"
    },
    {
      "code" : "5931018857",
      "display" : "台安藥局"
    },
    {
      "code" : "5931018866",
      "display" : "康橋藥局"
    },
    {
      "code" : "5931018875",
      "display" : "祥民藥局"
    },
    {
      "code" : "5931018884",
      "display" : "裕民藥局"
    },
    {
      "code" : "5931018893",
      "display" : "吉發藥局"
    },
    {
      "code" : "5931018900",
      "display" : "穎川藥局"
    },
    {
      "code" : "5931018919",
      "display" : "埔全藥局"
    },
    {
      "code" : "5931018928",
      "display" : "廣明藥局"
    },
    {
      "code" : "5931018937",
      "display" : "廣和藥師藥局"
    },
    {
      "code" : "5931018946",
      "display" : "躍獅芳心藥局"
    },
    {
      "code" : "5931018955",
      "display" : "富康活力華德藥局"
    },
    {
      "code" : "5931018964",
      "display" : "順儷府中藥局"
    },
    {
      "code" : "5931018973",
      "display" : "小太陽藥局"
    },
    {
      "code" : "5931018982",
      "display" : "正向漢生藥局"
    },
    {
      "code" : "5931018991",
      "display" : "柏裕藥局"
    },
    {
      "code" : "5931019005",
      "display" : "大川藥局"
    },
    {
      "code" : "5931020017",
      "display" : "建宏藥局"
    },
    {
      "code" : "5931020044",
      "display" : "唯安藥局"
    },
    {
      "code" : "5931020133",
      "display" : "上豪藥局"
    },
    {
      "code" : "5931020286",
      "display" : "博安藥局"
    },
    {
      "code" : "5931020311",
      "display" : "忠誠藥局"
    },
    {
      "code" : "5931020320",
      "display" : "優達藥局"
    },
    {
      "code" : "5931020400",
      "display" : "新迪化中西藥局"
    },
    {
      "code" : "5931020428",
      "display" : "久泰藥局"
    },
    {
      "code" : "5931020446",
      "display" : "玉美藥局"
    },
    {
      "code" : "5931020464",
      "display" : "合眾藥局"
    },
    {
      "code" : "5931020473",
      "display" : "天佑藥局"
    },
    {
      "code" : "5931020508",
      "display" : "佑民藥局"
    },
    {
      "code" : "5931020562",
      "display" : "力健藥局"
    },
    {
      "code" : "5931020599",
      "display" : "德林藥局"
    },
    {
      "code" : "5931020624",
      "display" : "新英藥師藥局"
    },
    {
      "code" : "5931020633",
      "display" : "仁安堂藥局"
    },
    {
      "code" : "5931020688",
      "display" : "厚德藥局"
    },
    {
      "code" : "5931020697",
      "display" : "建興藥局"
    },
    {
      "code" : "5931020704",
      "display" : "建芳藥局"
    },
    {
      "code" : "5931020740",
      "display" : "忠民藥局"
    },
    {
      "code" : "5931020795",
      "display" : "杜廣德藥師藥局"
    },
    {
      "code" : "5931020811",
      "display" : "志雄藥局"
    },
    {
      "code" : "5931020820",
      "display" : "三民藥師藥局"
    },
    {
      "code" : "5931020848",
      "display" : "吳廣隆藥局"
    },
    {
      "code" : "5931020866",
      "display" : "裕福藥局"
    },
    {
      "code" : "5931020919",
      "display" : "東裕藥局"
    },
    {
      "code" : "5931020964",
      "display" : "穗元大藥局"
    },
    {
      "code" : "5931020991",
      "display" : "久洲藥局"
    },
    {
      "code" : "5931021014",
      "display" : "鴻成藥局"
    },
    {
      "code" : "5931021023",
      "display" : "義中藥局"
    },
    {
      "code" : "5931021167",
      "display" : "禮隆藥局"
    },
    {
      "code" : "5931021265",
      "display" : "享生藥局"
    },
    {
      "code" : "5931021283",
      "display" : "豐安藥局"
    },
    {
      "code" : "5931021372",
      "display" : "福昌大藥局"
    },
    {
      "code" : "5931021416",
      "display" : "國星藥局"
    },
    {
      "code" : "5931021452",
      "display" : "家福藥局"
    },
    {
      "code" : "5931021532",
      "display" : "龍門藥局"
    },
    {
      "code" : "5931021658",
      "display" : "上益藥局"
    },
    {
      "code" : "5931022806",
      "display" : "聯鑫藥師藥局"
    },
    {
      "code" : "5931022931",
      "display" : "承都藥局"
    },
    {
      "code" : "5931022959",
      "display" : "名成藥局"
    },
    {
      "code" : "5931022995",
      "display" : "立雄藥局"
    },
    {
      "code" : "5931023018",
      "display" : "重德藥局"
    },
    {
      "code" : "5931023027",
      "display" : "五華藥局"
    },
    {
      "code" : "5931023036",
      "display" : "華泰藥師藥局"
    },
    {
      "code" : "5931023107",
      "display" : "容安藥局"
    },
    {
      "code" : "5931023161",
      "display" : "烈委藥局"
    },
    {
      "code" : "5931023198",
      "display" : "成立藥局"
    },
    {
      "code" : "5931023349",
      "display" : "迪化藥局"
    },
    {
      "code" : "5931023401",
      "display" : "正大藥局"
    },
    {
      "code" : "5931023447",
      "display" : "安泰藥局"
    },
    {
      "code" : "5931023527",
      "display" : "德慈藥局"
    },
    {
      "code" : "5931023536",
      "display" : "江村藥局"
    },
    {
      "code" : "5931023563",
      "display" : "寶貝藥局"
    },
    {
      "code" : "5931023581",
      "display" : "大重仁藥局"
    },
    {
      "code" : "5931023625",
      "display" : "聖美膚藥局"
    },
    {
      "code" : "5931023670",
      "display" : "誠泰藥師藥局"
    },
    {
      "code" : "5931023732",
      "display" : "松泰藥師藥局"
    },
    {
      "code" : "5931023741",
      "display" : "向上藥局"
    },
    {
      "code" : "5931023750",
      "display" : "興安藥局"
    },
    {
      "code" : "5931023830",
      "display" : "忠信藥局"
    },
    {
      "code" : "5931023858",
      "display" : "開元藥局"
    },
    {
      "code" : "5931023901",
      "display" : "銘泰藥局"
    },
    {
      "code" : "5931023910",
      "display" : "德河藥局"
    },
    {
      "code" : "5931024088",
      "display" : "美滿藥局"
    },
    {
      "code" : "5931024097",
      "display" : "義榮藥局"
    },
    {
      "code" : "5931024140",
      "display" : "祥和藥局"
    },
    {
      "code" : "5931024168",
      "display" : "合康健保藥局"
    },
    {
      "code" : "5931024239",
      "display" : "禾華藥局"
    },
    {
      "code" : "5931024355",
      "display" : "天賜藥局"
    },
    {
      "code" : "5931024373",
      "display" : "予康藥局"
    },
    {
      "code" : "5931024408",
      "display" : "幸福藥妝藥局"
    },
    {
      "code" : "5931024426",
      "display" : "甜心健康生活藥局"
    },
    {
      "code" : "5931024462",
      "display" : "惠理藥局"
    },
    {
      "code" : "5931024499",
      "display" : "信承藥局"
    },
    {
      "code" : "5931024515",
      "display" : "陳藥局"
    },
    {
      "code" : "5931024524",
      "display" : "陽明藥師藥局"
    },
    {
      "code" : "5931024551",
      "display" : "樂活處方箋藥局"
    },
    {
      "code" : "5931024588",
      "display" : "陽光藥師藥局"
    },
    {
      "code" : "5931024622",
      "display" : "萊康健保藥局"
    },
    {
      "code" : "5931024631",
      "display" : "德榮藥局"
    },
    {
      "code" : "5931024668",
      "display" : "景康藥局"
    },
    {
      "code" : "5931024677",
      "display" : "博愛藥局"
    },
    {
      "code" : "5931024695",
      "display" : "仁華藥局"
    },
    {
      "code" : "5931024711",
      "display" : "臻燿藥局"
    },
    {
      "code" : "5931024784",
      "display" : "中華健保藥局"
    },
    {
      "code" : "5931024873",
      "display" : "捷元健保藥局"
    },
    {
      "code" : "5931024908",
      "display" : "力行德榮藥局"
    },
    {
      "code" : "5931024935",
      "display" : "健康藥局"
    },
    {
      "code" : "5931024944",
      "display" : "康希藥局"
    },
    {
      "code" : "5931024962",
      "display" : "建祥三和藥局"
    },
    {
      "code" : "5931024971",
      "display" : "欽勝藥局"
    },
    {
      "code" : "5931025030",
      "display" : "飛龍大藥局"
    },
    {
      "code" : "5931025076",
      "display" : "慈愛藥局"
    },
    {
      "code" : "5931025174",
      "display" : "小林健保藥局"
    },
    {
      "code" : "5931025192",
      "display" : "榮康藥局"
    },
    {
      "code" : "5931025236",
      "display" : "祐銘藥局"
    },
    {
      "code" : "5931025245",
      "display" : "黎明藥師藥局"
    },
    {
      "code" : "5931025254",
      "display" : "仁愛健保藥局"
    },
    {
      "code" : "5931025263",
      "display" : "鴻泰健保藥局"
    },
    {
      "code" : "5931025281",
      "display" : "吉盛健保藥局"
    },
    {
      "code" : "5931025290",
      "display" : "康新藥局"
    },
    {
      "code" : "5931025325",
      "display" : "欣悅藥局"
    },
    {
      "code" : "5931025343",
      "display" : "益成藥局"
    },
    {
      "code" : "5931025361",
      "display" : "宗安藥師藥局"
    },
    {
      "code" : "5931025370",
      "display" : "晨星藥局"
    },
    {
      "code" : "5931025398",
      "display" : "昌誠藥局"
    },
    {
      "code" : "5931025432",
      "display" : "利民藥局"
    },
    {
      "code" : "5931025441",
      "display" : "尚好藥局"
    },
    {
      "code" : "5931025503",
      "display" : "德心藥局"
    },
    {
      "code" : "5931025521",
      "display" : "徐匯藥局"
    },
    {
      "code" : "5931025549",
      "display" : "吉康健保藥局"
    },
    {
      "code" : "5931025558",
      "display" : "藥比健保藥局"
    },
    {
      "code" : "5931025567",
      "display" : "閎安藥局"
    },
    {
      "code" : "5931025601",
      "display" : "人康藥局"
    },
    {
      "code" : "5931025610",
      "display" : "大樹三重藥局"
    },
    {
      "code" : "5931025638",
      "display" : "華安生活藥局"
    },
    {
      "code" : "5931025647",
      "display" : "幸康藥局"
    },
    {
      "code" : "5931025656",
      "display" : "煜安健保藥局"
    },
    {
      "code" : "5931025692",
      "display" : "杏一三重集成藥局"
    },
    {
      "code" : "5931025718",
      "display" : "幸聲藥局"
    },
    {
      "code" : "5931025745",
      "display" : "恆源藥局"
    },
    {
      "code" : "5931025781",
      "display" : "芯慈藥局"
    },
    {
      "code" : "5931025790",
      "display" : "銀河藥局"
    },
    {
      "code" : "5931025807",
      "display" : "永福藥局"
    },
    {
      "code" : "5931025825",
      "display" : "美康中正北藥局"
    },
    {
      "code" : "5931025843",
      "display" : "專品先嗇宮藥局"
    },
    {
      "code" : "5931025870",
      "display" : "宏安藥局"
    },
    {
      "code" : "5931025889",
      "display" : "親鄰藥局"
    },
    {
      "code" : "5931025898",
      "display" : "新宜安中西藥局"
    },
    {
      "code" : "5931025905",
      "display" : "出雲藥局"
    },
    {
      "code" : "5931025914",
      "display" : "仁美藥局"
    },
    {
      "code" : "5931025932",
      "display" : "永吉藥局"
    },
    {
      "code" : "5931025941",
      "display" : "辰新藥局"
    },
    {
      "code" : "5931025950",
      "display" : "美康三和藥局"
    },
    {
      "code" : "5931025969",
      "display" : "躍獅欣欣藥局"
    },
    {
      "code" : "5931025978",
      "display" : "重新藥局"
    },
    {
      "code" : "5931025987",
      "display" : "忠孝德榮藥局"
    },
    {
      "code" : "5931025996",
      "display" : "信義忠孝藥局"
    },
    {
      "code" : "5931026000",
      "display" : "佑全三重正義藥局"
    },
    {
      "code" : "5931026019",
      "display" : "正欣藥局"
    },
    {
      "code" : "5931026028",
      "display" : "宏欣藥局"
    },
    {
      "code" : "5931026037",
      "display" : "安立藥局"
    },
    {
      "code" : "5931026046",
      "display" : "臻曜藥局"
    },
    {
      "code" : "5931026055",
      "display" : "芮櫟溪尾大藥局"
    },
    {
      "code" : "5931026064",
      "display" : "五華春天生活藥局"
    },
    {
      "code" : "5931026073",
      "display" : "重陽藥局"
    },
    {
      "code" : "5931026082",
      "display" : "大有藥局"
    },
    {
      "code" : "5931026091",
      "display" : "重新藥局"
    },
    {
      "code" : "5931026108",
      "display" : "宏原健保藥局"
    },
    {
      "code" : "5931026117",
      "display" : "威仕康藥局"
    },
    {
      "code" : "5931026126",
      "display" : "仁愛健保藥局"
    },
    {
      "code" : "5931026135",
      "display" : "美康三和藥局"
    },
    {
      "code" : "5931026144",
      "display" : "康是美長壽藥局"
    },
    {
      "code" : "5931026153",
      "display" : "人康藥局"
    },
    {
      "code" : "5931026162",
      "display" : "五華春天生活藥局"
    },
    {
      "code" : "5931026171",
      "display" : "躍獅欣欣藥局"
    },
    {
      "code" : "5931026180",
      "display" : "馥佑藥局"
    },
    {
      "code" : "5931026199",
      "display" : "日初藥局"
    },
    {
      "code" : "5931026206",
      "display" : "惠鴻藥局"
    },
    {
      "code" : "5931026215",
      "display" : "仁義藥局"
    },
    {
      "code" : "5931026224",
      "display" : "好樂活藥局"
    },
    {
      "code" : "5931026242",
      "display" : "銘泰藥局"
    },
    {
      "code" : "5931026251",
      "display" : "宏原健保藥局"
    },
    {
      "code" : "5931026260",
      "display" : "光明藥局"
    },
    {
      "code" : "5931026279",
      "display" : "欣悅藥局"
    },
    {
      "code" : "5931026288",
      "display" : "重新藥局"
    },
    {
      "code" : "5931026297",
      "display" : "晨星藥局"
    },
    {
      "code" : "5931026304",
      "display" : "心美藥局"
    },
    {
      "code" : "5931026313",
      "display" : "康是美五華藥局"
    },
    {
      "code" : "5931026322",
      "display" : "新資生五華大藥局"
    },
    {
      "code" : "5931026331",
      "display" : "躍獅欣欣藥局"
    },
    {
      "code" : "5931026340",
      "display" : "一佳藥局"
    },
    {
      "code" : "5931026359",
      "display" : "專品先嗇宮藥局"
    },
    {
      "code" : "5931026368",
      "display" : "杏欣藥局"
    },
    {
      "code" : "5931026377",
      "display" : "一佳藥局"
    },
    {
      "code" : "5931026395",
      "display" : "祥和藥局"
    },
    {
      "code" : "5931026402",
      "display" : "曜合藥局"
    },
    {
      "code" : "5931026411",
      "display" : "中央春天藥局"
    },
    {
      "code" : "5931026439",
      "display" : "廣泓藥局"
    },
    {
      "code" : "5931026448",
      "display" : "忠孝台安藥局"
    },
    {
      "code" : "5931026457",
      "display" : "信義忠孝藥局"
    },
    {
      "code" : "5931026466",
      "display" : "心美藥局"
    },
    {
      "code" : "5931026475",
      "display" : "柏林藥局"
    },
    {
      "code" : "5931026484",
      "display" : "幸康藥局"
    },
    {
      "code" : "5931026500",
      "display" : "重陽藥局"
    },
    {
      "code" : "5931026519",
      "display" : "禮隆藥局"
    },
    {
      "code" : "5931026537",
      "display" : "幸康藥局"
    },
    {
      "code" : "5931026546",
      "display" : "重新藥局"
    },
    {
      "code" : "5931026555",
      "display" : "幸康藥局"
    },
    {
      "code" : "5931026564",
      "display" : "建祥三和藥局"
    },
    {
      "code" : "5931026573",
      "display" : "正欣藥局"
    },
    {
      "code" : "5931026582",
      "display" : "臻曜藥局"
    },
    {
      "code" : "5931026591",
      "display" : "宏安藥局"
    },
    {
      "code" : "5931026608",
      "display" : "閎安藥局"
    },
    {
      "code" : "5931026617",
      "display" : "美康中正北藥局"
    },
    {
      "code" : "5931026626",
      "display" : "信義忠孝藥局"
    },
    {
      "code" : "5931026635",
      "display" : "容安藥局"
    },
    {
      "code" : "5931026644",
      "display" : "赫爾溪尾藥局"
    },
    {
      "code" : "5931026653",
      "display" : "子安藥局"
    },
    {
      "code" : "5931026662",
      "display" : "臻曜藥局"
    },
    {
      "code" : "5931026671",
      "display" : "新資生五華大藥局"
    },
    {
      "code" : "5931030013",
      "display" : "皇誼藥局"
    },
    {
      "code" : "5931030184",
      "display" : "新昇大藥局"
    },
    {
      "code" : "5931030264",
      "display" : "永達大藥局"
    },
    {
      "code" : "5931030317",
      "display" : "聖英藥局"
    },
    {
      "code" : "5931030531",
      "display" : "成功藥局"
    },
    {
      "code" : "5931030540",
      "display" : "易安堂藥局"
    },
    {
      "code" : "5931030568",
      "display" : "仲景藥局"
    },
    {
      "code" : "5931030639",
      "display" : "家宏藥局"
    },
    {
      "code" : "5931030782",
      "display" : "佳民藥局"
    },
    {
      "code" : "5931030960",
      "display" : "中正藥局"
    },
    {
      "code" : "5931032099",
      "display" : "德和便利藥局"
    },
    {
      "code" : "5931032133",
      "display" : "宸安藥局"
    },
    {
      "code" : "5931032188",
      "display" : "原大藥局"
    },
    {
      "code" : "5931032286",
      "display" : "宏瑞藥局"
    },
    {
      "code" : "5931032302",
      "display" : "威康藥局"
    },
    {
      "code" : "5931032339",
      "display" : "宜泰藥局"
    },
    {
      "code" : "5931032419",
      "display" : "保平大藥局"
    },
    {
      "code" : "5931032428",
      "display" : "鳳軒藥局"
    },
    {
      "code" : "5931032473",
      "display" : "竹林藥局"
    },
    {
      "code" : "5931032731",
      "display" : "得安藥局"
    },
    {
      "code" : "5931032759",
      "display" : "友辰藥局"
    },
    {
      "code" : "5931032811",
      "display" : "華特健康藥局"
    },
    {
      "code" : "5931032875",
      "display" : "上安藥局"
    },
    {
      "code" : "5931032919",
      "display" : "宏安藥局"
    },
    {
      "code" : "5931032955",
      "display" : "博輝藥局"
    },
    {
      "code" : "5931033023",
      "display" : "榮總藥局"
    },
    {
      "code" : "5931033032",
      "display" : "弘光藥局"
    },
    {
      "code" : "5931033078",
      "display" : "博昇藥局"
    },
    {
      "code" : "5931033087",
      "display" : "康宏安藥局"
    },
    {
      "code" : "5931033103",
      "display" : "皇家藥師藥局"
    },
    {
      "code" : "5931033130",
      "display" : "永利藥局"
    },
    {
      "code" : "5931033176",
      "display" : "緣來藥師藥局"
    },
    {
      "code" : "5931033185",
      "display" : "偉凱藥局"
    },
    {
      "code" : "5931033194",
      "display" : "廣惠藥局"
    },
    {
      "code" : "5931033201",
      "display" : "級立健保藥局"
    },
    {
      "code" : "5931033345",
      "display" : "御生藥局"
    },
    {
      "code" : "5931033363",
      "display" : "保安藥局"
    },
    {
      "code" : "5931033416",
      "display" : "詠悅藥局"
    },
    {
      "code" : "5931033461",
      "display" : "常安中西藥局"
    },
    {
      "code" : "5931033498",
      "display" : "亞佐藥局"
    },
    {
      "code" : "5931033523",
      "display" : "永奕藥局"
    },
    {
      "code" : "5931033541",
      "display" : "大欣安藥局"
    },
    {
      "code" : "5931033578",
      "display" : "悅美保健藥局"
    },
    {
      "code" : "5931033603",
      "display" : "安安藥局"
    },
    {
      "code" : "5931033621",
      "display" : "永正健康人生藥局"
    },
    {
      "code" : "5931033649",
      "display" : "敦品民治藥局"
    },
    {
      "code" : "5931033676",
      "display" : "九州藥局"
    },
    {
      "code" : "5931033774",
      "display" : "台化藥局"
    },
    {
      "code" : "5931033783",
      "display" : "星韻藥局"
    },
    {
      "code" : "5931033792",
      "display" : "明慧藥師藥局"
    },
    {
      "code" : "5931033809",
      "display" : "新禾藥局"
    },
    {
      "code" : "5931033863",
      "display" : "欣安大藥局"
    },
    {
      "code" : "5931033881",
      "display" : "十路藥局"
    },
    {
      "code" : "5931033890",
      "display" : "康杏安藥局"
    },
    {
      "code" : "5931033907",
      "display" : "德美藥局"
    },
    {
      "code" : "5931033916",
      "display" : "宜田藥局"
    },
    {
      "code" : "5931033925",
      "display" : "康和藥局"
    },
    {
      "code" : "5931033952",
      "display" : "澄品藥局"
    },
    {
      "code" : "5931033961",
      "display" : "永和大樹藥局"
    },
    {
      "code" : "5931033970",
      "display" : "荃恩藥局"
    },
    {
      "code" : "5931033989",
      "display" : "悠活藥局"
    },
    {
      "code" : "5931034002",
      "display" : "日陽藥局"
    },
    {
      "code" : "5931034011",
      "display" : "律安藥局"
    },
    {
      "code" : "5931034020",
      "display" : "順和藥局"
    },
    {
      "code" : "5931034039",
      "display" : "叁品藥局"
    },
    {
      "code" : "5931034048",
      "display" : "崇恩藥局"
    },
    {
      "code" : "5931034057",
      "display" : "佑全永和中山藥局"
    },
    {
      "code" : "5931034084",
      "display" : "柏愛藥局"
    },
    {
      "code" : "5931034093",
      "display" : "順儷中正藥局"
    },
    {
      "code" : "5931034100",
      "display" : "開欣藥局"
    },
    {
      "code" : "5931034119",
      "display" : "仁愛陽光藥局"
    },
    {
      "code" : "5931034128",
      "display" : "富康活力永和藥局"
    },
    {
      "code" : "5931034137",
      "display" : "永杏中西藥局"
    },
    {
      "code" : "5931034146",
      "display" : "亮點藥局"
    },
    {
      "code" : "5931034155",
      "display" : "德上藥局"
    },
    {
      "code" : "5931034173",
      "display" : "橘子藥局"
    },
    {
      "code" : "5931034182",
      "display" : "宜禾藥局"
    },
    {
      "code" : "5931034191",
      "display" : "健生活藥局"
    },
    {
      "code" : "5931034208",
      "display" : "正銨藥局"
    },
    {
      "code" : "5931034217",
      "display" : "逸鼎健康藥局"
    },
    {
      "code" : "5931034226",
      "display" : "日陽藥局"
    },
    {
      "code" : "5931034244",
      "display" : "康杏安藥局"
    },
    {
      "code" : "5931034253",
      "display" : "宜禾藥局"
    },
    {
      "code" : "5931034262",
      "display" : "永旭藥局"
    },
    {
      "code" : "5931034271",
      "display" : "富康活力筑林藥局"
    },
    {
      "code" : "5931034299",
      "display" : "十二願福藥局"
    },
    {
      "code" : "5931034306",
      "display" : "仁愛陽光藥局"
    },
    {
      "code" : "5931034315",
      "display" : "順儷中正藥局"
    },
    {
      "code" : "5931034324",
      "display" : "康是美樂華藥局"
    },
    {
      "code" : "5931034333",
      "display" : "睿安藥局"
    },
    {
      "code" : "5931034351",
      "display" : "順儷中正藥局"
    },
    {
      "code" : "5931034360",
      "display" : "秀朗台安藥局"
    },
    {
      "code" : "5931034379",
      "display" : "康和藥局"
    },
    {
      "code" : "5931034388",
      "display" : "永麗中西藥局"
    },
    {
      "code" : "5931034397",
      "display" : "寰亞藥局"
    },
    {
      "code" : "5931034404",
      "display" : "佑全永和中山藥局"
    },
    {
      "code" : "5931034413",
      "display" : "康是美樂華藥局"
    },
    {
      "code" : "5931034422",
      "display" : "亮點中正藥局"
    },
    {
      "code" : "5931034431",
      "display" : "和家藥局"
    },
    {
      "code" : "5931034440",
      "display" : "富康活力民誌藥局"
    },
    {
      "code" : "5931034459",
      "display" : "安安藥局"
    },
    {
      "code" : "5931034468",
      "display" : "康是美樂華藥局"
    },
    {
      "code" : "5931034477",
      "display" : "順和藥局"
    },
    {
      "code" : "5931034486",
      "display" : "樂華康之友藥局"
    },
    {
      "code" : "5931034495",
      "display" : "十二願福藥局"
    },
    {
      "code" : "5931034502",
      "display" : "德和便利藥局"
    },
    {
      "code" : "5931034511",
      "display" : "德康中西藥局"
    },
    {
      "code" : "5931034539",
      "display" : "秀朗台安藥局"
    },
    {
      "code" : "5931034548",
      "display" : "十二願福藥局"
    },
    {
      "code" : "5931034557",
      "display" : "永和宏越藥局"
    },
    {
      "code" : "5931034584",
      "display" : "澄品藥局"
    },
    {
      "code" : "5931034600",
      "display" : "士安藥局"
    },
    {
      "code" : "5931034619",
      "display" : "富康活力永和藥局"
    },
    {
      "code" : "5931034628",
      "display" : "中正春天藥局"
    },
    {
      "code" : "5931034637",
      "display" : "亮點中正藥局"
    },
    {
      "code" : "5931034646",
      "display" : "佑全永和中山藥局"
    },
    {
      "code" : "5931034655",
      "display" : "宜禾藥局"
    },
    {
      "code" : "5931034664",
      "display" : "宜田藥局"
    },
    {
      "code" : "5931034673",
      "display" : "健生活藥局"
    },
    {
      "code" : "5931034682",
      "display" : "一家人健康藥局"
    },
    {
      "code" : "5931034691",
      "display" : "宜田藥局"
    },
    {
      "code" : "5931034708",
      "display" : "永義藥局"
    },
    {
      "code" : "5931034717",
      "display" : "樂華康之友藥局"
    },
    {
      "code" : "5931034726",
      "display" : "宜田藥局"
    },
    {
      "code" : "5931034735",
      "display" : "福藥局"
    },
    {
      "code" : "5931034744",
      "display" : "荃恩藥局"
    },
    {
      "code" : "5931034753",
      "display" : "熊安藥局"
    },
    {
      "code" : "5931034762",
      "display" : "安安藥局"
    },
    {
      "code" : "5931040019",
      "display" : "大榮藥局"
    },
    {
      "code" : "5931040037",
      "display" : "溫莎藥局"
    },
    {
      "code" : "5931040055",
      "display" : "瑞發藥局"
    },
    {
      "code" : "5931040082",
      "display" : "中和光田藥局"
    },
    {
      "code" : "5931040144",
      "display" : "安康藥局"
    },
    {
      "code" : "5931040153",
      "display" : "上仁藥局"
    },
    {
      "code" : "5931040180",
      "display" : "福雄藥局"
    },
    {
      "code" : "5931040215",
      "display" : "華新藥局"
    },
    {
      "code" : "5931040224",
      "display" : "欣祥藥局"
    },
    {
      "code" : "5931040242",
      "display" : "天立藥局"
    },
    {
      "code" : "5931040297",
      "display" : "信隆大藥局"
    },
    {
      "code" : "5931040313",
      "display" : "亮安藥局"
    },
    {
      "code" : "5931040322",
      "display" : "宏信藥局"
    },
    {
      "code" : "5931040395",
      "display" : "旭豐藥局"
    },
    {
      "code" : "5931040402",
      "display" : "健星藥局"
    },
    {
      "code" : "5931040475",
      "display" : "顧藥局"
    },
    {
      "code" : "5931040546",
      "display" : "林德興藥局"
    },
    {
      "code" : "5931040564",
      "display" : "宜生藥局"
    },
    {
      "code" : "5931040573",
      "display" : "欣大藥局"
    },
    {
      "code" : "5931040617",
      "display" : "田邊藥局"
    },
    {
      "code" : "5931040653",
      "display" : "新源林藥局"
    },
    {
      "code" : "5931040662",
      "display" : "仙正藥局"
    },
    {
      "code" : "5931040671",
      "display" : "吉立藥局"
    },
    {
      "code" : "5931040680",
      "display" : "博健藥局"
    },
    {
      "code" : "5931040724",
      "display" : "梓芳大藥局"
    },
    {
      "code" : "5931040733",
      "display" : "日發藥局"
    },
    {
      "code" : "5931040742",
      "display" : "開發大藥局"
    },
    {
      "code" : "5931040822",
      "display" : "國新藥局"
    },
    {
      "code" : "5931040840",
      "display" : "千大藥局"
    },
    {
      "code" : "5931041061",
      "display" : "裕壬藥局"
    },
    {
      "code" : "5931041070",
      "display" : "祥田藥局"
    },
    {
      "code" : "5931042282",
      "display" : "慈光藥局"
    },
    {
      "code" : "5931042326",
      "display" : "璟福藥局"
    },
    {
      "code" : "5931042371",
      "display" : "真成大藥局"
    },
    {
      "code" : "5931042648",
      "display" : "恩溢藥局"
    },
    {
      "code" : "5931042728",
      "display" : "上元藥局"
    },
    {
      "code" : "5931042782",
      "display" : "弘安藥局"
    },
    {
      "code" : "5931042808",
      "display" : "民德藥局"
    },
    {
      "code" : "5931042817",
      "display" : "家嘉藥局"
    },
    {
      "code" : "5931042853",
      "display" : "正陽藥師藥局"
    },
    {
      "code" : "5931042899",
      "display" : "家家藥局"
    },
    {
      "code" : "5931043047",
      "display" : "藥安藥局"
    },
    {
      "code" : "5931043109",
      "display" : "育新藥局"
    },
    {
      "code" : "5931043136",
      "display" : "聖康藥師藥局"
    },
    {
      "code" : "5931043181",
      "display" : "建琳藥局"
    },
    {
      "code" : "5931043216",
      "display" : "億華藥局"
    },
    {
      "code" : "5931043234",
      "display" : "康荃優生保健藥局"
    },
    {
      "code" : "5931043369",
      "display" : "泰泰健保藥局"
    },
    {
      "code" : "5931043396",
      "display" : "立健藥局"
    },
    {
      "code" : "5931043421",
      "display" : "錦和藥局"
    },
    {
      "code" : "5931043430",
      "display" : "慶華藥師藥局"
    },
    {
      "code" : "5931043501",
      "display" : "悅聖藥局"
    },
    {
      "code" : "5931043529",
      "display" : "新雙和藥師藥局"
    },
    {
      "code" : "5931043538",
      "display" : "三越藥局"
    },
    {
      "code" : "5931043565",
      "display" : "一安藥妝藥局"
    },
    {
      "code" : "5931043592",
      "display" : "美佳大藥局"
    },
    {
      "code" : "5931043627",
      "display" : "銓家藥局"
    },
    {
      "code" : "5931043636",
      "display" : "雙合藥局"
    },
    {
      "code" : "5931043663",
      "display" : "群芳藥局"
    },
    {
      "code" : "5931043690",
      "display" : "捷勝藥師藥局"
    },
    {
      "code" : "5931043761",
      "display" : "杏元藥局"
    },
    {
      "code" : "5931043770",
      "display" : "宜安健康人生藥局"
    },
    {
      "code" : "5931043798",
      "display" : "永成藥局"
    },
    {
      "code" : "5931043921",
      "display" : "良安藥局"
    },
    {
      "code" : "5931043930",
      "display" : "三德和藥局"
    },
    {
      "code" : "5931043976",
      "display" : "詠邑藥局"
    },
    {
      "code" : "5931044017",
      "display" : "幸福連鎖藥局"
    },
    {
      "code" : "5931044044",
      "display" : "宥元藥局"
    },
    {
      "code" : "5931044133",
      "display" : "康富力藥局"
    },
    {
      "code" : "5931044188",
      "display" : "安和藥師藥局"
    },
    {
      "code" : "5931044204",
      "display" : "康廷安藥局"
    },
    {
      "code" : "5931044268",
      "display" : "冠品藥師藥局"
    },
    {
      "code" : "5931044277",
      "display" : "維康藥局雙和店"
    },
    {
      "code" : "5931044375",
      "display" : "藥聯藥師藥局"
    },
    {
      "code" : "5931044393",
      "display" : "躍獅康銓藥局"
    },
    {
      "code" : "5931044419",
      "display" : "喬登藥局"
    },
    {
      "code" : "5931044464",
      "display" : "健暉藥局"
    },
    {
      "code" : "5931044491",
      "display" : "里安藥局"
    },
    {
      "code" : "5931044508",
      "display" : "和欣泰藥局"
    },
    {
      "code" : "5931044580",
      "display" : "躍獅天晴藥局"
    },
    {
      "code" : "5931044599",
      "display" : "成合藥局"
    },
    {
      "code" : "5931044606",
      "display" : "詠安藥局"
    },
    {
      "code" : "5931044615",
      "display" : "安泰大藥局"
    },
    {
      "code" : "5931044624",
      "display" : "奕采藥局"
    },
    {
      "code" : "5931044642",
      "display" : "貞心藥局"
    },
    {
      "code" : "5931044660",
      "display" : "吉佑藥局"
    },
    {
      "code" : "5931044679",
      "display" : "以法蓮藥局"
    },
    {
      "code" : "5931044704",
      "display" : "惠民藥局"
    },
    {
      "code" : "5931044740",
      "display" : "廣元藥局"
    },
    {
      "code" : "5931044768",
      "display" : "民樂健保藥局"
    },
    {
      "code" : "5931044786",
      "display" : "坤暉藥局"
    },
    {
      "code" : "5931044802",
      "display" : "皇秦大藥局"
    },
    {
      "code" : "5931044820",
      "display" : "禾心藥局"
    },
    {
      "code" : "5931044848",
      "display" : "和霖生活藥局"
    },
    {
      "code" : "5931044875",
      "display" : "誼安健業藥局"
    },
    {
      "code" : "5931044884",
      "display" : "壹品藥局"
    },
    {
      "code" : "5931044955",
      "display" : "安騏生活藥局"
    },
    {
      "code" : "5931044973",
      "display" : "佳禾藥局"
    },
    {
      "code" : "5931044982",
      "display" : "萊恩藥局"
    },
    {
      "code" : "5931044991",
      "display" : "曜群藥局"
    },
    {
      "code" : "5931045032",
      "display" : "朝安藥局"
    },
    {
      "code" : "5931045041",
      "display" : "大誠藥局"
    },
    {
      "code" : "5931045050",
      "display" : "日發藥師藥局"
    },
    {
      "code" : "5931045069",
      "display" : "禾昌藥局"
    },
    {
      "code" : "5931045078",
      "display" : "福澤員山藥局"
    },
    {
      "code" : "5931045112",
      "display" : "景安藥局"
    },
    {
      "code" : "5931045121",
      "display" : "富康活力景新藥局"
    },
    {
      "code" : "5931045130",
      "display" : "四維藥局"
    },
    {
      "code" : "5931045149",
      "display" : "三華藥局"
    },
    {
      "code" : "5931045158",
      "display" : "九崧藥局"
    },
    {
      "code" : "5931045176",
      "display" : "藥安連勝藥局"
    },
    {
      "code" : "5931045185",
      "display" : "綠杏廟口藥局"
    },
    {
      "code" : "5931045194",
      "display" : "中山藥局"
    },
    {
      "code" : "5931045210",
      "display" : "廣來藥師藥局"
    },
    {
      "code" : "5931045229",
      "display" : "佑全中和景新藥局"
    },
    {
      "code" : "5931045256",
      "display" : "品心藥局"
    },
    {
      "code" : "5931045292",
      "display" : "福欣藥局"
    },
    {
      "code" : "5931045309",
      "display" : "杏一中和雙和藥局"
    },
    {
      "code" : "5931045318",
      "display" : "富康活力華興藥局"
    },
    {
      "code" : "5931045327",
      "display" : "景新藥局"
    },
    {
      "code" : "5931045336",
      "display" : "杏一中和中山藥局"
    },
    {
      "code" : "5931045345",
      "display" : "芳碩藥局"
    },
    {
      "code" : "5931045354",
      "display" : "榮記大藥局"
    },
    {
      "code" : "5931045363",
      "display" : "順儷景安藥局"
    },
    {
      "code" : "5931045372",
      "display" : "伍品藥局"
    },
    {
      "code" : "5931045407",
      "display" : "中和慈美藥局"
    },
    {
      "code" : "5931045416",
      "display" : "信毅藥局"
    },
    {
      "code" : "5931045425",
      "display" : "千樂台安藥局"
    },
    {
      "code" : "5931045434",
      "display" : "悠悅藥局"
    },
    {
      "code" : "5931045443",
      "display" : "台昕藥局"
    },
    {
      "code" : "5931045452",
      "display" : "安華藥局"
    },
    {
      "code" : "5931045461",
      "display" : "富康活力遠東藥局"
    },
    {
      "code" : "5931045470",
      "display" : "富康活力永禎藥局"
    },
    {
      "code" : "5931045489",
      "display" : "順儷和平藥局"
    },
    {
      "code" : "5931045498",
      "display" : "好意藥局"
    },
    {
      "code" : "5931045505",
      "display" : "順儷民享藥局"
    },
    {
      "code" : "5931045514",
      "display" : "安泰健保藥局"
    },
    {
      "code" : "5931045532",
      "display" : "中山藥局"
    },
    {
      "code" : "5931045541",
      "display" : "富康活力華興藥局"
    },
    {
      "code" : "5931045550",
      "display" : "福澤員山藥局"
    },
    {
      "code" : "5931045569",
      "display" : "安泰健保藥局"
    },
    {
      "code" : "5931045578",
      "display" : "四維藥局"
    },
    {
      "code" : "5931045587",
      "display" : "安泰大藥局"
    },
    {
      "code" : "5931045596",
      "display" : "順儷景安藥局"
    },
    {
      "code" : "5931045603",
      "display" : "景本藥局"
    },
    {
      "code" : "5931045612",
      "display" : "躍獅中元藥局"
    },
    {
      "code" : "5931045621",
      "display" : "順儷和平藥局"
    },
    {
      "code" : "5931045630",
      "display" : "中山藥局"
    },
    {
      "code" : "5931045649",
      "display" : "康是美和宜藥局"
    },
    {
      "code" : "5931045658",
      "display" : "安泰健保藥局"
    },
    {
      "code" : "5931045667",
      "display" : "百合藥局"
    },
    {
      "code" : "5931045685",
      "display" : "聖康藥師藥局"
    },
    {
      "code" : "5931045694",
      "display" : "富康活力新生藥局"
    },
    {
      "code" : "5931045701",
      "display" : "大象藥局"
    },
    {
      "code" : "5931045710",
      "display" : "順儷宜安藥局"
    },
    {
      "code" : "5931045729",
      "display" : "力賀藥局"
    },
    {
      "code" : "5931045738",
      "display" : "杏一中和中山藥局"
    },
    {
      "code" : "5931045747",
      "display" : "順儷景安藥局"
    },
    {
      "code" : "5931045756",
      "display" : "員山春天藥局"
    },
    {
      "code" : "5931045765",
      "display" : "富康活力永禎藥局"
    },
    {
      "code" : "5931045774",
      "display" : "順儷和平藥局"
    },
    {
      "code" : "5931045783",
      "display" : "和心藥局"
    },
    {
      "code" : "5931045792",
      "display" : "惠民藥局"
    },
    {
      "code" : "5931045809",
      "display" : "福澤員山藥局"
    },
    {
      "code" : "5931045818",
      "display" : "聖康藥師藥局"
    },
    {
      "code" : "5931045827",
      "display" : "千樂台安藥局"
    },
    {
      "code" : "5931045836",
      "display" : "康愛藥局"
    },
    {
      "code" : "5931045845",
      "display" : "好意藥局"
    },
    {
      "code" : "5931045854",
      "display" : "秀仁藥局"
    },
    {
      "code" : "5931045863",
      "display" : "家嘉藥局"
    },
    {
      "code" : "5931045872",
      "display" : "順儷景安藥局"
    },
    {
      "code" : "5931045881",
      "display" : "順儷宜安藥局"
    },
    {
      "code" : "5931045907",
      "display" : "杏一中和中山藥局"
    },
    {
      "code" : "5931045916",
      "display" : "康是美和宜藥局"
    },
    {
      "code" : "5931045925",
      "display" : "芳碩藥局"
    },
    {
      "code" : "5931045934",
      "display" : "員山春天藥局"
    },
    {
      "code" : "5931045943",
      "display" : "順儷民享藥局"
    },
    {
      "code" : "5931045952",
      "display" : "榮記大藥局"
    },
    {
      "code" : "5931045961",
      "display" : "奕采藥局"
    },
    {
      "code" : "5931045970",
      "display" : "惠民藥局"
    },
    {
      "code" : "5931045989",
      "display" : "富康活力華興藥局"
    },
    {
      "code" : "5931045998",
      "display" : "富康活力遠東藥局"
    },
    {
      "code" : "5931046002",
      "display" : "正向專業藥局"
    },
    {
      "code" : "5931046011",
      "display" : "美心藥局"
    },
    {
      "code" : "5931046020",
      "display" : "躍獅秀山藥局"
    },
    {
      "code" : "5931046039",
      "display" : "景新藥局"
    },
    {
      "code" : "5931046048",
      "display" : "景安大澤藥局"
    },
    {
      "code" : "5931046057",
      "display" : "美心藥局"
    },
    {
      "code" : "5931046066",
      "display" : "康是美和宜藥局"
    },
    {
      "code" : "5931046075",
      "display" : "躍獅中元藥局"
    },
    {
      "code" : "5931046084",
      "display" : "惠進藥局"
    },
    {
      "code" : "5931046093",
      "display" : "成家健保藥局"
    },
    {
      "code" : "5931046119",
      "display" : "千樂台安藥局"
    },
    {
      "code" : "5931046128",
      "display" : "康義中安藥局"
    },
    {
      "code" : "5931046137",
      "display" : "宜安藥局"
    },
    {
      "code" : "5931046146",
      "display" : "躍獅中元藥局"
    },
    {
      "code" : "5931046155",
      "display" : "芳碩藥局"
    },
    {
      "code" : "5931046164",
      "display" : "杏一中和雙和藥局"
    },
    {
      "code" : "5931046173",
      "display" : "杏一中和中山藥局"
    },
    {
      "code" : "5931046182",
      "display" : "裕昌藥局"
    },
    {
      "code" : "5931046191",
      "display" : "康廷安藥局"
    },
    {
      "code" : "5931046208",
      "display" : "富康活力馥興藥局"
    },
    {
      "code" : "5931046226",
      "display" : "奕采藥局"
    },
    {
      "code" : "5931046235",
      "display" : "芳碩藥局"
    },
    {
      "code" : "5931046244",
      "display" : "中山藥局"
    },
    {
      "code" : "5931046253",
      "display" : "富康活力廣福藥局"
    },
    {
      "code" : "5931046262",
      "display" : "陸品藥局"
    },
    {
      "code" : "5931046271",
      "display" : "景藥局"
    },
    {
      "code" : "5931046299",
      "display" : "芳碩藥局"
    },
    {
      "code" : "5931046306",
      "display" : "榮記大藥局"
    },
    {
      "code" : "5931046315",
      "display" : "坤暉藥局"
    },
    {
      "code" : "5931046324",
      "display" : "富康活力遠東藥局"
    },
    {
      "code" : "5931050033",
      "display" : "仁淵藥局"
    },
    {
      "code" : "5931050104",
      "display" : "匯信大藥局"
    },
    {
      "code" : "5931050131",
      "display" : "再生藥局"
    },
    {
      "code" : "5931050211",
      "display" : "耀生中西藥局"
    },
    {
      "code" : "5931050364",
      "display" : "瑞欣藥局"
    },
    {
      "code" : "5931050408",
      "display" : "昌順藥局"
    },
    {
      "code" : "5931050417",
      "display" : "世明藥局"
    },
    {
      "code" : "5931050444",
      "display" : "活元藥局"
    },
    {
      "code" : "5931051558",
      "display" : "信龍大藥局"
    },
    {
      "code" : "5931051585",
      "display" : "益生大藥局"
    },
    {
      "code" : "5931051601",
      "display" : "昇旺藥局"
    },
    {
      "code" : "5931051674",
      "display" : "金美藥局"
    },
    {
      "code" : "5931051790",
      "display" : "家得福藥局"
    },
    {
      "code" : "5931051816",
      "display" : "康宜庭北新藥局"
    },
    {
      "code" : "5931051852",
      "display" : "康裕藥局"
    },
    {
      "code" : "5931051950",
      "display" : "中央大藥局"
    },
    {
      "code" : "5931052091",
      "display" : "康宜庭大坪林藥局"
    },
    {
      "code" : "5931052135",
      "display" : "椿萱藥局"
    },
    {
      "code" : "5931052215",
      "display" : "三民藥局"
    },
    {
      "code" : "5931052251",
      "display" : "昇育健康藥局"
    },
    {
      "code" : "5931052288",
      "display" : "躍獅正新藥局"
    },
    {
      "code" : "5931052313",
      "display" : "欣康藥局"
    },
    {
      "code" : "5931052368",
      "display" : "正安藥局"
    },
    {
      "code" : "5931052395",
      "display" : "寶輝藥局"
    },
    {
      "code" : "5931052439",
      "display" : "德莘藥局"
    },
    {
      "code" : "5931052457",
      "display" : "東碩藥局"
    },
    {
      "code" : "5931052484",
      "display" : "大河藥局"
    },
    {
      "code" : "5931052500",
      "display" : "欣美藥局"
    },
    {
      "code" : "5931052608",
      "display" : "佑成藥局"
    },
    {
      "code" : "5931052644",
      "display" : "杏運草藥局"
    },
    {
      "code" : "5931052653",
      "display" : "正升藥局"
    },
    {
      "code" : "5931052699",
      "display" : "維顥藥局"
    },
    {
      "code" : "5931052715",
      "display" : "陽光健康藥局"
    },
    {
      "code" : "5931052724",
      "display" : "合康大藥局"
    },
    {
      "code" : "5931052751",
      "display" : "新康藥局"
    },
    {
      "code" : "5931052797",
      "display" : "安欣藥局"
    },
    {
      "code" : "5931052804",
      "display" : "新店家安藥局"
    },
    {
      "code" : "5931052822",
      "display" : "瑞安健保藥局"
    },
    {
      "code" : "5931052840",
      "display" : "微笑生活藥局"
    },
    {
      "code" : "5931052920",
      "display" : "碧潭大藥局"
    },
    {
      "code" : "5931052966",
      "display" : "禾宜藥局"
    },
    {
      "code" : "5931052984",
      "display" : "北一藥師藥局"
    },
    {
      "code" : "5931052993",
      "display" : "唯客優藥局"
    },
    {
      "code" : "5931053007",
      "display" : "康曜藥師藥局"
    },
    {
      "code" : "5931053034",
      "display" : "康宜庭市公所藥局"
    },
    {
      "code" : "5931053061",
      "display" : "耕莘健康人生藥局"
    },
    {
      "code" : "5931053070",
      "display" : "美康中正藥局"
    },
    {
      "code" : "5931053089",
      "display" : "昇活藥局"
    },
    {
      "code" : "5931053098",
      "display" : "仁心藥局"
    },
    {
      "code" : "5931053123",
      "display" : "大吉藥局"
    },
    {
      "code" : "5931053132",
      "display" : "康宜庭碧潭藥局"
    },
    {
      "code" : "5931053141",
      "display" : "禾康藥局"
    },
    {
      "code" : "5931053169",
      "display" : "貳品藥局"
    },
    {
      "code" : "5931053178",
      "display" : "長照藥局"
    },
    {
      "code" : "5931053187",
      "display" : "建國六號藥局"
    },
    {
      "code" : "5931053196",
      "display" : "康心藥局"
    },
    {
      "code" : "5931053203",
      "display" : "巧新藥局"
    },
    {
      "code" : "5931053212",
      "display" : "康倍藥局"
    },
    {
      "code" : "5931053267",
      "display" : "富康活力惠國藥局"
    },
    {
      "code" : "5931053276",
      "display" : "富康活力新店藥局"
    },
    {
      "code" : "5931053285",
      "display" : "北新212藥局"
    },
    {
      "code" : "5931053294",
      "display" : "倍思特藥局"
    },
    {
      "code" : "5931053310",
      "display" : "安和藥局"
    },
    {
      "code" : "5931053329",
      "display" : "康宜庭民權藥局"
    },
    {
      "code" : "5931053338",
      "display" : "佳泰藥局"
    },
    {
      "code" : "5931053347",
      "display" : "健詮藥局"
    },
    {
      "code" : "5931053356",
      "display" : "安康佑康藥局"
    },
    {
      "code" : "5931053365",
      "display" : "十二願藥局"
    },
    {
      "code" : "5931053374",
      "display" : "均安藥局"
    },
    {
      "code" : "5931053383",
      "display" : "大豐藥局"
    },
    {
      "code" : "5931053392",
      "display" : "林旺藥局"
    },
    {
      "code" : "5931053409",
      "display" : "寶德藥局"
    },
    {
      "code" : "5931053418",
      "display" : "佑全新店北新藥局"
    },
    {
      "code" : "5931053427",
      "display" : "和霖生活藥局青潭店"
    },
    {
      "code" : "5931053436",
      "display" : "政新藥局"
    },
    {
      "code" : "5931053445",
      "display" : "公崙藥局"
    },
    {
      "code" : "5931053454",
      "display" : "富康活力安程藥局"
    },
    {
      "code" : "5931053463",
      "display" : "康是美福民藥局"
    },
    {
      "code" : "5931053472",
      "display" : "信義佳泰藥局"
    },
    {
      "code" : "5931053481",
      "display" : "富康活力惠國藥局"
    },
    {
      "code" : "5931053490",
      "display" : "新店藥局"
    },
    {
      "code" : "5931053507",
      "display" : "倍思特藥局"
    },
    {
      "code" : "5931053525",
      "display" : "信義佳泰藥局"
    },
    {
      "code" : "5931053534",
      "display" : "康是美惠國藥局"
    },
    {
      "code" : "5931053543",
      "display" : "法米大坪林藥局"
    },
    {
      "code" : "5931053552",
      "display" : "十二願藥局"
    },
    {
      "code" : "5931053561",
      "display" : "新店藥局"
    },
    {
      "code" : "5931053570",
      "display" : "安和藥局"
    },
    {
      "code" : "5931053589",
      "display" : "心樂藥局"
    },
    {
      "code" : "5931053598",
      "display" : "康是美惠國藥局"
    },
    {
      "code" : "5931053605",
      "display" : "富康活力大豐藥局"
    },
    {
      "code" : "5931053614",
      "display" : "北一藥師藥局"
    },
    {
      "code" : "5931053632",
      "display" : "永杏中西藥局"
    },
    {
      "code" : "5931053641",
      "display" : "信義佳泰藥局"
    },
    {
      "code" : "5931053650",
      "display" : "伸福康藥局"
    },
    {
      "code" : "5931053669",
      "display" : "富康活力惠國藥局"
    },
    {
      "code" : "5931053678",
      "display" : "安康佑康藥局"
    },
    {
      "code" : "5931053687",
      "display" : "倍思特藥局"
    },
    {
      "code" : "5931053696",
      "display" : "信義佳泰藥局"
    },
    {
      "code" : "5931053703",
      "display" : "現代藥局"
    },
    {
      "code" : "5931053712",
      "display" : "安和藥局"
    },
    {
      "code" : "5931053721",
      "display" : "中外藥局"
    },
    {
      "code" : "5931053730",
      "display" : "新店藥局"
    },
    {
      "code" : "5931053749",
      "display" : "倍思特藥局"
    },
    {
      "code" : "5931053758",
      "display" : "昇旺藥局"
    },
    {
      "code" : "5931053767",
      "display" : "富康活力安程藥局"
    },
    {
      "code" : "5931053776",
      "display" : "復泰藥局"
    },
    {
      "code" : "5931053785",
      "display" : "天杏藥局"
    },
    {
      "code" : "5931053794",
      "display" : "富康活力惠國藥局"
    },
    {
      "code" : "5931053801",
      "display" : "富康活力菁談藥局"
    },
    {
      "code" : "5931053810",
      "display" : "中外藥局"
    },
    {
      "code" : "5931053829",
      "display" : "湯泉藥師藥局"
    },
    {
      "code" : "5931053838",
      "display" : "台化皮咔丘藥局"
    },
    {
      "code" : "5931060146",
      "display" : "海山藥局"
    },
    {
      "code" : "5931060217",
      "display" : "富國藥局"
    },
    {
      "code" : "5931060244",
      "display" : "七安大藥局"
    },
    {
      "code" : "5931060262",
      "display" : "明生藥局"
    },
    {
      "code" : "5931060315",
      "display" : "文安藥局"
    },
    {
      "code" : "5931060342",
      "display" : "十安藥局"
    },
    {
      "code" : "5931060351",
      "display" : "冠仁藥局"
    },
    {
      "code" : "5931060431",
      "display" : "武田藥局"
    },
    {
      "code" : "5931060548",
      "display" : "二安藥局"
    },
    {
      "code" : "5931060557",
      "display" : "一安藥局"
    },
    {
      "code" : "5931060619",
      "display" : "蘇藥局"
    },
    {
      "code" : "5931060628",
      "display" : "錄新藥局"
    },
    {
      "code" : "5931060646",
      "display" : "王藥局"
    },
    {
      "code" : "5931060682",
      "display" : "勝安藥局"
    },
    {
      "code" : "5931060744",
      "display" : "祥好大藥局"
    },
    {
      "code" : "5931060815",
      "display" : "祐全大藥局"
    },
    {
      "code" : "5931060824",
      "display" : "禮安藥師藥局"
    },
    {
      "code" : "5931067092",
      "display" : "恩泰藥局"
    },
    {
      "code" : "5931067109",
      "display" : "揚明藥師藥局"
    },
    {
      "code" : "5931067136",
      "display" : "蒲陽藥局"
    },
    {
      "code" : "5931067145",
      "display" : "鶴田藥局"
    },
    {
      "code" : "5931067172",
      "display" : "民安藥局"
    },
    {
      "code" : "5931067216",
      "display" : "鍵豐藥局"
    },
    {
      "code" : "5931067332",
      "display" : "富祐藥局"
    },
    {
      "code" : "5931067378",
      "display" : "天給藥局"
    },
    {
      "code" : "5931067403",
      "display" : "建嘉藥局"
    },
    {
      "code" : "5931067412",
      "display" : "幸寧藥局"
    },
    {
      "code" : "5931067529",
      "display" : "北安藥局"
    },
    {
      "code" : "5931067547",
      "display" : "金翔藥局"
    },
    {
      "code" : "5931067565",
      "display" : "豐年藥局"
    },
    {
      "code" : "5931067850",
      "display" : "聯合藥局"
    },
    {
      "code" : "5931067903",
      "display" : "西華藥局"
    },
    {
      "code" : "5931067985",
      "display" : "蘋果藥局"
    },
    {
      "code" : "5931068008",
      "display" : "北醫藥局"
    },
    {
      "code" : "5931068080",
      "display" : "快樂藥局"
    },
    {
      "code" : "5931068151",
      "display" : "世鴻藥局"
    },
    {
      "code" : "5931068160",
      "display" : "三大藥局"
    },
    {
      "code" : "5931068268",
      "display" : "新莊大東藥局"
    },
    {
      "code" : "5931068302",
      "display" : "宏發藥局"
    },
    {
      "code" : "5931068375",
      "display" : "惠欣藥局"
    },
    {
      "code" : "5931068455",
      "display" : "合康藥師藥局"
    },
    {
      "code" : "5931068464",
      "display" : "健安藥局"
    },
    {
      "code" : "5931068508",
      "display" : "凱盛藥局"
    },
    {
      "code" : "5931068535",
      "display" : "永安藥局"
    },
    {
      "code" : "5931068580",
      "display" : "春元藥局"
    },
    {
      "code" : "5931068599",
      "display" : "建昌藥局"
    },
    {
      "code" : "5931068624",
      "display" : "瑞豐大藥局"
    },
    {
      "code" : "5931068633",
      "display" : "福華藥局"
    },
    {
      "code" : "5931068660",
      "display" : "翔昱健保藥局"
    },
    {
      "code" : "5931068722",
      "display" : "庭安藥局"
    },
    {
      "code" : "5931068759",
      "display" : "森活藥局"
    },
    {
      "code" : "5931068819",
      "display" : "東京大藥局"
    },
    {
      "code" : "5931068866",
      "display" : "大愛藥師藥局"
    },
    {
      "code" : "5931068875",
      "display" : "旭生藥局"
    },
    {
      "code" : "5931068884",
      "display" : "樂寶兒藥局"
    },
    {
      "code" : "5931068964",
      "display" : "賞安藥局"
    },
    {
      "code" : "5931068973",
      "display" : "富安藥局"
    },
    {
      "code" : "5931068991",
      "display" : "新莊健業藥局"
    },
    {
      "code" : "5931069023",
      "display" : "陽光藥局"
    },
    {
      "code" : "5931069201",
      "display" : "招安藥師藥局"
    },
    {
      "code" : "5931069265",
      "display" : "錦安藥局"
    },
    {
      "code" : "5931069363",
      "display" : "明亮藥局"
    },
    {
      "code" : "5931069372",
      "display" : "羽豐藥局"
    },
    {
      "code" : "5931069425",
      "display" : "國安藥局"
    },
    {
      "code" : "5931069498",
      "display" : "新杏藥局"
    },
    {
      "code" : "5931069505",
      "display" : "陽光連鎖藥局"
    },
    {
      "code" : "5931069532",
      "display" : "聯盟藥局"
    },
    {
      "code" : "5931069569",
      "display" : "心安藥局"
    },
    {
      "code" : "5931069603",
      "display" : "中信藥師藥局"
    },
    {
      "code" : "5931069701",
      "display" : "日光藥局"
    },
    {
      "code" : "5931069747",
      "display" : "禾佳藥局"
    },
    {
      "code" : "5931069765",
      "display" : "健業藥妝藥局"
    },
    {
      "code" : "5931069774",
      "display" : "真安綜合大藥局"
    },
    {
      "code" : "5931069792",
      "display" : "宏泰藥局"
    },
    {
      "code" : "5931069854",
      "display" : "康民藥局"
    },
    {
      "code" : "5931069863",
      "display" : "大方藥局"
    },
    {
      "code" : "5931069916",
      "display" : "朝陽藥局"
    },
    {
      "code" : "593106A011",
      "display" : "八德藥局"
    },
    {
      "code" : "593106A020",
      "display" : "紅豆藥局"
    },
    {
      "code" : "593106A039",
      "display" : "大仁藥局"
    },
    {
      "code" : "593106A093",
      "display" : "環球藥局"
    },
    {
      "code" : "593106A155",
      "display" : "日榮藥局"
    },
    {
      "code" : "593106A164",
      "display" : "家福健保藥局"
    },
    {
      "code" : "593106A173",
      "display" : "華泰藥局"
    },
    {
      "code" : "593106A244",
      "display" : "巧心藥局"
    },
    {
      "code" : "593106A299",
      "display" : "悅生藥局"
    },
    {
      "code" : "593106A324",
      "display" : "向日葵健保藥局"
    },
    {
      "code" : "593106A342",
      "display" : "真美滿藥局"
    },
    {
      "code" : "593106A379",
      "display" : "輔大美康藥局"
    },
    {
      "code" : "593106A388",
      "display" : "元大藥局"
    },
    {
      "code" : "593106A404",
      "display" : "新新藥局"
    },
    {
      "code" : "593106A422",
      "display" : "英謙藥局"
    },
    {
      "code" : "593106A477",
      "display" : "喜悅藥局"
    },
    {
      "code" : "593106A511",
      "display" : "明仁健保藥局"
    },
    {
      "code" : "593106A566",
      "display" : "一心春天藥局"
    },
    {
      "code" : "593106A584",
      "display" : "記安大藥局"
    },
    {
      "code" : "593106A600",
      "display" : "全鎵藥局"
    },
    {
      "code" : "593106A628",
      "display" : "中原藥局"
    },
    {
      "code" : "593106A637",
      "display" : "薇妮藥妝藥局"
    },
    {
      "code" : "593106A646",
      "display" : "薇妮雙鳳藥局"
    },
    {
      "code" : "593106A708",
      "display" : "宏福藥局"
    },
    {
      "code" : "593106A717",
      "display" : "大樹幸福藥局"
    },
    {
      "code" : "593106A726",
      "display" : "良和健保藥局"
    },
    {
      "code" : "593106A735",
      "display" : "樂家藥局"
    },
    {
      "code" : "593106A744",
      "display" : "永明藥局"
    },
    {
      "code" : "593106A771",
      "display" : "新佑康健保藥局"
    },
    {
      "code" : "593106A824",
      "display" : "家禾藥局"
    },
    {
      "code" : "593106A833",
      "display" : "欣國藥局"
    },
    {
      "code" : "593106A842",
      "display" : "鼎極藥局"
    },
    {
      "code" : "593106A851",
      "display" : "躍獅新豐藥局"
    },
    {
      "code" : "593106A860",
      "display" : "新莊至誠藥局"
    },
    {
      "code" : "593106A888",
      "display" : "晉成藥局"
    },
    {
      "code" : "593106A897",
      "display" : "陽光豐年藥局"
    },
    {
      "code" : "593106A904",
      "display" : "杏佳藥師藥局"
    },
    {
      "code" : "593106A913",
      "display" : "洋欣藥局"
    },
    {
      "code" : "593106A922",
      "display" : "德翰藥局"
    },
    {
      "code" : "593106A931",
      "display" : "建安藥局"
    },
    {
      "code" : "593106A959",
      "display" : "新莊大藥局"
    },
    {
      "code" : "593106A977",
      "display" : "丹鳳藥局"
    },
    {
      "code" : "593106A986",
      "display" : "立威藥局"
    },
    {
      "code" : "593106A995",
      "display" : "美德心藥局"
    },
    {
      "code" : "593106B027",
      "display" : "樂福藥局"
    },
    {
      "code" : "593106B036",
      "display" : "家嘉藥局"
    },
    {
      "code" : "593106B045",
      "display" : "力源藥局"
    },
    {
      "code" : "593106B054",
      "display" : "樂恩藥局"
    },
    {
      "code" : "593106B072",
      "display" : "小林健保藥局"
    },
    {
      "code" : "593106B081",
      "display" : "平安藥局"
    },
    {
      "code" : "593106B090",
      "display" : "依都勇藥局"
    },
    {
      "code" : "593106B107",
      "display" : "大樹新莊藥局"
    },
    {
      "code" : "593106B116",
      "display" : "來福中西健保藥局"
    },
    {
      "code" : "593106B125",
      "display" : "樂安生活藥局"
    },
    {
      "code" : "593106B134",
      "display" : "喜來樂中西藥局"
    },
    {
      "code" : "593106B143",
      "display" : "一銘藥局"
    },
    {
      "code" : "593106B152",
      "display" : "福原藥局"
    },
    {
      "code" : "593106B189",
      "display" : "美康頭前藥局"
    },
    {
      "code" : "593106B198",
      "display" : "和昌藥局"
    },
    {
      "code" : "593106B205",
      "display" : "藥師佛藥局"
    },
    {
      "code" : "593106B214",
      "display" : "微笑埔銓藥局"
    },
    {
      "code" : "593106B223",
      "display" : "吉田藥局"
    },
    {
      "code" : "593106B232",
      "display" : "新康健保藥局"
    },
    {
      "code" : "593106B241",
      "display" : "善美藥局"
    },
    {
      "code" : "593106B269",
      "display" : "聯成藥局"
    },
    {
      "code" : "593106B278",
      "display" : "家康藥局"
    },
    {
      "code" : "593106B287",
      "display" : "盛弘藥局"
    },
    {
      "code" : "593106B296",
      "display" : "廣元藥局"
    },
    {
      "code" : "593106B303",
      "display" : "新莊丁丁藥局"
    },
    {
      "code" : "593106B312",
      "display" : "家康藥局"
    },
    {
      "code" : "593106B321",
      "display" : "大樹幸福藥局"
    },
    {
      "code" : "593106B330",
      "display" : "和昌藥局"
    },
    {
      "code" : "593106B349",
      "display" : "騰康藥局"
    },
    {
      "code" : "593106B358",
      "display" : "熊健康藥局"
    },
    {
      "code" : "593106B385",
      "display" : "新莊大藥局"
    },
    {
      "code" : "593106B394",
      "display" : "躍獅新豐藥局"
    },
    {
      "code" : "593106B401",
      "display" : "健生活新莊體育館藥局"
    },
    {
      "code" : "593106B410",
      "display" : "和昌藥局"
    },
    {
      "code" : "593106B438",
      "display" : "中港藥局"
    },
    {
      "code" : "593106B447",
      "display" : "一心春天藥局"
    },
    {
      "code" : "593106B456",
      "display" : "聯成藥局"
    },
    {
      "code" : "593106B465",
      "display" : "福澤中正藥局"
    },
    {
      "code" : "593106B474",
      "display" : "陽光豐年藥局"
    },
    {
      "code" : "593106B483",
      "display" : "福原藥局"
    },
    {
      "code" : "593106B509",
      "display" : "光榮藥局"
    },
    {
      "code" : "593106B527",
      "display" : "康信藥局"
    },
    {
      "code" : "593106B536",
      "display" : "福華藥局"
    },
    {
      "code" : "593106B545",
      "display" : "一心春天藥局"
    },
    {
      "code" : "593106B563",
      "display" : "温馨藥局"
    },
    {
      "code" : "593106B572",
      "display" : "來福中西健保藥局"
    },
    {
      "code" : "593106B581",
      "display" : "大樹新莊藥局"
    },
    {
      "code" : "593106B590",
      "display" : "康是美鑫泰藥局"
    },
    {
      "code" : "593106B607",
      "display" : "洋欣藥局"
    },
    {
      "code" : "593106B616",
      "display" : "新莊丁丁藥局"
    },
    {
      "code" : "593106B625",
      "display" : "家康藥局"
    },
    {
      "code" : "593106B634",
      "display" : "英欠藥局"
    },
    {
      "code" : "593106B643",
      "display" : "大樹新莊藥局"
    },
    {
      "code" : "593106B652",
      "display" : "柏弘藥局"
    },
    {
      "code" : "593106B661",
      "display" : "七安大藥局"
    },
    {
      "code" : "593106B670",
      "display" : "三大藥局"
    },
    {
      "code" : "593106B689",
      "display" : "心安藥局"
    },
    {
      "code" : "593106B698",
      "display" : "星晨藥局"
    },
    {
      "code" : "593106B705",
      "display" : "康是美鑫泰藥局"
    },
    {
      "code" : "593106B714",
      "display" : "富安藥局"
    },
    {
      "code" : "593106B723",
      "display" : "益民長恩藥局"
    },
    {
      "code" : "593106B732",
      "display" : "福原藥局"
    },
    {
      "code" : "593106B741",
      "display" : "民安藥局"
    },
    {
      "code" : "593106B750",
      "display" : "悠活宏泰藥局"
    },
    {
      "code" : "593106B769",
      "display" : "巧心藥局"
    },
    {
      "code" : "593106B778",
      "display" : "新美藥局"
    },
    {
      "code" : "593106B787",
      "display" : "禾利藥局"
    },
    {
      "code" : "593106B796",
      "display" : "新佑康健保藥局"
    },
    {
      "code" : "593106B803",
      "display" : "新康健保藥局"
    },
    {
      "code" : "593106B812",
      "display" : "柏弘藥局"
    },
    {
      "code" : "593106B821",
      "display" : "健業藥妝藥局"
    },
    {
      "code" : "593106B830",
      "display" : "湧恩藥師藥局"
    },
    {
      "code" : "593106B849",
      "display" : "和昌藥局"
    },
    {
      "code" : "593106B858",
      "display" : "朝陽藥局"
    },
    {
      "code" : "593106B867",
      "display" : "新佑康健保藥局"
    },
    {
      "code" : "593106B876",
      "display" : "昌平藥局"
    },
    {
      "code" : "593106B894",
      "display" : "世鴻藥局"
    },
    {
      "code" : "593106B901",
      "display" : "家福健保藥局"
    },
    {
      "code" : "593106B910",
      "display" : "健生活新莊體育館藥局"
    },
    {
      "code" : "593106B929",
      "display" : "一心春天藥局"
    },
    {
      "code" : "593106B938",
      "display" : "耀勝藥局"
    },
    {
      "code" : "593106B947",
      "display" : "平安藥局"
    },
    {
      "code" : "593106B956",
      "display" : "群康藥局"
    },
    {
      "code" : "593106B974",
      "display" : "光榮藥局"
    },
    {
      "code" : "593106B983",
      "display" : "建嘉藥局"
    },
    {
      "code" : "593106B992",
      "display" : "專品幸福藥局"
    },
    {
      "code" : "593106C006",
      "display" : "丹鳳藥局"
    },
    {
      "code" : "593106C015",
      "display" : "新莊至誠藥局"
    },
    {
      "code" : "593106C024",
      "display" : "日榮藥局"
    },
    {
      "code" : "593106C033",
      "display" : "明仁健保藥局"
    },
    {
      "code" : "593106C042",
      "display" : "和昌藥局"
    },
    {
      "code" : "593106C051",
      "display" : "杏原藥局"
    },
    {
      "code" : "593106C060",
      "display" : "中港藥局"
    },
    {
      "code" : "593106C079",
      "display" : "暘光豐年藥局"
    },
    {
      "code" : "593106C088",
      "display" : "鮪魚藥師藥局"
    },
    {
      "code" : "593106C097",
      "display" : "新佑康健保藥局"
    },
    {
      "code" : "593106C104",
      "display" : "躍獅思源藥局"
    },
    {
      "code" : "593106C113",
      "display" : "新心藥局"
    },
    {
      "code" : "593106C122",
      "display" : "早安藥局"
    },
    {
      "code" : "593106C131",
      "display" : "活力康藥局"
    },
    {
      "code" : "593106C140",
      "display" : "健生活新莊體育館藥局"
    },
    {
      "code" : "593106C159",
      "display" : "藥華藥局"
    },
    {
      "code" : "593106C168",
      "display" : "新心藥局"
    },
    {
      "code" : "593106C177",
      "display" : "新心藥局"
    },
    {
      "code" : "593106C186",
      "display" : "杏佳藥師藥局"
    },
    {
      "code" : "593106C195",
      "display" : "躍獅新豐藥局"
    },
    {
      "code" : "593106C202",
      "display" : "新莊至誠藥局"
    },
    {
      "code" : "593106C211",
      "display" : "果心藥局"
    },
    {
      "code" : "5931070044",
      "display" : "正宜藥局"
    },
    {
      "code" : "5931070053",
      "display" : "仁一藥局"
    },
    {
      "code" : "5931070062",
      "display" : "鴻真藥局"
    },
    {
      "code" : "5931070080",
      "display" : "耀鴻藥局"
    },
    {
      "code" : "5931070099",
      "display" : "日弘藥師藥局"
    },
    {
      "code" : "5931070142",
      "display" : "江藥局"
    },
    {
      "code" : "5931070204",
      "display" : "懷恩藥局"
    },
    {
      "code" : "5931070213",
      "display" : "明川藥師藥局"
    },
    {
      "code" : "5931070286",
      "display" : "協安大藥局"
    },
    {
      "code" : "5931070348",
      "display" : "久青藥局"
    },
    {
      "code" : "5931070366",
      "display" : "聖和藥局"
    },
    {
      "code" : "5931070393",
      "display" : "羅群藥局"
    },
    {
      "code" : "5931070419",
      "display" : "暉民西藥局"
    },
    {
      "code" : "5931071425",
      "display" : "又怡藥師藥局"
    },
    {
      "code" : "5931071523",
      "display" : "蔚海藥局"
    },
    {
      "code" : "5931071532",
      "display" : "育生藥局"
    },
    {
      "code" : "5931071550",
      "display" : "久豐大藥局"
    },
    {
      "code" : "5931071649",
      "display" : "博生藥師藥局"
    },
    {
      "code" : "5931071658",
      "display" : "大慶藥局"
    },
    {
      "code" : "5931071774",
      "display" : "澤安藥師藥局"
    },
    {
      "code" : "5931071836",
      "display" : "弘昌藥師藥局"
    },
    {
      "code" : "5931071881",
      "display" : "盛立藥局"
    },
    {
      "code" : "5931071916",
      "display" : "立欣藥局"
    },
    {
      "code" : "5931071934",
      "display" : "樹新藥局"
    },
    {
      "code" : "5931071961",
      "display" : "綠蘋果藥局"
    },
    {
      "code" : "5931071970",
      "display" : "保康藥局"
    },
    {
      "code" : "5931072020",
      "display" : "泰平藥師藥局"
    },
    {
      "code" : "5931072039",
      "display" : "樹林藥師藥局"
    },
    {
      "code" : "5931072066",
      "display" : "琉璃水藥師藥局"
    },
    {
      "code" : "5931072137",
      "display" : "保安健保藥局"
    },
    {
      "code" : "5931072191",
      "display" : "生光堂藥局"
    },
    {
      "code" : "5931072217",
      "display" : "協興藥局"
    },
    {
      "code" : "5931072244",
      "display" : "彰安藥局"
    },
    {
      "code" : "5931072253",
      "display" : "活水藥局"
    },
    {
      "code" : "5931072262",
      "display" : "祐心藥局"
    },
    {
      "code" : "5931072299",
      "display" : "小蜜蜂中西健保藥局"
    },
    {
      "code" : "5931072351",
      "display" : "瑪諾藥局"
    },
    {
      "code" : "5931072388",
      "display" : "愛立康藥局"
    },
    {
      "code" : "5931072404",
      "display" : "伯安綜合藥局"
    },
    {
      "code" : "5931072413",
      "display" : "誠新大藥局"
    },
    {
      "code" : "5931072422",
      "display" : "三樹食在好健康藥局"
    },
    {
      "code" : "5931072431",
      "display" : "樹林大樹藥局"
    },
    {
      "code" : "5931072459",
      "display" : "健康人生藥局"
    },
    {
      "code" : "5931072468",
      "display" : "樹林丁丁藥局"
    },
    {
      "code" : "5931072495",
      "display" : "鄰康藥局"
    },
    {
      "code" : "5931072502",
      "display" : "啄木鳥藥局"
    },
    {
      "code" : "5931072511",
      "display" : "信和藥局"
    },
    {
      "code" : "5931072520",
      "display" : "世淇健保藥局"
    },
    {
      "code" : "5931072539",
      "display" : "樂澄藥局"
    },
    {
      "code" : "5931072575",
      "display" : "永賀藥局"
    },
    {
      "code" : "5931072584",
      "display" : "佳園藥局"
    },
    {
      "code" : "5931072593",
      "display" : "杏一樹林保安藥局"
    },
    {
      "code" : "5931072600",
      "display" : "藥師丸藥局"
    },
    {
      "code" : "5931072628",
      "display" : "樹林食在好健康藥局"
    },
    {
      "code" : "5931072637",
      "display" : "有日大藥局"
    },
    {
      "code" : "5931072646",
      "display" : "北一北大藥局"
    },
    {
      "code" : "5931072655",
      "display" : "得意藥局"
    },
    {
      "code" : "5931072664",
      "display" : "三樹食在好健康藥局"
    },
    {
      "code" : "5931072673",
      "display" : "森森藥局"
    },
    {
      "code" : "5931072682",
      "display" : "上宸藥局"
    },
    {
      "code" : "5931072691",
      "display" : "樂澄藥局"
    },
    {
      "code" : "5931072708",
      "display" : "益銘藥師藥局"
    },
    {
      "code" : "5931072717",
      "display" : "森森藥局"
    },
    {
      "code" : "5931072726",
      "display" : "良方藥局"
    },
    {
      "code" : "5931072735",
      "display" : "樹林藥局"
    },
    {
      "code" : "5931072744",
      "display" : "羅群藥局"
    },
    {
      "code" : "5931072753",
      "display" : "森森藥局"
    },
    {
      "code" : "5931072762",
      "display" : "信和藥局"
    },
    {
      "code" : "5931072780",
      "display" : "盛巨藥局"
    },
    {
      "code" : "5931072799",
      "display" : "上宸藥局"
    },
    {
      "code" : "5931072806",
      "display" : "松耘藥局"
    },
    {
      "code" : "5931072815",
      "display" : "喜樂藥局"
    },
    {
      "code" : "5931072824",
      "display" : "柑心藥局"
    },
    {
      "code" : "5931080022",
      "display" : "藥濟藥局"
    },
    {
      "code" : "5931080031",
      "display" : "林政德西藥局"
    },
    {
      "code" : "5931080148",
      "display" : "快安藥師藥局"
    },
    {
      "code" : "5931081216",
      "display" : "嘉泰藥師藥局"
    },
    {
      "code" : "5931081234",
      "display" : "文瑞藥局"
    },
    {
      "code" : "5931081289",
      "display" : "唯新示範藥局"
    },
    {
      "code" : "5931081305",
      "display" : "佑家藥局"
    },
    {
      "code" : "5931081332",
      "display" : "祐兒藥局"
    },
    {
      "code" : "5931081378",
      "display" : "鶯歌宏達藥局"
    },
    {
      "code" : "5931081396",
      "display" : "祐康藥局"
    },
    {
      "code" : "5931081403",
      "display" : "純安大藥局"
    },
    {
      "code" : "5931081412",
      "display" : "小樹藥師藥局"
    },
    {
      "code" : "5931081421",
      "display" : "萊爾康健保藥局"
    },
    {
      "code" : "5931081430",
      "display" : "華昇藥局"
    },
    {
      "code" : "5931081458",
      "display" : "食在好健康藥局"
    },
    {
      "code" : "5931081494",
      "display" : "康群藥局"
    },
    {
      "code" : "5931081510",
      "display" : "鶯歌藥局"
    },
    {
      "code" : "5931081529",
      "display" : "正雅藥局"
    },
    {
      "code" : "5931081547",
      "display" : "信義健保藥局"
    },
    {
      "code" : "5931081556",
      "display" : "易加藥局"
    },
    {
      "code" : "5931081565",
      "display" : "鶯歌藥局"
    },
    {
      "code" : "5931081574",
      "display" : "摩馬藥局"
    },
    {
      "code" : "5931081583",
      "display" : "鎮安易加藥局"
    },
    {
      "code" : "5931081592",
      "display" : "康是美鶯歌藥局"
    },
    {
      "code" : "5931081609",
      "display" : "康是美鶯歌藥局"
    },
    {
      "code" : "5931081618",
      "display" : "美運寶中西藥局"
    },
    {
      "code" : "5931081627",
      "display" : "康是美鶯歌藥局"
    },
    {
      "code" : "5931081636",
      "display" : "擇木良食藥局"
    },
    {
      "code" : "5931081654",
      "display" : "政新藥局"
    },
    {
      "code" : "5931081663",
      "display" : "南鶯藥局"
    },
    {
      "code" : "5931090082",
      "display" : "恆豐藥局"
    },
    {
      "code" : "5931090117",
      "display" : "大和藥局"
    },
    {
      "code" : "5931090180",
      "display" : "人來安藥局"
    },
    {
      "code" : "5931090279",
      "display" : "勝全藥局"
    },
    {
      "code" : "5931091374",
      "display" : "全球藥師藥局"
    },
    {
      "code" : "5931091427",
      "display" : "康美藥局"
    },
    {
      "code" : "5931091481",
      "display" : "盛加藥局"
    },
    {
      "code" : "5931091570",
      "display" : "三恩藥局"
    },
    {
      "code" : "5931091605",
      "display" : "三峽文化藥局"
    },
    {
      "code" : "5931091623",
      "display" : "兆康藥局"
    },
    {
      "code" : "5931091641",
      "display" : "北大藥局"
    },
    {
      "code" : "5931091678",
      "display" : "如音藥局"
    },
    {
      "code" : "5931091696",
      "display" : "祥祐藥局"
    },
    {
      "code" : "5931091712",
      "display" : "誠祐藥局"
    },
    {
      "code" : "5931091810",
      "display" : "誠美藥局"
    },
    {
      "code" : "5931091829",
      "display" : "有新藥局"
    },
    {
      "code" : "5931091856",
      "display" : "大家好學成藥局"
    },
    {
      "code" : "5931091865",
      "display" : "大新藥局"
    },
    {
      "code" : "5931091874",
      "display" : "盛台藥局"
    },
    {
      "code" : "5931091892",
      "display" : "三峽藥局"
    },
    {
      "code" : "5931091909",
      "display" : "盛禾藥局"
    },
    {
      "code" : "5931091972",
      "display" : "三峽大昌藥局"
    },
    {
      "code" : "5931091990",
      "display" : "欣美大藥局"
    },
    {
      "code" : "5931092022",
      "display" : "瑞達美藥局"
    },
    {
      "code" : "5931092040",
      "display" : "一大藥局"
    },
    {
      "code" : "5931092059",
      "display" : "三峽啄木鳥藥局"
    },
    {
      "code" : "5931092068",
      "display" : "益銘藥師藥局"
    },
    {
      "code" : "5931092095",
      "display" : "禾雅藥局"
    },
    {
      "code" : "5931092102",
      "display" : "升威藥局"
    },
    {
      "code" : "5931092111",
      "display" : "立雅藥局"
    },
    {
      "code" : "5931092120",
      "display" : "進安大藥局"
    },
    {
      "code" : "5931092139",
      "display" : "悅兒藥局"
    },
    {
      "code" : "5931092148",
      "display" : "愛美膚醫美藥局"
    },
    {
      "code" : "5931092157",
      "display" : "三峽立安藥局"
    },
    {
      "code" : "5931092166",
      "display" : "欣德北大藥局"
    },
    {
      "code" : "5931092175",
      "display" : "弘宇藥局"
    },
    {
      "code" : "5931092184",
      "display" : "福澤清福藥局"
    },
    {
      "code" : "5931092193",
      "display" : "凡禾藥局"
    },
    {
      "code" : "5931092200",
      "display" : "金美藥局"
    },
    {
      "code" : "5931092219",
      "display" : "北大藥局"
    },
    {
      "code" : "5931092228",
      "display" : "弘宇藥局"
    },
    {
      "code" : "5931092237",
      "display" : "盛田健保藥局"
    },
    {
      "code" : "5931092246",
      "display" : "欣德北大藥局"
    },
    {
      "code" : "5931092255",
      "display" : "三峽啄木鳥藥局"
    },
    {
      "code" : "5931092264",
      "display" : "躍獅佳益藥局"
    },
    {
      "code" : "5931092273",
      "display" : "瑞達美大同藥局"
    },
    {
      "code" : "5931092282",
      "display" : "康是美湧峽藥局"
    },
    {
      "code" : "5931092291",
      "display" : "桔子藥局"
    },
    {
      "code" : "5931092308",
      "display" : "瑞達美大銅藥局"
    },
    {
      "code" : "5931092317",
      "display" : "沛桐健康藥局"
    },
    {
      "code" : "5931092326",
      "display" : "佑全三峽大觀藥局"
    },
    {
      "code" : "5931092335",
      "display" : "三峽啄木鳥藥局"
    },
    {
      "code" : "5931092344",
      "display" : "芯安藥局"
    },
    {
      "code" : "5931092353",
      "display" : "佑全三峽大觀藥局"
    },
    {
      "code" : "5931092362",
      "display" : "福澤清福藥局"
    },
    {
      "code" : "5931092371",
      "display" : "康是美湧峽藥局"
    },
    {
      "code" : "5931092380",
      "display" : "芯安藥局"
    },
    {
      "code" : "5931092399",
      "display" : "聯心藥局"
    },
    {
      "code" : "5931092406",
      "display" : "弘宇藥局"
    },
    {
      "code" : "5931100047",
      "display" : "松和大藥局"
    },
    {
      "code" : "5931100074",
      "display" : "邱藥局"
    },
    {
      "code" : "5931100092",
      "display" : "上全藥局"
    },
    {
      "code" : "5931100154",
      "display" : "尚運藥局"
    },
    {
      "code" : "5931100163",
      "display" : "昇運藥局"
    },
    {
      "code" : "5931100270",
      "display" : "千代田藥局"
    },
    {
      "code" : "5931100305",
      "display" : "璉恩藥局"
    },
    {
      "code" : "5931101419",
      "display" : "淡水聯合藥局"
    },
    {
      "code" : "5931101464",
      "display" : "伯聯藥局"
    },
    {
      "code" : "5931101599",
      "display" : "聖元社區藥局"
    },
    {
      "code" : "5931101615",
      "display" : "大忠聯合藥局"
    },
    {
      "code" : "5931101624",
      "display" : "北新藥局"
    },
    {
      "code" : "5931101633",
      "display" : "吉利安健保藥師藥局"
    },
    {
      "code" : "5931101642",
      "display" : "吳光祥藥局"
    },
    {
      "code" : "5931101651",
      "display" : "天文大藥局"
    },
    {
      "code" : "5931101668",
      "display" : "長佑藥局"
    },
    {
      "code" : "5931101704",
      "display" : "聖天藥局"
    },
    {
      "code" : "5931101919",
      "display" : "優德仕藥局"
    },
    {
      "code" : "5931101937",
      "display" : "文川藥局"
    },
    {
      "code" : "5931101955",
      "display" : "伯宇藥局"
    },
    {
      "code" : "5931101973",
      "display" : "良順藥局"
    },
    {
      "code" : "5931102078",
      "display" : "躍獅竹圍藥局"
    },
    {
      "code" : "5931102087",
      "display" : "匯民藥局"
    },
    {
      "code" : "5931102103",
      "display" : "四季寶健保藥局"
    },
    {
      "code" : "5931102121",
      "display" : "淡海藥師藥局"
    },
    {
      "code" : "5931102176",
      "display" : "淡水健康人生藥局"
    },
    {
      "code" : "5931102229",
      "display" : "貝比爾藥局"
    },
    {
      "code" : "5931102265",
      "display" : "佳藥長照藥局"
    },
    {
      "code" : "5931102292",
      "display" : "佑全淡水淡金藥局"
    },
    {
      "code" : "5931102309",
      "display" : "憲立藥局"
    },
    {
      "code" : "5931102336",
      "display" : "淡大郭藥局"
    },
    {
      "code" : "5931102354",
      "display" : "天康大藥局"
    },
    {
      "code" : "5931102372",
      "display" : "日揚藥局"
    },
    {
      "code" : "5931102407",
      "display" : "躍獅淡水長照藥局"
    },
    {
      "code" : "5931102425",
      "display" : "日森人文藥局淡海店"
    },
    {
      "code" : "5931102434",
      "display" : "西雅圖聯合藥局"
    },
    {
      "code" : "5931102443",
      "display" : "淡水春天生活藥局"
    },
    {
      "code" : "5931102452",
      "display" : "池慶藥局"
    },
    {
      "code" : "5931102461",
      "display" : "淡水藥局"
    },
    {
      "code" : "5931102470",
      "display" : "躍獅台北灣藥局"
    },
    {
      "code" : "5931102489",
      "display" : "水源藥局"
    },
    {
      "code" : "5931102498",
      "display" : "池佑藥局"
    },
    {
      "code" : "5931102505",
      "display" : "躍獅沙崙藥局"
    },
    {
      "code" : "5931102514",
      "display" : "淡水春天生活藥局"
    },
    {
      "code" : "5931102523",
      "display" : "佑全淡水新市一藥局"
    },
    {
      "code" : "5931102532",
      "display" : "貝比爾藥局"
    },
    {
      "code" : "5931102541",
      "display" : "躍獅台北灣藥局"
    },
    {
      "code" : "5931102550",
      "display" : "躍獅新民藥局"
    },
    {
      "code" : "5931102569",
      "display" : "躍獅沙崙中西藥局"
    },
    {
      "code" : "5931102578",
      "display" : "躍獅淡水長照藥局"
    },
    {
      "code" : "5931102587",
      "display" : "宸星藥局"
    },
    {
      "code" : "5931102596",
      "display" : "上全藥局"
    },
    {
      "code" : "5931102603",
      "display" : "天康大藥局"
    },
    {
      "code" : "5931102630",
      "display" : "池佑藥局"
    },
    {
      "code" : "5931102649",
      "display" : "新一藥局"
    },
    {
      "code" : "5931102658",
      "display" : "佑全淡水新市一藥局"
    },
    {
      "code" : "5931102667",
      "display" : "水源藥局"
    },
    {
      "code" : "5931102676",
      "display" : "杏一淡水中山藥局"
    },
    {
      "code" : "5931102685",
      "display" : "淡水藥局"
    },
    {
      "code" : "5931102694",
      "display" : "佑全淡水淡金藥局"
    },
    {
      "code" : "5931102701",
      "display" : "清水春天藥局"
    },
    {
      "code" : "5931102710",
      "display" : "天康大藥局"
    },
    {
      "code" : "5931102729",
      "display" : "民權藥局"
    },
    {
      "code" : "5931102738",
      "display" : "十二願珝藥局"
    },
    {
      "code" : "5931102747",
      "display" : "昱承藥局"
    },
    {
      "code" : "5931102756",
      "display" : "清水春天藥局"
    },
    {
      "code" : "5931102765",
      "display" : "池佑藥局"
    },
    {
      "code" : "5931102774",
      "display" : "貝比爾藥局"
    },
    {
      "code" : "5931102783",
      "display" : "十二願珝藥局"
    },
    {
      "code" : "5931102792",
      "display" : "新春藥局"
    },
    {
      "code" : "5931110025",
      "display" : "巧能藥局"
    },
    {
      "code" : "5931110034",
      "display" : "麒豐藥局"
    },
    {
      "code" : "5931110070",
      "display" : "德昌藥局"
    },
    {
      "code" : "5931110114",
      "display" : "必進藥局"
    },
    {
      "code" : "5931110258",
      "display" : "春德堂藥局"
    },
    {
      "code" : "5931111540",
      "display" : "再興藥局"
    },
    {
      "code" : "5931111568",
      "display" : "湖前中西藥局"
    },
    {
      "code" : "5931111586",
      "display" : "品康藥局"
    },
    {
      "code" : "5931111602",
      "display" : "汐止中西大藥局"
    },
    {
      "code" : "5931111611",
      "display" : "向日葵藥局"
    },
    {
      "code" : "5931111719",
      "display" : "青苗藥局"
    },
    {
      "code" : "5931111737",
      "display" : "廣誠藥師藥局"
    },
    {
      "code" : "5931111755",
      "display" : "幸福藥局"
    },
    {
      "code" : "5931111773",
      "display" : "江北藥局"
    },
    {
      "code" : "5931111835",
      "display" : "全家藥局"
    },
    {
      "code" : "5931111844",
      "display" : "福恩藥師大藥局"
    },
    {
      "code" : "5931111915",
      "display" : "康元中西綜合藥局"
    },
    {
      "code" : "5931111951",
      "display" : "我家藥局"
    },
    {
      "code" : "5931111988",
      "display" : "滿益藥局"
    },
    {
      "code" : "5931112047",
      "display" : "吉安康健保藥師藥局"
    },
    {
      "code" : "5931112083",
      "display" : "裕和藥局"
    },
    {
      "code" : "5931112136",
      "display" : "汐芷藥局"
    },
    {
      "code" : "5931112145",
      "display" : "汐止健康人生藥局"
    },
    {
      "code" : "5931112225",
      "display" : "杏恩健保藥局"
    },
    {
      "code" : "5931112234",
      "display" : "安泰藥局"
    },
    {
      "code" : "5931112270",
      "display" : "汐心藥局"
    },
    {
      "code" : "5931112314",
      "display" : "杏光藥局"
    },
    {
      "code" : "5931112341",
      "display" : "躍獅尚揚藥局"
    },
    {
      "code" : "5931112369",
      "display" : "汐止立欣藥局"
    },
    {
      "code" : "5931112378",
      "display" : "翔云大藥局"
    },
    {
      "code" : "5931112430",
      "display" : "忠孝藥局"
    },
    {
      "code" : "5931112494",
      "display" : "長頸鹿藥局"
    },
    {
      "code" : "5931112510",
      "display" : "汐興藥局"
    },
    {
      "code" : "5931112636",
      "display" : "佳恩藥局"
    },
    {
      "code" : "5931112645",
      "display" : "健成藥局"
    },
    {
      "code" : "5931112690",
      "display" : "國升藥局"
    },
    {
      "code" : "5931112716",
      "display" : "福多藥局"
    },
    {
      "code" : "5931112789",
      "display" : "富康東科藥局"
    },
    {
      "code" : "5931112798",
      "display" : "益嘉藥局"
    },
    {
      "code" : "5931112832",
      "display" : "安忻藥局"
    },
    {
      "code" : "5931112912",
      "display" : "富康藥局"
    },
    {
      "code" : "5931112921",
      "display" : "明恩藥局"
    },
    {
      "code" : "5931112958",
      "display" : "快樂藥局汐止店"
    },
    {
      "code" : "5931112976",
      "display" : "永康中西綜合藥局"
    },
    {
      "code" : "5931112994",
      "display" : "汐止藥局"
    },
    {
      "code" : "5931113053",
      "display" : "建忠藥局"
    },
    {
      "code" : "5931113062",
      "display" : "健康晨光藥局"
    },
    {
      "code" : "5931113071",
      "display" : "蒲公英藥局"
    },
    {
      "code" : "5931113080",
      "display" : "宗齡藥局"
    },
    {
      "code" : "5931113106",
      "display" : "穎又安中西藥局"
    },
    {
      "code" : "5931113115",
      "display" : "躍獅大同藥局"
    },
    {
      "code" : "5931113124",
      "display" : "弘恩藥局"
    },
    {
      "code" : "5931113133",
      "display" : "祐欣藥局"
    },
    {
      "code" : "5931113142",
      "display" : "林美藥局"
    },
    {
      "code" : "5931113160",
      "display" : "社后藥局"
    },
    {
      "code" : "5931113179",
      "display" : "富康活力中興藥局"
    },
    {
      "code" : "5931113188",
      "display" : "汐止藥局"
    },
    {
      "code" : "5931113197",
      "display" : "博昱忠孝藥局"
    },
    {
      "code" : "5931113204",
      "display" : "富康活力忠孝藥局"
    },
    {
      "code" : "5931113213",
      "display" : "博昱忠孝藥局"
    },
    {
      "code" : "5931113222",
      "display" : "富康活力新欣藥局"
    },
    {
      "code" : "5931113240",
      "display" : "新昌藥局"
    },
    {
      "code" : "5931113259",
      "display" : "日建藥局"
    },
    {
      "code" : "5931113268",
      "display" : "佑全汐止康寧藥局"
    },
    {
      "code" : "5931113277",
      "display" : "永興藥局"
    },
    {
      "code" : "5931113286",
      "display" : "康是美北峰藥局"
    },
    {
      "code" : "5931113320",
      "display" : "杏一汐止忠孝藥局"
    },
    {
      "code" : "5931113339",
      "display" : "富康活力樟樹藥局"
    },
    {
      "code" : "5931113348",
      "display" : "富康活力中興藥局"
    },
    {
      "code" : "5931113357",
      "display" : "麒豐藥局"
    },
    {
      "code" : "5931113366",
      "display" : "忠孝藥局"
    },
    {
      "code" : "5931113375",
      "display" : "日建藥局"
    },
    {
      "code" : "5931113384",
      "display" : "永興藥局"
    },
    {
      "code" : "5931120049",
      "display" : "本平藥局"
    },
    {
      "code" : "5931120156",
      "display" : "瑞聯藥局"
    },
    {
      "code" : "5931121242",
      "display" : "崇德藥局"
    },
    {
      "code" : "5931121279",
      "display" : "大埔藥局"
    },
    {
      "code" : "5931121297",
      "display" : "瑞芳東亞大藥局"
    },
    {
      "code" : "5931121304",
      "display" : "竟安藥局"
    },
    {
      "code" : "5931121377",
      "display" : "瑞中藥局"
    },
    {
      "code" : "5931121386",
      "display" : "瑞光藥局"
    },
    {
      "code" : "5931121402",
      "display" : "瑞慶藥局"
    },
    {
      "code" : "5931121411",
      "display" : "長興堂藥局"
    },
    {
      "code" : "5931121420",
      "display" : "永展藥局"
    },
    {
      "code" : "5931121448",
      "display" : "伊達藥局"
    },
    {
      "code" : "5931121466",
      "display" : "瑞芳藥局"
    },
    {
      "code" : "5931121475",
      "display" : "瑞金藥局"
    },
    {
      "code" : "5931121484",
      "display" : "瑞芳藥局"
    },
    {
      "code" : "5931121493",
      "display" : "瑞慶藥局"
    },
    {
      "code" : "5931121500",
      "display" : "富康活力瑞方藥局"
    },
    {
      "code" : "5931121519",
      "display" : "本平藥局"
    },
    {
      "code" : "5931121528",
      "display" : "瑞芳藥局"
    },
    {
      "code" : "5931121537",
      "display" : "富康活力瑞方藥局"
    },
    {
      "code" : "5931121546",
      "display" : "瑞芳藥局"
    },
    {
      "code" : "5931121555",
      "display" : "瑞芳東亞大藥局"
    },
    {
      "code" : "5931130152",
      "display" : "博惠藥局"
    },
    {
      "code" : "5931130205",
      "display" : "瑞益藥局"
    },
    {
      "code" : "5931130214",
      "display" : "崇愛藥局"
    },
    {
      "code" : "5931130223",
      "display" : "久達藥局"
    },
    {
      "code" : "5931130241",
      "display" : "協成藥局"
    },
    {
      "code" : "5931130349",
      "display" : "祥發藥局"
    },
    {
      "code" : "5931130358",
      "display" : "盛安大藥局"
    },
    {
      "code" : "5931130394",
      "display" : "一和藥局"
    },
    {
      "code" : "5931130438",
      "display" : "正仁藥局"
    },
    {
      "code" : "5931130483",
      "display" : "學安藥師藥局"
    },
    {
      "code" : "5931130545",
      "display" : "恒生中西藥局"
    },
    {
      "code" : "5931131579",
      "display" : "祥安大藥局"
    },
    {
      "code" : "5931131800",
      "display" : "立康藥局"
    },
    {
      "code" : "5931131828",
      "display" : "咸安藥局"
    },
    {
      "code" : "5931131864",
      "display" : "學府實和藥局"
    },
    {
      "code" : "5931131882",
      "display" : "裕達藥局"
    },
    {
      "code" : "5931131908",
      "display" : "璨鴻藥局"
    },
    {
      "code" : "5931132110",
      "display" : "元崇藥局"
    },
    {
      "code" : "5931132138",
      "display" : "心中外藥局"
    },
    {
      "code" : "5931132165",
      "display" : "佳佳藥局"
    },
    {
      "code" : "5931132183",
      "display" : "尚安藥師藥局"
    },
    {
      "code" : "5931132236",
      "display" : "善淳藥師藥局"
    },
    {
      "code" : "5931132245",
      "display" : "萬昌健保藥局"
    },
    {
      "code" : "5931132263",
      "display" : "立新藥局"
    },
    {
      "code" : "5931132272",
      "display" : "富柏大藥局"
    },
    {
      "code" : "5931132307",
      "display" : "廣昇健保藥師藥局"
    },
    {
      "code" : "5931132343",
      "display" : "誠安藥局"
    },
    {
      "code" : "5931132389",
      "display" : "凱一藥局"
    },
    {
      "code" : "5931132405",
      "display" : "小倉藥局"
    },
    {
      "code" : "5931132487",
      "display" : "鄭家藥局"
    },
    {
      "code" : "5931132496",
      "display" : "惠蒼藥局"
    },
    {
      "code" : "5931132538",
      "display" : "宏奇藥局"
    },
    {
      "code" : "5931132576",
      "display" : "佑安藥局"
    },
    {
      "code" : "5931132594",
      "display" : "元蒼藥局"
    },
    {
      "code" : "5931132601",
      "display" : "吉城大藥局"
    },
    {
      "code" : "5931132610",
      "display" : "久安藥局"
    },
    {
      "code" : "5931132629",
      "display" : "育佳藥局"
    },
    {
      "code" : "5931132647",
      "display" : "舒民藥局"
    },
    {
      "code" : "5931132683",
      "display" : "家庭藥師連鎖藥局"
    },
    {
      "code" : "5931132727",
      "display" : "順儷藥師藥局"
    },
    {
      "code" : "5931132736",
      "display" : "大眾藥局"
    },
    {
      "code" : "5931132781",
      "display" : "德隆藥局"
    },
    {
      "code" : "5931132807",
      "display" : "健業藥局"
    },
    {
      "code" : "5931132816",
      "display" : "大康藥局"
    },
    {
      "code" : "5931132852",
      "display" : "佳霖藥局"
    },
    {
      "code" : "5931132870",
      "display" : "健群藥局"
    },
    {
      "code" : "5931132914",
      "display" : "健鼎藥局"
    },
    {
      "code" : "5931132932",
      "display" : "全家健康藥局"
    },
    {
      "code" : "5931132950",
      "display" : "美康藥妝藥局"
    },
    {
      "code" : "5931133019",
      "display" : "學府松藥局"
    },
    {
      "code" : "5931133037",
      "display" : "國安健保藥局"
    },
    {
      "code" : "5931133046",
      "display" : "大業藥局"
    },
    {
      "code" : "5931133064",
      "display" : "城康藥局"
    },
    {
      "code" : "5931133108",
      "display" : "三豐藥局"
    },
    {
      "code" : "5931133126",
      "display" : "成康藥局"
    },
    {
      "code" : "5931133135",
      "display" : "順儷明德藥局"
    },
    {
      "code" : "5931133171",
      "display" : "誠恩藥局"
    },
    {
      "code" : "5931133199",
      "display" : "陽光活力藥局"
    },
    {
      "code" : "5931133206",
      "display" : "樂利藥局"
    },
    {
      "code" : "5931133331",
      "display" : "城安大藥局"
    },
    {
      "code" : "5931133340",
      "display" : "大欣藥局"
    },
    {
      "code" : "5931133359",
      "display" : "麗膚藥局"
    },
    {
      "code" : "5931133395",
      "display" : "順儷金城藥局"
    },
    {
      "code" : "5931133439",
      "display" : "志仁藥局"
    },
    {
      "code" : "5931133457",
      "display" : "博盛健保藥局"
    },
    {
      "code" : "5931133500",
      "display" : "菩提藥局"
    },
    {
      "code" : "5931133519",
      "display" : "埔銓藥局"
    },
    {
      "code" : "5931133537",
      "display" : "裕生藥局"
    },
    {
      "code" : "5931133546",
      "display" : "宏林保健藥局"
    },
    {
      "code" : "5931133555",
      "display" : "活力藥局"
    },
    {
      "code" : "5931133564",
      "display" : "城恩藥局"
    },
    {
      "code" : "5931133582",
      "display" : "一心藥局"
    },
    {
      "code" : "5931133591",
      "display" : "土城人藥局"
    },
    {
      "code" : "5931133608",
      "display" : "土城金城藥局"
    },
    {
      "code" : "5931133617",
      "display" : "芮櫟頂埔大藥局"
    },
    {
      "code" : "5931133626",
      "display" : "優嘉藥師連鎖藥局"
    },
    {
      "code" : "5931133635",
      "display" : "順儷學府藥局"
    },
    {
      "code" : "5931133644",
      "display" : "貓頭鷹藥妝藥局"
    },
    {
      "code" : "5931133653",
      "display" : "家泰藥局"
    },
    {
      "code" : "5931133662",
      "display" : "中央藥局"
    },
    {
      "code" : "5931133671",
      "display" : "升立藥局"
    },
    {
      "code" : "5931133680",
      "display" : "土城金城藥局"
    },
    {
      "code" : "5931133699",
      "display" : "順儷明德藥局"
    },
    {
      "code" : "5931133706",
      "display" : "中央藥局"
    },
    {
      "code" : "5931133715",
      "display" : "瑞益藥局"
    },
    {
      "code" : "5931133724",
      "display" : "活力藥局"
    },
    {
      "code" : "5931133733",
      "display" : "康是美城美藥局"
    },
    {
      "code" : "5931133742",
      "display" : "順儷藥師藥局"
    },
    {
      "code" : "5931133751",
      "display" : "城康藥局"
    },
    {
      "code" : "5931133760",
      "display" : "健鼎藥局"
    },
    {
      "code" : "5931133779",
      "display" : "土城人藥局"
    },
    {
      "code" : "5931133788",
      "display" : "順儷明德藥局"
    },
    {
      "code" : "5931133797",
      "display" : "欣珉藥局"
    },
    {
      "code" : "5931133804",
      "display" : "郝藥局"
    },
    {
      "code" : "5931133813",
      "display" : "廣一藥局"
    },
    {
      "code" : "5931133822",
      "display" : "順儷學府藥局"
    },
    {
      "code" : "5931133831",
      "display" : "芮櫟土醫大藥局"
    },
    {
      "code" : "5931133840",
      "display" : "麗膚藥局"
    },
    {
      "code" : "5931133859",
      "display" : "躍獅祥龍藥局"
    },
    {
      "code" : "5931133868",
      "display" : "心願藥局"
    },
    {
      "code" : "5931133877",
      "display" : "天明熊麻吉中西藥局"
    },
    {
      "code" : "5931133895",
      "display" : "美康金城藥局"
    },
    {
      "code" : "5931133902",
      "display" : "順儷明德藥局"
    },
    {
      "code" : "5931133911",
      "display" : "順儷學府藥局"
    },
    {
      "code" : "5931133920",
      "display" : "和欣健保藥局"
    },
    {
      "code" : "5931133948",
      "display" : "躍獅佳信藥局"
    },
    {
      "code" : "5931133957",
      "display" : "維力健保藥局"
    },
    {
      "code" : "5931133966",
      "display" : "中央藥局"
    },
    {
      "code" : "5931133975",
      "display" : "舒民藥局"
    },
    {
      "code" : "5931133984",
      "display" : "誠恩藥局"
    },
    {
      "code" : "5931133993",
      "display" : "土城耀勝藥局"
    },
    {
      "code" : "5931134007",
      "display" : "美康中央藥局"
    },
    {
      "code" : "5931134016",
      "display" : "博盛健保藥局"
    },
    {
      "code" : "5931134025",
      "display" : "佳佳藥局"
    },
    {
      "code" : "5931134034",
      "display" : "土城中央藥局"
    },
    {
      "code" : "5931134043",
      "display" : "佳佳藥局"
    },
    {
      "code" : "5931134052",
      "display" : "土城耀勝藥局"
    },
    {
      "code" : "5931134070",
      "display" : "土城耀勝藥局"
    },
    {
      "code" : "5931140096",
      "display" : "華信藥局"
    },
    {
      "code" : "5931140112",
      "display" : "施藥局"
    },
    {
      "code" : "5931140121",
      "display" : "大政藥局"
    },
    {
      "code" : "5931140130",
      "display" : "欣泰藥局"
    },
    {
      "code" : "5931140158",
      "display" : "全民藥局"
    },
    {
      "code" : "5931140201",
      "display" : "理方藥局"
    },
    {
      "code" : "5931140229",
      "display" : "天士藥局"
    },
    {
      "code" : "5931140238",
      "display" : "謚安中西藥局"
    },
    {
      "code" : "5931140318",
      "display" : "慧安藥局"
    },
    {
      "code" : "5931140372",
      "display" : "上群藥師藥局"
    },
    {
      "code" : "5931140416",
      "display" : "松伯藥局"
    },
    {
      "code" : "5931141502",
      "display" : "蘆洲陳大藥局"
    },
    {
      "code" : "5931141520",
      "display" : "長安藥局"
    },
    {
      "code" : "5931141557",
      "display" : "龍成藥局"
    },
    {
      "code" : "5931141637",
      "display" : "華興藥師藥局"
    },
    {
      "code" : "5931141708",
      "display" : "保成藥局"
    },
    {
      "code" : "5931141726",
      "display" : "松展多利日式連鎖藥粧藥局"
    },
    {
      "code" : "5931141744",
      "display" : "慶明藥局"
    },
    {
      "code" : "5931141799",
      "display" : "群欣藥局"
    },
    {
      "code" : "5931141860",
      "display" : "北聯藥局"
    },
    {
      "code" : "5931141904",
      "display" : "杏昌藥局"
    },
    {
      "code" : "5931141913",
      "display" : "隆生藥局"
    },
    {
      "code" : "5931141922",
      "display" : "和泰藥師藥局"
    },
    {
      "code" : "5931141959",
      "display" : "長榮大藥局"
    },
    {
      "code" : "5931141986",
      "display" : "全佑藥局"
    },
    {
      "code" : "5931142018",
      "display" : "福您安中西藥局"
    },
    {
      "code" : "5931142072",
      "display" : "達特藥局"
    },
    {
      "code" : "5931142081",
      "display" : "威仕康藥局"
    },
    {
      "code" : "5931142090",
      "display" : "泰明藥局"
    },
    {
      "code" : "5931142116",
      "display" : "龍安藥局"
    },
    {
      "code" : "5931142161",
      "display" : "廷升藥局"
    },
    {
      "code" : "5931142241",
      "display" : "永恩健康藥局"
    },
    {
      "code" : "5931142296",
      "display" : "蓁美健康藥局"
    },
    {
      "code" : "5931142303",
      "display" : "康群生活藥局"
    },
    {
      "code" : "5931142367",
      "display" : "蘋果藥妝藥局"
    },
    {
      "code" : "5931142394",
      "display" : "常喜藥局"
    },
    {
      "code" : "5931142429",
      "display" : "世全藥局"
    },
    {
      "code" : "5931142447",
      "display" : "三鐵藥局"
    },
    {
      "code" : "5931142509",
      "display" : "萊康連鎖藥局"
    },
    {
      "code" : "5931142554",
      "display" : "宏祐藥局"
    },
    {
      "code" : "5931142572",
      "display" : "幸安藥局"
    },
    {
      "code" : "5931142634",
      "display" : "華安大藥局"
    },
    {
      "code" : "5931142643",
      "display" : "知達健保藥局"
    },
    {
      "code" : "5931142670",
      "display" : "陽光幸福藥局"
    },
    {
      "code" : "5931142723",
      "display" : "健群藥局"
    },
    {
      "code" : "5931142778",
      "display" : "芯聯藥局"
    },
    {
      "code" : "5931142796",
      "display" : "乙安藥局"
    },
    {
      "code" : "5931142849",
      "display" : "康泉藥師藥局"
    },
    {
      "code" : "5931142858",
      "display" : "愛佳健保藥局"
    },
    {
      "code" : "5931142901",
      "display" : "快樂藥局長榮店"
    },
    {
      "code" : "5931142983",
      "display" : "健安健保藥局"
    },
    {
      "code" : "5931143015",
      "display" : "喜健康藥局"
    },
    {
      "code" : "5931143033",
      "display" : "微笑杏鄰藥局"
    },
    {
      "code" : "5931143051",
      "display" : "萊康中華健保藥局"
    },
    {
      "code" : "5931143060",
      "display" : "美林藥局"
    },
    {
      "code" : "5931143088",
      "display" : "躍獅蘆洲藥局"
    },
    {
      "code" : "5931143104",
      "display" : "新信義藥局"
    },
    {
      "code" : "5931143113",
      "display" : "喜得健藥局"
    },
    {
      "code" : "5931143131",
      "display" : "杏一蘆洲長安藥局"
    },
    {
      "code" : "5931143186",
      "display" : "柏康藥局"
    },
    {
      "code" : "5931143195",
      "display" : "吉安藥局"
    },
    {
      "code" : "5931143202",
      "display" : "蘆洲丁丁藥局"
    },
    {
      "code" : "5931143211",
      "display" : "樂開懷健保藥局"
    },
    {
      "code" : "5931143248",
      "display" : "原子藥局"
    },
    {
      "code" : "5931143257",
      "display" : "德康藥局"
    },
    {
      "code" : "5931143266",
      "display" : "中美永結藥局"
    },
    {
      "code" : "5931143275",
      "display" : "集賢藥局"
    },
    {
      "code" : "5931143284",
      "display" : "宥安藥局"
    },
    {
      "code" : "5931143300",
      "display" : "大樹蘆洲藥局"
    },
    {
      "code" : "5931143319",
      "display" : "大樹長榮藥局"
    },
    {
      "code" : "5931143328",
      "display" : "全家藥粧藥局"
    },
    {
      "code" : "5931143337",
      "display" : "喜得健藥局"
    },
    {
      "code" : "5931143346",
      "display" : "蘆洲心心藥局"
    },
    {
      "code" : "5931143355",
      "display" : "昭陽藥局"
    },
    {
      "code" : "5931143364",
      "display" : "光禾藥局"
    },
    {
      "code" : "5931143382",
      "display" : "大樹蘆洲藥局"
    },
    {
      "code" : "5931143391",
      "display" : "集賢藥局"
    },
    {
      "code" : "5931143408",
      "display" : "杏一蘆洲長安藥局"
    },
    {
      "code" : "5931143417",
      "display" : "集賢藥局"
    },
    {
      "code" : "5931143426",
      "display" : "新資生長安大藥局"
    },
    {
      "code" : "5931143435",
      "display" : "杏一蘆洲長安藥局"
    },
    {
      "code" : "5931143453",
      "display" : "杏一蘆洲長安藥局"
    },
    {
      "code" : "5931143462",
      "display" : "康是美得勝藥局"
    },
    {
      "code" : "5931143471",
      "display" : "大樹長榮藥局"
    },
    {
      "code" : "5931143480",
      "display" : "蘆洲心心藥局"
    },
    {
      "code" : "5931143499",
      "display" : "美林藥局"
    },
    {
      "code" : "5931143506",
      "display" : "中華春天藥局"
    },
    {
      "code" : "5931143515",
      "display" : "永印中西健保藥局"
    },
    {
      "code" : "5931143533",
      "display" : "九芎藥局"
    },
    {
      "code" : "5931143542",
      "display" : "大樹蘆洲藥局"
    },
    {
      "code" : "5931143551",
      "display" : "原子藥局"
    },
    {
      "code" : "5931143560",
      "display" : "全家藥粧藥局"
    },
    {
      "code" : "5931143579",
      "display" : "美康蘆洲藥局"
    },
    {
      "code" : "5931143588",
      "display" : "蘆洲心心藥局"
    },
    {
      "code" : "5931143597",
      "display" : "大樹長榮藥局"
    },
    {
      "code" : "5931143604",
      "display" : "集賢藥局"
    },
    {
      "code" : "5931143613",
      "display" : "喜得健藥局"
    },
    {
      "code" : "5931143631",
      "display" : "杏一蘆洲長安藥局"
    },
    {
      "code" : "5931143640",
      "display" : "和泰藥師藥局"
    },
    {
      "code" : "5931150056",
      "display" : "常安藥局"
    },
    {
      "code" : "5931150065",
      "display" : "成泰藥局"
    },
    {
      "code" : "5931150163",
      "display" : "德泰藥局"
    },
    {
      "code" : "5931151231",
      "display" : "五股聯成藥局"
    },
    {
      "code" : "5931151277",
      "display" : "永任藥局"
    },
    {
      "code" : "5931151295",
      "display" : "凌雲藥局"
    },
    {
      "code" : "5931151302",
      "display" : "宏安藥局"
    },
    {
      "code" : "5931151311",
      "display" : "信恆藥局"
    },
    {
      "code" : "5931151437",
      "display" : "虹元藥局"
    },
    {
      "code" : "5931151473",
      "display" : "百成中西藥師藥局"
    },
    {
      "code" : "5931151482",
      "display" : "源昇藥局"
    },
    {
      "code" : "5931151491",
      "display" : "杏軒藥局"
    },
    {
      "code" : "5931151508",
      "display" : "三合藥局"
    },
    {
      "code" : "5931151544",
      "display" : "三好連鎖藥師藥局"
    },
    {
      "code" : "5931151599",
      "display" : "闔安藥局"
    },
    {
      "code" : "5931151606",
      "display" : "陽光樂活藥局"
    },
    {
      "code" : "5931151615",
      "display" : "陽光健保藥局"
    },
    {
      "code" : "5931151660",
      "display" : "祐康藥師藥局"
    },
    {
      "code" : "5931151679",
      "display" : "東興藥局"
    },
    {
      "code" : "5931151688",
      "display" : "五股藥局"
    },
    {
      "code" : "5931151697",
      "display" : "水碓藥局"
    },
    {
      "code" : "5931151713",
      "display" : "五股藥局"
    },
    {
      "code" : "5931151722",
      "display" : "佑全五股新五藥局"
    },
    {
      "code" : "5931151731",
      "display" : "新橙藥局"
    },
    {
      "code" : "5931151740",
      "display" : "新橙藥局"
    },
    {
      "code" : "5931151759",
      "display" : "百成中西藥師藥局"
    },
    {
      "code" : "5931151768",
      "display" : "倍康藥局"
    },
    {
      "code" : "5931151777",
      "display" : "佑全五股新五藥局"
    },
    {
      "code" : "5931151786",
      "display" : "新橙藥局"
    },
    {
      "code" : "5931151795",
      "display" : "五股藥局"
    },
    {
      "code" : "5931151802",
      "display" : "倍康藥局"
    },
    {
      "code" : "5931151811",
      "display" : "新橙藥局"
    },
    {
      "code" : "5931151820",
      "display" : "常安藥局"
    },
    {
      "code" : "5931151848",
      "display" : "五股藥局"
    },
    {
      "code" : "5931151857",
      "display" : "陽光樂活藥局"
    },
    {
      "code" : "5931160105",
      "display" : "泰林中西藥局"
    },
    {
      "code" : "5931160132",
      "display" : "健康藥師藥局"
    },
    {
      "code" : "5931160141",
      "display" : "日泰藥局"
    },
    {
      "code" : "5931161282",
      "display" : "善耕藥局"
    },
    {
      "code" : "5931161326",
      "display" : "泰安藥局"
    },
    {
      "code" : "5931161344",
      "display" : "北安藥妝藥局"
    },
    {
      "code" : "5931161353",
      "display" : "台灣藥局"
    },
    {
      "code" : "5931161433",
      "display" : "仁安藥局"
    },
    {
      "code" : "5931161460",
      "display" : "紅葉藥局"
    },
    {
      "code" : "5931161488",
      "display" : "旭晨藥局"
    },
    {
      "code" : "5931161513",
      "display" : "苗園健保特約藥局"
    },
    {
      "code" : "5931161577",
      "display" : "立赫輔大藥局"
    },
    {
      "code" : "5931161595",
      "display" : "泰山藥局"
    },
    {
      "code" : "5931161602",
      "display" : "全成藥局"
    },
    {
      "code" : "5931161611",
      "display" : "安馨藥局"
    },
    {
      "code" : "5931161620",
      "display" : "華特藥局"
    },
    {
      "code" : "5931161639",
      "display" : "泰山藥局"
    },
    {
      "code" : "5931161648",
      "display" : "旭晨藥局"
    },
    {
      "code" : "5931161657",
      "display" : "楷心藥局"
    },
    {
      "code" : "5931161666",
      "display" : "明志藥局"
    },
    {
      "code" : "5931161675",
      "display" : "樂山藥局"
    },
    {
      "code" : "5931161684",
      "display" : "泰安藥局"
    },
    {
      "code" : "5931161693",
      "display" : "明志藥局"
    },
    {
      "code" : "5931161700",
      "display" : "同榮藥局"
    },
    {
      "code" : "5931161719",
      "display" : "安馨藥局"
    },
    {
      "code" : "5931161728",
      "display" : "泰山明志全球藥局"
    },
    {
      "code" : "5931161737",
      "display" : "明志藥局"
    },
    {
      "code" : "5931170012",
      "display" : "存明藥局"
    },
    {
      "code" : "5931170021",
      "display" : "士昌藥局"
    },
    {
      "code" : "5931170067",
      "display" : "宏宇藥局"
    },
    {
      "code" : "5931170129",
      "display" : "麗園藥局"
    },
    {
      "code" : "5931170165",
      "display" : "龍點藥局"
    },
    {
      "code" : "5931171233",
      "display" : "狀元葯師藥局"
    },
    {
      "code" : "5931171242",
      "display" : "旺林藥局"
    },
    {
      "code" : "5931171251",
      "display" : "喜樂藥師藥局"
    },
    {
      "code" : "5931171297",
      "display" : "安康藥局"
    },
    {
      "code" : "5931171313",
      "display" : "林口啄木鳥藥局"
    },
    {
      "code" : "5931171340",
      "display" : "家欣藥師藥局"
    },
    {
      "code" : "5931171411",
      "display" : "康旭藥局"
    },
    {
      "code" : "5931171528",
      "display" : "長康藥局"
    },
    {
      "code" : "5931171537",
      "display" : "茂晟藥局"
    },
    {
      "code" : "5931171546",
      "display" : "安禾藥局"
    },
    {
      "code" : "5931171564",
      "display" : "家弘藥局"
    },
    {
      "code" : "5931171573",
      "display" : "安心藥局"
    },
    {
      "code" : "5931171582",
      "display" : "綠園藥局"
    },
    {
      "code" : "5931171644",
      "display" : "蛋寶寶藥局"
    },
    {
      "code" : "5931171662",
      "display" : "大心藥局"
    },
    {
      "code" : "5931171671",
      "display" : "欣穎藥局"
    },
    {
      "code" : "5931171680",
      "display" : "一家好藥局"
    },
    {
      "code" : "5931171706",
      "display" : "榮新藥局"
    },
    {
      "code" : "5931171724",
      "display" : "林康藥局"
    },
    {
      "code" : "5931171733",
      "display" : "長欣藥局"
    },
    {
      "code" : "5931171742",
      "display" : "唯恩藥局"
    },
    {
      "code" : "5931171779",
      "display" : "全球忠孝藥局"
    },
    {
      "code" : "5931171788",
      "display" : "泰臨中西藥局"
    },
    {
      "code" : "5931171813",
      "display" : "力行藥局"
    },
    {
      "code" : "5931171822",
      "display" : "榮昌藥局"
    },
    {
      "code" : "5931171831",
      "display" : "沐霖藥局"
    },
    {
      "code" : "5931171859",
      "display" : "佳心藥局"
    },
    {
      "code" : "5931171868",
      "display" : "林口藥局"
    },
    {
      "code" : "5931171877",
      "display" : "杏一林口仁愛藥局"
    },
    {
      "code" : "5931171886",
      "display" : "林口辰安藥局"
    },
    {
      "code" : "5931171895",
      "display" : "奇異果三井藥局"
    },
    {
      "code" : "5931171902",
      "display" : "康是美三井藥局"
    },
    {
      "code" : "5931171911",
      "display" : "泰臨中西藥局"
    },
    {
      "code" : "5931171920",
      "display" : "法米健康藥局"
    },
    {
      "code" : "5931171939",
      "display" : "法米健康藥局"
    },
    {
      "code" : "5931171948",
      "display" : "安心藥局"
    },
    {
      "code" : "5931171957",
      "display" : "美得心藥局"
    },
    {
      "code" : "5931171966",
      "display" : "榮昌藥局"
    },
    {
      "code" : "5931171975",
      "display" : "躍獅華都藥局"
    },
    {
      "code" : "5931171984",
      "display" : "杏一林口仁愛藥局"
    },
    {
      "code" : "5931171993",
      "display" : "佑全林口中山藥局"
    },
    {
      "code" : "5931172007",
      "display" : "頤和中西藥局"
    },
    {
      "code" : "5931172016",
      "display" : "安心藥局"
    },
    {
      "code" : "5931172025",
      "display" : "晨熙藥師藥局"
    },
    {
      "code" : "5931172034",
      "display" : "安心藥局"
    },
    {
      "code" : "5931172052",
      "display" : "林口藥局"
    },
    {
      "code" : "5931172061",
      "display" : "康是美三井藥局"
    },
    {
      "code" : "5931172070",
      "display" : "沐霖藥局"
    },
    {
      "code" : "5931172089",
      "display" : "奇異果三井藥局"
    },
    {
      "code" : "5931172098",
      "display" : "喜樂樂中西健保藥局"
    },
    {
      "code" : "5931172114",
      "display" : "林口樂誠藥局"
    },
    {
      "code" : "5931172123",
      "display" : "森民藥局"
    },
    {
      "code" : "5931172132",
      "display" : "力行藥局"
    },
    {
      "code" : "5931172141",
      "display" : "快樂斑馬藥局"
    },
    {
      "code" : "5931172150",
      "display" : "森陽藥局"
    },
    {
      "code" : "5931172169",
      "display" : "南勢藥局"
    },
    {
      "code" : "5931181051",
      "display" : "永源藥局"
    },
    {
      "code" : "5931181104",
      "display" : "裕康藥局"
    },
    {
      "code" : "5931181159",
      "display" : "信東深坑北深藥局"
    },
    {
      "code" : "5931181195",
      "display" : "健康小站藥局"
    },
    {
      "code" : "5931181239",
      "display" : "怡恩藥局"
    },
    {
      "code" : "5931181257",
      "display" : "福康藥粧藥局"
    },
    {
      "code" : "5931181266",
      "display" : "怡恩藥局"
    },
    {
      "code" : "5931181275",
      "display" : "安康藥妝藥局"
    },
    {
      "code" : "5931181284",
      "display" : "怡恩藥局"
    },
    {
      "code" : "5931190514",
      "display" : "碇康藥局"
    },
    {
      "code" : "5931211045",
      "display" : "三芝藥師藥局"
    },
    {
      "code" : "5931211063",
      "display" : "富康輝藥局"
    },
    {
      "code" : "5931220017",
      "display" : "醫有堂藥局"
    },
    {
      "code" : "5931231127",
      "display" : "杏家藥局"
    },
    {
      "code" : "5931231181",
      "display" : "八里藥師藥局"
    },
    {
      "code" : "5931231190",
      "display" : "龍米藥師藥局"
    },
    {
      "code" : "5931231207",
      "display" : "大愛嘉安藥局"
    },
    {
      "code" : "5931231225",
      "display" : "小蘋果藥局"
    },
    {
      "code" : "5931231298",
      "display" : "寶格麗藥局"
    },
    {
      "code" : "5931231305",
      "display" : "威爾斯藥局"
    },
    {
      "code" : "5931231314",
      "display" : "天康八里藥局"
    },
    {
      "code" : "5931231323",
      "display" : "佑全八里中山藥局"
    },
    {
      "code" : "5931231332",
      "display" : "天康八里藥局"
    },
    {
      "code" : "5931231341",
      "display" : "威爾斯藥局"
    },
    {
      "code" : "5931231350",
      "display" : "龍米藥師藥局"
    },
    {
      "code" : "5931231369",
      "display" : "八里藥局"
    },
    {
      "code" : "5931231378",
      "display" : "龍米藥師藥局"
    },
    {
      "code" : "5931250015",
      "display" : "松南藥局"
    },
    {
      "code" : "5931250042",
      "display" : "信芳藥局"
    },
    {
      "code" : "5931260020",
      "display" : "佑全貢寮仁和藥局"
    },
    {
      "code" : "5931270026",
      "display" : "仁又堂藥局"
    },
    {
      "code" : "5931270044",
      "display" : "金宏仁藥局"
    },
    {
      "code" : "5931271103",
      "display" : "躍獅五福藥局"
    },
    {
      "code" : "5931271112",
      "display" : "富康活力金釤藥局"
    },
    {
      "code" : "5931280013",
      "display" : "萬里藥局"
    },
    {
      "code" : "5931281074",
      "display" : "北海岸藥局"
    },
    {
      "code" : "5931281083",
      "display" : "焦藥局"
    },
    {
      "code" : "5931281092",
      "display" : "北海岸藥局"
    },
    {
      "code" : "5934010013",
      "display" : "永安藥局"
    },
    {
      "code" : "5934010022",
      "display" : "振芳藥局"
    },
    {
      "code" : "5934010068",
      "display" : "志成藥局"
    },
    {
      "code" : "5934010077",
      "display" : "華大藥局"
    },
    {
      "code" : "5934010086",
      "display" : "圓滿堂藥局"
    },
    {
      "code" : "5934010193",
      "display" : "文化藥師藥局"
    },
    {
      "code" : "5934010200",
      "display" : "康禾藥局"
    },
    {
      "code" : "5934010228",
      "display" : "中一藥局"
    },
    {
      "code" : "5934010282",
      "display" : "厚生藥局"
    },
    {
      "code" : "5934011403",
      "display" : "中興藥局"
    },
    {
      "code" : "5934011510",
      "display" : "李藥局"
    },
    {
      "code" : "5934011529",
      "display" : "宜生藥局"
    },
    {
      "code" : "5934011538",
      "display" : "宜和藥局"
    },
    {
      "code" : "5934011565",
      "display" : "微風藥師藥局"
    },
    {
      "code" : "5934011636",
      "display" : "興南藥局"
    },
    {
      "code" : "5934011725",
      "display" : "如康藥局"
    },
    {
      "code" : "5934011761",
      "display" : "宜芳藥局"
    },
    {
      "code" : "5934011850",
      "display" : "健康家藥局"
    },
    {
      "code" : "5934011958",
      "display" : "栢心藥局"
    },
    {
      "code" : "5934011985",
      "display" : "惠登藥師藥局"
    },
    {
      "code" : "5934012008",
      "display" : "欣悅藥局"
    },
    {
      "code" : "5934012017",
      "display" : "大榮藥師藥局"
    },
    {
      "code" : "5934012026",
      "display" : "博安藥局"
    },
    {
      "code" : "5934012044",
      "display" : "富康新民藥局"
    },
    {
      "code" : "5934012062",
      "display" : "鴻馨藥師健保藥局"
    },
    {
      "code" : "5934012115",
      "display" : "健生藥局"
    },
    {
      "code" : "5934012133",
      "display" : "仁俊藥局"
    },
    {
      "code" : "5934012160",
      "display" : "慈幼藥局"
    },
    {
      "code" : "5934012179",
      "display" : "宜蘭和睦藥局"
    },
    {
      "code" : "5934012197",
      "display" : "佳音藥局"
    },
    {
      "code" : "5934012204",
      "display" : "順利藥局"
    },
    {
      "code" : "5934012222",
      "display" : "康泰藥局"
    },
    {
      "code" : "5934012231",
      "display" : "黎明健康藥局"
    },
    {
      "code" : "5934012240",
      "display" : "東成藥局"
    },
    {
      "code" : "5934012286",
      "display" : "健康藥局"
    },
    {
      "code" : "5934012339",
      "display" : "禮仁藥局"
    },
    {
      "code" : "5934012348",
      "display" : "聖心藥局"
    },
    {
      "code" : "5934012357",
      "display" : "品康藥局"
    },
    {
      "code" : "5934012366",
      "display" : "熊賀大藥局"
    },
    {
      "code" : "5934012375",
      "display" : "宜蘭啄木鳥藥局"
    },
    {
      "code" : "5934012393",
      "display" : "綠洲藥局"
    },
    {
      "code" : "5934012400",
      "display" : "安得藥局"
    },
    {
      "code" : "5934012419",
      "display" : "熊貓健保藥局"
    },
    {
      "code" : "5934012437",
      "display" : "神農養生藥局"
    },
    {
      "code" : "5934012455",
      "display" : "日興健保藥局"
    },
    {
      "code" : "5934012464",
      "display" : "緣心健保藥局"
    },
    {
      "code" : "5934012473",
      "display" : "宜蘭藥局"
    },
    {
      "code" : "5934012482",
      "display" : "健生藥局"
    },
    {
      "code" : "5934012491",
      "display" : "佳興藥局"
    },
    {
      "code" : "5934012508",
      "display" : "健生藥局"
    },
    {
      "code" : "5934012517",
      "display" : "宜芳藥局"
    },
    {
      "code" : "5934012526",
      "display" : "土也家藥局"
    },
    {
      "code" : "5934012535",
      "display" : "康是美藥局宜大店"
    },
    {
      "code" : "5934012544",
      "display" : "佑全宜蘭和睦藥局"
    },
    {
      "code" : "5934012553",
      "display" : "泰山藥局"
    },
    {
      "code" : "5934012562",
      "display" : "禮仁藥局"
    },
    {
      "code" : "5934012571",
      "display" : "熊貓健保藥局"
    },
    {
      "code" : "5934012580",
      "display" : "安賀中西藥局"
    },
    {
      "code" : "5934012599",
      "display" : "逸菁中西特約藥局"
    },
    {
      "code" : "5934012606",
      "display" : "幸胡藥局"
    },
    {
      "code" : "5934012624",
      "display" : "宜蘭藥局"
    },
    {
      "code" : "5934012642",
      "display" : "順利藥局"
    },
    {
      "code" : "5934012651",
      "display" : "佑全宜蘭和睦藥局"
    },
    {
      "code" : "5934012660",
      "display" : "長緹健保中西藥局"
    },
    {
      "code" : "5934012679",
      "display" : "仁俊藥局"
    },
    {
      "code" : "5934012688",
      "display" : "共生藥局"
    },
    {
      "code" : "5934012697",
      "display" : "賦康藥局"
    },
    {
      "code" : "5934012704",
      "display" : "北峰藥局"
    },
    {
      "code" : "5934012713",
      "display" : "樂樂藥局宜蘭店"
    },
    {
      "code" : "5934012722",
      "display" : "宜蘭藥局"
    },
    {
      "code" : "5934012731",
      "display" : "宜蘭丁丁藥局"
    },
    {
      "code" : "5934012740",
      "display" : "宜蘭藥局"
    },
    {
      "code" : "5934012759",
      "display" : "賦康藥局"
    },
    {
      "code" : "5934020019",
      "display" : "樺生藥師連鎖藥局"
    },
    {
      "code" : "5934020064",
      "display" : "順昇藥局"
    },
    {
      "code" : "5934020073",
      "display" : "長生藥局"
    },
    {
      "code" : "5934020153",
      "display" : "信隆藥局"
    },
    {
      "code" : "5934020224",
      "display" : "源生藥局"
    },
    {
      "code" : "5934020251",
      "display" : "黃藥局"
    },
    {
      "code" : "5934020279",
      "display" : "博善藥局"
    },
    {
      "code" : "5934020288",
      "display" : "鑫聖藥局"
    },
    {
      "code" : "5934021374",
      "display" : "博雅藥師藥局"
    },
    {
      "code" : "5934021383",
      "display" : "東安藥局"
    },
    {
      "code" : "5934021409",
      "display" : "德芳藥局"
    },
    {
      "code" : "5934021418",
      "display" : "民生健保藥局"
    },
    {
      "code" : "5934021481",
      "display" : "怡林藥局"
    },
    {
      "code" : "5934021490",
      "display" : "康民藥局"
    },
    {
      "code" : "5934021516",
      "display" : "興東藥局"
    },
    {
      "code" : "5934021525",
      "display" : "喜樂藥師藥局"
    },
    {
      "code" : "5934021534",
      "display" : "佳和藥局"
    },
    {
      "code" : "5934021543",
      "display" : "宏恩藥局"
    },
    {
      "code" : "5934021552",
      "display" : "慈濟大藥局"
    },
    {
      "code" : "5934021561",
      "display" : "和平藥局"
    },
    {
      "code" : "5934021598",
      "display" : "康馥藥局"
    },
    {
      "code" : "5934021632",
      "display" : "上華藥局"
    },
    {
      "code" : "5934021641",
      "display" : "同興藥局"
    },
    {
      "code" : "5934021776",
      "display" : "一生藥師藥局"
    },
    {
      "code" : "5934021794",
      "display" : "倉前藥局"
    },
    {
      "code" : "5934021801",
      "display" : "康健藥局"
    },
    {
      "code" : "5934021847",
      "display" : "集祥藥局"
    },
    {
      "code" : "5934021856",
      "display" : "正欣藥局"
    },
    {
      "code" : "5934021883",
      "display" : "潤康社區健保藥局"
    },
    {
      "code" : "5934021927",
      "display" : "元氣藥局"
    },
    {
      "code" : "5934021936",
      "display" : "安良藥局"
    },
    {
      "code" : "5934021954",
      "display" : "家安藥局"
    },
    {
      "code" : "5934021972",
      "display" : "晨安藥局"
    },
    {
      "code" : "5934021981",
      "display" : "樂樂藥局"
    },
    {
      "code" : "5934021990",
      "display" : "成功藥局"
    },
    {
      "code" : "5934022013",
      "display" : "康莊藥局"
    },
    {
      "code" : "5934022022",
      "display" : "光澤醫美藥局"
    },
    {
      "code" : "5934022031",
      "display" : "大菖藥局"
    },
    {
      "code" : "5934022040",
      "display" : "羅東藥局"
    },
    {
      "code" : "5934022059",
      "display" : "宏安藥局"
    },
    {
      "code" : "5934022077",
      "display" : "天一藥師藥局"
    },
    {
      "code" : "5934022095",
      "display" : "羅東啄木鳥藥局"
    },
    {
      "code" : "5934022102",
      "display" : "杏一羅東興東藥局"
    },
    {
      "code" : "5934022111",
      "display" : "宏海藥局"
    },
    {
      "code" : "5934022120",
      "display" : "宜寧藥局"
    },
    {
      "code" : "5934022139",
      "display" : "公正藥局"
    },
    {
      "code" : "5934022148",
      "display" : "培英藥局"
    },
    {
      "code" : "5934022157",
      "display" : "哈哈藥局"
    },
    {
      "code" : "5934022166",
      "display" : "和平藥局"
    },
    {
      "code" : "5934022175",
      "display" : "公正藥局"
    },
    {
      "code" : "5934022184",
      "display" : "佑全羅東公正藥局"
    },
    {
      "code" : "5934022193",
      "display" : "佑全羅東興東南藥局"
    },
    {
      "code" : "5934022200",
      "display" : "杏一羅東興東藥局"
    },
    {
      "code" : "5934022219",
      "display" : "康是美藥局公正店"
    },
    {
      "code" : "5934022228",
      "display" : "杏一羅東興東藥局"
    },
    {
      "code" : "5934022237",
      "display" : "公正藥局"
    },
    {
      "code" : "5934022246",
      "display" : "喜樂藥師藥局"
    },
    {
      "code" : "5934022255",
      "display" : "來藥局"
    },
    {
      "code" : "5934022264",
      "display" : "福樂藥局"
    },
    {
      "code" : "5934022273",
      "display" : "彥心藥局"
    },
    {
      "code" : "5934022282",
      "display" : "東昇藥局"
    },
    {
      "code" : "5934022291",
      "display" : "羅東啄木鳥藥局"
    },
    {
      "code" : "5934022308",
      "display" : "景順藥局"
    },
    {
      "code" : "5934022317",
      "display" : "欣安藥局"
    },
    {
      "code" : "5934022326",
      "display" : "杏一羅東興東藥局"
    },
    {
      "code" : "5934022335",
      "display" : "東安藥局"
    },
    {
      "code" : "5934030015",
      "display" : "南陽藥局"
    },
    {
      "code" : "5934030033",
      "display" : "仁大藥局"
    },
    {
      "code" : "5934031101",
      "display" : "順慧藥局"
    },
    {
      "code" : "5934031110",
      "display" : "宜家藥師藥局"
    },
    {
      "code" : "5934031138",
      "display" : "新豐藥局"
    },
    {
      "code" : "5934031165",
      "display" : "宏一藥局"
    },
    {
      "code" : "5934031209",
      "display" : "仁人健保藥局"
    },
    {
      "code" : "5934031218",
      "display" : "熊野藥局"
    },
    {
      "code" : "5934031245",
      "display" : "熊本健保藥局"
    },
    {
      "code" : "5934031254",
      "display" : "佑全蘇澳中山藥局"
    },
    {
      "code" : "5934031263",
      "display" : "皇超藥局"
    },
    {
      "code" : "5934031272",
      "display" : "正蘇西西藥局"
    },
    {
      "code" : "5934031281",
      "display" : "佑全蘇澳中山藥局"
    },
    {
      "code" : "5934031290",
      "display" : "熊野藥局"
    },
    {
      "code" : "5934031307",
      "display" : "蘇澳藥局"
    },
    {
      "code" : "5934031316",
      "display" : "熊野健保藥局"
    },
    {
      "code" : "5934031325",
      "display" : "蘇澳藥局"
    },
    {
      "code" : "5934040039",
      "display" : "仁康藥局"
    },
    {
      "code" : "5934040093",
      "display" : "元生藥師藥局"
    },
    {
      "code" : "5934041125",
      "display" : "杏元藥局"
    },
    {
      "code" : "5934041143",
      "display" : "群英藥局"
    },
    {
      "code" : "5934041161",
      "display" : "頭城藥局"
    },
    {
      "code" : "5934041170",
      "display" : "永仁藥局"
    },
    {
      "code" : "5934041198",
      "display" : "頭城健保藥局"
    },
    {
      "code" : "5934041205",
      "display" : "晴天藥局"
    },
    {
      "code" : "5934041214",
      "display" : "佑全頭城青雲藥局"
    },
    {
      "code" : "5934041223",
      "display" : "佑全頭城青雲藥局"
    },
    {
      "code" : "5934050080",
      "display" : "三華藥局"
    },
    {
      "code" : "5934051149",
      "display" : "和風藥局"
    },
    {
      "code" : "5934051167",
      "display" : "岩峰藥局"
    },
    {
      "code" : "5934051229",
      "display" : "廣福藥師藥局"
    },
    {
      "code" : "5934051247",
      "display" : "安信藥局"
    },
    {
      "code" : "5934051265",
      "display" : "恩好藥局"
    },
    {
      "code" : "5934051274",
      "display" : "樂多藥局"
    },
    {
      "code" : "5934051309",
      "display" : "林子路藥局"
    },
    {
      "code" : "5934051318",
      "display" : "微笑藥局"
    },
    {
      "code" : "5934051327",
      "display" : "礁溪藥局"
    },
    {
      "code" : "5934051336",
      "display" : "安信藥局"
    },
    {
      "code" : "5934051354",
      "display" : "佑全宜蘭礁溪藥局"
    },
    {
      "code" : "5934051363",
      "display" : "微笑藥局"
    },
    {
      "code" : "5934051381",
      "display" : "安信藥局"
    },
    {
      "code" : "5934051390",
      "display" : "晉赫藥局"
    },
    {
      "code" : "5934061047",
      "display" : "壯圍藥局"
    },
    {
      "code" : "5934061065",
      "display" : "心星藥局"
    },
    {
      "code" : "5934070037",
      "display" : "上新藥局"
    },
    {
      "code" : "5934071034",
      "display" : "信毅藥師藥局"
    },
    {
      "code" : "5934071061",
      "display" : "喜樂心藥局"
    },
    {
      "code" : "5934071070",
      "display" : "員山健保藥局"
    },
    {
      "code" : "5934080015",
      "display" : "佳恩藥局"
    },
    {
      "code" : "5934080024",
      "display" : "杏東藥師藥局"
    },
    {
      "code" : "5934081049",
      "display" : "德鑫藥局"
    },
    {
      "code" : "5934081058",
      "display" : "華康藥局"
    },
    {
      "code" : "5934081067",
      "display" : "威仁藥局"
    },
    {
      "code" : "5934081129",
      "display" : "義成藥局"
    },
    {
      "code" : "5934081147",
      "display" : "康佑藥局"
    },
    {
      "code" : "5934081156",
      "display" : "樂心藥局"
    },
    {
      "code" : "5934081165",
      "display" : "合康藥局"
    },
    {
      "code" : "5934081174",
      "display" : "和康藥局"
    },
    {
      "code" : "5934081192",
      "display" : "順安藥局"
    },
    {
      "code" : "5934081209",
      "display" : "滋生堂藥局"
    },
    {
      "code" : "5934090048",
      "display" : "美華第一藥局"
    },
    {
      "code" : "5934091054",
      "display" : "日昇藥局"
    },
    {
      "code" : "5934091072",
      "display" : "新安藥局"
    },
    {
      "code" : "5934091081",
      "display" : "五結健保藥局"
    },
    {
      "code" : "5934091090",
      "display" : "平安藥局"
    },
    {
      "code" : "5934091125",
      "display" : "安心藥局"
    },
    {
      "code" : "5934091134",
      "display" : "松康藥局"
    },
    {
      "code" : "5934091143",
      "display" : "二結藥局"
    },
    {
      "code" : "5934091152",
      "display" : "承億藥局"
    },
    {
      "code" : "5934091161",
      "display" : "躍獅大心藥局"
    },
    {
      "code" : "5934100030",
      "display" : "三星健保藥局"
    },
    {
      "code" : "5934100049",
      "display" : "美麥藥局"
    },
    {
      "code" : "5934100058",
      "display" : "澄心藥局"
    },
    {
      "code" : "5934120014",
      "display" : "進昌健保藥局"
    },
    {
      "code" : "5990010515",
      "display" : "大賀藥局"
    },
    {
      "code" : "5990010524",
      "display" : "康總藥局"
    },
    {
      "code" : "5990010533",
      "display" : "金志忠藥局"
    },
    {
      "code" : "5990010631",
      "display" : "大森藥局"
    },
    {
      "code" : "5990010695",
      "display" : "百泰藥局"
    },
    {
      "code" : "5990020020",
      "display" : "大金藥局"
    },
    {
      "code" : "5990030044",
      "display" : "仁愛復興藥局"
    },
    {
      "code" : "5990030062",
      "display" : "大山藥局"
    },
    {
      "code" : "5990030080",
      "display" : "東馬健康藥局"
    },
    {
      "code" : "5990030099",
      "display" : "大山藥局"
    },
    {
      "code" : "5990040031",
      "display" : "伯玉藥局"
    },
    {
      "code" : "7101100026",
      "display" : "臺北市立聯合醫院附設林森中醫居家護理所"
    },
    {
      "code" : "7101160031",
      "display" : "稻香居家護理所(委託臺北榮民總醫院經營管理)"
    },
    {
      "code" : "7131020022",
      "display" : "新北市立聯合醫院附設居家護理所"
    },
    {
      "code" : "7131250011",
      "display" : "新北市雙溪區衛生所附設居家護理所"
    },
    {
      "code" : "7131270013",
      "display" : "國立臺灣大學醫學院附設醫院金山分院附設居家護理所"
    },
    {
      "code" : "7134010528",
      "display" : "宜蘭縣宜蘭市衛生所附設居家護理所"
    },
    {
      "code" : "7134020015",
      "display" : "宜蘭縣羅東鎮衛生所附設居家護理所"
    },
    {
      "code" : "7134030011",
      "display" : "宜蘭縣蘇澳鎮衛生所附設居家護理所"
    },
    {
      "code" : "7134060019",
      "display" : "宜蘭縣壯圍鄉衛生所附設居家護理所"
    },
    {
      "code" : "7134080011",
      "display" : "宜蘭縣冬山鄉衛生所附設居家護理所"
    },
    {
      "code" : "7191030017",
      "display" : "連江縣莒光鄉西莒衛生所附設居家護理所"
    },
    {
      "code" : "7191040013",
      "display" : "連江縣東引鄉衛生所附設居家護理所"
    },
    {
      "code" : "7201020025",
      "display" : "財團法人獎卿護理展望基金會大台北居家護理所"
    },
    {
      "code" : "7201170011",
      "display" : "財團法人生命連線基金會附設居家護理所"
    },
    {
      "code" : "7201190013",
      "display" : "同仁院醫療財團法人附設居家護理所"
    },
    {
      "code" : "7301010012",
      "display" : "基督復臨安息日會醫療財團法人附設臺安居家護理所"
    },
    {
      "code" : "7301020018",
      "display" : "國泰醫療財團法人附設居家護理所"
    },
    {
      "code" : "7301100011",
      "display" : "迦和居家護理所"
    },
    {
      "code" : "7301150011",
      "display" : "新光醫療財團法人附設新光居家護理所"
    },
    {
      "code" : "7301160017",
      "display" : "振興醫療財團法人附設振興居家護理所"
    },
    {
      "code" : "7301200016",
      "display" : "臺北市立萬芳醫院─委託臺北醫學大學辦理附設居家護理所"
    },
    {
      "code" : "7311030517",
      "display" : "醫療財團法人臺灣區煤礦業基金會附設八堵居家護理"
    },
    {
      "code" : "7331010020",
      "display" : "板橋中興醫院附設居家護理所"
    },
    {
      "code" : "7331040019",
      "display" : "衛生福利部雙和醫院附設居家護理所(委託臺北醫學大學興建經營)"
    },
    {
      "code" : "7331050024",
      "display" : "天主教耕莘醫療財團法人附設耕莘居家護理所"
    },
    {
      "code" : "7331060020",
      "display" : "中英醫療社團法人附設居家護理所"
    },
    {
      "code" : "7334010013",
      "display" : "宜蘭仁愛醫療財團法人附設仁愛居家護理所"
    },
    {
      "code" : "7334020028",
      "display" : "醫療財團法人羅許基金會附設羅東博愛居家護理所"
    },
    {
      "code" : "7334020037",
      "display" : "天主教靈醫會醫療財團法人附設羅東聖母居家護理所"
    },
    {
      "code" : "7334050017",
      "display" : "財團法人宜蘭縣私立竹林養護院附設居家護理所"
    },
    {
      "code" : "7334050035",
      "display" : "天主教靈醫會醫療財團法人附設礁溪杏和居家護理所"
    },
    {
      "code" : "7401011333",
      "display" : "博仁綜合醫院附設居家護理所"
    },
    {
      "code" : "7401011655",
      "display" : "苾滿居家護理所"
    },
    {
      "code" : "7401021286",
      "display" : "鄰里居家護理所"
    },
    {
      "code" : "7401021302",
      "display" : "可馨居家護理所"
    },
    {
      "code" : "7401021393",
      "display" : "臺北市私立幸福時光居家護理所"
    },
    {
      "code" : "7401021419",
      "display" : "協樂居家護理所"
    },
    {
      "code" : "7401090085",
      "display" : "吉馨安居家護理所"
    },
    {
      "code" : "7401090129",
      "display" : "共護家居家護理所"
    },
    {
      "code" : "7401090156",
      "display" : "承德居家護理所"
    },
    {
      "code" : "7401090165",
      "display" : "德馨居家護理所"
    },
    {
      "code" : "7401101467",
      "display" : "安歆居家護理所"
    },
    {
      "code" : "7401101556",
      "display" : "溫邸家居家護理所"
    },
    {
      "code" : "7401101583",
      "display" : "泰安醫院附設溫馨居家護理所"
    },
    {
      "code" : "7401101609",
      "display" : "臺北市蕭中正居家護理所"
    },
    {
      "code" : "7401101618",
      "display" : "凱琳居家護理所"
    },
    {
      "code" : "7401111034",
      "display" : "成功居家護理所"
    },
    {
      "code" : "7401111258",
      "display" : "康健居家護理所"
    },
    {
      "code" : "7401111267",
      "display" : "好運居家護理所"
    },
    {
      "code" : "7401111276",
      "display" : "新聯寬居家護理所"
    },
    {
      "code" : "7401111294",
      "display" : "全心居家護理所"
    },
    {
      "code" : "7401120033",
      "display" : "臺北市獨立型態南港居家護理所"
    },
    {
      "code" : "7401120042",
      "display" : "臺北市獨立型態成福居家護理所"
    },
    {
      "code" : "7401120051",
      "display" : "安德利居家護理所"
    },
    {
      "code" : "7401151298",
      "display" : "宜寧居家護理所"
    },
    {
      "code" : "7401161810",
      "display" : "育幸福居家護理所"
    },
    {
      "code" : "7401161865",
      "display" : "全佳居家護理所"
    },
    {
      "code" : "7401170542",
      "display" : "財團法人私立台北醫學大學附設醫院附設居家護理所"
    },
    {
      "code" : "7401170640",
      "display" : "信慈居家護理所"
    },
    {
      "code" : "7401181241",
      "display" : "庭安居家護理所"
    },
    {
      "code" : "7401181250",
      "display" : "美樺居家護理所"
    },
    {
      "code" : "7401181358",
      "display" : "泰安居家護理所"
    },
    {
      "code" : "7401181410",
      "display" : "永愛居家護理所"
    },
    {
      "code" : "7401181438",
      "display" : "惠馨居家護理所"
    },
    {
      "code" : "7401191041",
      "display" : "合康居家護理所"
    },
    {
      "code" : "7401191069",
      "display" : "愛吾愛居家護理所"
    },
    {
      "code" : "7401201113",
      "display" : "閤家福居家護理所"
    },
    {
      "code" : "7401201140",
      "display" : "景美醫院附設居家護理"
    },
    {
      "code" : "7401201159",
      "display" : "澄歆居家護理所"
    },
    {
      "code" : "7401201168",
      "display" : "興隆樂活居家護理所"
    },
    {
      "code" : "7401201177",
      "display" : "前瞻居家護理所"
    },
    {
      "code" : "7401201186",
      "display" : "北斗星居家護理所"
    },
    {
      "code" : "7401201195",
      "display" : "優助居家護理所"
    },
    {
      "code" : "7411011096",
      "display" : "基隆常春藤居家護理所"
    },
    {
      "code" : "7411020602",
      "display" : "百安居家護理所"
    },
    {
      "code" : "7411020611",
      "display" : "安和居家護理所"
    },
    {
      "code" : "7411041094",
      "display" : "安馨居家護理機構"
    },
    {
      "code" : "7411041110",
      "display" : "沅沅居家護理所"
    },
    {
      "code" : "7411050011",
      "display" : "美綠居家護理所"
    },
    {
      "code" : "7411060026",
      "display" : "佳惠居家護理所"
    },
    {
      "code" : "7411060035",
      "display" : "長青居家護理所"
    },
    {
      "code" : "7431011305",
      "display" : "健綸居家護理所"
    },
    {
      "code" : "7431011369",
      "display" : "慧安居家護理所"
    },
    {
      "code" : "7431011396",
      "display" : "私立新生活居家護理所"
    },
    {
      "code" : "7431011412",
      "display" : "聯順居家護理所"
    },
    {
      "code" : "7431011485",
      "display" : "私立健安護理之家"
    },
    {
      "code" : "7431011725",
      "display" : "蕭中正醫院附設居家護理所"
    },
    {
      "code" : "7431011832",
      "display" : "達霖居家護理所"
    },
    {
      "code" : "7431011967",
      "display" : "祥蕙居家護理所"
    },
    {
      "code" : "7431011985",
      "display" : "安康喜樂居家護理所"
    },
    {
      "code" : "7431012062",
      "display" : "元荷居家護理所"
    },
    {
      "code" : "7431012071",
      "display" : "百禾居家護理所"
    },
    {
      "code" : "7431012106",
      "display" : "豐生居家護理所"
    },
    {
      "code" : "7431012115",
      "display" : "中馨居家護理所"
    },
    {
      "code" : "7431021132",
      "display" : "庭芳居家護理所"
    },
    {
      "code" : "7431021249",
      "display" : "安心居家護理所"
    },
    {
      "code" : "7431021301",
      "display" : "旺福居家護理所"
    },
    {
      "code" : "7431021543",
      "display" : "萬眾居家護理所"
    },
    {
      "code" : "7431021570",
      "display" : "宜家居家護理所"
    },
    {
      "code" : "7431021614",
      "display" : "幸福時光居家護理所"
    },
    {
      "code" : "7431021632",
      "display" : "達心居家護理所"
    },
    {
      "code" : "7431021641",
      "display" : "沁心居家護理所"
    },
    {
      "code" : "7431021650",
      "display" : "如己居家護理所"
    },
    {
      "code" : "7431021669",
      "display" : "全心居家護理所"
    },
    {
      "code" : "7431021678",
      "display" : "守歲居家護理所"
    },
    {
      "code" : "7431031110",
      "display" : "永欣居家護理所"
    },
    {
      "code" : "7431031156",
      "display" : "芯全安居家護理所"
    },
    {
      "code" : "7431041054",
      "display" : "捷安居家護理所"
    },
    {
      "code" : "7431041296",
      "display" : "忠祥居家護理所"
    },
    {
      "code" : "7431041349",
      "display" : "禾藝居家護理所"
    },
    {
      "code" : "7431041367",
      "display" : "立穎居家護理所"
    },
    {
      "code" : "7431041394",
      "display" : "臻佳居家護理所"
    },
    {
      "code" : "7431041447",
      "display" : "璟濰居家護理所"
    },
    {
      "code" : "7431041474",
      "display" : "僖安居家護理所"
    },
    {
      "code" : "7431041492",
      "display" : "青禾居家護理所"
    },
    {
      "code" : "7431041518",
      "display" : "嘉寧居家護理所"
    },
    {
      "code" : "7431041545",
      "display" : "衛生福利部雙和醫院附設居家護理所(委託臺北醫學大學興建經營)"
    },
    {
      "code" : "7431041572",
      "display" : "德怡居家護理所"
    },
    {
      "code" : "7431041581",
      "display" : "康杏居家護理所"
    },
    {
      "code" : "7431041590",
      "display" : "齡馨居家護理所"
    },
    {
      "code" : "7431050535",
      "display" : "新新居家護理所"
    },
    {
      "code" : "7431050713",
      "display" : "遠東護理之家"
    },
    {
      "code" : "7431050777",
      "display" : "溫昕護理之家"
    },
    {
      "code" : "7431050839",
      "display" : "新北仁康醫院附設居家護理所"
    },
    {
      "code" : "7431050866",
      "display" : "美達居家護理所"
    },
    {
      "code" : "7431050928",
      "display" : "同仁醫院附設順安居家護理所"
    },
    {
      "code" : "7431050937",
      "display" : "永安居家護理所"
    },
    {
      "code" : "7431050946",
      "display" : "同仁醫院附設居家護理所"
    },
    {
      "code" : "7431050982",
      "display" : "同心居家護理所"
    },
    {
      "code" : "7431050991",
      "display" : "同仁醫院附設居家護理所"
    },
    {
      "code" : "7431051005",
      "display" : "愛家居家護理所"
    },
    {
      "code" : "7431051032",
      "display" : "永安居家護理所"
    },
    {
      "code" : "7431051041",
      "display" : "豐榮醫院附設居家護理所"
    },
    {
      "code" : "7431051050",
      "display" : "豐榮醫院附設居家護理所"
    },
    {
      "code" : "7431051069",
      "display" : "恒善居家護理所"
    },
    {
      "code" : "7431061289",
      "display" : "福耕居家護理所"
    },
    {
      "code" : "7431061332",
      "display" : "新泰綜合醫院附設居家護理所"
    },
    {
      "code" : "7431061378",
      "display" : "安家居家護理所"
    },
    {
      "code" : "7431061403",
      "display" : "思瑞居家護理所"
    },
    {
      "code" : "7431061412",
      "display" : "愛寧居家護理所"
    },
    {
      "code" : "7431061430",
      "display" : "護老安心居家護理所"
    },
    {
      "code" : "7431071061",
      "display" : "仁愛醫院附設居家護理所"
    },
    {
      "code" : "7431071089",
      "display" : "大心居家護理所"
    },
    {
      "code" : "7431071098",
      "display" : "溫馨居家護理所"
    },
    {
      "code" : "7431071105",
      "display" : "愛佳生活居家護理所"
    },
    {
      "code" : "7431071114",
      "display" : "美心居家護理所"
    },
    {
      "code" : "7431081067",
      "display" : "和鄰居家護理所"
    },
    {
      "code" : "7431081085",
      "display" : "馨樂居家護理所"
    },
    {
      "code" : "7431090011",
      "display" : "周玉惠助產所"
    },
    {
      "code" : "7431091063",
      "display" : "鴻欣護理之家"
    },
    {
      "code" : "7431091090",
      "display" : "永樂居家護理所"
    },
    {
      "code" : "7431091107",
      "display" : "清福醫院附設居家護理所"
    },
    {
      "code" : "7431091125",
      "display" : "益德居家護理所"
    },
    {
      "code" : "7431091161",
      "display" : "慧民居家護理所"
    },
    {
      "code" : "7431101046",
      "display" : "安福居家護理所"
    },
    {
      "code" : "7431101251",
      "display" : "永康居家護理所"
    },
    {
      "code" : "7431101260",
      "display" : "無論如河居家護理所"
    },
    {
      "code" : "7431110545",
      "display" : "私立常春藤居家護理所"
    },
    {
      "code" : "7431110590",
      "display" : "佳醫護理之家"
    },
    {
      "code" : "7431110698",
      "display" : "全人居家護理所"
    },
    {
      "code" : "7431110723",
      "display" : "南丁格爾居家護理所"
    },
    {
      "code" : "7431110732",
      "display" : "春暖居家護理所"
    },
    {
      "code" : "7431110769",
      "display" : "日好居家護理所"
    },
    {
      "code" : "7431110778",
      "display" : "沛熙居家護理所"
    },
    {
      "code" : "7431130752",
      "display" : "璟馨居家護理所"
    },
    {
      "code" : "7431130798",
      "display" : "福康居家護理所"
    },
    {
      "code" : "7431130805",
      "display" : "新北市私立仁德居家護理所"
    },
    {
      "code" : "7431130896",
      "display" : "私立健生護理之家"
    },
    {
      "code" : "7431130921",
      "display" : "慈心居家護理所"
    },
    {
      "code" : "7431130958",
      "display" : "齡活居家護理所"
    },
    {
      "code" : "7431130967",
      "display" : "齡活居家護理所"
    },
    {
      "code" : "7431130994",
      "display" : "銳辛居家護理所"
    },
    {
      "code" : "7431140598",
      "display" : "私立三民護理之家"
    },
    {
      "code" : "7431140687",
      "display" : "全連居家護理所"
    },
    {
      "code" : "7431140801",
      "display" : "禾協居家護理所"
    },
    {
      "code" : "7431140829",
      "display" : "仁安居家護理所"
    },
    {
      "code" : "7431150030",
      "display" : "新北市長青樹居家護理所"
    },
    {
      "code" : "7431150049",
      "display" : "安頤居家護理所"
    },
    {
      "code" : "7431160063",
      "display" : "慈英居家護理所"
    },
    {
      "code" : "7431160072",
      "display" : "輔仁大學學校財團法人輔仁大學附設醫院附設居家護理所"
    },
    {
      "code" : "7431160081",
      "display" : "輔仁大學學校財團法人輔仁大學附設醫院附設居家護理所"
    },
    {
      "code" : "7431160116",
      "display" : "輔仁大學學校財團法人輔仁大學附設醫院附設居家護理所"
    },
    {
      "code" : "7431171084",
      "display" : "康健居家護理所"
    },
    {
      "code" : "7431171164",
      "display" : "美善居家護理所"
    },
    {
      "code" : "7431171182",
      "display" : "全國居家護理所"
    },
    {
      "code" : "7431171191",
      "display" : "康富居家護理所"
    },
    {
      "code" : "7431171208",
      "display" : "明倉居家護理所"
    },
    {
      "code" : "7431171226",
      "display" : "全國居家護理所"
    },
    {
      "code" : "7431171244",
      "display" : "靜新居家護理所"
    },
    {
      "code" : "7431171253",
      "display" : "慈家居家護理所"
    },
    {
      "code" : "7431171271",
      "display" : "全方位居家護理所"
    },
    {
      "code" : "7431171299",
      "display" : "和順居家護理所"
    },
    {
      "code" : "7431230079",
      "display" : "圓果居家護理所"
    },
    {
      "code" : "7434011192",
      "display" : "安護居家護理所"
    },
    {
      "code" : "7434011209",
      "display" : "迦南居家護理所"
    },
    {
      "code" : "7434011218",
      "display" : "家宜居家護理所"
    },
    {
      "code" : "7434011227",
      "display" : "古德居家護理所"
    },
    {
      "code" : "7434011236",
      "display" : "杏安居家護理所"
    },
    {
      "code" : "7434011245",
      "display" : "嵐馨居家護理所"
    },
    {
      "code" : "7434011254",
      "display" : "心開居家護理所"
    },
    {
      "code" : "7434021116",
      "display" : "全心居家護理所"
    },
    {
      "code" : "7434021125",
      "display" : "永晴居家護理所"
    },
    {
      "code" : "7434021198",
      "display" : "紫羅蘭居家護理所"
    },
    {
      "code" : "7434050046",
      "display" : "晶玥居家護理所"
    },
    {
      "code" : "7434070011",
      "display" : "禾樂居居家護理所"
    },
    {
      "code" : "7434080017",
      "display" : "厝邊居家護理所"
    },
    {
      "code" : "7434080035",
      "display" : "靜綻居家護理所"
    },
    {
      "code" : "7434090022",
      "display" : "誼華居家護理所"
    },
    {
      "code" : "7434100023",
      "display" : "幸福居家護理所"
    },
    {
      "code" : "7434110010",
      "display" : "健康居家護理所"
    },
    {
      "code" : "7490030019",
      "display" : "周雅慧私立居家護理所"
    },
    {
      "code" : "7501010516",
      "display" : "三軍總醫院松山分院附設民眾診療服務處附設居家護理所"
    },
    {
      "code" : "7501020012",
      "display" : "臺北市立聯合醫院附設仁愛居家護理所"
    },
    {
      "code" : "7501090014",
      "display" : "臺北市立聯合醫院附設中興居家護理所"
    },
    {
      "code" : "7501110511",
      "display" : "三軍總醫院附設民眾診療服務處附設居家護理所"
    },
    {
      "code" : "7501120017",
      "display" : "臺北市立聯合醫院附設忠孝居家護理所"
    },
    {
      "code" : "7501150015",
      "display" : "臺北市立聯合醫院附設陽明居家護理所"
    },
    {
      "code" : "7501160011",
      "display" : "臺北榮民總醫院附設居家護理所"
    },
    {
      "code" : "7501161027",
      "display" : "臺北市立關渡醫院-委託臺北榮民總醫院經營附設居家護理"
    },
    {
      "code" : "7501180022",
      "display" : "臺北市立聯合醫院附設和平婦幼居家護理所"
    },
    {
      "code" : "7501190019",
      "display" : "國立臺灣大學醫學院附設醫院北護分院附設居家護理所"
    },
    {
      "code" : "7511070024",
      "display" : "衛生福利部基隆醫院附設居家護理"
    },
    {
      "code" : "7511070033",
      "display" : "基隆市立醫院附設居家護理所"
    },
    {
      "code" : "7531010533",
      "display" : "新北市立聯合醫院附設居家護理所"
    },
    {
      "code" : "7531060015",
      "display" : "衛生福利部臺北醫院附設居家護理所"
    },
    {
      "code" : "7531061030",
      "display" : "衛生福利部樂生療養院附設居家護理所"
    },
    {
      "code" : "7531120516",
      "display" : "新北市瑞芳區衛生所附設居家護理所"
    },
    {
      "code" : "7531180012",
      "display" : "新北市深坑區衛生所附設居家護理所"
    },
    {
      "code" : "7531190518",
      "display" : "新北市石碇區衛生所附設居家護理所"
    },
    {
      "code" : "7531200519",
      "display" : "新北市坪林區衛生所附設居家護理所"
    },
    {
      "code" : "7531240513",
      "display" : "新北市平溪區衛生所附設居家護理所"
    },
    {
      "code" : "7531260515",
      "display" : "新北市貢寮區衛生所附設居家護理所"
    },
    {
      "code" : "7531270011",
      "display" : "新北市金山區衛生所附設居家護理所"
    },
    {
      "code" : "7531290513",
      "display" : "新北市烏來區衛生所附設居家護理所"
    },
    {
      "code" : "7534010017",
      "display" : "國立陽明交通大學附設醫院居家護理所"
    },
    {
      "code" : "7534030019",
      "display" : "臺北榮民總醫院蘇澳分院附設居家護理所"
    },
    {
      "code" : "7534040515",
      "display" : "宜蘭縣頭城鎮衛生所附設居家護理所"
    },
    {
      "code" : "7534050511",
      "display" : "宜蘭縣礁溪鄉衛生所附設居家護理所"
    },
    {
      "code" : "7534070513",
      "display" : "宜蘭縣員山鄉衛生所附設居家護理所"
    },
    {
      "code" : "7534070522",
      "display" : "臺北榮民總醫院員山分院附設居家護理所"
    },
    {
      "code" : "7534090515",
      "display" : "宜蘭縣五結鄉衛生所附設居家護理所"
    },
    {
      "code" : "7534100516",
      "display" : "宜蘭縣三星鄉衛生所附設居家護理所"
    },
    {
      "code" : "7534110012",
      "display" : "宜蘭縣大同鄉衛生所附設居家護理所"
    },
    {
      "code" : "7534120018",
      "display" : "宜蘭縣南澳鄉衛生所附設居家護理所"
    },
    {
      "code" : "7590030011",
      "display" : "衛生福利部金門醫院居家護理所"
    },
    {
      "code" : "7591010013",
      "display" : "連江縣立醫院附設居家護理所"
    },
    {
      "code" : "7591020528",
      "display" : "連江縣北竿鄉衛生所附設居家護理所"
    },
    {
      "code" : "7591030515",
      "display" : "連江縣莒光鄉東莒衛生所附設居家護理所"
    },
    {
      "code" : "7601190511",
      "display" : "財團法人台灣省私立臺北仁濟院附設仁濟醫院附設居家護理所"
    },
    {
      "code" : "7611041061",
      "display" : "仁祥診所附設居家護理服務部"
    },
    {
      "code" : "7631010017",
      "display" : "醫療財團法人徐元智先生醫藥基金會附設亞東居家護理所"
    },
    {
      "code" : "7631020522",
      "display" : "宏仁醫院附設居家護理所"
    },
    {
      "code" : "7701100019",
      "display" : "台灣基督長老教會馬偕醫療財團法人附設馬偕居家護理所"
    },
    {
      "code" : "7701110015",
      "display" : "康寧醫療財團法人附設康寧居家護理所"
    },
    {
      "code" : "7711060013",
      "display" : "長庚醫療財團法人附設基隆居家護理所"
    },
    {
      "code" : "7731030511",
      "display" : "天主教耕莘醫療財團法人附設永和耕莘居家護理所"
    },
    {
      "code" : "7731050531",
      "display" : "佛教慈濟醫療財團法人附設台北慈濟居家護理所"
    },
    {
      "code" : "7731091023",
      "display" : "行天宮醫療志業醫療財團法人附設恩主公居家護理所"
    },
    {
      "code" : "7731110514",
      "display" : "國泰醫療財團法人附設汐止居家護理所"
    },
    {
      "code" : "8111070518",
      "display" : "衛生福利部基隆醫院附設社區復健中心"
    },
    {
      "code" : "8231060010",
      "display" : "財團法人私立台北仁濟院附設仁濟療養院新莊分院社區復健中心"
    },
    {
      "code" : "8301150512",
      "display" : "台北市康復之友協會附設孫媽媽工作坊"
    },
    {
      "code" : "8331010512",
      "display" : "社團法人新北市康復之友協會附設心橋工作坊"
    },
    {
      "code" : "8331060512",
      "display" : "社團法人新北市康復之友協會附設新莊工作坊"
    },
    {
      "code" : "8334020510",
      "display" : "宜蘭縣康復之友協會附設社區復健中心"
    },
    {
      "code" : "8401010583",
      "display" : "私立佳安康復之家"
    },
    {
      "code" : "8401010622",
      "display" : "私立松欣康復之家"
    },
    {
      "code" : "8401010640",
      "display" : "私立長青康復之家"
    },
    {
      "code" : "8401010659",
      "display" : "私立真宸康復之家"
    },
    {
      "code" : "8401020637",
      "display" : "私立如意康復之家"
    },
    {
      "code" : "8401020655",
      "display" : "私立瑞安康復之家"
    },
    {
      "code" : "8401020682",
      "display" : "私立安如康復之家"
    },
    {
      "code" : "8401020691",
      "display" : "私立圓心康復之家"
    },
    {
      "code" : "8401020708",
      "display" : "私立如意康復之家"
    },
    {
      "code" : "8401020717",
      "display" : "私立安如康復之家"
    },
    {
      "code" : "8401090521",
      "display" : "私立嘉仁康復之家"
    },
    {
      "code" : "8401090577",
      "display" : "私立崇生康復之家"
    },
    {
      "code" : "8401090586",
      "display" : "私立三原色康復之家"
    },
    {
      "code" : "8401100532",
      "display" : "私立長德康復之家"
    },
    {
      "code" : "8401100541",
      "display" : "私立長安康復之家"
    },
    {
      "code" : "8401100569",
      "display" : "私立采虹康復之家"
    },
    {
      "code" : "8401100578",
      "display" : "私立双連康復之家"
    },
    {
      "code" : "8401100667",
      "display" : "私立長育康復之家"
    },
    {
      "code" : "8401100676",
      "display" : "私立中華康復之家"
    },
    {
      "code" : "8401100685",
      "display" : "私立平安康復之家"
    },
    {
      "code" : "8401100701",
      "display" : "私立永芯康復之家"
    },
    {
      "code" : "8401100729",
      "display" : "私立南港康復之家"
    },
    {
      "code" : "8401100747",
      "display" : "私立涵宇康復之家"
    },
    {
      "code" : "8401100756",
      "display" : "私立賀健康復之家"
    },
    {
      "code" : "8401100765",
      "display" : "私立賀勝康復之家"
    },
    {
      "code" : "8401100774",
      "display" : "私立樂恬康復之家"
    },
    {
      "code" : "8401100783",
      "display" : "私立長育康復之家"
    },
    {
      "code" : "8401100792",
      "display" : "私立賀勝康復之家"
    },
    {
      "code" : "8401100809",
      "display" : "私立賀勝康復之家"
    },
    {
      "code" : "8401100818",
      "display" : "私立德耘康復之家"
    },
    {
      "code" : "8401110556",
      "display" : "私立內湖康復之家"
    },
    {
      "code" : "8401110574",
      "display" : "私立吉田康復之家"
    },
    {
      "code" : "8401110583",
      "display" : "私立好康康復之家"
    },
    {
      "code" : "8401120605",
      "display" : "私立德瑞康復之家"
    },
    {
      "code" : "8401150685",
      "display" : "私立詠康康復之家"
    },
    {
      "code" : "8401150701",
      "display" : "私立佑昇康復之家"
    },
    {
      "code" : "8401150747",
      "display" : "私立慈誠康復之家"
    },
    {
      "code" : "8401150756",
      "display" : "私立佳樺康復之家"
    },
    {
      "code" : "8401150765",
      "display" : "私立舒心康復之家"
    },
    {
      "code" : "8401150774",
      "display" : "私立金安康復之家"
    },
    {
      "code" : "8401150792",
      "display" : "私立芯苑康復之家"
    },
    {
      "code" : "8401150809",
      "display" : "私立天母康復之家"
    },
    {
      "code" : "8401160538",
      "display" : "私立協和康復之家"
    },
    {
      "code" : "8401160556",
      "display" : "私立演慈康復之家"
    },
    {
      "code" : "8401160574",
      "display" : "私立奇岩康復之家"
    },
    {
      "code" : "8401160672",
      "display" : "私立承安康復之家"
    },
    {
      "code" : "8401160681",
      "display" : "私立承宏康復之家"
    },
    {
      "code" : "8401160716",
      "display" : "私立翔宇康復之家"
    },
    {
      "code" : "8401160734",
      "display" : "私立禾康康復之家"
    },
    {
      "code" : "8401160752",
      "display" : "私立翔宇康復之家"
    },
    {
      "code" : "8401160761",
      "display" : "私立承安康復之家"
    },
    {
      "code" : "8401170516",
      "display" : "私立永青康復之家"
    },
    {
      "code" : "8401170543",
      "display" : "私立永青康復之家"
    },
    {
      "code" : "8401180567",
      "display" : "私立恩心社區復健中心"
    },
    {
      "code" : "8401180594",
      "display" : "私立德安康復之家"
    },
    {
      "code" : "8401180647",
      "display" : "私立南海康復之家"
    },
    {
      "code" : "8401180656",
      "display" : "私立源芃康復之家"
    },
    {
      "code" : "8401180665",
      "display" : "私立南海康復之家"
    },
    {
      "code" : "8401180674",
      "display" : "私立平安康復之家"
    },
    {
      "code" : "8401180683",
      "display" : "私立長安康復之家"
    },
    {
      "code" : "8401190652",
      "display" : "私立康怡康復之家"
    },
    {
      "code" : "8401200831",
      "display" : "私立青松康復之家"
    },
    {
      "code" : "8401200840",
      "display" : "私立均怡康復之家"
    },
    {
      "code" : "8401200859",
      "display" : "私立木柵康復之家"
    },
    {
      "code" : "8401200868",
      "display" : "私立莛苑康復之家"
    },
    {
      "code" : "8401200877",
      "display" : "私立長育康復之家"
    },
    {
      "code" : "8411070023",
      "display" : "暘基康復之家"
    },
    {
      "code" : "8431011048",
      "display" : "私立全安康復之家"
    },
    {
      "code" : "8431011057",
      "display" : "永吉康復之家"
    },
    {
      "code" : "8431011066",
      "display" : "祐成康復之家"
    },
    {
      "code" : "8431011093",
      "display" : "湳雅康復之家"
    },
    {
      "code" : "8431011100",
      "display" : "私立全安康復之家"
    },
    {
      "code" : "8431011119",
      "display" : "立川康復之家"
    },
    {
      "code" : "8431011128",
      "display" : "天下康復之家"
    },
    {
      "code" : "8431011137",
      "display" : "天下康復之家"
    },
    {
      "code" : "8431011146",
      "display" : "私立心晴康復之家"
    },
    {
      "code" : "8431011155",
      "display" : "私立樂米康復之家"
    },
    {
      "code" : "8431020029",
      "display" : "重安康復之家"
    },
    {
      "code" : "8431020038",
      "display" : "重光康復之家"
    },
    {
      "code" : "8431020047",
      "display" : "重安康復之家"
    },
    {
      "code" : "8431020056",
      "display" : "三重康復之家"
    },
    {
      "code" : "8431020065",
      "display" : "三重康復之家"
    },
    {
      "code" : "8431040012",
      "display" : "私立中和康復之家"
    },
    {
      "code" : "8431040021",
      "display" : "安立康復之家"
    },
    {
      "code" : "8431040049",
      "display" : "錦和康復之家"
    },
    {
      "code" : "8431040058",
      "display" : "玖久康復之家"
    },
    {
      "code" : "8431040067",
      "display" : "錦和康復之家"
    },
    {
      "code" : "8431040076",
      "display" : "安立康復之家"
    },
    {
      "code" : "8431051024",
      "display" : "私立新店怡園康復之家"
    },
    {
      "code" : "8431051060",
      "display" : "禾欣康復之家"
    },
    {
      "code" : "8431051088",
      "display" : "詠心康復之家"
    },
    {
      "code" : "8431051097",
      "display" : "安安康復之家"
    },
    {
      "code" : "8431051104",
      "display" : "安安康復之家"
    },
    {
      "code" : "8431060014",
      "display" : "鴻安康復之家"
    },
    {
      "code" : "8431060023",
      "display" : "私立佳瑩康復之家"
    },
    {
      "code" : "8431060032",
      "display" : "私立全人康復之家"
    },
    {
      "code" : "8431060078",
      "display" : "私立文德康復之家"
    },
    {
      "code" : "8431060087",
      "display" : "宏育康復之家"
    },
    {
      "code" : "8431060096",
      "display" : "禾安康復之家"
    },
    {
      "code" : "8431060103",
      "display" : "私立全人康復之家"
    },
    {
      "code" : "8431060112",
      "display" : "幸安康復之家"
    },
    {
      "code" : "8431070010",
      "display" : "喜鵲康復之家"
    },
    {
      "code" : "8431070029",
      "display" : "喜鵲康復之家"
    },
    {
      "code" : "8431090549",
      "display" : "私立安溪康復之家"
    },
    {
      "code" : "8431090576",
      "display" : "私立永丞康復之家"
    },
    {
      "code" : "8431090585",
      "display" : "私立安溪康復之家"
    },
    {
      "code" : "8431100040",
      "display" : "永安康復之家"
    },
    {
      "code" : "8431100086",
      "display" : "私立淡水康復之家"
    },
    {
      "code" : "8431110028",
      "display" : "私立汐止康復之家"
    },
    {
      "code" : "8431110037",
      "display" : "私立鹽光康復之家"
    },
    {
      "code" : "8431110055",
      "display" : "私立汐止康復之家"
    },
    {
      "code" : "8431110064",
      "display" : "私立汐止康復之家"
    },
    {
      "code" : "8431130511",
      "display" : "得揚工作坊"
    },
    {
      "code" : "8431130557",
      "display" : "私立迦百農康復之家"
    },
    {
      "code" : "8434010043",
      "display" : "慈育康復之家"
    },
    {
      "code" : "8434010052",
      "display" : "私立金山社區復健中心"
    },
    {
      "code" : "8434010061",
      "display" : "柏拉圖康復之家"
    },
    {
      "code" : "8434020512",
      "display" : "私立濟安康復之家"
    },
    {
      "code" : "8434020521",
      "display" : "宜蘭縣私立培德社區復健中心"
    },
    {
      "code" : "8501110512",
      "display" : "臺北市立聯合醫院心湖職能工作坊"
    },
    {
      "code" : "8501150525",
      "display" : "臺北市立聯合醫院福中職能工作坊"
    },
    {
      "code" : "8501160512",
      "display" : "三軍總醫院北投分院附設社區復健中心"
    },
    {
      "code" : "8501200511",
      "display" : "臺北市立聯合醫院文山職能工作坊"
    },
    {
      "code" : "8531040514",
      "display" : "衛生福利部八里療養院附設中和社區復健中心"
    },
    {
      "code" : "8531231024",
      "display" : "衛生福利部八里療養院附設八里康復之家"
    },
    {
      "code" : "8531231033",
      "display" : "衛生福利部八里療養院附設第二所康復之家"
    },
    {
      "code" : "8534070014",
      "display" : "臺北榮民總醫院員山分院附設鑄夢別苑康復之家"
    },
    {
      "code" : "8534070023",
      "display" : "臺北榮民總醫院員山分院附設社區復健中心"
    },
    {
      "code" : "8831150011",
      "display" : "新北市立五股康復之家（委託培靈醫療社團法人經營）"
    },
    {
      "code" : "9401010374",
      "display" : "民生醫事檢驗所"
    },
    {
      "code" : "9401100051",
      "display" : "啟新醫事檢驗所"
    },
    {
      "code" : "9401100097",
      "display" : "聯合醫事檢驗所"
    },
    {
      "code" : "9401101825",
      "display" : "玉山醫事檢驗所"
    },
    {
      "code" : "9401110208",
      "display" : "全康醫事檢驗所"
    },
    {
      "code" : "9401160020",
      "display" : "雙連醫事檢驗所"
    },
    {
      "code" : "9401171452",
      "display" : "和平醫事檢驗所"
    },
    {
      "code" : "9411010019",
      "display" : "中台醫事檢驗所"
    },
    {
      "code" : "9431011996",
      "display" : "中一醫事檢驗所"
    },
    {
      "code" : "9431021992",
      "display" : "三重醫事放射所"
    },
    {
      "code" : "9431031498",
      "display" : "百科醫事檢驗所"
    },
    {
      "code" : "9431040031",
      "display" : "良明醫事檢驗所"
    },
    {
      "code" : "9431040488",
      "display" : "泰安醫事檢驗所"
    },
    {
      "code" : "9431041501",
      "display" : "廣仁醫事檢驗所"
    },
    {
      "code" : "9431051203",
      "display" : "新店北新醫事檢驗所"
    },
    {
      "code" : "9431051212",
      "display" : "新店第一醫事放射所"
    },
    {
      "code" : "9431061558",
      "display" : "和興醫事檢驗所"
    },
    {
      "code" : "9431061656",
      "display" : "台美醫事檢驗所"
    },
    {
      "code" : "9431090022",
      "display" : "陽明醫事檢驗所"
    },
    {
      "code" : "9431131162",
      "display" : "聯正醫事檢驗所"
    },
    {
      "code" : "9431141113",
      "display" : "仁人醫事放射所"
    },
    {
      "code" : "9434010142",
      "display" : "正大醫事檢驗所"
    },
    {
      "code" : "9434011489",
      "display" : "勝安醫事檢驗所"
    },
    {
      "code" : "9434020184",
      "display" : "國際醫事檢驗所"
    },
    {
      "code" : "9434021636",
      "display" : "台灣醫事放射所"
    },
    {
      "code" : "HY01020010",
      "display" : "好孕助產所"
    },
    {
      "code" : "HY31060022",
      "display" : "禾頤助產所"
    },
    {
      "code" : "HY34090013",
      "display" : "貝斯特助產所"
    },
    {
      "code" : "JY01010089",
      "display" : "立人醫事檢驗所"
    },
    {
      "code" : "JY01010098",
      "display" : "民生醫事檢驗所"
    },
    {
      "code" : "JY01020058",
      "display" : "艾所醫事檢驗所"
    },
    {
      "code" : "JY01020110",
      "display" : "高端醫事檢驗所"
    },
    {
      "code" : "JY01020147",
      "display" : "大安聯合醫事檢驗所"
    },
    {
      "code" : "JY01020174",
      "display" : "健安聯醫事檢驗所"
    },
    {
      "code" : "JY01020209",
      "display" : "高端醫事檢驗所"
    },
    {
      "code" : "JY01100079",
      "display" : "長春醫事檢驗所"
    },
    {
      "code" : "JY01100122",
      "display" : "麗寶醫事檢驗所"
    },
    {
      "code" : "JY01110057",
      "display" : "訊聯醫事檢驗所"
    },
    {
      "code" : "JY01110075",
      "display" : "亞杏醫事檢驗所"
    },
    {
      "code" : "JY01110119",
      "display" : "益揚醫事檢驗所"
    },
    {
      "code" : "JY01110217",
      "display" : "益揚醫事檢驗所"
    },
    {
      "code" : "JY01110235",
      "display" : "辰熙醫事檢驗所"
    },
    {
      "code" : "JY01180059",
      "display" : "杏聯醫事檢驗所"
    },
    {
      "code" : "JY01180077",
      "display" : "慧智醫事檢驗所"
    },
    {
      "code" : "JY01180095",
      "display" : "詠捷醫事檢驗所"
    },
    {
      "code" : "JY01190028",
      "display" : "吉祥醫事檢驗所"
    },
    {
      "code" : "JY01190082",
      "display" : "詠捷醫事檢驗所"
    },
    {
      "code" : "JY01200010",
      "display" : "台灣生醫醫事檢驗所"
    },
    {
      "code" : "JY31010104",
      "display" : "普城醫事檢驗所"
    },
    {
      "code" : "JY31010159",
      "display" : "第一醫事檢驗所"
    },
    {
      "code" : "JY31020066",
      "display" : "健詮醫事檢驗所"
    },
    {
      "code" : "JY31030035",
      "display" : "欣奕醫事檢驗所"
    },
    {
      "code" : "JY31040040",
      "display" : "新隆醫事檢驗所"
    },
    {
      "code" : "JY31040068",
      "display" : "永緒醫事檢驗所"
    },
    {
      "code" : "JY31040077",
      "display" : "台灣優品醫事檢驗所"
    },
    {
      "code" : "JY31040086",
      "display" : "台灣優品醫事檢驗所"
    },
    {
      "code" : "JY31060088",
      "display" : "亞東醫事檢驗所"
    },
    {
      "code" : "JY31060104",
      "display" : "合森醫事檢驗所"
    },
    {
      "code" : "JY31060113",
      "display" : "鎧越醫事檢驗所"
    },
    {
      "code" : "JY31060122",
      "display" : "日康醫事檢驗所"
    },
    {
      "code" : "JY31070011",
      "display" : "陽光醫事檢驗所"
    },
    {
      "code" : "JY31090013",
      "display" : "博世醫事檢驗所"
    },
    {
      "code" : "JY31110047",
      "display" : "知愛分子醫事檢驗所"
    },
    {
      "code" : "JY31130049",
      "display" : "桀新醫事檢驗所"
    },
    {
      "code" : "JY34010017",
      "display" : "宜禾醫事檢驗所"
    },
    {
      "code" : "JY34020013",
      "display" : "鴻揚醫事檢驗所"
    },
    {
      "code" : "JY34020031",
      "display" : "鴻揚醫事檢驗所"
    },
    {
      "code" : "JY34020040",
      "display" : "東興醫事檢驗所"
    },
    {
      "code" : "JY34020059",
      "display" : "東興醫事檢驗所"
    },
    {
      "code" : "JY90010037",
      "display" : "現代醫事檢驗所"
    },
    {
      "code" : "JY90010046",
      "display" : "中央醫事檢驗所"
    },
    {
      "code" : "QY01010157",
      "display" : "永業物理治療所"
    },
    {
      "code" : "QY01010228",
      "display" : "永業物理治療所"
    },
    {
      "code" : "QY01180065",
      "display" : "暐淩居家物理治療所"
    },
    {
      "code" : "QY31010085",
      "display" : "城市健康物理治療所"
    },
    {
      "code" : "QY31010110",
      "display" : "城市健康物理治療所"
    },
    {
      "code" : "QY31020036",
      "display" : "集勇物理治療所"
    },
    {
      "code" : "QY31040056",
      "display" : "向安物理治療所"
    },
    {
      "code" : "QY31120013",
      "display" : "新北市瑞芳區衛生所附設物理治療所"
    },
    {
      "code" : "QY31130019",
      "display" : "同仁物理治療所"
    },
    {
      "code" : "QY31200016",
      "display" : "新北市坪林區衛生所附設物理治療所"
    },
    {
      "code" : "QY31210012",
      "display" : "新北市三芝區衛生所附設物理治療所"
    },
    {
      "code" : "QY31240010",
      "display" : "新北市平溪區衛生所附設物理治療所"
    },
    {
      "code" : "QY31250025",
      "display" : "新北市雙溪區衛生所附設物理治療所"
    },
    {
      "code" : "QY31250034",
      "display" : "新北市雙溪區衛生所附設物理治療所"
    },
    {
      "code" : "QY31260012",
      "display" : "新北市貢寮區衛生所附設物理治療所"
    },
    {
      "code" : "QY31280014",
      "display" : "新北市萬里區衛生所附設物理治療所"
    },
    {
      "code" : "QY34010050",
      "display" : "臻宸物理治療所"
    },
    {
      "code" : "QY34010078",
      "display" : "永春物理治療所"
    },
    {
      "code" : "RY01010050",
      "display" : "荷普職能治療所"
    },
    {
      "code" : "RY01160037",
      "display" : "稻香職能治療所-委託臺北榮民總醫院經營管理"
    },
    {
      "code" : "RY01160046",
      "display" : "安安優腦職能治療所"
    },
    {
      "code" : "RY01180048",
      "display" : "安安優腦古亭職能治療所"
    },
    {
      "code" : "RY01180057",
      "display" : "大心居家職能治療所"
    },
    {
      "code" : "RY31010059",
      "display" : "城市健康職能治療所"
    },
    {
      "code" : "RY31060040",
      "display" : "宏兒職能治療所"
    },
    {
      "code" : "SY31040012",
      "display" : "北大醫事放射所"
    },
    {
      "code" : "0132010014",
      "display" : "衛生福利部桃園醫院"
    },
    {
      "code" : "0132010023",
      "display" : "衛生福利部桃園療養院"
    },
    {
      "code" : "0132110519",
      "display" : "衛生福利部桃園醫院新屋分院"
    },
    {
      "code" : "0135010016",
      "display" : "衛生福利部苗栗醫院"
    },
    {
      "code" : "0412040012",
      "display" : "國立臺灣大學醫學院附設醫院新竹臺大分院新竹醫院"
    },
    {
      "code" : "0433050018",
      "display" : "國立臺灣大學醫學院附設醫院新竹臺大分院生醫醫院"
    },
    {
      "code" : "0512040014",
      "display" : "國軍桃園總醫院新竹分院附設民眾診療服務處"
    },
    {
      "code" : "0532090029",
      "display" : "國軍桃園總醫院附設民眾診療服務處"
    },
    {
      "code" : "0632010014",
      "display" : "臺北榮民總醫院桃園分院"
    },
    {
      "code" : "0633030010",
      "display" : "臺北榮民總醫院新竹分院"
    },
    {
      "code" : "0912040012",
      "display" : "平和醫療社團法人和平醫院"
    },
    {
      "code" : "0932020016",
      "display" : "宏其醫療社團法人宏其婦幼醫院"
    },
    {
      "code" : "0932020025",
      "display" : "天成醫療社團法人天晟醫院"
    },
    {
      "code" : "0932020034",
      "display" : "新國民醫療社團法人新國民醫院"
    },
    {
      "code" : "0933010014",
      "display" : "培靈醫療社團法人關西醫院"
    },
    {
      "code" : "0933050018",
      "display" : "東元醫療社團法人東元綜合醫院"
    },
    {
      "code" : "0933050036",
      "display" : "竹北新仁醫療社團法人新仁醫院"
    },
    {
      "code" : "0935010012",
      "display" : "梓榮醫療社團法人弘大醫院"
    },
    {
      "code" : "0935010021",
      "display" : "大千醫療社團法人南勢醫院"
    },
    {
      "code" : "0935020027",
      "display" : "李綜合醫療社團法人苑裡李綜合醫院"
    },
    {
      "code" : "1101010012",
      "display" : "長庚醫療財團法人台北長庚紀念醫院"
    },
    {
      "code" : "1112010519",
      "display" : "台灣基督長老教會馬偕醫療財團法人新竹馬偕紀念醫院"
    },
    {
      "code" : "1112010528",
      "display" : "國泰醫療財團法人新竹國泰綜合醫院"
    },
    {
      "code" : "1112010537",
      "display" : "新竹市立馬偕兒童醫院(委託台灣基督長老教會馬偕醫療財團法人興"
    },
    {
      "code" : "1132010024",
      "display" : "沙爾德聖保祿修女會醫療財團法人聖保祿醫院"
    },
    {
      "code" : "1132070011",
      "display" : "長庚醫療財團法人林口長庚紀念醫院"
    },
    {
      "code" : "1132071036",
      "display" : "長庚醫療財團法人桃園長庚紀念醫院"
    },
    {
      "code" : "1133060019",
      "display" : "天主教仁慈醫療財團法人仁慈醫院"
    },
    {
      "code" : "1135050020",
      "display" : "為恭醫療財團法人為恭紀念醫院"
    },
    {
      "code" : "1135130014",
      "display" : "佛教慈濟醫療財團法人三義慈濟中醫醫院"
    },
    {
      "code" : "1333050017",
      "display" : "中國醫藥大學新竹附設醫院"
    },
    {
      "code" : "1412040022",
      "display" : "財團法人台灣省私立桃園仁愛之家附設新竹新生醫院"
    },
    {
      "code" : "1435010013",
      "display" : "財團法人臺灣省私立桃園仁愛之家附設苗栗新生醫院"
    },
    {
      "code" : "1512011185",
      "display" : "南門綜合醫院"
    },
    {
      "code" : "1512040051",
      "display" : "新中興醫院"
    },
    {
      "code" : "1532010013",
      "display" : "振生醫院"
    },
    {
      "code" : "1532010120",
      "display" : "聯新國際醫院桃新分院"
    },
    {
      "code" : "1532011154",
      "display" : "敏盛綜合醫院"
    },
    {
      "code" : "1532011163",
      "display" : "德仁醫院"
    },
    {
      "code" : "1532011172",
      "display" : "桃園秉坤婦幼醫院"
    },
    {
      "code" : "1532020215",
      "display" : "祐民醫院"
    },
    {
      "code" : "1532021285",
      "display" : "承安醫院"
    },
    {
      "code" : "1532021310",
      "display" : "仁祥醫院"
    },
    {
      "code" : "1532021338",
      "display" : "中壢長榮醫院"
    },
    {
      "code" : "1532021365",
      "display" : "華揚醫院"
    },
    {
      "code" : "1532021374",
      "display" : "長慎醫院"
    },
    {
      "code" : "1532021383",
      "display" : "懷寧醫院"
    },
    {
      "code" : "1532021392",
      "display" : "中美醫院"
    },
    {
      "code" : "1532021418",
      "display" : "天祥醫院"
    },
    {
      "code" : "1532040039",
      "display" : "天成醫院"
    },
    {
      "code" : "1532040066",
      "display" : "怡仁綜合醫院"
    },
    {
      "code" : "1532060031",
      "display" : "居善醫院"
    },
    {
      "code" : "1532061065",
      "display" : "大園敏盛醫院"
    },
    {
      "code" : "1532070019",
      "display" : "大明醫院"
    },
    {
      "code" : "1532091081",
      "display" : "龍潭敏盛醫院"
    },
    {
      "code" : "1532100012",
      "display" : "新永和醫院"
    },
    {
      "code" : "1532100049",
      "display" : "聯新國際醫院"
    },
    {
      "code" : "1532101091",
      "display" : "陽明醫院"
    },
    {
      "code" : "1532101108",
      "display" : "宋俊宏婦幼醫院"
    },
    {
      "code" : "1532101117",
      "display" : "秉坤婦幼醫院"
    },
    {
      "code" : "1533030028",
      "display" : "林醫院"
    },
    {
      "code" : "1533030046",
      "display" : "竹信醫院"
    },
    {
      "code" : "1533051063",
      "display" : "大安醫院"
    },
    {
      "code" : "1533051072",
      "display" : "新仁醫院"
    },
    {
      "code" : "1535010024",
      "display" : "協和醫院"
    },
    {
      "code" : "1535010051",
      "display" : "大千綜合醫院"
    },
    {
      "code" : "1535031041",
      "display" : "通霄光田醫院"
    },
    {
      "code" : "1535040068",
      "display" : "慈祐醫院"
    },
    {
      "code" : "1535040086",
      "display" : "大眾醫院"
    },
    {
      "code" : "1535051178",
      "display" : "重光醫院"
    },
    {
      "code" : "1535051196",
      "display" : "崇仁醫院"
    },
    {
      "code" : "1535081078",
      "display" : "大順醫院"
    },
    {
      "code" : "2312010014",
      "display" : "新竹市東區衛生所"
    },
    {
      "code" : "2312041028",
      "display" : "新竹市北區衛生所"
    },
    {
      "code" : "2312050018",
      "display" : "新竹市香山衛生所"
    },
    {
      "code" : "2332010010",
      "display" : "桃園市桃園區衛生所"
    },
    {
      "code" : "2332020016",
      "display" : "桃園市中壢區衛生所"
    },
    {
      "code" : "2332030012",
      "display" : "桃園市大溪區衛生所"
    },
    {
      "code" : "2332040018",
      "display" : "桃園市楊梅區衛生所"
    },
    {
      "code" : "2332050014",
      "display" : "桃園市蘆竹區衛生所"
    },
    {
      "code" : "2332060010",
      "display" : "桃園市大園區衛生所"
    },
    {
      "code" : "2332070016",
      "display" : "桃園市龜山區衛生所"
    },
    {
      "code" : "2332080012",
      "display" : "桃園市八德區衛生所"
    },
    {
      "code" : "2332080021",
      "display" : "桃園市婦幼衛生所"
    },
    {
      "code" : "2332090018",
      "display" : "桃園市龍潭區衛生所"
    },
    {
      "code" : "2332100019",
      "display" : "桃園市平鎮區衛生所"
    },
    {
      "code" : "2332110015",
      "display" : "桃園市新屋區衛生所"
    },
    {
      "code" : "2332120011",
      "display" : "桃園市觀音區衛生所"
    },
    {
      "code" : "2332130017",
      "display" : "桃園市復興區衛生所"
    },
    {
      "code" : "2333010014",
      "display" : "新竹縣關西鎮衛生所"
    },
    {
      "code" : "2333020010",
      "display" : "新竹縣新埔鎮衛生所"
    },
    {
      "code" : "2333030016",
      "display" : "新竹縣竹東鎮衛生所"
    },
    {
      "code" : "2333050018",
      "display" : "新竹縣竹北市衛生所"
    },
    {
      "code" : "2333060014",
      "display" : "新竹縣湖口鄉衛生所"
    },
    {
      "code" : "2333070010",
      "display" : "新竹縣橫山鄉衛生所"
    },
    {
      "code" : "2333080016",
      "display" : "新竹縣新豐鄉衛生所"
    },
    {
      "code" : "2333090012",
      "display" : "新竹縣芎林鄉衛生所"
    },
    {
      "code" : "2333100013",
      "display" : "新竹縣寶山鄉衛生所"
    },
    {
      "code" : "2333110019",
      "display" : "新竹縣北埔鄉衛生所"
    },
    {
      "code" : "2333120015",
      "display" : "新竹縣峨眉鄉衛生所"
    },
    {
      "code" : "2333130011",
      "display" : "新竹縣尖石鄉衛生所"
    },
    {
      "code" : "2333140017",
      "display" : "新竹縣五峰鄉衛生所"
    },
    {
      "code" : "2335010012",
      "display" : "苗栗縣苗栗市衛生所"
    },
    {
      "code" : "2335020018",
      "display" : "苗栗縣苑裡鎮衛生所"
    },
    {
      "code" : "2335030014",
      "display" : "苗栗縣通霄鎮衛生所"
    },
    {
      "code" : "2335040010",
      "display" : "苗栗縣竹南鎮衛生所"
    },
    {
      "code" : "2335050016",
      "display" : "苗栗縣頭份市衛生所"
    },
    {
      "code" : "2335060012",
      "display" : "苗栗縣後龍鎮衛生所"
    },
    {
      "code" : "2335070018",
      "display" : "苗栗縣卓蘭鎮衛生所"
    },
    {
      "code" : "2335080014",
      "display" : "苗栗縣大湖鄉衛生所"
    },
    {
      "code" : "2335090010",
      "display" : "苗栗縣公館鄉衛生所"
    },
    {
      "code" : "2335100011",
      "display" : "苗栗縣銅鑼鄉衛生所"
    },
    {
      "code" : "2335110017",
      "display" : "苗栗縣南庄鄉衛生所"
    },
    {
      "code" : "2335120013",
      "display" : "苗栗縣頭屋鄉衛生所"
    },
    {
      "code" : "2335130019",
      "display" : "苗栗縣三義鄉衛生所"
    },
    {
      "code" : "2335140015",
      "display" : "苗栗縣西湖鄉衛生所"
    },
    {
      "code" : "2335150011",
      "display" : "苗栗縣造橋鄉衛生所"
    },
    {
      "code" : "2335160017",
      "display" : "苗栗縣三灣鄉衛生所"
    },
    {
      "code" : "2335170013",
      "display" : "苗栗縣獅潭鄉衛生所"
    },
    {
      "code" : "2335180019",
      "display" : "苗栗縣泰安鄉衛生所"
    },
    {
      "code" : "2412010534",
      "display" : "清華大學附設診所(委託台北榮民總醫院新竹分院經營)"
    },
    {
      "code" : "2712040010",
      "display" : "新竹榮民之家醫務室"
    },
    {
      "code" : "2732080018",
      "display" : "桃園榮民之家醫務室"
    },
    {
      "code" : "2732080038",
      "display" : "八德榮譽國民之家醫務室"
    },
    {
      "code" : "2735010029",
      "display" : "台灣中油探採診所"
    },
    {
      "code" : "3332070017",
      "display" : "財團法人銘傳大學附設醫務室"
    },
    {
      "code" : "3432020064",
      "display" : "日月光半導體製造股份有限公司中壢分公司醫務室"
    },
    {
      "code" : "3432041143",
      "display" : "中華汽車工業股份有限公司醫務室"
    },
    {
      "code" : "3432051176",
      "display" : "華通電腦股份有限公司附設員工診所"
    },
    {
      "code" : "3432060513",
      "display" : "聯新國際醫院桃園國際機場醫療中心"
    },
    {
      "code" : "3432072022",
      "display" : "台灣中油股份有限公司煉製事業部桃園煉油廠員工診所"
    },
    {
      "code" : "3432072077",
      "display" : "佳世達科技股份有限公司附設醫務室"
    },
    {
      "code" : "3432100558",
      "display" : "技嘉科技股份有限公司附設員工診所"
    },
    {
      "code" : "3435131055",
      "display" : "裕隆汽車製造股份有限公司員工診所"
    },
    {
      "code" : "3512010019",
      "display" : "王外科內科聯合診所"
    },
    {
      "code" : "3512010064",
      "display" : "吳振福眼科診所"
    },
    {
      "code" : "3512010073",
      "display" : "深潭耳鼻喉科診所"
    },
    {
      "code" : "3512010108",
      "display" : "傅小兒科診所"
    },
    {
      "code" : "3512010126",
      "display" : "林安復耳鼻喉科診所"
    },
    {
      "code" : "3512010135",
      "display" : "林啓銘內科小兒科診所"
    },
    {
      "code" : "3512010144",
      "display" : "楊進樑婦產科診所"
    },
    {
      "code" : "3512010233",
      "display" : "張內科小兒科診所"
    },
    {
      "code" : "3512010288",
      "display" : "吳憲一內科小兒科診所"
    },
    {
      "code" : "3512010528",
      "display" : "林芳勝診所"
    },
    {
      "code" : "3512010617",
      "display" : "簡小兒科內科診所"
    },
    {
      "code" : "3512010653",
      "display" : "陳耳鼻喉科診所"
    },
    {
      "code" : "3512010724",
      "display" : "范診所"
    },
    {
      "code" : "3512010751",
      "display" : "倪耳鼻喉科診所"
    },
    {
      "code" : "3512010760",
      "display" : "上明眼科診所"
    },
    {
      "code" : "3512010822",
      "display" : "邱診所"
    },
    {
      "code" : "3512010886",
      "display" : "莊峻鏞內科診所"
    },
    {
      "code" : "3512010902",
      "display" : "蘇銘煜診所"
    },
    {
      "code" : "3512010911",
      "display" : "林獻雄診所"
    },
    {
      "code" : "3512010939",
      "display" : "江婦產科診所"
    },
    {
      "code" : "3512010966",
      "display" : "長庚婦產科診所"
    },
    {
      "code" : "3512010975",
      "display" : "吳國治眼科診所"
    },
    {
      "code" : "3512010984",
      "display" : "羅興邦家庭醫學科診所"
    },
    {
      "code" : "3512010993",
      "display" : "永美陳志閔診所"
    },
    {
      "code" : "3512011007",
      "display" : "蔡文進小兒科診所"
    },
    {
      "code" : "3512011016",
      "display" : "和平婦產科診所"
    },
    {
      "code" : "3512011034",
      "display" : "吳廷臣診所"
    },
    {
      "code" : "3512011052",
      "display" : "欣安診所"
    },
    {
      "code" : "3512011070",
      "display" : "石銘煌診所"
    },
    {
      "code" : "3512011105",
      "display" : "李文華診所"
    },
    {
      "code" : "3512011123",
      "display" : "永堅眼科診所"
    },
    {
      "code" : "3512011132",
      "display" : "彭耳鼻喉科診所"
    },
    {
      "code" : "3512011150",
      "display" : "廖明厚小兒科診所"
    },
    {
      "code" : "3512011169",
      "display" : "黃耳鼻喉科診所"
    },
    {
      "code" : "3512011187",
      "display" : "謝碧祥診所"
    },
    {
      "code" : "3512011196",
      "display" : "普惠耳鼻喉科"
    },
    {
      "code" : "3512011221",
      "display" : "吳雨圭診所"
    },
    {
      "code" : "3512011230",
      "display" : "范揚峰骨科診所"
    },
    {
      "code" : "3512011267",
      "display" : "邱國華耳鼻喉科診所"
    },
    {
      "code" : "3512011276",
      "display" : "安慎診所"
    },
    {
      "code" : "3512011285",
      "display" : "恩慈診所"
    },
    {
      "code" : "3512011329",
      "display" : "葉佳全小兒科診所"
    },
    {
      "code" : "3512011356",
      "display" : "英慈耳鼻喉科診所"
    },
    {
      "code" : "3512011418",
      "display" : "林煜朗耳鼻喉科診所"
    },
    {
      "code" : "3512011427",
      "display" : "江秀蓉診所"
    },
    {
      "code" : "3512011436",
      "display" : "蘇釗人診所"
    },
    {
      "code" : "3512011445",
      "display" : "興世紀婦產科診所"
    },
    {
      "code" : "3512012479",
      "display" : "蘇育賢小兒科診所"
    },
    {
      "code" : "3512012595",
      "display" : "送子鳥診所"
    },
    {
      "code" : "3512012700",
      "display" : "江美麗婦產科診所"
    },
    {
      "code" : "3512012728",
      "display" : "啟恩小兒科診所"
    },
    {
      "code" : "3512012737",
      "display" : "陳志宏眼科診所"
    },
    {
      "code" : "3512012773",
      "display" : "林正弘小兒科診所"
    },
    {
      "code" : "3512012817",
      "display" : "陳志鴻泌尿科診所"
    },
    {
      "code" : "3512012862",
      "display" : "建功骨科外科診所"
    },
    {
      "code" : "3512012880",
      "display" : "大學眼科診所"
    },
    {
      "code" : "3512012899",
      "display" : "慈佑小兒科診所"
    },
    {
      "code" : "3512012906",
      "display" : "趙永康小兒科診所"
    },
    {
      "code" : "3512012924",
      "display" : "優生婦產科診所"
    },
    {
      "code" : "3512012942",
      "display" : "曾鼎昌整形外科診所"
    },
    {
      "code" : "3512012951",
      "display" : "成美整形外科診所"
    },
    {
      "code" : "3512013001",
      "display" : "闕弘昌復健科診所"
    },
    {
      "code" : "3512013010",
      "display" : "城佑耳鼻喉科診所"
    },
    {
      "code" : "3512013047",
      "display" : "陳兆英內科心臟科診所"
    },
    {
      "code" : "3512013056",
      "display" : "林冠賢皮膚科診所"
    },
    {
      "code" : "3512013065",
      "display" : "惠民真平內科外科聯合診所"
    },
    {
      "code" : "3512013074",
      "display" : "能清安欣診所"
    },
    {
      "code" : "3512013083",
      "display" : "徐文錦眼科診所"
    },
    {
      "code" : "3512013092",
      "display" : "康復診所"
    },
    {
      "code" : "3512013145",
      "display" : "成民內科診所"
    },
    {
      "code" : "3512013154",
      "display" : "林祺彬皮膚科診所"
    },
    {
      "code" : "3512013163",
      "display" : "廖健仲胃腸肝膽內科診所"
    },
    {
      "code" : "3512013172",
      "display" : "何耳鼻喉科診所"
    },
    {
      "code" : "3512013181",
      "display" : "林正修診所"
    },
    {
      "code" : "3512013216",
      "display" : "麗池診所"
    },
    {
      "code" : "3512013225",
      "display" : "賴閔宦小兒科診所"
    },
    {
      "code" : "3512013314",
      "display" : "阮皮膚科診所"
    },
    {
      "code" : "3512013332",
      "display" : "秦登峰診所"
    },
    {
      "code" : "3512013369",
      "display" : "小太陽耳鼻喉科診所"
    },
    {
      "code" : "3512013378",
      "display" : "茱麗婦產科診所"
    },
    {
      "code" : "3512013384",
      "display" : "小行星親子診所"
    },
    {
      "code" : "3512013396",
      "display" : "余鄭錦峰復健診所"
    },
    {
      "code" : "3512013449",
      "display" : "禾康耳鼻喉科診所"
    },
    {
      "code" : "3512013467",
      "display" : "欣欣診所"
    },
    {
      "code" : "3512013485",
      "display" : "康德診所"
    },
    {
      "code" : "3512013494",
      "display" : "松青診所"
    },
    {
      "code" : "3512013547",
      "display" : "力晶診所"
    },
    {
      "code" : "3512013556",
      "display" : "愛生美皮膚科診所"
    },
    {
      "code" : "3512013565",
      "display" : "億安診所"
    },
    {
      "code" : "3512013574",
      "display" : "晶亮眼科診所"
    },
    {
      "code" : "3512013636",
      "display" : "宏偉婦幼診所"
    },
    {
      "code" : "3512013645",
      "display" : "謝德貴兒童診所"
    },
    {
      "code" : "3512013654",
      "display" : "佳醫診所"
    },
    {
      "code" : "3512013663",
      "display" : "雅得麗生活診所"
    },
    {
      "code" : "3512013681",
      "display" : "新竹科學工業園區員工診所"
    },
    {
      "code" : "3512013716",
      "display" : "健新耳鼻喉科診所"
    },
    {
      "code" : "3512013734",
      "display" : "綺色佳診所"
    },
    {
      "code" : "3512013761",
      "display" : "上水透析診所"
    },
    {
      "code" : "3512013798",
      "display" : "林亮辰皮膚專科診所"
    },
    {
      "code" : "3512013805",
      "display" : "陽光診所"
    },
    {
      "code" : "3512013850",
      "display" : "安禾診所"
    },
    {
      "code" : "3512013869",
      "display" : "安禾安新診所"
    },
    {
      "code" : "3512013887",
      "display" : "上允耳鼻喉科診所"
    },
    {
      "code" : "3512013903",
      "display" : "漢杰小兒科診所"
    },
    {
      "code" : "3512013912",
      "display" : "林君怡小兒專科診所"
    },
    {
      "code" : "3512013949",
      "display" : "員康診所"
    },
    {
      "code" : "3512013976",
      "display" : "陳雲濤眼科診所"
    },
    {
      "code" : "3512013985",
      "display" : "聖興復健診所"
    },
    {
      "code" : "3512014017",
      "display" : "歆美皮診所"
    },
    {
      "code" : "3512014026",
      "display" : "馬大元診所"
    },
    {
      "code" : "3512014044",
      "display" : "關心診所"
    },
    {
      "code" : "3512014053",
      "display" : "遠見眼科診所"
    },
    {
      "code" : "3512014062",
      "display" : "曾嘉慶內科診所"
    },
    {
      "code" : "3512014080",
      "display" : "榮輝診所"
    },
    {
      "code" : "3512014099",
      "display" : "平衡身心診所"
    },
    {
      "code" : "3512014106",
      "display" : "欣悅光診所"
    },
    {
      "code" : "3512014115",
      "display" : "昇安診所"
    },
    {
      "code" : "3512014124",
      "display" : "小森林兒科診所"
    },
    {
      "code" : "3512014133",
      "display" : "晨心兒科診所"
    },
    {
      "code" : "3512014160",
      "display" : "柏廷耳鼻喉科診所"
    },
    {
      "code" : "3512014188",
      "display" : "恆心診所"
    },
    {
      "code" : "3512014197",
      "display" : "親禾身心診所"
    },
    {
      "code" : "3512014204",
      "display" : "杏光骨科診所"
    },
    {
      "code" : "3512014213",
      "display" : "生昇診所"
    },
    {
      "code" : "3512014222",
      "display" : "康田親子診所"
    },
    {
      "code" : "3512014231",
      "display" : "杏芙診所"
    },
    {
      "code" : "3512014240",
      "display" : "模力再生診所"
    },
    {
      "code" : "3512014259",
      "display" : "徐健倫親子診所"
    },
    {
      "code" : "3512014268",
      "display" : "聊癒之森身心診所"
    },
    {
      "code" : "3512014286",
      "display" : "宸新復健科診所"
    },
    {
      "code" : "3512014302",
      "display" : "恢衡耳鼻喉診所"
    },
    {
      "code" : "3512014320",
      "display" : "翰林耳鼻喉科診所"
    },
    {
      "code" : "3512014339",
      "display" : "拉菲爾健康管理診所"
    },
    {
      "code" : "3512014357",
      "display" : "康百事診所"
    },
    {
      "code" : "3512014428",
      "display" : "美平方健康美學診所"
    },
    {
      "code" : "3512014455",
      "display" : "適采復健科診所"
    },
    {
      "code" : "3512014473",
      "display" : "沐橙診所"
    },
    {
      "code" : "3512014482",
      "display" : "有家親子診所"
    },
    {
      "code" : "3512014517",
      "display" : "耘新復健科診所"
    },
    {
      "code" : "3512014526",
      "display" : "森和診所"
    },
    {
      "code" : "3512014535",
      "display" : "晨安親子診所"
    },
    {
      "code" : "3512040062",
      "display" : "蔡景銓內科小兒科診所"
    },
    {
      "code" : "3512040124",
      "display" : "杏春內科小兒科診所"
    },
    {
      "code" : "3512040295",
      "display" : "葉冠東婦產科診所"
    },
    {
      "code" : "3512040348",
      "display" : "蕭子青小兒科診所"
    },
    {
      "code" : "3512040446",
      "display" : "邊子揚診所"
    },
    {
      "code" : "3512040455",
      "display" : "林聖旦耳鼻喉科診所"
    },
    {
      "code" : "3512040473",
      "display" : "鄭眼科診所"
    },
    {
      "code" : "3512040517",
      "display" : "陳建銘婦產科診所"
    },
    {
      "code" : "3512040599",
      "display" : "劉復國診所"
    },
    {
      "code" : "3512040615",
      "display" : "陳吳坤骨科診所"
    },
    {
      "code" : "3512040651",
      "display" : "佳崋診所"
    },
    {
      "code" : "3512040660",
      "display" : "郭榮暉診所"
    },
    {
      "code" : "3512040697",
      "display" : "楊耳鼻喉科診所"
    },
    {
      "code" : "3512040777",
      "display" : "簡志澔小兒科診所"
    },
    {
      "code" : "3512040795",
      "display" : "張辰光復健科診所"
    },
    {
      "code" : "3512040893",
      "display" : "張錚小兒科診所"
    },
    {
      "code" : "3512040955",
      "display" : "台安耳鼻喉科診所"
    },
    {
      "code" : "3512040964",
      "display" : "李賢祺診所"
    },
    {
      "code" : "3512040973",
      "display" : "保元診所"
    },
    {
      "code" : "3512040991",
      "display" : "惠生婦產科診所"
    },
    {
      "code" : "3512042075",
      "display" : "陳達文內科診所"
    },
    {
      "code" : "3512042146",
      "display" : "李育奇診所"
    },
    {
      "code" : "3512042208",
      "display" : "陳君毅小兒科診所"
    },
    {
      "code" : "3512042226",
      "display" : "丁眼科診所"
    },
    {
      "code" : "3512042235",
      "display" : "大鵬復健科診所"
    },
    {
      "code" : "3512042244",
      "display" : "祐庭耳鼻喉科診所"
    },
    {
      "code" : "3512042253",
      "display" : "健群耳鼻喉科診所"
    },
    {
      "code" : "3512042262",
      "display" : "莊士易內科心臟內科診所"
    },
    {
      "code" : "3512042271",
      "display" : "英群莊皮膚科診所"
    },
    {
      "code" : "3512042280",
      "display" : "陳萬龍診所"
    },
    {
      "code" : "3512042315",
      "display" : "實和診所"
    },
    {
      "code" : "3512042351",
      "display" : "祥仁內科診所"
    },
    {
      "code" : "3512042502",
      "display" : "長福診所"
    },
    {
      "code" : "3512042520",
      "display" : "陳志成耳鼻喉科診所"
    },
    {
      "code" : "3512042539",
      "display" : "新朝診所"
    },
    {
      "code" : "3512042557",
      "display" : "廖文瑜皮膚科診所"
    },
    {
      "code" : "3512042584",
      "display" : "林正凱好孕診所"
    },
    {
      "code" : "3512042593",
      "display" : "杏慈婦產科診所"
    },
    {
      "code" : "3512042600",
      "display" : "林敬堯親子診所"
    },
    {
      "code" : "3512042628",
      "display" : "泰安診所"
    },
    {
      "code" : "3512042646",
      "display" : "麗明眼科診所"
    },
    {
      "code" : "3512042664",
      "display" : "宏仁診所"
    },
    {
      "code" : "3512042753",
      "display" : "民安診所"
    },
    {
      "code" : "3512042762",
      "display" : "和泰耳鼻喉科診所"
    },
    {
      "code" : "3512042780",
      "display" : "莊乾信內科診所"
    },
    {
      "code" : "3512042815",
      "display" : "宏安骨科診所"
    },
    {
      "code" : "3512042824",
      "display" : "安慎健康管理診所"
    },
    {
      "code" : "3512042860",
      "display" : "舜天診所"
    },
    {
      "code" : "3512042879",
      "display" : "杏保醫網信霖診所"
    },
    {
      "code" : "3512042897",
      "display" : "安竹診所"
    },
    {
      "code" : "3512042904",
      "display" : "立達診所"
    },
    {
      "code" : "3512042913",
      "display" : "陳福祥診所"
    },
    {
      "code" : "3512042931",
      "display" : "恆悅診所"
    },
    {
      "code" : "3512050111",
      "display" : "恩輝診所"
    },
    {
      "code" : "3512050120",
      "display" : "龔耳鼻喉科診所"
    },
    {
      "code" : "3512051181",
      "display" : "健安診所"
    },
    {
      "code" : "3512051243",
      "display" : "全興診所"
    },
    {
      "code" : "3512051332",
      "display" : "新美診所"
    },
    {
      "code" : "3512051369",
      "display" : "元培健康診所"
    },
    {
      "code" : "3512051378",
      "display" : "德康診所"
    },
    {
      "code" : "3512051387",
      "display" : "嘉軒耳鼻喉科診所"
    },
    {
      "code" : "3512051396",
      "display" : "君和內科診所"
    },
    {
      "code" : "3512051403",
      "display" : "金正順診所"
    },
    {
      "code" : "3532010060",
      "display" : "陳俊宏婦產科診所"
    },
    {
      "code" : "3532010104",
      "display" : "忠央診所"
    },
    {
      "code" : "3532010140",
      "display" : "崇愛診所"
    },
    {
      "code" : "3532010220",
      "display" : "南門張小兒科內科診所"
    },
    {
      "code" : "3532010239",
      "display" : "良譽小兒科診所"
    },
    {
      "code" : "3532010275",
      "display" : "賴博志診所"
    },
    {
      "code" : "3532010293",
      "display" : "游賜海婦產科診所"
    },
    {
      "code" : "3532010300",
      "display" : "張德成小兒科內科診所"
    },
    {
      "code" : "3532010337",
      "display" : "林振銘小兒科診所"
    },
    {
      "code" : "3532010382",
      "display" : "沈俊男內科小兒科診所"
    },
    {
      "code" : "3532010435",
      "display" : "張外科診所"
    },
    {
      "code" : "3532010444",
      "display" : "許家庭醫學科診所"
    },
    {
      "code" : "3532010515",
      "display" : "黃東波外科診所"
    },
    {
      "code" : "3532010533",
      "display" : "涂婦產科診所"
    },
    {
      "code" : "3532010588",
      "display" : "謝內科小兒科診所"
    },
    {
      "code" : "3532010686",
      "display" : "游江南內科小兒科診所"
    },
    {
      "code" : "3532010695",
      "display" : "邱婦產科診所"
    },
    {
      "code" : "3532010864",
      "display" : "謝宗佑診所"
    },
    {
      "code" : "3532010882",
      "display" : "吳政聰診所"
    },
    {
      "code" : "3532011003",
      "display" : "林外科診所"
    },
    {
      "code" : "3532011030",
      "display" : "江眼科診所"
    },
    {
      "code" : "3532011049",
      "display" : "陳嘉禎診所"
    },
    {
      "code" : "3532011067",
      "display" : "紀內科小兒科診所"
    },
    {
      "code" : "3532011218",
      "display" : "李應燦診所"
    },
    {
      "code" : "3532011307",
      "display" : "康銘龍內科小兒科診所"
    },
    {
      "code" : "3532011414",
      "display" : "陸勇亮診所"
    },
    {
      "code" : "3532011423",
      "display" : "王眼科診所"
    },
    {
      "code" : "3532011432",
      "display" : "亞泰診所"
    },
    {
      "code" : "3532011441",
      "display" : "惠民診所"
    },
    {
      "code" : "3532011450",
      "display" : "冠忠診所"
    },
    {
      "code" : "3532011503",
      "display" : "台安診所"
    },
    {
      "code" : "3532011512",
      "display" : "鄧婦產科診所"
    },
    {
      "code" : "3532011549",
      "display" : "劉宗浩婦產科診所"
    },
    {
      "code" : "3532011683",
      "display" : "林瑞家診所"
    },
    {
      "code" : "3532011825",
      "display" : "鄭嘉榮婦產科診所"
    },
    {
      "code" : "3532011852",
      "display" : "佳祐診所"
    },
    {
      "code" : "3532011905",
      "display" : "張耳鼻喉科診所"
    },
    {
      "code" : "3532011914",
      "display" : "游昆裕診所"
    },
    {
      "code" : "3532011923",
      "display" : "袁耳鼻喉科診所"
    },
    {
      "code" : "3532011969",
      "display" : "陳眼科診所"
    },
    {
      "code" : "3532011978",
      "display" : "張眼科診所"
    },
    {
      "code" : "3532012055",
      "display" : "保家診所"
    },
    {
      "code" : "3532012073",
      "display" : "林錫國診所"
    },
    {
      "code" : "3532012108",
      "display" : "謝以民診所"
    },
    {
      "code" : "3532012215",
      "display" : "陳昌平婦產科診所"
    },
    {
      "code" : "3532012386",
      "display" : "邱眼科診所"
    },
    {
      "code" : "3532012457",
      "display" : "易世富婦產科診所"
    },
    {
      "code" : "3532012475",
      "display" : "康瑞診所"
    },
    {
      "code" : "3532012493",
      "display" : "合康診所"
    },
    {
      "code" : "3532012528",
      "display" : "賴明偉復健科診所"
    },
    {
      "code" : "3532012564",
      "display" : "昇暉診所"
    },
    {
      "code" : "3532012582",
      "display" : "林振實小兒診所"
    },
    {
      "code" : "3532012591",
      "display" : "桃庚聯合診所"
    },
    {
      "code" : "3532012617",
      "display" : "聖家小兒科診所"
    },
    {
      "code" : "3532012626",
      "display" : "路加皮膚科診所"
    },
    {
      "code" : "3532012635",
      "display" : "謝秋梅診所"
    },
    {
      "code" : "3532012751",
      "display" : "親子診所"
    },
    {
      "code" : "3532012804",
      "display" : "柯福順耳鼻喉科診所"
    },
    {
      "code" : "3532012822",
      "display" : "長榮婦產科診所"
    },
    {
      "code" : "3532012877",
      "display" : "朱皮膚科診所"
    },
    {
      "code" : "3532012886",
      "display" : "桃園合信諾貝爾眼科診所"
    },
    {
      "code" : "3532012895",
      "display" : "林眼科診所"
    },
    {
      "code" : "3532012939",
      "display" : "景福骨科診所"
    },
    {
      "code" : "3532012948",
      "display" : "孫德金小兒科診所"
    },
    {
      "code" : "3532012966",
      "display" : "鴻林耳鼻喉科診所"
    },
    {
      "code" : "3532012975",
      "display" : "顧小兒科診所"
    },
    {
      "code" : "3532012984",
      "display" : "聯戰診所"
    },
    {
      "code" : "3532014040",
      "display" : "龍群骨科診所"
    },
    {
      "code" : "3532014086",
      "display" : "慧安耳鼻喉科診所"
    },
    {
      "code" : "3532014095",
      "display" : "吳可怡婦產科診所"
    },
    {
      "code" : "3532014157",
      "display" : "尚群診所"
    },
    {
      "code" : "3532014175",
      "display" : "張超翔皮膚科診所"
    },
    {
      "code" : "3532014273",
      "display" : "楊文彬耳鼻喉科診所"
    },
    {
      "code" : "3532014308",
      "display" : "偉勝耳鼻喉科診所"
    },
    {
      "code" : "3532014344",
      "display" : "林宏洲眼科診所"
    },
    {
      "code" : "3532014362",
      "display" : "向榮婦產科診所"
    },
    {
      "code" : "3532014380",
      "display" : "安慧診所"
    },
    {
      "code" : "3532014399",
      "display" : "吳鎮宇親子耳鼻喉科診所"
    },
    {
      "code" : "3532014504",
      "display" : "李應德診所"
    },
    {
      "code" : "3532014513",
      "display" : "范姜皮膚科診所"
    },
    {
      "code" : "3532014540",
      "display" : "陳維藩婦產專科診所"
    },
    {
      "code" : "3532014577",
      "display" : "陽光生活診所"
    },
    {
      "code" : "3532014595",
      "display" : "正典診所"
    },
    {
      "code" : "3532014620",
      "display" : "芯佑診所"
    },
    {
      "code" : "3532014657",
      "display" : "易康皮膚專科診所"
    },
    {
      "code" : "3532014666",
      "display" : "美劭診所"
    },
    {
      "code" : "3532014675",
      "display" : "曹景雄小兒科診所"
    },
    {
      "code" : "3532014684",
      "display" : "蘇裕哲診所"
    },
    {
      "code" : "3532014719",
      "display" : "寶貝兒童復健專科診所"
    },
    {
      "code" : "3532014728",
      "display" : "奕恩小兒科診所"
    },
    {
      "code" : "3532014755",
      "display" : "邵柏源耳鼻喉科"
    },
    {
      "code" : "3532014773",
      "display" : "何翊菁診所"
    },
    {
      "code" : "3532014782",
      "display" : "李柏鋒診所"
    },
    {
      "code" : "3532014808",
      "display" : "永欣診所"
    },
    {
      "code" : "3532014853",
      "display" : "昇昇婦產科診所"
    },
    {
      "code" : "3532014862",
      "display" : "惠生婦產科診所"
    },
    {
      "code" : "3532014871",
      "display" : "吉兒診所"
    },
    {
      "code" : "3532014906",
      "display" : "華麗診所"
    },
    {
      "code" : "3532014924",
      "display" : "胡錕杰診所"
    },
    {
      "code" : "3532014933",
      "display" : "鑫明眼科診所"
    },
    {
      "code" : "3532014951",
      "display" : "蕭閔誌診所"
    },
    {
      "code" : "3532014979",
      "display" : "慈民耳鼻喉科診所"
    },
    {
      "code" : "3532014997",
      "display" : "良祐診所"
    },
    {
      "code" : "3532015010",
      "display" : "澔德耳鼻喉科診所"
    },
    {
      "code" : "3532015065",
      "display" : "陳治平診所"
    },
    {
      "code" : "3532015109",
      "display" : "鼎尚診所"
    },
    {
      "code" : "3532015136",
      "display" : "鑫庚內科診所"
    },
    {
      "code" : "3532015145",
      "display" : "晨芳婦產科診所"
    },
    {
      "code" : "3532015190",
      "display" : "健新耳鼻喉科診所"
    },
    {
      "code" : "3532015243",
      "display" : "徐大昇皮膚科診所"
    },
    {
      "code" : "3532015270",
      "display" : "智元診所"
    },
    {
      "code" : "3532015350",
      "display" : "黃晉文診所"
    },
    {
      "code" : "3532015396",
      "display" : "萬能診所"
    },
    {
      "code" : "3532015421",
      "display" : "安美皮膚科耳鼻喉科專科診所"
    },
    {
      "code" : "3532015430",
      "display" : "全新精神專科診所"
    },
    {
      "code" : "3532015476",
      "display" : "心寧診所"
    },
    {
      "code" : "3532015501",
      "display" : "興安眼科診所"
    },
    {
      "code" : "3532015510",
      "display" : "惠安眼科診所"
    },
    {
      "code" : "3532015529",
      "display" : "聖昌診所"
    },
    {
      "code" : "3532015538",
      "display" : "張世彥眼科診所"
    },
    {
      "code" : "3532015556",
      "display" : "永晉診所"
    },
    {
      "code" : "3532015618",
      "display" : "婦茂婦幼診所"
    },
    {
      "code" : "3532015636",
      "display" : "陽明復健專科診所"
    },
    {
      "code" : "3532015713",
      "display" : "禾安診所"
    },
    {
      "code" : "3532015731",
      "display" : "振興診所"
    },
    {
      "code" : "3532015770",
      "display" : "全安診所"
    },
    {
      "code" : "3532015814",
      "display" : "桃安診所"
    },
    {
      "code" : "3532015896",
      "display" : "慈文診所"
    },
    {
      "code" : "3532015903",
      "display" : "欣欣診所"
    },
    {
      "code" : "3532015912",
      "display" : "光彩層峯親子皮膚科診所"
    },
    {
      "code" : "3532015967",
      "display" : "諾倍康診所"
    },
    {
      "code" : "3532015976",
      "display" : "明欣診所"
    },
    {
      "code" : "3532015985",
      "display" : "大學眼科診所"
    },
    {
      "code" : "3532016017",
      "display" : "江皮膚科診所"
    },
    {
      "code" : "3532016026",
      "display" : "亞聯親子診所"
    },
    {
      "code" : "3532016080",
      "display" : "健安診所"
    },
    {
      "code" : "3532016142",
      "display" : "正興診所"
    },
    {
      "code" : "3532016197",
      "display" : "胡順志診所"
    },
    {
      "code" : "3532016204",
      "display" : "何秋勇診所"
    },
    {
      "code" : "3532016277",
      "display" : "悅康復健診所"
    },
    {
      "code" : "3532016286",
      "display" : "大興維格內科診所"
    },
    {
      "code" : "3532016295",
      "display" : "大興維格皮膚科診所"
    },
    {
      "code" : "3532016357",
      "display" : "全家親子診所"
    },
    {
      "code" : "3532016375",
      "display" : "成功美學皮膚專科診所"
    },
    {
      "code" : "3532016393",
      "display" : "李裕承診所"
    },
    {
      "code" : "3532016428",
      "display" : "安心診所"
    },
    {
      "code" : "3532016446",
      "display" : "晨暘診所"
    },
    {
      "code" : "3532016508",
      "display" : "林信佑診所"
    },
    {
      "code" : "3532016517",
      "display" : "聖德診所"
    },
    {
      "code" : "3532016571",
      "display" : "家和診所"
    },
    {
      "code" : "3532016624",
      "display" : "樂康診所"
    },
    {
      "code" : "3532016642",
      "display" : "莊家盛內科診所"
    },
    {
      "code" : "3532016679",
      "display" : "小太陽耳鼻喉專科診所"
    },
    {
      "code" : "3532016713",
      "display" : "大順診所"
    },
    {
      "code" : "3532016722",
      "display" : "聚英光與自然眼科診所"
    },
    {
      "code" : "3532016740",
      "display" : "振雄診所"
    },
    {
      "code" : "3532016777",
      "display" : "育祥婦產科診所"
    },
    {
      "code" : "3532016786",
      "display" : "簡家醫診所"
    },
    {
      "code" : "3532016795",
      "display" : "美麗晶華診所"
    },
    {
      "code" : "3532016919",
      "display" : "大中骨科診所"
    },
    {
      "code" : "3532016928",
      "display" : "光文診所"
    },
    {
      "code" : "3532016964",
      "display" : "瀚群骨科診所"
    },
    {
      "code" : "3532016982",
      "display" : "蘇思明診所"
    },
    {
      "code" : "3532016991",
      "display" : "力綺復健科診所"
    },
    {
      "code" : "3532017005",
      "display" : "鼎侑診所"
    },
    {
      "code" : "3532017041",
      "display" : "達康復健科診所"
    },
    {
      "code" : "3532017130",
      "display" : "龍和診所"
    },
    {
      "code" : "3532017176",
      "display" : "盛軒耳鼻喉科診所"
    },
    {
      "code" : "3532017229",
      "display" : "生生外科婦產科診所"
    },
    {
      "code" : "3532017238",
      "display" : "同德診所"
    },
    {
      "code" : "3532017247",
      "display" : "吳睿斌婦產科診所"
    },
    {
      "code" : "3532017256",
      "display" : "詠美身心診所"
    },
    {
      "code" : "3532017265",
      "display" : "鑫桃眼科診所"
    },
    {
      "code" : "3532017283",
      "display" : "芯欣診所"
    },
    {
      "code" : "3532017292",
      "display" : "悅情身心科診所"
    },
    {
      "code" : "3532017372",
      "display" : "奧爾親子診所"
    },
    {
      "code" : "3532017425",
      "display" : "峰禾診所"
    },
    {
      "code" : "3532017461",
      "display" : "桃園彤顏診所"
    },
    {
      "code" : "3532017470",
      "display" : "康鴻復健科診所"
    },
    {
      "code" : "3532017523",
      "display" : "聖洸身心診所"
    },
    {
      "code" : "3532017550",
      "display" : "晨宏診所"
    },
    {
      "code" : "3532017569",
      "display" : "義佳診所"
    },
    {
      "code" : "3532017578",
      "display" : "周孫元診所"
    },
    {
      "code" : "3532017587",
      "display" : "靖明眼科診所"
    },
    {
      "code" : "3532017612",
      "display" : "大有耳鼻喉專科診所"
    },
    {
      "code" : "3532017649",
      "display" : "心晴診所"
    },
    {
      "code" : "3532017676",
      "display" : "吳耳鼻喉科診所"
    },
    {
      "code" : "3532017701",
      "display" : "吳俊毅身心精神科診所"
    },
    {
      "code" : "3532017710",
      "display" : "家恩診所"
    },
    {
      "code" : "3532017729",
      "display" : "杏蘊婦產科診所"
    },
    {
      "code" : "3532017738",
      "display" : "一德身心診所"
    },
    {
      "code" : "3532017765",
      "display" : "慈心診所"
    },
    {
      "code" : "3532017818",
      "display" : "惠生保安婦幼診所"
    },
    {
      "code" : "3532017836",
      "display" : "真醫診所"
    },
    {
      "code" : "3532017854",
      "display" : "佑霖診所"
    },
    {
      "code" : "3532017872",
      "display" : "巴黎國際長春診所"
    },
    {
      "code" : "3532017907",
      "display" : "心禾診所"
    },
    {
      "code" : "3532017925",
      "display" : "愛兒親子診所"
    },
    {
      "code" : "3532017943",
      "display" : "聖昕診所"
    },
    {
      "code" : "3532017952",
      "display" : "桃園維格皮膚科診所"
    },
    {
      "code" : "3532017961",
      "display" : "勤業診所"
    },
    {
      "code" : "3532017998",
      "display" : "正文身心診所"
    },
    {
      "code" : "3532018002",
      "display" : "中正耳鼻喉科診所"
    },
    {
      "code" : "3532018011",
      "display" : "存奕美學診所"
    },
    {
      "code" : "3532018039",
      "display" : "逢章診所"
    },
    {
      "code" : "3532018057",
      "display" : "禾欣骨科診所"
    },
    {
      "code" : "3532018066",
      "display" : "彥靚診所"
    },
    {
      "code" : "3532018100",
      "display" : "光彩皮膚科診所"
    },
    {
      "code" : "3532018119",
      "display" : "恆新復健科診所"
    },
    {
      "code" : "3532018128",
      "display" : "禾馨桃園婦幼診所"
    },
    {
      "code" : "3532018137",
      "display" : "日出親子診所"
    },
    {
      "code" : "3532018146",
      "display" : "當陽之境身心診所"
    },
    {
      "code" : "3532018155",
      "display" : "元康診所"
    },
    {
      "code" : "3532018164",
      "display" : "桃園高美泌尿科診所"
    },
    {
      "code" : "3532018191",
      "display" : "桃園馥齡診所"
    },
    {
      "code" : "3532018217",
      "display" : "寶順診所"
    },
    {
      "code" : "3532018226",
      "display" : "桃園大興諾貝爾眼科診所"
    },
    {
      "code" : "3532018235",
      "display" : "崇光身心診所"
    },
    {
      "code" : "3532018253",
      "display" : "永安診所"
    },
    {
      "code" : "3532018271",
      "display" : "德康診所"
    },
    {
      "code" : "3532018299",
      "display" : "昕生診所"
    },
    {
      "code" : "3532018306",
      "display" : "卓越皮膚科診所"
    },
    {
      "code" : "3532018315",
      "display" : "卓越小兒科診所"
    },
    {
      "code" : "3532018324",
      "display" : "慈悅皮膚科診所"
    },
    {
      "code" : "3532018333",
      "display" : "振心身心診所"
    },
    {
      "code" : "3532018342",
      "display" : "康倍診所"
    },
    {
      "code" : "3532018379",
      "display" : "豐年診所"
    },
    {
      "code" : "3532018388",
      "display" : "禾馨桃園外科診所"
    },
    {
      "code" : "3532018413",
      "display" : "藝文康澤復健科診所"
    },
    {
      "code" : "3532018431",
      "display" : "向陽診所"
    },
    {
      "code" : "3532018440",
      "display" : "桃園宏其生基診所"
    },
    {
      "code" : "3532018459",
      "display" : "中正眼科診所"
    },
    {
      "code" : "3532018486",
      "display" : "藝安復健科診所"
    },
    {
      "code" : "3532018520",
      "display" : "金鶯診所"
    },
    {
      "code" : "3532018539",
      "display" : "唯新骨科診所"
    },
    {
      "code" : "3532018548",
      "display" : "敏盛智慧健康管理診所"
    },
    {
      "code" : "3532018575",
      "display" : "翔語身心診所"
    },
    {
      "code" : "3532018584",
      "display" : "政揚診所"
    },
    {
      "code" : "3532018619",
      "display" : "福祐診所"
    },
    {
      "code" : "3532018628",
      "display" : "壹點零壹健康診所"
    },
    {
      "code" : "3532018664",
      "display" : "禾佳骨科診所"
    },
    {
      "code" : "3532018673",
      "display" : "健維診所"
    },
    {
      "code" : "3532018682",
      "display" : "陽光美膚診所"
    },
    {
      "code" : "3532018708",
      "display" : "宏華診所"
    },
    {
      "code" : "3532018780",
      "display" : "藝群桃園診所"
    },
    {
      "code" : "3532018824",
      "display" : "擁抱心身醫學診所"
    },
    {
      "code" : "3532018851",
      "display" : "藝文范姜皮膚科診所"
    },
    {
      "code" : "3532018860",
      "display" : "弘育皮膚科診所"
    },
    {
      "code" : "3532018879",
      "display" : "弘育耳鼻喉科診所"
    },
    {
      "code" : "3532018897",
      "display" : "愛群婦產科診所"
    },
    {
      "code" : "3532018913",
      "display" : "同恩復健科診所"
    },
    {
      "code" : "3532018931",
      "display" : "醫膚親子皮膚專科診所"
    },
    {
      "code" : "3532018968",
      "display" : "同心藝文診所"
    },
    {
      "code" : "3532018977",
      "display" : "佳醫診所"
    },
    {
      "code" : "3532018995",
      "display" : "湧恩診所"
    },
    {
      "code" : "3532019009",
      "display" : "桃園顧家泌尿科診所"
    },
    {
      "code" : "3532019018",
      "display" : "桃園藝文大學眼科診所"
    },
    {
      "code" : "3532019027",
      "display" : "宏蘊親子耳鼻喉科診所"
    },
    {
      "code" : "3532019036",
      "display" : "樂動復健科診所"
    },
    {
      "code" : "3532019054",
      "display" : "福馨診所"
    },
    {
      "code" : "3532019063",
      "display" : "藝群桃園診所"
    },
    {
      "code" : "3532019072",
      "display" : "睿視神經眼科診所"
    },
    {
      "code" : "3532019116",
      "display" : "宜禾診所"
    },
    {
      "code" : "3532019170",
      "display" : "中路翊菁診所"
    },
    {
      "code" : "3532019198",
      "display" : "至誠診所"
    },
    {
      "code" : "3532020020",
      "display" : "彭奕奇聯合診所"
    },
    {
      "code" : "3532020093",
      "display" : "何小兒科內科診所"
    },
    {
      "code" : "3532020146",
      "display" : "祥生婦產科小兒科診所"
    },
    {
      "code" : "3532020155",
      "display" : "鄒內兒科診所"
    },
    {
      "code" : "3532020226",
      "display" : "邱內兒科診所"
    },
    {
      "code" : "3532020342",
      "display" : "黃顯陽內科小兒科診所"
    },
    {
      "code" : "3532020646",
      "display" : "仁林診所"
    },
    {
      "code" : "3532020851",
      "display" : "陳達內科小兒科診所"
    },
    {
      "code" : "3532021045",
      "display" : "陳遠芳診所"
    },
    {
      "code" : "3532021134",
      "display" : "陳耳鼻喉科診所"
    },
    {
      "code" : "3532021296",
      "display" : "陳榮輝婦產科診所"
    },
    {
      "code" : "3532021312",
      "display" : "李經國診所"
    },
    {
      "code" : "3532021401",
      "display" : "曹振周小兒科診所"
    },
    {
      "code" : "3532021492",
      "display" : "徐永禧眼科診所"
    },
    {
      "code" : "3532021590",
      "display" : "羅診所"
    },
    {
      "code" : "3532021652",
      "display" : "曾憲利婦產科診所"
    },
    {
      "code" : "3532021670",
      "display" : "張文星診所"
    },
    {
      "code" : "3532021714",
      "display" : "黃一純診所"
    },
    {
      "code" : "3532021723",
      "display" : "黃永輝診所"
    },
    {
      "code" : "3532021796",
      "display" : "范姜眼科診所"
    },
    {
      "code" : "3532021867",
      "display" : "明安眼科診所"
    },
    {
      "code" : "3532021901",
      "display" : "葉佐仁診所"
    },
    {
      "code" : "3532021929",
      "display" : "何紹榮耳鼻喉科診所"
    },
    {
      "code" : "3532021974",
      "display" : "厚生婦產科診所"
    },
    {
      "code" : "3532021983",
      "display" : "蕭成芝診所"
    },
    {
      "code" : "3532022024",
      "display" : "吳瑞生診所"
    },
    {
      "code" : "3532022088",
      "display" : "洛淳皮膚科診所"
    },
    {
      "code" : "3532022159",
      "display" : "許文龍診所"
    },
    {
      "code" : "3532022202",
      "display" : "中壢聯新診所"
    },
    {
      "code" : "3532022211",
      "display" : "王小兒科診所"
    },
    {
      "code" : "3532022239",
      "display" : "吳家淦耳鼻喉科診所"
    },
    {
      "code" : "3532022257",
      "display" : "大林復健科診所"
    },
    {
      "code" : "3532022266",
      "display" : "陳鍊生診所"
    },
    {
      "code" : "3532022275",
      "display" : "林診所"
    },
    {
      "code" : "3532022364",
      "display" : "范光迪診所"
    },
    {
      "code" : "3532022373",
      "display" : "張皮膚科診所(原為張樹權皮膚科診所)"
    },
    {
      "code" : "3532022435",
      "display" : "祥安診所"
    },
    {
      "code" : "3532022480",
      "display" : "葉欽池小兒科診所"
    },
    {
      "code" : "3532022515",
      "display" : "敏昌診所"
    },
    {
      "code" : "3532022542",
      "display" : "興明皮膚科眼科聯合診所"
    },
    {
      "code" : "3532022560",
      "display" : "健康診所"
    },
    {
      "code" : "3532022579",
      "display" : "新時代眼科診所"
    },
    {
      "code" : "3532022686",
      "display" : "黃紀倫診所"
    },
    {
      "code" : "3532022702",
      "display" : "中新小兒科聯合診所"
    },
    {
      "code" : "3532022739",
      "display" : "福田診所"
    },
    {
      "code" : "3532022748",
      "display" : "王超群小兒科診所"
    },
    {
      "code" : "3532022793",
      "display" : "黃志焜診所"
    },
    {
      "code" : "3532022819",
      "display" : "宜安診所"
    },
    {
      "code" : "3532022855",
      "display" : "高正雄骨科診所"
    },
    {
      "code" : "3532022873",
      "display" : "安安小兒科診所"
    },
    {
      "code" : "3532022882",
      "display" : "佑林聯合診所"
    },
    {
      "code" : "3532022926",
      "display" : "吉康耳鼻喉科診所"
    },
    {
      "code" : "3532022935",
      "display" : "林浩健診所"
    },
    {
      "code" : "3532023156",
      "display" : "朱世弘婦產科診所"
    },
    {
      "code" : "3532023165",
      "display" : "家安診所"
    },
    {
      "code" : "3532023183",
      "display" : "黃大中診所"
    },
    {
      "code" : "3532023218",
      "display" : "馬興華耳鼻喉科診所"
    },
    {
      "code" : "3532023227",
      "display" : "葉神經科診所"
    },
    {
      "code" : "3532023254",
      "display" : "許志弘診所"
    },
    {
      "code" : "3532023263",
      "display" : "吉寶耳鼻喉科診所"
    },
    {
      "code" : "3532024297",
      "display" : "吳瑞瓊小兒科診所"
    },
    {
      "code" : "3532024304",
      "display" : "正倫診所"
    },
    {
      "code" : "3532024313",
      "display" : "安倫診所"
    },
    {
      "code" : "3532024411",
      "display" : "東新診所"
    },
    {
      "code" : "3532024475",
      "display" : "德祐診所"
    },
    {
      "code" : "3532024500",
      "display" : "中山診所"
    },
    {
      "code" : "3532024537",
      "display" : "趙葉林診所"
    },
    {
      "code" : "3532024564",
      "display" : "健興診所"
    },
    {
      "code" : "3532024591",
      "display" : "宏瑞診所"
    },
    {
      "code" : "3532024608",
      "display" : "昭全診所"
    },
    {
      "code" : "3532024733",
      "display" : "銓陽診所"
    },
    {
      "code" : "3532024840",
      "display" : "安康耳鼻喉科診所"
    },
    {
      "code" : "3532024859",
      "display" : "進華小兒科診所"
    },
    {
      "code" : "3532024877",
      "display" : "詮順耳鼻喉科診所"
    },
    {
      "code" : "3532024984",
      "display" : "顏復竹診所"
    },
    {
      "code" : "3532025007",
      "display" : "趙德明婦產科診所"
    },
    {
      "code" : "3532025016",
      "display" : "里安眼科診所"
    },
    {
      "code" : "3532025034",
      "display" : "徐文良婦產科診所"
    },
    {
      "code" : "3532025052",
      "display" : "黃文昌診所"
    },
    {
      "code" : "3532025061",
      "display" : "吉祥耳鼻喉科診所"
    },
    {
      "code" : "3532025089",
      "display" : "環東大榮眼科診所"
    },
    {
      "code" : "3532025114",
      "display" : "黃意剛診所"
    },
    {
      "code" : "3532025132",
      "display" : "鼎盛診所"
    },
    {
      "code" : "3532025141",
      "display" : "李皮膚科診所"
    },
    {
      "code" : "3532025187",
      "display" : "黃曉生小兒科診所"
    },
    {
      "code" : "3532025230",
      "display" : "鈺展骨科診所"
    },
    {
      "code" : "3532025267",
      "display" : "陳瑞祥診所"
    },
    {
      "code" : "3532025285",
      "display" : "中北眼科診所"
    },
    {
      "code" : "3532025301",
      "display" : "自立診所"
    },
    {
      "code" : "3532025338",
      "display" : "中庚診所"
    },
    {
      "code" : "3532025374",
      "display" : "中壢大學眼科診所"
    },
    {
      "code" : "3532025383",
      "display" : "中原診所"
    },
    {
      "code" : "3532025392",
      "display" : "宏元診所"
    },
    {
      "code" : "3532025436",
      "display" : "台馨診所"
    },
    {
      "code" : "3532025463",
      "display" : "榮元診所"
    },
    {
      "code" : "3532025525",
      "display" : "龍岡聯合診所"
    },
    {
      "code" : "3532025561",
      "display" : "謝醫師神經科診所"
    },
    {
      "code" : "3532025570",
      "display" : "林國揆小兒科診所"
    },
    {
      "code" : "3532025589",
      "display" : "合健骨科診所"
    },
    {
      "code" : "3532025598",
      "display" : "廣旭骨科診所"
    },
    {
      "code" : "3532025605",
      "display" : "范耳鼻喉科診所"
    },
    {
      "code" : "3532025614",
      "display" : "佳妍皮膚科診所"
    },
    {
      "code" : "3532025641",
      "display" : "王春元婦產科診所"
    },
    {
      "code" : "3532025678",
      "display" : "鄭朝強小兒科診所"
    },
    {
      "code" : "3532025721",
      "display" : "迎旭診所"
    },
    {
      "code" : "3532025749",
      "display" : "陳甘斌耳鼻喉科診所"
    },
    {
      "code" : "3532025758",
      "display" : "康庭診所"
    },
    {
      "code" : "3532025801",
      "display" : "邱信雄診所"
    },
    {
      "code" : "3532025892",
      "display" : "仁康診所"
    },
    {
      "code" : "3532025945",
      "display" : "龍興診所"
    },
    {
      "code" : "3532025990",
      "display" : "康富骨科診所"
    },
    {
      "code" : "3532026022",
      "display" : "周龍生婦產科診所"
    },
    {
      "code" : "3532026040",
      "display" : "中慎診所"
    },
    {
      "code" : "3532026059",
      "display" : "昇陽小兒科診所"
    },
    {
      "code" : "3532026120",
      "display" : "全家福診所"
    },
    {
      "code" : "3532026157",
      "display" : "張培鑫小兒科診所"
    },
    {
      "code" : "3532026193",
      "display" : "忠貞眼科診所"
    },
    {
      "code" : "3532026219",
      "display" : "梁恬綺小兒科診所"
    },
    {
      "code" : "3532026237",
      "display" : "文聖診所"
    },
    {
      "code" : "3532026246",
      "display" : "愛麗康診所"
    },
    {
      "code" : "3532026273",
      "display" : "德美診所"
    },
    {
      "code" : "3532026291",
      "display" : "陳炯旭診所"
    },
    {
      "code" : "3532026317",
      "display" : "立安眼科診所"
    },
    {
      "code" : "3532026335",
      "display" : "聯安家醫眼科診所"
    },
    {
      "code" : "3532026415",
      "display" : "米樂診所"
    },
    {
      "code" : "3532026522",
      "display" : "和美家醫診所"
    },
    {
      "code" : "3532026540",
      "display" : "活力診所"
    },
    {
      "code" : "3532026559",
      "display" : "麗卿神經專科診所"
    },
    {
      "code" : "3532026568",
      "display" : "維坤診所"
    },
    {
      "code" : "3532026595",
      "display" : "寰東耳鼻喉科診所"
    },
    {
      "code" : "3532026620",
      "display" : "崇恩診所"
    },
    {
      "code" : "3532026639",
      "display" : "彤顏診所"
    },
    {
      "code" : "3532026737",
      "display" : "翊恩診所"
    },
    {
      "code" : "3532026746",
      "display" : "陳秋芬親子診所"
    },
    {
      "code" : "3532026755",
      "display" : "景仁診所"
    },
    {
      "code" : "3532026808",
      "display" : "日揚診所"
    },
    {
      "code" : "3532026817",
      "display" : "心安診所"
    },
    {
      "code" : "3532026844",
      "display" : "康平診所"
    },
    {
      "code" : "3532026871",
      "display" : "弘林診所"
    },
    {
      "code" : "3532026924",
      "display" : "忠孝診所"
    },
    {
      "code" : "3532026951",
      "display" : "上仁美麗診所"
    },
    {
      "code" : "3532027074",
      "display" : "復康堡復健科診所"
    },
    {
      "code" : "3532027083",
      "display" : "順心診所"
    },
    {
      "code" : "3532027127",
      "display" : "智勇診所"
    },
    {
      "code" : "3532027163",
      "display" : "敦仁診所"
    },
    {
      "code" : "3532027172",
      "display" : "佳國耳鼻喉科診所"
    },
    {
      "code" : "3532027181",
      "display" : "尚語身心診所"
    },
    {
      "code" : "3532027190",
      "display" : "啟鐘耳鼻喉科診所"
    },
    {
      "code" : "3532027207",
      "display" : "同心海華診所"
    },
    {
      "code" : "3532027216",
      "display" : "立倫診所"
    },
    {
      "code" : "3532027234",
      "display" : "長春診所"
    },
    {
      "code" : "3532027243",
      "display" : "柏樂診所"
    },
    {
      "code" : "3532027289",
      "display" : "東豐診所"
    },
    {
      "code" : "3532027298",
      "display" : "台大晴朗診所"
    },
    {
      "code" : "3532027305",
      "display" : "聯心診所"
    },
    {
      "code" : "3532027323",
      "display" : "美麗新城診所"
    },
    {
      "code" : "3532027350",
      "display" : "仁馨耳鼻喉科診所"
    },
    {
      "code" : "3532027378",
      "display" : "龍泉診所"
    },
    {
      "code" : "3532027387",
      "display" : "黃義豪診所"
    },
    {
      "code" : "3532027396",
      "display" : "泰康診所"
    },
    {
      "code" : "3532027421",
      "display" : "博士身心醫學診所"
    },
    {
      "code" : "3532027449",
      "display" : "少同慈濟診所"
    },
    {
      "code" : "3532027467",
      "display" : "青溪診所"
    },
    {
      "code" : "3532027501",
      "display" : "佳康診所"
    },
    {
      "code" : "3532027529",
      "display" : "萬程骨科診所"
    },
    {
      "code" : "3532027538",
      "display" : "双眼明眼科診所"
    },
    {
      "code" : "3532027547",
      "display" : "拉菲爾人本診所"
    },
    {
      "code" : "3532027574",
      "display" : "活悅診所"
    },
    {
      "code" : "3532027583",
      "display" : "中壢巴黎國際長春診所"
    },
    {
      "code" : "3532027636",
      "display" : "青埔診所"
    },
    {
      "code" : "3532027645",
      "display" : "慧健康診所"
    },
    {
      "code" : "3532027654",
      "display" : "小樹苗診所"
    },
    {
      "code" : "3532027663",
      "display" : "青園診所"
    },
    {
      "code" : "3532027681",
      "display" : "群麗醫美診所"
    },
    {
      "code" : "3532027690",
      "display" : "英詮骨科診所"
    },
    {
      "code" : "3532027707",
      "display" : "長安內科診所"
    },
    {
      "code" : "3532027716",
      "display" : "馨心親子耳鼻喉科診所"
    },
    {
      "code" : "3532027743",
      "display" : "中壢彤顏診所"
    },
    {
      "code" : "3532027752",
      "display" : "宏悅親子耳鼻喉科診所"
    },
    {
      "code" : "3532027761",
      "display" : "賀立安診所"
    },
    {
      "code" : "3532027798",
      "display" : "佑慎診所"
    },
    {
      "code" : "3532027805",
      "display" : "青埔診所"
    },
    {
      "code" : "3532027814",
      "display" : "雅歌身心診所"
    },
    {
      "code" : "3532027823",
      "display" : "中壢高美泌尿科診所"
    },
    {
      "code" : "3532027850",
      "display" : "泰康診所"
    },
    {
      "code" : "3532027869",
      "display" : "群青診所"
    },
    {
      "code" : "3532027887",
      "display" : "福澤診所"
    },
    {
      "code" : "3532027912",
      "display" : "日禾復健科診所"
    },
    {
      "code" : "3532027921",
      "display" : "松義診所"
    },
    {
      "code" : "3532027930",
      "display" : "元化診所"
    },
    {
      "code" : "3532027958",
      "display" : "中壢國際大學眼科診所"
    },
    {
      "code" : "3532027976",
      "display" : "松義診所"
    },
    {
      "code" : "3532027985",
      "display" : "仁禾診所"
    },
    {
      "code" : "3532027994",
      "display" : "女王時尚診所"
    },
    {
      "code" : "3532028017",
      "display" : "乙馨診所"
    },
    {
      "code" : "3532028035",
      "display" : "內壢康澤復健科診所"
    },
    {
      "code" : "3532028044",
      "display" : "宏逸親子耳鼻喉科診所"
    },
    {
      "code" : "3532028053",
      "display" : "大為診所"
    },
    {
      "code" : "3532028062",
      "display" : "仁禾診所"
    },
    {
      "code" : "3532028080",
      "display" : "福德身心診所"
    },
    {
      "code" : "3532028106",
      "display" : "馨光內科診所"
    },
    {
      "code" : "3532028115",
      "display" : "璽邁兒淨美診所"
    },
    {
      "code" : "3532028124",
      "display" : "江淑娟身心科診所"
    },
    {
      "code" : "3532028188",
      "display" : "中庚診所"
    },
    {
      "code" : "3532028197",
      "display" : "桃園青埔諾貝爾眼科診所"
    },
    {
      "code" : "3532028204",
      "display" : "倍健復健科診所"
    },
    {
      "code" : "3532028213",
      "display" : "豪盛內科診所"
    },
    {
      "code" : "3532028222",
      "display" : "過嶺木子診所"
    },
    {
      "code" : "3532028240",
      "display" : "大象泌尿科診所"
    },
    {
      "code" : "3532030106",
      "display" : "盧德勝診所"
    },
    {
      "code" : "3532030311",
      "display" : "潘叡診所"
    },
    {
      "code" : "3532030348",
      "display" : "鴻昇診所"
    },
    {
      "code" : "3532030357",
      "display" : "榮恩婦產科診所"
    },
    {
      "code" : "3532030446",
      "display" : "明陽診所"
    },
    {
      "code" : "3532030464",
      "display" : "張輝鵬診所"
    },
    {
      "code" : "3532030482",
      "display" : "大華眼科診所"
    },
    {
      "code" : "3532030491",
      "display" : "劉華亮診所"
    },
    {
      "code" : "3532030633",
      "display" : "林佑祥診所"
    },
    {
      "code" : "3532031747",
      "display" : "大溪邱小兒科診所"
    },
    {
      "code" : "3532031827",
      "display" : "謝沿淮骨科診所"
    },
    {
      "code" : "3532031845",
      "display" : "合采皮膚科診所"
    },
    {
      "code" : "3532031854",
      "display" : "劉建志診所"
    },
    {
      "code" : "3532031863",
      "display" : "誠德耳鼻喉科診所"
    },
    {
      "code" : "3532031890",
      "display" : "安馨大溪診所"
    },
    {
      "code" : "3532031943",
      "display" : "大桃園耳鼻喉科診所"
    },
    {
      "code" : "3532031952",
      "display" : "松禾診所"
    },
    {
      "code" : "3532031961",
      "display" : "仁群診所"
    },
    {
      "code" : "3532031970",
      "display" : "大溪金鶯診所"
    },
    {
      "code" : "3532040095",
      "display" : "連婦產科診所"
    },
    {
      "code" : "3532040102",
      "display" : "林保坤診所"
    },
    {
      "code" : "3532040264",
      "display" : "鍾雲祥小兒科診所"
    },
    {
      "code" : "3532040273",
      "display" : "新岡診所"
    },
    {
      "code" : "3532040282",
      "display" : "博愛眼科診所"
    },
    {
      "code" : "3532040335",
      "display" : "陳耀芳耳鼻喉科診所"
    },
    {
      "code" : "3532040399",
      "display" : "勝遠診所"
    },
    {
      "code" : "3532040415",
      "display" : "明仁診所"
    },
    {
      "code" : "3532040438",
      "display" : "姜博文診所"
    },
    {
      "code" : "3532040451",
      "display" : "呂眼科診所"
    },
    {
      "code" : "3532040460",
      "display" : "鄭鈞源診所"
    },
    {
      "code" : "3532040522",
      "display" : "讚生診所"
    },
    {
      "code" : "3532040559",
      "display" : "輝煌診所"
    },
    {
      "code" : "3532040568",
      "display" : "弘仁小兒科診所"
    },
    {
      "code" : "3532041618",
      "display" : "黃彥華婦產科診所"
    },
    {
      "code" : "3532041672",
      "display" : "楊明小兒科診所"
    },
    {
      "code" : "3532041681",
      "display" : "邵耳鼻喉科診所"
    },
    {
      "code" : "3532041707",
      "display" : "民生診所"
    },
    {
      "code" : "3532041725",
      "display" : "羅肇煒診所"
    },
    {
      "code" : "3532041761",
      "display" : "健宏診所"
    },
    {
      "code" : "3532041832",
      "display" : "德安聯合診所"
    },
    {
      "code" : "3532041869",
      "display" : "楊志明診所"
    },
    {
      "code" : "3532041878",
      "display" : "楊欣診所"
    },
    {
      "code" : "3532041896",
      "display" : "揚昇小兒科診所"
    },
    {
      "code" : "3532041949",
      "display" : "曾世鳴皮膚科診所"
    },
    {
      "code" : "3532041958",
      "display" : "佑家診所"
    },
    {
      "code" : "3532041967",
      "display" : "毅嘉骨科診所"
    },
    {
      "code" : "3532041994",
      "display" : "永美耳鼻喉科診所"
    },
    {
      "code" : "3532042008",
      "display" : "陽光診所"
    },
    {
      "code" : "3532042062",
      "display" : "新楊梅診所"
    },
    {
      "code" : "3532042080",
      "display" : "育勝診所"
    },
    {
      "code" : "3532042124",
      "display" : "建東專科診所"
    },
    {
      "code" : "3532042133",
      "display" : "同心青山診所"
    },
    {
      "code" : "3532042179",
      "display" : "普心復健科診所"
    },
    {
      "code" : "3532042188",
      "display" : "民安診所"
    },
    {
      "code" : "3532042197",
      "display" : "宏彥親子耳鼻喉科診所"
    },
    {
      "code" : "3532042204",
      "display" : "瑞溪復健科診所"
    },
    {
      "code" : "3532042213",
      "display" : "家誼診所"
    },
    {
      "code" : "3532042222",
      "display" : "同心瑞埔診所"
    },
    {
      "code" : "3532042231",
      "display" : "謝中孚診所"
    },
    {
      "code" : "3532042240",
      "display" : "凱特美學診所"
    },
    {
      "code" : "3532042259",
      "display" : "皮智醫診所"
    },
    {
      "code" : "3532042268",
      "display" : "宏彥親子診所"
    },
    {
      "code" : "3532042277",
      "display" : "埔新永美診所"
    },
    {
      "code" : "3532042295",
      "display" : "傑安腸胃科診所"
    },
    {
      "code" : "3532042302",
      "display" : "康禾診所"
    },
    {
      "code" : "3532042311",
      "display" : "瑞恩內科診所"
    },
    {
      "code" : "3532042320",
      "display" : "加合診所"
    },
    {
      "code" : "3532042339",
      "display" : "楊梅康澤復健科診所"
    },
    {
      "code" : "3532042348",
      "display" : "安怡診所"
    },
    {
      "code" : "3532042357",
      "display" : "誠心診所"
    },
    {
      "code" : "3532050180",
      "display" : "宜佑診所"
    },
    {
      "code" : "3532050233",
      "display" : "梁志豪婦產科診所"
    },
    {
      "code" : "3532050242",
      "display" : "黃三奇診所"
    },
    {
      "code" : "3532050304",
      "display" : "劉發森診所"
    },
    {
      "code" : "3532050439",
      "display" : "聖欣小兒科診所"
    },
    {
      "code" : "3532050457",
      "display" : "王增齊診所"
    },
    {
      "code" : "3532050484",
      "display" : "長安診所"
    },
    {
      "code" : "3532050528",
      "display" : "莊耳鼻喉科診所"
    },
    {
      "code" : "3532050546",
      "display" : "游眼科診所"
    },
    {
      "code" : "3532050555",
      "display" : "林會川診所"
    },
    {
      "code" : "3532051650",
      "display" : "竹安診所"
    },
    {
      "code" : "3532051703",
      "display" : "劉賢璟皮膚科診所"
    },
    {
      "code" : "3532051712",
      "display" : "朱智盟眼科診所"
    },
    {
      "code" : "3532051767",
      "display" : "佳音小兒科診所"
    },
    {
      "code" : "3532051785",
      "display" : "晨新診所"
    },
    {
      "code" : "3532051801",
      "display" : "明濟診所"
    },
    {
      "code" : "3532051810",
      "display" : "全右診所"
    },
    {
      "code" : "3532051847",
      "display" : "宏安耳鼻喉科診所"
    },
    {
      "code" : "3532051856",
      "display" : "國欣診所"
    },
    {
      "code" : "3532051883",
      "display" : "謝欣穎婦產科診所"
    },
    {
      "code" : "3532051892",
      "display" : "大孫診所"
    },
    {
      "code" : "3532051927",
      "display" : "陳博文診所"
    },
    {
      "code" : "3532051954",
      "display" : "安泰耳鼻喉科診所"
    },
    {
      "code" : "3532051972",
      "display" : "宏日診所"
    },
    {
      "code" : "3532051981",
      "display" : "安禾診所"
    },
    {
      "code" : "3532052004",
      "display" : "慶成診所"
    },
    {
      "code" : "3532052031",
      "display" : "德信診所"
    },
    {
      "code" : "3532052095",
      "display" : "大興診所"
    },
    {
      "code" : "3532052184",
      "display" : "芯悅診所"
    },
    {
      "code" : "3532052219",
      "display" : "蔡錦文診所"
    },
    {
      "code" : "3532052237",
      "display" : "晨光診所"
    },
    {
      "code" : "3532052264",
      "display" : "日康診所"
    },
    {
      "code" : "3532052273",
      "display" : "愛鄰親子診所"
    },
    {
      "code" : "3532052344",
      "display" : "南崁診所"
    },
    {
      "code" : "3532052362",
      "display" : "亮亮耳鼻喉科診所"
    },
    {
      "code" : "3532052380",
      "display" : "欣悅診所"
    },
    {
      "code" : "3532052451",
      "display" : "佑心親子診所"
    },
    {
      "code" : "3532052460",
      "display" : "安康骨科診所"
    },
    {
      "code" : "3532052488",
      "display" : "喜樂診所"
    },
    {
      "code" : "3532052497",
      "display" : "南崁皮膚專科診所"
    },
    {
      "code" : "3532052513",
      "display" : "蘆竹大學眼科診所"
    },
    {
      "code" : "3532052522",
      "display" : "新合骨外科診所"
    },
    {
      "code" : "3532052540",
      "display" : "旭康診所"
    },
    {
      "code" : "3532052559",
      "display" : "安祐診所"
    },
    {
      "code" : "3532052568",
      "display" : "陳俊仁親子診所"
    },
    {
      "code" : "3532052577",
      "display" : "鴻彰診所"
    },
    {
      "code" : "3532052586",
      "display" : "安捷幸福診所"
    },
    {
      "code" : "3532052595",
      "display" : "上大新復健科診所"
    },
    {
      "code" : "3532052602",
      "display" : "張玉麟診所"
    },
    {
      "code" : "3532052611",
      "display" : "昕生診所"
    },
    {
      "code" : "3532052620",
      "display" : "育禾身心診所"
    },
    {
      "code" : "3532052639",
      "display" : "南崁康澤復健科診所"
    },
    {
      "code" : "3532052648",
      "display" : "佳康親子耳鼻喉科診所"
    },
    {
      "code" : "3532052657",
      "display" : "河畔皮膚專科診所"
    },
    {
      "code" : "3532052666",
      "display" : "智群診所"
    },
    {
      "code" : "3532052675",
      "display" : "竹文診所"
    },
    {
      "code" : "3532052684",
      "display" : "至御診所"
    },
    {
      "code" : "3532052693",
      "display" : "南崁桃庚診所"
    },
    {
      "code" : "3532052700",
      "display" : "天天復健科診所"
    },
    {
      "code" : "3532052719",
      "display" : "大竹金鶯診所"
    },
    {
      "code" : "3532052728",
      "display" : "熊大心親子診所"
    },
    {
      "code" : "3532052737",
      "display" : "禾宜骨科診所"
    },
    {
      "code" : "3532060140",
      "display" : "大義婦產科診所"
    },
    {
      "code" : "3532060177",
      "display" : "楊若麟診所"
    },
    {
      "code" : "3532060220",
      "display" : "翁國中小兒科診所"
    },
    {
      "code" : "3532060239",
      "display" : "慧明聯合診所"
    },
    {
      "code" : "3532060266",
      "display" : "呂清標診所"
    },
    {
      "code" : "3532060284",
      "display" : "家康診所"
    },
    {
      "code" : "3532060391",
      "display" : "志忠診所"
    },
    {
      "code" : "3532060408",
      "display" : "黃宗瑤診所"
    },
    {
      "code" : "3532060471",
      "display" : "方景立婦產科診所"
    },
    {
      "code" : "3532060551",
      "display" : "黃俊男診所"
    },
    {
      "code" : "3532060588",
      "display" : "仁安診所"
    },
    {
      "code" : "3532060597",
      "display" : "蘇崇凱診所"
    },
    {
      "code" : "3532060604",
      "display" : "懷德耳鼻喉科診所"
    },
    {
      "code" : "3532061683",
      "display" : "心和診所"
    },
    {
      "code" : "3532061727",
      "display" : "康膚診所"
    },
    {
      "code" : "3532061736",
      "display" : "蘇鼎淵皮膚科診所"
    },
    {
      "code" : "3532061754",
      "display" : "王永賢診所"
    },
    {
      "code" : "3532061772",
      "display" : "新光骨外科診所"
    },
    {
      "code" : "3532061816",
      "display" : "嘉誠診所"
    },
    {
      "code" : "3532061825",
      "display" : "木子診所"
    },
    {
      "code" : "3532061834",
      "display" : "杏妍診所"
    },
    {
      "code" : "3532061843",
      "display" : "盛仁診所"
    },
    {
      "code" : "3532061852",
      "display" : "萱仁診所"
    },
    {
      "code" : "3532061861",
      "display" : "艾利鉑診所"
    },
    {
      "code" : "3532061870",
      "display" : "青埔謝謝診所"
    },
    {
      "code" : "3532061889",
      "display" : "日日安親子耳鼻喉科診所"
    },
    {
      "code" : "3532061898",
      "display" : "日日安內科診所"
    },
    {
      "code" : "3532070333",
      "display" : "許忠信小兒科診所"
    },
    {
      "code" : "3532070379",
      "display" : "曾眼科診所"
    },
    {
      "code" : "3532070388",
      "display" : "黃博駿耳鼻喉科診所"
    },
    {
      "code" : "3532070422",
      "display" : "蕭大章診所"
    },
    {
      "code" : "3532070440",
      "display" : "周光偉診所"
    },
    {
      "code" : "3532070468",
      "display" : "陳皮膚科診所"
    },
    {
      "code" : "3532070548",
      "display" : "遠東耳鼻喉科診所"
    },
    {
      "code" : "3532070557",
      "display" : "杜一鳴婦產科診所"
    },
    {
      "code" : "3532070593",
      "display" : "顏福順診所"
    },
    {
      "code" : "3532070637",
      "display" : "連淑芳小兒科診所"
    },
    {
      "code" : "3532070708",
      "display" : "光明眼科診所"
    },
    {
      "code" : "3532071750",
      "display" : "吳天聰內科診所"
    },
    {
      "code" : "3532071803",
      "display" : "大魏診所"
    },
    {
      "code" : "3532071821",
      "display" : "龜山博濟診所"
    },
    {
      "code" : "3532071858",
      "display" : "陳完任家庭醫學科診所"
    },
    {
      "code" : "3532071867",
      "display" : "德泰診所"
    },
    {
      "code" : "3532071910",
      "display" : "吳奕宏診所"
    },
    {
      "code" : "3532071956",
      "display" : "合群骨科診所"
    },
    {
      "code" : "3532071965",
      "display" : "瑞家婦產科診所"
    },
    {
      "code" : "3532071983",
      "display" : "德馨診所"
    },
    {
      "code" : "3532072051",
      "display" : "杏芳婦產科診所"
    },
    {
      "code" : "3532072060",
      "display" : "新世代診所"
    },
    {
      "code" : "3532072088",
      "display" : "鴻興診所"
    },
    {
      "code" : "3532072097",
      "display" : "采奕診所"
    },
    {
      "code" : "3532072159",
      "display" : "南崁現代診所"
    },
    {
      "code" : "3532072168",
      "display" : "瑞奕診所"
    },
    {
      "code" : "3532072186",
      "display" : "維格皮膚科診所"
    },
    {
      "code" : "3532072211",
      "display" : "劉建宏診所"
    },
    {
      "code" : "3532072220",
      "display" : "健雄診所"
    },
    {
      "code" : "3532072248",
      "display" : "瑞安眼科診所"
    },
    {
      "code" : "3532072257",
      "display" : "聚英眼科診所"
    },
    {
      "code" : "3532072266",
      "display" : "朱永恆診所"
    },
    {
      "code" : "3532072300",
      "display" : "良安診所"
    },
    {
      "code" : "3532072319",
      "display" : "德恩診所"
    },
    {
      "code" : "3532072328",
      "display" : "日安親子診所"
    },
    {
      "code" : "3532072346",
      "display" : "李鴻麟診所"
    },
    {
      "code" : "3532072364",
      "display" : "蘆竹現代診所"
    },
    {
      "code" : "3532072373",
      "display" : "銘傳家醫診所"
    },
    {
      "code" : "3532072408",
      "display" : "南崁康群骨科診所"
    },
    {
      "code" : "3532072417",
      "display" : "現代皮膚科診所"
    },
    {
      "code" : "3532072435",
      "display" : "蘇宗偉身心診所"
    },
    {
      "code" : "3532072471",
      "display" : "陸教授神經科診所"
    },
    {
      "code" : "3532072480",
      "display" : "安庚內科診所"
    },
    {
      "code" : "3532072499",
      "display" : "無尾熊診所"
    },
    {
      "code" : "3532072506",
      "display" : "微笑親子耳鼻喉科診所"
    },
    {
      "code" : "3532072515",
      "display" : "欣庚診所"
    },
    {
      "code" : "3532072542",
      "display" : "清心身心診所"
    },
    {
      "code" : "3532072551",
      "display" : "宗男診所"
    },
    {
      "code" : "3532072579",
      "display" : "新迴龍診所"
    },
    {
      "code" : "3532072597",
      "display" : "福恩診所"
    },
    {
      "code" : "3532072604",
      "display" : "卓越耳鼻喉科診所"
    },
    {
      "code" : "3532072613",
      "display" : "永樂耳鼻喉科診所"
    },
    {
      "code" : "3532072622",
      "display" : "樂誠診所"
    },
    {
      "code" : "3532072659",
      "display" : "卓越內科診所"
    },
    {
      "code" : "3532072695",
      "display" : "正麒診所"
    },
    {
      "code" : "3532072711",
      "display" : "六順診所"
    },
    {
      "code" : "3532072748",
      "display" : "福佑診所"
    },
    {
      "code" : "3532072757",
      "display" : "安生診所"
    },
    {
      "code" : "3532072775",
      "display" : "龜山康澤復健科診所"
    },
    {
      "code" : "3532072784",
      "display" : "晴光皮膚專科診所"
    },
    {
      "code" : "3532072793",
      "display" : "銓佑診所"
    },
    {
      "code" : "3532072819",
      "display" : "全御診所"
    },
    {
      "code" : "3532072828",
      "display" : "文新診所"
    },
    {
      "code" : "3532072846",
      "display" : "新田身心診所"
    },
    {
      "code" : "3532072855",
      "display" : "維格診所"
    },
    {
      "code" : "3532072864",
      "display" : "安捷幸福診所"
    },
    {
      "code" : "3532072873",
      "display" : "林口冠雅復健科診所"
    },
    {
      "code" : "3532072882",
      "display" : "安捷幸福診所"
    },
    {
      "code" : "3532072891",
      "display" : "新田身心診所"
    },
    {
      "code" : "3532072908",
      "display" : "樂安診所"
    },
    {
      "code" : "3532080142",
      "display" : "十全內科小兒科診所"
    },
    {
      "code" : "3532080179",
      "display" : "潘肇祺家庭醫學科診所"
    },
    {
      "code" : "3532080428",
      "display" : "萬耳鼻喉科診所"
    },
    {
      "code" : "3532080544",
      "display" : "陳弘修耳鼻喉科診所"
    },
    {
      "code" : "3532080562",
      "display" : "復健診所"
    },
    {
      "code" : "3532080571",
      "display" : "蘇眼科診所"
    },
    {
      "code" : "3532080697",
      "display" : "吳鳳昕婦產科診所"
    },
    {
      "code" : "3532080731",
      "display" : "聖文診所"
    },
    {
      "code" : "3532080740",
      "display" : "林添貴診所"
    },
    {
      "code" : "3532080802",
      "display" : "陳坤荃小兒科診所"
    },
    {
      "code" : "3532080857",
      "display" : "劉奮洋診所"
    },
    {
      "code" : "3532080928",
      "display" : "楊正全聯合診所"
    },
    {
      "code" : "3532080991",
      "display" : "吳眼科診所"
    },
    {
      "code" : "3532081005",
      "display" : "上尤耳鼻喉科診所"
    },
    {
      "code" : "3532081014",
      "display" : "賴秉鈞聯合診所"
    },
    {
      "code" : "3532081023",
      "display" : "蕭益富診所"
    },
    {
      "code" : "3532081050",
      "display" : "顏耳鼻喉科診所"
    },
    {
      "code" : "3532081096",
      "display" : "德新診所"
    },
    {
      "code" : "3532082173",
      "display" : "李訓宗診所"
    },
    {
      "code" : "3532082182",
      "display" : "高誠診所"
    },
    {
      "code" : "3532082208",
      "display" : "李偉岳診所"
    },
    {
      "code" : "3532082217",
      "display" : "瀚文耳鼻喉科診所"
    },
    {
      "code" : "3532082253",
      "display" : "佑群骨科診所"
    },
    {
      "code" : "3532082262",
      "display" : "陳鉅昌診所"
    },
    {
      "code" : "3532082271",
      "display" : "家慶診所"
    },
    {
      "code" : "3532082280",
      "display" : "崇瑞耳鼻喉科診所"
    },
    {
      "code" : "3532082299",
      "display" : "惠欣婦產科診所"
    },
    {
      "code" : "3532082315",
      "display" : "博濟診所"
    },
    {
      "code" : "3532082324",
      "display" : "廣恩耳鼻喉科診所"
    },
    {
      "code" : "3532082342",
      "display" : "振益診所"
    },
    {
      "code" : "3532082360",
      "display" : "翁文堯婦產科診所"
    },
    {
      "code" : "3532082379",
      "display" : "郭淵進診所"
    },
    {
      "code" : "3532082388",
      "display" : "林立銘診所"
    },
    {
      "code" : "3532082413",
      "display" : "仁美皮膚科診所"
    },
    {
      "code" : "3532082422",
      "display" : "德禾診所"
    },
    {
      "code" : "3532082511",
      "display" : "新視界眼科診所"
    },
    {
      "code" : "3532082520",
      "display" : "羅久勝小兒專科診所"
    },
    {
      "code" : "3532082548",
      "display" : "廣德診所"
    },
    {
      "code" : "3532082575",
      "display" : "李淵順小兒科診所"
    },
    {
      "code" : "3532082593",
      "display" : "八德身心診所"
    },
    {
      "code" : "3532082600",
      "display" : "桃德診所"
    },
    {
      "code" : "3532082628",
      "display" : "超群復健科診所"
    },
    {
      "code" : "3532082637",
      "display" : "八德彤顏診所"
    },
    {
      "code" : "3532082646",
      "display" : "聖傑診所"
    },
    {
      "code" : "3532082655",
      "display" : "晨峰診所"
    },
    {
      "code" : "3532082664",
      "display" : "雷亞診所"
    },
    {
      "code" : "3532082673",
      "display" : "介壽診所"
    },
    {
      "code" : "3532082682",
      "display" : "合杏骨科診所"
    },
    {
      "code" : "3532082691",
      "display" : "吉米診所"
    },
    {
      "code" : "3532082708",
      "display" : "光與自然博士眼科診所"
    },
    {
      "code" : "3532082717",
      "display" : "小柚子兒科診所"
    },
    {
      "code" : "3532082726",
      "display" : "李耳鼻喉科診所"
    },
    {
      "code" : "3532082735",
      "display" : "家悅診所"
    },
    {
      "code" : "3532082744",
      "display" : "維康診所"
    },
    {
      "code" : "3532082753",
      "display" : "陽光美膚診所"
    },
    {
      "code" : "3532082762",
      "display" : "八德慶鴻診所"
    },
    {
      "code" : "3532082780",
      "display" : "豐田診所"
    },
    {
      "code" : "3532082799",
      "display" : "我家診所"
    },
    {
      "code" : "3532082806",
      "display" : "桃德診所"
    },
    {
      "code" : "3532082815",
      "display" : "風禾內科診所"
    },
    {
      "code" : "3532082824",
      "display" : "閤樂親子診所"
    },
    {
      "code" : "3532082833",
      "display" : "一家人診所"
    },
    {
      "code" : "3532082842",
      "display" : "桃德診所"
    },
    {
      "code" : "3532082851",
      "display" : "八德金鶯診所"
    },
    {
      "code" : "3532082860",
      "display" : "新晨骨科診所"
    },
    {
      "code" : "3532082879",
      "display" : "福民診所"
    },
    {
      "code" : "3532082888",
      "display" : "八德金鶯診所"
    },
    {
      "code" : "3532082897",
      "display" : "佳昇診所"
    },
    {
      "code" : "3532082904",
      "display" : "八德桃鶯康澤復健科診所"
    },
    {
      "code" : "3532082913",
      "display" : "晨峰診所"
    },
    {
      "code" : "3532082922",
      "display" : "豐田健康診所"
    },
    {
      "code" : "3532082931",
      "display" : "大湳金鶯診所"
    },
    {
      "code" : "3532082940",
      "display" : "日日晴內科診所"
    },
    {
      "code" : "3532082959",
      "display" : "日日晴耳鼻喉科診所"
    },
    {
      "code" : "3532082968",
      "display" : "日日晴親子耳鼻喉科診所"
    },
    {
      "code" : "3532082977",
      "display" : "耀心泌尿科診所"
    },
    {
      "code" : "3532090095",
      "display" : "龍安診所"
    },
    {
      "code" : "3532090111",
      "display" : "盛杞診所"
    },
    {
      "code" : "3532090166",
      "display" : "李翌新診所"
    },
    {
      "code" : "3532090184",
      "display" : "陳隆開外科診所"
    },
    {
      "code" : "3532090200",
      "display" : "徐耳鼻喉科診所"
    },
    {
      "code" : "3532090219",
      "display" : "黃啟昌小兒科診所"
    },
    {
      "code" : "3532090264",
      "display" : "安嘉診所"
    },
    {
      "code" : "3532090273",
      "display" : "龍潭眼科診所"
    },
    {
      "code" : "3532090282",
      "display" : "張瑞巖婦產科診所"
    },
    {
      "code" : "3532090291",
      "display" : "明揚眼科診所"
    },
    {
      "code" : "3532090317",
      "display" : "龍華診所"
    },
    {
      "code" : "3532090380",
      "display" : "簡皮膚科診所"
    },
    {
      "code" : "3532090399",
      "display" : "葉步財診所"
    },
    {
      "code" : "3532090406",
      "display" : "龍合骨科診所"
    },
    {
      "code" : "3532090479",
      "display" : "五福診所"
    },
    {
      "code" : "3532091476",
      "display" : "弘揚診所"
    },
    {
      "code" : "3532091501",
      "display" : "重慶骨科診所"
    },
    {
      "code" : "3532091510",
      "display" : "子均婦產科診所"
    },
    {
      "code" : "3532091529",
      "display" : "佑康診所"
    },
    {
      "code" : "3532091565",
      "display" : "平安診所"
    },
    {
      "code" : "3532091654",
      "display" : "龍欣耳鼻喉科診所"
    },
    {
      "code" : "3532091672",
      "display" : "怡合診所"
    },
    {
      "code" : "3532091690",
      "display" : "楊延壽診所"
    },
    {
      "code" : "3532091707",
      "display" : "杏德芙診所"
    },
    {
      "code" : "3532091716",
      "display" : "怡美診所"
    },
    {
      "code" : "3532091743",
      "display" : "唯科診所"
    },
    {
      "code" : "3532091752",
      "display" : "蕭森元婦產科診所"
    },
    {
      "code" : "3532091761",
      "display" : "易修成診所"
    },
    {
      "code" : "3532091770",
      "display" : "鄭幼文內科診所"
    },
    {
      "code" : "3532091798",
      "display" : "龍潭大學眼科診所"
    },
    {
      "code" : "3532091805",
      "display" : "國家中山科學研究院石園診所"
    },
    {
      "code" : "3532091814",
      "display" : "和暘診所"
    },
    {
      "code" : "3532091823",
      "display" : "心悅診所"
    },
    {
      "code" : "3532091832",
      "display" : "同安親子診所"
    },
    {
      "code" : "3532091841",
      "display" : "百年診所"
    },
    {
      "code" : "3532091850",
      "display" : "龍恩診所"
    },
    {
      "code" : "3532091869",
      "display" : "安心親子耳鼻喉科診所"
    },
    {
      "code" : "3532091896",
      "display" : "宇康診所"
    },
    {
      "code" : "3532091912",
      "display" : "怡和診所"
    },
    {
      "code" : "3532091930",
      "display" : "龍潭金鶯診所"
    },
    {
      "code" : "3532091949",
      "display" : "謝忠岳診所"
    },
    {
      "code" : "3532100283",
      "display" : "傳生聯合診所"
    },
    {
      "code" : "3532100372",
      "display" : "鄧龍敦診所"
    },
    {
      "code" : "3532100532",
      "display" : "吉象耳鼻喉科診所"
    },
    {
      "code" : "3532100603",
      "display" : "金陵診所"
    },
    {
      "code" : "3532100612",
      "display" : "昇元診所"
    },
    {
      "code" : "3532100649",
      "display" : "吳英錦小兒科診所"
    },
    {
      "code" : "3532101708",
      "display" : "佳信診所"
    },
    {
      "code" : "3532101815",
      "display" : "和愛診所"
    },
    {
      "code" : "3532101860",
      "display" : "高俊傑診所"
    },
    {
      "code" : "3532101888",
      "display" : "新安診所"
    },
    {
      "code" : "3532101897",
      "display" : "育英診所"
    },
    {
      "code" : "3532101904",
      "display" : "張如昌診所"
    },
    {
      "code" : "3532102018",
      "display" : "明鴻診所"
    },
    {
      "code" : "3532102116",
      "display" : "振平診所"
    },
    {
      "code" : "3532102170",
      "display" : "文化診所"
    },
    {
      "code" : "3532102189",
      "display" : "佳杏診所"
    },
    {
      "code" : "3532102198",
      "display" : "怡家診所"
    },
    {
      "code" : "3532102214",
      "display" : "幫寶貝診所"
    },
    {
      "code" : "3532102232",
      "display" : "杏福診所"
    },
    {
      "code" : "3532102241",
      "display" : "永豐診所"
    },
    {
      "code" : "3532102269",
      "display" : "勇信診所"
    },
    {
      "code" : "3532102287",
      "display" : "維賢診所"
    },
    {
      "code" : "3532102296",
      "display" : "天一診所"
    },
    {
      "code" : "3532102303",
      "display" : "河助璽恒診所"
    },
    {
      "code" : "3532102312",
      "display" : "慧安診所"
    },
    {
      "code" : "3532102321",
      "display" : "聯恩診所"
    },
    {
      "code" : "3532102349",
      "display" : "龍岡長榮診所"
    },
    {
      "code" : "3532102358",
      "display" : "王德和診所"
    },
    {
      "code" : "3532102367",
      "display" : "黃正龍診所"
    },
    {
      "code" : "3532102385",
      "display" : "立群診所"
    },
    {
      "code" : "3532102394",
      "display" : "陽光耳鼻喉科診所"
    },
    {
      "code" : "3532102401",
      "display" : "延平診所"
    },
    {
      "code" : "3532102410",
      "display" : "立康南勢診所"
    },
    {
      "code" : "3532102438",
      "display" : "義群診所"
    },
    {
      "code" : "3532102447",
      "display" : "舒欣身心診所"
    },
    {
      "code" : "3532102465",
      "display" : "山賀診所"
    },
    {
      "code" : "3532102474",
      "display" : "昇禾診所"
    },
    {
      "code" : "3532102483",
      "display" : "佳群診所"
    },
    {
      "code" : "3532110092",
      "display" : "宏濟診所"
    },
    {
      "code" : "3532110556",
      "display" : "宏和診所"
    },
    {
      "code" : "3532110565",
      "display" : "佑生小兒科診所"
    },
    {
      "code" : "3532111688",
      "display" : "謝氏診所"
    },
    {
      "code" : "3532111731",
      "display" : "文正眼科診所"
    },
    {
      "code" : "3532111802",
      "display" : "佑明診所"
    },
    {
      "code" : "3532121675",
      "display" : "健亞診所"
    },
    {
      "code" : "3532121719",
      "display" : "吉星診所"
    },
    {
      "code" : "3532121773",
      "display" : "觀興診所"
    },
    {
      "code" : "3532121791",
      "display" : "健群診所"
    },
    {
      "code" : "3532121826",
      "display" : "全心診所"
    },
    {
      "code" : "3532121844",
      "display" : "聯禾診所"
    },
    {
      "code" : "3532121862",
      "display" : "甘之泉診所"
    },
    {
      "code" : "3532121871",
      "display" : "泰安診所"
    },
    {
      "code" : "3532131037",
      "display" : "三民診所"
    },
    {
      "code" : "3532131064",
      "display" : "林德忠診所"
    },
    {
      "code" : "3532131135",
      "display" : "高揚威家醫科診所"
    },
    {
      "code" : "3532131144",
      "display" : "泰千診所"
    },
    {
      "code" : "3533010055",
      "display" : "謝小兒科內科診所"
    },
    {
      "code" : "3533010082",
      "display" : "樹德診所"
    },
    {
      "code" : "3533010091",
      "display" : "日興家庭醫學科診所"
    },
    {
      "code" : "3533010162",
      "display" : "朱內科診所"
    },
    {
      "code" : "3533010199",
      "display" : "有田診所"
    },
    {
      "code" : "3533010206",
      "display" : "關心眼科診所"
    },
    {
      "code" : "3533010224",
      "display" : "十信診所"
    },
    {
      "code" : "3533011347",
      "display" : "小飛象醫師診所"
    },
    {
      "code" : "3533011356",
      "display" : "陳興港診所"
    },
    {
      "code" : "3533011365",
      "display" : "祐大骨外科診所"
    },
    {
      "code" : "3533011374",
      "display" : "哈佛診所"
    },
    {
      "code" : "3533011383",
      "display" : "北醫樂齡診所"
    },
    {
      "code" : "3533020051",
      "display" : "陳興閣診所"
    },
    {
      "code" : "3533020177",
      "display" : "葉甫盛診所"
    },
    {
      "code" : "3533020195",
      "display" : "陳逸鴻診所"
    },
    {
      "code" : "3533021281",
      "display" : "遠東診所"
    },
    {
      "code" : "3533021307",
      "display" : "安康診所"
    },
    {
      "code" : "3533021478",
      "display" : "陳能照診所"
    },
    {
      "code" : "3533021558",
      "display" : "頂竹骨科診所"
    },
    {
      "code" : "3533021567",
      "display" : "張紹演診所"
    },
    {
      "code" : "3533021576",
      "display" : "雲村診所"
    },
    {
      "code" : "3533021585",
      "display" : "朋程親子診所"
    },
    {
      "code" : "3533030011",
      "display" : "朱耳鼻喉科診所"
    },
    {
      "code" : "3533030093",
      "display" : "鄧診所"
    },
    {
      "code" : "3533030100",
      "display" : "和平診所"
    },
    {
      "code" : "3533030146",
      "display" : "羅內科小兒科診所"
    },
    {
      "code" : "3533030217",
      "display" : "蘇眼科診所"
    },
    {
      "code" : "3533030324",
      "display" : "鄧永堅小兒科診所"
    },
    {
      "code" : "3533030342",
      "display" : "心和診所"
    },
    {
      "code" : "3533030360",
      "display" : "劉外科診所"
    },
    {
      "code" : "3533030397",
      "display" : "林皮膚科診所"
    },
    {
      "code" : "3533030413",
      "display" : "寶寶內科小兒科診所"
    },
    {
      "code" : "3533030440",
      "display" : "呂紹達內科診所"
    },
    {
      "code" : "3533030459",
      "display" : "崇安診所"
    },
    {
      "code" : "3533030502",
      "display" : "陳眼科診所"
    },
    {
      "code" : "3533030511",
      "display" : "王尹弘耳鼻喉科診所"
    },
    {
      "code" : "3533030539",
      "display" : "長春診所"
    },
    {
      "code" : "3533030557",
      "display" : "藍青復健診所"
    },
    {
      "code" : "3533030584",
      "display" : "曾政德婦產科外科診所"
    },
    {
      "code" : "3533030600",
      "display" : "張世澤眼科診所"
    },
    {
      "code" : "3533030637",
      "display" : "王仁俊小兒科診所"
    },
    {
      "code" : "3533031689",
      "display" : "安慎診所"
    },
    {
      "code" : "3533031698",
      "display" : "中央聯合診所(原為中央復健診所)"
    },
    {
      "code" : "3533031723",
      "display" : "陽明小兒科耳鼻喉科聯合診所"
    },
    {
      "code" : "3533031732",
      "display" : "德安聯合診所"
    },
    {
      "code" : "3533031750",
      "display" : "嘉良診所"
    },
    {
      "code" : "3533031796",
      "display" : "張景隆小兒科診所"
    },
    {
      "code" : "3533031812",
      "display" : "松禾診所"
    },
    {
      "code" : "3533031821",
      "display" : "崇光小兒專科診所"
    },
    {
      "code" : "3533031849",
      "display" : "黃診所"
    },
    {
      "code" : "3533031867",
      "display" : "冠興診所"
    },
    {
      "code" : "3533031876",
      "display" : "張國珍小兒科診所"
    },
    {
      "code" : "3533031885",
      "display" : "傅國維診所"
    },
    {
      "code" : "3533031910",
      "display" : "康健診所"
    },
    {
      "code" : "3533031929",
      "display" : "陽光精神科診所"
    },
    {
      "code" : "3533031947",
      "display" : "佳和婦產科診所"
    },
    {
      "code" : "3533031956",
      "display" : "蕭景欽診所"
    },
    {
      "code" : "3533031965",
      "display" : "弘康診所"
    },
    {
      "code" : "3533031983",
      "display" : "瑞安診所"
    },
    {
      "code" : "3533032006",
      "display" : "工業技術研究院醫務室"
    },
    {
      "code" : "3533032015",
      "display" : "平安葉國安耳鼻喉科診所"
    },
    {
      "code" : "3533032024",
      "display" : "平安李昀璇診所"
    },
    {
      "code" : "3533032033",
      "display" : "李傳盛家醫診所"
    },
    {
      "code" : "3533032042",
      "display" : "長春骨科診所"
    },
    {
      "code" : "3533032051",
      "display" : "照耀身心精神科診所"
    },
    {
      "code" : "3533032060",
      "display" : "宏竹骨科診所"
    },
    {
      "code" : "3533032079",
      "display" : "永安診所"
    },
    {
      "code" : "3533050148",
      "display" : "黃婦產科診所"
    },
    {
      "code" : "3533050157",
      "display" : "彭小兒科內科診所"
    },
    {
      "code" : "3533050184",
      "display" : "楊診所"
    },
    {
      "code" : "3533050237",
      "display" : "古有馨眼科診所"
    },
    {
      "code" : "3533050255",
      "display" : "劉智暉耳鼻喉科診所"
    },
    {
      "code" : "3533050273",
      "display" : "彭福麒小兒科診所"
    },
    {
      "code" : "3533050317",
      "display" : "彭眼科診所"
    },
    {
      "code" : "3533050326",
      "display" : "曾文鎮耳鼻喉科診所"
    },
    {
      "code" : "3533050335",
      "display" : "邱永和婦產科診所"
    },
    {
      "code" : "3533050353",
      "display" : "戴芳正診所"
    },
    {
      "code" : "3533050380",
      "display" : "曾文智診所"
    },
    {
      "code" : "3533050399",
      "display" : "新時代眼科診所"
    },
    {
      "code" : "3533050424",
      "display" : "崇美診所"
    },
    {
      "code" : "3533050442",
      "display" : "陳倫平婦產專科診所"
    },
    {
      "code" : "3533050460",
      "display" : "瑞麟診所"
    },
    {
      "code" : "3533051476",
      "display" : "宏仁耳鼻喉專科診所"
    },
    {
      "code" : "3533051485",
      "display" : "鄭新景骨科外科診所"
    },
    {
      "code" : "3533051501",
      "display" : "第一聯合診所"
    },
    {
      "code" : "3533051510",
      "display" : "柏安耳鼻喉科診所"
    },
    {
      "code" : "3533051547",
      "display" : "傅仁良小兒科診所"
    },
    {
      "code" : "3533051556",
      "display" : "彭聖勇小兒科內科專科診所"
    },
    {
      "code" : "3533051574",
      "display" : "劉家麟皮膚專科診所"
    },
    {
      "code" : "3533051583",
      "display" : "陳壽祥小兒科診所"
    },
    {
      "code" : "3533051609",
      "display" : "仁和復健科診所"
    },
    {
      "code" : "3533051618",
      "display" : "六竹診所"
    },
    {
      "code" : "3533051627",
      "display" : "劉信志診所"
    },
    {
      "code" : "3533051636",
      "display" : "游恆懿診所"
    },
    {
      "code" : "3533051654",
      "display" : "竹安眼科診所"
    },
    {
      "code" : "3533051672",
      "display" : "謝連中診所"
    },
    {
      "code" : "3533051681",
      "display" : "張仁祥眼科診所"
    },
    {
      "code" : "3533051707",
      "display" : "林銘淞耳鼻喉科診所"
    },
    {
      "code" : "3533051716",
      "display" : "李克隆小兒科診所"
    },
    {
      "code" : "3533051734",
      "display" : "潘昆瑩診所"
    },
    {
      "code" : "3533051743",
      "display" : "曾文怡診所"
    },
    {
      "code" : "3533051752",
      "display" : "比漾皮膚科診所"
    },
    {
      "code" : "3533051770",
      "display" : "張嘉榮診所"
    },
    {
      "code" : "3533051823",
      "display" : "光明復健診所"
    },
    {
      "code" : "3533051832",
      "display" : "翁佩魁小兒專科診所"
    },
    {
      "code" : "3533051841",
      "display" : "杏安診所"
    },
    {
      "code" : "3533051903",
      "display" : "麥建方小兒專科診所"
    },
    {
      "code" : "3533051921",
      "display" : "游丞顯小兒科診所"
    },
    {
      "code" : "3533051930",
      "display" : "健祥小兒科診所"
    },
    {
      "code" : "3533051956",
      "display" : "安立身心診所"
    },
    {
      "code" : "3533051967",
      "display" : "賴義傑皮膚專科診所"
    },
    {
      "code" : "3533051985",
      "display" : "台齡身心診所"
    },
    {
      "code" : "3533052044",
      "display" : "惠慎診所"
    },
    {
      "code" : "3533052080",
      "display" : "麗明眼科診所"
    },
    {
      "code" : "3533052099",
      "display" : "啄木鳥耳鼻喉科診所"
    },
    {
      "code" : "3533052106",
      "display" : "智康泌尿科診所"
    },
    {
      "code" : "3533052115",
      "display" : "康青骨科診所"
    },
    {
      "code" : "3533052188",
      "display" : "沛群耳鼻喉專科診所"
    },
    {
      "code" : "3533052197",
      "display" : "張建智內科診所"
    },
    {
      "code" : "3533052222",
      "display" : "洪瑞聰小兒專科診所"
    },
    {
      "code" : "3533052240",
      "display" : "王伯堅診所"
    },
    {
      "code" : "3533052302",
      "display" : "皇嘉骨科診所"
    },
    {
      "code" : "3533052348",
      "display" : "竹仁婦幼診所"
    },
    {
      "code" : "3533052366",
      "display" : "凃富籌復健診所"
    },
    {
      "code" : "3533052384",
      "display" : "日康診所"
    },
    {
      "code" : "3533052491",
      "display" : "艾兒診所"
    },
    {
      "code" : "3533052517",
      "display" : "顏明通婦產科診所"
    },
    {
      "code" : "3533052599",
      "display" : "達文希診所"
    },
    {
      "code" : "3533052606",
      "display" : "大家診所"
    },
    {
      "code" : "3533052651",
      "display" : "維格醫美診所"
    },
    {
      "code" : "3533052660",
      "display" : "育禾婦幼診所"
    },
    {
      "code" : "3533052679",
      "display" : "新瓦屋小兒科診所"
    },
    {
      "code" : "3533052688",
      "display" : "昊霖診所"
    },
    {
      "code" : "3533052722",
      "display" : "普懷醫學診所"
    },
    {
      "code" : "3533052740",
      "display" : "金慧親子耳鼻喉科診所"
    },
    {
      "code" : "3533052777",
      "display" : "歌斐木診所"
    },
    {
      "code" : "3533052786",
      "display" : "立安親子診所"
    },
    {
      "code" : "3533052802",
      "display" : "戴國城診所"
    },
    {
      "code" : "3533052811",
      "display" : "哈哈親子小兒科診所"
    },
    {
      "code" : "3533052820",
      "display" : "竹北上允耳鼻喉科診所"
    },
    {
      "code" : "3533052839",
      "display" : "高名診所"
    },
    {
      "code" : "3533052848",
      "display" : "鄭朝宇小兒科診所"
    },
    {
      "code" : "3533052875",
      "display" : "竹佑親子診所"
    },
    {
      "code" : "3533052884",
      "display" : "吳冠興皮膚科診所"
    },
    {
      "code" : "3533052893",
      "display" : "暖陽身心診所"
    },
    {
      "code" : "3533052900",
      "display" : "優視全方位眼科診所"
    },
    {
      "code" : "3533052919",
      "display" : "歆美皮診所"
    },
    {
      "code" : "3533052928",
      "display" : "益康耳鼻喉科診所"
    },
    {
      "code" : "3533052946",
      "display" : "嘉正耳鼻喉科診所"
    },
    {
      "code" : "3533052955",
      "display" : "美的整形外科診所"
    },
    {
      "code" : "3533052964",
      "display" : "黃煌富身心診所"
    },
    {
      "code" : "3533052991",
      "display" : "上杉診所"
    },
    {
      "code" : "3533053014",
      "display" : "噹好復健科診所"
    },
    {
      "code" : "3533053032",
      "display" : "新竹諾貝爾眼科診所"
    },
    {
      "code" : "3533053069",
      "display" : "遠見眼科診所"
    },
    {
      "code" : "3533053078",
      "display" : "雅丰竹北診所"
    },
    {
      "code" : "3533053103",
      "display" : "福瑞骨科診所"
    },
    {
      "code" : "3533053112",
      "display" : "聖永診所"
    },
    {
      "code" : "3533053149",
      "display" : "合江骨科診所"
    },
    {
      "code" : "3533053167",
      "display" : "優仕奇診所"
    },
    {
      "code" : "3533053176",
      "display" : "適康復健科診所"
    },
    {
      "code" : "3533053185",
      "display" : "杏美診所"
    },
    {
      "code" : "3533053210",
      "display" : "周伯翰身心醫學診所"
    },
    {
      "code" : "3533053238",
      "display" : "和沐復健專科診所"
    },
    {
      "code" : "3533053256",
      "display" : "嘉豐小森林兒科診所"
    },
    {
      "code" : "3533053265",
      "display" : "言恩診所"
    },
    {
      "code" : "3533053274",
      "display" : "敏悅日安耳鼻喉科診所"
    },
    {
      "code" : "3533053283",
      "display" : "瑞安耳鼻喉科診所"
    },
    {
      "code" : "3533053292",
      "display" : "蒔蒔診所"
    },
    {
      "code" : "3533053309",
      "display" : "佑達泌尿科診所"
    },
    {
      "code" : "3533053336",
      "display" : "文興親子診所"
    },
    {
      "code" : "3533053345",
      "display" : "愛樂醫診所"
    },
    {
      "code" : "3533053372",
      "display" : "竹北聯新運動醫學診所"
    },
    {
      "code" : "3533053381",
      "display" : "健全曼哈頓美學診所"
    },
    {
      "code" : "3533053407",
      "display" : "均安身心診所"
    },
    {
      "code" : "3533053416",
      "display" : "藝群新竹診所"
    },
    {
      "code" : "3533053425",
      "display" : "好膽胰診所"
    },
    {
      "code" : "3533053461",
      "display" : "竹北大學眼科診所"
    },
    {
      "code" : "3533053505",
      "display" : "宇成診所"
    },
    {
      "code" : "3533053514",
      "display" : "青心診所"
    },
    {
      "code" : "3533053532",
      "display" : "諦聽智慧診所"
    },
    {
      "code" : "3533053541",
      "display" : "博威診所"
    },
    {
      "code" : "3533053550",
      "display" : "竹北現代內科診所"
    },
    {
      "code" : "3533060153",
      "display" : "朱先營診所"
    },
    {
      "code" : "3533060162",
      "display" : "彭及江家庭醫學科診所"
    },
    {
      "code" : "3533060260",
      "display" : "陳岱全診所"
    },
    {
      "code" : "3533060279",
      "display" : "鄭聯合診所"
    },
    {
      "code" : "3533060322",
      "display" : "蘇明川耳鼻喉科診所"
    },
    {
      "code" : "3533061409",
      "display" : "柯介仁診所"
    },
    {
      "code" : "3533061418",
      "display" : "周診所"
    },
    {
      "code" : "3533061552",
      "display" : "信安眼科診所"
    },
    {
      "code" : "3533061632",
      "display" : "祐健診所"
    },
    {
      "code" : "3533061669",
      "display" : "天主教聖母診所"
    },
    {
      "code" : "3533061678",
      "display" : "育創診所"
    },
    {
      "code" : "3533061687",
      "display" : "成功診所"
    },
    {
      "code" : "3533061696",
      "display" : "富田診所"
    },
    {
      "code" : "3533061712",
      "display" : "創意診所"
    },
    {
      "code" : "3533061721",
      "display" : "友豐親子診所"
    },
    {
      "code" : "3533061749",
      "display" : "彥涵復健科診所"
    },
    {
      "code" : "3533061758",
      "display" : "祐嘉復健科骨科診所"
    },
    {
      "code" : "3533061794",
      "display" : "羽田診所"
    },
    {
      "code" : "3533061801",
      "display" : "豐安診所"
    },
    {
      "code" : "3533071058",
      "display" : "橫山庄診所"
    },
    {
      "code" : "3533080020",
      "display" : "健安婦產科診所"
    },
    {
      "code" : "3533080226",
      "display" : "羅世績診所"
    },
    {
      "code" : "3533080235",
      "display" : "張復健科診所"
    },
    {
      "code" : "3533080271",
      "display" : "胡兆陵診所"
    },
    {
      "code" : "3533080299",
      "display" : "吳家仁小兒科診所"
    },
    {
      "code" : "3533081321",
      "display" : "正翔診所"
    },
    {
      "code" : "3533081401",
      "display" : "潔明眼科診所"
    },
    {
      "code" : "3533081456",
      "display" : "康馨診所"
    },
    {
      "code" : "3533081465",
      "display" : "普濟診所"
    },
    {
      "code" : "3533081474",
      "display" : "林鴻志診所"
    },
    {
      "code" : "3533081483",
      "display" : "泰生婦產科診所"
    },
    {
      "code" : "3533081492",
      "display" : "祐寧骨外科診所"
    },
    {
      "code" : "3533081518",
      "display" : "瀚華診所"
    },
    {
      "code" : "3533081536",
      "display" : "永杏小兒科診所"
    },
    {
      "code" : "3533081545",
      "display" : "豐泰耳鼻喉科診所"
    },
    {
      "code" : "3533081563",
      "display" : "林鴻欣皮膚科診所"
    },
    {
      "code" : "3533081572",
      "display" : "廣慈診所"
    },
    {
      "code" : "3533081581",
      "display" : "新豐上允耳鼻喉科診所"
    },
    {
      "code" : "3533081590",
      "display" : "杜宜霖診所"
    },
    {
      "code" : "3533090044",
      "display" : "平安診所"
    },
    {
      "code" : "3533100027",
      "display" : "民安診所"
    },
    {
      "code" : "3533111075",
      "display" : "徐診所"
    },
    {
      "code" : "3533131031",
      "display" : "彭國楨診所"
    },
    {
      "code" : "3533131040",
      "display" : "嘉樂泰千診所"
    },
    {
      "code" : "3533140530",
      "display" : "泰千診所"
    },
    {
      "code" : "3535010035",
      "display" : "劉士桐診所"
    },
    {
      "code" : "3535010062",
      "display" : "陳耳鼻喉科診所"
    },
    {
      "code" : "3535010133",
      "display" : "中心診所"
    },
    {
      "code" : "3535010188",
      "display" : "仁暉診所"
    },
    {
      "code" : "3535010302",
      "display" : "周內科診所"
    },
    {
      "code" : "3535010393",
      "display" : "彭內科診所"
    },
    {
      "code" : "3535010428",
      "display" : "江建旺診所"
    },
    {
      "code" : "3535010437",
      "display" : "健群外科診所"
    },
    {
      "code" : "3535010473",
      "display" : "林苗婦產科診所"
    },
    {
      "code" : "3535010491",
      "display" : "黃內皮膚科診所"
    },
    {
      "code" : "3535010517",
      "display" : "楊宏源診所"
    },
    {
      "code" : "3535010526",
      "display" : "明星婦產科診所"
    },
    {
      "code" : "3535010535",
      "display" : "吳石川小兒科診所"
    },
    {
      "code" : "3535010553",
      "display" : "詹求孚診所"
    },
    {
      "code" : "3535010615",
      "display" : "解皮膚科診所"
    },
    {
      "code" : "3535010704",
      "display" : "劉文淦小兒科診所"
    },
    {
      "code" : "3535010713",
      "display" : "李仁超小兒科診所"
    },
    {
      "code" : "3535010777",
      "display" : "竹苗眼科診所"
    },
    {
      "code" : "3535010786",
      "display" : "黃明玲皮膚科診所"
    },
    {
      "code" : "3535010795",
      "display" : "何智博診所"
    },
    {
      "code" : "3535010802",
      "display" : "吳耳鼻喉科診所"
    },
    {
      "code" : "3535010884",
      "display" : "楊克寧婦產科診所"
    },
    {
      "code" : "3535010893",
      "display" : "邱啟恭診所"
    },
    {
      "code" : "3535011961",
      "display" : "周博治婦產科診所"
    },
    {
      "code" : "3535011970",
      "display" : "惠和診所"
    },
    {
      "code" : "3535012011",
      "display" : "天恩診所"
    },
    {
      "code" : "3535012039",
      "display" : "葉耳鼻喉科診所"
    },
    {
      "code" : "3535012048",
      "display" : "楊國君診所"
    },
    {
      "code" : "3535012066",
      "display" : "趙耳鼻喉科診所"
    },
    {
      "code" : "3535012075",
      "display" : "台糖診所"
    },
    {
      "code" : "3535012137",
      "display" : "弘明眼科診所"
    },
    {
      "code" : "3535012164",
      "display" : "康平皮膚科診所"
    },
    {
      "code" : "3535012173",
      "display" : "吳昆展小兒科診所"
    },
    {
      "code" : "3535012182",
      "display" : "蘇眼科診所"
    },
    {
      "code" : "3535012217",
      "display" : "德恩診所"
    },
    {
      "code" : "3535012235",
      "display" : "舒康診所"
    },
    {
      "code" : "3535012244",
      "display" : "張英俊診所"
    },
    {
      "code" : "3535012271",
      "display" : "益康診所"
    },
    {
      "code" : "3535012315",
      "display" : "蕭銘賢診所"
    },
    {
      "code" : "3535012342",
      "display" : "蔡志弦診所"
    },
    {
      "code" : "3535012388",
      "display" : "宏福診所"
    },
    {
      "code" : "3535012413",
      "display" : "長頸鹿診所"
    },
    {
      "code" : "3535012422",
      "display" : "何啟瑞診所"
    },
    {
      "code" : "3535012459",
      "display" : "福苗診所"
    },
    {
      "code" : "3535012468",
      "display" : "永旭診所"
    },
    {
      "code" : "3535012477",
      "display" : "林可迅診所"
    },
    {
      "code" : "3535012495",
      "display" : "正安診所"
    },
    {
      "code" : "3535012502",
      "display" : "吳四維診所"
    },
    {
      "code" : "3535012511",
      "display" : "心安診所"
    },
    {
      "code" : "3535012520",
      "display" : "大川診所"
    },
    {
      "code" : "3535012539",
      "display" : "明星診所"
    },
    {
      "code" : "3535020120",
      "display" : "王內科精神科診所"
    },
    {
      "code" : "3535020157",
      "display" : "視保眼科診所"
    },
    {
      "code" : "3535020166",
      "display" : "台安診所"
    },
    {
      "code" : "3535021252",
      "display" : "小太陽小兒科診所"
    },
    {
      "code" : "3535021261",
      "display" : "智光診所"
    },
    {
      "code" : "3535021314",
      "display" : "小朋友小兒科診所"
    },
    {
      "code" : "3535021341",
      "display" : "善美診所"
    },
    {
      "code" : "3535021350",
      "display" : "天慈身心科診所"
    },
    {
      "code" : "3535021396",
      "display" : "良宜診所"
    },
    {
      "code" : "3535021430",
      "display" : "怡安診所"
    },
    {
      "code" : "3535021476",
      "display" : "長春診所"
    },
    {
      "code" : "3535021501",
      "display" : "暘明診所"
    },
    {
      "code" : "3535021510",
      "display" : "真心診所"
    },
    {
      "code" : "3535021529",
      "display" : "安平診所"
    },
    {
      "code" : "3535021547",
      "display" : "杏安診所"
    },
    {
      "code" : "3535021556",
      "display" : "安和診所"
    },
    {
      "code" : "3535021565",
      "display" : "里仁診所"
    },
    {
      "code" : "3535021574",
      "display" : "明陽診所"
    },
    {
      "code" : "3535021583",
      "display" : "安平診所"
    },
    {
      "code" : "3535030019",
      "display" : "新仁診所"
    },
    {
      "code" : "3535030055",
      "display" : "扶生家庭醫學科診所"
    },
    {
      "code" : "3535030082",
      "display" : "新安內科小兒科診所"
    },
    {
      "code" : "3535030135",
      "display" : "羅耳鼻喉科診所"
    },
    {
      "code" : "3535030288",
      "display" : "宜佑診所"
    },
    {
      "code" : "3535031445",
      "display" : "通霄診所"
    },
    {
      "code" : "3535031490",
      "display" : "仁泰診所"
    },
    {
      "code" : "3535031561",
      "display" : "立健診所"
    },
    {
      "code" : "3535040122",
      "display" : "邱外科診所"
    },
    {
      "code" : "3535040159",
      "display" : "張耳鼻喉科診所"
    },
    {
      "code" : "3535040220",
      "display" : "陳眼科診所"
    },
    {
      "code" : "3535040239",
      "display" : "連進昌診所"
    },
    {
      "code" : "3535040257",
      "display" : "長青皮膚科診所"
    },
    {
      "code" : "3535040293",
      "display" : "黃正昇診所"
    },
    {
      "code" : "3535040319",
      "display" : "吳診所"
    },
    {
      "code" : "3535040328",
      "display" : "昇目眼科診所"
    },
    {
      "code" : "3535040337",
      "display" : "威德內科診所"
    },
    {
      "code" : "3535040355",
      "display" : "楊章民耳鼻喉科診所"
    },
    {
      "code" : "3535040373",
      "display" : "陳泮基耳鼻喉科診所"
    },
    {
      "code" : "3535041414",
      "display" : "黃甫彥婦產科"
    },
    {
      "code" : "3535041423",
      "display" : "南光門診聯合診所"
    },
    {
      "code" : "3535041469",
      "display" : "京典麗緻診所"
    },
    {
      "code" : "3535041503",
      "display" : "邱文仁小兒科診所"
    },
    {
      "code" : "3535041512",
      "display" : "永佳診所"
    },
    {
      "code" : "3535041594",
      "display" : "高秀春小兒科診所"
    },
    {
      "code" : "3535041610",
      "display" : "福康診所"
    },
    {
      "code" : "3535041638",
      "display" : "宏安診所"
    },
    {
      "code" : "3535041647",
      "display" : "宏仁診所"
    },
    {
      "code" : "3535041674",
      "display" : "楊內科診所"
    },
    {
      "code" : "3535041718",
      "display" : "活力診所"
    },
    {
      "code" : "3535041727",
      "display" : "順春診所"
    },
    {
      "code" : "3535041736",
      "display" : "聖福診所"
    },
    {
      "code" : "3535041745",
      "display" : "竹南診所"
    },
    {
      "code" : "3535041754",
      "display" : "德安診所"
    },
    {
      "code" : "3535041772",
      "display" : "許順㨗診所"
    },
    {
      "code" : "3535041781",
      "display" : "悅健耳鼻喉科診所"
    },
    {
      "code" : "3535041790",
      "display" : "竹南諾貝爾眼科診所"
    },
    {
      "code" : "3535041807",
      "display" : "有謙診所"
    },
    {
      "code" : "3535041816",
      "display" : "林佳霓家醫科診所"
    },
    {
      "code" : "3535050066",
      "display" : "張內科診所"
    },
    {
      "code" : "3535050146",
      "display" : "祥安診所"
    },
    {
      "code" : "3535050191",
      "display" : "陳晟康眼科診所"
    },
    {
      "code" : "3535050208",
      "display" : "溫診所"
    },
    {
      "code" : "3535050217",
      "display" : "簡維崧診所"
    },
    {
      "code" : "3535050235",
      "display" : "莊耳鼻喉科診所"
    },
    {
      "code" : "3535050253",
      "display" : "常青診所"
    },
    {
      "code" : "3535050299",
      "display" : "林可羽婦產科診所"
    },
    {
      "code" : "3535050306",
      "display" : "和平眼科診所"
    },
    {
      "code" : "3535050360",
      "display" : "仁心診所"
    },
    {
      "code" : "3535050388",
      "display" : "吳金垣小兒科診所"
    },
    {
      "code" : "3535051438",
      "display" : "鄭逢源耳鼻喉科診所"
    },
    {
      "code" : "3535051474",
      "display" : "建國耳鼻喉科診所"
    },
    {
      "code" : "3535051509",
      "display" : "晟新診所"
    },
    {
      "code" : "3535051518",
      "display" : "慈惠聯合診所"
    },
    {
      "code" : "3535051527",
      "display" : "何智超診所"
    },
    {
      "code" : "3535051536",
      "display" : "新愛兒診所"
    },
    {
      "code" : "3535051607",
      "display" : "丘小江小兒科診所"
    },
    {
      "code" : "3535051652",
      "display" : "吳兆章皮膚科診所"
    },
    {
      "code" : "3535051750",
      "display" : "承美身心科診所"
    },
    {
      "code" : "3535051769",
      "display" : "鎮安骨科診所"
    },
    {
      "code" : "3535051778",
      "display" : "人醫診所"
    },
    {
      "code" : "3535051787",
      "display" : "杜俊呈眼科診所"
    },
    {
      "code" : "3535051796",
      "display" : "奚道鈞眼科診所"
    },
    {
      "code" : "3535051803",
      "display" : "蘇志勇診所"
    },
    {
      "code" : "3535051812",
      "display" : "李欣祈診所"
    },
    {
      "code" : "3535051830",
      "display" : "黃耳鼻喉科診所"
    },
    {
      "code" : "3535051849",
      "display" : "施宏俊皮膚專科診所"
    },
    {
      "code" : "3535051876",
      "display" : "李裕清婦產科診所"
    },
    {
      "code" : "3535051894",
      "display" : "翰群骨科專科診所"
    },
    {
      "code" : "3535051901",
      "display" : "白蕙菁診所"
    },
    {
      "code" : "3535051929",
      "display" : "頭份儷馨診所"
    },
    {
      "code" : "3535051947",
      "display" : "崇仁診所"
    },
    {
      "code" : "3535051965",
      "display" : "何復健科診所"
    },
    {
      "code" : "3535051974",
      "display" : "葉診所"
    },
    {
      "code" : "3535051983",
      "display" : "頭份心安診所"
    },
    {
      "code" : "3535051992",
      "display" : "培倫診所"
    },
    {
      "code" : "3535052006",
      "display" : "欣和慎診所"
    },
    {
      "code" : "3535052015",
      "display" : "慈惠診所"
    },
    {
      "code" : "3535060044",
      "display" : "邱內科小兒科診所"
    },
    {
      "code" : "3535060204",
      "display" : "光田診所"
    },
    {
      "code" : "3535060222",
      "display" : "張聯合診所"
    },
    {
      "code" : "3535061247",
      "display" : "和信診所"
    },
    {
      "code" : "3535061265",
      "display" : "新光診所"
    },
    {
      "code" : "3535061372",
      "display" : "賜生堂診所"
    },
    {
      "code" : "3535061407",
      "display" : "龍安診所"
    },
    {
      "code" : "3535061425",
      "display" : "龍澄診所"
    },
    {
      "code" : "3535061434",
      "display" : "後龍診所"
    },
    {
      "code" : "3535071145",
      "display" : "卓錫彬診所"
    },
    {
      "code" : "3535071234",
      "display" : "安康診所"
    },
    {
      "code" : "3535071261",
      "display" : "老庄診所"
    },
    {
      "code" : "3535071270",
      "display" : "卓蘭鎮農會附設農民診所"
    },
    {
      "code" : "3535071323",
      "display" : "卓蘭農民診所"
    },
    {
      "code" : "3535080064",
      "display" : "李煜伸診所"
    },
    {
      "code" : "3535080073",
      "display" : "徐明宏診所"
    },
    {
      "code" : "3535090060",
      "display" : "張仲達診所"
    },
    {
      "code" : "3535090107",
      "display" : "廖本能診所"
    },
    {
      "code" : "3535091165",
      "display" : "祥恩診所"
    },
    {
      "code" : "3535091174",
      "display" : "張文源耳鼻喉科診所"
    },
    {
      "code" : "3535091209",
      "display" : "劉樵霖診所"
    },
    {
      "code" : "3535091227",
      "display" : "家正診所"
    },
    {
      "code" : "3535091245",
      "display" : "公館診所"
    },
    {
      "code" : "3535100070",
      "display" : "賴孟彥診所"
    },
    {
      "code" : "3535100089",
      "display" : "佑誠診所"
    },
    {
      "code" : "3535101095",
      "display" : "平安診所"
    },
    {
      "code" : "3535101111",
      "display" : "千宏診所"
    },
    {
      "code" : "3535111126",
      "display" : "福安診所"
    },
    {
      "code" : "3535111162",
      "display" : "安立診所"
    },
    {
      "code" : "3535111180",
      "display" : "民恩診所"
    },
    {
      "code" : "3535111199",
      "display" : "光禾診所"
    },
    {
      "code" : "3535120018",
      "display" : "煥陽診所"
    },
    {
      "code" : "3535121104",
      "display" : "大仁診所"
    },
    {
      "code" : "3535121113",
      "display" : "佑安診所"
    },
    {
      "code" : "3535121140",
      "display" : "頭屋診所"
    },
    {
      "code" : "3535131164",
      "display" : "農安診所"
    },
    {
      "code" : "3535131182",
      "display" : "惠生診所"
    },
    {
      "code" : "3535131253",
      "display" : "慈健診所"
    },
    {
      "code" : "3535141053",
      "display" : "三湖診所"
    },
    {
      "code" : "3535151139",
      "display" : "大坪診所"
    },
    {
      "code" : "3535151166",
      "display" : "永安診所"
    },
    {
      "code" : "3535161046",
      "display" : "三灣診所"
    },
    {
      "code" : "3535170545",
      "display" : "合樂診所"
    },
    {
      "code" : "3535181100",
      "display" : "清安診所"
    },
    {
      "code" : "3535181119",
      "display" : "泰安診所"
    },
    {
      "code" : "3712010086",
      "display" : "聯合牙醫診所"
    },
    {
      "code" : "3712010102",
      "display" : "明皓牙醫診所"
    },
    {
      "code" : "3712010166",
      "display" : "維泰牙醫診所"
    },
    {
      "code" : "3712010193",
      "display" : "孫牙醫診所"
    },
    {
      "code" : "3712010219",
      "display" : "宏昌牙醫診所"
    },
    {
      "code" : "3712010228",
      "display" : "大新牙醫診所"
    },
    {
      "code" : "3712010237",
      "display" : "蔡牙醫診所"
    },
    {
      "code" : "3712010255",
      "display" : "大學牙醫診所"
    },
    {
      "code" : "3712010264",
      "display" : "銘仁牙醫診所"
    },
    {
      "code" : "3712010291",
      "display" : "鄭牙醫診所"
    },
    {
      "code" : "3712010344",
      "display" : "禮正牙醫診所"
    },
    {
      "code" : "3712010371",
      "display" : "沈牙醫診所"
    },
    {
      "code" : "3712010380",
      "display" : "新明牙醫診所"
    },
    {
      "code" : "3712010399",
      "display" : "溫牙醫診所"
    },
    {
      "code" : "3712010406",
      "display" : "唐牙醫診所"
    },
    {
      "code" : "3712010424",
      "display" : "惠群牙醫診所"
    },
    {
      "code" : "3712010442",
      "display" : "親親牙醫診所"
    },
    {
      "code" : "3712010451",
      "display" : "明湖牙醫診所"
    },
    {
      "code" : "3712010460",
      "display" : "光復牙醫診所"
    },
    {
      "code" : "3712010479",
      "display" : "尖端牙醫診所"
    },
    {
      "code" : "3712010488",
      "display" : "三民牙醫診所"
    },
    {
      "code" : "3712010497",
      "display" : "陳奕熹牙醫診所"
    },
    {
      "code" : "3712010522",
      "display" : "中心牙醫診所"
    },
    {
      "code" : "3712010531",
      "display" : "曾元春牙醫診所"
    },
    {
      "code" : "3712010577",
      "display" : "智信牙醫診所"
    },
    {
      "code" : "3712010620",
      "display" : "先進牙醫診所"
    },
    {
      "code" : "3712010639",
      "display" : "金明牙醫診所"
    },
    {
      "code" : "3712010648",
      "display" : "信愛牙醫診所"
    },
    {
      "code" : "3712010657",
      "display" : "崇善牙醫診所"
    },
    {
      "code" : "3712010666",
      "display" : "崇安牙醫診所"
    },
    {
      "code" : "3712010675",
      "display" : "王子牙醫診所"
    },
    {
      "code" : "3712010684",
      "display" : "珂牙醫診所"
    },
    {
      "code" : "3712010746",
      "display" : "宏大牙醫診所"
    },
    {
      "code" : "3712010773",
      "display" : "簡牙醫診所"
    },
    {
      "code" : "3712010782",
      "display" : "上慈牙醫診所"
    },
    {
      "code" : "3712010791",
      "display" : "貝多芬牙醫診所"
    },
    {
      "code" : "3712010808",
      "display" : "關東橋仁美牙醫診所"
    },
    {
      "code" : "3712010817",
      "display" : "榮信牙醫診所"
    },
    {
      "code" : "3712010826",
      "display" : "誼安牙醫診所"
    },
    {
      "code" : "3712010835",
      "display" : "品傑牙醫診所"
    },
    {
      "code" : "3712010844",
      "display" : "陳慧貞牙醫診所"
    },
    {
      "code" : "3712010899",
      "display" : "米羅牙醫診所"
    },
    {
      "code" : "3712010979",
      "display" : "佳新牙醫診所"
    },
    {
      "code" : "3712010988",
      "display" : "雅旭牙醫診所"
    },
    {
      "code" : "3712012008",
      "display" : "普洛牙醫診所"
    },
    {
      "code" : "3712012044",
      "display" : "美日牙醫診所"
    },
    {
      "code" : "3712012071",
      "display" : "國喬牙醫診所"
    },
    {
      "code" : "3712012080",
      "display" : "敦品牙醫診所"
    },
    {
      "code" : "3712012106",
      "display" : "德陞牙醫診所"
    },
    {
      "code" : "3712012115",
      "display" : "皇家牙醫診所"
    },
    {
      "code" : "3712012151",
      "display" : "秀雅牙醫診所"
    },
    {
      "code" : "3712012179",
      "display" : "微笑牙醫診所"
    },
    {
      "code" : "3712012231",
      "display" : "達觀牙醫診所"
    },
    {
      "code" : "3712012259",
      "display" : "敏華牙醫診所"
    },
    {
      "code" : "3712012268",
      "display" : "永霖牙醫診所"
    },
    {
      "code" : "3712012286",
      "display" : "康齡牙醫診所"
    },
    {
      "code" : "3712012295",
      "display" : "耕心牙醫診所"
    },
    {
      "code" : "3712012302",
      "display" : "王存禎牙醫診所"
    },
    {
      "code" : "3712012311",
      "display" : "品味牙醫診所"
    },
    {
      "code" : "3712012329",
      "display" : "安徒生牙醫診所"
    },
    {
      "code" : "3712012338",
      "display" : "尊爵時尚牙醫診所"
    },
    {
      "code" : "3712012348",
      "display" : "清新牙醫診所"
    },
    {
      "code" : "3712012357",
      "display" : "意康牙醫診所"
    },
    {
      "code" : "3712012384",
      "display" : "安心牙醫診所"
    },
    {
      "code" : "3712012393",
      "display" : "明威牙醫診所"
    },
    {
      "code" : "3712012400",
      "display" : "禾一牙醫診所"
    },
    {
      "code" : "3712012419",
      "display" : "新美學牙醫診所"
    },
    {
      "code" : "3712012437",
      "display" : "京典牙醫診所"
    },
    {
      "code" : "3712012455",
      "display" : "育賢牙醫診所"
    },
    {
      "code" : "3712012464",
      "display" : "關新牙醫診所"
    },
    {
      "code" : "3712012482",
      "display" : "金牛頓牙醫診所"
    },
    {
      "code" : "3712012491",
      "display" : "森源牙醫診所"
    },
    {
      "code" : "3712012517",
      "display" : "詠美牙醫診所"
    },
    {
      "code" : "3712012526",
      "display" : "峰皇牙醫診所"
    },
    {
      "code" : "3712012553",
      "display" : "紐約牙醫診所"
    },
    {
      "code" : "3712012571",
      "display" : "晶華牙醫診所"
    },
    {
      "code" : "3712012580",
      "display" : "宏揚牙醫診所"
    },
    {
      "code" : "3712012599",
      "display" : "君悅牙醫診所"
    },
    {
      "code" : "3712012606",
      "display" : "寶傑美學牙醫診所"
    },
    {
      "code" : "3712012624",
      "display" : "日光翡麗牙醫診所"
    },
    {
      "code" : "3712012633",
      "display" : "品御牙醫診所"
    },
    {
      "code" : "3712012642",
      "display" : "園區牙醫診所"
    },
    {
      "code" : "3712012651",
      "display" : "和毅牙醫診所"
    },
    {
      "code" : "3712012660",
      "display" : "誠品牙醫診所"
    },
    {
      "code" : "3712012697",
      "display" : "倨誠牙醫診所"
    },
    {
      "code" : "3712012704",
      "display" : "杏明牙醫診所"
    },
    {
      "code" : "3712012713",
      "display" : "朱育正牙醫診所"
    },
    {
      "code" : "3712012722",
      "display" : "東門牙醫診所"
    },
    {
      "code" : "3712012731",
      "display" : "天晴牙醫診所"
    },
    {
      "code" : "3712012740",
      "display" : "皓齊牙醫診所"
    },
    {
      "code" : "3712012768",
      "display" : "晨光牙醫診所"
    },
    {
      "code" : "3712012777",
      "display" : "立安牙醫診所"
    },
    {
      "code" : "3712012786",
      "display" : "筑心筑美牙醫診所"
    },
    {
      "code" : "3712012795",
      "display" : "恩澄牙醫診所"
    },
    {
      "code" : "3712012802",
      "display" : "心勤美學牙醫診所"
    },
    {
      "code" : "3712012811",
      "display" : "小城堡牙醫診所"
    },
    {
      "code" : "3712012820",
      "display" : "森釉牙醫診所"
    },
    {
      "code" : "3712012839",
      "display" : "嶺先牙醫診所"
    },
    {
      "code" : "3712012848",
      "display" : "全美牙醫診所"
    },
    {
      "code" : "3712012857",
      "display" : "寓光牙醫診所"
    },
    {
      "code" : "3712012866",
      "display" : "怡櫟牙醫診所"
    },
    {
      "code" : "3712012875",
      "display" : "星悅精品牙醫診所"
    },
    {
      "code" : "3712012884",
      "display" : "綻美牙醫診所"
    },
    {
      "code" : "3712012893",
      "display" : "適采牙醫診所"
    },
    {
      "code" : "3712012900",
      "display" : "天空島牙醫診所"
    },
    {
      "code" : "3712012919",
      "display" : "蔚然美學牙醫診所"
    },
    {
      "code" : "3712012928",
      "display" : "夏研牙醫診所"
    },
    {
      "code" : "3712040011",
      "display" : "新捷牙醫診所"
    },
    {
      "code" : "3712040048",
      "display" : "王牙醫診所"
    },
    {
      "code" : "3712040075",
      "display" : "上上牙醫診所"
    },
    {
      "code" : "3712040084",
      "display" : "榮浩牙醫診所"
    },
    {
      "code" : "3712040100",
      "display" : "陽明牙醫診所"
    },
    {
      "code" : "3712040137",
      "display" : "翰霖牙醫診所"
    },
    {
      "code" : "3712040191",
      "display" : "銘燦牙醫診所"
    },
    {
      "code" : "3712040208",
      "display" : "懷仁牙醫診所"
    },
    {
      "code" : "3712040217",
      "display" : "東大牙醫診所"
    },
    {
      "code" : "3712040235",
      "display" : "琉璃光牙醫診所"
    },
    {
      "code" : "3712040244",
      "display" : "仁德牙醫診所"
    },
    {
      "code" : "3712040271",
      "display" : "安定牙醫診所"
    },
    {
      "code" : "3712040280",
      "display" : "東寧牙醫診所"
    },
    {
      "code" : "3712040306",
      "display" : "許牙醫診所"
    },
    {
      "code" : "3712040315",
      "display" : "光華牙醫診所"
    },
    {
      "code" : "3712040333",
      "display" : "陳牙醫診所"
    },
    {
      "code" : "3712040342",
      "display" : "僑霖牙醫診所"
    },
    {
      "code" : "3712040388",
      "display" : "如意牙醫診所"
    },
    {
      "code" : "3712040404",
      "display" : "親民牙醫診所"
    },
    {
      "code" : "3712040431",
      "display" : "潔明牙醫診所"
    },
    {
      "code" : "3712040459",
      "display" : "雅群牙醫診所"
    },
    {
      "code" : "3712040477",
      "display" : "游牙醫診所"
    },
    {
      "code" : "3712040495",
      "display" : "江牙醫診所"
    },
    {
      "code" : "3712040502",
      "display" : "懷恩牙醫診所"
    },
    {
      "code" : "3712040511",
      "display" : "康橋牙醫診所"
    },
    {
      "code" : "3712040539",
      "display" : "吳慧琳牙醫診所"
    },
    {
      "code" : "3712040566",
      "display" : "東濟牙醫診所"
    },
    {
      "code" : "3712040593",
      "display" : "博暘牙醫診所"
    },
    {
      "code" : "3712041607",
      "display" : "陳清龍牙醫診所"
    },
    {
      "code" : "3712041670",
      "display" : "周易中牙醫診所"
    },
    {
      "code" : "3712041689",
      "display" : "永川牙醫診所"
    },
    {
      "code" : "3712041705",
      "display" : "冠傑牙醫診所"
    },
    {
      "code" : "3712041714",
      "display" : "譚牙醫診所"
    },
    {
      "code" : "3712041732",
      "display" : "謝牙醫診所"
    },
    {
      "code" : "3712041741",
      "display" : "黃建群牙醫診所"
    },
    {
      "code" : "3712041778",
      "display" : "全家牙醫診所"
    },
    {
      "code" : "3712041812",
      "display" : "傑霖牙醫診所"
    },
    {
      "code" : "3712041821",
      "display" : "雅緻生活牙醫診所"
    },
    {
      "code" : "3712041830",
      "display" : "黃啟祥牙醫診所"
    },
    {
      "code" : "3712041867",
      "display" : "九歌牙醫診所"
    },
    {
      "code" : "3712041876",
      "display" : "馨典牙醫診所"
    },
    {
      "code" : "3712041885",
      "display" : "創美牙醫診所"
    },
    {
      "code" : "3712041929",
      "display" : "里昂哈佛國際牙醫診所"
    },
    {
      "code" : "3712041938",
      "display" : "彼德潘牙醫診所"
    },
    {
      "code" : "3712041947",
      "display" : "福華牙醫診所"
    },
    {
      "code" : "3712041956",
      "display" : "經典牙醫診所"
    },
    {
      "code" : "3712041965",
      "display" : "博悅牙醫診所"
    },
    {
      "code" : "3712041974",
      "display" : "森美牙醫診所"
    },
    {
      "code" : "3712041983",
      "display" : "麗緻牙醫診所"
    },
    {
      "code" : "3712050026",
      "display" : "深潭牙醫診所"
    },
    {
      "code" : "3712050035",
      "display" : "永志牙醫診所"
    },
    {
      "code" : "3712050044",
      "display" : "陳培中牙醫診所"
    },
    {
      "code" : "3712050053",
      "display" : "朝春牙醫診所"
    },
    {
      "code" : "3712050062",
      "display" : "香杉牙醫診所"
    },
    {
      "code" : "3712050071",
      "display" : "海棠牙醫診所"
    },
    {
      "code" : "3732010055",
      "display" : "宏仁牙醫診所"
    },
    {
      "code" : "3732010073",
      "display" : "正大牙醫診所"
    },
    {
      "code" : "3732010082",
      "display" : "黃牙醫診所"
    },
    {
      "code" : "3732010135",
      "display" : "立新牙醫診所"
    },
    {
      "code" : "3732010180",
      "display" : "德明牙醫診所"
    },
    {
      "code" : "3732010199",
      "display" : "慈恩牙醫診所"
    },
    {
      "code" : "3732010224",
      "display" : "杏昇牙醫診所"
    },
    {
      "code" : "3732010233",
      "display" : "大雅牙醫診所"
    },
    {
      "code" : "3732010242",
      "display" : "名家牙醫診所"
    },
    {
      "code" : "3732010279",
      "display" : "源芳牙醫診所"
    },
    {
      "code" : "3732010288",
      "display" : "銀格牙醫診所"
    },
    {
      "code" : "3732010297",
      "display" : "煌猷牙醫診所"
    },
    {
      "code" : "3732010304",
      "display" : "淨妙牙醫診所"
    },
    {
      "code" : "3732010322",
      "display" : "楊牙醫診所"
    },
    {
      "code" : "3732010331",
      "display" : "榮安牙醫診所"
    },
    {
      "code" : "3732010340",
      "display" : "千代牙醫診所"
    },
    {
      "code" : "3732010368",
      "display" : "景翔牙醫診所"
    },
    {
      "code" : "3732010377",
      "display" : "大成牙醫診所"
    },
    {
      "code" : "3732010395",
      "display" : "四維牙醫診所"
    },
    {
      "code" : "3732010420",
      "display" : "溫牙醫診所"
    },
    {
      "code" : "3732010466",
      "display" : "世界牙醫診所"
    },
    {
      "code" : "3732010500",
      "display" : "大衛牙醫診所"
    },
    {
      "code" : "3732010519",
      "display" : "欣聖牙醫診所"
    },
    {
      "code" : "3732010555",
      "display" : "佳德牙醫診所"
    },
    {
      "code" : "3732010626",
      "display" : "成功牙醫診所"
    },
    {
      "code" : "3732010635",
      "display" : "大宇牙醫診所"
    },
    {
      "code" : "3732010644",
      "display" : "明仁牙醫診所"
    },
    {
      "code" : "3732010653",
      "display" : "潔安牙醫診所"
    },
    {
      "code" : "3732010699",
      "display" : "定北牙醫診所"
    },
    {
      "code" : "3732010706",
      "display" : "三民牙醫診所"
    },
    {
      "code" : "3732010724",
      "display" : "信德牙醫診所"
    },
    {
      "code" : "3732010733",
      "display" : "百齡牙醫診所"
    },
    {
      "code" : "3732010779",
      "display" : "何逢原牙醫診所"
    },
    {
      "code" : "3732010797",
      "display" : "永安江牙醫診所"
    },
    {
      "code" : "3732010804",
      "display" : "永安牙醫診所"
    },
    {
      "code" : "3732010813",
      "display" : "宏國牙醫診所"
    },
    {
      "code" : "3732010840",
      "display" : "源美牙醫診所"
    },
    {
      "code" : "3732010868",
      "display" : "懷恩牙醫診所"
    },
    {
      "code" : "3732010886",
      "display" : "長榮牙醫診所"
    },
    {
      "code" : "3732010895",
      "display" : "鄭文祿牙醫診所"
    },
    {
      "code" : "3732010902",
      "display" : "古秀傳牙醫診所"
    },
    {
      "code" : "3732010948",
      "display" : "福太牙醫診所"
    },
    {
      "code" : "3732010975",
      "display" : "創彬牙醫診所"
    },
    {
      "code" : "3732010993",
      "display" : "郭偉軍牙醫診所"
    },
    {
      "code" : "3732011016",
      "display" : "何牙醫診所"
    },
    {
      "code" : "3732011025",
      "display" : "黃乃靖牙醫診所"
    },
    {
      "code" : "3732011034",
      "display" : "偉玲牙醫診所"
    },
    {
      "code" : "3732011052",
      "display" : "杏宏牙醫診所"
    },
    {
      "code" : "3732011070",
      "display" : "陳學偉牙醫診所"
    },
    {
      "code" : "3732011089",
      "display" : "福康牙醫診所"
    },
    {
      "code" : "3732011105",
      "display" : "新晴美學牙醫診所"
    },
    {
      "code" : "3732011123",
      "display" : "民生牙醫診所"
    },
    {
      "code" : "3732011141",
      "display" : "群益牙醫診所"
    },
    {
      "code" : "3732011169",
      "display" : "陳霖茂牙醫診所"
    },
    {
      "code" : "3732011221",
      "display" : "德恩牙醫診所"
    },
    {
      "code" : "3732011267",
      "display" : "誠品牙醫診所"
    },
    {
      "code" : "3732011285",
      "display" : "久大牙醫診所"
    },
    {
      "code" : "3732011294",
      "display" : "何良善牙醫診所"
    },
    {
      "code" : "3732011310",
      "display" : "臻美牙醫診所"
    },
    {
      "code" : "3732011329",
      "display" : "齊美牙醫診所"
    },
    {
      "code" : "3732011338",
      "display" : "朝陽牙醫診所"
    },
    {
      "code" : "3732011347",
      "display" : "大偉牙醫診所"
    },
    {
      "code" : "3732011356",
      "display" : "全品牙醫診所"
    },
    {
      "code" : "3732011383",
      "display" : "健銓牙醫診所"
    },
    {
      "code" : "3732011418",
      "display" : "康禾牙醫診所"
    },
    {
      "code" : "3732011427",
      "display" : "游偉斌牙醫診所"
    },
    {
      "code" : "3732011445",
      "display" : "博安牙醫診所"
    },
    {
      "code" : "3732012442",
      "display" : "新田牙醫診所"
    },
    {
      "code" : "3732012460",
      "display" : "明佑牙醫診所"
    },
    {
      "code" : "3732012479",
      "display" : "新世紀牙醫診所"
    },
    {
      "code" : "3732012540",
      "display" : "上華牙醫診所"
    },
    {
      "code" : "3732012568",
      "display" : "明新牙醫診所"
    },
    {
      "code" : "3732012595",
      "display" : "國鼎牙醫診所"
    },
    {
      "code" : "3732012611",
      "display" : "鈺盛牙醫診所"
    },
    {
      "code" : "3732012639",
      "display" : "名華牙醫診所"
    },
    {
      "code" : "3732012648",
      "display" : "錦生牙醫診所"
    },
    {
      "code" : "3732012700",
      "display" : "京瑋牙醫診所"
    },
    {
      "code" : "3732012746",
      "display" : "自強牙醫診所"
    },
    {
      "code" : "3732012755",
      "display" : "家和牙醫診所"
    },
    {
      "code" : "3732012782",
      "display" : "龍安牙醫診所"
    },
    {
      "code" : "3732012791",
      "display" : "新仁德牙醫診所"
    },
    {
      "code" : "3732012808",
      "display" : "同德牙醫診所"
    },
    {
      "code" : "3732012817",
      "display" : "立洋牙醫診所"
    },
    {
      "code" : "3732012826",
      "display" : "齡雅牙科牙醫診所"
    },
    {
      "code" : "3732012835",
      "display" : "京采牙醫診所"
    },
    {
      "code" : "3732012906",
      "display" : "陽光聯合牙醫診所"
    },
    {
      "code" : "3732012924",
      "display" : "康齡牙醫診所"
    },
    {
      "code" : "3732012942",
      "display" : "晴越牙醫診所"
    },
    {
      "code" : "3732012997",
      "display" : "豐恩牙醫診所"
    },
    {
      "code" : "3732013001",
      "display" : "益皓牙醫診所"
    },
    {
      "code" : "3732013038",
      "display" : "大有牙醫診所"
    },
    {
      "code" : "3732013056",
      "display" : "南加大牙醫診所"
    },
    {
      "code" : "3732013065",
      "display" : "向陽牙醫診所"
    },
    {
      "code" : "3732013074",
      "display" : "尚霖牙醫診所"
    },
    {
      "code" : "3732013083",
      "display" : "家欣牙醫"
    },
    {
      "code" : "3732013109",
      "display" : "優尚牙醫診所"
    },
    {
      "code" : "3732013118",
      "display" : "尚揚牙醫診所"
    },
    {
      "code" : "3732013145",
      "display" : "快樂牙醫診所"
    },
    {
      "code" : "3732013154",
      "display" : "佳樂牙醫診所"
    },
    {
      "code" : "3732013181",
      "display" : "葡萄藤牙醫診所"
    },
    {
      "code" : "3732013207",
      "display" : "叮噹牙醫診所"
    },
    {
      "code" : "3732013225",
      "display" : "豐成牙醫診所"
    },
    {
      "code" : "3732013261",
      "display" : "優利牙醫診所"
    },
    {
      "code" : "3732013270",
      "display" : "向日葵牙醫診所"
    },
    {
      "code" : "3732013289",
      "display" : "淯群牙醫診所"
    },
    {
      "code" : "3732013298",
      "display" : "冠倫牙醫診所"
    },
    {
      "code" : "3732013341",
      "display" : "風采牙醫診所"
    },
    {
      "code" : "3732013403",
      "display" : "維佑牙醫診所"
    },
    {
      "code" : "3732013412",
      "display" : "協和牙醫診所"
    },
    {
      "code" : "3732013421",
      "display" : "家禾牙醫診所"
    },
    {
      "code" : "3732013458",
      "display" : "禾康牙醫診所"
    },
    {
      "code" : "3732013467",
      "display" : "禾豐牙醫診所"
    },
    {
      "code" : "3732013476",
      "display" : "和悅牙醫診所"
    },
    {
      "code" : "3732013494",
      "display" : "寶山牙醫診所"
    },
    {
      "code" : "3732013501",
      "display" : "領航數位牙醫診所"
    },
    {
      "code" : "3732013529",
      "display" : "微登牙醫診所"
    },
    {
      "code" : "3732013538",
      "display" : "展新牙醫診所"
    },
    {
      "code" : "3732013547",
      "display" : "達美牙醫診所"
    },
    {
      "code" : "3732013565",
      "display" : "潔德美學牙醫診所"
    },
    {
      "code" : "3732013574",
      "display" : "禾騏牙醫診所"
    },
    {
      "code" : "3732013583",
      "display" : "藝文君品牙醫診所"
    },
    {
      "code" : "3732013592",
      "display" : "新悅牙醫診所"
    },
    {
      "code" : "3732013618",
      "display" : "旭陽牙醫診所"
    },
    {
      "code" : "3732013627",
      "display" : "建嘉牙醫診所"
    },
    {
      "code" : "3732013645",
      "display" : "完美牙醫診所"
    },
    {
      "code" : "3732013654",
      "display" : "健華牙醫診所"
    },
    {
      "code" : "3732013663",
      "display" : "瑞康牙醫診所"
    },
    {
      "code" : "3732013672",
      "display" : "風采矯正牙醫診所"
    },
    {
      "code" : "3732013681",
      "display" : "康喬口腔外科牙醫診所"
    },
    {
      "code" : "3732013707",
      "display" : "明陽牙醫診所"
    },
    {
      "code" : "3732013725",
      "display" : "瑞宏牙醫診所"
    },
    {
      "code" : "3732013743",
      "display" : "合康美學牙醫診所"
    },
    {
      "code" : "3732013752",
      "display" : "用心牙醫診所"
    },
    {
      "code" : "3732013761",
      "display" : "藝品牙醫診所"
    },
    {
      "code" : "3732013770",
      "display" : "固德牙醫診所"
    },
    {
      "code" : "3732013789",
      "display" : "宗賢牙醫診所"
    },
    {
      "code" : "3732013805",
      "display" : "澄禾牙醫診所"
    },
    {
      "code" : "3732013832",
      "display" : "蓁禾牙醫診所"
    },
    {
      "code" : "3732013850",
      "display" : "易融牙醫診所"
    },
    {
      "code" : "3732013869",
      "display" : "承品牙醫診所"
    },
    {
      "code" : "3732013878",
      "display" : "黃建達齒顎矯正專科牙醫診所"
    },
    {
      "code" : "3732013887",
      "display" : "京品牙醫診所"
    },
    {
      "code" : "3732013912",
      "display" : "悅翔牙醫診所"
    },
    {
      "code" : "3732013921",
      "display" : "詮鈦牙醫診所"
    },
    {
      "code" : "3732013958",
      "display" : "艾美牙醫診所"
    },
    {
      "code" : "3732013967",
      "display" : "康世維口腔美學牙醫診所"
    },
    {
      "code" : "3732013976",
      "display" : "新潔明牙醫診所"
    },
    {
      "code" : "3732013985",
      "display" : "美麗新牙醫診所"
    },
    {
      "code" : "3732013994",
      "display" : "瑞安牙醫診所"
    },
    {
      "code" : "3732014008",
      "display" : "敦品牙醫診所"
    },
    {
      "code" : "3732014017",
      "display" : "薇拉牙醫診所"
    },
    {
      "code" : "3732014026",
      "display" : "品汎牙醫診所"
    },
    {
      "code" : "3732014035",
      "display" : "藝文完美牙醫診所"
    },
    {
      "code" : "3732014044",
      "display" : "芊晴牙醫診所"
    },
    {
      "code" : "3732014071",
      "display" : "慈美牙醫診所"
    },
    {
      "code" : "3732014080",
      "display" : "沐光美學牙醫診所"
    },
    {
      "code" : "3732014099",
      "display" : "兆品美學牙醫診所"
    },
    {
      "code" : "3732014106",
      "display" : "昶佳牙醫診所"
    },
    {
      "code" : "3732014115",
      "display" : "海格口腔外科牙醫診所"
    },
    {
      "code" : "3732014124",
      "display" : "佑語牙醫診所"
    },
    {
      "code" : "3732014133",
      "display" : "森美學牙科診所"
    },
    {
      "code" : "3732014142",
      "display" : "合晴美學牙醫診所"
    },
    {
      "code" : "3732014151",
      "display" : "向陽藝心牙醫診所"
    },
    {
      "code" : "3732014160",
      "display" : "循映牙醫診所"
    },
    {
      "code" : "3732014179",
      "display" : "京鼎牙醫診所"
    },
    {
      "code" : "3732014188",
      "display" : "日好牙醫診所"
    },
    {
      "code" : "3732014197",
      "display" : "森子牙醫診所"
    },
    {
      "code" : "3732014204",
      "display" : "沐上澄牙醫診所"
    },
    {
      "code" : "3732014213",
      "display" : "周道牙醫診所"
    },
    {
      "code" : "3732014222",
      "display" : "向日葵兒童牙醫診所"
    },
    {
      "code" : "3732014231",
      "display" : "樂陽牙醫診所"
    },
    {
      "code" : "3732014240",
      "display" : "樂群牙醫診所"
    },
    {
      "code" : "3732014259",
      "display" : "風采美學牙醫診所"
    },
    {
      "code" : "3732014268",
      "display" : "佑鈞牙醫診所"
    },
    {
      "code" : "3732014277",
      "display" : "巧研美學牙醫診所"
    },
    {
      "code" : "3732014286",
      "display" : "九登牙醫診所"
    },
    {
      "code" : "3732014295",
      "display" : "耘禾牙醫診所"
    },
    {
      "code" : "3732014302",
      "display" : "雅德思牙醫診所"
    },
    {
      "code" : "3732014311",
      "display" : "悅翔中路牙醫診所"
    },
    {
      "code" : "3732014320",
      "display" : "簡青山牙醫診所"
    },
    {
      "code" : "3732014339",
      "display" : "上穎牙醫診所"
    },
    {
      "code" : "3732014348",
      "display" : "京澤牙醫診所"
    },
    {
      "code" : "3732014357",
      "display" : "睦牙醫診所"
    },
    {
      "code" : "3732014366",
      "display" : "海棠牙醫診所"
    },
    {
      "code" : "3732014375",
      "display" : "品蘊牙醫診所"
    },
    {
      "code" : "3732014384",
      "display" : "風和牙醫診所"
    },
    {
      "code" : "3732014393",
      "display" : "曙光牙醫診所"
    },
    {
      "code" : "3732014400",
      "display" : "杏桃牙醫診所"
    },
    {
      "code" : "3732014419",
      "display" : "桃園一日誠臻牙醫診所"
    },
    {
      "code" : "3732014428",
      "display" : "彤安美學牙醫診所"
    },
    {
      "code" : "3732014437",
      "display" : "栢世牙醫診所"
    },
    {
      "code" : "3732014446",
      "display" : "建嘉牙醫診所"
    },
    {
      "code" : "3732014455",
      "display" : "春日雅德思牙醫診所"
    },
    {
      "code" : "3732014473",
      "display" : "法鉑牙醫診所"
    },
    {
      "code" : "3732014508",
      "display" : "維藝美學牙醫診所"
    },
    {
      "code" : "3732014517",
      "display" : "井然牙醫診所"
    },
    {
      "code" : "3732014526",
      "display" : "英倫牙醫診所"
    },
    {
      "code" : "3732014535",
      "display" : "蒔雨牙醫診所"
    },
    {
      "code" : "3732014544",
      "display" : "小檜溪詮鈦牙醫診所"
    },
    {
      "code" : "3732014553",
      "display" : "循心牙醫診所"
    },
    {
      "code" : "3732014562",
      "display" : "流石歯科牙醫診所"
    },
    {
      "code" : "3732014580",
      "display" : "鼎康牙醫診所"
    },
    {
      "code" : "3732014599",
      "display" : "栢樂牙醫診所"
    },
    {
      "code" : "3732014606",
      "display" : "桃園一日誠臻牙醫診所"
    },
    {
      "code" : "3732014615",
      "display" : "小春日和牙醫診所"
    },
    {
      "code" : "3732020079",
      "display" : "大明牙醫診所"
    },
    {
      "code" : "3732020113",
      "display" : "森森牙醫診所"
    },
    {
      "code" : "3732020140",
      "display" : "東光牙醫診所"
    },
    {
      "code" : "3732020195",
      "display" : "良昇牙醫診所"
    },
    {
      "code" : "3732020202",
      "display" : "大眾牙醫診所"
    },
    {
      "code" : "3732020211",
      "display" : "名揚牙醫診所"
    },
    {
      "code" : "3732020220",
      "display" : "杜牙醫診所"
    },
    {
      "code" : "3732020275",
      "display" : "坤泰牙醫診所"
    },
    {
      "code" : "3732020284",
      "display" : "遠東牙醫診所"
    },
    {
      "code" : "3732020328",
      "display" : "王牙醫診所"
    },
    {
      "code" : "3732020346",
      "display" : "祥齡牙醫診所"
    },
    {
      "code" : "3732020373",
      "display" : "宏儒牙醫診所"
    },
    {
      "code" : "3732020382",
      "display" : "奕傑牙醫診所"
    },
    {
      "code" : "3732020391",
      "display" : "廖永楷牙醫診所"
    },
    {
      "code" : "3732020426",
      "display" : "尚賢牙醫診所"
    },
    {
      "code" : "3732020435",
      "display" : "范姜牙醫診所"
    },
    {
      "code" : "3732020462",
      "display" : "長江牙醫診所"
    },
    {
      "code" : "3732020579",
      "display" : "全悅牙醫診所"
    },
    {
      "code" : "3732020597",
      "display" : "良銘牙醫診所"
    },
    {
      "code" : "3732020613",
      "display" : "揚昇牙醫診所"
    },
    {
      "code" : "3732020622",
      "display" : "政寧牙醫診所"
    },
    {
      "code" : "3732020631",
      "display" : "華國牙醫診所"
    },
    {
      "code" : "3732020659",
      "display" : "杏福牙醫診所"
    },
    {
      "code" : "3732020668",
      "display" : "立人牙醫診所"
    },
    {
      "code" : "3732020677",
      "display" : "汎美牙醫診所"
    },
    {
      "code" : "3732020686",
      "display" : "時代牙醫診所"
    },
    {
      "code" : "3732020695",
      "display" : "紐大牙醫診所"
    },
    {
      "code" : "3732020720",
      "display" : "康碩牙醫診所"
    },
    {
      "code" : "3732020748",
      "display" : "順泰牙醫診所"
    },
    {
      "code" : "3732020775",
      "display" : "德暉牙醫診所"
    },
    {
      "code" : "3732020800",
      "display" : "超凡牙醫診所"
    },
    {
      "code" : "3732020820",
      "display"