# NHI-健保事前審查-給付適應症 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NHI-健保事前審查-給付適應症**

## CodeSystem: NHI-健保事前審查-給付適應症 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-apply-reason | *Version*:1.1.0 |
| Active as of 2025-10-01 | *Computable Name*:NHIApplyReason |

 
臺灣衛生福利部中央健康保險署「給付適應症」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。 

 This Code system is referenced in the content logical definition of the following value sets: 

* [NHIApplyReason](ValueSet-nhi-apply-reason.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "nhi-apply-reason",
  "url" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-apply-reason",
  "version" : "1.1.0",
  "name" : "NHIApplyReason",
  "title" : "NHI-健保事前審查-給付適應症",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-01",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣衛生福利部中央健康保險署「給付適應症」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 30,
  "concept" : [
    {
      "code" : "C50P1",
      "display" : "早期乳癌-未發生腋下淋巴結轉移",
      "definition" : "事前審查品項代碼為KC010892B5、KC011162B5、JC00154261、KC009612B5(自113年12月擴增)、KC011112DE(114年1月起擴增)才可填寫"
    },
    {
      "code" : "C50P2",
      "display" : "早期乳癌-具腋下淋巴結轉移",
      "definition" : "事前審查品項代碼為KC009612B5、KC010892B5、KC011112DE、KC011162B5、KC011362B5、JC00154261才可填寫"
    },
    {
      "code" : "C50R1",
      "display" : "轉移性乳癌",
      "definition" : "事前審查品項代碼為KC009612B5、KC010892B5、KC011112DE、KC011162B5、KC011362B5、JC00154261才可填寫"
    },
    {
      "code" : "C16R1",
      "display" : "轉移性胃癌",
      "definition" : "事前審查品項代碼為KC009612B5、KC010892B5、KC011112DE、KC011162B5、KC011362B5、JC00154261才可填寫"
    },
    {
      "code" : "P001",
      "display" : "黑色素瘤",
      "definition" : "事前審查品項代碼為KC01013229、KC01013230、KC01025219才可填寫"
    },
    {
      "code" : "P011",
      "display" : "非小細胞肺癌-SQ-2線",
      "definition" : "事前審查品項代碼為KC01050238、KC01013229、KC01013230、KC01025219、KC01258235才可填寫"
    },
    {
      "code" : "P012",
      "display" : "非小細胞肺癌-Adeno-3線",
      "definition" : "事前審查品項代碼為KC01050238、KC01013229、KC01013230、KC01025219、KC01258235才可填寫"
    },
    {
      "code" : "P013",
      "display" : "非小細胞肺癌第一線用藥(鱗狀、非鱗狀單用或非鱗併用)",
      "definition" : "事前審查品項代碼為KC01050238、KC01025219、KC01258235才可填寫(114年1月起擴增)"
    },
    {
      "code" : "P014",
      "display" : "鱗狀非小細胞肺癌第一線用藥(併用化療)",
      "definition" : "事前審查品項代碼為KC01025219才可填寫"
    },
    {
      "code" : "P015",
      "display" : "非小細胞肺癌鞏固治療(單用)",
      "definition" : "事前審查品項代碼為KC01088229才可填寫(114年8月起擴增)"
    },
    {
      "code" : "P021",
      "display" : "小細胞肺癌(併用化療)",
      "definition" : "事前審查品項代碼為KC01050238、KC01088229、KC01258235才可填寫"
    },
    {
      "code" : "P031",
      "display" : "典型何杰金氏淋巴瘤",
      "definition" : "事前審查品項代碼為KC01013229、KC01013230、KC01025219才可填寫"
    },
    {
      "code" : "P041",
      "display" : "泌尿道上皮癌-2線",
      "definition" : "事前審查品項代碼為KC01013229、KC01013230、KC01025219、KC01050238(113/8/1停止新病人給付)、KC01258235(113/8/1停止新病人給付)才可填寫"
    },
    {
      "code" : "P042",
      "display" : "泌尿道上皮癌-1線",
      "definition" : "事前審查品項代碼為KC01025219、KC01050238(113/8/1停止新病人給付)、KC01258235(113/8/1停止新病人給付)才可填寫"
    },
    {
      "code" : "P043",
      "display" : "局部晚期或轉移性泌尿道上皮癌之維持療法",
      "definition" : "事前審查品項代碼為KC01085229才可填寫"
    },
    {
      "code" : "P052",
      "display" : "胃癌-1線(併用化療)",
      "definition" : "事前審查品項代碼為KC01013230才可填寫"
    },
    {
      "code" : "P061",
      "display" : "腎細胞癌",
      "definition" : "事前審查品項代碼為KC01013229、KC01013230才可填寫"
    },
    {
      "code" : "P072",
      "display" : "晚期肝細胞癌-1線(併用標靶藥或免疫製劑藥)",
      "definition" : "事前審查品項代碼為KC01050238、KC01088229、KC01258235、KC01242235才可填寫"
    },
    {
      "code" : "P081",
      "display" : "頭頸部鱗狀細胞癌第二線用藥",
      "definition" : "事前審查品項代碼為KC01013229、KC01013230、KC01025219才可填寫"
    },
    {
      "code" : "P082",
      "display" : "頭頸部鱗狀細胞癌第一線用藥",
      "definition" : "事前審查品項代碼為KC01025219才可填寫"
    },
    {
      "code" : "P091",
      "display" : "默克細胞癌",
      "definition" : "事前審查品項代碼為KC01085229才可填寫"
    },
    {
      "code" : "P101",
      "display" : "食道鱗狀細胞癌",
      "definition" : "事前審查品項代碼為KC01013230才可填寫"
    },
    {
      "code" : "P111",
      "display" : "惡性肋膜間皮瘤(ipilimumab併用nivolumab 120mg)",
      "definition" : "事前審查品項代碼「先申請KC00958229，再申請KC01013230」才可填寫"
    },
    {
      "code" : "P121",
      "display" : "膽道癌(併用化療)",
      "definition" : "事前審查品項代碼為KC01088229才可填寫"
    },
    {
      "code" : "P131",
      "display" : "早期三陰性乳癌(併用化療)",
      "definition" : "KC01025219(114年6月起擴增)"
    },
    {
      "code" : "P141",
      "display" : "大腸直腸癌",
      "definition" : "KC01025219(114年6月起擴增)"
    },
    {
      "code" : "C83N2",
      "display" : "單獨使用於先前接受過至少一種化學或標靶治療方式無效或復發的被套細胞淋巴瘤成人病人",
      "definition" : "事前審查品項代碼為BC28160100才可填寫(114年8月起擴增)"
    },
    {
      "code" : "C88N3",
      "display" : "單獨使用於曾接受一種含單柱抗體及一種靜脈注射之alkylating agent之chemoimmunotherapy至少4療程以上後復發者的華氏巨球蛋白血症成年病人",
      "definition" : "事前審查品項代碼為BC28160100才可填寫(114年8月起擴增)"
    },
    {
      "code" : "C82N3",
      "display" : "與obinutuzumab併用，治療先前曾接受至少兩線(每線至少4個療程)全身性治療無效或復發的濾泡性淋巴瘤成人病人",
      "definition" : "事前審查品項代碼為BC28160100才可填寫(114年8月起擴增)"
    },
    {
      "code" : "C91N1",
      "display" : "單獨使用於慢性淋巴球白血病(CLL)成人病人",
      "definition" : "事前審查品項代碼為BC28160100才可填寫(114年10月起擴增)"
    }
  ]
}

```
