# 免疫製劑事前審查 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **免疫製劑事前審查**

## Example Bundle: 免疫製劑事前審查



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "bun-imm",
  "meta" : {
    "profile" : [
      "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-immunologic-agent-twpas"
    ]
  },
  "type" : "collection",
  "entry" : [
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Claim/cla-imm",
      "resource" : {
        "resourceType" : "Claim",
        "id" : "cla-imm",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Claim-immunologic-agent-twpas"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Claim_cla-imm\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Claim cla-imm</b></p><a name=\"cla-imm\"> </a><a name=\"hccla-imm\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Claim-immunologic-agent-twpas.html\">免疫製劑事前審查-Claim Immunologic Aagent TWPAS</a></p></div><p><b>ClaimEncounter</b>: <a href=\"Encounter-enc-min.html\">Encounter: status = planned; class = ambulatory (ActCode#AMB); serviceType = 胸腔暨重症加護</a></p><p><b>status</b>: Active</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/claim-type institutional}\">Institutional</span></p><p><b>subType</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-apply-type 1}\">送核</span></p><p><b>use</b>: Preauthorization</p><p><b>patient</b>: <a href=\"Patient-pat-min.html\">王大明 Male, DoB: 2001-01-01 ( Medical record number (use: official, ))</a></p><p><b>created</b>: 2024-05-30</p><p><b>enterer</b>: <a href=\"Practitioner-pra-min.html\">Practitioner: identifier = National Person Identifier where the xxx is the ISO table 3166 3-character (alphabetic) country code,Medical License number</a></p><p><b>provider</b>: <a href=\"Organization-org-hosp-example.html\">Organization 臺北市立聯合醫院</a></p><p><b>priority</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-tmhb-type 1}\">一般事前審查申請</span></p><blockquote><p><b>supportingInfo</b></p><p><b>sequence</b>: 1</p><p><b>category</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type weight}\">病人體重</span></p><p><b>value</b>: 59.65 kg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codekg = 'kg')</span></p></blockquote><blockquote><p><b>supportingInfo</b></p><p><b>sequence</b>: 2</p><p><b>category</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type height}\">病人身高</span></p><p><b>value</b>: 170 cm<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codecm = 'cm')</span></p></blockquote><blockquote><p><b>supportingInfo</b></p><p><b>sequence</b>: 3</p><p><b>category</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type bloodgroup}\">病人血型</span></p><p><b>value</b>: <a href=\"Observation-obs-blood-group.html\">Observation ABO and Rh group [Type] in Blood</a></p></blockquote><blockquote><p><b>supportingInfo</b></p><p><b>sequence</b>: 4</p><p><b>category</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type imagingReport}\">影像報告</span></p><p><b>value</b>: <a href=\"DiagnosticReport-diaRep-ima-min.html\">Diagnostic Report for 'B34JZZ3' for '-&gt;王大明 Male, DoB: 2001-01-01 ( Medical record number (use: official, ))'</a></p></blockquote><blockquote><p><b>supportingInfo</b></p><p><b>sequence</b>: 6</p><p><b>category</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type examinationReport}\">檢查報告</span></p><p><b>value</b>: <a href=\"DiagnosticReport-diaRep-min.html\">Diagnostic Report for 'Prostate Pathology biopsy report' for '-&gt;王大明 Male, DoB: 2001-01-01 ( Medical record number (use: official, ))'</a></p></blockquote><blockquote><p><b>supportingInfo</b></p><p><b>sequence</b>: 8</p><p><b>category</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type tests}\">檢驗(查)</span></p><p><b>value</b>: <a href=\"Observation-obs-lab-min.html\">Observation Platelets [#/volume] in Blood by Automated count</a></p></blockquote><blockquote><p><b>supportingInfo</b></p><p><b>sequence</b>: 9</p><p><b>category</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type tests}\">檢驗(查)</span></p><p><b>value</b>: <a href=\"Observation-obs-lab-cbc.html\">Observation CBC panel - Blood by Automated count</a></p></blockquote><blockquote><p><b>supportingInfo</b></p><p><b>sequence</b>: 10</p><p><b>category</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type patientAssessment}\">病人狀態評估</span></p><p><b>value</b>: <a href=\"Observation-obs-pat-nyha.html\">Observation Functional capacity NYHA</a></p></blockquote><blockquote><p><b>supportingInfo</b></p><p><b>sequence</b>: 11</p><p><b>category</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type medicationRequest}\">用藥品項</span></p><p><b>value</b>: <a href=\"MedicationRequest-medReq-treat.html\">MedicationRequest: status = completed; statusReason = Try another treatment first; intent = order; category = 健保; medication[x] = ANTI-COUGH SYRUP &quot;WASHINGTON&quot;</a></p></blockquote><blockquote><p><b>supportingInfo</b></p><p><b>sequence</b>: 12</p><p><b>category</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type radiotherapy}\">放射/照光治療</span></p><p><b>value</b>: <a href=\"Procedure-pro-min.html\">Procedure D7Y08ZZ</a></p></blockquote><blockquote><p><b>supportingInfo</b></p><p><b>sequence</b>: 13</p><p><b>category</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type carePlanDocument}\">治療計畫文件</span></p><p><b>value</b>: <a href=\"DocumentReference-doc-careplan-min.html\">DocumentReference: status = current; category = 治療計畫文件</a></p></blockquote><blockquote><p><b>supportingInfo</b></p><p><b>sequence</b>: 14</p><p><b>category</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type medicalRecord}\">病歷資料</span></p><p><b>value</b>: <a href=\"DocumentReference-doc-medicalRecord-min.html\">DocumentReference: status = current; category = 病歷資料</a></p></blockquote><blockquote><p><b>supportingInfo</b></p><p><b>sequence</b>: 15</p><p><b>category</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type treatmentAssessment}\">結果資訊</span></p><p><b>value</b>: <a href=\"Observation-obs-tx-min.html\">Observation International Working Group(IWG) Consensus Criteria</a></p></blockquote><blockquote><p><b>supportingInfo</b></p><p><b>sequence</b>: 16</p><p><b>category</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type opd}\">門診病歷</span></p><p><b>value</b>: <a href=\"Encounter-enc-opd.html\">Encounter: extension = -&gt;Observation Subjective Narrative,-&gt;Observation Objective Narrative,-&gt;ClinicalImpression: status = completed; summary = Right knee . arthritis . active,-&gt;CarePlan: status = completed; intent = plan; category = Assessment and Plan of Treatment; description = 1.Arrenge Arthrocentesis of Right knee and synovial fluid analysis (routine, culture and crystal analysis) after patient consent. 2.Analgesics. 3.Bed rest with ice packing if necessary.; status = finished; class = ambulatory (ActCode#AMB); serviceType = Family practice (qualifier value); period = 2025-11-11 --&gt; (ongoing)</a></p></blockquote><blockquote><p><b>supportingInfo</b></p><p><b>sequence</b>: 17</p><p><b>category</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type allergy}\">過敏史</span></p><p><b>value</b>: <a href=\"AllergyIntolerance-all-min.html\">AllergyIntolerance </a></p></blockquote><h3>Diagnoses</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Extension</b></td><td><b>Sequence</b></td><td><b>Diagnosis[x]</b></td><td><b>Type</b></td></tr><tr><td style=\"display: none\">*</td><td/><td>1</td><td><span title=\"Codes:{https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-cm-2023-tw I50.812}\">I50.812</span></td><td><span title=\"Codes:\">Adenocarcinoma, descending colon, cT3N2M1a, cStage IVA, KRAS G12V, with multiple liver metastases, status post FOLFIRI</span></td></tr></table><h3>Procedures</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Sequence</b></td><td><b>Date</b></td><td><b>Procedure[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1</td><td>2024-01-01</td><td><span title=\"Codes:{https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2023-tw 3E0Y704}\">3E0Y704</span></td></tr></table><h3>Insurances</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Sequence</b></td><td><b>Focal</b></td><td><b>Coverage</b></td></tr><tr><td style=\"display: none\">*</td><td>1</td><td>true</td><td><a href=\"Coverage-cov-min.html\">Coverage: status = active</a></td></tr></table><blockquote><p><b>item</b></p><p><b>RequestedService</b>: <a href=\"MedicationRequest-medReq-apply.html\">MedicationRequest: status = on-hold; intent = plan; medication[x] = Alunbrig film-coated tablets 30mg</a></p><p><b>sequence</b>: 1</p><p><b>productOrService</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-order-type 1}\">藥品</span></p><p><b>modifier</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-continuation-status 1}\">初次使用</span>, <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-line-of-therapy 1}\">第一線治療</span></p><p><b>programCode</b>: <span title=\"Codes:\">ALK陽性的晚期非小細胞肺癌第一線治療</span></p><p><b>quantity</b>: 52 {tbl}<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{tbl} = '{tbl}')</span></p></blockquote><blockquote><p><b>item</b></p><p><b>RequestedService</b>: <a href=\"MedicationRequest-medReq-apply-2.html\">MedicationRequest: status = on-hold; intent = plan; medication[x] = Herzuma Inj. 440mg, Lyophilized powder for injection</a></p><p><b>sequence</b>: 2</p><p><b>productOrService</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-order-type 1}\">藥品</span></p><p><b>modifier</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-continuation-status 1}\">初次使用</span>, <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-line-of-therapy 1}\">第一線治療</span></p><p><b>programCode</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-apply-reason C50P1}\">早期乳癌-未發生腋下淋巴結轉移</span></p><p><b>quantity</b>: 70 {tbl}<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{tbl} = '{tbl}')</span></p></blockquote></div>"
        },
        "extension" : [
          {
            "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-claim-encounter",
            "valueReference" : {
              "reference" : "Encounter/enc-min"
            }
          }
        ],
        "status" : "active",
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
              "code" : "institutional"
            }
          ]
        },
        "subType" : {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-apply-type",
              "code" : "1",
              "display" : "送核"
            }
          ]
        },
        "use" : "preauthorization",
        "patient" : {
          "reference" : "Patient/pat-min"
        },
        "created" : "2024-05-30",
        "enterer" : {
          "reference" : "Practitioner/pra-min"
        },
        "provider" : {
          "reference" : "Organization/org-hosp-example"
        },
        "priority" : {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-tmhb-type",
              "code" : "1",
              "display" : "一般事前審查申請"
            }
          ]
        },
        "supportingInfo" : [
          {
            "sequence" : 1,
            "category" : {
              "coding" : [
                {
                  "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                  "code" : "weight"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 59.65,
              "system" : "http://unitsofmeasure.org",
              "code" : "kg"
            }
          },
          {
            "sequence" : 2,
            "category" : {
              "coding" : [
                {
                  "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                  "code" : "height"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 170,
              "system" : "http://unitsofmeasure.org",
              "code" : "cm"
            }
          },
          {
            "sequence" : 3,
            "category" : {
              "coding" : [
                {
                  "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                  "code" : "bloodgroup"
                }
              ]
            },
            "valueReference" : {
              "reference" : "Observation/obs-blood-group"
            }
          },
          {
            "sequence" : 4,
            "category" : {
              "coding" : [
                {
                  "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                  "code" : "imagingReport"
                }
              ]
            },
            "valueReference" : {
              "reference" : "DiagnosticReport/diaRep-ima-min"
            }
          },
          {
            "sequence" : 6,
            "category" : {
              "coding" : [
                {
                  "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                  "code" : "examinationReport"
                }
              ]
            },
            "valueReference" : {
              "reference" : "DiagnosticReport/diaRep-min"
            }
          },
          {
            "sequence" : 8,
            "category" : {
              "coding" : [
                {
                  "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                  "code" : "tests"
                }
              ]
            },
            "valueReference" : {
              "reference" : "Observation/obs-lab-min"
            }
          },
          {
            "sequence" : 9,
            "category" : {
              "coding" : [
                {
                  "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                  "code" : "tests"
                }
              ]
            },
            "valueReference" : {
              "reference" : "Observation/obs-lab-cbc"
            }
          },
          {
            "sequence" : 10,
            "category" : {
              "coding" : [
                {
                  "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                  "code" : "patientAssessment"
                }
              ]
            },
            "valueReference" : {
              "reference" : "Observation/obs-pat-nyha"
            }
          },
          {
            "sequence" : 11,
            "category" : {
              "coding" : [
                {
                  "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                  "code" : "medicationRequest"
                }
              ]
            },
            "valueReference" : {
              "reference" : "MedicationRequest/medReq-treat"
            }
          },
          {
            "sequence" : 12,
            "category" : {
              "coding" : [
                {
                  "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                  "code" : "radiotherapy"
                }
              ]
            },
            "valueReference" : {
              "reference" : "Procedure/pro-min"
            }
          },
          {
            "sequence" : 13,
            "category" : {
              "coding" : [
                {
                  "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                  "code" : "carePlanDocument"
                }
              ]
            },
            "valueReference" : {
              "reference" : "DocumentReference/doc-careplan-min"
            }
          },
          {
            "sequence" : 14,
            "category" : {
              "coding" : [
                {
                  "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                  "code" : "medicalRecord"
                }
              ]
            },
            "valueReference" : {
              "reference" : "DocumentReference/doc-medicalRecord-min"
            }
          },
          {
            "sequence" : 15,
            "category" : {
              "coding" : [
                {
                  "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                  "code" : "treatmentAssessment"
                }
              ]
            },
            "valueReference" : {
              "reference" : "Observation/obs-tx-min"
            }
          },
          {
            "sequence" : 16,
            "category" : {
              "coding" : [
                {
                  "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                  "code" : "opd"
                }
              ]
            },
            "valueReference" : {
              "reference" : "Encounter/enc-opd"
            }
          },
          {
            "sequence" : 17,
            "category" : {
              "coding" : [
                {
                  "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                  "code" : "allergy"
                }
              ]
            },
            "valueReference" : {
              "reference" : "AllergyIntolerance/all-min"
            }
          }
        ],
        "diagnosis" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-pas/StructureDefinition/extension-diagnosisRecordedDate",
                "valueDate" : "2024-01-01"
              }
            ],
            "sequence" : 1,
            "diagnosisCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-cm-2023-tw",
                  "code" : "I50.812"
                }
              ]
            },
            "type" : [
              {
                "text" : "Adenocarcinoma, descending colon, cT3N2M1a, cStage IVA, KRAS G12V, with multiple liver metastases, status post FOLFIRI"
              }
            ]
          }
        ],
        "procedure" : [
          {
            "sequence" : 1,
            "date" : "2024-01-01",
            "procedureCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2023-tw",
                  "code" : "3E0Y704"
                }
              ]
            }
          }
        ],
        "insurance" : [
          {
            "sequence" : 1,
            "focal" : true,
            "coverage" : {
              "reference" : "Coverage/cov-min"
            }
          }
        ],
        "item" : [
          {
            "extension" : [
              {
                "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-requestedService",
                "valueReference" : {
                  "reference" : "MedicationRequest/medReq-apply"
                }
              }
            ],
            "sequence" : 1,
            "productOrService" : {
              "coding" : [
                {
                  "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-order-type",
                  "code" : "1",
                  "display" : "藥品"
                }
              ]
            },
            "modifier" : [
              {
                "coding" : [
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-continuation-status",
                    "code" : "1",
                    "display" : "初次使用"
                  }
                ]
              },
              {
                "coding" : [
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-line-of-therapy",
                    "code" : "1",
                    "display" : "第一線治療"
                  }
                ]
              }
            ],
            "programCode" : [
              {
                "text" : "ALK陽性的晚期非小細胞肺癌第一線治療"
              }
            ],
            "quantity" : {
              "value" : 52,
              "system" : "http://unitsofmeasure.org",
              "code" : "{tbl}"
            }
          },
          {
            "extension" : [
              {
                "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-requestedService",
                "valueReference" : {
                  "reference" : "MedicationRequest/medReq-apply-2"
                }
              }
            ],
            "sequence" : 2,
            "productOrService" : {
              "coding" : [
                {
                  "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-order-type",
                  "code" : "1",
                  "display" : "藥品"
                }
              ]
            },
            "modifier" : [
              {
                "coding" : [
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-continuation-status",
                    "code" : "1",
                    "display" : "初次使用"
                  }
                ]
              },
              {
                "coding" : [
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-line-of-therapy",
                    "code" : "1",
                    "display" : "第一線治療"
                  }
                ]
              }
            ],
            "programCode" : [
              {
                "coding" : [
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-apply-reason",
                    "code" : "C50P1"
                  }
                ]
              }
            ],
            "quantity" : {
              "value" : 70,
              "system" : "http://unitsofmeasure.org",
              "code" : "{tbl}"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Encounter/enc-opd",
      "resource" : {
        "resourceType" : "Encounter",
        "id" : "enc-opd",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-opd-twpas"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Encounter_enc-opd\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Encounter enc-opd</b></p><a name=\"enc-opd\"> </a><a name=\"hcenc-opd\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Encounter-opd-twpas.html\">門診病歷-Encounter OPD TWPAS</a></p></div><p><b>EncounterSubjective</b>: <a href=\"Observation-obs-subjective.html\">Observation Subjective Narrative</a></p><p><b>EncounterObjective</b>: <a href=\"Observation-obs-objective.html\">Observation Objective Narrative</a></p><p><b>EncounterClinicalImpression</b>: <a href=\"ClinicalImpression-cliImp-min.html\">ClinicalImpression: status = completed; summary = Right knee . arthritis . active</a></p><p><b>EncounterCarePlan</b>: <a href=\"CarePlan-careplan-min.html\">CarePlan: status = completed; intent = plan; category = Assessment and Plan of Treatment; description = 1.Arrenge Arthrocentesis of Right knee and synovial fluid analysis (routine, culture and crystal analysis) after patient consent. 2.Analgesics. 3.Bed rest with ice packing if necessary.</a></p><p><b>status</b>: Finished</p><p><b>class</b>: <a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html#v3-ActCode-AMB\">ActCode: AMB</a> (ambulatory)</p><p><b>serviceType</b>: <span title=\"Codes:{http://snomed.info/sct 419772000}\">Family practice (qualifier value)</span></p><h3>Participants</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Individual</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Practitioner-pra-min.html\">Practitioner: identifier = National Person Identifier where the xxx is the ISO table 3166 3-character (alphabetic) country code,Medical License number</a></td></tr></table><p><b>period</b>: 2025-11-11 --&gt; (ongoing)</p><h3>Diagnoses</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Condition</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Condition-con-diagnosis.html\">Condition M17.11</a></td></tr></table><p><b>serviceProvider</b>: <a href=\"Organization-org-hosp-example.html\">Organization 臺北市立聯合醫院</a></p></div>"
        },
        "extension" : [
          {
            "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-encounter-subjective",
            "valueReference" : {
              "reference" : "Observation/obs-subjective"
            }
          },
          {
            "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-encounter-objective",
            "valueReference" : {
              "reference" : "Observation/obs-objective"
            }
          },
          {
            "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-encounter-clinicalImpression",
            "valueReference" : {
              "reference" : "ClinicalImpression/cliImp-min"
            }
          },
          {
            "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-encounter-carePlan",
            "valueReference" : {
              "reference" : "CarePlan/careplan-min"
            }
          }
        ],
        "status" : "finished",
        "class" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "AMB"
        },
        "serviceType" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "419772000"
            }
          ]
        },
        "participant" : [
          {
            "individual" : {
              "reference" : "Practitioner/pra-min"
            }
          }
        ],
        "period" : {
          "start" : "2025-11-11"
        },
        "diagnosis" : [
          {
            "condition" : {
              "reference" : "Condition/con-diagnosis"
            }
          }
        ],
        "serviceProvider" : {
          "reference" : "Organization/org-hosp-example"
        }
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Encounter/enc-min",
      "resource" : {
        "resourceType" : "Encounter",
        "id" : "enc-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4;\n        border-radius: 5px; line-height: 60%\"><a name=\"Encounter_enc-min\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Encounter-twpas.html\">就醫科別-Encounter TWPAS</a></p></div><p><b>就醫現況</b>：Planned <span style=\"background: LightGoldenRodYellow; margin:\n            4px; border: 1px solid khaki\">(<a href=\"https://hl7.org/fhir/R4/codesystem-encounter-status.html\">EncounterStatus</a>#planned)</span></p><p><b>就醫分類</b>：ambulatory <span style=\"background: LightGoldenRodYellow; margin:\n            4px; border: 1px solid khaki\">(<a href=\"https://terminology.hl7.org/5.5.0/CodeSystem-v3-ActCode.html\">ActEncounterCode CT</a>#AMB)</span></p><p><b>就醫科別</b>：胸腔暨重症加護 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw/\">臺灣健保署就醫科別</a>#AJ)</span></p></div>"
        },
        "status" : "planned",
        "class" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "AMB"
        },
        "serviceType" : {
          "coding" : [
            {
              "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw",
              "code" : "AJ"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Patient/pat-min",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "pat-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><a name=\"Patient_pat-min\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Patient-twpas.html\">病人資訊-Patient TWPAS</a></p></div><blockquote><p><b>識別碼型別</b>：National Person Identifier <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">Identifier Type Codes</a>#NNxxx）</span><br/><b>身分證字號（official）</b>：A123456789 （http://www.moi.gov.tw）</p></blockquote><blockquote><p><b>識別碼型別</b>：Medical record number <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">Identifier Type Codes</a>#MR）</span><br/><b>病歷號（official）</b>：123456 （https://tpech.gov.taipei）</p></blockquote><p><b>姓名（usual）</b>：王大明</p><p><b>性別</b>：男</p><p><b>出生日期</b>：2001-01-01</p></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "NNxxx"
                }
              ]
            },
            "system" : "http://www.moi.gov.tw",
            "value" : "A123456789"
          },
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "MR"
                }
              ]
            },
            "system" : "https://tpech.gov.taipei",
            "value" : "123456"
          }
        ],
        "name" : [
          {
            "use" : "usual",
            "text" : "王大明"
          }
        ],
        "gender" : "male",
        "birthDate" : "2001-01-01"
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Practitioner/pra-min",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "pra-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Practitioner-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><a name=\"Practitioner_pra-min\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Practitioner-twpas.html\">醫事人員-Practitioner TWPAS</a></p></div><blockquote><p><b>識別碼型別</b>：National Person Identifier <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">Identifier Type Codes</a>#NNxxx）</span></p><p><b>身分證字號（official）</b>：F123456789 （http://www.moi.gov.tw）</p></blockquote><blockquote><p><b>識別碼型別</b>：Medical License number <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">Identifier Type Codes</a>#MD）</span></p><p><b>醫師證號</b>：KP00017 （https://dep.mohw.gov.tw/DOMA）</p></blockquote></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "NNxxx"
                }
              ]
            },
            "system" : "http://www.moi.gov.tw",
            "value" : "F123456789"
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "MD"
                }
              ]
            },
            "system" : "https://dep.mohw.gov.tw/DOMA",
            "value" : "KP00017"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Organization/org-hosp-example",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "org-hosp-example",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Organization-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_org-hosp-example\"> </a><h3><b>醫事機構</b></h3><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Organization-twpas.html\">機構-Organization TWPAS</a></p></div><p><b>機構名稱</b>：臺北市立聯合醫院</p><p><b>識別碼型別</b>：Provider number<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">IdentifierType</a>#PRN）</span><br/><b>機構代碼（official）</b>：0101090517 (https://nhicore.nhi.gov.tw/pas/CodeSystem/organization-identifier-tw)</p><p><b>機構種類</b>：Healthcare Provider <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://hl7.org/fhir/R4/codesystem-organization-type.html\">OrganizationType</a>#prov)</span></p></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "PRN"
                }
              ]
            },
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/organization-identifier-tw",
            "value" : "0101090517"
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
                "code" : "prov"
              }
            ]
          }
        ],
        "name" : "臺北市立聯合醫院"
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Condition/con-diagnosis",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "con-diagnosis",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Condition-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_con-diagnosis\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition con-diagnosis</b></p><a name=\"con-diagnosis\"> </a><a name=\"hccon-diagnosis\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Condition-twpas.html\">診斷-Condition TWPAS</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>category</b>: <span title=\"Codes:{http://loinc.org 29548-5}\">Diagnosis Narrative</span></p><p><b>code</b>: <span title=\"Codes:{https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-cm-2023-tw M17.11}\">M17.11</span></p><p><b>subject</b>: <a href=\"Patient-pat-min.html\">王大明 Male, DoB: 2001-01-01 ( Medical record number (use: official, ))</a></p><p><b>encounter</b>: <a href=\"Encounter-enc-opd.html\">Encounter: extension = -&gt;Observation Subjective Narrative,-&gt;Observation Objective Narrative,-&gt;ClinicalImpression: status = completed; summary = Right knee . arthritis . active,-&gt;CarePlan: status = completed; intent = plan; category = Assessment and Plan of Treatment; description = 1.Arrenge Arthrocentesis of Right knee and synovial fluid analysis (routine, culture and crystal analysis) after patient consent. 2.Analgesics. 3.Bed rest with ice packing if necessary.; status = finished; class = ambulatory (ActCode#AMB); serviceType = Family practice (qualifier value); period = 2025-11-11 --&gt; (ongoing)</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "29548-5"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-cm-2023-tw",
              "code" : "M17.11"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "encounter" : {
          "reference" : "Encounter/enc-opd"
        }
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Observation/obs-blood-group",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "obs-blood-group",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-blood-group-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_obs-blood-group\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation obs-blood-group</b></p><a name=\"obs-blood-group\"> </a><a name=\"hcobs-blood-group\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-blood-group-twpas.html\">血型-Observation Blood Group TWPAS</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type bloodgroup}\">病人血型</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 882-1}\">ABO and Rh group [Type] in Blood</span></p><p><b>subject</b>: <a href=\"Patient-pat-min.html\">王大明 Male, DoB: 2001-01-01 ( Medical record number (use: official, ))</a></p><p><b>effective</b>: 2024-05-07</p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 112144000}\">Blood group A</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                "code" : "bloodgroup"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "882-1"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "effectiveDateTime" : "2024-05-07",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "112144000"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/AllergyIntolerance/all-min",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "all-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/AllergyIntolerance-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_all-min\"> </a><p class=\"res-header-id\"><b>Generated Narrative: AllergyIntolerance all-min</b></p><a name=\"all-min\"> </a><a name=\"hcall-min\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-AllergyIntolerance-twpas.html\">過敏史-AllergyIntolerance TWPAS</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:\">對 A 藥物過敏，過敏反應為全身性皮疹、呼吸喘，約在服用後15分鐘發生。曾於2023年5月因感冒服用過 A 藥，出現上述過敏反應，故此後避免使用。</span></p><p><b>patient</b>: <a href=\"Patient-pat-min.html\">王大明 Male, DoB: 2001-01-01 ( Medical record number (use: official, ))</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "text" : "對 A 藥物過敏，過敏反應為全身性皮疹、呼吸喘，約在服用後15分鐘發生。曾於2023年5月因感冒服用過 A 藥，出現上述過敏反應，故此後避免使用。"
        },
        "patient" : {
          "reference" : "Patient/pat-min"
        }
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Observation/obs-subjective",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "obs-subjective",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-subjective-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_obs-subjective\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation obs-subjective</b></p><a name=\"obs-subjective\"> </a><a name=\"hcobs-subjective\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-subjective-twpas.html\">主觀描述-Observation Subjective TWPAS</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category survey}\">Survey</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 61150-9}\">Subjective Narrative</span></p><p><b>subject</b>: <a href=\"Patient-pat-min.html\">王大明 Male, DoB: 2001-01-01 ( Medical record number (use: official, ))</a></p><p><b>encounter</b>: <a href=\"Encounter-enc-opd.html\">Encounter: extension = -&gt;Observation Subjective Narrative,-&gt;Observation Objective Narrative,-&gt;ClinicalImpression: status = completed; summary = Right knee . arthritis . active,-&gt;CarePlan: status = completed; intent = plan; category = Assessment and Plan of Treatment; description = 1.Arrenge Arthrocentesis of Right knee and synovial fluid analysis (routine, culture and crystal analysis) after patient consent. 2.Analgesics. 3.Bed rest with ice packing if necessary.; status = finished; class = ambulatory (ActCode#AMB); serviceType = Family practice (qualifier value); period = 2025-11-11 --&gt; (ongoing)</a></p><p><b>effective</b>: 2025-11-11</p><p><b>value</b>: Pain and tenderness of Right knee since yesterday.</p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "survey"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "61150-9"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "encounter" : {
          "reference" : "Encounter/enc-opd"
        },
        "effectiveDateTime" : "2025-11-11",
        "valueString" : "Pain and tenderness of Right knee since yesterday."
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Observation/obs-objective",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "obs-objective",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-objective-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_obs-objective\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation obs-objective</b></p><a name=\"obs-objective\"> </a><a name=\"hcobs-objective\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-objective-twpas.html\">客觀描述-Observation Objective TWPAS</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category survey}\">Survey</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 61149-1}\">Objective Narrative</span></p><p><b>subject</b>: <a href=\"Patient-pat-min.html\">王大明 Male, DoB: 2001-01-01 ( Medical record number (use: official, ))</a></p><p><b>encounter</b>: <a href=\"Encounter-enc-opd.html\">Encounter: extension = -&gt;Observation Subjective Narrative,-&gt;Observation Objective Narrative,-&gt;ClinicalImpression: status = completed; summary = Right knee . arthritis . active,-&gt;CarePlan: status = completed; intent = plan; category = Assessment and Plan of Treatment; description = 1.Arrenge Arthrocentesis of Right knee and synovial fluid analysis (routine, culture and crystal analysis) after patient consent. 2.Analgesics. 3.Bed rest with ice packing if necessary.; status = finished; class = ambulatory (ActCode#AMB); serviceType = Family practice (qualifier value); period = 2025-11-11 --&gt; (ongoing)</a></p><p><b>effective</b>: 2025-11-11</p><p><b>value</b>: BP 110/70 mmHg  PR 80/min  BT 38.50C</p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "survey"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "61149-1"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "encounter" : {
          "reference" : "Encounter/enc-opd"
        },
        "effectiveDateTime" : "2025-11-11",
        "valueString" : "BP 110/70 mmHg  PR 80/min  BT 38.50C"
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/ClinicalImpression/cliImp-min",
      "resource" : {
        "resourceType" : "ClinicalImpression",
        "id" : "cliImp-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClinicalImpression-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ClinicalImpression_cliImp-min\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ClinicalImpression cliImp-min</b></p><a name=\"cliImp-min\"> </a><a name=\"hccliImp-min\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-ClinicalImpression-twpas.html\">評估-ClinicalImpression TWPAS</a></p></div><p><b>status</b>: Completed</p><p><b>subject</b>: <a href=\"Patient-pat-min.html\">王大明 Male, DoB: 2001-01-01 ( Medical record number (use: official, ))</a></p><p><b>encounter</b>: <a href=\"Encounter-enc-opd.html\">Encounter: extension = -&gt;Observation Subjective Narrative,-&gt;Observation Objective Narrative,-&gt;ClinicalImpression: status = completed; summary = Right knee . arthritis . active,-&gt;CarePlan: status = completed; intent = plan; category = Assessment and Plan of Treatment; description = 1.Arrenge Arthrocentesis of Right knee and synovial fluid analysis (routine, culture and crystal analysis) after patient consent. 2.Analgesics. 3.Bed rest with ice packing if necessary.; status = finished; class = ambulatory (ActCode#AMB); serviceType = Family practice (qualifier value); period = 2025-11-11 --&gt; (ongoing)</a></p><p><b>summary</b>: Right knee . arthritis . active</p></div>"
        },
        "status" : "completed",
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "encounter" : {
          "reference" : "Encounter/enc-opd"
        },
        "summary" : "Right knee . arthritis . active"
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/CarePlan/careplan-min",
      "resource" : {
        "resourceType" : "CarePlan",
        "id" : "careplan-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/CarePlan-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"CarePlan_careplan-min\"> </a><p class=\"res-header-id\"><b>Generated Narrative: CarePlan careplan-min</b></p><a name=\"careplan-min\"> </a><a name=\"hccareplan-min\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-CarePlan-twpas.html\">計畫-CarePlan TWPAS</a></p></div><p><b>status</b>: Completed</p><p><b>intent</b>: Plan</p><p><b>category</b>: <span title=\"Codes:{https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/careplan-category-tw assess-plan}\">Assessment and Plan of Treatment</span></p><p><b>description</b>: 1.Arrenge Arthrocentesis of Right knee and synovial fluid analysis (routine, culture and crystal analysis) after patient consent. 2.Analgesics. 3.Bed rest with ice packing if necessary.</p><p><b>subject</b>: <a href=\"Patient-pat-min.html\">王大明 Male, DoB: 2001-01-01 ( Medical record number (use: official, ))</a></p><p><b>encounter</b>: <a href=\"Encounter-enc-opd.html\">Encounter: extension = -&gt;Observation Subjective Narrative,-&gt;Observation Objective Narrative,-&gt;ClinicalImpression: status = completed; summary = Right knee . arthritis . active,-&gt;CarePlan: status = completed; intent = plan; category = Assessment and Plan of Treatment; description = 1.Arrenge Arthrocentesis of Right knee and synovial fluid analysis (routine, culture and crystal analysis) after patient consent. 2.Analgesics. 3.Bed rest with ice packing if necessary.; status = finished; class = ambulatory (ActCode#AMB); serviceType = Family practice (qualifier value); period = 2025-11-11 --&gt; (ongoing)</a></p></div>"
        },
        "status" : "completed",
        "intent" : "plan",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/careplan-category-tw",
                "code" : "assess-plan"
              }
            ]
          }
        ],
        "description" : "1.Arrenge Arthrocentesis of Right knee and synovial fluid analysis (routine, culture and crystal analysis) after patient consent. 2.Analgesics. 3.Bed rest with ice packing if necessary.",
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "encounter" : {
          "reference" : "Encounter/enc-opd"
        }
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/DiagnosticReport/diaRep-ima-min",
      "resource" : {
        "resourceType" : "DiagnosticReport",
        "id" : "diaRep-ima-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DiagnosticReport-image-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><a name=\"DiagnosticReport_diaRep-ima-min\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-DiagnosticReport-image-twpas.html\">影像報告-DiagnosticReport Image TWPAS</a></p></div><p><b>狀態</b>：final</p><p><b>病人</b>：<a href=\"Patient-pat-min.html\">Patient/pat-min</a> &quot;王大明&quot;</p><p><b>影像報告</b>：左上肢動脈血管內超音波 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2023-tw\">臺灣健保署2023年中文版ICD-10-PCS值集</a>#B34JZZ3)</span></p><p><b>影像報告日期</b>：2024-05-07</p><p><b>簽發影像報告醫師</b>：<a href=\"Practitioner-pra-min.html\">Practitioner/pra-min</a></p><p><b>影像檢查的身體部位／DICOM影像</b>：<a href=\"ImagingStudy-imaStu-min.html\">ImagingStudy/imaStu-min</a></p><p><b>影像報告結果</b>：影像報告結果</p><blockquote><p><b>影像報告名稱</b>：影像報告01</p><p><b>影像報告</b>：file://ImagingDiagnosticReport01.pdf</p></blockquote><blockquote><p><b>影像報告名稱</b>：影像報告02</p><p><b>影像報告</b>：file://ImagingDiagnosticReport02.pdf</p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                "code" : "imagingReport"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2023-tw",
              "code" : "B34JZZ3"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "effectiveDateTime" : "2024-05-07",
        "performer" : [
          {
            "reference" : "Practitioner/pra-min"
          }
        ],
        "imagingStudy" : [
          {
            "reference" : "ImagingStudy/imaStu-min"
          }
        ],
        "conclusion" : "影像報告結果",
        "presentedForm" : [
          {
            "contentType" : "application/pdf",
            "url" : "file://ImagingDiagnosticReport01.pdf",
            "title" : "影像報告"
          },
          {
            "contentType" : "application/pdf",
            "url" : "file://ImagingDiagnosticReport02.pdf",
            "title" : "影像報告"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/ImagingStudy/imaStu-min",
      "resource" : {
        "resourceType" : "ImagingStudy",
        "id" : "imaStu-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ImagingStudy-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><a name=\"ImagingStudy_imaStu-min\"> </a><p style=\"margin-bottom: 0px\">Profile：<a href=\"StructureDefinition-ImagingStudy-twpas.html\">DICOM影像-ImagingStudy TWPAS</a></p></div><p><b>狀態</b>：registered</p><p><b>病人</b>：<a href=\"Patient-pat-min.html\">Patient/pat-min</a> &quot;王大明&quot;</p><p><b>Study UID</b>：urn:oid:2.16.886.2102.54.4546465747.465465465</p><p><b>Series Instance UID</b>：2.16.886.2102.54.4546465747.465465466</p><p><b>SOP Instance UIDs</b>：2.25.88017001449189502323411118737039844241, 2.25.88017001449189502323411118737039844242</p><p><b>影像檢查的身體部位</b>：Head and neck structure<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> (<a href=\"http://snomed.info/sct\">SNOMED CT</a>#774007)</span></p><p><b>儀器</b>：CT Image Storage<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> (<a href=\"https://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html\">DICOM</a>#CT)</span></p></div>"
        },
        "identifier" : [
          {
            "system" : "urn:dicom:uid",
            "value" : "urn:oid:2.16.886.2102.54.4546465747.465465465"
          }
        ],
        "status" : "registered",
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "series" : [
          {
            "uid" : "2.16.886.2102.54.4546465747.465465466",
            "modality" : {
              "system" : "http://dicom.nema.org/resources/ontology/DCM",
              "code" : "CT"
            },
            "bodySite" : {
              "system" : "http://snomed.info/sct",
              "code" : "774007",
              "display" : "Head and neck structure"
            },
            "instance" : [
              {
                "uid" : "2.25.88017001449189502323411118737039844241",
                "sopClass" : {
                  "system" : "urn:ietf:rfc:3986",
                  "code" : "urn:oid:1.2.840.10008.5.1.4.1.1.2"
                }
              },
              {
                "uid" : "2.25.88017001449189502323411118737039844242",
                "sopClass" : {
                  "system" : "urn:ietf:rfc:3986",
                  "code" : "urn:oid:1.2.840.10008.5.1.4.1.1.2"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Media/med-min",
      "resource" : {
        "resourceType" : "Media",
        "id" : "med-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Media-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><a name=\"Media_med-min\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Media-twpas.html\">非DICOM影像-Media TWPAS</a></p></div><p><b>狀態</b>：completed</p><p><b>病人</b>：<a href=\"Patient-pat-min.html\">Patient/pat-min</a> &quot;王大明&quot;</p><p><b>影像檢查的身體部位</b>：Head and neck structure<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> (<a href=\"http://snomed.info/sct\">SNOMED CT</a>#774007)</span></p><p><b>非DICOM影像</b>：file://US01.jpg（#image/jpeg）</p></div>"
        },
        "status" : "completed",
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "bodySite" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "774007",
              "display" : "Head and neck structure"
            }
          ]
        },
        "content" : {
          "contentType" : "image/jpeg",
          "url" : "file://US01.jpg"
        }
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/DiagnosticReport/diaRep-min",
      "resource" : {
        "resourceType" : "DiagnosticReport",
        "id" : "diaRep-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DiagnosticReport-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><a name=\"DiagnosticReport_diaRep-min\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-DiagnosticReport-twpas.html\">檢查報告-DiagnosticReport TWPAS</a></p></div><p><b>狀態</b>：final</p><p><b>報告類型</b>：Prostate Pathology biopsy report <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"http://loinc.org\">EncounterStatus</a>#66117-3)</span></p><p><b>檢體種類</b>：Prostate</p><p><b>病人</b>：<a href=\"Patient-pat-min.html\">Patient/pat-min</a> &quot;王大明&quot;</p><p><b>報告日期</b>：2024-05-07</p><p><b>檢查報告醫師</b>：<a href=\"Practitioner-pra-min.html\">Practitioner/pra-min</a></p><p><b>報告結果-文數字</b>：細胞檢查報告結果</p><blockquote><p><b>檢查報告名稱</b>：PathologyReport01</p><p><b>檢查報告</b>：file://PathologyReport01.pdf</p></blockquote><blockquote><p><b>檢查報告名稱</b>：PathologyReport02</p><p><b>檢查報告</b>：file://PathologyReport02.pdf</p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                "code" : "examinationReport"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "66117-3"
            }
          ],
          "text" : "Prostate"
        },
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "effectiveDateTime" : "2024-05-07",
        "performer" : [
          {
            "reference" : "Practitioner/pra-min"
          }
        ],
        "conclusion" : "細胞檢查報告結果",
        "presentedForm" : [
          {
            "contentType" : "application/pdf",
            "url" : "file://PathologyReport01.pdf",
            "title" : "PathologyReport01"
          },
          {
            "contentType" : "application/pdf",
            "url" : "file://PathologyReport02.pdf",
            "title" : "PathologyReport02"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Observation/obs-lab-min",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "obs-lab-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-laboratory-result-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><a name=\"Observation_obs-lab-min\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-laboratory-result-twpas.html\">檢驗檢查-Observation Laboratory Result TWPAS</a></p></div><p><b>狀態</b>：final</p><p><b>類型</b>：檢驗(查)<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> (<a href=\"CodeSystem-nhi-supporting-info-type.html/\">NHI-補充資訊類別值集</a>#tests)</span></p><p><b>檢驗(查)名稱</b>：Platelets [#/volume] in Blood by Automated count <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"http://loinc.org/\">LOINCCodes</a>#777-3)</span></p><p><b>病人</b>：<a href=\"Patient-pat-min.html\">Patient/pat-min</a></p><p><b>檢驗(查)報告日期</b>：2024-01-01</p><p><b>簽發檢驗(查)報告醫事人員身分證號</b>：<a href=\"Practitioner-pra-min.html\">Practitioner/pra-min</a></p><p><b>檢驗(查)結果</b>：5.1 mmol/l</p><p><b>檢驗(查)結果判讀</b>：高，High <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation/\">ObservationInterpretationCodes </a>#H)</span></p><p><b>檢驗(查)結果之參考範圍下限</b>：2.9 mmol/L</p><p><b>檢驗(查)結果之參考範圍上限</b>：4.9 mmol/L</p><p><b>檢驗(查)附件</b>：<a href=\"DocumentReference-doc-test-min.html\">DocumentReference/doc-test-min</a></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                "code" : "tests"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "777-3"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "effectiveDateTime" : "2024-01-01",
        "performer" : [
          {
            "reference" : "Practitioner/pra-min"
          }
        ],
        "valueQuantity" : {
          "value" : 5.1,
          "unit" : "mmol/l"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "H"
              }
            ],
            "text" : "高"
          }
        ],
        "referenceRange" : [
          {
            "low" : {
              "value" : 2.9,
              "unit" : "mmol/l",
              "system" : "http://unitsofmeasure.org",
              "code" : "mmol/L"
            },
            "high" : {
              "value" : 4.9,
              "unit" : "mmol/l",
              "system" : "http://unitsofmeasure.org",
              "code" : "mmol/L"
            }
          }
        ],
        "derivedFrom" : [
          {
            "reference" : "DocumentReference/doc-test-min"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Observation/obs-lab-cbc",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "obs-lab-cbc",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-laboratory-result-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><a name=\"Observation_obs-lab-cbc\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-laboratory-result-twpas.html\">檢驗檢查-Observation Laboratory Result TWPAS</a></p></div><p><b>狀態</b>：final</p><p><b>類型</b>：檢驗(查)<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> (<a href=\"CodeSystem-nhi-supporting-info-type.html/\">NHI-補充資訊類別值集</a>#tests)</span></p><p><b>套組代碼</b>：CBC panel - Blood by Automated count <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"http://loinc.org/\">LOINCCodes</a>#58410-2)</span></p><p><b>病人</b>：<a href=\"Patient-pat-min.html\">Patient/pat-min</a></p><p><b>檢驗(查)報告日期</b>：2024-01-01</p><p><b>簽發檢驗(查)報告醫事人員身分證號</b>：<a href=\"Practitioner-pra-min.html\">Practitioner/pra-min</a></p><p><b>檢驗(查)附件</b>：<a href=\"DocumentReference-doc-test-min.html\">DocumentReference/doc-test-min</a></p><blockquote><p><b>檢驗(查)名稱</b>：Leukocytes [#/volume] in Blood by Automated count <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"http://loinc.org/\">LOINCCodes</a>#6690-2)</span><br/><b>檢驗(查)結果</b>：3.6 × 10^3/μL<br/><b>檢驗(查)結果之參考範圍下限</b>：3.9 × 10^3/μL<br/><b>檢驗(查)結果之參考範圍上限</b>：10.6 × 10^3/μL</p></blockquote><blockquote><p><b>檢驗(查)名稱</b>：Erythrocytes [#/volume] in Blood by Automated count <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"http://loinc.org/\">LOINCCodes</a>#789-8)</span><br/><b>檢驗(查)結果</b>：4.7 × 10^6/μL<br/><b>檢驗(查)結果之參考範圍下限</b>：4.5 × 10^3/μL<br/><b>檢驗(查)結果之參考範圍上限</b>：5.9 × 10^3/μL</p></blockquote><blockquote><p><b>檢驗(查)名稱</b>：Hemoglobin [Mass/volume] in Blood <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"http://loinc.org/\">LOINCCodes</a>#718-7)</span><br/><b>檢驗(查)結果</b>：14 g/dL<br/><b>檢驗(查)結果之參考範圍下限</b>：13.5 g/dL<br/><b>檢驗(查)結果之參考範圍上限</b>：17.5 g/dL</p></blockquote><blockquote><p><b>檢驗(查)名稱</b>：Hematocrit [Volume Fraction] of Blood by Automated count <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"http://loinc.org/\">LOINCCodes</a>#4544-3)</span><br/><b>檢驗(查)結果</b>：45 %<br/><b>檢驗(查)結果之參考範圍下限</b>：41 %<br/><b>檢驗(查)結果之參考範圍上限</b>：53 %</p></blockquote><blockquote><p><b>檢驗(查)名稱</b>：Platelets [#/volume] in Blood by Automated count <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"http://loinc.org/\">LOINCCodes</a>#777-3)</span><br/><b>檢驗(查)結果</b>：101 × 10^3/μL<br/><b>檢驗(查)結果之參考範圍下限</b>：150 × 10^3/μL<br/><b>檢驗(查)結果之參考範圍上限</b>：400 × 10^3/μL</p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                "code" : "tests"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "58410-2"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "effectiveDateTime" : "2024-01-01",
        "performer" : [
          {
            "reference" : "Practitioner/pra-min"
          }
        ],
        "derivedFrom" : [
          {
            "reference" : "DocumentReference/doc-test-min"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "6690-2"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 3.6,
              "unit" : "10*3/uL"
            },
            "referenceRange" : [
              {
                "low" : {
                  "value" : 3.9,
                  "unit" : "10*3/uL"
                },
                "high" : {
                  "value" : 10.6,
                  "unit" : "10*3/uL"
                }
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "789-8"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 4.7,
              "unit" : "10*6/uL"
            },
            "referenceRange" : [
              {
                "low" : {
                  "value" : 4.5,
                  "unit" : "10*6/uL"
                },
                "high" : {
                  "value" : 5.9,
                  "unit" : "10*6/uL"
                }
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "718-7"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 14,
              "unit" : "g/dL"
            },
            "referenceRange" : [
              {
                "low" : {
                  "value" : 13.5,
                  "unit" : "g/dL"
                },
                "high" : {
                  "value" : 17.5,
                  "unit" : "g/dL"
                }
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "4544-3"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 45,
              "unit" : "%"
            },
            "referenceRange" : [
              {
                "low" : {
                  "value" : 41,
                  "unit" : "%"
                },
                "high" : {
                  "value" : 53,
                  "unit" : "%"
                }
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "777-3"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 101,
              "unit" : "10*3/uL"
            },
            "referenceRange" : [
              {
                "low" : {
                  "value" : 150,
                  "unit" : "10*3/uL"
                },
                "high" : {
                  "value" : 400,
                  "unit" : "10*3/uL"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/DocumentReference/doc-test-min",
      "resource" : {
        "resourceType" : "DocumentReference",
        "id" : "doc-test-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DocumentReference-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4;\n        border-radius: 5px; line-height: 60%\"><a name=\"DocumentReference_doc-test-min\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-DocumentReference-twpas.html\">文件參照-DocumentReference TWPAS</a></p></div><p><b>狀態</b>：current</p><p><b>報告類型</b>：檢驗(查)附件 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"CodeSystem-nhi-pdf-type.html\">NHI-文件類型</a>#test)</span></p><p><b>病人</b>：<a href=\"Patient-pat-min.html\">Patient/pat-min</a> &quot;王大明&quot;</p><blockquote><p><b>檢驗(查)附件 (application/pdf)</b>：file://TestReport01.pdf</p><p><b>檢驗(查)附件名稱</b>：TestReport01</p></blockquote><blockquote><p><b>檢驗(查)附件 (application/pdf)</b>：file://TestReport02.pdf</p><p><b>檢驗(查)附件名稱</b>：TestReport02</p></blockquote></div>"
        },
        "status" : "current",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-pdf-type",
                "code" : "test"
              }
            ]
          }
        ],
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "content" : [
          {
            "attachment" : {
              "contentType" : "application/pdf",
              "url" : "file://TestReport01.pdf",
              "title" : "TestReport01"
            }
          },
          {
            "attachment" : {
              "contentType" : "application/pdf",
              "url" : "file://TestReport02.pdf",
              "title" : "TestReport02"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Observation/obs-pat-nyha",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "obs-pat-nyha",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-pat-assessment-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><a name=\"Observation_obs-pat-nyha\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-pat-assessment-twpas.html\">病人狀態評估-Observation Patient Assessment TWPAS</a></p></div><p><b>狀態</b>：final</p><p><b>病人狀態評估項目代碼</b>：Functional capacity NYHA <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"http://loinc.org\">LOINC + SCT + NHI-健保事前審查-病人狀態評估項目值集 </a>#88020-3)</span></p><p><b>病人</b>：<a href=\"Patient-pat-min.html\">Patient/pat-min</a></p><p><b>病人狀態評估日期</b>：2024-01-01</p><p><b>評估項目醫事人員身分證號</b>：<a href=\"Practitioner-pra-min.html\">Practitioner/pra-min</a></p><p><b>病人狀態評估結果</b>：class1</p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
                "code" : "patientAssessment"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "88020-3"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "effectiveDateTime" : "2024-01-01",
        "performer" : [
          {
            "reference" : "Practitioner/pra-min"
          }
        ],
        "valueString" : "class1"
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/MedicationRequest/medReq-treat",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "medReq-treat",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/MedicationRequest-treat-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4;\n        border-radius: 5px; line-height: 60%\"><a name=\"MedicationRequest_medReq-treat\"> </a><p style=\"margin-bottom: 0px\">Profile：<a href=\"StructureDefinition-MedicationRequest-treat-twpas.html\">用藥品項-MedicationRequest Treat TWPAS</a></p></div><p><b>藥物使用狀態</b>：completed</p><p><b>藥物處方終止原因</b>：Try another treatment first <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"https://hl7.org/fhir/R4/codesystem-medicationrequest-status-reason.html\">MedicationRequest Status Reason Codes</a>#altchoice)</span></p><p><b>意圖</b>：Order <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://hl7.org/fhir/CodeSystem/medicationrequest-intent\">medicationRequest Intent</a>#order)</span></p><p><b>自費註記</b>：健保 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"CodeSystem-nhi-drug-category.html\">NHI-藥物類型</a>#nhi)</span></p><p><b>藥品代碼</b>：ANTI-CUGH SYRUP 60ML <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"CodeSystem-nhi-medication.html\">NHI-健保事前審查-用藥品項值集</a>#A000755151)</span></p><p><b>病人</b>：<a href=\"Patient-pat-min.html\">Patient/pat-min</a> &quot;&quot;</p><p><b>藥品使用頻率及服用時間</b>：1W3D</p><p><b>藥物每次處方劑量(單位)</b>：4 (tablets <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"https://hl7.org/fhir/R4/valueset-ucum-common.html\">Common UCUM units</a>#{tbl})</span>)</p><p><b>藥物處方起始日期</b>：2024-05-01</p><p><b>藥物處方終止日期</b>：2024-05-07</p><p><b>給藥途徑／作用部位</b>：Oral use <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"http://snomed.info/sct/\">SNOMED CT + 臺灣健保署給藥途徑值集</a>#26643006)</span></p></div>"
        },
        "status" : "completed",
        "statusReason" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/medicationrequest-status-reason",
              "code" : "altchoice"
            }
          ]
        },
        "intent" : "order",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-drug-category",
                "code" : "nhi"
              }
            ]
          }
        ],
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-medication",
              "code" : "A000755151"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2024-05-01",
                  "end" : "2024-05-07"
                }
              },
              "code" : {
                "text" : "1W3D"
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "26643006"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 4,
                  "unit" : "tablets",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "{tbl}"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Procedure/pro-min",
      "resource" : {
        "resourceType" : "Procedure",
        "id" : "pro-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Procedure-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4;\n        border-radius: 5px; line-height: 60%\"><a name=\"Procedure_pro-min\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Procedure-twpas.html\">放射/照光治療-Procedure TWPAS</a></p></div><p><b>放射/照光治療狀態</b>：completed</p><p><b>放射/照光治療項目</b>：骨髓高溫療法 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"https://twcore.mohw.gov.tw/ig/twcore/0.3.2/CodeSystem-icd-10-pcs-2023-tw.html\">臺灣2023年中文版ICD-10-PCS</a>#D7Y08ZZ)</span></p><p><b>病人</b>：<a href=\"Patient-pat-min.html\">Patient/pat-min</a> &quot;王大明&quot;</p><p><b>放射/照光治療日期</b>：2024-05-06 09:00:00+0000</p><p><b>放射/照光治療總劑量</b>：<a href=\"Substance-sub-min.html\">Substance/sub-min</a> 5000 mg</p></div>"
        },
        "status" : "completed",
        "code" : {
          "coding" : [
            {
              "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2023-tw",
              "code" : "D7Y08ZZ"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "performedDateTime" : "2024-05-06T09:00:00.000Z",
        "usedReference" : [
          {
            "reference" : "Substance/sub-min"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Substance/sub-min",
      "resource" : {
        "resourceType" : "Substance",
        "id" : "sub-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Substance-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4;\n        border-radius: 5px; line-height: 60%\"><a name=\"Substance_sub-min\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Substance-twpas.html\">放射/照光治療總劑量-Substance TWPAS</a></p></div><p><b>放射/照光治療項目</b>：骨髓高溫療法 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"https://twcore.mohw.gov.tw/ig/twcore/0.3.2/CodeSystem-icd-10-pcs-2023-tw.html\">臺灣2023年中文版ICD-10-PCS</a>#D7Y08ZZ)</span></p><p><b>放射/照光治療總劑量(單位)</b>：5000 (/mg)</p></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2023-tw",
              "code" : "D7Y08ZZ"
            }
          ]
        },
        "ingredient" : [
          {
            "quantity" : {
              "numerator" : {
                "value" : 5000,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 0
              }
            },
            "substanceCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2023-tw",
                  "code" : "D7Y08ZZ"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/DocumentReference/doc-careplan-min",
      "resource" : {
        "resourceType" : "DocumentReference",
        "id" : "doc-careplan-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DocumentReference-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4;\n        border-radius: 5px; line-height: 60%\"><a name=\"DocumentReference_doc-careplan-min\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-DocumentReference-twpas.html\">文件參照-DocumentReference TWPAS</a></p></div><p><b>狀態</b>：current</p><p><b>報告類型</b>：治療計畫文件 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"CodeSystem-nhi-pdf-type.html\">NHI-文件類型</a>#careplan)</span></p><p><b>病人</b>：<a href=\"Patient-pat-min.html\">Patient/pat-min</a> &quot;王大明&quot;</p><p><b>治療計畫文件名稱</b>：免疫檢查點抑制劑治療計畫</p><p><b>治療計畫文件 (application/pdf)</b>：file://CarePlanReport01.pdf</p></div>"
        },
        "status" : "current",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-pdf-type",
                "code" : "careplan"
              }
            ]
          }
        ],
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "content" : [
          {
            "attachment" : {
              "contentType" : "application/pdf",
              "url" : "file://CarePlanReport01.pdf",
              "title" : "免疫檢查點抑制劑治療計畫"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Observation/obs-tx-min",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "obs-tx-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-tx-assessment-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><a name=\"Observation_obs-tx-min\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-tx-assessment-twpas.html\">治療後疾病狀態評估-Observation Treatment Assessment TWPAS</a></p></div><p><b>狀態</b>：final</p><p><b>治療後疾病狀態評估項目</b>：International Working Group(IWG) Consensus Criteria<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> (<a href=\"CodeSystem-nhi-tx-ast.html\">NHI-治療後疾病狀態評估項目值集</a>#IWGC)</span></p><p><b>病人</b>：<a href=\"Patient-pat-min.html\">Patient/pat-min</a></p><p><b>治療後疾病狀態評估日期</b>：2024-01-01</p><p><b>治療後疾病狀態評估結果</b>：Partial remission (PR)</p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-tx-ast",
              "code" : "IWGC",
              "display" : "International Working Group(IWG) Consensus Criteria"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "effectiveDateTime" : "2024-05-07",
        "performer" : [
          {
            "reference" : "Practitioner/pra-min"
          }
        ],
        "valueString" : "Partial remission (PR)"
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/MedicationRequest/medReq-apply",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "medReq-apply",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/MedicationRequest-apply-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><a name=\"MedicationRequest_medReq-apply\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-MedicationRequest-apply-twpas.html\">事前審查品項-MedicationRequest Apply TWPAS</a></p></div><p><b>狀態</b>：On Hold</p><p><b>目的</b>：Plan</p><p><b>事前審查品項代碼</b>：Alunbrig film-coated tablets 30mgL<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> (<a href=\"CodeSystem-nhi-medication.html\">NHI-健保事前審查-用藥品項值集</a>#BC27730100)</span></p><p><b>病人</b>：<a href=\"Patient-pat-min.html\">Patient/pat-min</a> &quot;王大明&quot;</p><blockquote><p><b>事前審查藥物預定處方起始日期</b>：2024-01-01</p><p><b>事前審查藥物預定處方終止日期</b>：2024-02-11</p><p><b>事前審查藥品使用頻率及服用時間</b>：Every day at institution specified times.、飯前1小時使用<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> (<a href=\"ValueSet-medication-frequency-hl7-nhi.html\">HL7 TimingAbbreviation + 臺灣健保署藥品使用頻率值集</a>#BIW、#AC1H)</span></p><p><b>事前審查藥品每次處方劑量</b>：75 mg/m2</p><p><b>事前審查藥品療程／週期數</b>：42</p><p><b>給藥途徑／作用部位</b>：Oral use <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"http://snomed.info/sct/\">SNOMED CT + 臺灣健保署給藥途徑值集</a>#26643006)</span></p></blockquote><blockquote><p><b>事前審查藥物預定處方起始日期</b>：2024-02-12</p><p><b>事前審查藥物預定處方終止日期</b>：2024-03-10</p><p><b>事前審查藥品使用頻率及服用時間</b>：每4週的第1天、每4週的第2天、每4週的第3天、每4週的第4天、每4週的第5天、飯前1小時使用<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> (<a href=\"ValueSet-medication-frequency-hl7-nhi.html\">HL7 TimingAbbreviation + 臺灣健保署藥品使用頻率值集</a>#Q4WD1、#Q4WD2、#Q4WD3、#Q4WD4、#Q4WD5、#AC1H)</span></p><p><b>事前審查藥品每次處方劑量</b>：150 mg/m2</p><p><b>事前審查藥品療程／週期數</b>：1</p><p><b>給藥途徑／作用部位</b>：Oral use <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"http://snomed.info/sct/\">SNOMED CT + 臺灣健保署給藥途徑值集</a>#26643006)</span></p></blockquote></div>"
        },
        "status" : "on-hold",
        "intent" : "plan",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-medication",
              "code" : "BC27730100"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2024-01-01",
                  "end" : "2024-02-11"
                },
                "count" : 42
              },
              "code" : {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-GTSAbbreviation",
                    "code" : "QD"
                  },
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
                    "code" : "AC1H"
                  }
                ]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "26643006"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 75,
                  "system" : "http://unitsofmeasure.org",
                  "code" : "mg/m2"
                }
              }
            ]
          },
          {
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2024-02-12",
                  "end" : "2024-03-10"
                },
                "count" : 1
              },
              "code" : {
                "coding" : [
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
                    "code" : "Q4WD1"
                  },
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
                    "code" : "Q4WD2"
                  },
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
                    "code" : "Q4WD3"
                  },
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
                    "code" : "Q4WD4"
                  },
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
                    "code" : "Q4WD5"
                  },
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
                    "code" : "AC1H"
                  }
                ]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "26643006"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 150,
                  "system" : "http://unitsofmeasure.org",
                  "code" : "mg/m2"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/MedicationRequest/medReq-apply-2",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "medReq-apply-2",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/MedicationRequest-apply-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><a name=\"MedicationRequest_medReq-apply-2\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-MedicationRequest-apply-twpas.html\">事前審查品項-MedicationRequest Apply TWPAS</a></p></div><p><b>狀態</b>：On Hold</p><p><b>目的</b>：Plan</p><p><b>事前審查品項代碼</b>：Herzuma Inj. 440mg <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"CodeSystem-nhi-medication.html\">NHI-健保事前審查-用藥品項值集</a>#KC011162B5)</span></p><p><b>病人</b>：<a href=\"Patient-pat-min.html\">Patient/pat-min</a> &quot;王大明&quot;</p><p><b>事前審查藥物預定處方起始日期</b>：2024-03-11</p><p><b>事前審查藥物預定處方終止日期</b>：2024-07-28</p><p><b>事前審查藥品使用頻率及服用時間</b>：每4週的第1天、每4週的第2天、每4週的第3天、每4週的第4天、每4週的第5天、飯前1小時使用<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> (<a href=\"ValueSet-medication-frequency-hl7-nhi.html\">HL7 TimingAbbreviation + 臺灣健保署藥品使用頻率值集</a>#Q4WD1、#Q4WD2、#Q4WD3、#Q4WD4、#Q4WD5、#AC1H)</span></p><p><b>事前審查藥品每次處方劑量</b>：200 mg/m2</p><p><b>事前審查藥品療程／週期數</b>：1</p><p><b>給藥途徑／作用部位</b>：Oral use <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"http://snomed.info/sct/\">SNOMED CT + 臺灣健保署給藥途徑值集</a>#26643006)</span></p></div>"
        },
        "status" : "on-hold",
        "intent" : "plan",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-medication",
              "code" : "KC011162B5"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2024-03-11",
                  "end" : "2024-07-28"
                },
                "count" : 1
              },
              "code" : {
                "coding" : [
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
                    "code" : "Q4WD1"
                  },
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
                    "code" : "Q4WD2"
                  },
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
                    "code" : "Q4WD3"
                  },
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
                    "code" : "Q4WD4"
                  },
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
                    "code" : "Q4WD5"
                  },
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
                    "code" : "AC1H"
                  }
                ]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "26643006"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 200,
                  "system" : "http://unitsofmeasure.org",
                  "code" : "mg/m2"
                }
              }
            ]
          }
        ],
        "dispenseRequest" : {
          "quantity" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-orderableDrugForm"
          }
        }
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Coverage/cov-min",
      "resource" : {
        "resourceType" : "Coverage",
        "id" : "cov-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Coverage-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><a name=\"Coverage_cov-min\"> </a><p style=\"margin-bottom: 0px\">Profile：<a href=\"StructureDefinition-Coverage-twpas.html\">健保事前審查計畫-Coverage TWPAS</a></p></div><p><b>狀態</b>：active</p><p><b>受益人</b>：<a href=\"Patient-pat-min.html\">Patient/pat-min</a> &quot;王大明&quot;</p><p><b>保險人</b>：<a href=\"Organization-org-nhi.html\">Organization/org-nhi</a> &quot;衛生福利部中央健康保險署&quot;</p></div>"
        },
        "status" : "active",
        "beneficiary" : {
          "reference" : "Patient/pat-min"
        },
        "payor" : [
          {
            "reference" : "Organization/org-nhi"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/Organization/org-nhi",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "org-nhi",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-govt-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><a name=\"Organization_org-nhi\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://twcore.mohw.gov.tw/ig/twcore/0.3.2/StructureDefinition-Organization-govt-twcore.html\">臺灣核心-政府機構（TW Core Organization Government）</a></p></div><p><b>機構名稱</b>：衛生福利部中央健康保險署</p><p><b>識別碼型別</b>：Government Organization Identifier<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/v2-0203\">臺灣識別碼類型值集</a>#GOI）</span><br/><b>機關代號（official）</b>：A21030000I (https://oid.nat.gov.tw/)</p><p><b>機構種類</b>：Government <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://hl7.org/fhir/R4/codesystem-organization-type.html\">OrganizationType</a>#govt)</span></p></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/v2-0203",
                  "code" : "GOI"
                }
              ]
            },
            "system" : "https://oid.nat.gov.tw/",
            "value" : "A21030000I"
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
                "code" : "govt"
              }
            ]
          }
        ],
        "name" : "衛生福利部中央健康保險署"
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/DocumentReference/doc-medicalRecord-min",
      "resource" : {
        "resourceType" : "DocumentReference",
        "id" : "doc-medicalRecord-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DocumentReference-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4;\n        border-radius: 5px; line-height: 60%\"><a name=\"DocumentReference_doc-medicalRecord-min\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-DocumentReference-twpas.html\">文件參照-DocumentReference TWPAS</a></p></div><p><b>狀態</b>：current</p><p><b>報告類型</b>：病歷資料 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"CodeSystem-nhi-pdf-type.html\">NHI-文件類型</a>#medrec)</span></p><p><b>病人</b>：<a href=\"Patient-pat-min.html\">Patient/pat-min</a> &quot;王大明&quot;</p><p><b>病歷資料 (application/pdf)</b>：file://王大明病歷.pdf</p><p><b>病歷資料名稱</b>：王大明病歷</p></div>"
        },
        "status" : "current",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-pdf-type",
                "code" : "medrec"
              }
            ]
          }
        ],
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "content" : [
          {
            "attachment" : {
              "contentType" : "application/pdf",
              "url" : "file://王大明病歷.pdf",
              "title" : "王大明病歷"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://nhicore.nhi.gov.tw/pas/DocumentReference/doc-patientAssessment-min",
      "resource" : {
        "resourceType" : "DocumentReference",
        "id" : "doc-patientAssessment-min",
        "meta" : {
          "profile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DocumentReference-twpas"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4;\n        border-radius: 5px; line-height: 60%\"><a name=\"DocumentReference_doc-patientAssessment-min\"> </a><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-DocumentReference-twpas.html\">文件參照-DocumentReference TWPAS</a></p></div><p><b>狀態</b>：current</p><p><b>報告類型</b>：病人狀態評估報告 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"CodeSystem-nhi-pdf-type.html\">NHI-文件類型</a>#patientAssessment)</span></p><p><b>病人</b>：<a href=\"Patient-pat-min.html\">Patient/pat-min</a> &quot;王大明&quot;</p><p><b>病人狀態評估報告 (application/pdf)</b>：file://病人狀態評估報告.pdf</p><p><b>病人狀態評估報告名稱</b>：病人狀態評估報告名稱</p></div>"
        },
        "status" : "current",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-pdf-type",
                "code" : "patientAssessment"
              }
            ]
          }
        ],
        "subject" : {
          "reference" : "Patient/pat-min"
        },
        "content" : [
          {
            "attachment" : {
              "contentType" : "application/pdf",
              "url" : "file://病人狀態評估報告.pdf",
              "title" : "病人狀態評估報告名稱"
            }
          }
        ]
      }
    }
  ]
}

```
