# 專門術語 - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* **專門術語**

## 專門術語

這頁列出TWCI IG必須及可能需要使用的所有專門術語(terminology)

### 值集(Value Sets)

[SNOMEDCT-健保重大傷病-身體部位值集](ValueSet-body-site.md)

SNOMEDCT-健保重大傷病-身體部位值集，代碼對應請參考[臺灣健保署身體部位代碼對應SNOMED CT](https://build.fhir.org/ig/TWNHIFHIR/pas/ConceptMap-nhi-sct-body-site.html)。

[NHI-健保重大傷病-癌症期別值集](ValueSet-cancer-stage.md)

NHI-健保重大傷病-癌症期別值集

[NHI-健保重大傷病-臺灣健保署2023年中文版ICD 10 PCS-影像報告值集](ValueSet-icd-10-pcs-2023-image.md)

NHI-健保重大傷病-臺灣健保署2023年中文版ICD 10 PCS-影像報告值集

[LOINC-健保重大傷病-報告類型值集](ValueSet-loinc-report-type.md)

LOINC-健保重大傷病-報告類型值集

[HL7-健保重大傷病-非DICOM影像MimeType值集](ValueSet-media-mimetypes.md)

HL7-健保重大傷病-非DICOM影像MimeType值集

[NHI-健保重大傷病-申報方式值集](ValueSet-nhi-apply-mode.md)

NHI-健保重大傷病-申報方式值集

[NHI-健保重大傷病-申報類別值集](ValueSet-nhi-apply-type.md)

NHI-健保重大傷病-申報類別值集

[NHI-健保重大傷病-核定結果值集](ValueSet-nhi-approve-result.md)

NHI-健保重大傷病-核定結果值集

[NHI-健保重大傷病-後續治療計劃值集](ValueSet-nhi-cancer-treatment-plan.md)

NHI-健保重大傷病-後續治療計劃值集

[NHI-健保重大傷病-後續治療評估值集](ValueSet-nhi-cancer-treatment.md)

NHI-健保重大傷病-後續治療評估值集

[NHI-健保重大傷病-癌症狀態](ValueSet-nhi-cancerstage-status.md)

NHI-健保重大傷病-癌症狀態

[NHI-健保重大傷病-癌症最初診斷AJCC分期值集](ValueSet-nhi-cancerstaging.md)

NHI-健保重大傷病-癌症最初診斷AJCC分期值集

[NHI-健保重大傷病-重大傷病類別值集](ValueSet-nhi-category.md)

NHI-健保重大傷病-重大傷病類別值集

[NHI-健保重大傷病-ICD-CM-重大傷病診斷代碼值集](ValueSet-nhi-diag-code-icd.md)

NHI-健保重大傷病-ICD-CM-重大傷病診斷代碼值集

[NHI-健保重大傷病-特約醫事機構值集](ValueSet-nhi-organization.md)

NHI-健保重大傷病-特約醫事機構值集，參照至[衛福部健保署特約醫事機構代碼網路查詢服務](https://www.nhi.gov.tw/ch/cp-5548-135e8-2931-1.html)中的[健保特約醫療院所名冊](https://info.nhi.gov.tw/IODE0000/IODE0000S09?id=1120)

代碼出版日期：2024-04-22；資料所屬單位：衛生福利部中央健康保險署。

**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。**

[NHI-健保重大傷病-ICD-CM-原發癌症診斷碼值集](ValueSet-nhi-primary-cancer-icd.md)

NHI-健保重大傷病-ICD-CM-原發癌症診斷碼值集

### 代碼系統(Code Systems)

[NHI-健保重大傷病-癌症期別](CodeSystem-cancer-stage.md)

臺灣衛生福利部中央健康保險署「癌症期別」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保重大傷病-申報方式](CodeSystem-nhi-apply-mode.md)

臺灣衛生福利部中央健康保險署「申報方式」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保重大傷病-申報類別](CodeSystem-nhi-apply-type.md)

臺灣衛生福利部中央健康保險署「申報類別」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保重大傷病-核定結果](CodeSystem-nhi-approve-result.md)

臺灣衛生福利部中央健康保險署「核定結果」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保重大傷病-後續治療計劃](CodeSystem-nhi-cancer-treatment-plan.md)

臺灣衛生福利部中央健康保險署「後續治療計劃」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。
 參照自[重大傷病專區](https://www.nhi.gov.tw/ch/np-2957-1.html)中申請須知及文件下載的[惡性腫瘤重大傷病證明換發評估表(自105年1月1日適用)(104.12.22更新)](https://www.nhi.gov.tw/ch/dl-30060-83fc8c0cada24dae8f3c5d5a98201aee-1.odt)

[NHI-健保重大傷病-後續治療評估](CodeSystem-nhi-cancer-treatment.md)

臺灣衛生福利部中央健康保險署「後續治療評估」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。
 參照自[重大傷病專區](https://www.nhi.gov.tw/ch/np-2957-1.html)中申請須知及文件下載的[惡性腫瘤重大傷病證明換發評估表(自105年1月1日適用)(104.12.22更新)](https://www.nhi.gov.tw/ch/dl-30060-83fc8c0cada24dae8f3c5d5a98201aee-1.odt)

[NHI-健保重大傷病-癌症狀態](CodeSystem-nhi-cancerstage-status.md)

臺灣衛生福利部中央健康保險署「癌症狀態」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保重大傷病-癌症最初診斷AJCC分期](CodeSystem-nhi-cancerstaging.md)

臺灣衛生福利部中央健康保險署「癌症最初診斷AJCC分期」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保重大傷病-重大傷病類別](CodeSystem-nhi-category.md)

臺灣衛生福利部中央健康保險署「重大傷病類別」代碼，代碼出版日期：2024-09-20；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保重大傷病-特約醫事機構](CodeSystem-organization-identifier-tw.md)

臺灣衛生福利部中央健康保險署「特約醫事機構」代碼，參照至[衛福部健保署特約醫事機構代碼網路查詢服務](https://www.nhi.gov.tw/ch/cp-5548-135e8-2931-1.html)中的[健保特約醫療院所名冊](https://info.nhi.gov.tw/IODE0000/IODE0000S09?id=1120)

代碼出版日期：2024-04-22；資料所屬單位：衛生福利部中央健康保險署。

**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。**

