# 查詢參數 - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* **查詢參數**

## 查詢參數

以下為本IG使用到的所有查詢參數(SearchParameter)。

### 對外服務之API

#### 以Profile分類

##### Task

* [period](SearchParameter-Task-period.md)
* [patient](SearchParameter-Task-patient.md)
* [authored-on](SearchParameter-Task-authored-on.md)
* [modified](SearchParameter-Task-modified.md)
* [identifier](SearchParameter-Task-identifier.md)
* [status](SearchParameter-Task-status.md)

##### Patient

* [name](SearchParameter-Patient-name.md)
* [identifier](SearchParameter-Patient-identifier.md)

#### 以查詢欄位分類

##### 病人身分證號：Task.patient.identifier

`GET [base]/Task?patient.identifier=[身分證號]`
 例子：
 (1) GET [base]/Task?patient.identifier=A123456789

##### 病人姓名：Task.patient.name

`GET [base]/Task?patient.name=[姓名]`
 例子：
 (1) GET [base]/Task?patient.name=A123456789

##### 受理日期：Task.period

`GET [base]/Task?period={gt|lt|ge|le}[受理日期]{&period={gt|lt|ge|le}[受理日期]}`
 例子：
 (1) GET [base]/Task?period=gt2025-11-07&period=lt2025-01-07

##### 核定日期：Task.modified

`GET [base]/Task?modified={gt|lt|ge|le}[核定日期]{&modified={gt|lt|ge|le}[核定日期]}`
 例子：
 (1) GET [base]/Task?modified=gt2025-01-05&modified=lt2025-01-07

##### 受理編號：Task.identifier

`GET [base]/Task?identifier=[受理編號]`
 例子：
 (1) GET [base]/Task?identifier=20241231010109051701

##### 收件日期：Task.authored-on

`GET [base]/Task?authored-on={gt|lt|ge|le}[收件日期]{&authored-on={gt|lt|ge|le}[收件日期]}`
 例子：
 (1) GET [base]/Task?authored-on=gt2025-11-07&authored-on=lt2025-01-07

##### 查詢進度：Task.status

`GET [base]/Task?status=[查詢進度]`
 例子：
 (1) GET [base]/Task?status=completed

### 未對外服務之API

#### Bundle

* [_id](SearchParameter-Bundle-id.md)

