# 應用說明 - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* **應用說明**

## 應用說明

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/ci/ImplementationGuide/tw.gov.mohw.nhi.ci | *Version*:1.0.2 |
| Active as of 2025-11-12 | *Computable Name*:TWCI |

**請注意**：您目前所看到的IG為持續建置(ci-build)版，主要依據實作者及健保署端的業務需求即時調整V1.0.1版內容，因而會比健保署的IG版本V1.0.1(https://nhicore.nhi.gov.tw/ci/)內容新，僅供未來想以最新版本規格進行資料上傳的人員參考，下次更新版本號時間未定，屆時才會調整相應版本的健保署FHIR伺服器規格。
 
 **醫院實作時請以V1.0.1為主進行實例驗證，目前健保署端的伺服器採用V1.0.1版規格。**

**相關資訊可參考衛生福利部中央健康保險署的[癌症重大傷病申請導入FHIR](https://www.nhi.gov.tw/ch/np-3788-1.html)。**

因考量實作需求，於2025/11/12異動以下內容：
1. 新增[Example Task: 重大傷病申請-無換發評估表](Task-tas-noillness.md)並修改[Example Bundle: 重大傷病申請證明-無換發評估表](Bundle-bun-noillness.md)。
請留意這些異動，以避免影響您的實作。

### 專案介紹

臺灣健保重大傷病實作指引(Taiwan NHI Catastrophic Illness Implementation Guide，TWCI IG)採用HL7® FHIR® standard（Fast Healthcare Interoperability Resources）IG建置方法，在[FHIR R4.0.1](http://hl7.org/fhir/R4/)之標準基礎上，繼承TW Core IG V0.3.2 (2024-12-12)，進一步定義適用於「重大傷病」資料需求的Resources（類似資料表）、其中的資料項目（意即欄位）、基數（意即0..1、0..*、1..1或1..*）及資料類型（文字、日期時間、代碼等）等。

### 專案背景

衛生福利部中央健康保險署規劃癌症重大傷病上傳機制，係配合賴總統於健康台灣之「國家癌症防治計畫」政策，刻正規劃NGS申報資料收載、癌症重大傷病申請、癌藥事前審查申請及癌症個案療效追蹤等癌症醫療資訊之數位轉型，期透過資料有效互通，達成以病人為中心之完整照護。

### 專案範圍

#### 使用案例(Use Case)

本專案之主要實作者為醫院，醫院透過此系統，協助保險對象申請重大傷病，透過共通傳輸平台批次上傳重大傷病申請證明書相關文件，並送至衛生福利部中央健康保險署審核。

#### 循序圖

送核、送核補件、申復及申復補件之作業流程皆相同，依該個案是首次送審或不同意後再次送審等之狀態進行選擇不同的申請類別，以做為行政程序之判斷。

送核、送核補件、申復及申復補件作業流程如下：

1. 醫院開發重大傷病系統產生重大傷病申請證明（Bundle TWCI）
1. 醫院將已產生之重大傷病申請證明相關文件上傳至健保署
1. 若資料符合格式，健保署回覆上傳成功訊息，由醫院查詢上傳結果
1. 若資料不符合格式，健保署回覆上傳失敗訊息，由醫院查詢上傳結果
1. 資料上傳成功後，健保署申請證明通過，由醫院查詢申請結果
1. 資料上傳成功後，健保署申請證明未通過，由醫院查詢申請結果![](sequence.png)

### 如何閱讀這個實作指引(IG)

TWCI IG之網站架構圖如下圖所示。各功能說明如下：

* **[應用說明](index.md)**：TWCI IG介紹及背景說明。
* **[視覺化邏輯模型](vision.md)**：TWCI IG邏輯模型架構視覺化圖。
* **[規範文件](artifacts.md)** 
* **[能力聲明](capabilitystatements.md)**：應用TWCI IG於建置業務目的使用的FHIR Server時，該FHIR Server必須及建議應該支援的資料存取功能。 
* **[邏輯模型](models.md)**：TWCI IG的所有邏輯模型(Logical Models)，邏輯模型會定義相應情境下使用的所有資料欄位。為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」瞭解各資料欄位實際使用TWCI IG的哪個Profiles的哪個資料項目(element)。 
* **[FHIR Profiles](profiles.md)**： 
* TWCI IG的所有Profiles之定義與範例。
* 各資料項目不同實作強制程度的Terminology。
 
* **[專門術語](terminologies.md)**：TWCI IG所使用的專門術語，包括代碼系統（Code Systems）及值集（Value Sets）。 
 
* **[範例](examples.md)**：TWCI IG所定義Profiles之範例檔。
* **[定義與範例檔下載](downloads.md)**：實作者若不偏好使用FHIR RESTful API驗證資料是否符合Profiles，可直接下載所需的格式驗證檔，包括XML、JSON及Turtle三種格式，亦可於此下載完整範例檔。
* **[安全性](security.md)**：主要說明採用TWCI IG網站進行實作時，有關資料存取授權的作法。
* **[版本異動](https://vacc.cdc.gov.tw/vacc/history.html)**：若TWCI IG網站的版本有所異動，皆可透過[異動說明頁](https://vacc.cdc.gov.tw/vacc/history.html)得以瞭解版本間的異動差異。

### 作者與貢獻者

| | | |
| :--- | :--- | :--- |
| 作者-IG | 李麗惠 | 國立臺北護理健康大學-健康事業管理系 |
| 作者-IG | 曾鈺珈 | |
| 作者-IG | 黃甄翔 | |
| 貢獻者-IG | 王智廣 | 衛生福利部中央健康保險署-醫務管理組 |
| 貢獻者-IG | 宋怡慧 | |
| 貢獻者-IG | 衛生福利部中央健康保險署-資訊組 | |
| 貢獻者-IG | 衛生福利部資訊處 | |

如醫院有參與意願申請加入癌症重大傷病導入FHIR試辦院所，或對資料內容、代碼檔、IG有任何疑問，

請先洽(02)2706-5866#2610 宋小姐

*若民眾對事前審查案申請案件有疑義，請洽各分區業務組。



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "tw.gov.mohw.nhi.ci",
  "url" : "https://nhicore.nhi.gov.tw/ci/ImplementationGuide/tw.gov.mohw.nhi.ci",
  "version" : "1.0.2",
  "name" : "TWCI",
  "title" : "臺灣重大傷病實作指引",
  "status" : "active",
  "date" : "2025-11-12T05:05:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣重大傷病實作指引(Taiwan NHI Catastrophic Illness Implementation Guide，TWCI IG)",
  "packageId" : "tw.gov.mohw.nhi.ci",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "6.5.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "TWCore",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore/ImplementationGuide/tw.gov.mohw.twcore",
      "packageId" : "tw.gov.mohw.twcore",
      "version" : "0.3.2"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2024+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://nhicore.nhi.gov.tw/ci/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2024+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://nhicore.nhi.gov.tw/ci/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Bundle-id"
        },
        "name" : "Bundle-id",
        "description" : "重大傷病申請證明(Bundle)的邏輯性ID",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/media-mimetypes"
        },
        "name" : "HL7-健保重大傷病-非DICOM影像MimeType值集",
        "description" : "HL7-健保重大傷病-非DICOM影像MimeType值集",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/loinc-report-type"
        },
        "name" : "LOINC-健保重大傷病-報告類型值集",
        "description" : "LOINC-健保重大傷病-報告類型值集",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/nhi-primary-cancer-icd"
        },
        "name" : "NHI-健保重大傷病-ICD-CM-原發癌症診斷碼值集",
        "description" : "NHI-健保重大傷病-ICD-CM-原發癌症診斷碼值集",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/nhi-diag-code-icd"
        },
        "name" : "NHI-健保重大傷病-ICD-CM-重大傷病診斷代碼值集",
        "description" : "NHI-健保重大傷病-ICD-CM-重大傷病診斷代碼值集",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/nhi-cancer-treatment-plan"
        },
        "name" : "NHI-健保重大傷病-後續治療計劃",
        "description" : "臺灣衛生福利部中央健康保險署「後續治療計劃」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。  \n參照自[重大傷病專區](https://www.nhi.gov.tw/ch/np-2957-1.html)中申請須知及文件下載的[惡性腫瘤重大傷病證明換發評估表(自105年1月1日適用)(104.12.22更新)](https://www.nhi.gov.tw/ch/dl-30060-83fc8c0cada24dae8f3c5d5a98201aee-1.odt)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/nhi-cancer-treatment-plan"
        },
        "name" : "NHI-健保重大傷病-後續治療計劃值集",
        "description" : "NHI-健保重大傷病-後續治療計劃值集",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/nhi-cancer-treatment"
        },
        "name" : "NHI-健保重大傷病-後續治療評估",
        "description" : "臺灣衛生福利部中央健康保險署「後續治療評估」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。  \n參照自[重大傷病專區](https://www.nhi.gov.tw/ch/np-2957-1.html)中申請須知及文件下載的[惡性腫瘤重大傷病證明換發評估表(自105年1月1日適用)(104.12.22更新)](https://www.nhi.gov.tw/ch/dl-30060-83fc8c0cada24dae8f3c5d5a98201aee-1.odt)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/nhi-cancer-treatment"
        },
        "name" : "NHI-健保重大傷病-後續治療評估值集",
        "description" : "NHI-健保重大傷病-後續治療評估值集",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/nhi-approve-result"
        },
        "name" : "NHI-健保重大傷病-核定結果",
        "description" : "臺灣衛生福利部中央健康保險署「核定結果」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/nhi-approve-result"
        },
        "name" : "NHI-健保重大傷病-核定結果值集",
        "description" : "NHI-健保重大傷病-核定結果值集",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/organization-identifier-tw"
        },
        "name" : "NHI-健保重大傷病-特約醫事機構",
        "description" : "臺灣衛生福利部中央健康保險署「特約醫事機構」代碼，參照至[衛福部健保署特約醫事機構代碼網路查詢服務](https://www.nhi.gov.tw/ch/cp-5548-135e8-2931-1.html)中的[健保特約醫療院所名冊](https://info.nhi.gov.tw/IODE0000/IODE0000S09?id=1120)\n\n代碼出版日期：2024-04-22；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/nhi-organization"
        },
        "name" : "NHI-健保重大傷病-特約醫事機構值集",
        "description" : "NHI-健保重大傷病-特約醫事機構值集，參照至[衛福部健保署特約醫事機構代碼網路查詢服務](https://www.nhi.gov.tw/ch/cp-5548-135e8-2931-1.html)中的[健保特約醫療院所名冊](https://info.nhi.gov.tw/IODE0000/IODE0000S09?id=1120)\n\n代碼出版日期：2024-04-22；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/nhi-apply-mode"
        },
        "name" : "NHI-健保重大傷病-申報方式",
        "description" : "臺灣衛生福利部中央健康保險署「申報方式」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/nhi-apply-mode"
        },
        "name" : "NHI-健保重大傷病-申報方式值集",
        "description" : "NHI-健保重大傷病-申報方式值集",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/nhi-apply-type"
        },
        "name" : "NHI-健保重大傷病-申報類別",
        "description" : "臺灣衛生福利部中央健康保險署「申報類別」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/nhi-apply-type"
        },
        "name" : "NHI-健保重大傷病-申報類別值集",
        "description" : "NHI-健保重大傷病-申報類別值集",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/nhi-cancerstaging"
        },
        "name" : "NHI-健保重大傷病-癌症最初診斷AJCC分期",
        "description" : "臺灣衛生福利部中央健康保險署「癌症最初診斷AJCC分期」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/nhi-cancerstaging"
        },
        "name" : "NHI-健保重大傷病-癌症最初診斷AJCC分期值集",
        "description" : "NHI-健保重大傷病-癌症最初診斷AJCC分期值集",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cancer-stage"
        },
        "name" : "NHI-健保重大傷病-癌症期別",
        "description" : "臺灣衛生福利部中央健康保險署「癌症期別」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cancer-stage"
        },
        "name" : "NHI-健保重大傷病-癌症期別值集",
        "description" : "NHI-健保重大傷病-癌症期別值集",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/nhi-cancerstage-status"
        },
        "name" : "NHI-健保重大傷病-癌症狀態",
        "description" : "NHI-健保重大傷病-癌症狀態",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/nhi-cancerstage-status"
        },
        "name" : "NHI-健保重大傷病-癌症狀態",
        "description" : "臺灣衛生福利部中央健康保險署「癌症狀態」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/icd-10-pcs-2023-image"
        },
        "name" : "NHI-健保重大傷病-臺灣健保署2023年中文版ICD 10 PCS-影像報告值集",
        "description" : "NHI-健保重大傷病-臺灣健保署2023年中文版ICD 10 PCS-影像報告值集",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/nhi-category"
        },
        "name" : "NHI-健保重大傷病-重大傷病類別",
        "description" : "臺灣衛生福利部中央健康保險署「重大傷病類別」代碼，代碼出版日期：2024-09-20；資料所屬單位：臺灣衛生福利部中央健康保險署。",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/nhi-category"
        },
        "name" : "NHI-健保重大傷病-重大傷病類別值集",
        "description" : "NHI-健保重大傷病-重大傷病類別值集",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Patient-identifier"
        },
        "name" : "Patient-identifier",
        "description" : "病人的身分證號(identifier)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Patient-name"
        },
        "name" : "Patient-name",
        "description" : "病人的姓名(name)，該查詢可能與 HumanName 中的任何字串匹配，包括完整的中文姓名(text)、英文姓(family)、英文名(given)、姓名前面的頭銜(prefix)、姓名後面的稱謂(suffix)。",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/body-site"
        },
        "name" : "SNOMEDCT-健保重大傷病-身體部位值集",
        "description" : "SNOMEDCT-健保重大傷病-身體部位值集，代碼對應請參考[臺灣健保署身體部位代碼對應SNOMED CT](https://build.fhir.org/ig/TWNHIFHIR/pas/ConceptMap-nhi-sct-body-site.html)。",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Task-authored-on"
        },
        "name" : "Task-authored-on",
        "description" : "重大傷病申請(Task)的收件日期(authoredOn)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Task-identifier"
        },
        "name" : "Task-identifier",
        "description" : "重大傷病申請(Task)的核定日期(identifier)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Task-modified"
        },
        "name" : "Task-modified",
        "description" : "重大傷病申請(Task)的核定日期(lastModified)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Task-patient"
        },
        "name" : "Task-patient",
        "description" : "重大傷病申請(Task)的對象(patient)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Task-period"
        },
        "name" : "Task-period",
        "description" : "重大傷病申請(Task)的受理日期(executionPeriod)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Task-status"
        },
        "name" : "Task-status",
        "description" : "重大傷病申請(Task)的查詢進度(status)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ApplyModel"
        },
        "name" : "申請(Apply)重大傷病申請書之資料模型",
        "description" : "申請(Apply)重大傷病之資料模型，此邏輯模型為定義重大傷病情境下使用的所有資料欄位。\n為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」\n瞭解各資料欄位實際使用TWCI IG的哪個Profiles的哪個資料項目（element）。亦可配合\n[視覺化邏輯模型圖]進行欄位對應。",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/pat-min"
        },
        "name" : "病人資訊",
        "description" : "依據病人資訊-Patient TWCI Profile呈現病人基本資料之範例",
        "exampleCanonical" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Patient-twci"
        },
        "name" : "病人資訊-Patient TWCI",
        "description" : "此病人資訊-Patient TWCI Profile說明TWCI IG如何進一步定義臺灣核心-病人(TW Core Patient) Profile以呈現重大傷病之病人基本資料",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/CapabilityStatementTWCIServer"
        },
        "name" : "臺灣重大傷病-伺服端(TWCI Server)",
        "description" : "臺灣健保重大傷病實作指引(TWCI IG)伺服端(Server)之能力聲明",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/CapabilityStatementTWCIClient"
        },
        "name" : "臺灣重大傷病-用戶端(TWCI Client)",
        "description" : "臺灣健保重大傷病實作指引(TWCI IG)用戶端(Client)之能力聲明",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/con-min"
        },
        "name" : "重大傷病",
        "description" : "依據重大傷病-Condition TWCI Profile呈現重大傷病之範例",
        "exampleCanonical" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Condition-twci"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Condition-twci"
        },
        "name" : "重大傷病-Condition TWCI",
        "description" : "此重大傷病-Condition TWCI Profile說明TWCI IG如何進一步定義臺灣核心-病情、問題或診斷（TW Core Condition） Profile以呈現重大傷病之內容",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/tas-min"
        },
        "name" : "重大傷病申請",
        "description" : "依據重大傷病申請-Task TWCI Profile呈現重大傷病申請之範例",
        "exampleCanonical" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Task-twci"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Task-twci"
        },
        "name" : "重大傷病申請-Task TWCI",
        "description" : "此重大傷病申請-Task TWCI Profile說明TWCI IG如何進一步定義FHIR的Task Resource以呈現重大傷病申請之內容",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/tas-noillness"
        },
        "name" : "重大傷病申請-無換發評估表",
        "description" : "依據重大傷病申請-Task TWCI Profile呈現重大傷病申請-無換發評估表之範例",
        "exampleCanonical" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Task-twci"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Questionnaire"
          }
        ],
        "reference" : {
          "reference" : "Questionnaire/apply-catastrophic-illness"
        },
        "name" : "重大傷病申請書",
        "description" : "依據重大傷病申請書-Questionnaire TWCI Profile呈現重大傷病申請書之範例",
        "exampleCanonical" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Questionnaire-twci"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Questionnaire-twci"
        },
        "name" : "重大傷病申請書-Questionnaire TWCI",
        "description" : "此重大傷病申請書-Questionnaire TWCI Profile說明TWCI IG如何進一步定義FHIR的Questionnaire Resource以呈現重大傷病申請書中之內容",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "QuestionnaireResponse"
          }
        ],
        "reference" : {
          "reference" : "QuestionnaireResponse/queRes-min"
        },
        "name" : "重大傷病申請書回覆",
        "description" : "依據重大傷病申請書回覆-QuestionnaireResponse TWCI Profile呈現重大傷病申請書回覆之範例",
        "exampleCanonical" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "QuestionnaireResponse"
          }
        ],
        "reference" : {
          "reference" : "QuestionnaireResponse/queRes-noillness"
        },
        "name" : "重大傷病申請書回覆(無換發評估表、多筆檢查報告)",
        "description" : "依據重大傷病申請書回覆-QuestionnaireResponse TWCI Profile呈現重大傷病申請書回覆(無換發評估表、多筆檢查報告)之範例",
        "exampleCanonical" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/QuestionnaireResponse-twci"
        },
        "name" : "重大傷病申請書回覆-QuestionnaireResponse TWCI",
        "description" : "此重大傷病申請書回覆-QuestionnaireResponse TWCI Profile說明TWCI IG如何進一步定義FHIR的QuestionnaireResponse Resource以呈現重大傷病申請書回覆中之內容",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Bundle-twci"
        },
        "name" : "重大傷病申請證明-Bundle TWCI",
        "description" : "此重大傷病申請證明-Bundle TWCI Profile說明TWCI IG如何進一步定義臺灣核心-資料交換基本單位（TW Core Bundle） Profile以呈現重大傷病申請證明之內容",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bun-noillness"
        },
        "name" : "重大傷病申請證明-無換發評估表",
        "description" : "依據重大傷病申請證明-Bundle TWCI Profile呈現重大傷病申請證明-無換發評估表之範例",
        "exampleCanonical" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Bundle-twci"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bun-min"
        },
        "name" : "重大傷病申請證明-送核",
        "description" : "依據重大傷病申請證明-Bundle TWCI Profile呈現重大傷病申請證明之範例",
        "exampleCanonical" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Bundle-twci"
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "應用說明",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "capabilitystatements.html"
            }
          ],
          "nameUrl" : "capabilitystatements.html",
          "title" : "能力聲明",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "searchparameters.html"
            }
          ],
          "nameUrl" : "searchparameters.html",
          "title" : "查詢參數",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "models.html"
            }
          ],
          "nameUrl" : "models.html",
          "title" : "邏輯模型",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "profiles.html"
            }
          ],
          "nameUrl" : "profiles.html",
          "title" : "FHIR Profiles",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "terminologies.html"
            }
          ],
          "nameUrl" : "terminologies.html",
          "title" : "專門術語",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples.html"
            }
          ],
          "nameUrl" : "examples.html",
          "title" : "範例",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "結構定義與範例檔下載",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "security.html"
            }
          ],
          "nameUrl" : "security.html",
          "title" : "安全性",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "ImplementationGuide-tw.gov.mohw.nhi.ci.html"
            }
          ],
          "nameUrl" : "ImplementationGuide-tw.gov.mohw.nhi.ci.html",
          "title" : "TWCI ImplementationGuide Resource",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "vision.html"
            }
          ],
          "nameUrl" : "vision.html",
          "title" : "視覺化邏輯模型",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "validate.html"
            }
          ],
          "nameUrl" : "validate.html",
          "title" : "驗證教學",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
