# 重大傷病申請-Task TWCI - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **重大傷病申請-Task TWCI**

## Resource Profile: 重大傷病申請-Task TWCI 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/ci/StructureDefinition/Task-twci | *Version*:1.0.2 |
| Active as of 2025-11-12 | *Computable Name*:TaskTWCI |

 
此重大傷病申請-Task TWCI Profile說明TWCI IG如何進一步定義FHIR的Task Resource以呈現重大傷病申請之內容 

**Usages:**

* Use this Profile: [重大傷病申請證明-Bundle TWCI](StructureDefinition-Bundle-twci.md)
* Examples for this Profile: [Task/tas-min](Task-tas-min.md) and [Task/tas-noillness](Task-tas-noillness.md)
* CapabilityStatements using this Profile: [臺灣重大傷病-用戶端(TWCI Client)](CapabilityStatement-CapabilityStatementTWCIClient.md) and [臺灣重大傷病-伺服端(TWCI Server)](CapabilityStatement-CapabilityStatementTWCIServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.ci|current/StructureDefinition/Task-twci)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Task-twci.csv), [Excel](StructureDefinition-Task-twci.xlsx), [Schematron](StructureDefinition-Task-twci.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TWCI支援的RESTful互動功能的完整清單，請參閱[TWCI Server能力聲明](CapabilityStatement-CapabilityStatementTWCIServer.md)。

#### 必須支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Task-patient.md)**.**[`identifier`](SearchParameter-Patient-identifier.md)**查詢所有Task：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Task?patient.identifier=[code]`例子：
(1) GET [base]/Task?patient.identifier=A123456789
1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Task-patient.md)**.**[`name`](SearchParameter-Patient-name.md)**查詢所有Task：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過string查詢](http://hl7.org/fhir/R4/search.html#string))
`GET [base]/Task?patient.name=[string]`例子：
(1) GET [base]/Task?patient.name=王大明
1. **必須（SHALL）**支援透過查詢參數**[`period`](SearchParameter-Task-period.md)**查詢所有Task：
([如何透過date查詢](https://hl7.org/fhir/R4/search.html#date))
`GET [base]/Task?period={gt|lt|ge|le}[date]{&period={gt|lt|ge|le}[date]}`例子：
(1) GET [base]/Task?period=gt2025-11-07&period=lt2025-01-07
1. **必須（SHALL）**支援透過查詢參數**[`modified`](SearchParameter-Task-modified.md)**查詢所有Task：
([如何透過date查詢](https://hl7.org/fhir/R4/search.html#date))
`GET [base]/Task?modified={gt|lt|ge|le}[date]{&modified={gt|lt|ge|le}[date]}`例子：
(1) GET [base]/Task?modified=gt2025-01-05&modified=lt2025-01-07
1. **必須（SHALL）**支援透過查詢參數**[`identifier`](SearchParameter-Task-identifier.md)**查詢所有Task：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Task?identifier=[code]`例子：
(1) GET [base]/Task?identifier=20241231010109051701
1. **必須（SHALL）**支援透過查詢參數**[`authored-on`](SearchParameter-Task-authored-on.md)**查詢所有Task：
([如何透過date查詢](https://hl7.org/fhir/R4/search.html#date))
`GET [base]/Task?authored-on={gt|lt|ge|le}[date]{&authored-on={gt|lt|ge|le}[date]}`例子：
(1) GET [base]/Task?authored-on=gt2025-11-07&authored-on=lt2025-01-07
1. **必須（SHALL）**支援透過查詢參數**[`status`](SearchParameter-Task-status.md)**查詢所有Task：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Task?status=[code]`例子：
(1) GET [base]/Task?status=completed



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Task-twci",
  "url" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Task-twci",
  "version" : "1.0.2",
  "name" : "TaskTWCI",
  "title" : "重大傷病申請-Task TWCI",
  "status" : "active",
  "date" : "2025-11-12T05:05:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此重大傷病申請-Task TWCI Profile說明TWCI IG如何進一步定義FHIR的Task Resource以呈現重大傷病申請之內容",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Task",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Task",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Task.identifier",
        "path" : "Task.identifier",
        "short" : "受理編號（上傳時不須填寫，由健保署端收件後填寫。）"
      },
      {
        "id" : "Task.basedOn",
        "path" : "Task.basedOn",
        "short" : "重大傷病(Condition)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Condition-twci"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.status",
        "path" : "Task.status",
        "short" : "查詢進度。上傳時請固定填requested。送審:requested | 審結:completed | 核定同意:accepted | 核定不同意:rejected | 退件:failed | 補件:on-hold",
        "patternCode" : "requested",
        "mustSupport" : true
      },
      {
        "id" : "Task.businessStatus",
        "path" : "Task.businessStatus",
        "short" : "核定結果（上傳時不須填寫，由健保署端收件後填寫。）",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-approve-result"
        }
      },
      {
        "id" : "Task.intent",
        "path" : "Task.intent",
        "short" : "【因FHIR設計而需必填】上傳時請固定填order。unknown | proposal | plan | order | original-order | reflex-order | filler-order | instance-order | option",
        "patternCode" : "order"
      },
      {
        "id" : "Task.focus",
        "path" : "Task.focus",
        "short" : "重大傷病申請書回覆(QuestionnaireResponse)",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.for",
        "path" : "Task.for",
        "short" : "病人資訊(Patient)",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.executionPeriod",
        "path" : "Task.executionPeriod",
        "short" : "受理日期（上傳時不須填寫，由健保署端收件後填寫。）",
        "mustSupport" : true
      },
      {
        "id" : "Task.authoredOn",
        "path" : "Task.authoredOn",
        "short" : "收件日期（上傳時不須填寫，由健保署端收件後填寫。）",
        "mustSupport" : true
      }
    ]
  }
}

```
