# 重大傷病申請書回覆-QuestionnaireResponse TWCI - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **重大傷病申請書回覆-QuestionnaireResponse TWCI**

## Resource Profile: 重大傷病申請書回覆-QuestionnaireResponse TWCI 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci | *Version*:1.0.2 |
| Active as of 2025-11-12 | *Computable Name*:QuestionnaireResponseTWCI |

 
此重大傷病申請書回覆-QuestionnaireResponse TWCI Profile說明TWCI IG如何進一步定義FHIR的QuestionnaireResponse Resource以呈現重大傷病申請書回覆中之內容 

**Usages:**

* Use this Profile: [重大傷病申請證明-Bundle TWCI](StructureDefinition-Bundle-twci.md)
* Refer to this Profile: [重大傷病申請-Task TWCI](StructureDefinition-Task-twci.md)
* Examples for this Profile: [QuestionnaireResponse/queRes-min](QuestionnaireResponse-queRes-min.md) and [QuestionnaireResponse/queRes-noillness](QuestionnaireResponse-queRes-noillness.md)
* CapabilityStatements using this Profile: [臺灣重大傷病-用戶端(TWCI Client)](CapabilityStatement-CapabilityStatementTWCIClient.md) and [臺灣重大傷病-伺服端(TWCI Server)](CapabilityStatement-CapabilityStatementTWCIServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.ci|current/StructureDefinition/QuestionnaireResponse-twci)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-QuestionnaireResponse-twci.csv), [Excel](StructureDefinition-QuestionnaireResponse-twci.xlsx), [Schematron](StructureDefinition-QuestionnaireResponse-twci.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "QuestionnaireResponse-twci",
  "url" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci",
  "version" : "1.0.2",
  "name" : "QuestionnaireResponseTWCI",
  "title" : "重大傷病申請書回覆-QuestionnaireResponse TWCI",
  "status" : "active",
  "date" : "2025-11-12T05:05:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此重大傷病申請書回覆-QuestionnaireResponse TWCI Profile說明TWCI IG如何進一步定義FHIR的QuestionnaireResponse Resource以呈現重大傷病申請書回覆中之內容",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "QuestionnaireResponse",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "QuestionnaireResponse.questionnaire",
        "path" : "QuestionnaireResponse.questionnaire",
        "min" : 1,
        "type" : [
          {
            "code" : "canonical",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Questionnaire-twci"
            ]
          }
        ],
        "patternCanonical" : "https://nhicore.nhi.gov.tw/ci/Questionnaire/apply-catastrophic-illness",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.status",
        "path" : "QuestionnaireResponse.status",
        "patternCode" : "completed"
      },
      {
        "id" : "QuestionnaireResponse.item",
        "path" : "QuestionnaireResponse.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 6,
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item.linkId",
        "path" : "QuestionnaireResponse.item.linkId",
        "short" : "問卷題目編號"
      },
      {
        "id" : "QuestionnaireResponse.item:hosp",
        "path" : "QuestionnaireResponse.item",
        "sliceName" : "hosp",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.linkId",
        "path" : "QuestionnaireResponse.item.linkId",
        "patternString" : "1"
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.text",
        "path" : "QuestionnaireResponse.item.text",
        "patternString" : "hosp|院所資訊"
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item",
        "path" : "QuestionnaireResponse.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 5,
        "max" : "7"
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:applMode",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "applMode",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:applMode.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "1.1"
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:applMode.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "hosp.applMode|申報方式"
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:applMode.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:applMode.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:applMode.answer.value[x]:valueCoding",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "sliceName" : "valueCoding",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "patternCoding" : {
          "system" : "https://nhicore.nhi.gov.tw/ci/CodeSystem/nhi-apply-mode",
          "code" : "2"
        },
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-apply-mode"
        }
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:applType",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "applType",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:applType.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "1.2"
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:applType.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "hosp.applType|申報類別"
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:applType.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:applType.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:applType.answer.value[x]:valueCoding",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "sliceName" : "valueCoding",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "patternCoding" : {
          "system" : "https://nhicore.nhi.gov.tw/ci/CodeSystem/nhi-apply-type",
          "code" : "1"
        },
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-apply-type"
        }
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:applDate",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "applDate",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:applDate.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "1.3"
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:applDate.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "hosp.applDate|申請日期"
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:applDate.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:medCertBookDate",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "medCertBookDate",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "constraint" : [
          {
            "key" : "medCertBookDate",
            "severity" : "error",
            "human" : "開立診斷書申請日期，不可大於系統日，不可小於2016-01-01，且為系統日之30日內。",
            "expression" : "answer.value.ofType(date) <= today() and answer.value.ofType(date) >= @2016-01-01 and answer.value.ofType(date) >= today() - 30 days",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:medCertBookDate.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "1.4"
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:medCertBookDate.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "hosp.medCertBookDate|開立診斷書申請日期"
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:medCertBookDate.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:medCertBookDate.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:hospId",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "hospId",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:hospId.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "1.5"
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:hospId.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "hosp.hospId|醫事機構代碼"
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:hospId.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:hospId.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:hospId.answer.value[x]:valueCoding",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "sliceName" : "valueCoding",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-organization"
        }
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:acptNo",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "acptNo",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:acptNo.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "1.6"
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:acptNo.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "hosp.acptNo|受理編號"
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:acptNo.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:acptNo.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:acptNo.answer.value[x]:valueString",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:acptNum",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "acptNum",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:acptNum.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "1.7"
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:acptNum.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "hosp.acptNum|受理次數"
      },
      {
        "id" : "QuestionnaireResponse.item:hosp.item:acptNum.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:patient",
        "path" : "QuestionnaireResponse.item",
        "sliceName" : "patient",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:patient.linkId",
        "path" : "QuestionnaireResponse.item.linkId",
        "patternString" : "2"
      },
      {
        "id" : "QuestionnaireResponse.item:patient.text",
        "path" : "QuestionnaireResponse.item.text",
        "patternString" : "patient|病人資訊"
      },
      {
        "id" : "QuestionnaireResponse.item:patient.answer",
        "path" : "QuestionnaireResponse.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:patient.answer.value[x]",
        "path" : "QuestionnaireResponse.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "QuestionnaireResponse.item:patient.answer.value[x]:valueReference",
        "path" : "QuestionnaireResponse.item.answer.value[x]",
        "sliceName" : "valueReference",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci"
            ]
          }
        ]
      },
      {
        "id" : "QuestionnaireResponse.item:doctor",
        "path" : "QuestionnaireResponse.item",
        "sliceName" : "doctor",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:doctor.linkId",
        "path" : "QuestionnaireResponse.item.linkId",
        "patternString" : "3"
      },
      {
        "id" : "QuestionnaireResponse.item:doctor.text",
        "path" : "QuestionnaireResponse.item.text",
        "patternString" : "doctor|醫師資訊"
      },
      {
        "id" : "QuestionnaireResponse.item:doctor.item",
        "path" : "QuestionnaireResponse.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:doctor.item:diagPrsnId",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "diagPrsnId",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:doctor.item:diagPrsnId.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "3.1"
      },
      {
        "id" : "QuestionnaireResponse.item:doctor.item:diagPrsnId.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "doctor.diagPrsnId|醫師身分證號"
      },
      {
        "id" : "QuestionnaireResponse.item:doctor.item:diagPrsnId.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:doctor.item:diagPrsnId.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:doctor.item:diagPrsnId.answer.value[x]:valueString",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "constraint" : [
          {
            "key" : "txt-10",
            "severity" : "error",
            "human" : "長度不得超過10字",
            "expression" : "length() <= 10",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:doctor.item:diagPrsnName",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "diagPrsnName",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:doctor.item:diagPrsnName.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "3.2"
      },
      {
        "id" : "QuestionnaireResponse.item:doctor.item:diagPrsnName.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "doctor.diagPrsnName|診斷醫師姓名"
      },
      {
        "id" : "QuestionnaireResponse.item:doctor.item:diagPrsnName.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:doctor.item:diagPrsnName.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:doctor.item:diagPrsnName.answer.value[x]:valueString",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "constraint" : [
          {
            "key" : "txt-12",
            "severity" : "error",
            "human" : "長度不得超過12字",
            "expression" : "length() <= 12",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis",
        "path" : "QuestionnaireResponse.item",
        "sliceName" : "diagnosis",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.linkId",
        "path" : "QuestionnaireResponse.item.linkId",
        "patternString" : "4"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.text",
        "path" : "QuestionnaireResponse.item.text",
        "patternString" : "diagnosis|疾病資訊"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item",
        "path" : "QuestionnaireResponse.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:icd10cmCode",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "icd10cmCode",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:icd10cmCode.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "4.1"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:icd10cmCode.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "diagnosis.icd10cmCode|主診斷代碼"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:icd10cmCode.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:icd10cmCode.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:icd10cmCode.answer.value[x]:valueCoding",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "sliceName" : "valueCoding",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-diag-code-icd"
        }
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "examinationReport",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "constraint" : [
          {
            "key" : "speType",
            "severity" : "error",
            "human" : "當報告類型(code.coding.code)為`47526-9`時，檢體種類(code.text)必填",
            "expression" : "(item.where(linkId = '4.2.1').item.answer.value.ofType(Coding).exists(code='47526-9')) implies (item.where(linkId = '4.2.2').item.answer.value.ofType(string).exists())",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "4.2"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "diagnosis.examinationReport|檢查報告"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item",
        "path" : "QuestionnaireResponse.item.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        }
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportType",
        "path" : "QuestionnaireResponse.item.item.item",
        "sliceName" : "reportType",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportType.linkId",
        "path" : "QuestionnaireResponse.item.item.item.linkId",
        "patternString" : "4.2.1"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportType.text",
        "path" : "QuestionnaireResponse.item.item.item.text",
        "patternString" : "diagnosis.examinationReport.reportType|報告類型。當LOINC無法具體描述檢體種類（例如：`47526-9`時），請填寫及補充說明檢體種類。"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportType.answer",
        "path" : "QuestionnaireResponse.item.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportType.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportType.answer.value[x]:valueCoding",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "sliceName" : "valueCoding",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/ci/ValueSet/loinc-report-type"
        }
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:speType",
        "path" : "QuestionnaireResponse.item.item.item",
        "sliceName" : "speType",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:speType.linkId",
        "path" : "QuestionnaireResponse.item.item.item.linkId",
        "patternString" : "4.2.2"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:speType.text",
        "path" : "QuestionnaireResponse.item.item.item.text",
        "patternString" : "diagnosis.examinationReport.speType|檢體種類"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:speType.answer",
        "path" : "QuestionnaireResponse.item.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:speType.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:speType.answer.value[x]:valueString",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "constraint" : [
          {
            "key" : "txt-20",
            "severity" : "error",
            "human" : "長度不得超過20字",
            "expression" : "length() <= 20",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportResultString",
        "path" : "QuestionnaireResponse.item.item.item",
        "sliceName" : "reportResultString",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportResultString.linkId",
        "path" : "QuestionnaireResponse.item.item.item.linkId",
        "patternString" : "4.2.3"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportResultString.text",
        "path" : "QuestionnaireResponse.item.item.item.text",
        "patternString" : "diagnosis.examinationReport.reportResultString|報告結果-文數字"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportResultString.answer",
        "path" : "QuestionnaireResponse.item.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportResultString.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportResultString.answer.value[x]:valueString",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "constraint" : [
          {
            "key" : "txt-4000",
            "severity" : "error",
            "human" : "長度不得超過4000字",
            "expression" : "length() <= 4000",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportResultPdf",
        "path" : "QuestionnaireResponse.item.item.item",
        "sliceName" : "reportResultPdf",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportResultPdf.linkId",
        "path" : "QuestionnaireResponse.item.item.item.linkId",
        "patternString" : "4.2.4"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportResultPdf.text",
        "path" : "QuestionnaireResponse.item.item.item.text",
        "patternString" : "diagnosis.examinationReport.reportResultPdf|檢查報告檔案，請填寫完整檔案路徑。填寫格式：「file://檔名.副檔名」。"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportResultPdf.answer",
        "path" : "QuestionnaireResponse.item.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportResultPdf.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportResultPdf.answer.value[x]:valueString",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "constraint" : [
          {
            "key" : "txt-50",
            "severity" : "error",
            "human" : "長度不得超過50字",
            "expression" : "length() <= 50",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportResultPdfTitle",
        "path" : "QuestionnaireResponse.item.item.item",
        "sliceName" : "reportResultPdfTitle",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportResultPdfTitle.linkId",
        "path" : "QuestionnaireResponse.item.item.item.linkId",
        "patternString" : "4.2.5"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportResultPdfTitle.text",
        "path" : "QuestionnaireResponse.item.item.item.text",
        "patternString" : "diagnosis.examinationReport.reportResultPdfTitle|檢查報告名稱"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportResultPdfTitle.answer",
        "path" : "QuestionnaireResponse.item.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportResultPdfTitle.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportResultPdfTitle.answer.value[x]:valueString",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "constraint" : [
          {
            "key" : "txt-50",
            "severity" : "error",
            "human" : "長度不得超過50字",
            "expression" : "length() <= 50",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportDate",
        "path" : "QuestionnaireResponse.item.item.item",
        "sliceName" : "reportDate",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportDate.linkId",
        "path" : "QuestionnaireResponse.item.item.item.linkId",
        "patternString" : "4.2.6"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportDate.text",
        "path" : "QuestionnaireResponse.item.item.item.text",
        "patternString" : "diagnosis.examinationReport.reportDate|報告日期，YYYY-MM-DD。"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:examinationReport.item:reportDate.answer",
        "path" : "QuestionnaireResponse.item.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:medrec",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "medrec",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:medrec.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "4.3"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:medrec.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "diagnosis.medrec|病歷資料"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:medrec.item",
        "path" : "QuestionnaireResponse.item.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        }
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:medrec.item:medrec",
        "path" : "QuestionnaireResponse.item.item.item",
        "sliceName" : "medrec",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:medrec.item:medrec.linkId",
        "path" : "QuestionnaireResponse.item.item.item.linkId",
        "patternString" : "4.3.1"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:medrec.item:medrec.text",
        "path" : "QuestionnaireResponse.item.item.item.text",
        "patternString" : "diagnosis.medrec.medrec|病歷資料"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:medrec.item:medrec.answer",
        "path" : "QuestionnaireResponse.item.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:medrec.item:medrec.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:medrec.item:medrec.answer.value[x]:valueString",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:medrec.item:medrecTitle",
        "path" : "QuestionnaireResponse.item.item.item",
        "sliceName" : "medrecTitle",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:medrec.item:medrecTitle.linkId",
        "path" : "QuestionnaireResponse.item.item.item.linkId",
        "patternString" : "4.3.2"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:medrec.item:medrecTitle.text",
        "path" : "QuestionnaireResponse.item.item.item.text",
        "patternString" : "diagnosis.medrec.medrecTitle|病歷資料名稱"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:medrec.item:medrecTitle.answer",
        "path" : "QuestionnaireResponse.item.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:medrec.item:medrecTitle.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:medrec.item:medrecTitle.answer.value[x]:valueString",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "imageStudy",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "4.4"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "diagnosis.imageStudy|影像報告"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item",
        "path" : "QuestionnaireResponse.item.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        }
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgItem",
        "path" : "QuestionnaireResponse.item.item.item",
        "sliceName" : "imgItem",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgItem.linkId",
        "path" : "QuestionnaireResponse.item.item.item.linkId",
        "patternString" : "4.4.1"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgItem.text",
        "path" : "QuestionnaireResponse.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgItem|影像報告"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgItem.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgItem.answer.value[x]:valueCoding",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "sliceName" : "valueCoding",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgResult",
        "path" : "QuestionnaireResponse.item.item.item",
        "sliceName" : "imgResult",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgResult.linkId",
        "path" : "QuestionnaireResponse.item.item.item.linkId",
        "patternString" : "4.4.2"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgResult.text",
        "path" : "QuestionnaireResponse.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgResult|影像報告結果"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgResult.answer",
        "path" : "QuestionnaireResponse.item.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgResult.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgResult.answer.value[x]:valueString",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDate",
        "path" : "QuestionnaireResponse.item.item.item",
        "sliceName" : "imgDate",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDate.linkId",
        "path" : "QuestionnaireResponse.item.item.item.linkId",
        "patternString" : "4.4.3"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDate.text",
        "path" : "QuestionnaireResponse.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgDate|影像報告日期"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDate.answer",
        "path" : "QuestionnaireResponse.item.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgBodySite",
        "path" : "QuestionnaireResponse.item.item.item",
        "sliceName" : "imgBodySite",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgBodySite.linkId",
        "path" : "QuestionnaireResponse.item.item.item.linkId",
        "patternString" : "4.4.4"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgBodySite.text",
        "path" : "QuestionnaireResponse.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgBodySite|影像檢查的身體部位"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgBodySite.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgBodySite.answer.value[x]:valueCoding",
        "path" : "QuestionnaireResponse.item.item.item.answer.value[x]",
        "sliceName" : "valueCoding",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom",
        "path" : "QuestionnaireResponse.item.item.item",
        "sliceName" : "imgDicom",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.linkId",
        "path" : "QuestionnaireResponse.item.item.item.linkId",
        "patternString" : "4.4.5"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.text",
        "path" : "QuestionnaireResponse.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgDicom|DICOM影像"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item",
        "path" : "QuestionnaireResponse.item.item.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 2
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:studyUid",
        "path" : "QuestionnaireResponse.item.item.item.item",
        "sliceName" : "studyUid",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:studyUid.linkId",
        "path" : "QuestionnaireResponse.item.item.item.item.linkId",
        "patternString" : "4.4.5.1"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:studyUid.text",
        "path" : "QuestionnaireResponse.item.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgDicom.studyUid|整項影像檢查的識別碼"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:studyUid.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:studyUid.answer.value[x]:valueString",
        "path" : "QuestionnaireResponse.item.item.item.item.answer.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series",
        "path" : "QuestionnaireResponse.item.item.item.item",
        "sliceName" : "series",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.linkId",
        "path" : "QuestionnaireResponse.item.item.item.item.linkId",
        "patternString" : "4.4.5.2"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.text",
        "path" : "QuestionnaireResponse.item.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgDicom.series|每項影像檢查有一個或多個系列(series)的實例"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item",
        "path" : "QuestionnaireResponse.item.item.item.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 3
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:uid",
        "path" : "QuestionnaireResponse.item.item.item.item.item",
        "sliceName" : "uid",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:uid.linkId",
        "path" : "QuestionnaireResponse.item.item.item.item.item.linkId",
        "patternString" : "4.4.5.2.1"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:uid.text",
        "path" : "QuestionnaireResponse.item.item.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgDicom.series.uid|此系列的DICOM系列實例UID"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:uid.answer",
        "path" : "QuestionnaireResponse.item.item.item.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:uid.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.item.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:uid.answer.value[x]:valueString",
        "path" : "QuestionnaireResponse.item.item.item.item.item.answer.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:modality",
        "path" : "QuestionnaireResponse.item.item.item.item.item",
        "sliceName" : "modality",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:modality.linkId",
        "path" : "QuestionnaireResponse.item.item.item.item.item.linkId",
        "patternString" : "4.4.5.2.2"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:modality.text",
        "path" : "QuestionnaireResponse.item.item.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgDicom.series.modality|此系列實例所使用的成像儀器"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:modality.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.item.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:modality.answer.value[x]:valueCoding",
        "path" : "QuestionnaireResponse.item.item.item.item.item.answer.value[x]",
        "sliceName" : "valueCoding",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance",
        "path" : "QuestionnaireResponse.item.item.item.item.item",
        "sliceName" : "instance",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.linkId",
        "path" : "QuestionnaireResponse.item.item.item.item.item.linkId",
        "patternString" : "4.4.5.2.3"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.text",
        "path" : "QuestionnaireResponse.item.item.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgDicom.series.instance|系列中的一個SOP實例"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item",
        "path" : "QuestionnaireResponse.item.item.item.item.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 2
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:uid",
        "path" : "QuestionnaireResponse.item.item.item.item.item.item",
        "sliceName" : "uid",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:uid.linkId",
        "path" : "QuestionnaireResponse.item.item.item.item.item.item.linkId",
        "patternString" : "4.4.5.2.3.1"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:uid.text",
        "path" : "QuestionnaireResponse.item.item.item.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgDicom.series.instance.uid|DICOM影像"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:uid.answer",
        "path" : "QuestionnaireResponse.item.item.item.item.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:uid.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.item.item.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:uid.answer.value[x]:valueString",
        "path" : "QuestionnaireResponse.item.item.item.item.item.item.answer.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:sopClass",
        "path" : "QuestionnaireResponse.item.item.item.item.item.item",
        "sliceName" : "sopClass",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:sopClass.linkId",
        "path" : "QuestionnaireResponse.item.item.item.item.item.item.linkId",
        "patternString" : "4.4.5.2.3.2"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:sopClass.text",
        "path" : "QuestionnaireResponse.item.item.item.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgDicom.series.instance.sopClass|DICOM class 類型"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:sopClass.answer",
        "path" : "QuestionnaireResponse.item.item.item.item.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:sopClass.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.item.item.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:sopClass.answer.value[x]:valueCoding",
        "path" : "QuestionnaireResponse.item.item.item.item.item.item.answer.value[x]",
        "sliceName" : "valueCoding",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgNonDicom",
        "path" : "QuestionnaireResponse.item.item.item",
        "sliceName" : "imgNonDicom",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgNonDicom.linkId",
        "path" : "QuestionnaireResponse.item.item.item.linkId",
        "patternString" : "4.4.6"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgNonDicom.text",
        "path" : "QuestionnaireResponse.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgNonDicom|非DICOM影像"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgNonDicom.item",
        "path" : "QuestionnaireResponse.item.item.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 2
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicom",
        "path" : "QuestionnaireResponse.item.item.item.item",
        "sliceName" : "imgNonDicom",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicom.linkId",
        "path" : "QuestionnaireResponse.item.item.item.item.linkId",
        "patternString" : "4.4.6.1"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicom.text",
        "path" : "QuestionnaireResponse.item.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgNonDicom.imgNonDicom|非DICOM影像"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicom.answer",
        "path" : "QuestionnaireResponse.item.item.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicom.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicom.answer.value[x]:valueString",
        "path" : "QuestionnaireResponse.item.item.item.item.answer.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicomMimeType",
        "path" : "QuestionnaireResponse.item.item.item.item",
        "sliceName" : "imgNonDicomMimeType",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicomMimeType.linkId",
        "path" : "QuestionnaireResponse.item.item.item.item.linkId",
        "patternString" : "4.4.6.2"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicomMimeType.text",
        "path" : "QuestionnaireResponse.item.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgNonDicom.imgNonDicomMimeType|非DICOM影像MimeType"
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicomMimeType.answer",
        "path" : "QuestionnaireResponse.item.item.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicomMimeType.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicomMimeType.answer.value[x]:valueCoding",
        "path" : "QuestionnaireResponse.item.item.item.item.answer.value[x]",
        "sliceName" : "valueCoding",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/ci/ValueSet/media-mimetypes"
        }
      },
      {
        "id" : "QuestionnaireResponse.item:ci",
        "path" : "QuestionnaireResponse.item",
        "sliceName" : "ci",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:ci.linkId",
        "path" : "QuestionnaireResponse.item.linkId",
        "patternString" : "5"
      },
      {
        "id" : "QuestionnaireResponse.item:ci.text",
        "path" : "QuestionnaireResponse.item.text",
        "patternString" : "ci|重大傷病"
      },
      {
        "id" : "QuestionnaireResponse.item:ci.answer",
        "path" : "QuestionnaireResponse.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:ci.answer.value[x]",
        "path" : "QuestionnaireResponse.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "QuestionnaireResponse.item:ci.answer.value[x]:valueReference",
        "path" : "QuestionnaireResponse.item.answer.value[x]",
        "sliceName" : "valueReference",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Condition-twci"
            ]
          }
        ]
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage",
        "path" : "QuestionnaireResponse.item",
        "sliceName" : "cancerStage",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.linkId",
        "path" : "QuestionnaireResponse.item.linkId",
        "patternString" : "6"
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.text",
        "path" : "QuestionnaireResponse.item.text",
        "patternString" : "cancerStage|癌症期別"
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.item",
        "path" : "QuestionnaireResponse.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.item:cancerStage",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "cancerStage",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.item:cancerStage.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "6.1"
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.item:cancerStage.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "cancerStage.cancerStage|癌症期別，醫院自行填入癌症期別(1~4)，若為不適用者填9(不適用)。"
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.item:cancerStage.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.item:cancerStage.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.item:cancerStage.answer.value[x]:valueCoding",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "sliceName" : "valueCoding",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/ci/ValueSet/cancer-stage"
        }
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.item:assessScore",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "assessScore",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.item:assessScore.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "6.2"
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.item:assessScore.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "cancerStage.assessScore|癌症分期分數或結果"
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.item:assessScore.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.item:assessScore.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.item:assessScore.answer.value[x]:valueString",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "constraint" : [
          {
            "key" : "txt-12",
            "severity" : "error",
            "human" : "長度不得超過12字",
            "expression" : "length() <= 12",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.item:assessDate",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "assessDate",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.item:assessDate.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "6.3"
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.item:assessDate.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "cancerStage.assessDate|癌症分期量表評估日期，YYYY-MM-DD，西元年月日，民國前為負數。"
      },
      {
        "id" : "QuestionnaireResponse.item:cancerStage.item:assessDate.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness",
        "path" : "QuestionnaireResponse.item",
        "sliceName" : "illness",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness.linkId",
        "path" : "QuestionnaireResponse.item.linkId",
        "patternString" : "7"
      },
      {
        "id" : "QuestionnaireResponse.item:illness.text",
        "path" : "QuestionnaireResponse.item.text",
        "patternString" : "illness|惡性腫瘤重大傷病換發評估表"
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item",
        "path" : "QuestionnaireResponse.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        }
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerCode",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "oriCancerCode",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerCode.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "7.1"
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerCode.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "illness.oriCancerCode|原發癌症診斷碼，最長為7碼。"
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerCode.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerCode.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerCode.answer.value[x]:valueCoding",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "sliceName" : "valueCoding",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-primary-cancer-icd"
        }
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerDxDate",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "oriCancerDxDate",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerDxDate.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "7.2"
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerDxDate.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "illness.oriCancerDxDate|癌症最初診斷日期，西元年月日；不得大於系統日。"
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerDxDate.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerAjcc",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "oriCancerAjcc",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerAjcc.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "7.3"
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerAjcc.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "illness.oriCancerAjcc|癌症最初診斷AJCC分期(病理分期或未接受治療前的臨床分期)，依期別填入；若不是用此分類而用其他分類，則填寫9。"
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerAjcc.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerAjcc.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerAjcc.answer.value[x]:valueCoding",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "sliceName" : "valueCoding",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-cancerstaging"
        }
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerAjcc1",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "oriCancerAjcc1",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerAjcc1.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "7.4"
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerAjcc1.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "illness.oriCancerAjcc1|癌症最初診斷AJCC分期_補充說明欄位，若前述欄位為9，則請於此欄位描述其他系統之其他分期為何。"
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerAjcc1.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerAjcc1.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:oriCancerAjcc1.answer.value[x]:valueString",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "constraint" : [
          {
            "key" : "txt-20",
            "severity" : "error",
            "human" : "長度不得超過20字",
            "expression" : "length() <= 20",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerStatus",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "cancerStatus",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerStatus.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "7.5"
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerStatus.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "illness.cancerStatus|目前癌症狀態"
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerStatus.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerStatus.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerStatus.answer.value[x]:valueCoding",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "sliceName" : "valueCoding",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-cancerstage-status"
        }
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerTreatment",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "cancerTreatment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerTreatment.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "7.6"
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerTreatment.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "illness.cancerTreatment|後續治療評估，可複選。"
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerTreatment.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerTreatment.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerTreatment.answer.value[x]:valueCoding",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "sliceName" : "valueCoding",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-cancer-treatment"
        }
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerTreatmentPlan",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "cancerTreatmentPlan",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerTreatmentPlan.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "7.7"
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerTreatmentPlan.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "illness.cancerTreatmentPlan|後續治療計劃，可複選。"
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerTreatmentPlan.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerTreatmentPlan.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerTreatmentPlan.answer.value[x]:valueCoding",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "sliceName" : "valueCoding",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-cancer-treatment-plan"
        }
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerTreatmentText",
        "path" : "QuestionnaireResponse.item.item",
        "sliceName" : "cancerTreatmentText",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerTreatmentText.linkId",
        "path" : "QuestionnaireResponse.item.item.linkId",
        "patternString" : "7.8"
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerTreatmentText.text",
        "path" : "QuestionnaireResponse.item.item.text",
        "patternString" : "illness.cancerTreatmentText|補充說明。"
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerTreatmentText.answer",
        "path" : "QuestionnaireResponse.item.item.answer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerTreatmentText.answer.value[x]",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "QuestionnaireResponse.item:illness.item:cancerTreatmentText.answer.value[x]:valueString",
        "path" : "QuestionnaireResponse.item.item.answer.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "constraint" : [
          {
            "key" : "txt-400",
            "severity" : "error",
            "human" : "長度不得超過400字",
            "expression" : "length() <= 400",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci"
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
