# 重大傷病申請書-Questionnaire TWCI - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **重大傷病申請書-Questionnaire TWCI**

## Resource Profile: 重大傷病申請書-Questionnaire TWCI 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/ci/StructureDefinition/Questionnaire-twci | *Version*:1.0.2 |
| Active as of 2025-11-12 | *Computable Name*:QuestionnaireTWCI |

 
此重大傷病申請書-Questionnaire TWCI Profile說明TWCI IG如何進一步定義FHIR的Questionnaire Resource以呈現重大傷病申請書中之內容 

**Usages:**

* Refer to this Profile: [重大傷病申請書回覆-QuestionnaireResponse TWCI](StructureDefinition-QuestionnaireResponse-twci.md)
* Examples for this Profile: [CatastrophicIllnessForm](Questionnaire-apply-catastrophic-illness.md)
* CapabilityStatements using this Profile: [臺灣重大傷病-用戶端(TWCI Client)](CapabilityStatement-CapabilityStatementTWCIClient.md) and [臺灣重大傷病-伺服端(TWCI Server)](CapabilityStatement-CapabilityStatementTWCIServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.ci|current/StructureDefinition/Questionnaire-twci)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Questionnaire-twci.csv), [Excel](StructureDefinition-Questionnaire-twci.xlsx), [Schematron](StructureDefinition-Questionnaire-twci.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Questionnaire-twci",
  "url" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Questionnaire-twci",
  "version" : "1.0.2",
  "name" : "QuestionnaireTWCI",
  "title" : "重大傷病申請書-Questionnaire TWCI",
  "status" : "active",
  "date" : "2025-11-12T05:05:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此重大傷病申請書-Questionnaire TWCI Profile說明TWCI IG如何進一步定義FHIR的Questionnaire Resource以呈現重大傷病申請書中之內容",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "objimpl",
      "uri" : "http://hl7.org/fhir/object-implementation",
      "name" : "Object Implementation Information"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Questionnaire",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Questionnaire",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Questionnaire",
        "path" : "Questionnaire"
      },
      {
        "id" : "Questionnaire.status",
        "path" : "Questionnaire.status",
        "patternCode" : "active"
      },
      {
        "id" : "Questionnaire.item",
        "path" : "Questionnaire.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 6,
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item.linkId",
        "path" : "Questionnaire.item.linkId",
        "short" : "問卷題目編號"
      },
      {
        "id" : "Questionnaire.item.type",
        "path" : "Questionnaire.item.type",
        "short" : "答題類型。group:組合題 ｜ date:日期 ｜ string:字串 ｜ integer:整數｜ choice:選擇｜ attachment:文件｜ text:文字"
      },
      {
        "id" : "Questionnaire.item:hosp",
        "path" : "Questionnaire.item",
        "sliceName" : "hosp",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:hosp.linkId",
        "path" : "Questionnaire.item.linkId",
        "patternString" : "1"
      },
      {
        "id" : "Questionnaire.item:hosp.text",
        "path" : "Questionnaire.item.text",
        "patternString" : "hosp|院所資訊"
      },
      {
        "id" : "Questionnaire.item:hosp.type",
        "path" : "Questionnaire.item.type",
        "patternCode" : "group"
      },
      {
        "id" : "Questionnaire.item:hosp.required",
        "path" : "Questionnaire.item.required",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:hosp.item",
        "path" : "Questionnaire.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 5
      },
      {
        "id" : "Questionnaire.item:hosp.item:applMode",
        "path" : "Questionnaire.item.item",
        "sliceName" : "applMode",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:hosp.item:applMode.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "1.1"
      },
      {
        "id" : "Questionnaire.item:hosp.item:applMode.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "hosp.applMode|申報方式"
      },
      {
        "id" : "Questionnaire.item:hosp.item:applMode.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "choice"
      },
      {
        "id" : "Questionnaire.item:hosp.item:applMode.required",
        "path" : "Questionnaire.item.item.required",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:hosp.item:applMode.answerValueSet",
        "path" : "Questionnaire.item.item.answerValueSet",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-apply-mode"
      },
      {
        "id" : "Questionnaire.item:hosp.item:applType",
        "path" : "Questionnaire.item.item",
        "sliceName" : "applType",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:hosp.item:applType.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "1.2"
      },
      {
        "id" : "Questionnaire.item:hosp.item:applType.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "hosp.applType|申報類別"
      },
      {
        "id" : "Questionnaire.item:hosp.item:applType.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "choice"
      },
      {
        "id" : "Questionnaire.item:hosp.item:applType.required",
        "path" : "Questionnaire.item.item.required",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:hosp.item:applType.answerValueSet",
        "path" : "Questionnaire.item.item.answerValueSet",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-apply-type"
      },
      {
        "id" : "Questionnaire.item:hosp.item:applDate",
        "path" : "Questionnaire.item.item",
        "sliceName" : "applDate",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:hosp.item:applDate.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "1.3"
      },
      {
        "id" : "Questionnaire.item:hosp.item:applDate.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "hosp.applDate|申請日期"
      },
      {
        "id" : "Questionnaire.item:hosp.item:applDate.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "date"
      },
      {
        "id" : "Questionnaire.item:hosp.item:applDate.required",
        "path" : "Questionnaire.item.item.required",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:hosp.item:medCertBookDate",
        "path" : "Questionnaire.item.item",
        "sliceName" : "medCertBookDate",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:hosp.item:medCertBookDate.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "1.4"
      },
      {
        "id" : "Questionnaire.item:hosp.item:medCertBookDate.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "hosp.medCertBookDate|開立診斷書申請日期"
      },
      {
        "id" : "Questionnaire.item:hosp.item:medCertBookDate.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "date"
      },
      {
        "id" : "Questionnaire.item:hosp.item:medCertBookDate.required",
        "path" : "Questionnaire.item.item.required",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:hosp.item:hospId",
        "path" : "Questionnaire.item.item",
        "sliceName" : "hospId",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:hosp.item:hospId.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "1.5"
      },
      {
        "id" : "Questionnaire.item:hosp.item:hospId.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "hosp.hospId|醫事機構代碼"
      },
      {
        "id" : "Questionnaire.item:hosp.item:hospId.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "choice"
      },
      {
        "id" : "Questionnaire.item:hosp.item:hospId.required",
        "path" : "Questionnaire.item.item.required",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:hosp.item:hospId.answerValueSet",
        "path" : "Questionnaire.item.item.answerValueSet",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-organization"
      },
      {
        "id" : "Questionnaire.item:hosp.item:acptNo",
        "path" : "Questionnaire.item.item",
        "sliceName" : "acptNo",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:hosp.item:acptNo.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "1.6"
      },
      {
        "id" : "Questionnaire.item:hosp.item:acptNo.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "hosp.acptNo|受理編號"
      },
      {
        "id" : "Questionnaire.item:hosp.item:acptNo.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "string"
      },
      {
        "id" : "Questionnaire.item:hosp.item:acptNum",
        "path" : "Questionnaire.item.item",
        "sliceName" : "acptNum",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:hosp.item:acptNum.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "1.7"
      },
      {
        "id" : "Questionnaire.item:hosp.item:acptNum.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "hosp.acptNum|受理次數"
      },
      {
        "id" : "Questionnaire.item:hosp.item:acptNum.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "integer"
      },
      {
        "id" : "Questionnaire.item:patient",
        "path" : "Questionnaire.item",
        "sliceName" : "patient",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:patient.linkId",
        "path" : "Questionnaire.item.linkId",
        "patternString" : "2"
      },
      {
        "id" : "Questionnaire.item:patient.text",
        "path" : "Questionnaire.item.text",
        "patternString" : "patient|病人資訊"
      },
      {
        "id" : "Questionnaire.item:patient.type",
        "path" : "Questionnaire.item.type",
        "patternCode" : "reference"
      },
      {
        "id" : "Questionnaire.item:patient.required",
        "path" : "Questionnaire.item.required",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:patient.answerOption.value[x]",
        "path" : "Questionnaire.item.answerOption.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Resource"]
          }
        ]
      },
      {
        "id" : "Questionnaire.item:doctor",
        "path" : "Questionnaire.item",
        "sliceName" : "doctor",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:doctor.linkId",
        "path" : "Questionnaire.item.linkId",
        "patternString" : "3"
      },
      {
        "id" : "Questionnaire.item:doctor.text",
        "path" : "Questionnaire.item.text",
        "patternString" : "doctor|醫師資訊"
      },
      {
        "id" : "Questionnaire.item:doctor.type",
        "path" : "Questionnaire.item.type",
        "patternCode" : "group"
      },
      {
        "id" : "Questionnaire.item:doctor.required",
        "path" : "Questionnaire.item.required",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:doctor.item",
        "path" : "Questionnaire.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 1
      },
      {
        "id" : "Questionnaire.item:doctor.item:diagPrsnId",
        "path" : "Questionnaire.item.item",
        "sliceName" : "diagPrsnId",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:doctor.item:diagPrsnId.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "3.1"
      },
      {
        "id" : "Questionnaire.item:doctor.item:diagPrsnId.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "doctor.diagPrsnId|醫師身分證號"
      },
      {
        "id" : "Questionnaire.item:doctor.item:diagPrsnId.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "string"
      },
      {
        "id" : "Questionnaire.item:doctor.item:diagPrsnName",
        "path" : "Questionnaire.item.item",
        "sliceName" : "diagPrsnName",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:doctor.item:diagPrsnName.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "3.2"
      },
      {
        "id" : "Questionnaire.item:doctor.item:diagPrsnName.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "doctor.diagPrsnName|診斷醫師姓名"
      },
      {
        "id" : "Questionnaire.item:doctor.item:diagPrsnName.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "string"
      },
      {
        "id" : "Questionnaire.item:doctor.item:diagPrsnName.required",
        "path" : "Questionnaire.item.item.required",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis",
        "path" : "Questionnaire.item",
        "sliceName" : "diagnosis",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.linkId",
        "path" : "Questionnaire.item.linkId",
        "patternString" : "4"
      },
      {
        "id" : "Questionnaire.item:diagnosis.text",
        "path" : "Questionnaire.item.text",
        "patternString" : "diagnosis|疾病資訊"
      },
      {
        "id" : "Questionnaire.item:diagnosis.type",
        "path" : "Questionnaire.item.type",
        "patternCode" : "group"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item",
        "path" : "Questionnaire.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 1
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:icd10cmCode",
        "path" : "Questionnaire.item.item",
        "sliceName" : "icd10cmCode",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:icd10cmCode.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "4.1"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:icd10cmCode.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "diagnosis.icd10cmCode|主診斷代碼"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:icd10cmCode.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "choice"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:icd10cmCode.required",
        "path" : "Questionnaire.item.item.required",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:icd10cmCode.answerValueSet",
        "path" : "Questionnaire.item.item.answerValueSet",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-diag-code-icd"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport",
        "path" : "Questionnaire.item.item",
        "sliceName" : "examinationReport",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "4.2"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "diagnosis.examinationReport|檢查報告"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "group"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item",
        "path" : "Questionnaire.item.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        }
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportType",
        "path" : "Questionnaire.item.item.item",
        "sliceName" : "reportType",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportType.linkId",
        "path" : "Questionnaire.item.item.item.linkId",
        "patternString" : "4.2.1"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportType.text",
        "path" : "Questionnaire.item.item.item.text",
        "patternString" : "diagnosis.examinationReport.reportType|報告類型。當LOINC無法具體描述檢體種類（例如：`47526-9`時），請填寫及補充說明檢體種類。"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportType.type",
        "path" : "Questionnaire.item.item.item.type",
        "patternCode" : "choice"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportType.answerValueSet",
        "path" : "Questionnaire.item.item.item.answerValueSet",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/ci/ValueSet/loinc-report-type"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:speType",
        "path" : "Questionnaire.item.item.item",
        "sliceName" : "speType",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:speType.linkId",
        "path" : "Questionnaire.item.item.item.linkId",
        "patternString" : "4.2.2"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:speType.text",
        "path" : "Questionnaire.item.item.item.text",
        "patternString" : "diagnosis.examinationReport.speType|檢體種類"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:speType.type",
        "path" : "Questionnaire.item.item.item.type",
        "patternCode" : "string"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportResultString",
        "path" : "Questionnaire.item.item.item",
        "sliceName" : "reportResultString",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportResultString.linkId",
        "path" : "Questionnaire.item.item.item.linkId",
        "patternString" : "4.2.3"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportResultString.text",
        "path" : "Questionnaire.item.item.item.text",
        "patternString" : "diagnosis.examinationReport.reportResultString|報告結果-文數字"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportResultString.type",
        "path" : "Questionnaire.item.item.item.type",
        "patternCode" : "string"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportResultPdf",
        "path" : "Questionnaire.item.item.item",
        "sliceName" : "reportResultPdf",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportResultPdf.linkId",
        "path" : "Questionnaire.item.item.item.linkId",
        "patternString" : "4.2.4"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportResultPdf.text",
        "path" : "Questionnaire.item.item.item.text",
        "patternString" : "diagnosis.examinationReport.reportResultPdf|檢查報告檔案，請填寫完整檔案路徑。填寫格式：「file://檔名.副檔名」。"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportResultPdf.type",
        "path" : "Questionnaire.item.item.item.type",
        "patternCode" : "string"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportResultPdfTitle",
        "path" : "Questionnaire.item.item.item",
        "sliceName" : "reportResultPdfTitle",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportResultPdfTitle.linkId",
        "path" : "Questionnaire.item.item.item.linkId",
        "patternString" : "4.2.5"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportResultPdfTitle.text",
        "path" : "Questionnaire.item.item.item.text",
        "patternString" : "diagnosis.examinationReport.reportResultPdfTitle|檢查報告名稱"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportResultPdfTitle.type",
        "path" : "Questionnaire.item.item.item.type",
        "patternCode" : "string"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportDate",
        "path" : "Questionnaire.item.item.item",
        "sliceName" : "reportDate",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportDate.linkId",
        "path" : "Questionnaire.item.item.item.linkId",
        "patternString" : "4.2.6"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportDate.text",
        "path" : "Questionnaire.item.item.item.text",
        "patternString" : "diagnosis.examinationReport.reportDate|報告日期，YYYY-MM-DD。"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:examinationReport.item:reportDate.type",
        "path" : "Questionnaire.item.item.item.type",
        "patternCode" : "date"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:medrec",
        "path" : "Questionnaire.item.item",
        "sliceName" : "medrec",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:medrec.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "4.3"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:medrec.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "diagnosis.medrec|病歷資料"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:medrec.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "group"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:medrec.repeats",
        "path" : "Questionnaire.item.item.repeats",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:medrec.item",
        "path" : "Questionnaire.item.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        }
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:medrec.item:medrec",
        "path" : "Questionnaire.item.item.item",
        "sliceName" : "medrec",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:medrec.item:medrec.linkId",
        "path" : "Questionnaire.item.item.item.linkId",
        "patternString" : "4.3.1"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:medrec.item:medrec.text",
        "path" : "Questionnaire.item.item.item.text",
        "patternString" : "diagnosis.medrec.medrec|病歷資料"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:medrec.item:medrec.type",
        "path" : "Questionnaire.item.item.item.type",
        "patternCode" : "string"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:medrec.item:medrecTitle",
        "path" : "Questionnaire.item.item.item",
        "sliceName" : "medrecTitle",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:medrec.item:medrecTitle.linkId",
        "path" : "Questionnaire.item.item.item.linkId",
        "patternString" : "4.3.2"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:medrec.item:medrecTitle.text",
        "path" : "Questionnaire.item.item.item.text",
        "patternString" : "diagnosis.medrec.medrecTitle|病歷資料名稱"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:medrec.item:medrecTitle.type",
        "path" : "Questionnaire.item.item.item.type",
        "patternCode" : "string"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy",
        "path" : "Questionnaire.item.item",
        "sliceName" : "imageStudy",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "4.4"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "diagnosis.imageStudy|影像報告"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "group"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.repeats",
        "path" : "Questionnaire.item.item.repeats",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item",
        "path" : "Questionnaire.item.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        }
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgItem",
        "path" : "Questionnaire.item.item.item",
        "sliceName" : "imgItem",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgItem.linkId",
        "path" : "Questionnaire.item.item.item.linkId",
        "patternString" : "4.4.1"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgItem.text",
        "path" : "Questionnaire.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgItem|影像報告"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgItem.type",
        "path" : "Questionnaire.item.item.item.type",
        "patternCode" : "choice"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgItem.answerValueSet",
        "path" : "Questionnaire.item.item.item.answerValueSet",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/ci/ValueSet/icd-10-pcs-2023-image"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgResult",
        "path" : "Questionnaire.item.item.item",
        "sliceName" : "imgResult",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgResult.linkId",
        "path" : "Questionnaire.item.item.item.linkId",
        "patternString" : "4.4.2"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgResult.text",
        "path" : "Questionnaire.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgResult|影像報告結果"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgResult.type",
        "path" : "Questionnaire.item.item.item.type",
        "patternCode" : "string"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDate",
        "path" : "Questionnaire.item.item.item",
        "sliceName" : "imgDate",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDate.linkId",
        "path" : "Questionnaire.item.item.item.linkId",
        "patternString" : "4.4.3"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDate.text",
        "path" : "Questionnaire.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgDate|影像報告日期"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDate.type",
        "path" : "Questionnaire.item.item.item.type",
        "patternCode" : "date"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgBodySite",
        "path" : "Questionnaire.item.item.item",
        "sliceName" : "imgBodySite",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgBodySite.linkId",
        "path" : "Questionnaire.item.item.item.linkId",
        "patternString" : "4.4.4"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgBodySite.text",
        "path" : "Questionnaire.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgBodySite|影像檢查的身體部位"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgBodySite.type",
        "path" : "Questionnaire.item.item.item.type",
        "patternCode" : "choice"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgBodySite.answerValueSet",
        "path" : "Questionnaire.item.item.item.answerValueSet",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/ci/ValueSet/body-site"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom",
        "path" : "Questionnaire.item.item.item",
        "sliceName" : "imgDicom",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.linkId",
        "path" : "Questionnaire.item.item.item.linkId",
        "patternString" : "4.4.5"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.text",
        "path" : "Questionnaire.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgDicom|DICOM影像"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.type",
        "path" : "Questionnaire.item.item.item.type",
        "patternCode" : "group"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.repeats",
        "path" : "Questionnaire.item.item.item.repeats",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item",
        "path" : "Questionnaire.item.item.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 2
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:studyUid",
        "path" : "Questionnaire.item.item.item.item",
        "sliceName" : "studyUid",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:studyUid.linkId",
        "path" : "Questionnaire.item.item.item.item.linkId",
        "patternString" : "4.4.5.1"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:studyUid.text",
        "path" : "Questionnaire.item.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgDicom.studyUid|整項影像檢查的識別碼"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:studyUid.type",
        "path" : "Questionnaire.item.item.item.item.type",
        "patternCode" : "string"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series",
        "path" : "Questionnaire.item.item.item.item",
        "sliceName" : "series",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.linkId",
        "path" : "Questionnaire.item.item.item.item.linkId",
        "patternString" : "4.4.5.2"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.text",
        "path" : "Questionnaire.item.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgDicom.series|每項影像檢查有一個或多個系列(series)的實例"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.type",
        "path" : "Questionnaire.item.item.item.item.type",
        "patternCode" : "group"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.repeats",
        "path" : "Questionnaire.item.item.item.item.repeats",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item",
        "path" : "Questionnaire.item.item.item.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 3
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:uid",
        "path" : "Questionnaire.item.item.item.item.item",
        "sliceName" : "uid",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:uid.linkId",
        "path" : "Questionnaire.item.item.item.item.item.linkId",
        "patternString" : "4.4.5.2.1"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:uid.text",
        "path" : "Questionnaire.item.item.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgDicom.series.uid|此系列的DICOM系列實例UID"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:uid.type",
        "path" : "Questionnaire.item.item.item.item.item.type",
        "patternCode" : "string"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:modality",
        "path" : "Questionnaire.item.item.item.item.item",
        "sliceName" : "modality",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:modality.linkId",
        "path" : "Questionnaire.item.item.item.item.item.linkId",
        "patternString" : "4.4.5.2.2"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:modality.text",
        "path" : "Questionnaire.item.item.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgDicom.series.modality|此系列實例所使用的成像儀器"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:modality.type",
        "path" : "Questionnaire.item.item.item.item.item.type",
        "patternCode" : "choice"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:modality.answerValueSet",
        "path" : "Questionnaire.item.item.item.item.item.answerValueSet",
        "patternCanonical" : "http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_29.html"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance",
        "path" : "Questionnaire.item.item.item.item.item",
        "sliceName" : "instance",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.linkId",
        "path" : "Questionnaire.item.item.item.item.item.linkId",
        "patternString" : "4.4.5.2.3"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.text",
        "path" : "Questionnaire.item.item.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgDicom.series.instance|系列中的一個SOP實例"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.type",
        "path" : "Questionnaire.item.item.item.item.item.type",
        "patternCode" : "group"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.repeats",
        "path" : "Questionnaire.item.item.item.item.item.repeats",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item",
        "path" : "Questionnaire.item.item.item.item.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 2
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:uid",
        "path" : "Questionnaire.item.item.item.item.item.item",
        "sliceName" : "uid",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:uid.linkId",
        "path" : "Questionnaire.item.item.item.item.item.item.linkId",
        "patternString" : "4.4.5.2.3.1"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:uid.text",
        "path" : "Questionnaire.item.item.item.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgDicom.series.instance.uid|DICOM影像"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:uid.type",
        "path" : "Questionnaire.item.item.item.item.item.item.type",
        "patternCode" : "string"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:sopClass",
        "path" : "Questionnaire.item.item.item.item.item.item",
        "sliceName" : "sopClass",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:sopClass.linkId",
        "path" : "Questionnaire.item.item.item.item.item.item.linkId",
        "patternString" : "4.4.5.2.3.2"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:sopClass.text",
        "path" : "Questionnaire.item.item.item.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgDicom.series.instance.sopClass|DICOM class 類型"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgDicom.item:series.item:instance.item:sopClass.type",
        "path" : "Questionnaire.item.item.item.item.item.item.type",
        "patternCode" : "choice"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgNonDicom",
        "path" : "Questionnaire.item.item.item",
        "sliceName" : "imgNonDicom",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgNonDicom.linkId",
        "path" : "Questionnaire.item.item.item.linkId",
        "patternString" : "4.4.6"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgNonDicom.text",
        "path" : "Questionnaire.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgNonDicom|非DICOM影像"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgNonDicom.type",
        "path" : "Questionnaire.item.item.item.type",
        "patternCode" : "group"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgNonDicom.repeats",
        "path" : "Questionnaire.item.item.item.repeats",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgNonDicom.item",
        "path" : "Questionnaire.item.item.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 2
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicom",
        "path" : "Questionnaire.item.item.item.item",
        "sliceName" : "imgNonDicom",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicom.linkId",
        "path" : "Questionnaire.item.item.item.item.linkId",
        "patternString" : "4.4.6.1"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicom.text",
        "path" : "Questionnaire.item.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgNonDicom.imgNonDicom|非DICOM影像"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicom.type",
        "path" : "Questionnaire.item.item.item.item.type",
        "patternCode" : "string"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicomMimeType",
        "path" : "Questionnaire.item.item.item.item",
        "sliceName" : "imgNonDicomMimeType",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicomMimeType.linkId",
        "path" : "Questionnaire.item.item.item.item.linkId",
        "patternString" : "4.4.6.2"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicomMimeType.text",
        "path" : "Questionnaire.item.item.item.item.text",
        "patternString" : "diagnosis.imageStudy.imgNonDicom.imgNonDicomMimeType|非DICOM影像MimeType"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicomMimeType.type",
        "path" : "Questionnaire.item.item.item.item.type",
        "patternCode" : "choice"
      },
      {
        "id" : "Questionnaire.item:diagnosis.item:imageStudy.item:imgNonDicom.item:imgNonDicomMimeType.answerValueSet",
        "path" : "Questionnaire.item.item.item.item.answerValueSet",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/ci/ValueSet/media-mimetypes"
      },
      {
        "id" : "Questionnaire.item:ci",
        "path" : "Questionnaire.item",
        "sliceName" : "ci",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:ci.linkId",
        "path" : "Questionnaire.item.linkId",
        "patternString" : "5"
      },
      {
        "id" : "Questionnaire.item:ci.text",
        "path" : "Questionnaire.item.text",
        "patternString" : "ci|重大傷病"
      },
      {
        "id" : "Questionnaire.item:ci.type",
        "path" : "Questionnaire.item.type",
        "patternCode" : "reference"
      },
      {
        "id" : "Questionnaire.item:ci.required",
        "path" : "Questionnaire.item.required",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:ci.answerOption.value[x]",
        "path" : "Questionnaire.item.answerOption.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Resource"]
          }
        ]
      },
      {
        "id" : "Questionnaire.item:cancerStage",
        "path" : "Questionnaire.item",
        "sliceName" : "cancerStage",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:cancerStage.linkId",
        "path" : "Questionnaire.item.linkId",
        "patternString" : "6"
      },
      {
        "id" : "Questionnaire.item:cancerStage.text",
        "path" : "Questionnaire.item.text",
        "patternString" : "cancerStage|癌症期別"
      },
      {
        "id" : "Questionnaire.item:cancerStage.type",
        "path" : "Questionnaire.item.type",
        "patternCode" : "group"
      },
      {
        "id" : "Questionnaire.item:cancerStage.required",
        "path" : "Questionnaire.item.required",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:cancerStage.item",
        "path" : "Questionnaire.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 1
      },
      {
        "id" : "Questionnaire.item:cancerStage.item:cancerStage",
        "path" : "Questionnaire.item.item",
        "sliceName" : "cancerStage",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:cancerStage.item:cancerStage.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "6.1"
      },
      {
        "id" : "Questionnaire.item:cancerStage.item:cancerStage.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "cancerStage.cancerStage|癌症期別，醫院自行填入癌症期別(1~4)，若為不適用者填9(不適用)。"
      },
      {
        "id" : "Questionnaire.item:cancerStage.item:cancerStage.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "choice"
      },
      {
        "id" : "Questionnaire.item:cancerStage.item:cancerStage.required",
        "path" : "Questionnaire.item.item.required",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:cancerStage.item:cancerStage.answerValueSet",
        "path" : "Questionnaire.item.item.answerValueSet",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/ci/ValueSet/cancer-stage"
      },
      {
        "id" : "Questionnaire.item:cancerStage.item:assessScore",
        "path" : "Questionnaire.item.item",
        "sliceName" : "assessScore",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:cancerStage.item:assessScore.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "6.2"
      },
      {
        "id" : "Questionnaire.item:cancerStage.item:assessScore.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "cancerStage.assessScore|癌症分期分數或結果"
      },
      {
        "id" : "Questionnaire.item:cancerStage.item:assessScore.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "string"
      },
      {
        "id" : "Questionnaire.item:cancerStage.item:assessDate",
        "path" : "Questionnaire.item.item",
        "sliceName" : "assessDate",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:cancerStage.item:assessDate.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "6.3"
      },
      {
        "id" : "Questionnaire.item:cancerStage.item:assessDate.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "cancerStage.assessDate|癌症分期量表評估日期，YYYY-MM-DD，西元年月日，民國前為負數。"
      },
      {
        "id" : "Questionnaire.item:cancerStage.item:assessDate.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "date"
      },
      {
        "id" : "Questionnaire.item:illness",
        "path" : "Questionnaire.item",
        "sliceName" : "illness",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:illness.linkId",
        "path" : "Questionnaire.item.linkId",
        "patternString" : "7"
      },
      {
        "id" : "Questionnaire.item:illness.text",
        "path" : "Questionnaire.item.text",
        "patternString" : "illness|惡性腫瘤重大傷病換發評估表"
      },
      {
        "id" : "Questionnaire.item:illness.type",
        "path" : "Questionnaire.item.type",
        "patternCode" : "group"
      },
      {
        "id" : "Questionnaire.item:illness.item",
        "path" : "Questionnaire.item.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        }
      },
      {
        "id" : "Questionnaire.item:illness.item:oriCancerCode",
        "path" : "Questionnaire.item.item",
        "sliceName" : "oriCancerCode",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:illness.item:oriCancerCode.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "7.1"
      },
      {
        "id" : "Questionnaire.item:illness.item:oriCancerCode.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "illness.oriCancerCode|原發癌症診斷碼，最長為7碼。"
      },
      {
        "id" : "Questionnaire.item:illness.item:oriCancerCode.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "choice"
      },
      {
        "id" : "Questionnaire.item:illness.item:oriCancerCode.answerValueSet",
        "path" : "Questionnaire.item.item.answerValueSet",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-primary-cancer-icd"
      },
      {
        "id" : "Questionnaire.item:illness.item:oriCancerDxDate",
        "path" : "Questionnaire.item.item",
        "sliceName" : "oriCancerDxDate",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:illness.item:oriCancerDxDate.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "7.2"
      },
      {
        "id" : "Questionnaire.item:illness.item:oriCancerDxDate.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "illness.oriCancerDxDate|癌症最初診斷日期，西元年月日；不得大於系統日。"
      },
      {
        "id" : "Questionnaire.item:illness.item:oriCancerDxDate.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "date"
      },
      {
        "id" : "Questionnaire.item:illness.item:oriCancerAjcc",
        "path" : "Questionnaire.item.item",
        "sliceName" : "oriCancerAjcc",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:illness.item:oriCancerAjcc.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "7.3"
      },
      {
        "id" : "Questionnaire.item:illness.item:oriCancerAjcc.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "illness.oriCancerAjcc|癌症最初診斷AJCC分期(病理分期或未接受治療前的臨床分期)，依期別填入；若不是用此分類而用其他分類，則填寫9。"
      },
      {
        "id" : "Questionnaire.item:illness.item:oriCancerAjcc.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "choice"
      },
      {
        "id" : "Questionnaire.item:illness.item:oriCancerAjcc.answerValueSet",
        "path" : "Questionnaire.item.item.answerValueSet",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-cancerstaging"
      },
      {
        "id" : "Questionnaire.item:illness.item:oriCancerAjcc1",
        "path" : "Questionnaire.item.item",
        "sliceName" : "oriCancerAjcc1",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:illness.item:oriCancerAjcc1.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "7.4"
      },
      {
        "id" : "Questionnaire.item:illness.item:oriCancerAjcc1.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "illness.oriCancerAjcc1|癌症最初診斷AJCC分期_補充說明欄位，若前述欄位為9，則請於此欄位描述其他系統之其他分期為何。"
      },
      {
        "id" : "Questionnaire.item:illness.item:oriCancerAjcc1.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "string"
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerStatus",
        "path" : "Questionnaire.item.item",
        "sliceName" : "cancerStatus",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerStatus.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "7.5"
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerStatus.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "illness.cancerStatus|目前癌症狀態"
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerStatus.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "choice"
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerStatus.answerValueSet",
        "path" : "Questionnaire.item.item.answerValueSet",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-cancerstage-status"
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerTreatment",
        "path" : "Questionnaire.item.item",
        "sliceName" : "cancerTreatment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerTreatment.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "7.6"
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerTreatment.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "illness.cancerTreatment|後續治療評估，可複選。"
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerTreatment.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "choice"
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerTreatment.repeats",
        "path" : "Questionnaire.item.item.repeats",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerTreatment.answerValueSet",
        "path" : "Questionnaire.item.item.answerValueSet",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-cancer-treatment"
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerTreatmentPlan",
        "path" : "Questionnaire.item.item",
        "sliceName" : "cancerTreatmentPlan",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerTreatmentPlan.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "7.7"
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerTreatmentPlan.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "illness.cancerTreatmentPlan|後續治療計劃，可複選。"
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerTreatmentPlan.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "choice"
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerTreatmentPlan.repeats",
        "path" : "Questionnaire.item.item.repeats",
        "patternBoolean" : true
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerTreatmentPlan.answerValueSet",
        "path" : "Questionnaire.item.item.answerValueSet",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-cancer-treatment-plan"
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerTreatmentText",
        "path" : "Questionnaire.item.item",
        "sliceName" : "cancerTreatmentText",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerTreatmentText.linkId",
        "path" : "Questionnaire.item.item.linkId",
        "patternString" : "7.8"
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerTreatmentText.text",
        "path" : "Questionnaire.item.item.text",
        "patternString" : "illness.cancerTreatmentText|補充說明。"
      },
      {
        "id" : "Questionnaire.item:illness.item:cancerTreatmentText.type",
        "path" : "Questionnaire.item.item.type",
        "patternCode" : "string"
      }
    ]
  }
}

```
