# 重大傷病-Condition TWCI - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **重大傷病-Condition TWCI**

## Resource Profile: 重大傷病-Condition TWCI 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/ci/StructureDefinition/Condition-twci | *Version*:1.0.2 |
| Active as of 2025-11-12 | *Computable Name*:ConditionTWCI |

 
此重大傷病-Condition TWCI Profile說明TWCI IG如何進一步定義臺灣核心-病情、問題或診斷（TW Core Condition） Profile以呈現重大傷病之內容 

**Usages:**

* Use this Profile: [重大傷病申請證明-Bundle TWCI](StructureDefinition-Bundle-twci.md)
* Refer to this Profile: [重大傷病申請書回覆-QuestionnaireResponse TWCI](StructureDefinition-QuestionnaireResponse-twci.md) and [重大傷病申請-Task TWCI](StructureDefinition-Task-twci.md)
* Examples for this Profile: [Condition/con-min](Condition-con-min.md)
* CapabilityStatements using this Profile: [臺灣重大傷病-用戶端(TWCI Client)](CapabilityStatement-CapabilityStatementTWCIClient.md) and [臺灣重大傷病-伺服端(TWCI Server)](CapabilityStatement-CapabilityStatementTWCIServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.ci|current/StructureDefinition/Condition-twci)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Condition-twci.csv), [Excel](StructureDefinition-Condition-twci.xlsx), [Schematron](StructureDefinition-Condition-twci.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Condition-twci",
  "url" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Condition-twci",
  "version" : "1.0.2",
  "name" : "ConditionTWCI",
  "title" : "重大傷病-Condition TWCI",
  "status" : "active",
  "date" : "2025-11-12T05:05:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此重大傷病-Condition TWCI Profile說明TWCI IG如何進一步定義臺灣核心-病情、問題或診斷（TW Core Condition） Profile以呈現重大傷病之內容",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition.category",
        "path" : "Condition.category",
        "short" : "重大傷病類別",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/ci/CodeSystem/nhi-category",
              "code" : "01"
            }
          ]
        },
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-category"
        }
      },
      {
        "id" : "Condition.category.coding",
        "path" : "Condition.category.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Condition.category.coding.code",
        "path" : "Condition.category.coding.code",
        "short" : "固定填「01」(癌症)。",
        "min" : 1
      },
      {
        "id" : "Condition.subject",
        "path" : "Condition.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci"
            ]
          }
        ]
      }
    ]
  }
}

```
