# Patient-name - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient-name**

## SearchParameter: Patient-name 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/ci/SearchParameter/Patient-name | *Version*:1.0.2 |
| Active as of 2025-11-07 | *Computable Name*:PatientName |

 
病人的姓名(name)，該查詢可能與 HumanName 中的任何字串匹配，包括完整的中文姓名(text)、英文姓(family)、英文名(given)、姓名前面的頭銜(prefix)、姓名後面的稱謂(suffix)。 

## PatientName

Parameter `name`:`string`

病人的姓名(name)，該查詢可能與 HumanName 中的任何字串匹配，包括完整的中文姓名(text)、英文姓(family)、英文名(given)、姓名前面的頭銜(prefix)、姓名後面的稱謂(suffix)。

| | |
| :--- | :--- |
| Resource | [Patient](http://hl7.org/fhir/R4/patient.html) |
| Expression | `Patient.name` |
| Multiples | * multipleAnd: It's up to the server whether the parameter may repeat in order to specify multiple values that must all be true
* multipleOr: It's up to the server whether the parameter can have multiple values (separated by comma) where at least one must be true
 |



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "Patient-name",
  "url" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Patient-name",
  "version" : "1.0.2",
  "name" : "PatientName",
  "status" : "active",
  "date" : "2025-11-07",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "病人的姓名(name)，該查詢可能與 HumanName 中的任何字串匹配，包括完整的中文姓名(text)、英文姓(family)、英文名(given)、姓名前面的頭銜(prefix)、姓名後面的稱謂(suffix)。",
  "code" : "name",
  "base" : ["Patient"],
  "type" : "string",
  "expression" : "Patient.name"
}

```
