# 病人資訊 - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **病人資訊**

## Example Patient: 病人資訊

Profile: [病人資訊-Patient TWCI](StructureDefinition-Patient-twci.md)

> **識別碼型別**：National Person Identifier（[Identifier Type Codes](http://terminology.hl7.org/CodeSystem/v2-0203)#NNxxx）
**身分證號（official）**：A123456789 （http://www.moi.gov.tw）

> **識別碼型別**：Medical record number（[Identifier Type Codes](http://terminology.hl7.org/CodeSystem/v2-0203)#MR）
**病歷號（official）**：123456 （https://tpech.gov.taipei）

**姓名（usual）**：王大明

**性別**：男（male）

**出生日期**：2001-01-01

**手機號碼**：0912345678

**連絡電話**：0227065866

**電子郵件信箱**：a123456@nhi.gov.tw

**郵遞區號**：106

**連絡住址**：台北市大安區信義路三段140號



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "pat-min",
  "meta" : {
    "profile" : [
      "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "NNxxx"
          }
        ]
      },
      "system" : "http://www.moi.gov.tw",
      "value" : "A123456789"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR"
          }
        ]
      },
      "system" : "https://tpech.gov.taipei",
      "value" : "123456"
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "text" : "王大明"
    }
  ],
  "telecom" : [
    {
      "system" : "sms",
      "value" : "0912345678"
    },
    {
      "system" : "phone",
      "value" : "0227065866"
    },
    {
      "system" : "email",
      "value" : "a123456@nhi.gov.tw"
    }
  ],
  "gender" : "male",
  "birthDate" : "2001-01-01",
  "address" : [
    {
      "text" : "台北市大安區信義路三段140號",
      "_postalCode" : {
        "extension" : [
          {
            "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-postal-code",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code3-tw",
                  "code" : "106"
                }
              ]
            }
          }
        ]
      }
    }
  ]
}

```
