# TWCI ImplementationGuide Resource - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* **TWCI ImplementationGuide Resource**

## TWCI ImplementationGuide Resource

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/ci/ImplementationGuide/tw.gov.mohw.nhi.ci | *Version*:1.0.2 |
| *NPM package name*: tw.gov.mohw.nhi.ci | *Computable Name*:TWCI |

* [XML](ImplementationGuide-tw.gov.mohw.nhi.ci.xml)
* [JSON](ImplementationGuide-tw.gov.mohw.nhi.ci.json)

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (tw.gov.mohw.nhi.ci.r4)](package.r4.tgz) and [R4B (tw.gov.mohw.nhi.ci.r4b)](package.r4b.tgz) are available. 

#### IG Dependencies

This IG Contains the following dependencies on other IGs.







#### Global Profiles

*There are no Global profiles defined*

#### Copyrights

This publication includes IP covered under the following statements.

* These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright Â© 2011 by the National Electrical Manufacturers Association.

* DICOM Controlled Terminology Definitions: [Bundle/bun-min](Bundle-bun-min.md), [Bundle/bun-noillness](Bundle-bun-noillness.md), [QuestionnaireResponse/queRes-min](QuestionnaireResponse-queRes-min.md) and [QuestionnaireResponse/queRes-noillness](QuestionnaireResponse-queRes-noillness.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/bun-min](Bundle-bun-min.md), [Bundle/bun-noillness](Bundle-bun-noillness.md)...Show 5 more,[CatastrophicIllnessForm](Questionnaire-apply-catastrophic-illness.md),[LOINCReportType](ValueSet-loinc-report-type.md),[QuestionnaireResponse/queRes-min](QuestionnaireResponse-queRes-min.md),[QuestionnaireResponse/queRes-noillness](QuestionnaireResponse-queRes-noillness.md)and[QuestionnaireResponseTWCI](StructureDefinition-QuestionnaireResponse-twci.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [Bundle/bun-min](Bundle-bun-min.md), [Bundle/bun-noillness](Bundle-bun-noillness.md)...Show 4 more,[CatastrophicIllnessForm](Questionnaire-apply-catastrophic-illness.md),[QuestionnaireResponse/queRes-min](QuestionnaireResponse-queRes-min.md),[QuestionnaireResponse/queRes-noillness](QuestionnaireResponse-queRes-noillness.md)and[SNOMEDCTBodySite](ValueSet-body-site.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Condition Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-category.html): [ConditionTWCI](StructureDefinition-Condition-twci.md) and [NHICICategory](ValueSet-nhi-category.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-clinical.html): [Bundle/bun-min](Bundle-bun-min.md), [Bundle/bun-noillness](Bundle-bun-noillness.md) and [Condition/con-min](Condition-con-min.md)
* [identifierType](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0203.html): [Bundle/bun-min](Bundle-bun-min.md), [Bundle/bun-noillness](Bundle-bun-noillness.md) and [Patient/pat-min](Patient-pat-min.md)


* World Health Organization (WHO)

* [臺灣健保署2023年中文版ICD-10-CM](https://twcore.mohw.gov.tw/ig/twcore/0.3.2/ValueSet-icd-10-cm-2023-tw.html): [Bundle/bun-min](Bundle-bun-min.md), [Bundle/bun-noillness](Bundle-bun-noillness.md)...Show 6 more,[CatastrophicIllnessForm](Questionnaire-apply-catastrophic-illness.md),[NHIDiagCodeICD](ValueSet-nhi-diag-code-icd.md),[NHIPrimaryCancerICD](ValueSet-nhi-primary-cancer-icd.md),[QuestionnaireResponse/queRes-min](QuestionnaireResponse-queRes-min.md),[QuestionnaireResponse/queRes-noillness](QuestionnaireResponse-queRes-noillness.md)and[QuestionnaireResponseTWCI](StructureDefinition-QuestionnaireResponse-twci.md)
* [臺灣健保署2023年中文版ICD-10-PCS](https://twcore.mohw.gov.tw/ig/twcore/0.3.2/ValueSet-icd-10-pcs-2023-tw.html): [Bundle/bun-min](Bundle-bun-min.md), [Bundle/bun-noillness](Bundle-bun-noillness.md)...Show 4 more,[CatastrophicIllnessForm](Questionnaire-apply-catastrophic-illness.md),[ICD10PCS2023Image](ValueSet-icd-10-pcs-2023-image.md),[QuestionnaireResponse/queRes-min](QuestionnaireResponse-queRes-min.md)and[QuestionnaireResponse/queRes-noillness](QuestionnaireResponse-queRes-noillness.md)


* 中華郵政

* [臺灣中華郵政3碼郵遞區號](https://twcore.mohw.gov.tw/ig/twcore/0.3.2/CodeSystem-postal-code3-tw.html): [Bundle/bun-min](Bundle-bun-min.md), [Bundle/bun-noillness](Bundle-bun-noillness.md) and [Patient/pat-min](Patient-pat-min.md)


