# 重大傷病 - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **重大傷病**

## Example Condition: 重大傷病

Profile: [重大傷病-Condition TWCI](StructureDefinition-Condition-twci.md)

**病情狀態**：Active ([ConditionClinicalStatusCodes](https://hl7.org/fhir/R4/codesystem-condition-clinical.html/)#active)

**重大傷病類別**：癌症 ([ConditionClinicalStatusCodes](ValueSet-nhi-category.md/)#01)

**病人**：[Patient/pat-min](Patient-pat-min.md)



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "con-min",
  "meta" : {
    "profile" : [
      "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Condition-twci"
    ]
  },
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "https://nhicore.nhi.gov.tw/ci/CodeSystem/nhi-category",
          "code" : "01"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/pat-min"
  }
}

```
