# 臺灣重大傷病-用戶端(TWCI Client) - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **臺灣重大傷病-用戶端(TWCI Client)**

## CapabilityStatement: 臺灣重大傷病-用戶端(TWCI Client) 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/ci/CapabilityStatement/CapabilityStatementTWCIClient | *Version*:1.0.2 |
| Active as of 2025-11-07 | *Computable Name*:CapabilityStatementTWCIClient |

 
臺灣健保重大傷病實作指引(TWCI IG)用戶端(Client)之能力聲明 

 [Raw OpenAPI-Swagger Definition file](CapabilityStatementTWCIClient.openapi.json) | [Download](CapabilityStatementTWCIClient.openapi.json) 

## 臺灣重大傷病-用戶端(TWCI Client)

* 實作指引版本：1.0.2
* FHIR版本：4.0.1
* 支援格式：`json`, `xml`
* 發佈日：2025-11-07
* 發佈者：衛生福利部中央健康保險署

### 建議應該（SHOULD）支援以下實作指引

* [臺灣重大傷病實作指引 (TWCI IG)](index.md)

## Client的FHIR RESTful功能要求

### 模式：client

臺灣重大傷病-用戶端(TWCI Client)**必須(SHALL)**：
(1)使用使用臺灣重大傷病伺服端（TWCI Server）能力聲明中的查詢參數，支援讀取和查詢一個或多個臺灣重大傷病Profile(s)。

安全性：
(1)有關要求和建議，請參閱[安全性](security.md)。

### Resources或Profiles的RESTful功能

#### Summary

共有六類Resources支援查詢，查詢參數如表列：

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [Bundle](#Bundle1-1) | [重大傷病申請證明-Bundle TWCI](StructureDefinition-Bundle-twci.md) | y | y | y |  | y | _id |
| [Questionnaire](#Questionnaire1-2) | [重大傷病申請書-Questionnaire TWCI](StructureDefinition-Questionnaire-twci.md) | y | y | y |  | y |  |
| [QuestionnaireResponse](#QuestionnaireResponse1-3) | [重大傷病申請書回覆-QuestionnaireResponse TWCI](StructureDefinition-QuestionnaireResponse-twci.md) | y | y | y |  | y |  |
| [Task](#Task1-4) | [重大傷病申請-Task TWCI](StructureDefinition-Task-twci.md) | y | y | y |  | y | period, patient, authored-on, modified, identifier, status |
| [Patient](#Patient1-5) | [病人資訊-Patient TWCI](StructureDefinition-Patient-twci.md) | y | y | y |  | y | name, identifier |
| [Condition](#Condition1-6) | [重大傷病-Condition TWCI](StructureDefinition-Condition-twci.md) | y | y | y |  | y |  |

-------

#### 預期的遵從度： 必須（SHALL） Bundle

Profile

[重大傷病申請證明-Bundle TWCI](StructureDefinition-Bundle-twci.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **SHALL** 支援 `create`, `read`, `vread`, `update`.

Search Parameters


 

#### 預期的遵從度： 必須（SHALL） Questionnaire

Profile

[重大傷病申請書-Questionnaire TWCI](StructureDefinition-Questionnaire-twci.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **SHALL** 支援 `create`, `read`, `vread`, `update`.

#### 預期的遵從度： 必須（SHALL） QuestionnaireResponse

Profile

[重大傷病申請書回覆-QuestionnaireResponse TWCI](StructureDefinition-QuestionnaireResponse-twci.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **SHALL** 支援 `create`, `read`, `vread`, `update`.

#### 預期的遵從度： 必須（SHALL） Task

Profile

[重大傷病申請-Task TWCI](StructureDefinition-Task-twci.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **SHALL** 支援 `create`, `read`, `vread`, `update`.

Search Parameters


 

#### 預期的遵從度： 必須（SHALL） Patient

Profile

[病人資訊-Patient TWCI](StructureDefinition-Patient-twci.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **SHALL** 支援 `create`, `read`, `vread`, `update`.

Search Parameters


 

#### 預期的遵從度： 必須（SHALL） Condition

Profile

[重大傷病-Condition TWCI](StructureDefinition-Condition-twci.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **SHALL** 支援 `create`, `read`, `vread`, `update`.



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "CapabilityStatementTWCIClient",
  "url" : "https://nhicore.nhi.gov.tw/ci/CapabilityStatement/CapabilityStatementTWCIClient",
  "version" : "1.0.2",
  "name" : "CapabilityStatementTWCIClient",
  "title" : "臺灣重大傷病-用戶端(TWCI Client)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-07",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣健保重大傷病實作指引(TWCI IG)用戶端(Client)之能力聲明",
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["json", "xml"],
  "patchFormat" : ["application/json-patch+json"],
  "implementationGuide" : [
    "https://nhicore.nhi.gov.tw/ci/ImplementationGuide/tw.gov.mohw.nhi.ci"
  ],
  "rest" : [
    {
      "mode" : "client",
      "documentation" : "臺灣重大傷病-用戶端(TWCI Client)必須（SHALL）使用臺灣重大傷病伺服端（TWCI Server）能力聲明中的查詢參數，支援讀取和查詢一個或多個臺灣重大傷病Profile(s)。",
      "security" : {
        "description" : "有關要求和建議，請參閱[安全性](security.html)。"
      },
      "resource" : [
        {
          "type" : "Bundle",
          "profile" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Bundle-twci",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "_id",
              "definition" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Bundle-id",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Questionnaire",
          "profile" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Questionnaire-twci",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "QuestionnaireResponse",
          "profile" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "Task",
          "profile" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Task-twci",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "period",
              "definition" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Task-period",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient",
              "definition" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Task-patient",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "authored-on",
              "definition" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Task-authored-on",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "modified",
              "definition" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Task-modified",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "identifier",
              "definition" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Task-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "status",
              "definition" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Task-status",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Patient",
          "profile" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "name",
              "definition" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Patient-name",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "identifier",
              "definition" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Patient-identifier",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Condition",
          "profile" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Condition-twci",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        }
      ]
    }
  ]
}

```
