# tw.gov.mohw.nhi.ci#1.0.2: 臺灣重大傷病實作指引

## Pages

* [應用說明](index.md)
* [安全性](security.md)
* [驗證教學](validate.md)
* [邏輯模型](models.md)
* [查詢參數](searchparameters.md)
* [FHIR Profiles](profiles.md)
* [視覺化邏輯模型](vision.md)
* [結構定義與範例檔下載](downloads.md)
* [能力聲明](capabilitystatements.md)
* [範例](examples.md)
* [TWCI ImplementationGuide Resource](ImplementationGuide-tw.gov.mohw.nhi.ci.md)
* [Artifacts Summary](artifacts.md)
* [專門術語](terminologies.md)

## Resources

### CodeSystems

* [NHI-健保重大傷病-癌症期別](CodeSystem-cancer-stage.md)
* [NHI-健保重大傷病-申報方式](CodeSystem-nhi-apply-mode.md)
* [NHI-健保重大傷病-申報類別](CodeSystem-nhi-apply-type.md)
* [NHI-健保重大傷病-核定結果](CodeSystem-nhi-approve-result.md)
* [NHI-健保重大傷病-後續治療計劃](CodeSystem-nhi-cancer-treatment-plan.md)
* [NHI-健保重大傷病-後續治療評估](CodeSystem-nhi-cancer-treatment.md)
* [NHI-健保重大傷病-癌症狀態](CodeSystem-nhi-cancerstage-status.md)
* [NHI-健保重大傷病-癌症最初診斷AJCC分期](CodeSystem-nhi-cancerstaging.md)
* [NHI-健保重大傷病-重大傷病類別](CodeSystem-nhi-category.md)
* [NHI-健保重大傷病-特約醫事機構](CodeSystem-organization-identifier-tw.md)

### ValueSets

* [SNOMEDCT-健保重大傷病-身體部位值集](ValueSet-body-site.md)
* [NHI-健保重大傷病-癌症期別值集](ValueSet-cancer-stage.md)
* [NHI-健保重大傷病-臺灣健保署2023年中文版ICD 10 PCS-影像報告值集](ValueSet-icd-10-pcs-2023-image.md)
* [LOINC-健保重大傷病-報告類型值集](ValueSet-loinc-report-type.md)
* [HL7-健保重大傷病-非DICOM影像MimeType值集](ValueSet-media-mimetypes.md)
* [NHI-健保重大傷病-申報方式值集](ValueSet-nhi-apply-mode.md)
* [NHI-健保重大傷病-申報類別值集](ValueSet-nhi-apply-type.md)
* [NHI-健保重大傷病-核定結果值集](ValueSet-nhi-approve-result.md)
* [NHI-健保重大傷病-後續治療計劃值集](ValueSet-nhi-cancer-treatment-plan.md)
* [NHI-健保重大傷病-後續治療評估值集](ValueSet-nhi-cancer-treatment.md)
* [NHI-健保重大傷病-癌症狀態](ValueSet-nhi-cancerstage-status.md)
* [NHI-健保重大傷病-癌症最初診斷AJCC分期值集](ValueSet-nhi-cancerstaging.md)
* [NHI-健保重大傷病-重大傷病類別值集](ValueSet-nhi-category.md)
* [NHI-健保重大傷病-ICD-CM-重大傷病診斷代碼值集](ValueSet-nhi-diag-code-icd.md)
* [NHI-健保重大傷病-特約醫事機構值集](ValueSet-nhi-organization.md)
* [NHI-健保重大傷病-ICD-CM-原發癌症診斷碼值集](ValueSet-nhi-primary-cancer-icd.md)

### Logicals

* [申請(Apply)重大傷病申請書之資料模型](StructureDefinition-ApplyModel.md)

### Resource Profiles

* [重大傷病申請證明-Bundle TWCI](StructureDefinition-Bundle-twci.md)
* [重大傷病-Condition TWCI](StructureDefinition-Condition-twci.md)
* [病人資訊-Patient TWCI](StructureDefinition-Patient-twci.md)
* [重大傷病申請書-Questionnaire TWCI](StructureDefinition-Questionnaire-twci.md)
* [重大傷病申請書回覆-QuestionnaireResponse TWCI](StructureDefinition-QuestionnaireResponse-twci.md)
* [重大傷病申請-Task TWCI](StructureDefinition-Task-twci.md)

### CapabilityStatements

* [臺灣重大傷病-用戶端(TWCI Client)](CapabilityStatement-CapabilityStatementTWCIClient.md)
* [臺灣重大傷病-伺服端(TWCI Server)](CapabilityStatement-CapabilityStatementTWCIServer.md)

### ImplementationGuides

* [臺灣重大傷病實作指引](index.md)

### SearchParameters

* [BundleID](SearchParameter-Bundle-id.md)
* [PatientIdentifier](SearchParameter-Patient-identifier.md)
* [PatientName](SearchParameter-Patient-name.md)
* [TaskAuthoredOn](SearchParameter-Task-authored-on.md)
* [TaskIdentifier](SearchParameter-Task-identifier.md)
* [TaskModified](SearchParameter-Task-modified.md)
* [TaskPatient](SearchParameter-Task-patient.md)
* [TaskPeriod](SearchParameter-Task-period.md)
* [TaskStatus](SearchParameter-Task-status.md)

### Examples

* [bun-min (Bundle)](Bundle-bun-min.md)
* [bun-noillness (Bundle)](Bundle-bun-noillness.md)
* [con-min (Condition)](Condition-con-min.md)
* [pat-min (Patient)](Patient-pat-min.md)
* [Catastrophic-Illness-Form (Questionnaire)](Questionnaire-apply-catastrophic-illness.md)
* [queRes-min (QuestionnaireResponse)](QuestionnaireResponse-queRes-min.md)
* [queRes-noillness (QuestionnaireResponse)](QuestionnaireResponse-queRes-noillness.md)
* [tas-min (Task)](Task-tas-min.md)
* [tas-noillness (Task)](Task-tas-noillness.md)
