# 應用說明 - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* **應用說明**

## 應用說明

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/ci/ImplementationGuide/tw.gov.mohw.nhi.ci | *Version*:1.0.2 |
| Active as of 2025-11-12 | *Computable Name*:TWCI |

**請注意**：您目前所看到的IG為持續建置(ci-build)版，主要依據實作者及健保署端的業務需求即時調整V1.0.1版內容，因而會比健保署的IG版本V1.0.1(https://nhicore.nhi.gov.tw/ci/)內容新，僅供未來想以最新版本規格進行資料上傳的人員參考，下次更新版本號時間未定，屆時才會調整相應版本的健保署FHIR伺服器規格。
 
 **醫院實作時請以V1.0.1為主進行實例驗證，目前健保署端的伺服器採用V1.0.1版規格。**

**相關資訊可參考衛生福利部中央健康保險署的[癌症重大傷病申請導入FHIR](https://www.nhi.gov.tw/ch/np-3788-1.html)。**

因考量實作需求，於2025/11/12異動以下內容：
1. 新增[Example Task: 重大傷病申請-無換發評估表](Task-tas-noillness.md)並修改[Example Bundle: 重大傷病申請證明-無換發評估表](Bundle-bun-noillness.md)。
請留意這些異動，以避免影響您的實作。

### 專案介紹

臺灣健保重大傷病實作指引(Taiwan NHI Catastrophic Illness Implementation Guide，TWCI IG)採用HL7® FHIR® standard（Fast Healthcare Interoperability Resources）IG建置方法，在[FHIR R4.0.1](http://hl7.org/fhir/R4/)之標準基礎上，繼承TW Core IG V0.3.2 (2024-12-12)，進一步定義適用於「重大傷病」資料需求的Resources（類似資料表）、其中的資料項目（意即欄位）、基數（意即0..1、0..*、1..1或1..*）及資料類型（文字、日期時間、代碼等）等。

### 專案背景

衛生福利部中央健康保險署規劃癌症重大傷病上傳機制，係配合賴總統於健康台灣之「國家癌症防治計畫」政策，刻正規劃NGS申報資料收載、癌症重大傷病申請、癌藥事前審查申請及癌症個案療效追蹤等癌症醫療資訊之數位轉型，期透過資料有效互通，達成以病人為中心之完整照護。

### 專案範圍

#### 使用案例(Use Case)

本專案之主要實作者為醫院，醫院透過此系統，協助保險對象申請重大傷病，透過共通傳輸平台批次上傳重大傷病申請證明書相關文件，並送至衛生福利部中央健康保險署審核。

#### 循序圖

送核、送核補件、申復及申復補件之作業流程皆相同，依該個案是首次送審或不同意後再次送審等之狀態進行選擇不同的申請類別，以做為行政程序之判斷。

送核、送核補件、申復及申復補件作業流程如下：

1. 醫院開發重大傷病系統產生重大傷病申請證明（Bundle TWCI）
1. 醫院將已產生之重大傷病申請證明相關文件上傳至健保署
1. 若資料符合格式，健保署回覆上傳成功訊息，由醫院查詢上傳結果
1. 若資料不符合格式，健保署回覆上傳失敗訊息，由醫院查詢上傳結果
1. 資料上傳成功後，健保署申請證明通過，由醫院查詢申請結果
1. 資料上傳成功後，健保署申請證明未通過，由醫院查詢申請結果![](sequence.png)

### 如何閱讀這個實作指引(IG)

TWCI IG之網站架構圖如下圖所示。各功能說明如下：

* **[應用說明](index.md)**：TWCI IG介紹及背景說明。
* **[視覺化邏輯模型](vision.md)**：TWCI IG邏輯模型架構視覺化圖。
* **[規範文件](artifacts.md)** 
* **[能力聲明](capabilitystatements.md)**：應用TWCI IG於建置業務目的使用的FHIR Server時，該FHIR Server必須及建議應該支援的資料存取功能。 
* **[邏輯模型](models.md)**：TWCI IG的所有邏輯模型(Logical Models)，邏輯模型會定義相應情境下使用的所有資料欄位。為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」瞭解各資料欄位實際使用TWCI IG的哪個Profiles的哪個資料項目(element)。 
* **[FHIR Profiles](profiles.md)**： 
* TWCI IG的所有Profiles之定義與範例。
* 各資料項目不同實作強制程度的Terminology。
 
* **[專門術語](terminologies.md)**：TWCI IG所使用的專門術語，包括代碼系統（Code Systems）及值集（Value Sets）。 
 
* **[範例](examples.md)**：TWCI IG所定義Profiles之範例檔。
* **[定義與範例檔下載](downloads.md)**：實作者若不偏好使用FHIR RESTful API驗證資料是否符合Profiles，可直接下載所需的格式驗證檔，包括XML、JSON及Turtle三種格式，亦可於此下載完整範例檔。
* **[安全性](security.md)**：主要說明採用TWCI IG網站進行實作時，有關資料存取授權的作法。
* **[版本異動](https://vacc.cdc.gov.tw/vacc/history.html)**：若TWCI IG網站的版本有所異動，皆可透過[異動說明頁](https://vacc.cdc.gov.tw/vacc/history.html)得以瞭解版本間的異動差異。

### 作者與貢獻者

| | | |
| :--- | :--- | :--- |
| 作者-IG | 李麗惠 | 國立臺北護理健康大學-健康事業管理系 |
| 作者-IG | 曾鈺珈 | |
| 作者-IG | 黃甄翔 | |
| 貢獻者-IG | 王智廣 | 衛生福利部中央健康保險署-醫務管理組 |
| 貢獻者-IG | 宋怡慧 | |
| 貢獻者-IG | 衛生福利部中央健康保險署-資訊組 | |
| 貢獻者-IG | 衛生福利部資訊處 | |

如醫院有參與意願申請加入癌症重大傷病導入FHIR試辦院所，或對資料內容、代碼檔、IG有任何疑問，

請先洽(02)2706-5866#2610 宋小姐

*若民眾對事前審查案申請案件有疑義，請洽各分區業務組。

