# Artifacts Summary - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [臺灣重大傷病-伺服端(TWCI Server)](CapabilityStatement-CapabilityStatementTWCIServer.md) | 臺灣健保重大傷病實作指引(TWCI IG)伺服端(Server)之能力聲明 |
| [臺灣重大傷病-用戶端(TWCI Client)](CapabilityStatement-CapabilityStatementTWCIClient.md) | 臺灣健保重大傷病實作指引(TWCI IG)用戶端(Client)之能力聲明 |

### Behavior: Search Parameters 

These define the properties by which a RESTful server can be searched. They can also be used for sorting and including related resources.

| | |
| :--- | :--- |
| [Bundle-id](SearchParameter-Bundle-id.md) | 重大傷病申請證明(Bundle)的邏輯性ID |
| [Patient-identifier](SearchParameter-Patient-identifier.md) | 病人的身分證號(identifier) |
| [Patient-name](SearchParameter-Patient-name.md) | 病人的姓名(name)，該查詢可能與 HumanName 中的任何字串匹配，包括完整的中文姓名(text)、英文姓(family)、英文名(given)、姓名前面的頭銜(prefix)、姓名後面的稱謂(suffix)。 |
| [Task-authored-on](SearchParameter-Task-authored-on.md) | 重大傷病申請(Task)的收件日期(authoredOn) |
| [Task-identifier](SearchParameter-Task-identifier.md) | 重大傷病申請(Task)的核定日期(identifier) |
| [Task-modified](SearchParameter-Task-modified.md) | 重大傷病申請(Task)的核定日期(lastModified) |
| [Task-patient](SearchParameter-Task-patient.md) | 重大傷病申請(Task)的對象(patient) |
| [Task-period](SearchParameter-Task-period.md) | 重大傷病申請(Task)的受理日期(executionPeriod) |
| [Task-status](SearchParameter-Task-status.md) | 重大傷病申請(Task)的查詢進度(status) |

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [申請(Apply)重大傷病申請書之資料模型](StructureDefinition-ApplyModel.md) | 申請(Apply)重大傷病之資料模型，此邏輯模型為定義重大傷病情境下使用的所有資料欄位。 為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」 瞭解各資料欄位實際使用TWCI IG的哪個Profiles的哪個資料項目（element）。亦可配合 [視覺化邏輯模型圖]進行欄位對應。 |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [病人資訊-Patient TWCI](StructureDefinition-Patient-twci.md) | 此病人資訊-Patient TWCI Profile說明TWCI IG如何進一步定義臺灣核心-病人(TW Core Patient) Profile以呈現重大傷病之病人基本資料 |
| [重大傷病-Condition TWCI](StructureDefinition-Condition-twci.md) | 此重大傷病-Condition TWCI Profile說明TWCI IG如何進一步定義臺灣核心-病情、問題或診斷（TW Core Condition） Profile以呈現重大傷病之內容 |
| [重大傷病申請-Task TWCI](StructureDefinition-Task-twci.md) | 此重大傷病申請-Task TWCI Profile說明TWCI IG如何進一步定義FHIR的Task Resource以呈現重大傷病申請之內容 |
| [重大傷病申請書-Questionnaire TWCI](StructureDefinition-Questionnaire-twci.md) | 此重大傷病申請書-Questionnaire TWCI Profile說明TWCI IG如何進一步定義FHIR的Questionnaire Resource以呈現重大傷病申請書中之內容 |
| [重大傷病申請書回覆-QuestionnaireResponse TWCI](StructureDefinition-QuestionnaireResponse-twci.md) | 此重大傷病申請書回覆-QuestionnaireResponse TWCI Profile說明TWCI IG如何進一步定義FHIR的QuestionnaireResponse Resource以呈現重大傷病申請書回覆中之內容 |
| [重大傷病申請證明-Bundle TWCI](StructureDefinition-Bundle-twci.md) | 此重大傷病申請證明-Bundle TWCI Profile說明TWCI IG如何進一步定義臺灣核心-資料交換基本單位（TW Core Bundle） Profile以呈現重大傷病申請證明之內容 |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [HL7-健保重大傷病-非DICOM影像MimeType值集](ValueSet-media-mimetypes.md) | HL7-健保重大傷病-非DICOM影像MimeType值集 |
| [LOINC-健保重大傷病-報告類型值集](ValueSet-loinc-report-type.md) | LOINC-健保重大傷病-報告類型值集 |
| [NHI-健保重大傷病-ICD-CM-原發癌症診斷碼值集](ValueSet-nhi-primary-cancer-icd.md) | NHI-健保重大傷病-ICD-CM-原發癌症診斷碼值集 |
| [NHI-健保重大傷病-ICD-CM-重大傷病診斷代碼值集](ValueSet-nhi-diag-code-icd.md) | NHI-健保重大傷病-ICD-CM-重大傷病診斷代碼值集 |
| [NHI-健保重大傷病-後續治療計劃值集](ValueSet-nhi-cancer-treatment-plan.md) | NHI-健保重大傷病-後續治療計劃值集 |
| [NHI-健保重大傷病-後續治療評估值集](ValueSet-nhi-cancer-treatment.md) | NHI-健保重大傷病-後續治療評估值集 |
| [NHI-健保重大傷病-核定結果值集](ValueSet-nhi-approve-result.md) | NHI-健保重大傷病-核定結果值集 |
| [NHI-健保重大傷病-特約醫事機構值集](ValueSet-nhi-organization.md) | NHI-健保重大傷病-特約醫事機構值集，參照至[衛福部健保署特約醫事機構代碼網路查詢服務](https://www.nhi.gov.tw/ch/cp-5548-135e8-2931-1.html)中的[健保特約醫療院所名冊](https://info.nhi.gov.tw/IODE0000/IODE0000S09?id=1120)代碼出版日期：2024-04-22；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** |
| [NHI-健保重大傷病-申報方式值集](ValueSet-nhi-apply-mode.md) | NHI-健保重大傷病-申報方式值集 |
| [NHI-健保重大傷病-申報類別值集](ValueSet-nhi-apply-type.md) | NHI-健保重大傷病-申報類別值集 |
| [NHI-健保重大傷病-癌症最初診斷AJCC分期值集](ValueSet-nhi-cancerstaging.md) | NHI-健保重大傷病-癌症最初診斷AJCC分期值集 |
| [NHI-健保重大傷病-癌症期別值集](ValueSet-cancer-stage.md) | NHI-健保重大傷病-癌症期別值集 |
| [NHI-健保重大傷病-癌症狀態](ValueSet-nhi-cancerstage-status.md) | NHI-健保重大傷病-癌症狀態 |
| [NHI-健保重大傷病-臺灣健保署2023年中文版ICD 10 PCS-影像報告值集](ValueSet-icd-10-pcs-2023-image.md) | NHI-健保重大傷病-臺灣健保署2023年中文版ICD 10 PCS-影像報告值集 |
| [NHI-健保重大傷病-重大傷病類別值集](ValueSet-nhi-category.md) | NHI-健保重大傷病-重大傷病類別值集 |
| [SNOMEDCT-健保重大傷病-身體部位值集](ValueSet-body-site.md) | SNOMEDCT-健保重大傷病-身體部位值集，代碼對應請參考[臺灣健保署身體部位代碼對應SNOMED CT](https://build.fhir.org/ig/TWNHIFHIR/pas/ConceptMap-nhi-sct-body-site.html)。 |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [NHI-健保重大傷病-後續治療計劃](CodeSystem-nhi-cancer-treatment-plan.md) | 臺灣衛生福利部中央健康保險署「後續治療計劃」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。參照自[重大傷病專區](https://www.nhi.gov.tw/ch/np-2957-1.html)中申請須知及文件下載的[惡性腫瘤重大傷病證明換發評估表(自105年1月1日適用)(104.12.22更新)](https://www.nhi.gov.tw/ch/dl-30060-83fc8c0cada24dae8f3c5d5a98201aee-1.odt) |
| [NHI-健保重大傷病-後續治療評估](CodeSystem-nhi-cancer-treatment.md) | 臺灣衛生福利部中央健康保險署「後續治療評估」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。參照自[重大傷病專區](https://www.nhi.gov.tw/ch/np-2957-1.html)中申請須知及文件下載的[惡性腫瘤重大傷病證明換發評估表(自105年1月1日適用)(104.12.22更新)](https://www.nhi.gov.tw/ch/dl-30060-83fc8c0cada24dae8f3c5d5a98201aee-1.odt) |
| [NHI-健保重大傷病-核定結果](CodeSystem-nhi-approve-result.md) | 臺灣衛生福利部中央健康保險署「核定結果」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保重大傷病-特約醫事機構](CodeSystem-organization-identifier-tw.md) | 臺灣衛生福利部中央健康保險署「特約醫事機構」代碼，參照至[衛福部健保署特約醫事機構代碼網路查詢服務](https://www.nhi.gov.tw/ch/cp-5548-135e8-2931-1.html)中的[健保特約醫療院所名冊](https://info.nhi.gov.tw/IODE0000/IODE0000S09?id=1120)代碼出版日期：2024-04-22；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** |
| [NHI-健保重大傷病-申報方式](CodeSystem-nhi-apply-mode.md) | 臺灣衛生福利部中央健康保險署「申報方式」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保重大傷病-申報類別](CodeSystem-nhi-apply-type.md) | 臺灣衛生福利部中央健康保險署「申報類別」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保重大傷病-癌症最初診斷AJCC分期](CodeSystem-nhi-cancerstaging.md) | 臺灣衛生福利部中央健康保險署「癌症最初診斷AJCC分期」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保重大傷病-癌症期別](CodeSystem-cancer-stage.md) | 臺灣衛生福利部中央健康保險署「癌症期別」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保重大傷病-癌症狀態](CodeSystem-nhi-cancerstage-status.md) | 臺灣衛生福利部中央健康保險署「癌症狀態」代碼，代碼出版日期：2025-11-07；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保重大傷病-重大傷病類別](CodeSystem-nhi-category.md) | 臺灣衛生福利部中央健康保險署「重大傷病類別」代碼，代碼出版日期：2024-09-20；資料所屬單位：臺灣衛生福利部中央健康保險署。 |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [病人資訊](Patient-pat-min.md) | 依據病人資訊-Patient TWCI Profile呈現病人基本資料之範例 |
| [重大傷病](Condition-con-min.md) | 依據重大傷病-Condition TWCI Profile呈現重大傷病之範例 |
| [重大傷病申請](Task-tas-min.md) | 依據重大傷病申請-Task TWCI Profile呈現重大傷病申請之範例 |
| [重大傷病申請-無換發評估表](Task-tas-noillness.md) | 依據重大傷病申請-Task TWCI Profile呈現重大傷病申請-無換發評估表之範例 |
| [重大傷病申請書](Questionnaire-apply-catastrophic-illness.md) | 依據重大傷病申請書-Questionnaire TWCI Profile呈現重大傷病申請書之範例 |
| [重大傷病申請書回覆](QuestionnaireResponse-queRes-min.md) | 依據重大傷病申請書回覆-QuestionnaireResponse TWCI Profile呈現重大傷病申請書回覆之範例 |
| [重大傷病申請書回覆(無換發評估表、多筆檢查報告)](QuestionnaireResponse-queRes-noillness.md) | 依據重大傷病申請書回覆-QuestionnaireResponse TWCI Profile呈現重大傷病申請書回覆(無換發評估表、多筆檢查報告)之範例 |
| [重大傷病申請證明-無換發評估表](Bundle-bun-noillness.md) | 依據重大傷病申請證明-Bundle TWCI Profile呈現重大傷病申請證明-無換發評估表之範例 |
| [重大傷病申請證明-送核](Bundle-bun-min.md) | 依據重大傷病申請證明-Bundle TWCI Profile呈現重大傷病申請證明之範例 |

