# NHI-健保重大傷病-ICD-CM-原發癌症診斷碼值集 - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NHI-健保重大傷病-ICD-CM-原發癌症診斷碼值集**

## ValueSet: NHI-健保重大傷病-ICD-CM-原發癌症診斷碼值集 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-primary-cancer-icd | *Version*:1.0.2 |
| Active as of 2025-11-07 | *Computable Name*:NHIPrimaryCancerICD |

 
NHI-健保重大傷病-ICD-CM-原發癌症診斷碼值集 

 **References** 

* [重大傷病申請書回覆-QuestionnaireResponse TWCI](StructureDefinition-QuestionnaireResponse-twci.md)
* [Catastrophic-Illness-Form](Questionnaire-apply-catastrophic-illness.md)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include codes from[`https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-cm-2023-tw`](https://twcore.mohw.gov.tw/ig/twcore/0.3.2/ValueSet-icd-10-cm-2023-tw.html)version 📦2024-11-18 where USE = 1
* Include all codes defined in [`https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-9-cm-2001-tw`](https://twcore.mohw.gov.tw/ig/twcore/0.3.2/CodeSystem-icd-9-cm-2001-tw.html)version 📦2023-05-09

 

### Expansion

This value set has 90,030 codes in it. In order to keep the publication size manageable, only a selection (1,000 codes) of the whole set of codes is shown.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "nhi-primary-cancer-icd",
  "url" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-primary-cancer-icd",
  "version" : "1.0.2",
  "name" : "NHIPrimaryCancerICD",
  "title" : "NHI-健保重大傷病-ICD-CM-原發癌症診斷碼值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-07",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "NHI-健保重大傷病-ICD-CM-原發癌症診斷碼值集",
  "compose" : {
    "include" : [
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-cm-2023-tw",
        "filter" : [
          {
            "property" : "USE",
            "op" : "=",
            "value" : "1"
          }
        ]
      },
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-9-cm-2001-tw"
      }
    ]
  }
}

```
