# NHI-健保重大傷病-核定結果值集 - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NHI-健保重大傷病-核定結果值集**

## ValueSet: NHI-健保重大傷病-核定結果值集 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-approve-result | *Version*:1.0.2 |
| Active as of 2025-11-07 | *Computable Name*:NHICIApproveResult |

 
NHI-健保重大傷病-核定結果值集 

 **References** 

* [重大傷病申請-Task TWCI](StructureDefinition-Task-twci.md)

### Logical Definition (CLD)

* Include all codes defined in [`https://nhicore.nhi.gov.tw/ci/CodeSystem/nhi-approve-result`](CodeSystem-nhi-approve-result.md)version 📦1.0.2

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "nhi-approve-result",
  "url" : "https://nhicore.nhi.gov.tw/ci/ValueSet/nhi-approve-result",
  "version" : "1.0.2",
  "name" : "NHICIApproveResult",
  "title" : "NHI-健保重大傷病-核定結果值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-07",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "NHI-健保重大傷病-核定結果值集",
  "compose" : {
    "include" : [
      {
        "system" : "https://nhicore.nhi.gov.tw/ci/CodeSystem/nhi-approve-result"
      }
    ]
  }
}

```
