# LOINC-健保重大傷病-報告類型值集 - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **LOINC-健保重大傷病-報告類型值集**

## ValueSet: LOINC-健保重大傷病-報告類型值集 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/ci/ValueSet/loinc-report-type | *Version*:1.0.2 |
| Active as of 2025-11-07 | *Computable Name*:LOINCReportType |

 
LOINC-健保重大傷病-報告類型值集 

 **References** 

* [重大傷病申請書回覆-QuestionnaireResponse TWCI](StructureDefinition-QuestionnaireResponse-twci.md)
* [Catastrophic-Illness-Form](Questionnaire-apply-catastrophic-illness.md)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include codes from[`http://loinc.org`](http://loinc.org)version Not Stated (use latest from terminology server) where SCALE_TYP = LP32888-7 (Doc)
* Include codes from[`http://loinc.org`](http://loinc.org)version Not Stated (use latest from terminology server) where SCALE_TYP = LP7749-7 (Nar)

 

### Expansion

Expansion from tx.fhir.org based on Loinc v2.81

This value set has >1000 codes in it. In order to keep the publication size manageable, only a selection (1000 codes) of the whole set of codes is shown

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "loinc-report-type",
  "url" : "https://nhicore.nhi.gov.tw/ci/ValueSet/loinc-report-type",
  "version" : "1.0.2",
  "name" : "LOINCReportType",
  "title" : "LOINC-健保重大傷病-報告類型值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-07",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "LOINC-健保重大傷病-報告類型值集",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org",
        "filter" : [
          {
            "property" : "SCALE_TYP",
            "op" : "=",
            "value" : "LP32888-7"
          }
        ]
      },
      {
        "system" : "http://loinc.org",
        "filter" : [
          {
            "property" : "SCALE_TYP",
            "op" : "=",
            "value" : "LP7749-7"
          }
        ]
      }
    ]
  }
}

```
