# 病人資訊-Patient TWCI - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **病人資訊-Patient TWCI**

## Resource Profile: 病人資訊-Patient TWCI 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci | *Version*:1.0.2 |
| Active as of 2025-11-12 | *Computable Name*:PatientTWCI |

 
此病人資訊-Patient TWCI Profile說明TWCI IG如何進一步定義臺灣核心-病人(TW Core Patient) Profile以呈現重大傷病之病人基本資料 

**Usages:**

* Use this Profile: [重大傷病申請證明-Bundle TWCI](StructureDefinition-Bundle-twci.md)
* Refer to this Profile: [重大傷病-Condition TWCI](StructureDefinition-Condition-twci.md), [重大傷病申請書回覆-QuestionnaireResponse TWCI](StructureDefinition-QuestionnaireResponse-twci.md) and [重大傷病申請-Task TWCI](StructureDefinition-Task-twci.md)
* Examples for this Profile: [Patient/pat-min](Patient-pat-min.md)
* CapabilityStatements using this Profile: [臺灣重大傷病-用戶端(TWCI Client)](CapabilityStatement-CapabilityStatementTWCIClient.md) and [臺灣重大傷病-伺服端(TWCI Server)](CapabilityStatement-CapabilityStatementTWCIServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.ci|current/StructureDefinition/Patient-twci)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Patient-twci.csv), [Excel](StructureDefinition-Patient-twci.xlsx), [Schematron](StructureDefinition-Patient-twci.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TWCI支援的RESTful互動功能的完整清單，請參閱[TWCI Server能力聲明](CapabilityStatement-CapabilityStatementTWCIServer.md)。

#### 必須支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`name`](SearchParameter-Patient-name.md)**查詢所有Patient：
([如何透過string查詢](http://hl7.org/fhir/R4/search.html#string))
`GET [base]/Patient?name=[string]`例子：
(1) GET [base]/Patient?name=王大明
1. **必須（SHALL）**支援透過查詢參數**[`identifier`](SearchParameter-Patient-identifier.md)**查詢所有Patient：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Patient?identifier=[code]`例子：
(1) GET [base]/Patient?identifier=A123456789



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Patient-twci",
  "url" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci",
  "version" : "1.0.2",
  "name" : "PatientTWCI",
  "title" : "病人資訊-Patient TWCI",
  "status" : "active",
  "date" : "2025-11-12T05:05:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此病人資訊-Patient TWCI Profile說明TWCI IG如何進一步定義臺灣核心-病人(TW Core Patient) Profile以呈現重大傷病之病人基本資料",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "constraint" : [
          {
            "key" : "patient-gender-match",
            "severity" : "error",
            "human" : "gender依據identifier:idCardNumber第二位字符檢核男性與女性代碼 (1,8,A,C,Y=male, 2,9,B,D,X=female)",
            "expression" : "((identifier.where(system = 'http://www.moi.gov.tw').value.substring(1, 1) = '1' or\n  identifier.where(system = 'http://www.moi.gov.tw').value.substring(1, 1) = '8' or\n  identifier.where(system = 'http://www.moi.gov.tw').value.substring(1, 1) = 'A' or\n  identifier.where(system = 'http://www.moi.gov.tw').value.substring(1, 1) = 'C' or\n  identifier.where(system = 'http://www.moi.gov.tw').value.substring(1, 1) = 'Y') \n  implies gender = 'male') \nand \n((identifier.where(system = 'http://www.moi.gov.tw').value.substring(1, 1) = '2' or\n  identifier.where(system = 'http://www.moi.gov.tw').value.substring(1, 1) = '9' or\n  identifier.where(system = 'http://www.moi.gov.tw').value.substring(1, 1) = 'B' or\n  identifier.where(system = 'http://www.moi.gov.tw').value.substring(1, 1) = 'D' or\n  identifier.where(system = 'http://www.moi.gov.tw').value.substring(1, 1) = 'X') \n  implies gender = 'female')",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci"
          },
          {
            "key" : "telecom",
            "severity" : "error",
            "human" : "手機號碼與聯絡電話應至少填寫一欄。",
            "expression" : "telecom.where(system = 'sms').exists() or telecom.where(system = 'phone').exists()",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci"
          }
        ]
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "max" : "2"
      },
      {
        "id" : "Patient.identifier:idCardNumber",
        "path" : "Patient.identifier",
        "sliceName" : "idCardNumber",
        "short" : "身分證號",
        "min" : 1
      },
      {
        "id" : "Patient.identifier:idCardNumber.value",
        "path" : "Patient.identifier.value",
        "constraint" : [
          {
            "key" : "txt-10",
            "severity" : "error",
            "human" : "長度不得超過10字",
            "expression" : "length() <= 10",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci"
          }
        ]
      },
      {
        "id" : "Patient.identifier:passportNumber",
        "path" : "Patient.identifier",
        "sliceName" : "passportNumber",
        "max" : "0"
      },
      {
        "id" : "Patient.identifier:residentNumber",
        "path" : "Patient.identifier",
        "sliceName" : "residentNumber",
        "max" : "0"
      },
      {
        "id" : "Patient.identifier:medicalRecord",
        "path" : "Patient.identifier",
        "sliceName" : "medicalRecord",
        "short" : "病歷號(參與醫院必須註冊命名系統)。由醫院自行填寫。"
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "min" : 1,
        "max" : "1",
        "constraint" : [
          {
            "key" : "pat-name",
            "severity" : "error",
            "human" : "病人姓名有誤，超過12字",
            "expression" : "text.length() <= 12",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci"
          }
        ]
      },
      {
        "id" : "Patient.name:official",
        "path" : "Patient.name",
        "sliceName" : "official",
        "max" : "0"
      },
      {
        "id" : "Patient.name:usual",
        "path" : "Patient.name",
        "sliceName" : "usual",
        "short" : "姓名",
        "min" : 1
      },
      {
        "id" : "Patient.name:usual.text",
        "path" : "Patient.name.text",
        "min" : 1
      },
      {
        "id" : "Patient.name:temp",
        "path" : "Patient.name",
        "sliceName" : "temp",
        "max" : "0"
      },
      {
        "id" : "Patient.name:anonymous",
        "path" : "Patient.name",
        "sliceName" : "anonymous",
        "max" : "0"
      },
      {
        "id" : "Patient.telecom",
        "path" : "Patient.telecom",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "ordered" : false,
          "rules" : "closed"
        },
        "min" : 1,
        "max" : "3"
      },
      {
        "id" : "Patient.telecom:mobile",
        "path" : "Patient.telecom",
        "sliceName" : "mobile",
        "short" : "手機號碼。應為數字10碼(寄送核發簡訊使用)。手機號碼與聯絡電話應至少填寫一欄。",
        "min" : 0,
        "max" : "1",
        "constraint" : [
          {
            "key" : "telecom-mobile",
            "severity" : "error",
            "human" : "手機號碼格式有誤，應為數字10碼。",
            "expression" : "value.toString().length() = 10",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.telecom:mobile.system",
        "path" : "Patient.telecom.system",
        "patternCode" : "sms"
      },
      {
        "id" : "Patient.telecom:contactTel",
        "path" : "Patient.telecom",
        "sliceName" : "contactTel",
        "short" : "連絡電話。長度不得超過15字。手機號碼與聯絡電話應至少填寫一欄。",
        "min" : 0,
        "max" : "1",
        "constraint" : [
          {
            "key" : "telecom-contactTel",
            "severity" : "error",
            "human" : "連絡電話格式有誤，長度不得超過15字。",
            "expression" : "value.toString().length() <= 15",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.telecom:contactTel.system",
        "path" : "Patient.telecom.system",
        "patternCode" : "phone"
      },
      {
        "id" : "Patient.telecom:contactTel.value",
        "path" : "Patient.telecom.value",
        "constraint" : [
          {
            "key" : "txt-15",
            "severity" : "error",
            "human" : "長度不得超過15字",
            "expression" : "length() <= 15",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci"
          }
        ]
      },
      {
        "id" : "Patient.telecom:email",
        "path" : "Patient.telecom",
        "sliceName" : "email",
        "short" : "電子郵件信箱",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.telecom:email.system",
        "path" : "Patient.telecom.system",
        "patternCode" : "email"
      },
      {
        "id" : "Patient.telecom:email.value",
        "path" : "Patient.telecom.value",
        "constraint" : [
          {
            "key" : "txt-40",
            "severity" : "error",
            "human" : "長度不得超過40字",
            "expression" : "length() <= 40",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci"
          }
        ]
      },
      {
        "id" : "Patient.gender",
        "path" : "Patient.gender",
        "short" : "病人性別。male:男性 ｜ female:女性 ｜ other:其他 ｜ unknown:未知"
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "short" : "出生日期，YYYY-MM-DD，西元年月日。"
      },
      {
        "id" : "Patient.address",
        "path" : "Patient.address",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Patient.address.text",
        "path" : "Patient.address.text",
        "short" : "連絡住址",
        "min" : 1,
        "constraint" : [
          {
            "key" : "txt-80",
            "severity" : "error",
            "human" : "長度不得超過80字",
            "expression" : "length() <= 80",
            "source" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci"
          }
        ]
      },
      {
        "id" : "Patient.address.postalCode",
        "path" : "Patient.address.postalCode",
        "min" : 1
      },
      {
        "id" : "Patient.address.postalCode.extension",
        "path" : "Patient.address.postalCode.extension",
        "min" : 1
      },
      {
        "id" : "Patient.address.postalCode.extension:PostalCode",
        "path" : "Patient.address.postalCode.extension",
        "sliceName" : "PostalCode",
        "min" : 1
      },
      {
        "id" : "Patient.address.postalCode.extension:PostalCode.value[x].coding",
        "path" : "Patient.address.postalCode.extension.value[x].coding",
        "min" : 1
      },
      {
        "id" : "Patient.address.postalCode.extension:PostalCode.value[x].coding:PostalCode3",
        "path" : "Patient.address.postalCode.extension.value[x].coding",
        "sliceName" : "PostalCode3",
        "min" : 1
      },
      {
        "id" : "Patient.address.postalCode.extension:PostalCode.value[x].coding:PostalCode3.code",
        "path" : "Patient.address.postalCode.extension.value[x].coding.code",
        "short" : "郵遞區號"
      },
      {
        "id" : "Patient.address.postalCode.extension:PostalCode.value[x].coding:PostalCode5",
        "path" : "Patient.address.postalCode.extension.value[x].coding",
        "sliceName" : "PostalCode5",
        "max" : "0"
      },
      {
        "id" : "Patient.address.postalCode.extension:PostalCode.value[x].coding:PostalCode6",
        "path" : "Patient.address.postalCode.extension.value[x].coding",
        "sliceName" : "PostalCode6",
        "max" : "0"
      }
    ]
  }
}

```
