# 重大傷病申請證明-Bundle TWCI - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **重大傷病申請證明-Bundle TWCI**

## Resource Profile: 重大傷病申請證明-Bundle TWCI 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/ci/StructureDefinition/Bundle-twci | *Version*:1.0.2 |
| Active as of 2025-11-12 | *Computable Name*:BundleTWCI |

 
此重大傷病申請證明-Bundle TWCI Profile說明TWCI IG如何進一步定義臺灣核心-資料交換基本單位（TW Core Bundle） Profile以呈現重大傷病申請證明之內容 

**Usages:**

* Examples for this Profile: [Bundle/bun-min](Bundle-bun-min.md) and [Bundle/bun-noillness](Bundle-bun-noillness.md)
* CapabilityStatements using this Profile: [臺灣重大傷病-用戶端(TWCI Client)](CapabilityStatement-CapabilityStatementTWCIClient.md) and [臺灣重大傷病-伺服端(TWCI Server)](CapabilityStatement-CapabilityStatementTWCIServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.ci|current/StructureDefinition/Bundle-twci)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Bundle-twci.csv), [Excel](StructureDefinition-Bundle-twci.xlsx), [Schematron](StructureDefinition-Bundle-twci.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TWCI支援的RESTful互動功能的完整清單，請參閱[TWCI Server能力聲明](CapabilityStatement-CapabilityStatementTWCIServer.md)。

#### 必須支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`_id`](SearchParameter-Bundle-id.md)**查詢所有Bundle：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Bundle?_id=[id]`
`GET [base]/Bundle/[id]`例子：
(1) GET [base]/Bundle?_id=bun-1
(2) GET [base]/Bundle/bun-1



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Bundle-twci",
  "url" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Bundle-twci",
  "version" : "1.0.2",
  "name" : "BundleTWCI",
  "title" : "重大傷病申請證明-Bundle TWCI",
  "status" : "active",
  "date" : "2025-11-12T05:05:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此重大傷病申請證明-Bundle TWCI Profile說明TWCI IG如何進一步定義臺灣核心-資料交換基本單位（TW Core Bundle） Profile以呈現重大傷病申請證明之內容",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle"
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "patternCode" : "collection",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resource"
            }
          ],
          "rules" : "open"
        },
        "min" : 4,
        "max" : "4",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:task",
        "path" : "Bundle.entry",
        "sliceName" : "task",
        "short" : "重大傷病申請",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:task.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Task",
            "profile" : [
              "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Task-twci"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:questionnaireResponse",
        "path" : "Bundle.entry",
        "sliceName" : "questionnaireResponse",
        "short" : "重大傷病申請書回覆",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:questionnaireResponse.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "QuestionnaireResponse",
            "profile" : [
              "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:patient",
        "path" : "Bundle.entry",
        "sliceName" : "patient",
        "short" : "病人資訊",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:patient.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Patient",
            "profile" : [
              "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:condition",
        "path" : "Bundle.entry",
        "sliceName" : "condition",
        "short" : "重大傷病",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:condition.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Condition",
            "profile" : [
              "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Condition-twci"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
