# 申請(Apply)重大傷病申請書之資料模型 - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **申請(Apply)重大傷病申請書之資料模型**

## Logical Model: 申請(Apply)重大傷病申請書之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/ci/StructureDefinition/ApplyModel | *Version*:1.0.2 |
| Active as of 2025-11-12 | *Computable Name*:ApplyModel |

 
申請(Apply)重大傷病之資料模型，此邏輯模型為定義重大傷病情境下使用的所有資料欄位。 為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」 瞭解各資料欄位實際使用TWCI IG的哪個Profiles的哪個資料項目（element）。亦可配合 [視覺化邏輯模型圖]進行欄位對應。 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.ci|current/StructureDefinition/ApplyModel)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ApplyModel.csv), [Excel](StructureDefinition-ApplyModel.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ApplyModel",
  "url" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/ApplyModel",
  "version" : "1.0.2",
  "name" : "ApplyModel",
  "title" : "申請(Apply)重大傷病申請書之資料模型",
  "status" : "active",
  "date" : "2025-11-12T05:05:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "申請(Apply)重大傷病之資料模型，此邏輯模型為定義重大傷病情境下使用的所有資料欄位。\n為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」\n瞭解各資料欄位實際使用TWCI IG的哪個Profiles的哪個資料項目（element）。亦可配合\n[視覺化邏輯模型圖]進行欄位對應。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWCIQuestionnaireResponse",
      "uri" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci",
      "name" : "Mapping to TWCI QuestionnaireResponse"
    },
    {
      "identity" : "TWCIPatient",
      "uri" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci",
      "name" : "Mapping to TWCI Patient"
    },
    {
      "identity" : "TWCICondition",
      "uri" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Condition-twci",
      "name" : "Mapping to TWCI Condition"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/ApplyModel",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "ApplyModel",
        "path" : "ApplyModel",
        "short" : "申請(Apply)重大傷病申請書之資料模型",
        "definition" : "申請(Apply)重大傷病之資料模型，此邏輯模型為定義重大傷病情境下使用的所有資料欄位。\n為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」\n瞭解各資料欄位實際使用TWCI IG的哪個Profiles的哪個資料項目（element）。亦可配合\n[視覺化邏輯模型圖]進行欄位對應。"
      },
      {
        "id" : "ApplyModel.hosp",
        "path" : "ApplyModel.hosp",
        "short" : "院所資訊",
        "definition" : "院所資訊",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.hosp.applMode",
        "path" : "ApplyModel.hosp.applMode",
        "short" : "申報方式",
        "definition" : "申報方式",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '1').item.where(linkId = '1.1').answer.valueCoding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.hosp.applType",
        "path" : "ApplyModel.hosp.applType",
        "short" : "申報類別",
        "definition" : "申報類別",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '1').item.where(linkId = '1.2').answer.valueCoding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.hosp.applDate",
        "path" : "ApplyModel.hosp.applDate",
        "short" : "申請日期",
        "definition" : "申請日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '1').item.where(linkId = '1.3').answer.valueDate"
          }
        ]
      },
      {
        "id" : "ApplyModel.hosp.medCertBookDate",
        "path" : "ApplyModel.hosp.medCertBookDate",
        "short" : "開立診斷書申請日期",
        "definition" : "開立診斷書申請日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '1').item.where(linkId = '1.4').answer.valueDate"
          }
        ]
      },
      {
        "id" : "ApplyModel.hosp.hospId",
        "path" : "ApplyModel.hosp.hospId",
        "short" : "醫事機構代碼",
        "definition" : "醫事機構代碼，必須存在於醫事機構基本資料檔內",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '1').item.where(linkId = '1.5').answer.valueCoding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.hosp.acptNo",
        "path" : "ApplyModel.hosp.acptNo",
        "short" : "受理編號",
        "definition" : "受理編號",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '1').item.where(linkId = '1.6').answer.valueString"
          }
        ]
      },
      {
        "id" : "ApplyModel.hosp.acptNum",
        "path" : "ApplyModel.hosp.acptNum",
        "short" : "受理次數",
        "definition" : "受理次數",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '1').item.where(linkId = '1.7').answer.valueInteger"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient",
        "path" : "ApplyModel.patient",
        "short" : "病人資訊",
        "definition" : "病人資訊",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '2').answer.valueReference"
          },
          {
            "identity" : "TWCIPatient",
            "map" : "Patient"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient.idCard",
        "path" : "ApplyModel.patient.idCard",
        "short" : "身分證號",
        "definition" : "身分證號",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIPatient",
            "map" : "Patient.identifier.where(type.coding.code = 'NNxxx').value"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient.patID",
        "path" : "ApplyModel.patient.patID",
        "short" : "病歷號",
        "definition" : "病歷號",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIPatient",
            "map" : "Patient.identifier.where(type.coding.code = 'MR').value"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient.name",
        "path" : "ApplyModel.patient.name",
        "short" : "姓名",
        "definition" : "姓名",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIPatient",
            "map" : "Patient.name.where(use = 'usual').text"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient.gender",
        "path" : "ApplyModel.patient.gender",
        "short" : "病人性別",
        "definition" : "病人性別",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIPatient",
            "map" : "Patient.gender"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient.birthday",
        "path" : "ApplyModel.patient.birthday",
        "short" : "出生日期",
        "definition" : "出生日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIPatient",
            "map" : "Patient.birthDate"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient.zipCode",
        "path" : "ApplyModel.patient.zipCode",
        "short" : "郵遞區號",
        "definition" : "郵遞區號",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIPatient",
            "map" : "Patient.address.postalCode"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient.contactAddr",
        "path" : "ApplyModel.patient.contactAddr",
        "short" : "連絡住址",
        "definition" : "連絡住址",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIPatient",
            "map" : "Patient.address.text"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient.mobile",
        "path" : "ApplyModel.patient.mobile",
        "short" : "手機號碼",
        "definition" : "手機號碼。應為數字10碼(寄送核發簡訊使用)。手機號碼與聯絡電話應至少填寫一欄。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIPatient",
            "map" : "Patient.telecom.where(system = 'sms').value"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient.contactTel",
        "path" : "ApplyModel.patient.contactTel",
        "short" : "連絡電話",
        "definition" : "連絡電話。長度不得超過15字。手機號碼與聯絡電話應至少填寫一欄。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIPatient",
            "map" : "Patient.telecom.where(system = 'phone').value"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient.email",
        "path" : "ApplyModel.patient.email",
        "short" : "電子郵件信箱",
        "definition" : "電子郵件信箱",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIPatient",
            "map" : "Patient.telecom.where(system = 'email').value"
          }
        ]
      },
      {
        "id" : "ApplyModel.doctor",
        "path" : "ApplyModel.doctor",
        "short" : "醫師資訊",
        "definition" : "醫師資訊",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.doctor.diagPrsnId",
        "path" : "ApplyModel.doctor.diagPrsnId",
        "short" : "醫師身分證號",
        "definition" : "醫師身分證號",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '3').item.where(linkId = '3.1').answer.valueString"
          }
        ]
      },
      {
        "id" : "ApplyModel.doctor.diagPrsnName",
        "path" : "ApplyModel.doctor.diagPrsnName",
        "short" : "診斷醫師姓名",
        "definition" : "診斷醫師姓名",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '3').item.where(linkId = '3.2').answer.valueString"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis",
        "path" : "ApplyModel.diagnosis",
        "short" : "疾病資訊",
        "definition" : "疾病資訊",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.icd10cmCode",
        "path" : "ApplyModel.diagnosis.icd10cmCode",
        "short" : "主診斷代碼",
        "definition" : "主診斷代碼",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.1').answer.valueCoding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.examinationReport",
        "path" : "ApplyModel.diagnosis.examinationReport",
        "short" : "檢查報告",
        "definition" : "檢查報告",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.examinationReport.reportType",
        "path" : "ApplyModel.diagnosis.examinationReport.reportType",
        "short" : "報告類型",
        "definition" : "報告類型。當LOINC無法具體描述檢體種類（例如：`47526-9`時），請填寫及補充說明檢體種類。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.2').item.where(linkId = '4.2.1').answer.valueCoding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.examinationReport.speType",
        "path" : "ApplyModel.diagnosis.examinationReport.speType",
        "short" : "檢體種類",
        "definition" : "檢體種類",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.2').item.where(linkId = '4.2.2').answer.valueString"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.examinationReport.reportResultString",
        "path" : "ApplyModel.diagnosis.examinationReport.reportResultString",
        "short" : "檢查報告結果（文數字）",
        "definition" : "檢查報告結果-文數字與base64Binary應擇一填寫",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.2').item.where(linkId = '4.2.3').answer.valueString"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.examinationReport.reportResultPdf",
        "path" : "ApplyModel.diagnosis.examinationReport.reportResultPdf",
        "short" : "檢查報告結果（檔案路徑）",
        "definition" : "檢查報告結果-文數字與base64Binary應擇一填寫",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.2').item.where(linkId = '4.2.4').answer.valueString"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.examinationReport.reportResultPdfTitle",
        "path" : "ApplyModel.diagnosis.examinationReport.reportResultPdfTitle",
        "short" : "檢查報告名稱",
        "definition" : "檢查報告名稱",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.2').item.where(linkId = '4.2.5').answer.valueString"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.examinationReport.reportDate",
        "path" : "ApplyModel.diagnosis.examinationReport.reportDate",
        "short" : "報告日期",
        "definition" : "報告日期",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.2').item.where(linkId = '4.2.6').answer.valueDate"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.medrec",
        "path" : "ApplyModel.diagnosis.medrec",
        "short" : "病歷資料",
        "definition" : "病歷資料（非屬影像報告檢查驗報告部分）",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.medrec.medrec",
        "path" : "ApplyModel.diagnosis.medrec.medrec",
        "short" : "病歷資料（請填寫完整檔案路徑）",
        "definition" : "病歷資料（請填寫完整檔案路徑）",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.3').item.where(linkId = '4.3.1').answer.valueString"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.medrec.medrecTitle",
        "path" : "ApplyModel.diagnosis.medrec.medrecTitle",
        "short" : "病歷資料名稱",
        "definition" : "病歷資料名稱",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.3').item.where(linkId = '4.3.2').answer.valueString"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy",
        "path" : "ApplyModel.diagnosis.imageStudy",
        "short" : "影像報告",
        "definition" : "影像報告",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgItem",
        "path" : "ApplyModel.diagnosis.imageStudy.imgItem",
        "short" : "影像報告",
        "definition" : "影像報告",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.4').item.where(linkId = '4.4.1').answer.valueCoding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgResult",
        "path" : "ApplyModel.diagnosis.imageStudy.imgResult",
        "short" : "影像報告結果",
        "definition" : "影像報告結果",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.4').item.where(linkId = '4.4.2').answer.valueString"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgDate",
        "path" : "ApplyModel.diagnosis.imageStudy.imgDate",
        "short" : "影像報告日期",
        "definition" : "影像報告日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.4').item.where(linkId = '4.4.3').answer.valueDate"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgBodySite",
        "path" : "ApplyModel.diagnosis.imageStudy.imgBodySite",
        "short" : "影像檢查的身體部位",
        "definition" : "影像檢查的身體部位",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.4').item.where(linkId = '4.4.4').answer.valueCoding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgDicom",
        "path" : "ApplyModel.diagnosis.imageStudy.imgDicom",
        "short" : "DICOM影像",
        "definition" : "DICOM影像",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgDicom.studyUid",
        "path" : "ApplyModel.diagnosis.imageStudy.imgDicom.studyUid",
        "short" : "整項影像檢查的識別碼",
        "definition" : "D整項影像檢查的識別碼",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.4').item.where(linkId = '4.4.5').item.where(linkId = '4.4.5.1').answer.valueString"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgDicom.series",
        "path" : "ApplyModel.diagnosis.imageStudy.imgDicom.series",
        "short" : "每項影像檢查有一個或多個系列(series)的實例",
        "definition" : "每項影像檢查有一個或多個系列(series)的實例",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgDicom.series.uid",
        "path" : "ApplyModel.diagnosis.imageStudy.imgDicom.series.uid",
        "short" : "此系列的DICOM系列實例UID",
        "definition" : "此系列的DICOM系列實例UID",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.4').item.where(linkId = '4.4.5').item.where(linkId = '4.4.5.2').item.where(linkId = '4.4.5.2.1').answer.valueString"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgDicom.series.modality",
        "path" : "ApplyModel.diagnosis.imageStudy.imgDicom.series.modality",
        "short" : "此系列實例所使用的成像儀器",
        "definition" : "此系列實例所使用的成像儀器",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.4').item.where(linkId = '4.4.5').item.where(linkId = '4.4.5.2').item.where(linkId = '4.4.5.2.2').answer.valueCoding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgDicom.series.instance",
        "path" : "ApplyModel.diagnosis.imageStudy.imgDicom.series.instance",
        "short" : "系列中的一個SOP實例",
        "definition" : "系列中的一個SOP實例",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgDicom.series.instance.uid",
        "path" : "ApplyModel.diagnosis.imageStudy.imgDicom.series.instance.uid",
        "short" : "DICOM影像",
        "definition" : "DICOM影像",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.4').item.where(linkId = '4.4.5').item.where(linkId = '4.4.5.2').item.where(linkId = '4.4.5.2.3').item.where(linkId = '4.4.5.2.3.1').answer.valueString"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgDicom.series.instance.sopClass",
        "path" : "ApplyModel.diagnosis.imageStudy.imgDicom.series.instance.sopClass",
        "short" : "DICOM class 類型",
        "definition" : "DICOM class 類型",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.4').item.where(linkId = '4.4.5').item.where(linkId = '4.4.5.2').item.where(linkId = '4.4.5.2.3').item.where(linkId = '4.4.5.2.3.2').answer.valueCoding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgNonDicom",
        "path" : "ApplyModel.diagnosis.imageStudy.imgNonDicom",
        "short" : "非DICOM影像",
        "definition" : "非DICOM影像",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgNonDicom.imgNonDicom",
        "path" : "ApplyModel.diagnosis.imageStudy.imgNonDicom.imgNonDicom",
        "short" : "非DICOM影像（請填寫完整檔案路徑）",
        "definition" : "非DICOM影像（請填寫完整檔案路徑）",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.4').item.where(linkId = '4.4.6').item.where(linkId = '4.4.6.1').answer.valueString"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgNonDicom.imgNonDicomMimeType",
        "path" : "ApplyModel.diagnosis.imageStudy.imgNonDicom.imgNonDicomMimeType",
        "short" : "非DICOM影像MimeType",
        "definition" : "非DICOM影像MimeType",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '4').item.where(linkId = '4.4').item.where(linkId = '4.4.6').item.where(linkId = '4.4.6.2').answer.valueCoding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.ci",
        "path" : "ApplyModel.ci",
        "short" : "重大傷病",
        "definition" : "重大傷病",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '5').answer.valueReference"
          },
          {
            "identity" : "TWCICondition",
            "map" : "Condition"
          }
        ]
      },
      {
        "id" : "ApplyModel.ci.hvType",
        "path" : "ApplyModel.ci.hvType",
        "short" : "重大傷病類別",
        "definition" : "重大傷病類別",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCICondition",
            "map" : "Condition.category.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.cancerStage",
        "path" : "ApplyModel.cancerStage",
        "short" : "癌症期別",
        "definition" : "癌症期別",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.cancerStage.cancerStage",
        "path" : "ApplyModel.cancerStage.cancerStage",
        "short" : "癌症期別",
        "definition" : "癌症期別",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '6').item.where(linkId = '6.1').answer.valueCoding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.cancerStage.assessScore",
        "path" : "ApplyModel.cancerStage.assessScore",
        "short" : "癌症分期分數或結果",
        "definition" : "癌症分期分數或結果",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '6').item.where(linkId = '6.2').answer.valueString"
          }
        ]
      },
      {
        "id" : "ApplyModel.cancerStage.assessDate",
        "path" : "ApplyModel.cancerStage.assessDate",
        "short" : "癌症分期量表評估日期",
        "definition" : "癌症分期量表評估日期",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '6').item.where(linkId = '6.3').answer.valueDate"
          }
        ]
      },
      {
        "id" : "ApplyModel.illness",
        "path" : "ApplyModel.illness",
        "short" : "惡性腫瘤重大傷病換發評估表",
        "definition" : "惡性腫瘤重大傷病換發評估表",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.illness.code",
        "path" : "ApplyModel.illness.code",
        "short" : "原發癌症診斷碼",
        "definition" : "原發癌症診斷碼",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '7').item.where(linkId = '7.1').answer.valueCoding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.illness.date",
        "path" : "ApplyModel.illness.date",
        "short" : "癌症最初診斷日期",
        "definition" : "癌症最初診斷日期",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '7').item.where(linkId = '7.2').answer.valueDate"
          }
        ]
      },
      {
        "id" : "ApplyModel.illness.oriCancerAjcc",
        "path" : "ApplyModel.illness.oriCancerAjcc",
        "short" : "癌症最初診斷AJCC分期",
        "definition" : "癌症最初診斷AJCC分期",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '7').item.where(linkId = '7.3').answer.valueCoding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.illness.oriCancerAjcc1",
        "path" : "ApplyModel.illness.oriCancerAjcc1",
        "short" : "癌症最初診斷AJCC分期_補充說明欄位",
        "definition" : "癌症最初診斷AJCC分期_補充說明欄位",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '7').item.where(linkId = '7.4').answer.valueString"
          }
        ]
      },
      {
        "id" : "ApplyModel.illness.cancerStatus",
        "path" : "ApplyModel.illness.cancerStatus",
        "short" : "目前癌症狀態",
        "definition" : "目前癌症狀態",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '7').item.where(linkId = '7.5').answer.valueCoding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.illness.cancerTreatment",
        "path" : "ApplyModel.illness.cancerTreatment",
        "short" : "後續治療評估",
        "definition" : "後續治療評估",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '7').item.where(linkId = '7.6').answer.valueCoding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.illness.cancerTreatmentPlan",
        "path" : "ApplyModel.illness.cancerTreatmentPlan",
        "short" : "後續治療計畫",
        "definition" : "後續治療計畫",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '7').item.where(linkId = '7.7').answer.valueCoding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.illness.cancerTreatmentText",
        "path" : "ApplyModel.illness.cancerTreatmentText",
        "short" : "補充說明",
        "definition" : "補充欄位供申請院所自行補充說明",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCIQuestionnaireResponse",
            "map" : "QuestionnaireResponse.item.where(linkId = '7').item.where(linkId = '7.8').answer.valueString"
          }
        ]
      }
    ]
  }
}

```
