# Task-patient - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Task-patient**

## SearchParameter: Task-patient 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/ci/SearchParameter/Task-patient | *Version*:1.0.2 |
| Active as of 2025-11-07 | *Computable Name*:TaskPatient |

 
重大傷病申請(Task)的對象(patient) 

## TaskPatient

Parameter `period`:`reference`

重大傷病申請(Task)的對象(patient)

| | |
| :--- | :--- |
| Resource | [Task](http://hl7.org/fhir/R4/task.html) |
| Expression | `Task.for.where(resolve() is Patient)` |
| Multiples | * multipleAnd: It's up to the server whether the parameter may repeat in order to specify multiple values that must all be true
* multipleOr: It's up to the server whether the parameter can have multiple values (separated by comma) where at least one must be true
 |
| Chains | Allowed: name, identifier |



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "Task-patient",
  "url" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Task-patient",
  "version" : "1.0.2",
  "name" : "TaskPatient",
  "status" : "active",
  "date" : "2025-11-07",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "重大傷病申請(Task)的對象(patient)",
  "code" : "period",
  "base" : ["Task"],
  "type" : "reference",
  "expression" : "Task.for.where(resolve() is Patient)",
  "chain" : ["name", "identifier"]
}

```
