# 臺灣重大傷病-伺服端(TWCI Server) - 臺灣重大傷病實作指引 v1.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **臺灣重大傷病-伺服端(TWCI Server)**

## CapabilityStatement: 臺灣重大傷病-伺服端(TWCI Server) 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/ci/CapabilityStatement/CapabilityStatementTWCIServer | *Version*:1.0.2 |
| Active as of 2025-11-07 | *Computable Name*:CapabilityStatementTWCIServer |

 
臺灣健保重大傷病實作指引(TWCI IG)伺服端(Server)之能力聲明 

 [Raw OpenAPI-Swagger Definition file](CapabilityStatementTWCIServer.openapi.json) | [Download](CapabilityStatementTWCIServer.openapi.json) 

## 臺灣重大傷病-伺服端(TWCI Server)

* 實作指引版本：1.0.2
* FHIR版本：4.0.1
* 支援格式：`json`, `xml`
* 發佈日：2025-11-07
* 發佈者：衛生福利部中央健康保險署

### 必須（SHALL）支援以下實作指引

* [臺灣重大傷病實作指引 (TWCI IG)](index.md)

## Server的FHIR RESTful功能要求

### 模式：server

臺灣重大傷病-伺服端(TWCI Server)**必須(SHALL)**：
(1)可透過FHIR RESTful API查詢、新增及刪除Resources
(2)根據FHIR規範實作RESTful API
(3)HTTP回傳狀態碼
   ①(Status 2xx)：請求成功
   ②(Status 400)：無效參數（invalid parameter）
   ③(Status 401/4xx)：未經授權的請求（unauthorized request）
   ④(Status 403)：未充分授權的資料存取範圍（insufficient premission scope）
   ⑤(Status 404)：未知的resource（unknown resource）
(4)Server提供的API操作皆支援JSON格式
(5)可識別每個新增到Server的實例（instance）之meta.profile是否為TWCI Profiles Defining URL，並確認實例是否依循Profile製作。
【註：實例是指依據Profile實作，將真實資料以JSON、XML或Turtle格式存放的檔案】

臺灣重大傷病-伺服端(TWCI Server)**建議應該(SHOULD)**：
(1)Server提供的API操作皆支援XML格式

安全性：
(1)Server**必須(SHALL)**透過回傳 HTTP 401「未授權」， HTTP 403「禁止」，或 HTTP 404 「未找到」，來拒絕任何未經授權的請求。

### Resources或Profiles的RESTful功能

#### Summary

共有六類Resources支援查詢，查詢參數如表列：

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [Bundle](#Bundle1-1) | [重大傷病申請證明-Bundle TWCI](StructureDefinition-Bundle-twci.md) | y | y | y |  | y | _id |
| [Questionnaire](#Questionnaire1-2) | [重大傷病申請書-Questionnaire TWCI](StructureDefinition-Questionnaire-twci.md) | y | y | y |  | y |  |
| [QuestionnaireResponse](#QuestionnaireResponse1-3) | [重大傷病申請書回覆-QuestionnaireResponse TWCI](StructureDefinition-QuestionnaireResponse-twci.md) | y | y | y |  | y |  |
| [Task](#Task1-4) | [重大傷病申請-Task TWCI](StructureDefinition-Task-twci.md) | y | y | y |  | y | period, patient, authored-on, modified, identifier, status |
| [Patient](#Patient1-5) | [病人資訊-Patient TWCI](StructureDefinition-Patient-twci.md) | y | y | y |  | y | name, identifier |
| [Condition](#Condition1-6) | [重大傷病-Condition TWCI](StructureDefinition-Condition-twci.md) | y | y | y |  | y |  |

-------

#### 預期的遵從度： 必須（SHALL） Bundle

Profile

[重大傷病申請證明-Bundle TWCI](StructureDefinition-Bundle-twci.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **SHALL** 支援 `create`, `read`, `vread`, `update`.

Search Parameters


 

#### 預期的遵從度： 必須（SHALL） Questionnaire

Profile

[重大傷病申請書-Questionnaire TWCI](StructureDefinition-Questionnaire-twci.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **SHALL** 支援 `create`, `read`, `vread`, `update`.

#### 預期的遵從度： 必須（SHALL） QuestionnaireResponse

Profile

[重大傷病申請書回覆-QuestionnaireResponse TWCI](StructureDefinition-QuestionnaireResponse-twci.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **SHALL** 支援 `create`, `read`, `vread`, `update`.

#### 預期的遵從度： 必須（SHALL） Task

Profile

[重大傷病申請-Task TWCI](StructureDefinition-Task-twci.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **SHALL** 支援 `create`, `read`, `vread`, `update`.

Search Parameters


 

#### 預期的遵從度： 必須（SHALL） Patient

Profile

[病人資訊-Patient TWCI](StructureDefinition-Patient-twci.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **SHALL** 支援 `create`, `read`, `vread`, `update`.

Search Parameters


 

#### 預期的遵從度： 必須（SHALL） Condition

Profile

[重大傷病-Condition TWCI](StructureDefinition-Condition-twci.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **SHALL** 支援 `create`, `read`, `vread`, `update`.



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "CapabilityStatementTWCIServer",
  "url" : "https://nhicore.nhi.gov.tw/ci/CapabilityStatement/CapabilityStatementTWCIServer",
  "version" : "1.0.2",
  "name" : "CapabilityStatementTWCIServer",
  "title" : "臺灣重大傷病-伺服端(TWCI Server)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-07",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣健保重大傷病實作指引(TWCI IG)伺服端(Server)之能力聲明",
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["json", "xml"],
  "patchFormat" : ["application/json-patch+json"],
  "implementationGuide" : [
    "https://nhicore.nhi.gov.tw/ci/ImplementationGuide/tw.gov.mohw.nhi.ci"
  ],
  "rest" : [
    {
      "mode" : "server",
      "documentation" : "臺灣重大傷病-伺服端(TWCI Server)必須（SHALL）使用臺灣重大傷病伺服端（TWCI Server）能力聲明中的查詢參數，支援讀取和查詢一個或多個臺灣重大傷病Profile(s)。",
      "security" : {
        "service" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/restful-security-service",
                "code" : "SMART-on-FHIR"
              }
            ]
          }
        ],
        "description" : "Server必須(SHALL)透過回傳 HTTP 401「未授權」， HTTP 403「禁止」，或 HTTP 404 「未找到」，來拒絕任何未經授權的請求。"
      },
      "resource" : [
        {
          "type" : "Bundle",
          "profile" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Bundle-twci",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "_id",
              "definition" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Bundle-id",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Questionnaire",
          "profile" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Questionnaire-twci",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "QuestionnaireResponse",
          "profile" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/QuestionnaireResponse-twci",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "Task",
          "profile" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Task-twci",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "period",
              "definition" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Task-period",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient",
              "definition" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Task-patient",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "authored-on",
              "definition" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Task-authored-on",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "modified",
              "definition" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Task-modified",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "identifier",
              "definition" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Task-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "status",
              "definition" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Task-status",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Patient",
          "profile" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Patient-twci",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "name",
              "definition" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Patient-name",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "identifier",
              "definition" : "https://nhicore.nhi.gov.tw/ci/SearchParameter/Patient-identifier",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Condition",
          "profile" : "https://nhicore.nhi.gov.tw/ci/StructureDefinition/Condition-twci",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        }
      ]
    }
  ]
}

```
