# Artifacts Summary - 臺灣健保署基礎實作指引 v0.0.1

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [臺灣健保署基礎(Base)資料模型](StructureDefinition-BaseModel.md) | 臺灣健保署基礎(Base)資料模型，此邏輯模型為定義臺灣健保署基礎情境下使用的所有資料欄位。 為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」 瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目（element）。亦可配合 [視覺化邏輯模型圖]進行欄位對應。 |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [事前審查-Claim TWNHIBASE](StructureDefinition-Claim-twnhibase.md) | 此事前審查-Claim TWNHIBASE Profile說明本IG如何進一步定義FHIR的Claim Resource以呈現健保署基礎事前審查之內容 |
| [健保事前審查計畫-Coverage TWNHIBASE](StructureDefinition-Coverage-twnhibase.md) | 此健保事前審查計畫-Coverage TWNHIBASE Profile說明本IG如何進一步定義FHIR的Coverage Resource以呈現健保署基礎事前審查之健保事前審查計畫 |
| [基因檢測機構-Organization Gene TWNHIBASE](StructureDefinition-Organization-gene-twnhibase.md) | 此基因檢測機構-Organization Gene TWNHIBASE Profile說明本IG如何進一步定義臺灣核心-機構(TW Core Organization) Profile以呈現健保署基礎之基因檢測機構基本資料 |
| [基因檢測檢體-Specimen TWNHIBASE](StructureDefinition-Specimen-twnhibase.md) | 此基因檢測檢體-Specimen TWNHIBASE Profile說明本IG如何進一步定義臺灣核心-檢體(TW Core Specimen) Profile以呈現健保署基礎基因資訊之檢測檢體相關內容 |
| [基因資訊-Observation Diagnostic TWNHIBASE](StructureDefinition-Observation-diagnostic-twnhibase.md) | 此基因資訊-Observation Diagnostic TWNHIBASE Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現健保署基礎之基因資訊 |
| [文件參照-DocumentReference TWNHIBASE](StructureDefinition-DocumentReference-twnhibase.md) | 此文件參照-DocumentReference TWNHIBASE Profile說明本IG如何進一步定義臺灣核心-文件參照(TW Core DocumentReference) Profile以呈現健保署基礎之治療計畫文件及基因報告 |
| [病人資訊-Patient TWNHIBASE](StructureDefinition-Patient-twnhibase.md) | 此病人資訊-Patient TWNHIBASE Profile說明本IG如何進一步定義臺灣核心-病人(TW Core Patient) Profile以呈現健保署基礎之病人基本資料 |
| [醫事機構-Organization TWNHIBASE](StructureDefinition-Organization-twnhibase.md) | 此醫事機構-Organization TWNHIBASE Profile說明本IG如何進一步定義臺灣核心-機構(TW Core Organization) Profile以呈現健保署基礎之醫事機構基本資料 |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [LOINC-健保署-基因檢測代碼值集](ValueSet-gene-test-code.md) | LOINC-健保署-基因檢測代碼值集 |
| [LOINC-健保署-基因檢測檢體類型值集](ValueSet-specime-type.md) | LOINC-健保署-基因檢測檢體類型值集 |
| [LOINC-健保署-基因突變類型值集](ValueSet-dna-change-type.md) | LOINC-健保署-基因突變類型值集 |
| [NHI-健保署-文件類型值集](ValueSet-nhi-pdf-type.md) | NHI-健保署-文件類型值集 |
| [NHI-健保署-特約醫事機構值集](ValueSet-nhi-organization.md) | NHI-健保署-特約醫事機構值集，參照至[衛福部健保署特約醫事機構代碼網路查詢服務](https://www.nhi.gov.tw/ch/cp-5548-135e8-2931-1.html)中的[健保特約醫療院所名冊](https://info.nhi.gov.tw/IODE0000/IODE0000S09?id=1120)代碼出版日期：2024-04-22；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** |
| [NHI-健保署-申報類別值集](ValueSet-nhi-apply-type.md) | NHI-健保署-申報類別值集 |
| [NHI-健保署-申請案件類別值集](ValueSet-nhi-tmhb-type.md) | NHI-健保署-申請案件類別值集 |
| [NHI-健保署-補充資訊類別值集](ValueSet-nhi-supporting-info-type.md) | NHI-健保署-補充資訊類別值集 |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [INCa-健保署-基因突變類型](CodeSystem-inca-osiris.md) | INCa-健保署-基因突變類型，資料所屬單位：Institut National du Cancer (INCa)，參照至：https://github.com/InstitutNationalduCancer/OSIRIS。 |
| [NHI-健保署-文件類型](CodeSystem-nhi-pdf-type.md) | 臺灣衛生福利部中央健康保險署「文件類型」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保署-特約醫事機構](CodeSystem-organization-identifier-tw.md) | 臺灣衛生福利部中央健康保險署「特約醫事機構」代碼，參照至[衛福部健保署特約醫事機構代碼網路查詢服務](https://www.nhi.gov.tw/ch/cp-5548-135e8-2931-1.html)中的[健保特約醫療院所名冊](https://info.nhi.gov.tw/IODE0000/IODE0000S09?id=1120)代碼出版日期：2024-04-22；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** |
| [NHI-健保署-申報類別](CodeSystem-nhi-apply-type.md) | 臺灣衛生福利部中央健康保險署「申報類別」代碼，代碼出版日期：2025-10-21；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保署-申請案件類別](CodeSystem-nhi-tmhb-type.md) | 臺灣衛生福利部中央健康保險署「申請案件類別」代碼，代碼出版日期：2025-10-21；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保署-補充資訊類別](CodeSystem-nhi-supporting-info-type.md) | 臺灣衛生福利部中央健康保險署「補充資訊類別」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。 |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [事前審查-送核、套組檢驗、多事前審查癌藥品項](Claim-cla-1.md) | 依據事前審查-Claim TWNHIBASE Profile呈現健保署基礎事前審查之範例，含兩筆檢驗(查)。 |
| [健保事前審查計畫](Coverage-cov-min.md) | 依據健保事前審查計畫-Coverage TWNHIBASE Profile呈現健保署基礎事前審查計畫之範例 |
| [基因報告](DocumentReference-doc-gene-min.md) | 依據文件參照-DocumentReference TWNHIBASE Profile呈現基因報告之範例 |
| [基因檢測機構](Organization-org-gene-example.md) | 依據基因檢測機構-Organization Genetic Testing TWNHIBASE Profile呈現基因檢測機構之範例 |
| [基因檢測檢體](Specimen-spe-min.md) | 依據基因檢測檢體-Specimen TWNHIBASE Profile呈現基因檢測檢體之範例 |
| [基因資訊](Observation-obs-diagnostic-min.md) | 依據基因資訊-Observation Diagnostic TWNHIBASE Profile呈現基因資訊之範例 |
| [檢驗(查)附件](DocumentReference-doc-test-min.md) | 依據文件參照-DocumentReference TWNHIBASE Profile呈現檢驗(查)附件之範例 |
| [治療計畫文件](DocumentReference-doc-careplan-min.md) | 依據文件參照-DocumentReference TWNHIBASE Profile呈現治療計畫文件之範例 |
| [病人資訊](Patient-pat-min.md) | 依據病人資訊-Patient TWNHIBASE Profile呈現病人資訊之範例 |
| [病歷資料](DocumentReference-doc-medicalRecord-min.md) | 依據文件參照-DocumentReference TWNHIBASE Profile呈現病歷資料之範例 |
| [衛生福利部中央健康保險署](Organization-org-nhi.md) | 依據臺灣核心-政府機構（TW Core Organization Government）Profile呈現衛生福利部中央健康保險署 |
| [醫事機構](Organization-org-hosp-example.md) | 依據機構-Organization TWNHIBASE Profile呈現醫事機構之範例 |

