# NHI-健保署-申請案件類別值集 - 臺灣健保署基礎實作指引 v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NHI-健保署-申請案件類別值集**

## ValueSet: NHI-健保署-申請案件類別值集 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/base/ValueSet/nhi-tmhb-type | *Version*:0.0.1 |
| Draft as of 2025-10-21 | *Computable Name*:NHITMHBType |

 
NHI-健保署-申請案件類別值集 

 **References** 

* [事前審查-Claim TWNHIBASE](StructureDefinition-Claim-twnhibase.md)

### Logical Definition (CLD)

* Include all codes defined in [`https://nhicore.nhi.gov.tw/base/CodeSystem/nhi-tmhb-type`](CodeSystem-nhi-tmhb-type.md)version 📦0.0.1

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "nhi-tmhb-type",
  "url" : "https://nhicore.nhi.gov.tw/base/ValueSet/nhi-tmhb-type",
  "version" : "0.0.1",
  "name" : "NHITMHBType",
  "title" : "NHI-健保署-申請案件類別值集",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-21",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "NHI-健保署-申請案件類別值集",
  "compose" : {
    "include" : [
      {
        "system" : "https://nhicore.nhi.gov.tw/base/CodeSystem/nhi-tmhb-type"
      }
    ]
  }
}

```
