# NHI-健保署-文件類型值集 - 臺灣健保署基礎實作指引 v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NHI-健保署-文件類型值集**

## ValueSet: NHI-健保署-文件類型值集 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/base/ValueSet/nhi-pdf-type | *Version*:0.0.1 |
| Draft as of 2025-10-01 | *Computable Name*:NHIPDFType |

 
NHI-健保署-文件類型值集 

 **References** 

* [文件參照-DocumentReference TWNHIBASE](StructureDefinition-DocumentReference-twnhibase.md)

### Logical Definition (CLD)

* Include all codes defined in [`https://nhicore.nhi.gov.tw/base/CodeSystem/nhi-pdf-type`](CodeSystem-nhi-pdf-type.md)version 📦0.0.1

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "nhi-pdf-type",
  "url" : "https://nhicore.nhi.gov.tw/base/ValueSet/nhi-pdf-type",
  "version" : "0.0.1",
  "name" : "NHIPDFType",
  "title" : "NHI-健保署-文件類型值集",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-01",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "NHI-健保署-文件類型值集",
  "compose" : {
    "include" : [
      {
        "system" : "https://nhicore.nhi.gov.tw/base/CodeSystem/nhi-pdf-type"
      }
    ]
  }
}

```
