# 基因檢測檢體-Specimen TWNHIBASE - 臺灣健保署基礎實作指引 v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **基因檢測檢體-Specimen TWNHIBASE**

## Resource Profile: 基因檢測檢體-Specimen TWNHIBASE 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/base/StructureDefinition/Specimen-twnhibase | *Version*:0.0.1 |
| Draft as of 2025-10-29 | *Computable Name*:SpecimenTWNHIBASE |

 
此基因檢測檢體-Specimen TWNHIBASE Profile說明本IG如何進一步定義臺灣核心-檢體(TW Core Specimen) Profile以呈現健保署基礎基因資訊之檢測檢體相關內容 

**Usages:**

* Refer to this Profile: [基因資訊-Observation Diagnostic TWNHIBASE](StructureDefinition-Observation-diagnostic-twnhibase.md)
* Examples for this Profile: [Specimen/spe-min](Specimen-spe-min.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.base|current/StructureDefinition/Specimen-twnhibase)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Specimen-twnhibase.csv), [Excel](StructureDefinition-Specimen-twnhibase.xlsx), [Schematron](StructureDefinition-Specimen-twnhibase.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Specimen-twnhibase",
  "url" : "https://nhicore.nhi.gov.tw/base/StructureDefinition/Specimen-twnhibase",
  "version" : "0.0.1",
  "name" : "SpecimenTWNHIBASE",
  "title" : "基因檢測檢體-Specimen TWNHIBASE",
  "status" : "draft",
  "date" : "2025-10-29T03:09:05+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此基因檢測檢體-Specimen TWNHIBASE Profile說明本IG如何進一步定義臺灣核心-檢體(TW Core Specimen) Profile以呈現健保署基礎基因資訊之檢測檢體相關內容",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Specimen",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Specimen",
        "path" : "Specimen"
      },
      {
        "id" : "Specimen.meta",
        "path" : "Specimen.meta",
        "min" : 1
      },
      {
        "id" : "Specimen.meta.profile",
        "path" : "Specimen.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/base/StructureDefinition/Specimen-twnhibase"
      },
      {
        "id" : "Specimen.type",
        "path" : "Specimen.type",
        "short" : "基因檢測檢體類型",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/base/ValueSet/specime-type"
        }
      },
      {
        "id" : "Specimen.subject",
        "path" : "Specimen.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/base/StructureDefinition/Patient-twnhibase"
            ]
          }
        ]
      },
      {
        "id" : "Specimen.receivedTime",
        "path" : "Specimen.receivedTime",
        "short" : "基因檢測日期",
        "min" : 1,
        "mustSupport" : true
      }
    ]
  }
}

```
