# 事前審查-Claim TWNHIBASE - 臺灣健保署基礎實作指引 v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **事前審查-Claim TWNHIBASE**

## Resource Profile: 事前審查-Claim TWNHIBASE 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/base/StructureDefinition/Claim-twnhibase | *Version*:0.0.1 |
| Draft as of 2025-10-29 | *Computable Name*:ClaimTWNHIBASE |

 
此事前審查-Claim TWNHIBASE Profile說明本IG如何進一步定義FHIR的Claim Resource以呈現健保署基礎事前審查之內容 

**Usages:**

* Examples for this Profile: [Claim/cla-1](Claim-cla-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.base|current/StructureDefinition/Claim-twnhibase)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Claim-twnhibase.csv), [Excel](StructureDefinition-Claim-twnhibase.xlsx), [Schematron](StructureDefinition-Claim-twnhibase.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Claim-twnhibase",
  "url" : "https://nhicore.nhi.gov.tw/base/StructureDefinition/Claim-twnhibase",
  "version" : "0.0.1",
  "name" : "ClaimTWNHIBASE",
  "title" : "事前審查-Claim TWNHIBASE",
  "status" : "draft",
  "date" : "2025-10-29T03:09:05+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此事前審查-Claim TWNHIBASE Profile說明本IG如何進一步定義FHIR的Claim Resource以呈現健保署基礎事前審查之內容",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Claim",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Claim",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Claim",
        "path" : "Claim"
      },
      {
        "id" : "Claim.meta",
        "path" : "Claim.meta",
        "min" : 1
      },
      {
        "id" : "Claim.meta.profile",
        "path" : "Claim.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/base/StructureDefinition/Claim-twnhibase"
      },
      {
        "id" : "Claim.type",
        "path" : "Claim.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
              "code" : "institutional"
            }
          ]
        }
      },
      {
        "id" : "Claim.subType",
        "path" : "Claim.subType",
        "short" : "申報類別，1:送核 | 2:送核補件 | 3:申復 | 4:爭議審議 | 5:申復補件 。",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/base/ValueSet/nhi-apply-type"
        }
      },
      {
        "id" : "Claim.subType.coding",
        "path" : "Claim.subType.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Claim.subType.coding.system",
        "path" : "Claim.subType.coding.system",
        "min" : 1,
        "patternUri" : "https://nhicore.nhi.gov.tw/base/CodeSystem/nhi-apply-type"
      },
      {
        "id" : "Claim.subType.coding.code",
        "path" : "Claim.subType.coding.code",
        "short" : "申報類別，1:送核 | 2:送核補件 | 3:申復 | 4:爭議審議 | 5:申復補件 。",
        "min" : 1
      },
      {
        "id" : "Claim.use",
        "path" : "Claim.use",
        "patternCode" : "preauthorization"
      },
      {
        "id" : "Claim.patient",
        "path" : "Claim.patient",
        "short" : "病人資訊",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/base/StructureDefinition/Patient-twnhibase"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.created",
        "path" : "Claim.created",
        "short" : "申請日期，YYYY-MM-DD，機構自填。",
        "mustSupport" : true
      },
      {
        "id" : "Claim.provider",
        "path" : "Claim.provider",
        "short" : "醫事機構代碼，必須存在於醫事機構基本資料檔內。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/base/StructureDefinition/Organization-twnhibase"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.priority",
        "path" : "Claim.priority",
        "short" : "申請案件類別，1:一般事前審查申請 | 3:自主審查 | 4:緊急報備；專審系統識別用，對應PXXT_CODE(TMHB,001)。",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/base/ValueSet/nhi-tmhb-type"
        }
      },
      {
        "id" : "Claim.supportingInfo",
        "path" : "Claim.supportingInfo",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "category"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Claim.supportingInfo.category",
        "path" : "Claim.supportingInfo.category",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/base/ValueSet/nhi-supporting-info-type"
        }
      },
      {
        "id" : "Claim.supportingInfo:geneInfo",
        "path" : "Claim.supportingInfo",
        "sliceName" : "geneInfo",
        "short" : "基因資訊",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Claim.supportingInfo:geneInfo.category",
        "path" : "Claim.supportingInfo.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/base/CodeSystem/nhi-supporting-info-type",
              "code" : "geneInfo"
            }
          ]
        }
      },
      {
        "id" : "Claim.supportingInfo:geneInfo.timing[x]",
        "path" : "Claim.supportingInfo.timing[x]",
        "max" : "0"
      },
      {
        "id" : "Claim.supportingInfo:geneInfo.value[x]",
        "path" : "Claim.supportingInfo.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/base/StructureDefinition/Observation-diagnostic-twnhibase"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.diagnosis",
        "path" : "Claim.diagnosis",
        "short" : "sequence=1時為主要疾病；sequence>=2代表共病。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.diagnosis.extension",
        "path" : "Claim.diagnosis.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Claim.diagnosis.extension:recordedDate",
        "path" : "Claim.diagnosis.extension",
        "sliceName" : "recordedDate",
        "short" : "診斷日期，YYYY-MM-DD，西元年月日。【此為參考Da Vinci PAS IG的extension設計】",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pas/StructureDefinition/extension-diagnosisRecordedDate"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.diagnosis.sequence",
        "path" : "Claim.diagnosis.sequence",
        "short" : "sequence=1時為主要疾病；sequence>=2代表共病。"
      },
      {
        "id" : "Claim.diagnosis.diagnosis[x]",
        "path" : "Claim.diagnosis.diagnosis[x]",
        "short" : "國際疾病分類代碼(含共病)，當前疾病狀態。ICD-10-CM。",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/icd-10-cm-2023-tw"
        }
      },
      {
        "id" : "Claim.diagnosis.diagnosis[x].coding",
        "path" : "Claim.diagnosis.diagnosis[x].coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "closed"
        }
      },
      {
        "id" : "Claim.diagnosis.diagnosis[x].coding:icd10-cm-2023",
        "path" : "Claim.diagnosis.diagnosis[x].coding",
        "sliceName" : "icd10-cm-2023",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/icd-10-cm-2023-tw"
        }
      },
      {
        "id" : "Claim.diagnosis.diagnosis[x].coding:icd10-cm-2023.system",
        "path" : "Claim.diagnosis.diagnosis[x].coding.system",
        "min" : 1,
        "patternUri" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-cm-2023-tw",
        "mustSupport" : true
      },
      {
        "id" : "Claim.diagnosis.diagnosis[x].coding:icd10-cm-2023.code",
        "path" : "Claim.diagnosis.diagnosis[x].coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.diagnosis.diagnosis[x].coding:icd10-cm-2014",
        "path" : "Claim.diagnosis.diagnosis[x].coding",
        "sliceName" : "icd10-cm-2014",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/icd-10-cm-2014-tw"
        }
      },
      {
        "id" : "Claim.diagnosis.diagnosis[x].coding:icd10-cm-2014.system",
        "path" : "Claim.diagnosis.diagnosis[x].coding.system",
        "min" : 1,
        "patternUri" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-cm-2014-tw",
        "mustSupport" : true
      },
      {
        "id" : "Claim.diagnosis.diagnosis[x].coding:icd10-cm-2014.code",
        "path" : "Claim.diagnosis.diagnosis[x].coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.diagnosis.type",
        "path" : "Claim.diagnosis.type",
        "max" : "1"
      },
      {
        "id" : "Claim.diagnosis.type.text",
        "path" : "Claim.diagnosis.type.text",
        "short" : "簡要病摘(申請理由)。連結院內HIS系統之簡要病摘，或填寫原事前審查之申請理由。請勿將醫事機構名稱、病人及醫師姓名等資訊列入結果中上傳，且不得包含HTML或XML等語法。",
        "mustSupport" : true
      }
    ]
  }
}

```
