# 事前審查-送核、套組檢驗、多事前審查癌藥品項 - 臺灣健保署基礎實作指引 v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **事前審查-送核、套組檢驗、多事前審查癌藥品項**

## Example Claim: 事前審查-送核、套組檢驗、多事前審查癌藥品項

Profile: [事前審查-Claim TWNHIBASE](StructureDefinition-Claim-twnhibase.md)

**狀態**：Active

**類型**：Institutional([ClaimTypeCodes](http://terminology.hl7.org/CodeSystem/claim-type)#institutional)

**申報類別**：送核([NHI-申報類別值集](CodeSystem-nhi-apply-type.md)#1)

**目的**：Preauthorization

**病人**：[Patient/pat-min](Patient-pat-min.md) "王大明"

**申請日期**：2024-05-30

**醫事機構代碼**：[Organization/org-hosp-example](Organization-org-hosp-example.md)

**申請案件類別**：一般事前審查申請([NHI-申請案件類別值集](CodeSystem-nhi-tmhb-type.md)#1)

### Diagnoses

**診斷日期**：2024-01-01

**國際疾病分類代碼**：慢性右心臟衰竭([臺灣健保署2023年中文版ICD-10-CM值集](https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-cm-2023-tw)#I50.812)

**簡要病摘**：Adenocarcinoma, descending colon, cT3N2M1a, cStage IVA, KRAS G12V, with multiple liver metastases, status post FOLFIRI

> **supportingInfo****sequence**：1**category**：基因資訊**value**：[Observation/obs-diagnostic-min](Observation-obs-diagnostic-min.md)

### Insurances

**sequence**：1

**coverage**：[Coverage/cov-min](Coverage-cov-min.md)



## Resource Content

```json
{
  "resourceType" : "Claim",
  "id" : "cla-1",
  "meta" : {
    "profile" : [
      "https://nhicore.nhi.gov.tw/base/StructureDefinition/Claim-twnhibase"
    ]
  },
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
        "code" : "institutional"
      }
    ]
  },
  "subType" : {
    "coding" : [
      {
        "system" : "https://nhicore.nhi.gov.tw/base/CodeSystem/nhi-apply-type",
        "code" : "1",
        "display" : "送核"
      }
    ]
  },
  "use" : "preauthorization",
  "patient" : {
    "reference" : "Patient/pat-min"
  },
  "created" : "2024-05-30",
  "provider" : {
    "reference" : "Organization/org-hosp-example"
  },
  "priority" : {
    "coding" : [
      {
        "system" : "https://nhicore.nhi.gov.tw/base/CodeSystem/nhi-tmhb-type",
        "code" : "1",
        "display" : "一般事前審查申請"
      }
    ]
  },
  "supportingInfo" : [
    {
      "sequence" : 1,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/base/CodeSystem/nhi-supporting-info-type",
            "code" : "geneInfo"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Observation/obs-diagnostic-min"
      }
    }
  ],
  "diagnosis" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-pas/StructureDefinition/extension-diagnosisRecordedDate",
          "valueDate" : "2024-01-01"
        }
      ],
      "sequence" : 1,
      "diagnosisCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-cm-2023-tw",
            "code" : "I50.812"
          }
        ]
      },
      "type" : [
        {
          "text" : "Adenocarcinoma, descending colon, cT3N2M1a, cStage IVA, KRAS G12V, with multiple liver metastases, status post FOLFIRI"
        }
      ]
    }
  ],
  "insurance" : [
    {
      "sequence" : 1,
      "focal" : true,
      "coverage" : {
        "reference" : "Coverage/cov-min"
      }
    }
  ]
}

```
