# tw.gov.mohw.nhi.base#0.0.1: 臺灣健保署基礎實作指引

## Pages

* [應用說明](index.md)
* [邏輯模型](models.md)
* [結構定義與範例檔下載](downloads.md)
* [範例](examples.md)
* [Artifacts Summary](artifacts.md)
* [安全性](security.md)
* [查詢參數](searchparameters.md)
* [專門術語](terminologies.md)
* [FHIR Profiles及Extensions](profiles-and-extensions.md)
* [視覺化邏輯模型](vision.md)
* [能力聲明](capabilitystatements.md)
* [TW NHI BASE ImplementationGuide Resource](ImplementationGuide-tw.gov.mohw.nhi.base.md)

## Resources

### CodeSystems

* [INCa-健保署-基因突變類型](CodeSystem-inca-osiris.md)
* [NHI-健保署-申報類別](CodeSystem-nhi-apply-type.md)
* [NHI-健保署-文件類型](CodeSystem-nhi-pdf-type.md)
* [NHI-健保署-補充資訊類別](CodeSystem-nhi-supporting-info-type.md)
* [NHI-健保署-申請案件類別](CodeSystem-nhi-tmhb-type.md)
* [NHI-健保署-特約醫事機構](CodeSystem-organization-identifier-tw.md)

### ValueSets

* [LOINC-健保署-基因突變類型值集](ValueSet-dna-change-type.md)
* [LOINC-健保署-基因檢測代碼值集](ValueSet-gene-test-code.md)
* [NHI-健保署-申報類別值集](ValueSet-nhi-apply-type.md)
* [NHI-健保署-特約醫事機構值集](ValueSet-nhi-organization.md)
* [NHI-健保署-文件類型值集](ValueSet-nhi-pdf-type.md)
* [NHI-健保署-補充資訊類別值集](ValueSet-nhi-supporting-info-type.md)
* [NHI-健保署-申請案件類別值集](ValueSet-nhi-tmhb-type.md)
* [LOINC-健保署-基因檢測檢體類型值集](ValueSet-specime-type.md)

### Logicals

* [臺灣健保署基礎(Base)資料模型](StructureDefinition-BaseModel.md)

### Resource Profiles

* [事前審查-Claim TWNHIBASE](StructureDefinition-Claim-twnhibase.md)
* [健保事前審查計畫-Coverage TWNHIBASE](StructureDefinition-Coverage-twnhibase.md)
* [文件參照-DocumentReference TWNHIBASE](StructureDefinition-DocumentReference-twnhibase.md)
* [基因資訊-Observation Diagnostic TWNHIBASE](StructureDefinition-Observation-diagnostic-twnhibase.md)
* [基因檢測機構-Organization Gene TWNHIBASE](StructureDefinition-Organization-gene-twnhibase.md)
* [醫事機構-Organization TWNHIBASE](StructureDefinition-Organization-twnhibase.md)
* [病人資訊-Patient TWNHIBASE](StructureDefinition-Patient-twnhibase.md)
* [基因檢測檢體-Specimen TWNHIBASE](StructureDefinition-Specimen-twnhibase.md)

### ImplementationGuides

* [臺灣健保署基礎實作指引](index.md)

### Examples

* [cla-1 (Claim)](Claim-cla-1.md)
* [cov-min (Coverage)](Coverage-cov-min.md)
* [doc-careplan-min (DocumentReference)](DocumentReference-doc-careplan-min.md)
* [doc-gene-min (DocumentReference)](DocumentReference-doc-gene-min.md)
* [doc-medicalRecord-min (DocumentReference)](DocumentReference-doc-medicalRecord-min.md)
* [doc-test-min (DocumentReference)](DocumentReference-doc-test-min.md)
* [obs-diagnostic-min (Observation)](Observation-obs-diagnostic-min.md)
* [org-gene-example (Organization)](Organization-org-gene-example.md)
* [臺北市立聯合醫院 (Organization)](Organization-org-hosp-example.md)
* [衛生福利部中央健康保險署 (Organization)](Organization-org-nhi.md)
* [pat-min (Patient)](Patient-pat-min.md)
* [spe-min (Specimen)](Specimen-spe-min.md)
