# 應用說明 - 臺灣健保署基礎實作指引 v0.0.1

* [**Table of Contents**](toc.md)
* **應用說明**

## 應用說明

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/base/ImplementationGuide/tw.gov.mohw.nhi.base | *Version*:0.0.1 |
| Draft as of 2025-10-29 | *Computable Name*:TWNHIBASE |

### 專案介紹

臺灣健保署基礎實作指引(Taiwan NHI Base Implementation Guide，簡稱TWNHIBASE IG)採用HL7® FHIR® standard（Fast Healthcare Interoperability Resources）IG建置方法，在FHIR R4.0.1之標準基礎上，繼承TW Core IG V0.3.2 (2024-12-12)，進一步定義適用於「臺灣健保署基礎」資料需求的Resources（類似資料表）、其中的資料項目（意即欄位）、基數（意即0..1、0..*、1..1或1..*）及資料類型（文字、日期時間、代碼等）等。

### 專案背景

衛生福利部中央健康保險署。

### 如何閱讀這個實作指引(IG)

本IG之網站架構圖如下圖所示。各功能說明如下：

* **[應用說明](index.md)**：本IG介紹及背景說明。
* **[視覺化邏輯模型](vision.md)**：本IG邏輯模型架構視覺化圖。
* **[規範文件](artifacts.md)** 
* **[能力聲明](capabilitystatements.md)**：應用本IG於建置業務目的使用的FHIR Server時，該FHIR Server必須及建議應該支援的資料存取功能。 
* **[邏輯模型](models.md)**：本IG的所有邏輯模型(Logical Models)，邏輯模型會定義相應情境下使用的所有資料欄位。為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目(element)。 
* **[FHIR Profiles](profiles-and-extensions.md)**： 
* 本IG的所有Profiles之定義與範例。
* 各資料項目不同實作強制程度的Terminology。
 
* **[專門術語](terminologies.md)**：本IG所使用的專門術語，包括代碼系統（Code Systems）及值集（Value Sets）。 
 
* **[範例](examples.md)**：本IG所定義Profiles之範例檔。
* **[定義與範例檔下載](downloads.md)**：實作者若不偏好使用FHIR RESTful API驗證資料是否符合Profiles，可直接下載所需的格式驗證檔，包括XML、JSON及Turtle三種格式，亦可於此下載完整範例檔。
* **[安全性](security.md)**：主要說明採用本IG網站進行實作時，有關資料存取授權的作法。
* **[版本異動](https://nhicore.nhi.gov.tw/base/history.html)**：若本IG網站的版本有所異動，皆可透過[異動說明頁](https://nhicore.nhi.gov.tw/base/history.html)得以瞭解版本間的異動差異。

### 作者與貢獻者

| | | |
| :--- | :--- | :--- |
| 作者-IG | 李麗惠 | 國立臺北護理健康大學-健康事業管理系 |
| 作者-IG | 李奇安 | |
| 作者-IG | 曾鈺珈 | |
| 作者-IG | 林伃瑤 | |

