# 病人資訊-Patient TWNHIBASE - 臺灣健保署基礎實作指引 v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **病人資訊-Patient TWNHIBASE**

## Resource Profile: 病人資訊-Patient TWNHIBASE 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/base/StructureDefinition/Patient-twnhibase | *Version*:0.0.1 |
| Draft as of 2025-10-29 | *Computable Name*:PatientTWNHIBASE |

 
此病人資訊-Patient TWNHIBASE Profile說明本IG如何進一步定義臺灣核心-病人(TW Core Patient) Profile以呈現健保署基礎之病人基本資料 

**Usages:**

* Refer to this Profile: [事前審查-Claim TWNHIBASE](StructureDefinition-Claim-twnhibase.md), [健保事前審查計畫-Coverage TWNHIBASE](StructureDefinition-Coverage-twnhibase.md), [文件參照-DocumentReference TWNHIBASE](StructureDefinition-DocumentReference-twnhibase.md), [基因資訊-Observation Diagnostic TWNHIBASE](StructureDefinition-Observation-diagnostic-twnhibase.md) and [基因檢測檢體-Specimen TWNHIBASE](StructureDefinition-Specimen-twnhibase.md)
* Examples for this Profile: [Patient/pat-min](Patient-pat-min.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.base|current/StructureDefinition/Patient-twnhibase)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Patient-twnhibase.csv), [Excel](StructureDefinition-Patient-twnhibase.xlsx), [Schematron](StructureDefinition-Patient-twnhibase.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Patient-twnhibase",
  "url" : "https://nhicore.nhi.gov.tw/base/StructureDefinition/Patient-twnhibase",
  "version" : "0.0.1",
  "name" : "PatientTWNHIBASE",
  "title" : "病人資訊-Patient TWNHIBASE",
  "status" : "draft",
  "date" : "2025-10-29T03:09:05+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此病人資訊-Patient TWNHIBASE Profile說明本IG如何進一步定義臺灣核心-病人(TW Core Patient) Profile以呈現健保署基礎之病人基本資料",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "constraint" : [
          {
            "key" : "patient-gender-match",
            "severity" : "error",
            "human" : "gender依據identifier:idCardNumber第二位字符檢核男性與女性代碼 (1=male, 2=female)",
            "expression" : "(identifier.where(system = 'http://www.moi.gov.tw').value.substring(1, 1) = '1' implies gender = 'male') and (identifier.where(system = 'http://www.moi.gov.tw').value.substring(1, 1) = '2' implies gender = 'female')",
            "source" : "https://nhicore.nhi.gov.tw/base/StructureDefinition/Patient-twnhibase"
          }
        ]
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "max" : "2"
      },
      {
        "id" : "Patient.identifier:idCardNumber",
        "path" : "Patient.identifier",
        "sliceName" : "idCardNumber",
        "short" : "身分證號，被保險人國民身分證統一編號。",
        "min" : 1
      },
      {
        "id" : "Patient.identifier:medicalRecord",
        "path" : "Patient.identifier",
        "sliceName" : "medicalRecord",
        "short" : "病歷號 (參與醫院必須註冊命名系統)，由醫院自行填寫。"
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "min" : 1,
        "max" : "1",
        "constraint" : [
          {
            "key" : "pat-name",
            "severity" : "error",
            "human" : "病人姓名有誤，超過40字",
            "expression" : "text.length() <= 40",
            "source" : "https://nhicore.nhi.gov.tw/base/StructureDefinition/Patient-twnhibase"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:official",
        "path" : "Patient.name",
        "sliceName" : "official",
        "max" : "0"
      },
      {
        "id" : "Patient.name:usual",
        "path" : "Patient.name",
        "sliceName" : "usual",
        "min" : 1
      },
      {
        "id" : "Patient.name:usual.text",
        "path" : "Patient.name.text",
        "min" : 1
      },
      {
        "id" : "Patient.name:temp",
        "path" : "Patient.name",
        "sliceName" : "temp",
        "max" : "0"
      },
      {
        "id" : "Patient.name:anonymous",
        "path" : "Patient.name",
        "sliceName" : "anonymous",
        "max" : "0"
      },
      {
        "id" : "Patient.gender",
        "path" : "Patient.gender",
        "short" : "male:男性 ｜ female:女性 ｜ other:其他 ｜ unknown:未知"
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "short" : "出生日期，YYYY-MM-DD，西元年月日。"
      }
    ]
  }
}

```
