# 醫事機構-Organization TWNHIBASE - 臺灣健保署基礎實作指引 v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **醫事機構-Organization TWNHIBASE**

## Resource Profile: 醫事機構-Organization TWNHIBASE 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/base/StructureDefinition/Organization-twnhibase | *Version*:0.0.1 |
| Draft as of 2025-10-29 | *Computable Name*:OrganizationTWNHIBASE |

 
此醫事機構-Organization TWNHIBASE Profile說明本IG如何進一步定義臺灣核心-機構(TW Core Organization) Profile以呈現健保署基礎之醫事機構基本資料 

**Usages:**

* Refer to this Profile: [事前審查-Claim TWNHIBASE](StructureDefinition-Claim-twnhibase.md)
* Examples for this Profile: [臺北市立聯合醫院](Organization-org-hosp-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.base|current/StructureDefinition/Organization-twnhibase)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Organization-twnhibase.csv), [Excel](StructureDefinition-Organization-twnhibase.xlsx), [Schematron](StructureDefinition-Organization-twnhibase.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Organization-twnhibase",
  "url" : "https://nhicore.nhi.gov.tw/base/StructureDefinition/Organization-twnhibase",
  "version" : "0.0.1",
  "name" : "OrganizationTWNHIBASE",
  "title" : "醫事機構-Organization TWNHIBASE",
  "status" : "draft",
  "date" : "2025-10-29T03:09:05+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此醫事機構-Organization TWNHIBASE Profile說明本IG如何進一步定義臺灣核心-機構(TW Core Organization) Profile以呈現健保署基礎之醫事機構基本資料",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "short" : "醫事機構代碼",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier.system",
        "path" : "Organization.identifier.system",
        "min" : 1,
        "patternUri" : "https://nhicore.nhi.gov.tw/base/CodeSystem/organization-identifier-tw",
        "example" : [
          {
            "label" : "General",
            "valueUri" : "https://nhicore.nhi.gov.tw/base/CodeSystem/organization-identifier-tw"
          }
        ]
      },
      {
        "id" : "Organization.identifier.value",
        "path" : "Organization.identifier.value",
        "min" : 1,
        "example" : [
          {
            "label" : "General",
            "valueString" : "0101090517"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/base/ValueSet/nhi-organization"
        }
      }
    ]
  }
}

```
