# 文件參照-DocumentReference TWNHIBASE - 臺灣健保署基礎實作指引 v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **文件參照-DocumentReference TWNHIBASE**

## Resource Profile: 文件參照-DocumentReference TWNHIBASE 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/base/StructureDefinition/DocumentReference-twnhibase | *Version*:0.0.1 |
| Draft as of 2025-10-29 | *Computable Name*:DocumentReferenceTWNHIBASE |

 
此文件參照-DocumentReference TWNHIBASE Profile說明本IG如何進一步定義臺灣核心-文件參照(TW Core DocumentReference) Profile以呈現健保署基礎之治療計畫文件及基因報告 

**Usages:**

* Refer to this Profile: [基因資訊-Observation Diagnostic TWNHIBASE](StructureDefinition-Observation-diagnostic-twnhibase.md)
* Examples for this Profile: [DocumentReference/doc-careplan-min](DocumentReference-doc-careplan-min.md), [DocumentReference/doc-gene-min](DocumentReference-doc-gene-min.md), [DocumentReference/doc-medicalRecord-min](DocumentReference-doc-medicalRecord-min.md) and [DocumentReference/doc-test-min](DocumentReference-doc-test-min.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.base|current/StructureDefinition/DocumentReference-twnhibase)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-DocumentReference-twnhibase.csv), [Excel](StructureDefinition-DocumentReference-twnhibase.xlsx), [Schematron](StructureDefinition-DocumentReference-twnhibase.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "DocumentReference-twnhibase",
  "url" : "https://nhicore.nhi.gov.tw/base/StructureDefinition/DocumentReference-twnhibase",
  "version" : "0.0.1",
  "name" : "DocumentReferenceTWNHIBASE",
  "title" : "文件參照-DocumentReference TWNHIBASE",
  "status" : "draft",
  "date" : "2025-10-29T03:09:05+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此文件參照-DocumentReference TWNHIBASE Profile說明本IG如何進一步定義臺灣核心-文件參照(TW Core DocumentReference) Profile以呈現健保署基礎之治療計畫文件及基因報告",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "fhircomposition",
      "uri" : "http://hl7.org/fhir/composition",
      "name" : "FHIR Composition"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "xds",
      "uri" : "http://ihe.net/xds",
      "name" : "XDS metadata equivalent"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DocumentReference",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DocumentReference",
        "path" : "DocumentReference"
      },
      {
        "id" : "DocumentReference.meta",
        "path" : "DocumentReference.meta",
        "min" : 1
      },
      {
        "id" : "DocumentReference.meta.profile",
        "path" : "DocumentReference.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/base/StructureDefinition/DocumentReference-twnhibase"
      },
      {
        "id" : "DocumentReference.status",
        "path" : "DocumentReference.status",
        "patternCode" : "current"
      },
      {
        "id" : "DocumentReference.category",
        "path" : "DocumentReference.category",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/base/ValueSet/nhi-pdf-type"
        }
      },
      {
        "id" : "DocumentReference.category.coding",
        "path" : "DocumentReference.category.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "DocumentReference.category.coding.code",
        "path" : "DocumentReference.category.coding.code",
        "min" : 1
      },
      {
        "id" : "DocumentReference.subject",
        "path" : "DocumentReference.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/base/StructureDefinition/Patient-twnhibase"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.content.attachment",
        "path" : "DocumentReference.content.attachment",
        "constraint" : [
          {
            "key" : "UploadContent",
            "severity" : "error",
            "human" : "填寫格式：file://檔名.副檔名，例如：file://US01.jpg、file://PathologyReport01.pdf、file://GenReport01.pdf、file://王大明病歷.pdf",
            "expression" : "url.matches('^file://[a-zA-Z0-9_一-龥()（）－]+.[a-zA-Z]{2,5}$')",
            "source" : "https://nhicore.nhi.gov.tw/base/StructureDefinition/DocumentReference-twnhibase"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.attachment.contentType",
        "path" : "DocumentReference.content.attachment.contentType",
        "short" : "報告結果-MIMEType",
        "min" : 1,
        "patternCode" : "application/pdf",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.attachment.url",
        "path" : "DocumentReference.content.attachment.url",
        "short" : "基因報告／治療計畫文件／檢驗(查)附件／病歷資料。（請填寫完整檔案路徑）",
        "min" : 1,
        "example" : [
          {
            "label" : "General",
            "valueUrl" : "file://PathologyReport01.pdf"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.attachment.title",
        "path" : "DocumentReference.content.attachment.title",
        "short" : "基因報告名稱／治療計畫文件名稱／檢驗(查)附件名稱／病歷資料名稱。",
        "mustSupport" : true
      }
    ]
  }
}

```
