# 臺灣健保署基礎(Base)資料模型 - 臺灣健保署基礎實作指引 v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **臺灣健保署基礎(Base)資料模型**

## Logical Model: 臺灣健保署基礎(Base)資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/base/StructureDefinition/BaseModel | *Version*:0.0.1 |
| Draft as of 2025-10-29 | *Computable Name*:BaseModel |

 
臺灣健保署基礎(Base)資料模型，此邏輯模型為定義臺灣健保署基礎情境下使用的所有資料欄位。 為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」 瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目（element）。亦可配合 [視覺化邏輯模型圖]進行欄位對應。 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.base|current/StructureDefinition/BaseModel)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-BaseModel.csv), [Excel](StructureDefinition-BaseModel.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "BaseModel",
  "url" : "https://nhicore.nhi.gov.tw/base/StructureDefinition/BaseModel",
  "version" : "0.0.1",
  "name" : "BaseModel",
  "title" : "臺灣健保署基礎(Base)資料模型",
  "status" : "draft",
  "date" : "2025-10-29T03:09:05+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣健保署基礎(Base)資料模型，此邏輯模型為定義臺灣健保署基礎情境下使用的所有資料欄位。\n為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」\n瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目（element）。亦可配合\n[視覺化邏輯模型圖]進行欄位對應。",
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://nhicore.nhi.gov.tw/base/StructureDefinition/BaseModel",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "BaseModel",
        "path" : "BaseModel",
        "short" : "臺灣健保署基礎(Base)資料模型",
        "definition" : "臺灣健保署基礎(Base)資料模型，此邏輯模型為定義臺灣健保署基礎情境下使用的所有資料欄位。\n為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」\n瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目（element）。亦可配合\n[視覺化邏輯模型圖]進行欄位對應。"
      },
      {
        "id" : "BaseModel.hosp",
        "path" : "BaseModel.hosp",
        "short" : "院所資訊",
        "definition" : "院所資訊",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "BaseModel.hosp.hospId",
        "path" : "BaseModel.hosp.hospId",
        "short" : "醫事機構代碼",
        "definition" : "醫事機構代碼，必須存在於醫事機構基本資料檔內",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "BaseModel.hosp.applType",
        "path" : "BaseModel.hosp.applType",
        "short" : "申報類別",
        "definition" : "申報類別",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BaseModel.hosp.applDate",
        "path" : "BaseModel.hosp.applDate",
        "short" : "申請日期",
        "definition" : "申請日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "BaseModel.patient",
        "path" : "BaseModel.patient",
        "short" : "病人資訊",
        "definition" : "病人資訊",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "BaseModel.patient.patId",
        "path" : "BaseModel.patient.patId",
        "short" : "病歷號",
        "definition" : "病歷號 (參與醫院必須註冊命名系統)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "BaseModel.patient.name",
        "path" : "BaseModel.patient.name",
        "short" : "姓名",
        "definition" : "姓名",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "BaseModel.patient.idCard",
        "path" : "BaseModel.patient.idCard",
        "short" : "身分證號",
        "definition" : "身分證號",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "BaseModel.patient.birthday",
        "path" : "BaseModel.patient.birthday",
        "short" : "出生日期",
        "definition" : "出生日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "BaseModel.patient.gender",
        "path" : "BaseModel.patient.gender",
        "short" : "病人性別",
        "definition" : "病人性別",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "BaseModel.diagnosis",
        "path" : "BaseModel.diagnosis",
        "short" : "疾病資訊",
        "definition" : "疾病資訊",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "BaseModel.diagnosis.icd10cmCode",
        "path" : "BaseModel.diagnosis.icd10cmCode",
        "short" : "國際疾病分類代碼 (sequence=1)，共病症 (sequence>=2)",
        "definition" : "國際疾病分類代碼 (sequence=1)，共病症 (sequence>=2)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "BaseModel.diagnosis.diagDate",
        "path" : "BaseModel.diagnosis.diagDate",
        "short" : "診斷日期",
        "definition" : "YYYYMMDD，西元年月日，民國前為負數，sequence=1時為必填",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "BaseModel.diagnosis.diagCurrentStatus",
        "path" : "BaseModel.diagnosis.diagCurrentStatus",
        "short" : "簡要病摘。連結院內HIS系統之簡要病摘，或填寫原基因定序檢測之申請理由。",
        "definition" : "簡要病摘。連結院內HIS系統之簡要病摘，或填寫原基因定序檢測之申請理由。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "BaseModel.gene",
        "path" : "BaseModel.gene",
        "short" : "基因資訊",
        "definition" : "基因資訊",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "BaseModel.gene.genTestCode",
        "path" : "BaseModel.gene.genTestCode",
        "short" : "基因檢測代碼",
        "definition" : "基因檢測代碼",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BaseModel.gene.mutationType",
        "path" : "BaseModel.gene.mutationType",
        "short" : "基因突變類型",
        "definition" : "基因突變類型",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BaseModel.gene.specimenType",
        "path" : "BaseModel.gene.specimenType",
        "short" : "基因檢測檢體類型",
        "definition" : "基因檢測檢體類型",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BaseModel.gene.genMethod",
        "path" : "BaseModel.gene.genMethod",
        "short" : "基因檢測方法",
        "definition" : "基因檢測方法",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BaseModel.gene.genDate",
        "path" : "BaseModel.gene.genDate",
        "short" : "基因檢測日期",
        "definition" : "基因檢測日期",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "BaseModel.gene.genOrg",
        "path" : "BaseModel.gene.genOrg",
        "short" : "基因檢測機構",
        "definition" : "基因檢測機構",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "BaseModel.gene.genResult",
        "path" : "BaseModel.gene.genResult",
        "short" : "基因檢測分析結果",
        "definition" : "基因檢測分析結果",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BaseModel.gene.genInterpretation",
        "path" : "BaseModel.gene.genInterpretation",
        "short" : "基因臨床判讀結果",
        "definition" : "基因臨床判讀結果，醫師判讀結果",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BaseModel.gene.genPdf",
        "path" : "BaseModel.gene.genPdf",
        "short" : "基因報告（檔案路徑）",
        "definition" : "基因報告（請填寫完整檔案路徑）",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ]
      },
      {
        "id" : "BaseModel.gene.genPdfTitle",
        "path" : "BaseModel.gene.genPdfTitle",
        "short" : "基因報告名稱",
        "definition" : "基因報告名稱",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
