# Home - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/ImplementationGuide/ig-ee-medication-scheme | *Version*:1.0.0 |
| Draft as of 2025-12-09 | *Computable Name*:MedicationScheme |

> 

# NB!

**This is a development build and should be considered as “work in progress”. The content changes on a daily basis. This is not an official product release yet.****Juhendit täiendatakse igapäevaselt. Kõik liidestumiseks vajalik materjal pole veel juhendisse lisatud, tegu on MUSTANDIGA!**

This implementation guide describes the medication scheme maintained by Health and Welfare Information Systems Centre. Main content is provided in English, more detailed specifications and names of local value sets and code systems may occasionally be available only in Estonian.

Käesolev juhis kirjeldab ravimiskeemi, mida haldab Tervise ja Heaolu Infosüsteemide Keskus. Juhis on kirjutatud eesti ja inglise keeles, kusjuures eestikeelne tekst on kohati põhjalikum ja detailsem, olles suunatud kohalikule arendajale.

## About | Juhendist

* **In English**: The digital Medication Scheme offers both doctors and patients a comprehensive and up-to-date overview of the medications a patient is taking. The entire management of a patient's medication scheme is consolidated under the one service. In the future, important over-the-counter medications and dietary supplements can be included in the Medication Scheme.-------Implementation Guide contains:* Profiles, extensions, value sets and code systems used for medication scheme
* Guidance how to implement medication scheme
* Operations descriptions
* Logical models
* Usage guidance, including basic querying

  * **Eesti keeles**: Ravimiskeem pakub nii arstidele kui ka patsientidele terviklikku ja ajakohast ülevaadet patsiendi poolt tarvitatavatest ravimitest. Kogu patsiendi ravimiskeemi korraldus koondub Ravimiskeemi teenuse alla. Tulevikus saab ravimiskeemi lisada olulisi käsimüügiravimeid ja ka toidulisandeid.-------Juhend sisaldab:* Ravimiskeemi jaoks kasutatavad profiilid, laiendid, loendid ja koodiloendid
* Juhised ravimiskeemi juurutamiseks
* Operatsioonide kirjeldused
* Loogilised mudelid
* Kasutusjuhised, sh peamised päringud


### In scope:

* MedicationStatement
* MedicationRequest
* MedicationDispensation
* ClinicalUseDefinition
* List
* Task

### Out of scope:

* MedicationAdministration (will be part of hospital medication IG in near future)
* Coverage – reinbursement of patient’s medication is arranged from Estonian Health Insurance Fund side and not relevant in practitioner’s software view.

## Background

First phase of development is tightly connected with Estonian Medical Prescription Center so Medication Overview is a copy of legacy prescribing system gradually moving towards new generation health data exchange.

## Healthcare Specialist Portal | Tervisejuhtimise töölaud TJT

* **In English**: Tervisejuhtimise töölaud (Healthcare Specialist Portal) is a web-based tool designed for healthcare professionals and other specialists involved in patient care. It consolidates various e-services that support patient treatment. The tool provides a quick overview of an individual’s health data, allows for data updates, and facilitates collaboration among healthcare providers to create a comprehensive health plan for the person. All new generation health data system's e-services will be made available through the portal. Specialists can access relevant information legally available to them. This includes a unified medication history, essential health details, and the patient’s medical background. Additionally, the dashboard provides condition-specific views and references to private-sector digital solutions. Each specialist can tailor a personal dashboard to display the most relevant information for their work. This personalization ensures that critical data is readily accessible. Patients wishing to access the same information can use [Health Portal](https://www.terviseportaal.ee/en/). The Healthcare Specialist Portal was developed through collaboration between Tervisekassa, TEHIK, and analysis and development partners from Industry62, Net Group, and Nortal. It represents the next generation of health information system services. .-------Healthcare Specialist Portal:* Is intented for use by healthcare professionals and other specialists involved in providing healthcare services
* Serves as the initial access point for next-generation health information system services
* Ensures that refined services are available to be seamlessly integrated into healthcare institutions' information systems.

  * **Eesti keeles**: Tervisejuhtimise töölaud on veebipõhine tööriist kõigile tervishoiutöötajatele ja teistele raviprotsessi toetavatele spetsialistidele, mis koondab kokku erinevad patsiendikäsitlust toetavad e-teenused. Lahendus annab kiirelt ülevaate inimese terviseandmetest, võimaldab neid omakorda täiendada ning koostöös teiste tervishoiutöötajatega juhtide inimese terviseplaani. Töölaua kaudu saavad kättesaadavaks kõik uue põlvkonna terviseinfosüsteemi teenused. Töölaual näeb iga spetsialist kogu infot, milleks tal juriidiliselt õigus on, alates ühtsest ravimiskeemist, elulisest teabest ja terviseajaloost, lõpetades seisundipõhiste vaadete ja viidetega erasektori digilahendustele. Spetsialistidel on võimalik töölaua avakuva kohandada selliselt, et sealt tuleks välja just temale kõige olulisem info. Inimene ise aga pääseb samale infole ligi [Terviseportaali](https://www.terviseportaal.ee/) kaudu.-------Tervisejuhtimise töölaud:* On kasutamiseks tervishoiutöötajatele ja teistele spetsialistidele, kes tervishoiuteenuste pakkumisel osalevad
* On eelkõige koostööplatvorm, mis võimaldab oma tööd senisest kiiremini, mugavamalt, efektiivsemalt ja patsiendikesksemalt teha.
* Töölaud on esimene ligipääsupunkt uue põlvkonna terviseinfosüsteemi teenustele ning töölaua abil tagame ka raviasutuste infosüsteemidele juurutamiseks lihvitud teenused.


## Terminology

Code systems and value sets in this IG are examples. You will find the most up-to-date versions of them in TEHIK terminology server. Always query the terminology from there. [FHIR terminology services](https://build.fhir.org/ig/TEHIK-EE/TerminologyServices/) maintained by Health and Welfare Information Systems Centre IG contains more detailed information.

## References

This IG was initially a Simplifier project: https://simplifier.net/ee-tis



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "ig-ee-medication-scheme",
  "url" : "https://fhir.ee/ImplementationGuide/ig-ee-medication-scheme",
  "version" : "1.0.0",
  "name" : "MedicationScheme",
  "title" : "Medication Scheme Implementation Guide",
  "status" : "draft",
  "date" : "2025-12-09",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Implementation guide for medication scheme",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "packageId" : "ig-ee-medication-scheme",
  "license" : "MIT",
  "fhirVersion" : ["5.0.0"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r5",
      "version" : "7.0.1"
    },
    {
      "id" : "hl7_fhir_uv_extensions",
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions",
      "version" : "current"
    },
    {
      "id" : "ee_fhir_base",
      "uri" : "https://fhir.ee/base/ImplementationGuide/ee.fhir.base",
      "packageId" : "ee.fhir.base",
      "version" : "2.0.0"
    },
    {
      "id" : "ee_fhir_mpi",
      "uri" : "https://fhir.ee/mpi/ImplementationGuide/ee.fhir.mpi",
      "packageId" : "ee.fhir.mpi",
      "version" : "1.5.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r5#0.9.0"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/additional-information"
        },
        "name" : "additional information TEST-CS",
        "description" : "placeholder. USE text.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/additional-information"
        },
        "name" : "additional information TEST-VS",
        "description" : "placeholder. USE text.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/adrenalin"
        },
        "name" : "adrenalin",
        "description" : "Description of medication adrenaline",
        "isExample" : true,
        "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-medication-epc"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/adrenaline-renal-function"
        },
        "name" : "adrenaline-renal-function",
        "description" : "Description of medication adrenaline used as an input when validating medications affecting renal function",
        "isExample" : true,
        "profile" : [
          "https://fhir.ee/StructureDefinition/ee-tis-medication-renal-function"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/alprazolam"
        },
        "name" : "alprazolam",
        "description" : "Description of medication alprazoleme",
        "isExample" : true,
        "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-medication-epc"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/alprazolam-dispensed"
        },
        "name" : "alprazolam-dispensed",
        "description" : "Description of medication alprazoleme for dispensation to patient",
        "isExample" : true,
        "profile" : [
          "https://fhir.ee/StructureDefinition/ee-tis-medication-dispensed-to-patient"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/aspirin"
        },
        "name" : "aspirin",
        "description" : "Description of medication Aspirin",
        "isExample" : true,
        "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-medication-epc"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Communication"
          }
        ],
        "reference" : {
          "reference" : "Communication/Comment-changed"
        },
        "name" : "Comment-changed",
        "description" : "Comment about alprazolam where the comment has been changed",
        "isExample" : true,
        "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-communication"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Communication"
          }
        ],
        "reference" : {
          "reference" : "Communication/comment-renal-failure"
        },
        "name" : "comment-renal-failure",
        "description" : "Comment about alprazolam when the patient has renal failure",
        "isExample" : true,
        "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-communication"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Communication"
          }
        ],
        "reference" : {
          "reference" : "Communication/Comment1"
        },
        "name" : "Comment1",
        "description" : "Comment about alprazolam",
        "isExample" : true,
        "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-communication"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/D12345"
        },
        "name" : "D12345",
        "description" : "Practitioner, Doctor Mart Murakas",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/dexamethason"
        },
        "name" : "dexamethason",
        "description" : "Description of medication dexamethasone",
        "isExample" : true,
        "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-medication-epc"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/dispensation-alprazolam"
        },
        "name" : "dispensation-alprazolam",
        "description" : "Alprasolaami väljamüük teise soodustusega kui mida arst on retseptile pannud. Dispensation of alprazolam prescription with 0 reinbursement rate in pharmacy",
        "isExample" : true,
        "profile" : [
          "https://fhir.ee/StructureDefinition/ee-tis-prescription-dispense"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/dispensation-metformin"
        },
        "name" : "dispensation-metformin",
        "description" : "Metformiini väljamüük patsiendi esindajale. Dispensation of metformin prescription for other buyer",
        "isExample" : true,
        "profile" : [
          "https://fhir.ee/StructureDefinition/ee-tis-prescription-dispense"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/drug-form-group"
        },
        "name" : "drug form groub TEST-CS",
        "description" : "placeholder. USE text.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/drug-form-group"
        },
        "name" : "drug form groub TEST-VS",
        "description" : "placeholder. USE text.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-annotation"
        },
        "name" : "EETISAnnotation",
        "description" : "Kommentaar/märkus. Note or comment with time and author.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-communication"
        },
        "name" : "EETISCommunication",
        "description" : "Ravimiskeemi kommentaar. Comment about one treatment line in mediction list.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-dosage"
        },
        "name" : "EETISDosage",
        "description" : "Annustamisjuhis. Dosage is for exact representation of what quantity in which units and how often should medication be taken by patient.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-medication-dispensed-to-patient"
        },
        "name" : "EETISMedicationDispensedToPatient",
        "description" : "Väljamüüdud ravim. Medication resource as it is presented today in Estonian e-Prescription center (Retseptikeskus). Used on prescriptions and dispensations.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-medication-epc"
        },
        "name" : "EETISMedicationEPC",
        "description" : "Ravim. Medication resource as it is presented today in Estonian e-Prescription center (Retseptikeskus). Used on prescriptions NOT on dispensations.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-medication-extemporal"
        },
        "name" : "EETISMedicationExtemporal",
        "description" : "Ekstemporaalne ravim. Profile for representing medication that is prepared in pharmacy by pharmacist. E.g. sulfur ointment or solution of Protargoli.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-medication-interaction"
        },
        "name" : "EETISMedicationInteraction",
        "description" : "Ravimite omavahelised koostoimed. This profile is for the representation of the interactions between medication A and medication B in order to display warnings related to medications.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-medication-list"
        },
        "name" : "EETISMedicationList",
        "description" : "Ravimiskeem. This profile gathers patient's medications in one list for better overview of the whole medication scheme",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-medication-renal-function"
        },
        "name" : "EETISMedicationRenalFunction",
        "description" : "Ravim neerufunktsiooni päringu sisendis. Medication resource for input when validating renal function.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-medication-statement"
        },
        "name" : "EETISMedicationStatement",
        "description" : "Ravimiskeemi rida. One or more Medication Statements form patient's Medication Scheme.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-observation-egfr"
        },
        "name" : "EETISObservationEGFR",
        "description" : "eGFR analüüsi tulemus. Observation about eGFR",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-pharmacy-location"
        },
        "name" : "EETISPharmacyLocation",
        "description" : "Apteegi asukoht. This resource is used when there is a need to specify a certain pharmacy for medication dispensation.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-practitioner-role"
        },
        "name" : "EETISPractitionerRole",
        "description" : "Tervishoiutöötaja roll. Certified/licenced practitioner in a certain role in specified organization. E.g doctors working in different places may have different obligations/rights depending on the role they have in that organization.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-prescription"
        },
        "name" : "EETISPrescription",
        "description" : "Retsept. This is a profile for medication prescription.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-prescription-dispense"
        },
        "name" : "EETISPrescriptionDispense",
        "description" : "Ravimi väljastamine. When the medication prescribed is dispensed in pharmacy.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-reimbursement-task"
        },
        "name" : "EETISReimbursementTask",
        "description" : "Soodusmäära küsimine. Task is for the practitioner to ask reimbursement rates for prescription medicine. The MedicationStatement with its medication is sent to the Estonian Prescription Center and in return the practitoner recieves reimbursement rate (with additional explanation) for the medication.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-reimbursement-task-response-parameters"
        },
        "name" : "EETISReimbursementTaskResponseParameters",
        "description" : "This resource passes information back to EETISReimbursementTask output about the e-Prescription Centre's answer of allowed reimbursement rates. Also, information about insurance, EU insurance, pension and pension for incapacity for work are passed back.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-renal-failure-ds"
        },
        "name" : "EETISRenalFailureDS",
        "description" : "Neerufuntsiooni puudulikkuse otsustustoe vastus. This profile is for the representation of patient's renal function failure and alerts about it so the medication can be adjusted according to failure degree.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/extemporal"
        },
        "name" : "extemporal",
        "description" : "Extemporal medication example of sulfur ointment",
        "isExample" : true,
        "profile" : [
          "https://fhir.ee/StructureDefinition/ee-tis-medication-extemporal"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-additional-information-link"
        },
        "name" : "ExtensionEETISAdditionalInformationLink",
        "description" : "Link lisa-infole. Link which takes to another page including additional and more detailed information about the topic.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-affected-medication-statements"
        },
        "name" : "ExtensionEETISAffectedMedicationStatements",
        "description" : "Koostoimest mõjutatud ravimiskeemi rida.This extension is used in EETISMedicationInteraction profile to identify all medication statements which are related to interaction.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-buyer-epc"
        },
        "name" : "ExtensionEETISBuyerEPC",
        "description" : "Ostja. When someone other than the subject of prescription buys medication.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-cancelled-status-reason"
        },
        "name" : "ExtensionEETISCancelledStatusReason",
        "description" : "Annulleerimise põhjus. Extension for describing the reason of 'cancelled' status of prescription",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-consent-with-interactions"
        },
        "name" : "ExtensionEETISConsentWithInteractions",
        "description" : "Nõusolek koostoimetega. This extension is used in EETISMedicationList profile to express whether or not the practitioner adding medicines considered the interactions and consented with them.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-course-of-therapy-type"
        },
        "name" : "ExtensionEETISCourseOfTherapyType",
        "description" : "Ravikuuri tüüp. Defines whether the medication course is fixed or continuous etc.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-dispensation-authorization"
        },
        "name" : "ExtensionEETISDispensationAuthorization",
        "description" : "Volituse liik. Defines the authorization of the prescription.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-dosage-modification"
        },
        "name" : "ExtensionEETISDosageModification",
        "description" : "Annustamise soovitused. Recommendation for dosaging",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-grouped-items"
        },
        "name" : "ExtensionEETISGroupedItems",
        "description" : "Grupeerija. Used when there is a need to group several items that contain data about the same line of medication prescribed to the patient.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-lock-status"
        },
        "name" : "ExtensionEETISLockStatus",
        "description" : "Broneering retseptil. When pharmacy locks the prescription for ordering unauthorized medication for patient.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-medication-remainder"
        },
        "name" : "ExtensionEETISMedicationRemainder",
        "description" : "Jääk. Extension describing how many days worth medication is left on prescription.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-medicinal-product-classification"
        },
        "name" : "ExtensionEETISMedicinalProductClassification",
        "description" : "Klassifikatsioon. Classification of the product, e.g. ATC, narcotic/psychtropic or prescription/over-the-counter medication",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-medicinal-product-name"
        },
        "name" : "ExtensionEETISMedicinalProductName",
        "description" : "Ravimi nimi. Registered name for the medicinal product.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-nephrotoxic"
        },
        "name" : "ExtensionEETISNephrotoxic",
        "description" : "Asendamine lubatud. Reason for not allowing the substitution of medication.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-prescription-change"
        },
        "name" : "ExtensionEETISPrescriptionChange",
        "description" : "Retsepti muutmise aeg, muutja ja põhjus.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-prescription-intent"
        },
        "name" : "ExtensionEETISPrescriptionIntent",
        "description" : " Kas retsept on \"order\" või \"proposal\". Viimane on müügiloata ravimite puhul. Intent of prescription.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-prescription-validity-time"
        },
        "name" : "ExtensionEETISPrescriptionValidityTime",
        "description" : "Retsepti kehtivuse lõpu aeg ravimiskeemi rea kontekstis. Validity end date of a prescription in a MedicationStatement.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-reimbursement-rate"
        },
        "name" : "ExtensionEETISReimbursementRate",
        "description" : "Soodustuse määr ja tingimused (soodusravimite nimekirja järgi). For representation of the reimbursement rate and reason of prescription medicine. Speciality of prescriber if available and necessary",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-related-observation-or-condition"
        },
        "name" : "ExtensionEETISRelatedObservationOrCondition",
        "description" : "Seotud analüüs/test/uuring, mis on võib mõjutada neerufunktsiooni.This extension is used in to express renal function related observation/condition.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-renal-failure-warning"
        },
        "name" : "ExtensionEETISRenalFailureWarning",
        "description" : "Nõusolek neerufunktsiooni hoiatustega. This extension is used in EETISMedicationList profile to express whether or not the practitioner adding medicines considered renal function failure warnings and consented with them.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-size-of-item"
        },
        "name" : "ExtensionEETISSizeOfItem",
        "description" : "Pakkeühiku suurus. Size of medicinal product item (3ml).",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-substitution"
        },
        "name" : "ExtensionEETISSubstitution",
        "description" : "Asendamine lubatud. Reason for not allowing the substitution of medication.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-total-prescribed-amount"
        },
        "name" : "ExtensionEETISTotalPrescribedAmount",
        "description" : "Väljakirjutatud kogus. How much in total there is medication prescribed on one Medication Request.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-unauthorized-product-request"
        },
        "name" : "ExtensionEETISUnauthorizedProductRequest",
        "description" : "Müügiloata ravimi taotlus. Used for requesting marketing permit for unauthorized medication.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ee-tis-verification"
        },
        "name" : "ExtensionEETISVerification",
        "description" : "Kinnitamine. This extension is used for the verification of the MedicationStatement - when practitioner changes, adds or deletes anything in patient's medication scheme it must be verified with date and id of the practitioner.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/failure-degree"
        },
        "name" : "failure degree TEST-CS",
        "description" : "placeholder. USE text.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/failure-degree"
        },
        "name" : "failure degree TEST-VS",
        "description" : "placeholder. USE text.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/fenoksymetyylpenitsilliin"
        },
        "name" : "fenoksymetyylpenitsilliin",
        "description" : "Description of medication phenoxymethylpenicillin",
        "isExample" : true,
        "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-medication-epc"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/MedicationStatement-confirmed-medication-scheme"
        },
        "name" : "Find confirmed medication scheme",
        "description" : "The confirmed operation is used to get current confirmed medication scheme.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/Interactions"
        },
        "name" : "Find interactions for medications",
        "description" : "The interactions operation is used to get interactions for given Medications or MedicationPlan.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/Medication-renal-failure-warnings"
        },
        "name" : "Find renal failure warnings for medications",
        "description" : "The renal failure warnings operation is used to get renal warnings for given Medications or Medication Scheme.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/MedicationStatement-history"
        },
        "name" : "Get history of medication statements",
        "description" : "Returns the history of the current MedicationPlan(confirmed MedicationStatements) for requested patient",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/MedicationStatement-confirm"
        },
        "name" : "Medication Statement Confirm",
        "description" : "The $confirm operation manages a medication plan of a patient, i.e. creates a snapshot of effective medication statements as well as propagates medication requests.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/MedicationStatement-complex-dosaging"
        },
        "name" : "MedicationStatement-complex-dosaging",
        "description" : "Ravimiskeemi rida muutuva annustamisega. Schema line for metformin with complex dosaging",
        "isExample" : true,
        "profile" : [
          "https://fhir.ee/StructureDefinition/ee-tis-medication-statement"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/MedicationStatement-metformin"
        },
        "name" : "MedicationStatement-metformin",
        "description" : "Ravimiskeemi rida. Schema line for metformin",
        "isExample" : true,
        "profile" : [
          "https://fhir.ee/StructureDefinition/ee-tis-medication-statement"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/MedicationStatement-metformin-grouped-items"
        },
        "name" : "MedicationStatement-metformin-grouped-items",
        "description" : "Ravimiskeemi rida kus identifikaatorid on grupeeritud. Schema line for metformin where several identifiers are grouped together.",
        "isExample" : true,
        "profile" : [
          "https://fhir.ee/StructureDefinition/ee-tis-medication-statement"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/MedicationStatement-metformin-historyView"
        },
        "name" : "MedicationStatement-metformin-historyView",
        "description" : "Ravimiskeemi rida ajaloo vaates grupeerituna ravimvormi järgi. Schema line for metformin in TJT history view grouped by form",
        "isExample" : true,
        "profile" : [
          "https://fhir.ee/StructureDefinition/ee-tis-medication-statement"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/MedicationStatementAlprazolam"
        },
        "name" : "MedicationStatementAlprazolam",
        "description" : "Ravimiskeemi rida. Schema line for alprazolam",
        "isExample" : true,
        "profile" : [
          "https://fhir.ee/StructureDefinition/ee-tis-medication-statement"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/metformin"
        },
        "name" : "metformin",
        "description" : "Description of medication metformin",
        "isExample" : true,
        "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-medication-epc"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/metformin-dispensed"
        },
        "name" : "metformin-dispensed",
        "description" : "Description of medication metformin dispensed to patient",
        "isExample" : true,
        "profile" : [
          "https://fhir.ee/StructureDefinition/ee-tis-medication-dispensed-to-patient"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/N98765"
        },
        "name" : "N98765",
        "description" : "Practitioner, Nurse Õde Laura",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/novorapid"
        },
        "name" : "novorapid",
        "description" : "Description of medication aspart-insulin",
        "isExample" : true,
        "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-medication-epc"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/observation-egfr1"
        },
        "name" : "observation-egfr1",
        "description" : "Example of an eGFR observation",
        "isExample" : true,
        "profile" : [
          "https://fhir.ee/StructureDefinition/ee-tis-observation-egfr"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/parameters-response"
        },
        "name" : "parameters-response",
        "description" : "Soodustuse päringu vastus. Response for reimbursement parameters.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/pat1MatiMeri"
        },
        "name" : "pat1MatiMeri",
        "description" : "Patient Mati Meri",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/pharmacistKristiina"
        },
        "name" : "pharmacistKristiina",
        "description" : "Practitioner with Medre code P00197 in practitioner role pharmacist",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/PractRoleD12345"
        },
        "name" : "PractRoleD12345",
        "description" : "Practitioner D12345 in practitioner role doctor and with occupation pediaater",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/PractRoleN98765"
        },
        "name" : "PractRoleN98765",
        "description" : "Practitioner N98765 in practitioner role nurse and occupation õde",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/prescription-adrenalin-pos-dec"
        },
        "name" : "prescription-adrenalin-pos-dec",
        "description" : "Unauthorized medication adrenaline with positive decision for marketing request and permission to form prescription",
        "isExample" : true,
        "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-prescription"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/prescription-alprazolam"
        },
        "name" : "prescription-alprazolam",
        "description" : "Prescription of alprazolam with reimbursement rate 50%",
        "isExample" : true,
        "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-prescription"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/prescription-cancelled"
        },
        "name" : "prescription-cancelled",
        "description" : "Cancelled prescription of phenoxymethylpenicillin",
        "isExample" : true,
        "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-prescription"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/prescription-metformin"
        },
        "name" : "prescription-metformin",
        "description" : "Prescription of metformin with substitution NOT allowed and reason for that",
        "isExample" : true,
        "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-prescription"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "List"
          }
        ],
        "reference" : {
          "reference" : "List/listMatiMeri3"
        },
        "name" : "Ravimiskeem, kinnitatud D12345 poolt",
        "description" : "List of patient's medications verified by D12345",
        "isExample" : true,
        "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-medication-list"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ClinicalUseDefinition"
          }
        ],
        "reference" : {
          "reference" : "ClinicalUseDefinition/renal-function-failure"
        },
        "name" : "renal-function-failure",
        "description" : "Example of a alert when medication affects renal function and dosage must be corrected",
        "isExample" : true,
        "profile" : [
          "https://fhir.ee/StructureDefinition/ee-tis-renal-failure-ds"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/rh"
        },
        "name" : "rh",
        "description" : "Organization Rakvere Haigla",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/atc-ee"
        },
        "name" : "Siseriiklik ATC",
        "description" : "WHO ATC klassifikatsioon koos Eesti laiendkoodidega",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/atc-ee"
        },
        "name" : "Siseriiklik ATC",
        "description" : "WHO ATC klassifikatsioon koos Eesti laiendkoodidega",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/Task-reimbursements"
        },
        "name" : "Task reimbursements",
        "description" : "The reimbursement operation is used to get possible reimbursement for given Medication.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/tehiku-apteek"
        },
        "name" : "tehiku-apteek",
        "description" : "Location of pharmacy Tehiku apteek",
        "isExample" : true,
        "profile" : [
          "https://fhir.ee/StructureDefinition/ee-tis-pharmacy-location"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/TiamiinPyridoksiinTsyanokobalamiinLidokaiin"
        },
        "name" : "TiamiinPyridoksiinTsyanokobalamiinLidokaiin",
        "description" : "Description of medication Milgamma with four ingredient",
        "isExample" : true,
        "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-medication-epc"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/toimeained"
        },
        "name" : "Toimeained",
        "description" : "Ravimiameti nimekiri ravimite toimeainetest",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/toimeained"
        },
        "name" : "Toimeainete loend",
        "description" : "Ravimiameti nimekiri ravimite toimeainetest",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/MedicationStatement-validate-custom"
        },
        "name" : "Validate MedicationStatement business rules",
        "description" : "Builds on the default validate, by running MedIN specific business rules and RK checks",
        "isExample" : false
      }
    ],
    "page" : {
      "sourceUrl" : "toc.html",
      "name" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "sourceUrl" : "index.html",
          "name" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "guidance.html",
          "name" : "guidance.html",
          "title" : "Guidance",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "operations.html",
          "name" : "operations.html",
          "title" : "Operations",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "knownissues.html",
          "name" : "knownissues.html",
          "title" : "Known Issues",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "downloads.html",
          "name" : "downloads.html",
          "title" : "Downloads",
          "generation" : "html"
        },
        {
          "sourceUrl" : "controls.html",
          "name" : "controls.html",
          "title" : "Controls",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "checklist.html",
          "name" : "checklist.html",
          "title" : "Checklist for developers",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "usecases.html",
          "name" : "usecases.html",
          "title" : "Use cases",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "other.html",
          "name" : "other.html",
          "title" : "About",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "contacts.html",
          "name" : "contacts.html",
          "title" : "Contacts",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "changes.html",
          "name" : "changes.html",
          "title" : "Changes",
          "generation" : "html"
        },
        {
          "sourceUrl" : "documentation.html",
          "name" : "documentation.html",
          "title" : "Documentation",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "copyrightyear"
        },
        "value" : "2025+"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "releaselabel"
        },
        "value" : "trial-use"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "autoload-resources"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/capabilities"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/examples"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/extensions"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/models"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/operations"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/profiles"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/resources"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/vocabulary"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/maps"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/testing"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/history"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "fsh-generated/resources"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-pages"
        },
        "value" : "template/config"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-pages"
        },
        "value" : "input/images"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-liquid"
        },
        "value" : "template/liquid"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-liquid"
        },
        "value" : "input/liquid"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-qa"
        },
        "value" : "temp/qa"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-temp"
        },
        "value" : "temp/pages"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-output"
        },
        "value" : "output"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-tx-cache"
        },
        "value" : "input-cache/txcache"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-suppressed-warnings"
        },
        "value" : "input/ignoreWarnings.txt"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-history"
        },
        "value" : "https://fhir.ee/history.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "template-html"
        },
        "value" : "template-page.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "template-md"
        },
        "value" : "template-page-md.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-contact"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-context"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-copyright"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-jurisdiction"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-license"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-publisher"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-version"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-wg"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "active-tables"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "fmm-definition"
        },
        "value" : "http://hl7.org/fhir/versions.html#maturity"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "propagate-status"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "excludelogbinaryformat"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "tabbed-snapshots"
        },
        "value" : "true"
      }
    ]
  }
}

```
