# Artifacts Summary - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Operation Definitions 

These are custom operations that can be supported by and/or invoked by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Find confirmed medication scheme](OperationDefinition-MedicationStatement-confirmed-medication-scheme.md) | The confirmed operation is used to get current confirmed medication scheme. |
| [Find interactions for medications](OperationDefinition-Interactions.md) | The interactions operation is used to get interactions for given Medications or MedicationPlan. |
| [Find renal failure warnings for medications](OperationDefinition-Medication-renal-failure-warnings.md) | The renal failure warnings operation is used to get renal warnings for given Medications or Medication Scheme. |
| [Get history of medication statements](OperationDefinition-MedicationStatement-history.md) | Returns the history of the current MedicationPlan(confirmed MedicationStatements) for requested patient |
| [Medication Statement Confirm](OperationDefinition-MedicationStatement-confirm.md) | The $confirm operation manages a medication plan of a patient, i.e. creates a snapshot of effective medication statements as well as propagates medication requests. |
| [Task reimbursements](OperationDefinition-Task-reimbursements.md) | The reimbursement operation is used to get possible reimbursement for given Medication. |
| [Validate MedicationStatement business rules](OperationDefinition-MedicationStatement-validate-custom.md) | Builds on the default validate, by running MedIN specific business rules and RK checks |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [EETISCommunication](StructureDefinition-ee-tis-communication.md) | Ravimiskeemi kommentaar. Comment about one treatment line in mediction list. |
| [EETISMedicationDispensedToPatient](StructureDefinition-ee-tis-medication-dispensed-to-patient.md) | Väljamüüdud ravim. Medication resource as it is presented today in Estonian e-Prescription center (Retseptikeskus). Used on prescriptions and dispensations. |
| [EETISMedicationEPC](StructureDefinition-ee-tis-medication-epc.md) | Ravim. Medication resource as it is presented today in Estonian e-Prescription center (Retseptikeskus). Used on prescriptions NOT on dispensations. |
| [EETISMedicationExtemporal](StructureDefinition-ee-tis-medication-extemporal.md) | Ekstemporaalne ravim. Profile for representing medication that is prepared in pharmacy by pharmacist. E.g. sulfur ointment or solution of Protargoli. |
| [EETISMedicationInteraction](StructureDefinition-ee-tis-medication-interaction.md) | Ravimite omavahelised koostoimed. This profile is for the representation of the interactions between medication A and medication B in order to display warnings related to medications. |
| [EETISMedicationList](StructureDefinition-ee-tis-medication-list.md) | Ravimiskeem. This profile gathers patient's medications in one list for better overview of the whole medication scheme |
| [EETISMedicationRenalFunction](StructureDefinition-ee-tis-medication-renal-function.md) | Ravim neerufunktsiooni päringu sisendis. Medication resource for input when validating renal function. |
| [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md) | Ravimiskeemi rida. One or more Medication Statements form patient's Medication Scheme. |
| [EETISObservationEGFR](StructureDefinition-ee-tis-observation-egfr.md) | eGFR analüüsi tulemus. Observation about eGFR |
| [EETISPharmacyLocation](StructureDefinition-ee-tis-pharmacy-location.md) | Apteegi asukoht. This resource is used when there is a need to specify a certain pharmacy for medication dispensation. |
| [EETISPractitionerRole](StructureDefinition-ee-tis-practitioner-role.md) | Tervishoiutöötaja roll. Certified/licenced practitioner in a certain role in specified organization. E.g doctors working in different places may have different obligations/rights depending on the role they have in that organization. |
| [EETISPrescription](StructureDefinition-ee-tis-prescription.md) | Retsept. This is a profile for medication prescription. |
| [EETISPrescriptionDispense](StructureDefinition-ee-tis-prescription-dispense.md) | Ravimi väljastamine. When the medication prescribed is dispensed in pharmacy. |
| [EETISReimbursementTask](StructureDefinition-ee-tis-reimbursement-task.md) | Soodusmäära küsimine. Task is for the practitioner to ask reimbursement rates for prescription medicine. The MedicationStatement with its medication is sent to the Estonian Prescription Center and in return the practitoner recieves reimbursement rate (with additional explanation) for the medication. |
| [EETISReimbursementTaskResponseParameters](StructureDefinition-ee-tis-reimbursement-task-response-parameters.md) | This resource passes information back to EETISReimbursementTask output about the e-Prescription Centre's answer of allowed reimbursement rates. Also, information about insurance, EU insurance, pension and pension for incapacity for work are passed back. |
| [EETISRenalFailureDS](StructureDefinition-ee-tis-renal-failure-ds.md) | Neerufuntsiooni puudulikkuse otsustustoe vastus. This profile is for the representation of patient's renal function failure and alerts about it so the medication can be adjusted according to failure degree. |

### Structures: Data Type Profiles 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [EETISAnnotation](StructureDefinition-ee-tis-annotation.md) | Kommentaar/märkus. Note or comment with time and author. |
| [EETISDosage](StructureDefinition-ee-tis-dosage.md) | Annustamisjuhis. Dosage is for exact representation of what quantity in which units and how often should medication be taken by patient. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [ExtensionEETISAdditionalInformationLink](StructureDefinition-ee-tis-additional-information-link.md) | Link lisa-infole. Link which takes to another page including additional and more detailed information about the topic. |
| [ExtensionEETISAffectedMedicationStatements](StructureDefinition-ee-tis-affected-medication-statements.md) | Koostoimest mõjutatud ravimiskeemi rida.This extension is used in EETISMedicationInteraction profile to identify all medication statements which are related to interaction. |
| [ExtensionEETISBuyerEPC](StructureDefinition-ee-tis-buyer-epc.md) | Ostja. When someone other than the subject of prescription buys medication. |
| [ExtensionEETISCancelledStatusReason](StructureDefinition-ee-tis-cancelled-status-reason.md) | Annulleerimise põhjus. Extension for describing the reason of 'cancelled' status of prescription |
| [ExtensionEETISConsentWithInteractions](StructureDefinition-ee-tis-consent-with-interactions.md) | Nõusolek koostoimetega. This extension is used in EETISMedicationList profile to express whether or not the practitioner adding medicines considered the interactions and consented with them. |
| [ExtensionEETISCourseOfTherapyType](StructureDefinition-ee-tis-course-of-therapy-type.md) | Ravikuuri tüüp. Defines whether the medication course is fixed or continuous etc. |
| [ExtensionEETISDispensationAuthorization](StructureDefinition-ee-tis-dispensation-authorization.md) | Volituse liik. Defines the authorization of the prescription. |
| [ExtensionEETISDosageModification](StructureDefinition-ee-tis-dosage-modification.md) | Annustamise soovitused. Recommendation for dosaging |
| [ExtensionEETISGroupedItems](StructureDefinition-ee-tis-grouped-items.md) | Grupeerija. Used when there is a need to group several items that contain data about the same line of medication prescribed to the patient. |
| [ExtensionEETISLockStatus](StructureDefinition-ee-tis-lock-status.md) | Broneering retseptil. When pharmacy locks the prescription for ordering unauthorized medication for patient. |
| [ExtensionEETISMedicationRemainder](StructureDefinition-ee-tis-medication-remainder.md) | Jääk. Extension describing how many days worth medication is left on prescription. |
| [ExtensionEETISMedicinalProductClassification](StructureDefinition-ee-tis-medicinal-product-classification.md) | Klassifikatsioon. Classification of the product, e.g. ATC, narcotic/psychtropic or prescription/over-the-counter medication |
| [ExtensionEETISMedicinalProductName](StructureDefinition-ee-tis-medicinal-product-name.md) | Ravimi nimi. Registered name for the medicinal product. |
| [ExtensionEETISNephrotoxic](StructureDefinition-ee-tis-nephrotoxic.md) | Asendamine lubatud. Reason for not allowing the substitution of medication. |
| [ExtensionEETISPrescriptionChange](StructureDefinition-ee-tis-prescription-change.md) | Retsepti muutmise aeg, muutja ja põhjus. |
| [ExtensionEETISPrescriptionIntent](StructureDefinition-ee-tis-prescription-intent.md) | Kas retsept on "order" või "proposal". Viimane on müügiloata ravimite puhul. Intent of prescription. |
| [ExtensionEETISPrescriptionValidityTime](StructureDefinition-ee-tis-prescription-validity-time.md) | Retsepti kehtivuse lõpu aeg ravimiskeemi rea kontekstis. Validity end date of a prescription in a MedicationStatement. |
| [ExtensionEETISReimbursementRate](StructureDefinition-ee-tis-reimbursement-rate.md) | Soodustuse määr ja tingimused (soodusravimite nimekirja järgi). For representation of the reimbursement rate and reason of prescription medicine. Speciality of prescriber if available and necessary |
| [ExtensionEETISRelatedObservationOrCondition](StructureDefinition-ee-tis-related-observation-or-condition.md) | Seotud analüüs/test/uuring, mis on võib mõjutada neerufunktsiooni.This extension is used in to express renal function related observation/condition. |
| [ExtensionEETISRenalFailureWarning](StructureDefinition-ee-tis-renal-failure-warning.md) | Nõusolek neerufunktsiooni hoiatustega. This extension is used in EETISMedicationList profile to express whether or not the practitioner adding medicines considered renal function failure warnings and consented with them. |
| [ExtensionEETISSizeOfItem](StructureDefinition-ee-tis-size-of-item.md) | Pakkeühiku suurus. Size of medicinal product item (3ml). |
| [ExtensionEETISSubstitution](StructureDefinition-ee-tis-substitution.md) | Asendamine lubatud. Reason for not allowing the substitution of medication. |
| [ExtensionEETISTotalPrescribedAmount](StructureDefinition-ee-tis-total-prescribed-amount.md) | Väljakirjutatud kogus. How much in total there is medication prescribed on one Medication Request. |
| [ExtensionEETISUnauthorizedProductRequest](StructureDefinition-ee-tis-unauthorized-product-request.md) | Müügiloata ravimi taotlus. Used for requesting marketing permit for unauthorized medication. |
| [ExtensionEETISVerification](StructureDefinition-ee-tis-verification.md) | Kinnitamine. This extension is used for the verification of the MedicationStatement - when practitioner changes, adds or deletes anything in patient's medication scheme it must be verified with date and id of the practitioner. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Siseriiklik ATC](ValueSet-atc-ee.md) | WHO ATC klassifikatsioon koos Eesti laiendkoodidega |
| [Toimeainete loend](ValueSet-toimeained.md) | Ravimiameti nimekiri ravimite toimeainetest |
| [additional information TEST-VS](ValueSet-additional-information.md) | placeholder. USE text. |
| [drug form groub TEST-VS](ValueSet-drug-form-group.md) | placeholder. USE text. |
| [failure degree TEST-VS](ValueSet-failure-degree.md) | placeholder. USE text. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Siseriiklik ATC](CodeSystem-atc-ee.md) | WHO ATC klassifikatsioon koos Eesti laiendkoodidega |
| [Toimeained](CodeSystem-toimeained.md) | Ravimiameti nimekiri ravimite toimeainetest |
| [additional information TEST-CS](CodeSystem-additional-information.md) | placeholder. USE text. |
| [drug form groub TEST-CS](CodeSystem-drug-form-group.md) | placeholder. USE text. |
| [failure degree TEST-CS](CodeSystem-failure-degree.md) | placeholder. USE text. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Comment-changed](Communication-Comment-changed.md) | Comment about alprazolam where the comment has been changed |
| [Comment1](Communication-Comment1.md) | Comment about alprazolam |
| [D12345](Practitioner-D12345.md) | Practitioner, Doctor Mart Murakas |
| [MedicationStatement-complex-dosaging](MedicationStatement-MedicationStatement-complex-dosaging.md) | Ravimiskeemi rida muutuva annustamisega. Schema line for metformin with complex dosaging |
| [MedicationStatement-metformin](MedicationStatement-MedicationStatement-metformin.md) | Ravimiskeemi rida. Schema line for metformin |
| [MedicationStatement-metformin-grouped-items](MedicationStatement-MedicationStatement-metformin-grouped-items.md) | Ravimiskeemi rida kus identifikaatorid on grupeeritud. Schema line for metformin where several identifiers are grouped together. |
| [MedicationStatement-metformin-historyView](MedicationStatement-MedicationStatement-metformin-historyView.md) | Ravimiskeemi rida ajaloo vaates grupeerituna ravimvormi järgi. Schema line for metformin in TJT history view grouped by form |
| [MedicationStatementAlprazolam](MedicationStatement-MedicationStatementAlprazolam.md) | Ravimiskeemi rida. Schema line for alprazolam |
| [N98765](Practitioner-N98765.md) | Practitioner, Nurse Õde Laura |
| [PractRoleD12345](PractitionerRole-PractRoleD12345.md) | Practitioner D12345 in practitioner role doctor and with occupation pediaater |
| [PractRoleN98765](PractitionerRole-PractRoleN98765.md) | Practitioner N98765 in practitioner role nurse and occupation õde |
| [Ravimiskeem, kinnitatud D12345 poolt](List-listMatiMeri3.md) | List of patient's medications verified by D12345 |
| [TiamiinPyridoksiinTsyanokobalamiinLidokaiin](Medication-TiamiinPyridoksiinTsyanokobalamiinLidokaiin.md) | Description of medication Milgamma with four ingredient |
| [adrenalin](Medication-adrenalin.md) | Description of medication adrenaline |
| [adrenaline-renal-function](Medication-adrenaline-renal-function.md) | Description of medication adrenaline used as an input when validating medications affecting renal function |
| [alprazolam](Medication-alprazolam.md) | Description of medication alprazoleme |
| [alprazolam-dispensed](Medication-alprazolam-dispensed.md) | Description of medication alprazoleme for dispensation to patient |
| [aspirin](Medication-aspirin.md) | Description of medication Aspirin |
| [comment-renal-failure](Communication-comment-renal-failure.md) | Comment about alprazolam when the patient has renal failure |
| [dexamethason](Medication-dexamethason.md) | Description of medication dexamethasone |
| [dispensation-alprazolam](MedicationDispense-dispensation-alprazolam.md) | Alprasolaami väljamüük teise soodustusega kui mida arst on retseptile pannud. Dispensation of alprazolam prescription with 0 reinbursement rate in pharmacy |
| [dispensation-metformin](MedicationDispense-dispensation-metformin.md) | Metformiini väljamüük patsiendi esindajale. Dispensation of metformin prescription for other buyer |
| [extemporal](Medication-extemporal.md) | Extemporal medication example of sulfur ointment |
| [fenoksymetyylpenitsilliin](Medication-fenoksymetyylpenitsilliin.md) | Description of medication phenoxymethylpenicillin |
| [metformin](Medication-metformin.md) | Description of medication metformin |
| [metformin-dispensed](Medication-metformin-dispensed.md) | Description of medication metformin dispensed to patient |
| [novorapid](Medication-novorapid.md) | Description of medication aspart-insulin |
| [observation-egfr1](Observation-observation-egfr1.md) | Example of an eGFR observation |
| [parameters-response](Parameters-parameters-response.md) | Soodustuse päringu vastus. Response for reimbursement parameters. |
| [pat1MatiMeri](Patient-pat1MatiMeri.md) | Patient Mati Meri |
| [pharmacistKristiina](PractitionerRole-pharmacistKristiina.md) | Practitioner with Medre code P00197 in practitioner role pharmacist |
| [prescription-adrenalin-pos-dec](MedicationRequest-prescription-adrenalin-pos-dec.md) | Unauthorized medication adrenaline with positive decision for marketing request and permission to form prescription |
| [prescription-alprazolam](MedicationRequest-prescription-alprazolam.md) | Prescription of alprazolam with reimbursement rate 50% |
| [prescription-cancelled](MedicationRequest-prescription-cancelled.md) | Cancelled prescription of phenoxymethylpenicillin |
| [prescription-metformin](MedicationRequest-prescription-metformin.md) | Prescription of metformin with substitution NOT allowed and reason for that |
| [renal-function-failure](ClinicalUseDefinition-renal-function-failure.md) | Example of a alert when medication affects renal function and dosage must be corrected |
| [rh](Organization-rh.md) | Organization Rakvere Haigla |
| [tehiku-apteek](Location-tehiku-apteek.md) | Location of pharmacy Tehiku apteek |

