# Toimeainete loend - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Toimeainete loend**

## ValueSet: Toimeainete loend 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/ValueSet/toimeained | *Version*:1.0.0 |
| Draft as of 2025-12-29 | *Computable Name*:Toimeained_VS |

 
Ravimiameti nimekiri ravimite toimeainetest 

 **References** 

* [EETISMedicationEPC](StructureDefinition-ee-tis-medication-epc.md)
* [EETISMedicationRenalFunction](StructureDefinition-ee-tis-medication-renal-function.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "toimeained",
  "url" : "https://fhir.ee/ValueSet/toimeained",
  "version" : "1.0.0",
  "name" : "Toimeained_VS",
  "title" : "Toimeainete loend",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-29T12:57:39+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Ravimiameti nimekiri ravimite toimeainetest",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://fhir.ee/CodeSystem/toimeained"
      }
    ]
  }
}

```
